<?php

/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');


class Spec_holiday2ModelApp_api extends JModelList {

    /**
     * Constructor
     *
     * @param    array          An optional associative array of configuration settings
     *
     * @see      JController
     * @since    1.6
     */
    public function __construct($config = array()) 
    {
      
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        parent::__construct($config);
    }

    private function convertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('d.m.Y', $from);
        $from_date = $from_date_raw->format('Y-m-d 00:00:00');
       

        $to_date_raw = DateTime::createFromFormat('d.m.Y', $to);
        $to_date = $to_date_raw->format('Y-m-d 00:00:00');
        
        return [
            'from'=>$from_date,
            'to'=>$to_date
        ];
    }
    
    private function checkPeriod($dates, $user_id)
    {
        $from=$dates['from'];
        $to=$dates['to'];
        
        $query = "SELECT COUNT(*) AS 'count' FROM reservations WHERE NOT ((end <= '$from') OR (start >= '$to')) AND room_id = '$user_id'";
        $this->db->setQuery($query);
        $reservations = $this->db->loadObject();
        
        return $reservations->count;
    }
    
    public function setHolidayApi($user_id, $from, $to)
    {
        $dates_arr=$this->convertDates($from, $to);
        $check_period=$this->checkPeriod($dates_arr, $user_id);
        
        if($check_period==0){
            $start=$dates_arr['from'];
            $end=$dates_arr['to'];
            $name='holiday';
            $room=(int)$user_id;
        
            $item = new stdClass();
            $response=new stdClass();
        
            $item->id = null;
            $item->name = $name;
            $item->start=$start;
            $item->end = $end;
            $item->room_id=$room;
            $item->status='api_suggested';
            $item->paid=0;
  
            if($this->db->insertObject('reservations', $item)){
                //$response->result = 'OK';
            
                $insert_id=$this->db->insertid();
                //$response->message = 'Created with id: '.$insert_id;
                $response->insert_id = $insert_id;
                $response->type='success';
            }
            return (array)$response;
        } else{
            return 'error-0';
        }
        /*return [
            $dates_arr,
            $check_period
        ];*/
    }
    
    public function setHolidayFromCalendar($user_id, $from, $to)
    {
        $dates_arr=$this->convertDates($from, $to);
        $check_period=$this->checkPeriod($dates_arr, $user_id);
        
        if($check_period==0){
            $start=$dates_arr['from'];
            $end=$dates_arr['to'];
            $name='holiday';
            $room=(int)$user_id;
        
            $item = new stdClass();
            $response=new stdClass();
        
            $item->id = null;
            $item->name = $name;
            $item->start=$start;
            $item->end = $end;
            $item->room_id=$room;
            $item->status='New';
            $item->paid=0;
  
            if($this->db->insertObject('reservations', $item)){
                //$response->result = 'OK';
            
                $insert_id=$this->db->insertid();
                //$response->message = 'Created with id: '.$insert_id;
                $response->insert_id = $insert_id;
                $response->type='success';
            }
            return (array)$response;
        } else{
            return 'error-0';
        }
       
    }
    
    public function getHolidaysApi($user_id)   {
        $query = "SELECT `id`, `start`, `end`, `status` FROM `reservations` WHERE  `room_id` = ".$this->db->quote($user_id)."  order by `start` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        if(empty($list))
            $list  =  array();
        foreach ($list as $key=>$reservation) {
            $final  =   $this->reverseConvertDates($reservation->start, $reservation->end);
            $reservation->start =   $final->start;
            $reservation->end   =   $final->end;        
            if($reservation->status==='api_suggested'){
                $reservation->status='Pending';
            } elseif($reservation->status==='New'){
                $reservation->status='Confirmed';
            }
            $list[$key] = (array)$reservation;
        }        
        return $list;
    }
   
    public function getHolidayApi($user_id, $id)
    {
        $query = "SELECT `id`, `start`, `end`, `status` FROM `reservations` WHERE `id`='$id' AND `room_id` = '$user_id'";
        $this->db->setQuery($query);
        $reservation = $this->db->loadObject();
        
        $final=$this->reverseConvertDates($reservation->start, $reservation->end);
        $reservation->start=$final->start;
        $reservation->end=$final->end;
        
        if($reservation->status==='api_suggested'){
            $reservation->status='Pending';
        } elseif($reservation->status==='New'){
            $reservation->status='Confirmed';
        }
        
        return $reservation;
    }
    
    private function reverseConvertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        $from_date = $from_date_raw->format('d.m.Y');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        $to_date = $to_date_raw->format('d.m.Y');
        
        return (object)[
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }

    
    
}
