<?php
/**
 * @package     Joomla.Site
 * @subpackage  Templates.holidays
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

$app             = JFactory::getApplication();
$doc             = JFactory::getDocument();
$user            = JFactory::getUser();
$this->language  = $doc->language;
$this->direction = $doc->direction;

// Getting params from template
$params = $app->getTemplate(true)->params;

// Detecting Active Variables
$option   = $app->input->getCmd('option', '');
$view     = $app->input->getCmd('view', '');
$layout   = $app->input->getCmd('layout', '');
$task     = $app->input->getCmd('task', '');
$itemid   = $app->input->getCmd('Itemid', '');
$sitename = $app->get('sitename');
$userToken = JSession::getFormToken();
$lang =& JFactory::getLanguage();
if ($lang->getName() == "Íslenska (Ísland)") {
    $l = '/is/';
    $l01='is';
    $returnUrlLogout = '&return=aW5kZXgucGhwP0l0ZW1pZD0xMTc1';
} else {
    $l = '/en/';
    $l01='en';
}
if($task == "edit" || $layout == "form" )
{
	$fullWidth = 1;
}
else
{
	$fullWidth = 0;
}

// Add JavaScript Frameworks
JHtml::_('bootstrap.framework');
$doc->addScript($this->baseurl . '/templates/' . $this->template . '/js/template.js');
$doc->addScript($this->baseurl . '/templates/curiotimehome/js/jPushMenu.js');
 $doc->addStyleSheet($this->baseurl . '/templates/curiotimehome/css/jPushMenu.css?time='.time());
 
// Add Stylesheets
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/template.css?time='.time());
$doc->addStyleSheet($this->baseurl . '/components/com_audit/assets/incl/font-awesome-4.7.0/css/font-awesome.min.css');
$doc->addStyleSheet($this->baseurl . '/templates/' . $this->template . '/css/custom0.css?time='.time());

// Load optional RTL Bootstrap CSS
JHtml::_('bootstrap.loadCss', false, $this->direction);

// Adjusting content width
if ($this->countModules('position-7') && $this->countModules('position-8'))
{
	$span = "span6";
}
elseif ($this->countModules('position-7') && !$this->countModules('position-8'))
{
	$span = "span9";
}
elseif (!$this->countModules('position-7') && $this->countModules('position-8'))
{
	$span = "span9";
}
else
{
	$span = "span12";
}

// Logo file or site title param
if ($this->params->get('logoFile'))
{
	$logo = '<img src="' . JUri::root() . $this->params->get('logoFile') . '" alt="' . $sitename . '" />';
}
elseif ($this->params->get('sitetitle'))
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . htmlspecialchars($this->params->get('sitetitle')) . '</span>';
}
else
{
	$logo = '<span class="site-title" title="' . $sitename . '">' . $sitename . '</span>';
}
$doc->setGenerator('');
$config = JFactory::getConfig();
$enable_new_menu = $config->get('enable_new_menu');

$body_addon_class = '';

if($enable_new_menu == '1'){
   $body_addon_class.=' body_with_new_menu';
}
?>
<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="<?php echo $this->language; ?>" lang="<?php echo $this->language; ?>" dir="<?php echo $this->direction; ?>">
<head>
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<jdoc:include type="head" />
	<?php // Use of Google Font ?>
	<?php if ($this->params->get('googleFont')) : ?>
		<link href='//fonts.googleapis.com/css?family=<?php echo $this->params->get('googleFontName'); ?>' rel='stylesheet' type='text/css' />
		<style type="text/css">
			h1,h2,h3,h4,h5,h6,.site-title{
				font-family: '<?php echo str_replace('+', ' ', $this->params->get('googleFontName')); ?>', sans-serif;
			}
		</style>
	<?php endif; ?>
	<?php // Template color ?>
	<?php if ($this->params->get('templateColor')) : ?>
	<style type="text/css">
		body.site
		{
			/*border-top: 3px solid <?php echo $this->params->get('templateColor'); ?>;*/
			background-color: <?php echo $this->params->get('templateBackgroundColor'); ?>
		}
		a
		{
			color: <?php echo $this->params->get('templateColor'); ?>;
		}
		.navbar-inner, .nav-list > .active > a, .nav-list > .active > a:hover, .dropdown-menu li > a:hover, .dropdown-menu .active > a, .dropdown-menu .active > a:hover, .nav-pills > .active > a, .nav-pills > .active > a:hover,
		.btn-primary
		{
			background: <?php echo $this->params->get('templateColor'); ?>;
		}
		.navbar-inner
		{
			-moz-box-shadow: 0 1px 3px rgba(0, 0, 0, .25), inset 0 -1px 0 rgba(0, 0, 0, .1), inset 0 30px 10px rgba(0, 0, 0, .2);
			-webkit-box-shadow: 0 1px 3px rgba(0, 0, 0, .25), inset 0 -1px 0 rgba(0, 0, 0, .1), inset 0 30px 10px rgba(0, 0, 0, .2);
			box-shadow: 0 1px 3px rgba(0, 0, 0, .25), inset 0 -1px 0 rgba(0, 0, 0, .1), inset 0 30px 10px rgba(0, 0, 0, .2);
		}
	</style>
	<?php endif; ?>
	<!--[if lt IE 9]>
		<script src="<?php echo JUri::root(true); ?>/media/jui/js/html5.js"></script>
	<![endif]-->
</head>
 
<body class="site <?php echo $option
	. ' view-' . $view
	. ($layout ? ' layout-' . $layout : ' no-layout')
	. ($task ? ' task-' . $task : ' no-task')
	. ($itemid ? ' itemid-' . $itemid : '')
	. ($params->get('fluidContainer') ? ' fluid' : '');
?><?php if($this->language=='is-is'){echo ' body_lang-is';} else{ echo ' body_lang-en';} echo $body_addon_class;?>">
    
 <nav class="cbp-spmenu cbp-spmenu-vertical cbp-spmenu-left">
           <span class="icon-remove"></span>
	    <?php if ($this->countModules('footer-right')) : ?>
                <div>
                    <jdoc:include type="modules" name="footer-right" style="none" />
                </div>
            <?php endif; ?> 
            <?php 
                $page = $_SERVER['REQUEST_URI'];
                $page = str_replace(['/en', '/is'], '', $page);
                if($page != '/'){
                    $url = $page;
                } else{
                    $url = ''; 
                }             
            ?>
            <div class="js_lang_link">
                <a class="lang-link a_en_link" href="/en<?=$url?>"><img width="30" src="/images/en.png" alt=""></a>
                <a class="lang-link" href="/is<?=$url?>"><img width="30" src="/images/is.png" alt=""></a>
            </div>
    </nav>

	<!-- Body -->
	<div class="body">
                <?php if ($this->countModules('left-menu')) : ?>
                    <div id="left-menu">
                        <div class="pull-left">
                            <jdoc:include type="modules" name="left-menu" style="none" />
                             <?php 
                                /*$page = $_SERVER['REQUEST_URI'];
                                $page = str_replace(['/en', '/is'], '', $page);
                                if($page != '/'){
                                    $url = $page;
                                } else{
                                    $url = ''; 
                                }*/             
                            ?>
                            <div class="lang_link_wr">
                                <a class="lang-link" href="/en<?=$url?>"><img width="30" src="/images/en.png" alt=""></a>
                                <a class="lang-link" href="/is<?=$url?>"><img width="30" src="/images/is.png" alt=""></a>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
		<div class="container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?>">
			<!-- Header -->
			<header class="header" role="banner">
				<!--<div class="header-inner clearfix">
					<a class="brand pull-left" href="<?php echo $this->baseurl; ?>/">
						<?php echo $logo; ?>
						<?php if ($this->params->get('sitedescription')) : ?>
							<?php echo '<div class="site-description">' . htmlspecialchars($this->params->get('sitedescription')) . '</div>'; ?>
						<?php endif; ?>
					</a>
					<div class="header-search pull-right">
						<jdoc:include type="modules" name="position-0" style="none" />
					</div>
				</div>-->
			</header>
			<?php if ($this->countModules('position-1')) : ?>
				<nav class="navigation" role="navigation">
					<jdoc:include type="modules" name="position-1" style="none" />
				</nav>
			<?php endif; ?>
			<jdoc:include type="modules" name="banner" style="xhtml" />
			<div class="row-fluid">
				<?php if ($this->countModules('position-8')) : ?>
					<!-- Begin Sidebar -->
					<div id="sidebar" class="span3">
						<div class="sidebar-nav">
							<jdoc:include type="modules" name="position-8" style="xhtml" />
						</div>
					</div>
					<!-- End Sidebar -->
				<?php endif; ?>
				<main id="content" role="main" class="<?php echo $span; ?>">
					<!-- Begin Content -->
					<jdoc:include type="modules" name="position-3" style="xhtml" />
					<!--<jdoc:include type="message" />-->
					<jdoc:include type="component" />
					<jdoc:include type="modules" name="position-2" style="none" />
					<!-- End Content -->
				</main>
				<?php if ($this->countModules('position-7')) : ?>
					<div id="aside" class="span3">
						<!-- Begin Right Sidebar -->
						<jdoc:include type="modules" name="position-7" style="well" />
						<!-- End Right Sidebar -->
					</div>
				<?php endif; ?>
			</div>
		</div>
	</div>
	<!-- Footer -->
	<!--<footer class="footer" role="contentinfo">
		<div class="container<?php echo ($params->get('fluidContainer') ? '-fluid' : ''); ?>">
			<hr />
			<jdoc:include type="modules" name="footer" style="none" />
			<p class="pull-right">
				<a href="#top" id="back-top">
					<?php echo JText::_('TPL_PROTOSTAR_BACKTOTOP'); ?>
				</a>
			</p>
			<p>
				&copy; <?php echo date('Y'); ?> <?php echo $sitename; ?>
			</p>
		</div>
	</footer>-->
	<jdoc:include type="modules" name="debug" style="none" />
        
        <script>
            'use strict';
    
            jQuery(document).ready(function($){
                let 
                    js = $,
                    true_left_menu_html = js('#left-menu').html(),
                    lang = '<?=$l01?>',
                    enable_new_menu = '<?=$enable_new_menu?>';
                
                js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .icon-remove').after(js('.js_lang_link'));
                
                if(enable_new_menu == '1'){
                    js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .nav.menu').addClass('first_left_menu');
                    js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .nav.menu').after(true_left_menu_html);
            
                    if(lang == 'is'){
                        js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .item-1185 a').prepend('<i class="fa fa-play" aria-hidden="true"></i>');
                        js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .item-1187 a').prepend('<i class="fa fa-sign-out" aria-hidden="true"></i>');
                    } else{
                        js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .item-1184 a').prepend('<i class="fa fa-play" aria-hidden="true"></i>');
                        js('.cbp-spmenu.cbp-spmenu-vertical.cbp-spmenu-left .item-1186 a').prepend('<i class="fa fa-sign-out" aria-hidden="true"></i>');
                    }
                }
        
                js('#left-menu .nav.menu').prepend('<li class="li_with_background"><div class="extra_menu"><a href="javascript:void(0)" class="a_header_logo js_trigger_menu toggle-menu menu-left push-body jPushMenuBtn"><img src="/images/menu-icons/icon-menu.png" class="js_trigger_menu toggle-menu menu-left push-body jPushMenuBtn"></a> </div></li>');
                js('#left-menu .nav.menu').append('<li class="li_bottom"><a href="#"></a></li>');
                 
                js('.toggle-menu').jPushMenu();  
                
                js('.logout-link2').click(function(){
                    window.location = 'index.php?option=com_users&task=user.logout&<?=$userToken?>=1<?=$returnUrlLogout?>'; 
                });
            });
        </script>
</body>
</html>
