<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_menu
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

if (is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) {
    // component exists
    JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
    $model = JModelLegacy::getInstance('Api', 'CtapiModel');
    $user = & JFactory::getUser();
    $mods = $model->getCompanyMods($user->company, 1);
    $lang = & JFactory::getLanguage();
    if ($lang->getName() == "Íslenska (Ísland)") {
        $l = 'is';
    } else {
        $l = 'en';
    }
     /*echo '<pre>';
      print_r($mods);
      echo '</pre>'; */

    $disableLinks = array();
    if (isset($mods["confirmation"]) && $mods["confirmation"] == 0) {

        if ($l == 'is') {
            $disableLinks[] = "/is/confirm-time";
            $disableLinks[] = "/is/confirm-page-new";
            $disableLinks[] = 'index.php?option=com_audit&view=confirm_time_new';
        } else {
            $disableLinks[] = "/confirm-time";
            $disableLinks[] = "/confirm-page-new";
            $disableLinks[] = 'index.php?option=com_audit&view=confirm_time_new';
        }
    }
    if (isset($mods["holiday"]) && $mods["holiday"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/new-holidays2";
            $disableLinks[] = "/is/holidays-new";
            $disableLinks[] = "index.php?option=com_spec_holiday2&view=new_psd";
        } else {
            $disableLinks[] = "/new-holidays2";
            $disableLinks[] = "/holidays-new";
            $disableLinks[] = "index.php?option=com_spec_holiday2&view=new_psd";
        }
    }
    if (isset($mods["pay_period"]) && $mods["pay_period"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/pay-period-clock";
            $disableLinks[] = "index.php?option=com_audit&view=pay_period";

            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/is/pay-period-clock-new";
        } else {
            $disableLinks[] = "/pay-period-clock";
            $disableLinks[] = "index.php?option=com_audit&view=pay_period";

            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/pay-period-clock-new";
        }
    }

    if (isset($mods["enable_task_manager"]) && $mods["enable_task_manager"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/task-manager";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager";

            $disableLinks[] = "/is/task-manager-new";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager_new";
        } else {
            $disableLinks[] = "/task-manager";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager";

            $disableLinks[] = "/task-manager-new";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager_new";
        }
    }

    if (isset($mods["enable_rules"]) && $mods["enable_rules"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/rules";
            $disableLinks[] = "index.php?option=com_audit&view=rules";

            $disableLinks[] = "/is/rules-new";
            $disableLinks[] = "index.php?option=com_audit&view=rules_new";
        } else {
            $disableLinks[] = "/rules";
            $disableLinks[] = "index.php?option=com_audit&view=rules";

            $disableLinks[] = "/rules-new";
            $disableLinks[] = "index.php?option=com_audit&view=rules_new";
        }
    }

    if (in_array(2, $user->groups) || in_array(9, $user->groups)) {
        if ($l == 'is') {
            $disableLinks[] = "/is/employers-staff";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users";

            $disableLinks[] = "/is/employers-list-new";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users_new";

            $disableLinks[] = "/is/settings";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages";

            $disableLinks[] = "/is/settings-new";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages_new";
            
            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/is/pay-period-clock-new";
        } else {
            $disableLinks[] = "/employers-staff";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users";

            $disableLinks[] = "/employers-list-new";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users_new";

            $disableLinks[] = "/settings";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages";

            $disableLinks[] = "/settings-new";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages_new";
            
            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/pay-period-clock-new";
        }
    }
	if (isset($mods["shifts"]) && $mods["shifts"] == 0 || (in_array(9, $user->groups))) {
        $disableLinks[] = "/is/shedules";
        $disableLinks[] = "index.php?option=com_shifts&view=new_psd";
        $disableLinks[] = "index.php?option=com_shifts&view=default";
              
        $disableLinks[] = "/shedules";
        $disableLinks[] = "/shifts";
        $disableLinks[] = "/is/shifts";           
    }

    if (!empty($disableLinks)) {
        foreach ($disableLinks as $dLink) {
            foreach ($list as $k => &$item) {
                /* echo '<pre>';
                  print_r($k);
                  echo '</pre>'; */

                  /*echo '<pre>';
                  print_r($item);
                  echo '</pre>'; */

                /* echo '<pre>dd';
                  print_r($dlink);
                  echo '</pre>'; */

                if ($item->link == $dLink /* || $item->flink == $dlink */) {
                    /* echo '<pre>';
                      print_r($dLink);
                      echo '</pre>'; */
                    //unset($list[$k]); 
                    $list[$k]->link = "/#dis";
                    $list[$k]->flink = "/#dis";
                    $list[$k]->alias = "/#dis";
                    $list[$k]->anchor_css = $list[$k]->anchor_css . " menu-item-disabled ";
                    break;
                }
            }
        }
    }

    /* echo '<pre>';
      print_r($disableLinks);
      echo '</pre>'; */
    //var_dump($disableLinks);exit;
}

if (0) {
    echo "<pre>";
    var_dump($list);
    echo "</pre>";
    exit;
}
// Note. It is important to remove spaces between elements.
?>
<?php // The menu class is deprecated. Use nav instead.  ?>
<ul class="nav menu<?php echo $class_sfx; ?>"<?php
$tag = '';

if ($params->get('tag_id') != null) {
    $tag = $params->get('tag_id') . '';
    echo ' id="' . $tag . '"';
}
?>>
<?php
foreach ($list as $i => &$item) {
    $class = 'item-' . $item->id;

    if (($item->id == $active_id) OR ( $item->type == 'alias' AND $item->params->get('aliasoptions') == $active_id)) {
        $class .= ' current';
    }

    if (in_array($item->id, $path)) {
        $class .= ' active';
    } elseif ($item->type == 'alias') {
        $aliasToId = $item->params->get('aliasoptions');

        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
            $class .= ' active';
        } elseif (in_array($aliasToId, $path)) {
            $class .= ' alias-parent-active';
        }
    }

    if ($item->type == 'separator') {
        $class .= ' divider';
    }

    if ($item->deeper) {
        $class .= ' deeper';
    }

    if ($item->parent) {
        $class .= ' parent';
    }

    if (!empty($class)) {
        $class = ' class="' . trim($class) . '"';
    }

    echo '<li' . $class . '>';

    // Render the menu item.
    switch ($item->type) :
        case 'separator':
        case 'url':
        case 'component':
        case 'heading':
            require JModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
            break;

        default:
            require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
            break;
    endswitch;

    // The next item is deeper.
    if ($item->deeper) {
        echo '<ul class="nav-child unstyled small">';
    } elseif ($item->shallower) {
        // The next item is shallower.
        echo '</li>';
        echo str_repeat('</ul></li>', $item->level_diff);
    } else {
        // The next item is on the same level.
        echo '</li>';
    }
}
?></ul>
<style>
    ul.menu li a.menu-item-disabled .image-title {
        text-decoration: line-through;
        color:#909090;
    }
</style>
<script>
    jQuery(document).on("click", "ul.menu li a.menu-item-disabled", function () {
        return false;
    })
</script>