<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_menu
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

if (is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) {
    // component exists
    JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
    $model = JModelLegacy::getInstance('Api', 'CtapiModel');
    $user = & JFactory::getUser();
    $mods = $model->getCompanyMods($user->company, 1);
    $lang = & JFactory::getLanguage();
    if ($lang->getName() == "Íslenska (Ísland)") {
        $l = 'is';
    } else {
        $l = 'en';
    }
    /*echo '<pre>';
    print_r($mods);
    echo '</pre>'; */
        
    $disableLinks = array();
    if (isset($mods["confirmation"]) && $mods["confirmation"] == 0) {

        if ($l == 'is') {
            $disableLinks[] = "/is/confirm-time";
            $disableLinks[] = "/is/confirm-page-new";
            $disableLinks[] = 'index.php?option=com_audit&view=confirm_time_new';
        } else {
            $disableLinks[] = "/confirm-time";
            $disableLinks[] = "/confirm-page-new";
            $disableLinks[] = '/index.php?option=com_audit&view=confirm_time_new';
        }
    }
    if (isset($mods["holiday"]) && $mods["holiday"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/new-holidays2";
        } else {
            $disableLinks[] = "/new-holidays2";
        }
    }
    if (isset($mods["pay_period"]) && $mods["pay_period"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/pay-period-clock";
            $disableLinks[] = "index.php?option=com_audit&view=pay_period";
            
            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/is/pay-period-clock-new";
        } else {
            $disableLinks[] = "/pay-period-clock";
            $disableLinks[] = "index.php?option=com_audit&view=pay_period";
            
            $disableLinks[] = "index.php?option=com_audit&view=pay_period_new";
            $disableLinks[] = "/pay-period-clock-new";
        }
    }

    if (isset($mods["enable_task_manager"]) && $mods["enable_task_manager"] == 0) {
        if ($l == 'is') {
            $disableLinks[] = "/is/task-manager";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager";
        } else {
            $disableLinks[] = "/task-manager";
            $disableLinks[] = "index.php?option=com_audit&view=task_manager";
        }
    }

    if (isset($mods["enable_rules"]) && $mods["enable_rules"] == 0 || in_array(10, $user->groups)) {
        if ($l == 'is') {
            $disableLinks[] = "/is/rules";
            $disableLinks[] = "index.php?option=com_audit&view=rules";
        } else {
            $disableLinks[] = "/rules";
            $disableLinks[] = "index.php?option=com_audit&view=rules";
        }
    }

    if (in_array(2, $user->groups) || in_array(9, $user->groups)) {
        if ($l == 'is') {
            $disableLinks[] = "/is/employers-staff";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users";

            $disableLinks[] = "/is/settings";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages";
        } else {
            $disableLinks[] = "/employers-staff";
            $disableLinks[] = "index.php?option=com_audit&view=registered_users";

            $disableLinks[] = "/settings";
            $disableLinks[] = "index.php?option=com_audit&view=time_wages";
        }
    }
    /* echo '<pre>';
      print_r($user);
      echo '</pre>'; */
    if (!empty($disableLinks)) {
        /*echo '<pre>';
        print_r($disableLinks);
        echo '</pre>';*/
        foreach ($disableLinks as $dLink) {
            foreach ($list as $k => &$item) {
                 /*echo '<pre>';
                  print_r($k);
                  echo '</pre>';*/

                  /*echo '<pre>';
                  print_r($item);
                  echo '</pre>'; */
                if ($item->link == $dLink) {
                    /* echo '<pre>';
                      print_r($dLink);
                      echo '</pre>'; */
                    //unset($list[$k]); 
                    $list[$k]->link = "/#dis";
                    $list[$k]->flink = "/#dis";
                    $list[$k]->alias = "/#dis";
                    $list[$k]->anchor_css = $list[$k]->anchor_css . " menu-item-disabled ";
                    break;
                }
            }
        }
    }


    //var_dump($disableLinks);exit;
}

$page = $_SERVER['REQUEST_URI'];
$page = str_replace(['/en', '/is'], '', $page);
if ($page != '/') {
    $url = $page;
} else {
    $url = '';
}

if (0) {
    echo "<pre>";
    var_dump($list);
    echo "</pre>";
    exit;
}
// Note. It is important to remove spaces between elements.
?>
<?php // The menu class is deprecated. Use nav instead.  ?>
<ul class="navbar-nav mr-auto <?php echo $class_sfx; ?>"<?php
$tag = '';

if ($params->get('tag_id') != null) {
    $tag = $params->get('tag_id') . '';
    echo ' id="' . $tag . '"';
}
?>><li class="nav-item li_control_panel">
        <a class="d-inline_block d-lg-none d-xl-none lang-link" href="/en<?= $url ?>"><img width="30" src="/images/en.png" alt=""></a>
        <a class="d-inline_block d-lg-none d-xl-none lang-link" href="/is<?= $url ?>"><img width="30" src="/images/is.png" alt=""></a>
    </li>
    <!--<li class="nav-item dropdown">
        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown1" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <?= JText::_('Menu'); ?>
        </a>
        <div class="dropdown-menu" aria-labelledby="navbarDropdown1">
            <a class="dropdown-item" href="<?= $l ?>"><?= JText::_('COM_AUDIT_HOME_NAV_MAIN_PAGE'); ?></a>
            <a class="dropdown-item" href="<?= $l ?>/curio-time"><?= JText::_('COM_AUDIT_HOME_NAV_CONTROL_PANEL'); ?></a>
        </div>
    </li>-->
<?php
foreach ($list as $i => &$item) {
    $class = 'item-' . $item->id;

    if (($item->id == $active_id) OR ( $item->type == 'alias' AND $item->params->get('aliasoptions') == $active_id)) {
        $class .= ' current';
    }

    if (in_array($item->id, $path)) {
        $class .= ' active';
    } elseif ($item->type == 'alias') {
        $aliasToId = $item->params->get('aliasoptions');

        if (count($path) > 0 && $aliasToId == $path[count($path) - 1]) {
            $class .= ' active';
        } elseif (in_array($aliasToId, $path)) {
            $class .= ' alias-parent-active';
        }
    }

    if ($item->type == 'separator') {
        $class .= ' divider';
    }

    if ($item->deeper) {
        $class .= ' deeper';
    }

    if ($item->parent) {
        $class .= ' parent';
    }

    if (!empty($class)) {
        $class = ' class="' . trim($class) . '"';
    }

    echo '<li class="nav-item">';
    //<a class="nav-link">'
    // Render the menu item.
    switch ($item->type) :
        case 'separator':
        case 'url':
        case 'component':
        case 'heading':
            //echo $item->type.PHP_EOL;
            require JModuleHelper::getLayoutPath('mod_menu', 'default_' . $item->type);
            break;

        default:
            require JModuleHelper::getLayoutPath('mod_menu', 'default_url');
            break;
    endswitch;

    // The next item is deeper.
    if ($item->deeper) {
        echo '<ul class="nav-child unstyled small">';
    } elseif ($item->shallower) {
        // The next item is shallower.
        echo '</li>';
        echo str_repeat('</ul></li>', $item->level_diff);
    } else {
        // The next item is on the same level.
        echo '</li>';
    }
}
?>
    <!--<li class="nav-item dropdown li_control_panel">
        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown0" role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
            <?= JText::_('COM_AUDIT_HOME_NAV_CONTROL_PANEL'); ?>
        </a>
        <div class="dropdown-menu" aria-labelledby="navbarDropdown0">
            <a class="dropdown-item" href="<?= $l ?>"><?= JText::_('COM_AUDIT_HOME_NAV_MAIN_PAGE'); ?></a>
            <a class="dropdown-item" href="<?= $l ?>/curio-time"><?= JText::_('COM_AUDIT_HOME_NAV_CONTROL_PANEL'); ?></a>
        </div>
    </li>-->
    <li class="nav-item li_logout_home">
        <a class="nav-link logout-link2 d-flex align-items-center" href="#"><i class="fa fa-user-circle" aria-hidden="true"></i> <?= JText::_('COM_AUDIT_CONTROL_PANEL_TOP_MENU_LOGOUT'); ?></a>
    </li>
</ul>
<style>
    ul.menu li a.menu-item-disabled .image-title {
        text-decoration: line-through;
        color:#909090;
    }
</style>
<script>
    jQuery(document).on("click", "ul.menu li a.menu-item-disabled", function () {
        return false;
    });
</script>