<?php

/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/  

set_time_limit(0);

define('_JEXEC', 1);

define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);


define('DS', DIRECTORY_SEPARATOR);
require_once( JPATH_BASE . DS . 'includes' . DS . 'defines.php' );

require_once( JPATH_BASE . DS . 'includes' . DS . 'framework.php' );

jimport('joomla.application.component.controller');

$mainframe = & JFactory::getApplication('site');
$session = & JFactory::getSession();
$db = & JFactory::getDbo();
$config = & JFactory::getConfig();

$encryption_key = $config->get('front_api_encryption_key');
$front_api_password = $config->get('front_api_passw');

define('ENCRYPTION_KEY', $encryption_key);
define("FRONT_API_PASSWORD", $front_api_password);


if ($curl = curl_init()) {
    
} else {
    exit('Curl not init!');
}

class testingFrontApi {

    private $db;
    
    public function __construct() 
    {

        $this->db = &JFactory::getDBO();
        $this->app = & JFactory::getApplication();
        $this->doc = & JFactory::getDocument();
        $this->server_path = JPATH_BASE;
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();

        $this->password_current_api = FRONT_API_PASSWORD;
        $this->server_name = $_SERVER['SERVER_NAME'];

        if ($this->server_name == 'localhost') {
            $this->ultima_api_path = 'http://' . $this->server_name . '/front_api/api.php';
        } else {
            $this->ultima_api_path = 'https://' . $this->server_name . '/front_api/api.php';
        }

        $this->client_info = $_SERVER['HTTP_USER_AGENT'];
        $this->client_ip = $_SERVER['REMOTE_ADDR'];
        $this->prepare_passw_auth = $this->preparePassw($this->password_current_api);
    }

    public function preparePassw($passw) 
    {
        return password_hash($passw, PASSWORD_BCRYPT);
    }

    /**
        * Get pay period data by token.
        * Response http://prntscr.com/upym4g , http://prntscr.com/upyn19 .
        *   
        * array['fields']              array Defines the fields to be shown by scaffolding.
        *              ['user_token']        string user_token
        *              ['from'] string from
        *              ['to'] string to
        *              ['lang'] string lang
        * 
        * @param array $config (See above)
        * @return Object std.
    */
    public function getTimesheetTest($config) 
    {
        echo 'getTimesheet';
        
        $prepare_lang = $this->encrypt($config['lang']);
        //$prepared_company = $this->encrypt($config['company']);
        //$prepared_password = $this->encrypt($config['password']);
        
        $prepared_company = $config['company'];
        $prepared_password = $config['password'];
        $id = $config['id'];
        
        $data = [
            //'passw' => $this->prepare_passw_auth,
            'jsonrpc' => '2.0',
            'method' => 'getTimesheet',
            'params' => [
                'client_info' => $this->client_info,
                'lang' => $prepare_lang,
                'user_token' => $config['user_token'],
                'from' => $config['from'],
                'to' => $config['to'],
               
            ],
            'id' => $id
        ];

        $responses = $this->curlCall($this->ultima_api_path, $data);
        $no_json_decoded = $responses['raw_curl_response'];
        $json_decoded =  $responses['curl_response'];
        
        return $json_decoded;
    }
    
    public function unlockTest($config) 
    {
        echo 'unlock';
        $curl = curl_init();
        
      
        $prepare_lang = $this->encrypt($config['lang']);
        //$prepared_company = $this->encrypt($config['company']);
        //$prepared_password = $this->encrypt($config['password']);
        
        $prepared_company = $config['company'];
        $prepared_password = $config['password'];
        $id = $config['id'];
        
        $data = [
            //'passw' => $this->prepare_passw_auth,
            'jsonrpc' => '2.0',
            'method' => 'unlock',
            'params' => [
                'client_info' => $this->client_info,
                'lang' => $prepare_lang,
                'company' => $prepared_company,
                'password' => $prepared_password,
            ],
            'id' => $id
        ];

        $responses = $this->curlCall($this->ultima_api_path, $data);
        $no_json_decoded = $responses['raw_curl_response'];
        $json_decoded =  $responses['curl_response'];
        
        return $json_decoded;
    }

    public function __toString()
    {
        return '';
    }
    
    private function encrypt($plaintext) 
    {
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = openssl_random_pseudo_bytes($ivlen);
        $ciphertext_raw = openssl_encrypt($plaintext, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $hmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        $ciphertext = base64_encode($iv . $hmac . $ciphertext_raw);
        
        return $ciphertext;
    }

    private function decrypt($ciphertext) 
    {
        $c = base64_decode($ciphertext);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $plaintext = openssl_decrypt($ciphertext_raw, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {
            return $plaintext;
        }
    }

    private static function decryptStatic($ciphertext) 
    {
        $c = base64_decode($ciphertext);
        $ivlen = openssl_cipher_iv_length($cipher = "AES-128-CBC");
        $iv = substr($c, 0, $ivlen);
        $hmac = substr($c, $ivlen, $sha2len = 32);
        $ciphertext_raw = substr($c, $ivlen + $sha2len);
        $plaintext = openssl_decrypt($ciphertext_raw, $cipher, ENCRYPTION_KEY, $options = OPENSSL_RAW_DATA, $iv);
        $calcmac = hash_hmac('sha256', $ciphertext_raw, ENCRYPTION_KEY, $as_binary = true);
        if (hash_equals($hmac, $calcmac)) {
            return $plaintext;
        }
    }
    
    private function curlCall($url, $data)
    {
        $curl = curl_init();
        $post = http_build_query($data);
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_CONNECTTIMEOUT => 0,
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);
        curl_close($curl);

        $res = json_decode(trim($out), true);
        if(empty($res)){
            $res = [];
        }
        
        return [
            'raw_curl_response' => $out,
            'curl_response' => $res
        ];
    }

}

$client_obj = new testingFrontApi();
$user_token = 'e076fc596ee17b4438dc3e19ccd021fb432d12f42a8a8ba76ff8e2810181f2ea9e9a1d277672dc2641561492e03c782a507a0e6fb09036cce67759942fb34b42';

/**
 * Get pay period data by token.
 * Response http://prntscr.com/upym4g , http://prntscr.com/upyn19 .
 *   
 * array['fields']              array Defines the fields to be shown by scaffolding.
 *              ['user_token']        string user_token
 *              ['from'] string from
 *              ['to'] string to
 *              ['lang'] string lang
 * 
 * @param array $config (See above)
 * @return Object std.
 */
 $response = $client_obj->getTimesheetTest([
    'user_token' => $user_token,
    'from' => '25.09.2020',
    'to' => '24.10.2020',  
    'lang' => 'en',//en/is,
    'id' => mt_rand(0, 9999999)
  ]);
 
  echo '<pre>';
  print_r($response);
  echo '</pre>'; 


/**
 * Check password and set & return cookie for unlock page https://gyazo.com/edd7de01502dc695e0f707bbf19b7281
 * Response http://prntscr.com/w0lu0u . If is error - return http://prntscr.com/vqkp1p .
 *   
 * array['fields']              array Defines the fields to be shown by scaffolding.
 *              ['lang']        string lang(en/is)
 *              ['company']      string company
 *              ['password']     string password
 *              ['id']           int id
 * 
 * @param array $config (See above)
 * @return Object std.
 */
  /*$response = $client_obj->unlockTest([
    'lang' => 'en',
    'company' => 'manager_c',
    'password' => 'nduOEURg93rf',
    'id' => mt_rand(0, 9999999)
  ]);
 
  echo '<pre>'; 
  print_r($response);
  echo '</pre>';  */


/* * *END not delete these tests!** */
?>
