<?php
// No direct access
defined('_JEXEC') or die;
/**
 * @author 
 */
class AuditModelCustom_pay_period extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();

        $this->work_day_hours = 8;
        //$this->model_pay_period=&JModelLegacy::getInstance('Pay_Paeriod', 'AuditModel');
       // $this->joomla_baseurl=JUri::base(); 
       
        include JPATH_BASE.DS.'components'.DS.'com_audit'.DS.'assets'.DS.'incl'.DS.'simplehtmldom_1_5'.DS.'simple_html_dom.php';
    }

    public function backgroundClassesArray($user_id, $dates) {
        //$dates=json_decode($dates);
        $final_array=[];
        
        foreach($dates as $items){
            $i=0;
            
            foreach ($items as $date){              
                $time_array=explode(':', $date['time']); 
                $hours=$time_array[0];
                               
                //if($hours>=$this->work_day_hours){                     
                    $bckground_class=$this->getBackgroundClass($date['date'], $user_id);
                    
                    //$final_array[]=$hours;
                    $final_array['items'][$i]['user_id']=$user_id;
                    $final_array['items'][$i]['date']=$date['date'];
                    $final_array['items'][$i]['total_time']=$date['time'];
                    $final_array['items'][$i]['class']=$bckground_class;
                    
                    $i++;
                //}                           
            }     
        }
        return $final_array;
    }
    
    public function getBackgroundClass($date, $user_id)
    {
        $user_id=(int)$user_id;
        $date1=explode('.', $date);
        
        $year=date('Y', strtotime($date));
        $month=date('n', strtotime($date));
        $day=date('j', strtotime($date));
       
        //$report_items= json_decode($this->getReportItems($user_id));
        $report_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
        
        //foreach($report_items as $item1){
            //if($item1->year===$year && $item1->month===$month && $item1->day===$day){
                //$current_status=$report_item_status;
             if($report_item_status){   
                switch($report_item_status){
                    case '1':
                        $background_class='pay_period_td_background_green';
                    break;
                    case '2':
                        $background_class='pay_period_td_background_yellow';
                    break;
                    case '3':
                        $background_class='pay_period_td_background_red';
                    break;
                    case '4':
                        $background_class='pay_period_td_background_blue';
                    break;
                    case '6':
                        $background_class='pay_period_td_background_gray';
                    break;
                    default:
                        $background_class='';
                    break;
                
                }
            } else{
                $background_class='';
            }
        //}
        
        return $background_class;
    }
    
   /* public function getReportItems($user_id)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        return json_encode($items);
    }*/
    
    public function checkReportItemStatus($user_id, $date_year, $date_month, $date_day)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'"  AND `year`="'.$date_year.'" AND `month`="'.$date_month.'" AND `day`="'.$date_day.'"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        return $user_report->status;
    }
    
    public function calcColoredDays($user_id, $status, $from, $to)
    {
       // $from='01.03.2018';
       // $to='31.03.2018';
        
        $current_month=date('n', strtotime($from));
        $year=date('Y', strtotime($from));
        
        //$query='SELECT COUNT(id) as count_items FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $this->db->setQuery( $query );
        $all_days_current_month = $this->db->loadObjectList(); 
        
        $prepare_array=[];
        $i=0;
        $count_day_for_audit_time=0;
        
        foreach($all_days_current_month as $k=>$v){      
            $day=$v->day;
            $month=$v->month;
            $year=$v->year;
            
            $prepare_array[$i]['color']=$status;
            $prepare_array[$i]['date']=DateTime::createFromFormat('Y.n.j', $year.'.'.$month.'.'.$day)->format('Y-m-d');
            $query='SELECT COUNT(id) as count_items FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $this->db->setQuery( $query );
            $count_items= $this->db->loadObject()->count_items; 
            
            if($count_items>0){
                $prepare_array[$i]['count']=$count_items;
                $count_day_for_audit_time=$prepare_array[$i]['count']; //count number of days if exist day in table audit_time          
            } else{
               $count_day_for_audit_time++;//increment the number of days if the table audit_time does not have a time stamp
            }
     
            $i++;      
        }
  
       // return $shedule_items->count_items;   
        /*echo '<pre>';
        echo 'from-'.$from;
        echo ' to-'.$to.'<br/>';
        //echo 'error-'.$error;
        print_r($prepare_array);
        echo '</pre>';*/
        
        
        return $count_day_for_audit_time;
    }
    
    
    
    public function calcColoredDaysCustomFromTo($user_id, $status, $from, $to)
    {
       // $from='01.05.2018';
       // $to='31.05.2018';
        
        //echo $from.' - '.$to.'<br/>';
        
        $date_from= DateTime::createFromFormat('d.m.Y', $from);
        $current_month=$date_from->format('n');
        $current_year=$date_from->format('Y');
        
        $date_to= DateTime::createFromFormat('d.m.Y', $to);
        $month_to=$date_to->format('n');
        $year_to=$date_to->format('Y');
        
        //make dates array
        $begin = new DateTime( $date_from->format('Y-m-d') );
        $end = new DateTime( $date_to->format('Y-m-d') );
        $end = $end->modify( '+1 day' ); 
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($begin, $interval ,$end);

        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND (';
        
        foreach($daterange as $date){     
            $query.='`month`="'.$date->format('n').'" AND `status`="'.$status.'" AND `year`="'.$date->format('Y').'" AND `day`="'.$date->format('j').'" OR ';
        }
        $query = chop($query, ' OR');
   
        //$query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`>="'.$current_month.'" AND `status`="'.$status.'" AND `year`>="'.$year.'" AND `month`<="'.$month_to.'" AND `year`<="'.$year_to.'"';
        //$query='SELECT `day`, `month`, `year` FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $query.=')';
        //echo '<br/>'.$query.'<br/>';
       
        $this->db->setQuery( $query );
        $all_days_current_month = $this->db->loadObjectList(); 
        
        /*echo '<pre>';
        print_r( $all_days_current_month);
        echo '</pre>';*/
        
        $prepare_array=[];
        $i=0;
        $count_day_for_audit_time=0;
       
        foreach($all_days_current_month as $k=>$v){      
            $day=$v->day;
            $month=$v->month;
            $year=$v->year;
            
            $prepare_array[$i]['color']=$status;
            $prepare_array[$i]['date']=DateTime::createFromFormat('Y.n.j', $year.'.'.$month.'.'.$day)->format('Y-m-d');
            //$query='SELECT COUNT(id) as count_items FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            $this->db->setQuery( $query );
            $count_items_array= $this->db->loadObjectList(); 
            
            if(count($count_items_array)>1){//if there are more than one login for one date
                foreach($count_items_array as $one_item){                  
                    $count_day_for_audit_time++;
                
                    /*if(count($count_items_array)>0){
                        $prepare_array[$i]['count']=count($count_items_array);
                        $count_day_for_audit_time=$prepare_array[$i]['count']; //count number of days if exist day in table audit_time          
                    } else{
                        $count_day_for_audit_time++;//increment the number of days if the table audit_time does not have a time stamp
                    }*/
                }           
            } else{
                $count_day_for_audit_time++;
            }                    
            $i++;                
        }
         
        return $count_day_for_audit_time;
    }
    
    public function getAskGps($user_id)
    {
        $date=date('Y-m-d');
        
        $query = "SELECT `asked_gps` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date` = '$date'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadResult();
        return (string)$res;
    }
    
    public function setCoordinates($lat, $lng, $user_id, $note)
    {
        $lat=(float)$lat;
        $lng=(float)$lng;
        $current_date=date('Y-m-d');
        
        $query = "SELECT `id` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        $last_db_id=$res->id;
        
        $query = "UPDATE #__audit_time SET `lat`='$lat', `lng`='$lng', `asked_gps`='0', `note`='$note' WHERE `id`='".$last_db_id."'";       
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function saveNoteHome($user_id, $note)
    {
        $current_date=date('Y-m-d');
        
        $query = "SELECT `id` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        $last_db_id=$res->id;
        
        $query = "UPDATE #__audit_time SET `note`='$note' WHERE `id`='".$last_db_id."'";       
        $this->db->setQuery($query);
        return $this->db->query();
    }
    
    public function getLatLng($date, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `lat`, `lng` FROM #__audit_time WHERE `date_logged`='$date' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function getLatLng2($date_start, $date_end, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `date_logged`, `lat`, `lng`, `lat_end`, `lng_end` FROM #__audit_time WHERE `date_logged`>='$date_start' AND `date_logged`<='$date_end' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function getLatLngEnd($date, $user_id)
    {
        $user_id=(int)$user_id;
        //$user_joomla = JFactory::getUser($user_id);
        $query="SELECT `lat_end`, `lng_end` FROM #__audit_time WHERE `date_logged`='$date' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return json_encode($res);
    }
    
    public function saveInputPayPeriod($user_id, $from, $to, $owner_id)
    {
        //here
        $query="SELECT `id` FROM #__users WHERE `owner_id`='$owner_id'";
        $this->db->setQuery($query);
        $array_manager_users = $this->db->loadObjectList();
        
        foreach ($array_manager_users as $one_user) {
            $query = "SELECT `id` FROM #__pay_period_preserved WHERE `id_user` = '$one_user->id'";
            $this->db->setQuery($query);
            //get current gps status
            $res = $this->db->loadResult();

            if (is_null($res)) {
                //insert into
                $item = new stdClass();
                $item->id_user = $one_user->id;
                $item->from_date = $from;
                $item->to_date = $to;
                $this->db->insertObject('#__pay_period_preserved', $item);
                $res = 'insert';
            } else {
                //update table
                $item = new stdClass();
                $item->id_user = $one_user->id;
                $item->from_date = $from;
                $item->to_date = $to;
                $this->db->updateObject('#__pay_period_preserved', $item, 'id_user');

                $res = 'update';
            }
        }





        return $res;
    }
    
    public function saveInputPayPeriodNewUser($user_id)
    {
        $user= JFactory::getUser($user_id);
        $owner_id=$user->owner_id;
        
        $query = "SELECT `from_date`, `to_date` FROM #__pay_period_preserved WHERE `id_user` = '$owner_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObjectList();

        if (!empty($res)) {
            $from_date=$res[0]->from_date;
            $to_date=$res[0]->to_date;
        } else {
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month'));  
        }
        $item = new stdClass();
        $item->id_user = $user_id;
        $item->from_date = $from_date;
        $item->to_date = $to_date;
        $this->db->insertObject('#__pay_period_preserved', $item);




        echo '<pre>';
        print_r($res);
        echo '</pre>';
    }
    
    public function getInputsPayPeriod($u_id)
    {
        $u_id=(int)$u_id;
        $query = "SELECT * FROM #__pay_period_preserved WHERE `id_user` = '$u_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        
        if(empty($res)){
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month')); 
            
            $res['id_user']=$u_id;
            $res['from_date']=$from_date;
            $res['to_date']=$to_date;
            $res=(object)$res;
        }
        return json_encode($res);
    }
    
    public function totalAskedGps($user_id)
    {
        $current_date=date('Y-m-d');
        $query = "SELECT `asked_gps` FROM #__audit_time WHERE `id_user` = '$user_id' AND `date`='".$current_date."' ORDER BY `id` DESC LIMIT 0, 1";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        return $res->asked_gps;
    }
    
    public function newTotal($param){
       $idField = $param['id'];
       $valueField = $param['value']; 
       $yearField = $param['year']; 
       $dateField = $param['date']; 
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       

       /*if(empty($id) && !empty($valueField)){
            $db = & JFactory::getDBO();
            $user = & JFactory::getUser(); 
            $id_user = $user->id;  

            if($id_user > 0){
                $item = new stdClass;
                $item->id = NULL;
                $item->id_user = $id_user;
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                $item->new_hours = $valueField;

                if (!$db->insertObject( '#__audit_time', $item, 'id' )) {
                   echo $db->stderr();
                   return false;
                } else{
                   echo $valueField;
                   return true;
                }
            }
       } else{*/
           //here
            $query = "UPDATE #__audit_time SET $field='$valueField' WHERE id = '$id'";
            $db = & JFactory::getDBO();
            $db->setQuery($query);
            if($db->query()){
                echo $valueField;
            }
      // }    
    }
    
    //old sequrity method. 18.07.2018
    /*public function addNewAuditTimeRow($param, $mode, $action)
    {
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;
      //return $param;
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       
        if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            //manager
            if(in_array(6, $user_joomla->groups)){
               //get owner id
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$id_user'";     
                $this->db->setQuery($query);
                $owner_id=$this->db->loadResult();
            
                //if user is in current manager
                if($user_joomla->owner_id==$owner_id && $id_user>0){
                    $item = new stdClass;
                    if($action==='update'){
                        $item->id = $id; 
                    } if($action==='insert'){
                       $item->id = NULL; 
                    }
                    
                    $item->id_user = $id_user;
                    $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                    //$item->date_logged='';
                    //$item->date_exit='';
                    $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                    $item->ip=$_SERVER["REMOTE_ADDR"];
                
                    switch($mode){
                        case 'description':
                            $item->note = $valueField;
                        break;
                        case 'daytime':
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        break;
                        case 'total':
                            $item->new_hours = $valueField;               
                        break;
                    }      
                    if($action=='update'){
                        $res=$this->db->updateObject('#__audit_time', $item, 'id');
                    } if($action=='insert'){
                        $res=$db->insertObject( '#__audit_time', $item, 'id' );
                    }
                   
                
                    if (!$res) {//db error code
                        $code=4; 
                    } else{//success code
                        $code=0;                
                    }
                    
                } else{//if manager wants to add a record, replacing the user id - return permission denied code
                    $code=1;
                }
            }
            
            //user
            if(in_array(2, $user_joomla->groups)){     
                if($id_user==$user_joomla->id){
                    $item = new stdClass;
                    $item->id = NULL;
                    $item->id_user = $id_user;
                    $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
                    //$item->date_logged='';
                    //$item->date_exit='';
                    $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
                    $item->ip=$_SERVER["REMOTE_ADDR"];
                
                    switch($mode){
                        case 'description':
                            $item->note = $valueField;
                        break;
                        case 'daytime':
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        break;
                        case 'total':
                            $item->new_hours = $valueField;               
                        break;
                    }              
                    $res=$db->insertObject( '#__audit_time', $item, 'id' );
                
                    if (!$res) {//db error code
                        $code=4; 
                    } else{//success code
                        $code=0;                
                    }
                } else{//if user replace original user id
                    $code=1;
                }                        
            } 

            
       } else{//field is empty
           $code=3;
       }
       
        switch($mode){
            case 'description':
                $result=[
                    'new_note'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid(),
                    'action'=>$action
                ];     
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
        }
       
        return $result;
        
    }*/
    
    //not sequrity method
    public function addNewAuditTimeRow($param, $mode, $action)
    {
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pay_period4.html', print_r($param, true), FILE_APPEND | LOCK_EX);
       $idField = $param['id'];
       
       $valueField = $param['value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       $yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['user_id'];
       $id_user=(int)$id_user;
      
       $dateField = explode('.', $dateField);
       $idField = explode('-', $idField);
       $field = $idField[0];
       $id = $idField[1];
       
        //if(!empty($valueField)){
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                  //  
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$_SERVER["REMOTE_ADDR"];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;
                case 'total':
                    $item->new_hours = $valueField;               
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    //here
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/edit_weekends.html', print_r($valueField, true), FILE_APPEND | LOCK_EX);
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                    $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
            }
                   
        //}  

       $code=0;
       
       //need optimized
        switch($mode){
            case 'login_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'exit_hours':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'total':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'daytime':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;  
            case 'afterwork':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'night_time':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'weekend':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'holidays':
                $result=[
                    'new_value'=>$valueField,
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid()
                ];        
            break;
            case 'description':
                $result=[
                    'new_note'=>$valueField,//
                    'code'=>(string)$code,
                    'id_user'=>$id_user,
                    'last_id'=>$db->insertid(),
                    'action'=>$action
                ];     
            break;
           
        }
       
        return $result;
        
    }
    
    public function addOneRowPayPeriod($row_date, $id_user)
    {
        //here
        $item = new stdClass;
        $item->id = NULL; 
        $item->id_user = $id_user;
        if($_SERVER['SERVER_NAME']=='fagverk.curiotime.com'){
            $date_obj=DateTimeWR::createFromFormat('d.m.Y', $row_date);
        } else{
              $date_obj=DateTime::createFromFormat('d.m.Y', $row_date);
        }
        
        $item->date_logged = $date_obj->format('Y-m-d').' 00:00:00';
        //$item->date_exit = $date_obj->format('Y-m-d').' 00:00:01';
        $item->date_exit = '0000-00-00 00:00:00';
        $item->date = $date_obj->format('Y-m-d');
        $item->ip=$_SERVER["REMOTE_ADDR"];
            
        $res=$this->db->insertObject( '#__audit_time', $item, 'id' );      
        $insert_id=$this->db->insertid();
        setcookie('insert_id_pay_period', $insert_id,  time()+3600 * 24 * 365);
    }
    
    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        return $valueField;
    }
    
    public function saveNotePayPeriod($id, $note)
    {
        //update table
        $id=(int)$id;
        $user_joomla = JFactory::getUser();
        $code=0;
        //admin
        if(in_array(8, $user_joomla->groups)){
            $item = new stdClass();
            $item->id =$id;
            $item->note = $note;
            $this->db->updateObject('#__audit_time', $item, 'id');
        } 
        //manager
        if(in_array(6, $user_joomla->groups)){
            //get user id
            $query = "SELECT `id_user` FROM #__audit_time WHERE `id` = '$id'";     
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();
            
            //get owner id
            $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$id_user'";     
            $this->db->setQuery($query);
            $owner_id=$this->db->loadResult();
            
            //if user is in current manager
            if($user_joomla->owner_id===$owner_id){
                $item = new stdClass();
                $item->id =$id;
                $item->note = $note;
                $this->db->updateObject('#__audit_time', $item, 'id');
            } else{
                $code=1;
            }            
        } 
        //user
        if(in_array(2, $user_joomla->groups)){   
            $query = "SELECT `id_user` FROM #__audit_time WHERE `id` = '$id'";     
            $this->db->setQuery($query);
            $id_user=$this->db->loadResult();
            
            if($id_user===$user_joomla->id){
                $query = "UPDATE #__audit_time SET `note`='$note' WHERE `id`='".$id."' AND `id_user`='$user_joomla->id'";       
                $this->db->setQuery($query);
                $this->db->query();
            } else{
                $code=2;
            }                        
        } 
            
        $result=[
            'new_note'=>$note,
            'code'=>(string)$code,
            'id_user'=>$id_user,
            'owner_id'=>$owner_id
            //'user_joomla'=>$user_joomla
        ];
        return $result;
    }
    
    public function convertStringToDateObject($string)
    {
        $test_t2_array=explode(':', $string);
        $test_t2_h=$test_t2_array[0];
        $test_t2_m=$test_t2_array[1];
        
        $res=date("H:i", strtotime($test_t2_h.":".$test_t2_m.":00"));
        return $res;
    }
    
    public function deleteRowId($row_id)
    {
        $query="DELETE FROM `#__audit_time` WHERE `id` = '$row_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getPDFdiapason($from_date, $to_date, $lang)
    {
        $final_array=[];
        $months_array=[
            "January"=>"janúar",
            "February"=>"febrúar",
            "March"=>"mars",
            "April"=>"apríl",
            "May"=>"maí",
            "June"=>"júní",
            "July"=>"júlí",
            "August"=>"ágúst",
            "September"=>"September",
            "October"=>"október",
            "November"=>"nóvember",
            "December"=>"desember"
        ];
        $from_date_obj= DateTime::createFromFormat('d.m.Y', $from_date);
        $to_date_obj= DateTime::createFromFormat('d.m.Y', $to_date);
        $current_date_obj=DateTime::createFromFormat('d.m.Y', date('d.m.Y'));
        $current_month=$current_date_obj->format('m'); 
        $i=0;

        function foo($n) {
            /*  Month number outside the range [1 .. 12]
                * Fits in the appropriate number in this range
                *
                * ___][_______][_______][_______][___
                * -12  -11   0  1    12  13   24  25
                *            <  >
                * -inf .. 0      1 .. +inf
                * >>> % 12       >>> - 1
                * -11 .. 0       0 .. +inf
                * >>> + 12       >>> % 12
                * 1 .. 12        0 .. 11
                *                >>> + 1
                *                1 .. 12
            */
            return ($n <= 0) ? $n % 12 + 12 : ($n - 1) % 12 + 1;
        }

        function bar($count) {
            //last month's number
            $last = gmdate('n') ;

            //the first month number from $ count of previous
            $first = $last - $count + 1;

            /*
             * numbers from the first to the previous
              *converted into natural numbers of months
            */
            return array_map("foo", range($first, $last));
        }
        
        $preview_months_array=bar(12);
           
        foreach($preview_months_array as $preview_month){ 
            if($preview_months_array[$i]>$current_month){
              $final_array[$i]['year']=date('Y', strtotime('last Year'));  
              //echo $preview_months_array[$i-1];
            } else{
               //echo $preview_months_array[$i-1];
               $final_array[$i]['year']=date('Y');
            }
            
            $to_year = ($preview_months_array[$i] == 12 && $from_date_obj->format('d')>'01') ? $final_array[$i]['year']+1 : $final_array[$i]['year'];
            $to_month = ($from_date_obj->format('d')>'01') ? $preview_months_array[$i+1] : $preview_months_array[$i];
            $to_day = ($from_date_obj->format('d')=='01') ? date('t', strtotime($from_date_obj->format('d').'.'.$to_month.'.'.$to_year)) : $to_date_obj->format('d');
              
            $preview_month_obj=DateTime::createFromFormat('d.n.Y', date('01.'.$preview_month.'.Y'));   
            $final_array[$i]['from']=date('d.m.Y', strtotime($from_date_obj->format('d').'.'.$preview_months_array[$i].'.'.$final_array[$i]['year']));
            $final_array[$i]['to']=date('d.m.Y', strtotime($to_day.'.'.$to_month.'.'.$to_year));
            $final_array[$i]['name']=$preview_month_obj->format('F');
            

           $i++;
        } 
        arsort($final_array);
        
        return json_encode([
            'from'=>$from_date,
            'to'=>$to_date,          
            'preview_months_array'=>$preview_months_array,
            'final_array'=>$final_array
        ]);
    }
    
    public function checkBreakItem($break_raw) {
        $arr=explode('+', $break_raw);
        if(count($arr)===1){
            return '0';
        } elseif(count($arr)>1){
            return '1';
        }
    }
    
    public function normalizeBreak($break_raw) {
        if(!empty($break_raw)){
            $arr=explode('+', $break_raw);
            $daytime_break_time = !empty($arr[1]) ? new DateTime($arr[1]) : new DateTime('00:00');
        }
            
        return $daytime_break_time;
    }
    
    public function preparePayPeriodOfHtml($html) {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
        
        
        $totalsJson  =  array();
        if(preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html,$arr)) {
            $totalsJson  = json_decode($arr[1],true);
        }
        
        
        
        $result=[];
        foreach($q1 as $table){
            $dates=$table->find('*[class="api_date"]');
            $totals=$table->find('*[class="api_custom_td_1"]');
            $rows_id=$table->find('*[id="hidden_row_id"]');
             
            $i=0;
            foreach($dates as $date){
                //$result[]=htmlspecialchars($date);
                $result[$i]['date']=$date->plaintext;
                
                $result[$i]['total']=trim(strip_tags($totals[$i]));
                //check cell edited or set color
                $total_edited=strripos($totals[$i], 'red-line');
                
                //check colors
                $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                
                //set cell edited
                if($total_edited==true){
                    $result[$i]['total_edited']=1;
                } 
                
                //set colors
                if($total_color_red==true){
                    $result[$i]['total_color']='red';
                } 
                if($total_color_yellow==true){
                    $result[$i]['total_color']='yellow';
                }
                if($total_color_green==true){
                    $result[$i]['total_color']='green';
                }
                if($total_color_blue==true){
                    $result[$i]['total_color']='blue';
                }
                $result[$i]['row_id']=trim($rows_id[$i]->getAttribute('value'));
                
                $i++;
            }
            
            
           
        }
        $count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
           $result['global_totals']['sick']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        
        
        if(isset($totalsJson['daytime'])) $result['global_totals']['daytime']  = $totalsJson['daytime']['total'];
        if(isset($totalsJson['after_hours'])) $result['global_totals']['afterwork']  = $totalsJson['after_hours']['total'];
        if(isset($totalsJson['night'])) $result['global_totals']['night_time']  = $totalsJson['night']['total'];
        if(isset($totalsJson['weekends'])) $result['global_totals']['weekend']  = $totalsJson['weekends']['total'];
        if(isset($totalsJson['holidays_90'])) $result['global_totals']['holidays_90']  = $totalsJson['holidays_90']['total'];
        if(isset($totalsJson['holidays_45'])) $result['global_totals']['holidays_45']  = $totalsJson['holidays_45']['total'];
        if(isset($totalsJson['sick'])) $result['global_totals']['sick']  = $totalsJson['sick']['total'];
        
        //$result['raw'] = $totalsJson;
        return $result;
    }

    public function prepareOneDateOfHtml($html, $user_id) {
        include_once($_SERVER['DOCUMENT_ROOT'].'/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');
        $dom = str_get_html($html);
        $q1  = $dom->find('table[class="pdf_not_width"]');
        
        $user= & JFactory::getUser($user_id);
        if(in_array(9, $user->groups)){
            $lock_fields=1;
        }
        
        $result=[];
        foreach($q1 as $table){
            $dates=$table->find('*[class="api_date"]');
            $totals=$table->find('*[class="api_custom_td_1"]');
            
            $time_start=$table->find('*[class="date_login"]');
            $time_end=$table->find('*[class="date_logout"]');
            $daytime=$table->find('*[class="api_daytime"]');
            $afterwork=$table->find('*[class="api_afterwork"]');
            $night=$table->find('*[class="api_night"]');
            $weekends=$table->find('*[class="api_weekends"]');
            $holidays=$table->find('*[class="api_holidays"]');
            
            $i=0;
            foreach($dates as $date){
                //$result[]=htmlspecialchars($date);
                $result[$i]['date']=$date->plaintext;
                
                $result[$i]['total']=trim(strip_tags($totals[$i]));
                
                 //check colors
                $total_color_red=strripos($totals[$i], 'pay_period_td_background_red');
                $total_color_yellow=strripos($totals[$i], 'pay_period_td_background_yellow');
                $total_color_green=strripos($totals[$i], 'pay_period_td_background_green');
                $total_color_blue=strripos($totals[$i], 'pay_period_td_background_blue');
                $total_color_gray=strripos($totals[$i], 'pay_period_td_background_gray');
                
                //check cell edited or set color
                $total_edited=strripos($totals[$i], 'red-line');
                //set cell edited
                if($total_edited==true){
                    $result[$i]['total_edited']=1;
                } 
                
                //set colors
                if($total_color_red==true){
                    $result[$i]['total_color']='red';
                } 
                if($total_color_yellow==true){
                    $result[$i]['total_color']='yellow';
                }
                if($total_color_green==true){
                    $result[$i]['total_color']='green';
                }
                if($total_color_blue==true){
                    $result[$i]['total_color']='blue';
                }
                if($total_color_gray==true){
                    $result[$i]['total_color']='gray';
                }
                
                $result[$i]['in']=trim(strip_tags($time_start[$i]));
                $result[$i]['out']=trim(strip_tags($time_end[$i]));
                $weekends_row=trim(strip_tags($weekends[$i]));
                $holidays_row=trim(strip_tags($holidays[$i]));
                
                //for fix this bug http://prntscr.com/pdwba1- bug fixed
                //if(empty($weekends_row) && empty($holidays_row)){
                    $result[$i]['daytime']=trim(strip_tags($daytime[$i]));
                
                    $daytime_edited_class=strripos($daytime[$i], 'red-line');
                    if($daytime_edited_class==true){
                        $result[$i]['daytime_edited']=1;
                    }
                
                    $result[$i]['afterwork']=trim(strip_tags($afterwork[$i]));
                    $afterwork_edited_class=strripos($afterwork[$i], 'red-line');
                    if($afterwork_edited_class==true){
                        $result[$i]['afterwork_edited']=1;
                    }
                
                    $result[$i]['night_time']=trim(strip_tags($night[$i]));
                    $night_edited_class=strripos($night[$i], 'red-line');
                    if($night_edited_class==true){
                        $result[$i]['night_edited']=1;
                    }
                //}
                
                $result[$i]['weekends']=$weekends_row;
                $weekend_edited_class=strripos($weekends[$i], 'red-line');
                if($weekend_edited_class==true){
                    $result[$i]['weekend_edited']=1;
                }
                
                $result[$i]['holidays']=$holidays_row;
                $holidays_edited_class=strripos($holidays[$i], 'red-line');
                if($holidays_edited_class==true){
                    $result[$i]['holidays_edited']=1;
                }
               
                $result[$i]['lock_fields']=$lock_fields;
                
                $i++;
            }
            
            
           
        }
        $count=count($result);
        
        foreach($dom->find('*[class="total-h"]') as $ee){
           $result['global_totals']['total']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-daytime"]') as $ee){
           $result['global_totals']['daytime']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-afterwork"]') as $ee){
           $result['global_totals']['afterwork']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-night_time"]') as $ee){
           $result['global_totals']['night_time']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-weekend"]') as $ee){
           $result['global_totals']['weekend']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays90"]') as $ee){
           $result['global_totals']['holidays_90']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays45"]') as $ee){
           $result['global_totals']['holidays_45']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-holidays_sick"]') as $ee){
           $result['global_totals']['sick']= trim($ee->plaintext);
        }
        foreach($dom->find('*[class="t-breaks"]') as $ee){
           $result['global_totals']['break']= trim($ee->plaintext);
        }
        return $result;
    }
    
    private function checkWeekend($date) { 
        return (date('N', strtotime($date)) >= 6);
    }
    
    private function checkHoliday($date) {
        $query_h = "SELECT title,  CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop
                    FROM #__holiday WHERE date = '$date' AND published = '1' AND language = 'all'";
        $this->db->setQuery($query_h);
        $holiday_h = $this->db->loadObjectList();
        
        return count($holiday_h)>0;
    }
    
    public function setOneDatePP4_2($date, $id, $post, $id_user, $client_ip) {        
        // convert date
        $dateArr    =   explode(".",$date);
        $date       =   $dateArr[2]."-".$dateArr[1]."-".$dateArr[0];
        $time       =   strtotime($date);
        $date       =   date("Y-m-d",$time);
        
        $id  = intval($id);
        $query= 'SELECT * FROM #__audit_time WHERE `id` = "'.$id.'"';
        $this->db->setQuery($query);
        $item = $this->db->loadObject();
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_weekend_loock.html', print_r($item, true), FILE_APPEND | LOCK_EX);
       
        if($id > 0 && empty($item)) {
            throw new Exception("Record Audit Time [{$id}] not found.");
        }
        if(empty($item)) {
            $item =  new stdClass();
            $item->date  =  $date;
            $item->id_user  =   $id_user;
            $item->date_logged  =   date("Y-m-d 00:00:00",$time);
            $item->date_exit    =   date("Y-m-d 00:00:01",$time);
            $item->ip           =   $client_ip;
        } 
        
        $result_check_weekend=$this->checkWeekend($item->date);
        $result_check_holidays=$this->checkHoliday($item->date);
        
        if(is_array($post)) {
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_weekend_loock.html', print_r($post, true), FILE_APPEND | LOCK_EX);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_weekend_loock.html', print_r($result_check_holidays, true), FILE_APPEND | LOCK_EX);
            
            foreach ($post as $k=>$v) {
                if($k   !=  'description')  {
                    $v =   $this->autocompletion($v);
                }
                $valueField  = $v;
                switch($k){
                    /*case 'login_hours':
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_logged = $newValue;
                        $item->date_logged_edit='1';                   
                    break;
                    case 'exit_hours':
                        if($id <=0 ){
                            $item->date_logged = date("Y-m-d 00:00:00",$time);
                        }
                        $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                        $item->date_exit = $newValue;
                        $item->date_exit_edit='1';                   
                    break;*/
                    //
                    case 'total':
                        $item->new_hours = $valueField;               
                    break;
                    case 'daytime':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'afterwork':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_afterwork = $valueField;
                            $item->afterwork_edit='1';
                            $item->afterwork_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'night_time':
                        if($result_check_weekend!=1 && $result_check_holidays!=1){
                            $item->new_night_time = $valueField;
                            $item->night_time_edit='1';
                            $item->night_time_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'weekend':
                        if($result_check_weekend==1){
                            $item->new_weekend = $valueField;
                            $item->weekend_edit='1';
                            $item->weekend_edited_date=date('Y-m-d H:i:s');
                        }
                    break;
                    case 'holidays':
                        if($result_check_holidays==1){
                            $item->new_holidays = $valueField;
                            $item->holidays_edit='1';
                            $item->holidays_edited_date=date('Y-m-d H:i:s');
                        } 
                    break;
                    case 'description':
                        //$item->note = $valueField;
                    break;
                }
            }
        }
        if($id > 0) {
            $action  =  "update";
            $res    =   $this->db->updateObject('#__audit_time', $item, 'id');
        } else {
            $action  =  "insert";
            $res    =   $this->db->insertObject( '#__audit_time', $item, 'id' );
            $id     =   $this->db->insertid();
        }        
        $code   =   0;
        return array    (
            'code'=>(string)$code,
            'local_user_id'=> intval($id_user),
            'action'=>$action,
            'last_id'=>$id,
            'post'=>$post
        );
        return $item;
    }
    
    
    public function setOneDatePP4($param, $action)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pay_period4.html', print_r($param, true), FILE_APPEND | LOCK_EX);
        //exit;

       $valueField = $param['new_value']; 
       $valueField=trim($valueField);
       $valueField= strip_tags($valueField);
       
       //$yearField = $param['year']; 
       $dateField = $param['date']; 
       $id_user=$param['u_id'];
       $id_user=(int)$id_user;
      
       $dateField = explode('.', $dateField);
       $yearField=$dateField[2];
       //$idField = $param['row_id'];
       //$idField = explode('-', $idField);
       
       $field = $param['cell_name'];
       $mode=$field;
       $id = $param['row_id'];
       
        
            $db = $this->db;
            $user_joomla = & JFactory::getUser(); 
            $id_user0 = $user_joomla->id;  
            
            $item = new stdClass;
            if($action==='update'){
                $item->id = $id; 
            } if($action==='insert'){
                $item->id = NULL; 
            }
                   
            $item->id_user = $id_user;
            if( $action!=='update' && $mode!='login_hours' && $mode!='exit_hours'){
                $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:01';
            }
            
            //$item->date_logged='';
            //$item->date_exit='';
            $item->date = $yearField.'-'.$dateField[1].'-'.$dateField[0];
            $item->ip=$param['client_ip'];
                
            if($mode!='description'){
                //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                $valueField=$this->autocompletion($valueField);
            }
            
            switch($mode){
                //this fields (login and hours) locked in app
                /*case 'login_hours':
                    //date= date from client request plus new H:i
                    if($action!='update'){
                       // $item->date_exit = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 23:59:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
       
                    $item->date_logged = $newValue;
                    $item->date_logged_edit='1';                   
                break;
                case 'exit_hours':
                    if($action!='update'){
                        $item->date_logged = $yearField.'-'.$dateField[1].'-'.$dateField[0].' 00:00:00';
                    }
                    $newValue = date('Y-m-d', strtotime($item->date)).' '.$valueField;
                     
                    $item->date_exit = $newValue;
                    $item->date_exit_edit='1';                   
                break;*/
                case 'total':
                    $item->new_hours = $valueField;               
                break;
                case 'daytime':
                    $item->new_daytime = $valueField;
                    $item->daytime_edit='1';
                    $item->daytime_edited_date=date('Y-m-d H:i:s');
                break;
                case 'afterwork':
                    $item->new_afterwork = $valueField;
                    $item->afterwork_edit='1';
                    $item->afterwork_edited_date=date('Y-m-d H:i:s');
                break;
                case 'night_time':
                    $item->new_night_time = $valueField;
                    $item->night_time_edit='1';
                    $item->night_time_edited_date=date('Y-m-d H:i:s');
                break;
                case 'weekend':
                    //here
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/edit_weekends.html', print_r($valueField, true), FILE_APPEND | LOCK_EX);
                    $item->new_weekend = $valueField;
                    $item->weekend_edit='1';
                    $item->weekend_edited_date=date('Y-m-d H:i:s');
                break;
                case 'holidays':
                    $item->new_holidays = $valueField;
                    $item->holidays_edit='1';
                    $item->holidays_edited_date=date('Y-m-d H:i:s');
                break;
                case 'description':
                   // $item->note = $valueField;
                break;
            }
            
            if($action=='update'){
                $res=$this->db->updateObject('#__audit_time', $item, 'id');
            } if($action=='insert'){
                $res=$this->db->insertObject( '#__audit_time', $item, 'id' );
            }
                   
         

       $code=0;

       return [
            'new_value'=>$valueField,
            'code'=>(string)$code,
            'id_user'=>$id_user,
            'action'=>$action,
            'last_id'=>$db->insertid()
        ];         
    }
    
    public function checkID($row_id, $user_id){
        $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `id`="'.$row_id.'"';
        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        
        if(empty($res)){
            return 0;
        } else{
            return 1;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/pay_period4.html', print_r($res, true), FILE_APPEND | LOCK_EX);
    }
    
    public function getManagerId($user_id){
        $user=& JFactory::getUser((int)$user_id);
        return $user->owner_id;
    }
    
    public function newCalcColoredDays($user_id, $status, $from, $to, $note)
    {
        $date_from= DateTime::createFromFormat('d.m.Y', $from);
        $current_month=$date_from->format('n');
        $current_year=$date_from->format('Y');
        
        $date_to= DateTime::createFromFormat('d.m.Y', $to);
        $month_to=$date_to->format('n');
        $year_to=$date_to->format('Y');
        
        //make dates array
        $begin = new DateTime( $date_from->format('Y-m-d') );
        $end = new DateTime( $date_to->format('Y-m-d') );
        $end = $end->modify( '+1 day' ); 
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($begin, $interval ,$end);
        
        //echo 'from= '.$date_from->format('Y-m-d').'<br/>';
        //echo 'to= '.$date_to->format('Y-m-d');

        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" AND (';
        
        foreach($daterange as $date){     
            $query.='`month`="'.$date->format('n').'" AND `status`="'.$status.'" AND `year`="'.$date->format('Y').'" AND `day`="'.$date->format('j').'" OR ';
        }
        $query = chop($query, ' OR');
        $query.=')';
        
        $this->db->setQuery( $query );
        $all_days_current_month = $this->db->loadObjectList(); 

        $prepare_array=[];
        $i=0;
        $count_day_for_audit_time=0;
        
        if(!empty($note)){
            $note=trim($this->db->escape($note));
        }
        
        foreach($all_days_current_month as $k=>$v){      
            $day=$v->day;
            $month=$v->month;
            $year=$v->year;
            
            $prepare_array[$i]['color']=$status;
            $prepare_array[$i]['date']=DateTime::createFromFormat('Y.n.j', $year.'.'.$month.'.'.$day)->format('Y-m-d');
            
            if(!empty($note)){
                $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'" AND `note` LIKE "%'.$note.'%"';
                 //$query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            } else{
                $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$prepare_array[$i]['date'].'"';
            }
            //echo $query;
            $this->db->setQuery( $query );
            $count_items_array= $this->db->loadAssocList(); 
            
            if(!empty($note)){
                /*echo '<pre>';
                print_r($count_items_array);
                echo '</pre>';*/
            }
            //echo $query.'<br/>';
            if(count($count_items_array)>1){//if there are more than one login for one date
                $j=0;
                foreach($count_items_array as $one_item){  

                    if($j>0 && $one_item[$j-1]!=$prepare_array[$i]['date']){
                        
                    } else{
                       
                            $count_day_for_audit_time++;
                      
                    }
                    
                    $j++;
                }           
            } else{
              
                    $count_day_for_audit_time++;
            
                
            }                    
            $i++;                
        }
         
        return $count_day_for_audit_time;
    }
    
    public function newCalcColoredDaysSearchResult($user_id, $status, $from, $to, $dayNumber)
    {
       $count_day_for_audit_time=0;
       foreach($dayNumber as $one_date){
            $query='SELECT * FROM #__audit_time WHERE `id_user`="'.$user_id.'" AND `date`="'.$one_date->date.'" AND `note`';
           
            //echo $query;
            $this->db->setQuery( $query );
            $count_items_array= $this->db->loadAssocList(); 
            $count_day_for_audit_time++;
       }
       
       return $count_day_for_audit_time;
    }
}
