<?php
/**
 * @version     1.0.0
 * @package     plg_vmpayment_korta
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Eir�kur Haraldsson <eiki25@gmail.com> - http://www.ozon.is
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */  
 
// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
 
if (!class_exists ('vmPSPlugin')) {
	require(JPATH_VM_PLUGINS . DS . 'vmpsplugin.php');
}
class plgVmPaymentKorta extends vmPSPlugin
{
    /**
     * Constructor
     *
     * For php4 compatibility we must not use the __constructor as a constructor for
     * plugins because func_get_args ( void ) returns a copy of all passed arguments
     * NOT references.  This causes problems with cross-referencing necessary for the
     * observer design pattern.
     */
    function plgVmPaymentKorta( &$subject, $config )
    {             
		parent::__construct ($subject, $config);

		$this->_loggable = TRUE;
		$this->_tablepkey = 'id';
		$this->_tableId = 'id';
		$this->tableFields = array_keys ($this->getTableSQLFields ());
		$varsToPush = $this->getVarsToPush ();

		$this->setConfigParameterable ($this->_configTableFieldName, $varsToPush);
    }
    
    /*    
        Backend function to initialize parameter so configuration can be save in payment table 
    */
//         function plgVmDeclarePluginParamsPayment ($name, $id, &$data)
//        {
//		return $this->declarePluginParams ('payment', $name, $id, $data);
//	}
//
//    /*    
//        Backend function to initialize parameter so configuration can be save in payment table 
//    */
//	function plgVmSetOnTablePluginParamsPayment ($name, $id, &$table)
//        {  
//		return $this->setOnTablePluginParams ($name, $id, $table);
//	}    
    
        
        
        
        function plgVmDeclarePluginParamsPaymentVM3( &$data) {
		return $this->declarePluginParams('payment', $data);
	}

	function plgVmSetOnTablePluginParamsPayment($name, $id, &$table) {
		return $this->setOnTablePluginParams($name, $id, $table);
	}
        
        
        
        
        
        
    /*
        Create the table for this plugin (for report purpose) if it does not yet exist. The name of table will be #_virtuemart_payment_plg_<paymentplugin_name>    
    */
	protected function getVmPluginCreateTableSQL () {

		return $this->createTableSQL ('Korta Payment Table');
	}

    /*
        Returns field for Report table    
    */
	function getTableSQLFields () {

		$SQLfields = array(
			'id'                                         => 'int(1) UNSIGNED NOT NULL AUTO_INCREMENT',
			'virtuemart_order_id'                        => 'int(1) UNSIGNED',
			'order_number'                               => 'char(64)',
			'virtuemart_paymentmethod_id'                => 'mediumint(1) UNSIGNED',
			'payment_name'                               => 'varchar(5000)',
		    'payment_order_total'                        => 'decimal(15,5) NOT NULL DEFAULT \'0.00000\'',
		    'payment_currency'                           => 'char(3) ',            
			'user_session'                             => 'char(255)',
			'cost_per_transaction'                       => 'decimal(10,2)',
			'cost_percent_total'                         => 'char(10)',
			'tax_id'                                     => 'smallint(1)',
			'korta_reference'   => 'char(64)',
			'korta_cardbrand'       => 'char(255)',
			'korta_card4'        => 'char(255)',
            'korta_time'   => 'char(30)',
		);
		return $SQLfields;
	}

    /**
	 * Create the table for this plugin if it does not yet exist.
	 * This functions checks if the called plugin is active one.
	 * When yes it is calling the standard method to create the tables
	 */
	function plgVmOnStoreInstallPaymentPluginTable ($jplugin_id) {
	
		return $this->onStoreInstallPluginTable ($jplugin_id);
	}
    
	/**
	 * This event is fired after the payment method has been selected. It can be used to store
	 * additional payment info in the cart.
	 *
	 * @author Max Milbers
	 * @author Val�rie isaksen
	 *
	 * @param VirtueMartCart $cart: the actual cart
	 * @return null if the payment was not selected, true if the data is valid, error message if the data is not vlaid
	 *
	 */
	public function plgVmOnSelectCheckPayment (VirtueMartCart $cart, &$msg) {

		return $this->OnSelectCheck ($cart);
	}

	/**
	 * plgVmDisplayListFEPayment
	 * This event is fired to display the pluginmethods in the cart (edit shipment/payment) for exampel
	 *
	 * @param object  $cart Cart object
	 * @param integer $selected ID of the method selected
	 * @return boolean True on succes, false on failures, null when this plugin was not selected.
	 * On errors, JError::raiseWarning (or JError::raiseError) must be used to set a message.
	 *
	 * @author Valerie Isaksen
	 * @author Max Milbers
	 */
	public function plgVmDisplayListFEPayment (VirtueMartCart $cart, $selected = 0, &$htmlIn) {

		return $this->displayListFE ($cart, $selected, $htmlIn);
	}
        
	/**    
	 * plgVmOnCheckAutomaticSelectedPayment
	 * Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	 * The plugin must check first if it is the correct type
	 *
	 * @author Valerie Isaksen
	 * @param VirtueMartCart cart: the cart object
	 * @return null if no plugin was found, 0 if more then one plugin was found,  virtuemart_xxx_id if only one plugin is found
	 *
	 */         
	// Checks how many plugins are available. If only one, the user will not have the choice. Enter edit_xxx page
	// The plugin must check first if it is the correct type
	function plgVmOnCheckAutomaticSelectedPayment(VirtueMartCart $cart, array $cart_prices = array(), &$paymentCounter) {    
		return $this->onCheckAutomaticSelected($cart, $cart_prices, $paymentCounter);        
	}
        
    
	/**
	 * Check if the payment conditions are fulfilled for this payment method
	 *
	 * @author: Valerie Isaksen
	 *
	 * @param $cart_prices: cart prices
	 * @param $payment
	 * @return true: if the conditions are fulfilled, false otherwise
	 *
	 */
	protected function checkConditions ($cart, $method, $cart_prices)
    {            
        return TRUE;
    }
    
	/**
     * Calculation for using this payment method and final cost with tax calculation etc    
	 * @param VirtueMartCart $cart
	 * @param                $method
	 * @param                $cart_prices
	 * @return int
	 */
	function getCosts (VirtueMartCart $cart, $method, $cart_prices) {

		if (preg_match ('/%$/', $method->cost_percent_total)) {
			$cost_percent_total = substr ($method->cost_percent_total, 0, -1);
		} else {
			$cost_percent_total = $method->cost_percent_total;
		}
		return ($method->cost_per_transaction + ($cart_prices['salesPrice'] * $cost_percent_total * 0.01));
	}
    
	/*
    * plgVmonSelectedCalculatePricePayment
    * Calculate the price (value, tax_id) of the selected method
    * It is called by the calculator
    * This function does NOT to be reimplemented. If not reimplemented, then the default values from this function are taken.
    * @author Valerie Isaksen
    * @cart: VirtueMartCart the current cart
    * @cart_prices: array the new cart prices
    * @return null if the method was not selected, false if the shiiping rate is not valid any more, true otherwise
    */
	public function plgVmonSelectedCalculatePricePayment (VirtueMartCart $cart, array &$cart_prices, &$cart_prices_name) {

		return $this->onSelectedCalculatePrice ($cart, $cart_prices, $cart_prices_name);
	}    
    
         
	/**
     * Process after buyer set confirm purchase in check out, it loads a new page
	 * @param $cart
	 * @param $order
	 * @return bool|null
	 */     
	function plgVmConfirmedOrder ($cart, $order)
    {
        if (!class_exists ('VirtueMartCart'))
        {
			    require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
        }
    
		if (!($method = $this->getVmPluginMethod ($order['details']['BT']->virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}    
        
        $cart = VirtueMartCart::getCart();
                            
        if ($this->validatePaymentMethod($method))
        {          
		    // Prepare data that should be stored in the database
		    $session = JFactory::getSession ();
		    $return_context = $session->getId ();            
		    $dbValues['user_session'] = $return_context;
		    $dbValues['order_number'] = $order['details']['BT']->order_number;
		    $dbValues['payment_name'] = $this->renderPluginName ($method, $order);
		    $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
		    $dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		    $dbValues['cost_percent_total'] = $method->cost_percent_total;
		    $dbValues['payment_currency'] = $method->payment_currency;
		    $dbValues['payment_order_total'] = $totalInPaymentCurrency;
		    $dbValues['tax_id'] = $method->tax_id;
                    
		    $this->storePSPluginInternalData ($dbValues);  
            VmConfig::loadJLang('com_virtuemart_orders',TRUE);
        
        
            $html = $this->renderByLayout ('buildpaymentlayout', array(				
                'pm' => $order['details']['BT']->virtuemart_paymentmethod_id,
                'reference' => $order['details']['BT']->order_number                
			));        
                            
            JRequest::setVar ('html', $html);
        }        
    }
        
	/**
	 * @param $virtuemart_paymentmethod_id
	 * @param $paymentCurrencyId
	 * @return bool|null
	 */
	function plgVmgetPaymentCurrency ($virtuemart_paymentmethod_id, &$paymentCurrencyId) {

		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL; // Another method was selected, do nothing
		}
		if (!$this->selectedThisElement ($method->payment_element)) {
			return FALSE;
		}
		$this->getPaymentCurrency ($method);
		$paymentCurrencyId = $method->payment_currency;
	}    
    
	/**
     * Renders the content of the Payment IFRAME
	 * @param $html
	 * @return bool|null|string
	 */  
    function plgVmOnPaymentNotification ()
    {                   		
		if (!class_exists ('shopFunctionsF'))
        {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}                
		if (!class_exists ('VirtueMartModelOrders'))
        {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}   
		if (!class_exists('CurrencyDisplay'))
        {
            require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');        
        }           
    
		// the payment itself should send the parameter needed.
		$virtuemart_paymentmethod_id = JRequest::getInt ('pm', 0);		
		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL;
		} // Another method was selected, do nothing

		if (!$this->selectedThisElement ($method->payment_element)) {
			return NULL;
		}        
        
		// platform params and payment data
		$data = JRequest::get ('get');
        		
		if (!array_key_exists ('reference', $data) || !isset($data['reference'])) {			
			return NULL; // Another method was selected, do nothing
		}
                                
        // Get Order Id
		$virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($data['reference']);    
                       
        // Get Order Plugin Data
		if (!($payment = $this->getDataByOrderId ($virtuemart_order_id))) {			
            JError::raiseWarning(500, 'Error getting Order Plugin Data');
			return;
		}      
                       
        // Get Payment Method
		$method = $this->getVmPluginMethod ($payment->virtuemart_paymentmethod_id);
		if (!$this->selectedThisElement ($method->payment_element)) {			
			return FALSE;
		}    
        
        // Get Order
		$modelOrder = VmModel::getModel ('orders');
		$order = $modelOrder->getOrder ($virtuemart_order_id);        
            
        // Get Currency
        $this->getPaymentCurrency ($method);
		$currency_code_3 = shopFunctions::getCurrencyByID ($method->payment_currency, 'currency_code_3');        
        
        // Get Amount        
		$paymentCurrency = CurrencyDisplay::getInstance ($method->payment_currency);
		$totalInPaymentCurrency = round ($paymentCurrency->convertCurrencyTo ($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);        
        
        // Get Description
        $itemNames = array();
        foreach($order['items'] as $item)
        {
            array_push($itemNames, $item->order_item_name);            
        }
        $description = implode(', ', $itemNames);       
        
        // DEBUG
        if ($_SERVER['REMOTE_ADDR'] == 'localhost')
        {
            $method->url = JURI::root() . 'plugins/vmpayment/korta/korta/kortatestingform.php';
        }
    
        // Assign view variables
        $item = new stdClass();
        $item->amount = $totalInPaymentCurrency;
        $item->currency = $currency_code_3;        
        $item->description = $description;
        $item->reference = $data['reference'];
        
        
        // Rafr�n undirskrift til a� KORTA geti sta�fest a� grei�slan kemur fr� ��r !
        $md5key = htmlentities($item->amount . $item->currency . $method->merchant . $method->terminal . $description . $method->secretcode);
                        
        $checkvaluemd5 = md5($md5key);
        
        // Extra setting not in GUI                
        $downloadurl = JURI::root() .'index.php?option=com_virtuemart&view=pluginresponse&task=pluginresponsereceived&pm='.$order['details']['BT']->virtuemart_paymentmethod_id;
        
        $html = $this->renderByLayout ('displaypayment', array(
			'paymentsettings' => $method,            
            'downloadurl' => $downloadurl,            
            'item' => $item,
            'checkvaluemd5' => $checkvaluemd5
		));
                        
        // Displya Korta IFRAME content
        echo($html);
        

        
        // Get rid of template
        $app = JFactory::getApplication();
        $app->close();
    }
        
	/**
     * Process after Korta iframe is redirected after successful payment
	 * @param $html
	 * @return bool|null|string
	 */
	function plgVmOnPaymentResponseReceived (&$html)
    {		
		if (!class_exists ('shopFunctionsF'))
        {
			require(JPATH_VM_SITE . DS . 'helpers' . DS . 'shopfunctionsf.php');
		}        
		if (!class_exists ('VirtueMartModelOrders'))
        {
			require(JPATH_VM_ADMINISTRATOR . DS . 'models' . DS . 'orders.php');
		}
		if (!class_exists('CurrencyDisplay'))
        {
            require(JPATH_VM_ADMINISTRATOR . DS . 'helpers' . DS . 'currencydisplay.php');        
        }          
        if (!class_exists ('VirtueMartCart'))
        {
			    require(JPATH_VM_SITE . DS . 'helpers' . DS . 'cart.php');
        }        
        VmConfig::loadJLang('com_virtuemart_orders',TRUE);
        
		// the payment itself should send the parameter needed.
		$virtuemart_paymentmethod_id = JRequest::getInt ('pm', 0);		
		if (!($method = $this->getVmPluginMethod ($virtuemart_paymentmethod_id))) {
			return NULL;
		} // Another method was selected, do nothing

		if (!$this->selectedThisElement ($method->payment_element)) {
			return NULL;
		}        
    
		// The payment itself should send the parameter needed.		
		$order_number = JRequest::getString('reference', 0);        
        if (empty($order_number))
        {            
            JError::raiseWarning(500, 'Order Reference number missing');
            RETURN NULL;
        }
                            
        // Get Order Id
		if (!($virtuemart_order_id = VirtueMartModelOrders::getOrderIdByOrderNumber ($order_number))) {            
			return NULL;
		} 
                		
        // Get Order Plugin Data
		if (!($payment = $this->getDataByOrderId ($virtuemart_order_id))) {			
            JError::raiseWarning(500, 'Error getting Order Plugin Data');
			return NULL;
		}      
                        
        // Get Payment Method
		$method = $this->getVmPluginMethod ($payment->virtuemart_paymentmethod_id);
		if (!$this->selectedThisElement ($method->payment_element)) {			
			return FALSE;
		} 
        
        // Get Order
		$modelOrder = VmModel::getModel ('orders');
		$order = $modelOrder->getOrder ($virtuemart_order_id);      
                        
        // Get Currency
        $this->getPaymentCurrency ($method);
		$currency_code_3 = shopFunctions::getCurrencyByID ($method->payment_currency, 'currency_code_3');             
        
        // Get Cart
        $cart = VirtueMartCart::getCart();
        
        // Get Amount        
		$paymentCurrency = CurrencyDisplay::getInstance ($method->payment_currency);
		$totalInPaymentCurrency = round ($paymentCurrency->convertCurrencyTo ($method->payment_currency, $order['details']['BT']->order_total, FALSE), 2);        
        
        // Get Description
        $itemNames = array();
        foreach($order['items'] as $item)
        {
            array_push($itemNames, $item->order_item_name);            
        }
        $description = implode(', ', $itemNames);     
                        
        // Get Vendor
		if (!class_exists ('VirtueMartModelVendor')) {
			JLoader::import ('vendor', JPATH_ADMINISTRATOR . DS . 'components' . DS . 'com_virtuemart' . DS . 'models');
		}
		$modelVendor = VmModel::getModel ('vendor'); 
        $vendor = $modelVendor->getVendor($order['details']['BT']->virtuemart_vendor_id);        
                                                                                                                                                                                        
        // Gildi sem koma � forminu sem sent er fr� Netgrei�slum KORTA
        $korta_reference = JRequest::getString('reference');
        $korta_checkvaluemd5 = JRequest::getString('checkvaluemd5');
        $korta_downloadmd5 = JRequest::getString('downloadmd5');
        $korta_time = JRequest::getString('time');
        $korta_cardbrand = JRequest::getString('cardbrand');
        $korta_card4 =  JRequest::getString('card4');
        
     
        $query = "SELECT payment_params FROM #__virtuemart_paymentmethods WHERE payment_element = 'korta'";
        $db =& JFactory::getDBO();
        $db->setQuery( $query );
        $payment_params = $db->loadResult();

       
        if(strstr($payment_params, 'testing')){
           $my_downloadmd5 = htmlentities('2' . $korta_checkvaluemd5  . $korta_reference . $method->secretcode . 'TEST');     
        }
        else{
           $my_downloadmd5 = htmlentities('2' . $korta_checkvaluemd5  . $korta_reference . $method->secretcode);      
        }
                              
               
        $my_downloadmd5 = md5($my_downloadmd5);
                                                            
        if ($my_downloadmd5 == $korta_downloadmd5)
        {                                                    
            $html = $this->renderByLayout ('paymentreceived', array(
			    'order' => $order,
                'currency' => $paymentCurrency,
                'korta_reference' => $korta_reference,
                'korta_time' => $korta_time,
                'korta_cardbrand' => $korta_cardbrand,
                'korta_card4' => $korta_card4,
                'vendor' => $vendor,
                'currency_code_3' => $currency_code_3,
                'amount' => $totalInPaymentCurrency
		    ));        
                                                                    
            if (empty($payment->korta_reference))
            {
                // Update PluginInternal Data + (CardBrand and CardLast4Digits and Reference)
		        $session = JFactory::getSession ();
		        $return_context = $session->getId ();            
		        $dbValues['user_session'] = $return_context;            
                $dbValues['virtuemart_order_id'] = $virtuemart_order_id;
		        $dbValues['order_number'] = $order['details']['BT']->order_number;
		        $dbValues['payment_name'] = $this->renderPluginName ($method, $order);
		        $dbValues['virtuemart_paymentmethod_id'] = $cart->virtuemart_paymentmethod_id;
		        $dbValues['cost_per_transaction'] = $method->cost_per_transaction;
		        $dbValues['cost_percent_total'] = $method->cost_percent_total;
		        $dbValues['payment_currency'] = $method->payment_currency;
		        $dbValues['payment_order_total'] = $totalInPaymentCurrency;
		        $dbValues['tax_id'] = $method->tax_id;            
		        $dbValues['korta_reference'] = $korta_reference;
                $dbValues['korta_cardbrand'] = $korta_cardbrand;
                $dbValues['korta_card4'] = $korta_card4;            		    
                $dbValues['korta_time'] = $korta_time;        
                $this->storePSPluginInternalData ($dbValues, 'virtuemart_order_id', TRUE);
                        
                // Update Order Status to Completed            
			    $order['customer_notified'] = 1;			
			    $order['order_status'] = $method->status_success;
			    $order['comments'] = JText::sprintf ('VMPAYMENT_KORTA_PAYMENT_STATUS_CONFIRMED', $order_number);            
			    $modelOrder->updateStatusForOneOrder ($order['details']['BT']->virtuemart_order_id, $order, TRUE);                   
            }                                                                                                                                                            		                                                                         
        }
        else
        {  
            
            echo 'Electronic signature does not match, is someone hacking ? <br/>';
           
            //echo('�ryggisundirskrift passar ekki, svindl � gangi ?');               
        } 

        // Empty Cart
        $cart->emptyCart ();                    
                
        echo($html);
        
        // Get rid of template
        $app = JFactory::getApplication();
        $app->close();                        
    }    
    
	/**
	 * Display stored payment data for an order
	 *
	 * @see components/com_virtuemart/helpers/vmPaymentPlugin::plgVmOnShowOrderPaymentBE()
	 */
	function plgVmOnShowOrderBEPayment ($virtuemart_order_id, $virtuemart_payment_id) {

		if (!$this->selectedThisByMethodId ($virtuemart_payment_id)) {
			return NULL; // Another method was selected, do nothing
		}
		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}
		$html = '<table class="adminlist">' . "\n";
		$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE ($this->_name .'_TIMEOFPAYMENT', $paymentTable->korta_time);
		$html .= $this->getHtmlRowBE ($this->_name .'_REFERENCE', $paymentTable->korta_reference);
		$html .= $this->getHtmlRowBE ($this->_name .'_CARDBRAND', $paymentTable->korta_cardbrand);
        $html .= $this->getHtmlRowBE ($this->_name .'_CARD', 'xxxxxxxxxx'.$paymentTable->korta_card4);		
		$html .= '</table>' . "\n";
		return $html;
	}    
    
	/**
	 * Display stored payment data for an order
	 *
	 * @see components/com_virtuemart/helpers/vmPaymentPlugin::plgVmOnShowOrderPaymentBE()
	 */
                       
	function plgVmOnShowOrderFEPayment ($virtuemart_order_id, $virtuemart_payment_id) {

        $this->onShowOrderFE($virtuemart_order_id, $virtuemart_paymentmethod_id, $payment_name);
    
		if (!$this->selectedThisByMethodId ($virtuemart_payment_id)) {
			return NULL; // Another method was selected, do nothing
		}
		if (!($paymentTable = $this->getDataByOrderId ($virtuemart_order_id))) {
			return NULL;
		}
		$html = '<table width="100%" border="0" cellpadding="0" cellspacing="0" class="html-email">' . "\n";
		//$html .= $this->getHtmlHeaderBE ();
		$html .= $this->getHtmlRowBE ($this->_name .'_TIMEOFPAYMENT', $paymentTable->korta_time);
		$html .= $this->getHtmlRowBE ($this->_name .'_REFERENCE', $paymentTable->korta_reference);
		$html .= $this->getHtmlRowBE ($this->_name .'_CARDBRAND', $paymentTable->korta_cardbrand);
                $html .= $this->getHtmlRowBE ($this->_name .'_CARD', 'xxxxxxxxxx'.$paymentTable->korta_card4);		
		$html .= '</table><br/>' . "\n";
                if($_REQUEST['task'] == 'pluginresponsereceived'){
                     echo($html);
                     echo '<br><a href="/" target="_top" style="color:#07b!important; font-size: 16px; text-decoration: none;">'.JText::_('VMPAYMENT_KORTA_GO_TO_HOME').'</a><br>';
                }
       
        
        
		return $html;
	}        
    
    function getfullName($first, $middle, $last)
    {
        $fullName = $first;
        
        if (!empty($middle))
        {
            $fullName .= ' '.$middle;
        }               
        
        if (!empty($last))
        {
            $fullName .= ' '.$last;
        }        
        return $fullName;
    }
    
	/**
     * Validates parameters set in Korta payment plugin
	 * @param $method
	 * @return true if all parameters are valid
	 */    
    function validatePaymentMethod($method)
    {        
        $returnValue = true;
		if (empty($method->merchant)) {
			vmWarn (JText::_ ('VMPAYMENT_KORTA_MERCHANT_NOT_SET'));
			$returnValue = false;
		}
        
		if (empty($method->terminal)) {
			vmWarn (JText::_ ('VMPAYMENT_KORTA_TERMINAL_NOT_SET'));
			$returnValue = false;
		}
        
		
        if (empty($method->secretcode)) {
			vmWarn (JText::_ ('VMPAYMENT_KORTA_SECRETCODE_NOT_SET'));
			$returnValue = false;
		}          
        
		if (empty($method->url)) {
			vmWarn (JText::_ ('VMPAYMENT_KORTA_URL_NOT_SET'));
			$returnValue = false;
		}    
        
		if (empty($method->refermethod)) {
			vmWarn (JText::_ ('VMPAYMENT_KORTA_REFERMETHOD_NOT_SET'));
			$returnValue = false;
		}                 
                                              
        return $returnValue;
    }        
}
?>