<?php defined( '_JEXEC' ) or die( 'Restricted access' );
/**
 * @version     1.0.0
 * @package     plg_vmpayment_korta
 * @copyright   Copyright (C) 2013. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      Eirkur Haraldsson <eiki25@gmail.com> - http://www.ozon.is
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * See /administrator/components/com_virtuemart/COPYRIGHT.php for copyright notices and details.
 *
 * http://virtuemart.net
 */    
$currency = $viewData['currency']; 
$address = ((isset($viewData['order']['details']['ST'])) ? $viewData['order']['details']['ST'] : $viewData['order']['details']['BT']); 
?>
<style type="text/css">
h3, td, th { font-size: 0.8em; }
</style>

<table class="cart-summary width="100%" cellspacing="0" cellpadding="0" border="0">
    <tbody>
    <tr>
	<th colspan="2"><strong><?php echo JText::_('VMPAYMENT_KORTA_PAYMENT_RECEIVED') ?></strong></th>
    </tr>
    <tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_TIMEOFPAYMENT') ?></td>
	<td align="left"><?php echo $viewData['korta_time']; ?></td>
    </tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_REFERENCE') ?></td>
	<td align="left"><?php echo $viewData['korta_reference']; ?></td>
    </tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_CARDBRAND') ?></td>
	<td align="left"><?php echo $viewData['korta_cardbrand']; ?></td>
    </tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_CARD') ?></td>
	<td align="left">xxxxxxxxxx<?php echo $viewData['korta_card4']; ?></td>
    </tr>    
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_MERCHANTINFO') ?></td>
	<td align="left"><?php echo $viewData['vendor']->vendor_name; ?></td>
    </tr>    
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_AMOUNT') ?></td>
	<td align="left"><?php echo $viewData['amount'] ?>&nbsp;<?php echo $viewData['currency_code_3'] ?></td>
    </tr>       
    <tr>
    </tbody>
</table>
<?php if (isset($address)) : ?>                
<br/>
<table class="cart-summary width="100%" cellspacing="0" cellpadding="0" border="0">
    <tbody>
    <tr>
	<th colspan="2"><strong><?php echo JText::_('VMPAYMENT_KORTA_BUYER_INFO') ?></strong></th>
    </tr>
    <tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_FULLNAME') ?></td>
	<td align="left"><?php echo $this->getfullName($address->first_name, $address->middle_name, $address->last_name); ?></td>
    </tr>
    <tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_EMAIL') ?></td>
	<td align="left"><?php echo $address->email; ?></td>
    </tr>
    <tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_ADDRESS') ?></td>
	<td align="left"><?php echo $address->address_1; ?></td>
    </tr>    
    <tr>
	<td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_CITY') ?></td>
	<td align="left"><?php echo $address->city; ?></td>
    </tr>
    <tr>
    <td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_ZIP') ?></td>
	<td align="left"><?php echo $address->zip; ?></td>
    </tr>
    <tr>
    <td class=""><?php echo JText::_('VMPAYMENT_KORTA_BUYER_COUNTRY') ?></td>
	<td align="left"><?php echo ShopFunctions::getCountryByID ($address->virtuemart_country_id, 'country_2_code') ?></td>
    </tr>    
    </tbody>
</table>
<?php endif; ?>

<h3><?php echo JText::_('COM_VIRTUEMART_ACC_ORDER_INFO'); ?></h3>
<table class="cart-summary" width="100%" cellspacing="0" cellpadding="5" border="0">
	<tr align="left" class="sectiontableheader">
		<th align="left" width="5%"><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_SKU') ?></th>
		<th align="left" width="32%" ><?php echo JText::_('COM_VIRTUEMART_PRODUCT_NAME_TITLE') ?></th>		
		<th align="center" width="20%" ><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_PRICE') ?></th>
		<th align="right" width="8%"><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_QTY') ?></th>
		<?php if ( VmConfig::get('show_tax')) { ?>
		<th align="right" width="15%" ><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_PRODUCT_TAX') ?></th>
		  <?php } ?>		
		<th align="right" width="20%"><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></th>
	</tr>
<?php
	foreach($viewData['order']['items'] as $item) {
		$qtt = $item->product_quantity ;		
?>
		<tr valign="top">
			<td align="left">
				<?php echo $item->order_item_sku; ?>
			</td>
			<td align="left">
				<?php echo $item->order_item_name; ?>				
			</td>
			<td align="center"   class="priceCol" >
			    <?php echo '<span >'.$currency->priceDisplay($item->product_item_price,$currency) .'</span><br />'; ?>
			</td>
			<td align="right" >
				<?php echo $qtt; ?>
			</td>
			<?php if ( VmConfig::get('show_tax')) { ?>
				<td align="right" class="priceCol"><?php echo "<span  class='priceColor2'>".$currency->priceDisplay($item->product_tax ,$currency, $qtt)."</span>" ?></td>
                                <?php } ?>
			<td align="right"  class="priceCol">
				<?php
				$item->product_basePriceWithTax = (float) $item->product_basePriceWithTax;
				$class = '';
				if(!empty($item->product_basePriceWithTax) && $item->product_basePriceWithTax != $item->product_final_price ) {
					echo '<span class="line-through" >'.$currency->priceDisplay($item->product_basePriceWithTax,$currency,$qtt) .'</span><br />' ;
				}

				echo $currency->priceDisplay(  $item->product_subtotal_with_tax ,$currency); //No quantity or you must use product_final_price ?>
			</td>
		</tr>
<?php } ?>	
	<tr>
		<td align="right" class="pricePad" colspan="5"><strong><?php echo JText::_('COM_VIRTUEMART_ORDER_PRINT_TOTAL') ?></strong></td>
		<td align="right"><strong><?php echo $currency->priceDisplay($viewData['order']['details']['BT']->order_total, $currency); ?></strong></td>
	</tr>
</table>