<?php
class RPC2Api {
    private $url  =  "";
    public function __construct($url) {
        $this->url  = $url;
    }
    
    
    public function __call ($name ,$arguments ) {
        return $this->call($name,$arguments);
    }
    
    /**
     * 
     * @param String $method
     * @param Array $params
     */
    public function call($method,$params = array()) {
        if(empty($params))  $params  = array();        
        return $this->makeRequest($method,$params);
    }
    
    private function makeRequest($method,$params) {
        
        $params2  = array();
        foreach ($params as $p) {
            $params2[]  = $p;
        }
        $params  = $params2;
        $context = stream_context_create(
            array(
                "http" => array(
                    "header"  => "Content-type: text/json\r\n",
                    "method"  => "POST",
                    'max_redirects' => 3,            
                    'follow_location' => true,
                    'timeout' => 10,
                    "content" => json_encode(
                        array(
                            "id"        =>  uniqid(),
                            "jsonrpc"   =>  '2.0',
                            "method"    =>  $method,
                            "params"    =>  $params
                        )
                    )
                ),
                'ssl' => array(
                    'verify_peer' => false,
                    'verify_peer_name' => false
                )
            )
        );
        $data   =   @file_get_contents($this->url,false,$context);
        $data   =   json_decode($data,true);
        if(empty($data))
            return null;
        if(isset($data['result']))
            return $data['result'];
        return null;
    }
}
/*
$url  =  "http://api.curiooffice.com/index.php?option=com_coapi";
$api  =  new RPC2Api($url);
$data  = $api->call("system.getUserIdsByHost", array("douongboduong.com"));
var_dump($data);
*/