<?php
// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

/**
 * Example Folder Plugin
 *
 * @package      Joomla.Plugin
 * @subpackage   system.mixpanel
 * @since        1.5
 */
require_once(__DIR__."/rpc2api.php");
class plgSystemCuriooffice_ctapi extends JPlugin
{
    /**
     * Self instance
     *
     * @var plgSystemCuriooffice
     */
    public static $_self ;    
    /**
     * Constructor
     *
     * @access      public
     * @param       object  $subject The object to observe
     * @param       array   $config  An array that holds the plugin configuration
     * @since       1.6
     */
    
    public $params  =   null;
    public $apiUrl  =   null;
    public $apiUrlCo=   null;
    public $apiCompany  =   null;
    public $api     =   null;
    public $apico   =   null;
    public $api_last_user_id = 0;
    public $db      =   null;
    
    public function __construct(&$subject, $config)
    {
        parent::__construct( $subject, $config );
        $this->db   =   JFactory::getDBO();
        
        $this->app  =   JFactory::getApplication();        
        self::$_self = $this ;
        
        $this->params   =   new JRegistry($config['params']);
        $this->apiUrl   =   $this->params->get("api_url");
        $this->apiUrlCo =   $this->params->get("coapi_url");
        $this->apiCompany   =   $this->params->get("coapi_company");
        
        
        $this->api_last_user_id =   (int)$this->params->get("api_last_user_id");
        
        if(empty($this->apiUrl) == false)        
            $this->api      =   new RPC2Api($this->apiUrl);
        
        if(empty($this->apiUrlCo) == false)
            $this->apico    =   new RPC2Api($this->apiUrlCo);
        
        
    }
    
    /**
     * Get self object instance.
     *
     * @return  plgFolderExample
     */
    public static function getInstance()
    {
        return self::$_self ;
    }
    
    
    
    public function onPreprocessMenuItems($context, &$items, $params, $enabled)  { 
        
    }       
    
    
    public function onApiClearUsers()   {
        
        $query  =   "SELECT * FROM #__users WHERE block = 0 ORDER BY id ASC";
        $this->db->setQuery($query);
        $results = $this->db->loadObjectList();
        $uids  = array();
        foreach ($results as $user) {
            $uids[]  = intval($user->id);
        }
        if($this->api != null) {
            $data  = $this->api->call("system.clearUsers",array($_SERVER['HTTP_HOST'],$uids));
            var_dump($data);
        }
        echo "ok";
        
    }
    
    
    // system Events
    // ======================================================================================
	
	/**
     * Utility method to act on a user after it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserAfterSave($user, $isnew, $success, $msg = null)   {   
       
       
        
        if(!empty($user))        
            $this->updateapiMods($user);
        
        $sql  =  "update #__users SET api_token=sha1(CONCAT(id,username,password,rand())) WHERE  api_token IS NULL OR api_token = ''";
        $this->db->setQuery($sql);
        $this->db->query();
        
        
        $id  = intval($user['id']);
        $user = JFactory::getUser($id);
        mt_srand(time());
        
        /*
        if(strlen(trim($user->unical_id)) < 4) {            
            $user->unical_id = mt_rand(9000000, 9999999);
            $obj =  new stdClass();
            $obj->id        = $user->id;
            $obj->unical_id = $user->unical_id;            
            $this->db->updateObject('#__users', $obj, 'id');
            $user = & JFactory::getUser($id);
        }
        */
        /*
        if(strlen(trim($user->api_token)) < 5) {
            $user->api_token = sha1(uniqid("u").time(). mt_rand(9000000, 9999999));            
            $obj =  new stdClass();
            $obj->id        = $user->id;
            $obj->api_token = $user->api_token;
            $this->db->updateObject('#__users', $obj, 'id');
            $user = & JFactory::getUser($id);
        }        
        */
        
        
        
        
        $params =  array();
        $params['host'] =  $_SERVER['HTTP_HOST'];
        $params['id']   =  $user->id;
        $params['name'] =  $user->name;
        $params['username'] =  $user->username;
        $params['company'] =  $user->company;
        $params['email'] =  $user->email;
        $params['password'] =  $user->password2;
        $params['api_token'] =  $user->api_token;
        $params['api_type'] =  'ct';
        $params['rule_en'] =  $user->rule_text;
        $params['rule_is'] =  $user->rule_text_is;
        
        $params['address'] =  $user->address;
        $params['zip_code'] =  $user->zip_code;
        $params['town'] =  $user->town;
        $params['country'] =  $user->country;
        //$params['tel'] =  $_REQUEST['jform']['tel'];
        $params['tel'] = $user->tel;
        $params['group_user'] =  $user->group_user;
        $params['unical_id'] =  $user->username;        
        $params['uid'] = $params['host'].":".$params['id'];
        
        $params['is_hide']     =   intval($user->is_hide);
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/on_user_after_save.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);  
        if(strlen(trim($user->username0)) > 2) {
            $params['name'] =  $user->username0;
        }   
        
        $groups = $user->groups;
                
        try {
            
            if(!in_array(8, $groups)) {
                if($this->api != null) {

                    $uid  = $this->api->call("system.updateUser",array($params));                    
                    if(!isset($uid['not_allowed'])) {
                        if(!isset($uid['uid'])) 
                            throw new Exception("Api Error");                
                        if(strlen($uid['uid']) < 2) 
                            throw new Exception("Api Error");
                    }
                }
                
                
                $coSync  =  true;
                if(strlen(trim($this->apiCompany)) > 0) {
                    if(trim($this->apiCompany) != trim($user->company)) {
                        $coSync  =  false;
                    }
                }
                
                if($this->apico != null && $coSync) {
                    $uid  = $this->apico->call("system.updateUser",array($params));
                    if(!isset($uid['not_allowed'])) {
                        if(!isset($uid['uid'])) 
                            throw new Exception("Api Error");                
                        if(strlen($uid['uid']) < 2) 
                            throw new Exception("Api Error");
                    }
                }
            }

            $table = new JTableExtension(JFactory::getDbo());
            $table->load(array('element' => 'curiooffice_ctapi'));
            $this->params->set('api_last_user_id', $user->id);
            $table->set('params', $this->params->toString());
            $table->store();
            
        } catch (Exception $e) {
            
        }
        
        
        try {
            if(!empty($user)) {
                $app = JFactory::getApplication();
                
                jimport('joomla.application.component.model');
                JModelLegacy::addIncludePath(JPATH_SITE.'/administrator/components/com_ctapi/models', 'CtapiModel');
                $apiModel   =  JModelLegacy::getInstance('Api','CtapiModel');
                
                $res_check  =   $apiModel->checkCompanyIsNew($user->company);
                if($res_check->company_is_new == 1){
                    $apiModel->saveNewCompany($user->company);   
                }  
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/on_user_after_save.html', print_r('$isnew:'.$isnew.' $user->from_iframe:'.$user->from_iframe, true), FILE_APPEND | LOCK_EX);
                if($isnew === true && $user->from_iframe == 1){
                   //$_REQUEST['task'] = 'iframeInterLayer';
                   //$apiModel->setDefaultModules($user->company, 'from_iframe'); 
                } else{
                    if($isnew === true && in_array(6, $user->groups)){
                        $this->setWordOfWisdom($user->id);   
                    } if($user->from_iframe == 1){
                          $apiModel->setDefaultModules($user->company, 'from_iframe'); 
                    } else{
                         $apiModel->setDefaultModules($user->company, '');
                    }
                   
                }
                
               
            }
        } catch (Exception $e) {
            
        }
        
    }
    
    private function setWordOfWisdom($manager_id)
    {
        $item = new stdClass();
        $item->id = $manager_id;
        $item->quote_home_status = 1;
        $this->db->updateObject('#__users', $item, 'id');
    }
    
    /**
     * Remove all sessions for the user name
     *
     * @param    array      $user       Holds the user data
     * @param    boolean    $succes     True if user was succesfully stored in the database
     * @param    string     $msg        Message
     *
     * @return    boolean
     * @since    1.6
     */
    public function onUserAfterDelete($user, $success, $msg)    {        
        $id  = intval($user['id']);
        $unical_id  = trim($user['unical_id']);
        $uid    =   $_SERVER['HTTP_HOST'].":".intval($id);
        if($this->api != null) {
            $this->api->call("system.deleteUser",array($_SERVER['HTTP_HOST'],$id));
        }
        if($this->apico != null) {
            $this->apico->call("system.deleteUser",array($_SERVER['HTTP_HOST'],$unical_id,$uid));
        }
    }
    
    /**
     * After Initialise Event.
     */
    public function onAfterInitialise() {        
        $dispatcher = JEventDispatcher::getInstance();
        $db = JFactory::getDBO();
        
        $sql  =  "update #__users SET api_token=sha1(CONCAT(id,username,password,rand())) WHERE  api_token IS NULL OR api_token = ''";
        $db->setQuery($sql);
        $db->query();
        
        $query  =   "SELECT * FROM #__users WHERE id > ".$db->quote($this->api_last_user_id)." AND block = 0 ORDER BY id ASC LIMIT 2";
        $db->setQuery($query);
        $results = $db->loadObjectList();
        $api_last_user_id = 0;
        foreach($results as $result) {
            $user  =  (array)$result;
            $api_last_user_id = (int) $user['id'];
            $dispatcher->trigger("onUserAfterSave", array($user, false, true, null));
        }
        /*
        if($api_last_user_id > 0) {
            
            $table = new JTableExtension(JFactory::getDbo());
            $table->load(array('element' => 'curiooffice_ctapi'));
            $this->params->set('api_last_user_id', $api_last_user_id);
            $table->set('params', $this->params->toString());
            $table->store();
        }
        */
    }
    
    /**
     * After Route Event.
     */
    public function onAfterRoute()
    {
        
    }
    
    /**
     * After Dispatch Event.
     */
    public function onAfterDispatch()
    {
        
    }
    
    /**
     * After Render Event.
     */
    public function onAfterRender()  {
        
    }
    
    
    
    // Content Events
    // ======================================================================================
    
    
    /**
     * Example prepare content method
     *
     * Method is called by the view
     *
     * @param    string    The context of the content being passed to the plugin.
     * @param    object    The content object.  Note $article->text is also available
     * @param    object    The content params
     * @param    int       The 'page' number
     * @since    1.6
     */
    public function onContentPrepare($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example after display title method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentAfterTitle($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example before display content method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentBeforeDisplay($context, &$article, &$params, $page=0)
    {
    }

    /**
     * Example after display content method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentAfterDisplay($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example before save content method
     *
     * Method is called right before content is saved into the database.
     * Article object is passed by reference, so any changes will be saved!
     * NOTE:  Returning false will abort the save with an error.
     *You can set the error by calling $article->setError($message)
     *
     * @param    string      The context of the content passed to the plugin.
     * @param    object      A JTableContent object
     * @param    bool        If the content is just about to be created
     * @return   bool        If false, abort the save
     * @since    1.6
     */
    public function onContentBeforeSave($context, &$article, $isNew)
    {
    }
    
    /**
     * Example after save content method
     * Article is passed by reference, but after the save, so no changes will be saved.
     * Method is called right after the content is saved
     *
     * @param    string      The context of the content passed to the plugin (added in 1.6)
     * @param    object      A JTableContent object
     * @param    bool        If the content is just about to be created
     * @since    1.6
     */
    public function onContentAfterSave($context, &$article, $isNew)
    {
    }

    /**
     * Example before delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    object    The data relating to the content that is to be deleted.
     * @return   boolean
     * @since    1.6
     */
    public function onContentBeforeDelete($context, $data)
    {
    }
    
    /**
     * Example after delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    object    The data relating to the content that was deleted.
     * @return   boolean
     * @since    1.6
     */
    public function onContentAfterDelete($context, $data)
    {
    }

    /**
     * Example after delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    array     A list of primary key ids of the content that has changed state.
     * @param    int       The value of the state that the content has been changed to.
     * @return    boolean
     * @since    1.6
     */
    public function onContentChangeState($context, $pks, $value)
    {
    }
    
    
    
    // Form Events
    // ====================================================================================
    
    
    /**
     * @param    JForm    $form    The form to be altered.
     * @param    array    $data    The associated data for the form.
     *
     * @return    boolean
     * @since    1.6
     */
    function onContentPrepareForm($form, $data)    {
        if(empty($form))
            return true;
            
        if (!($form instanceof JForm)) {
            return true;
        }        
        $name  = $form->getName();
        switch ($name) {
            case "com_users.user":                
                return $this->changeUserEditForm($form, $data);                
                break;
        }        
        return true;
    }
    
    
    private function changeUserEditForm($form, $data) {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/changeUserEditForm.html', print_r($data->tel, true), FILE_APPEND | LOCK_EX);
        
        if(empty($data))
            return true;
        
        $data2  =  (array)$data;
        $company  =  trim($data2['company']);
        if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) return true;
        JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
        $model = JModelLegacy::getInstance('Api', 'CtapiModel');
        $allMods        =   $model->allMods();
        $activeMods     =   $model->getCompanyMods($company, 1);
        
        
        /*
            echo "<pre>";
            var_dump($allMods); 
            var_dump($activeMods);
            exit;
            //$activeMods     =   $model->getCompanyMods($company,$default  =  1)
        */
      
        
        $uid  =  0;
        if(isset($data2['id']) && intval($data2['id']) > 0) {
            $xml =  '<?xml version="1.0" encoding="utf-8"?><form><fieldset name="user_details">';
            //$xml .=  '<field type="spacer" name="sp_01" hr="true" />';
            
            $label_tel = 'Phone';
            $descr_tel = 'User phone';
            $xml .= '<field name="tel"  type="text" label="'.htmlspecialchars($label_tel, ENT_QUOTES).'" description="['.htmlspecialchars($descr_tel, ENT_QUOTES).']" value="'.$data->tel.'" default="" ></field>';
            $xml .=  '<field type="spacer" name="sp_02" label="Api Modules" />';
            
            
           /* echo '<pre>Before:';
            print_r($activeMods);
            echo '</pre>';
            
            if($activeMods['pay_period']==0){
                $activeMods['pay_period']=1;
            }
            echo '<pre>After:';
            print_r($activeMods);
            echo '</pre>';*/
            
            
            //echo "<pre>";var_dump($activeMods);exit;
            foreach ($activeMods as $m=>$v) {
                $label  =  $m;
                if(isset($allMods[$m]))
                    $label  =  $allMods[$m];

                
                if(in_array($m, array("user_limit"))) {
                    // use text 
                    $xml .= '<field name="api_mods_'.$m.'" type="number" min="0" max="200" step="1" label="'.htmlspecialchars($label,ENT_QUOTES).'" description="['.htmlspecialchars($m,ENT_QUOTES).']" value="'. intval($v).'" default="'. intval($v).'" class="btn-group btn-group-yesno" ><option value="1">JYES</option><option value="0">JNO</option></field>';
                } else {                    
                    $xml .= '<field name="api_mods_'.$m.'" type="radio" label="'.htmlspecialchars($label,ENT_QUOTES).'" description="['.htmlspecialchars($m,ENT_QUOTES).']" value="'. intval($v).'" default="'. intval($v).'" class="btn-group btn-group-yesno" ><option value="1">JYES</option><option value="0">JNO</option></field>';
                }
            }
            
            $xml .=  '<field name="api_update_mods" type="hidden" default="'. intval($data2['id']).'" />';
            $xml .= '</fieldset></form>';
            $form->load($xml, false);
        }
        
        return true;
    }
    
    public function updateapiMods($user) {
        
        if(empty($_POST))
            return false;
            
        
        
        $user  =  (array) $user;
        if(!isset($user["company"])) return false;
        if(strlen(trim($user["company"])) < 1) return false;
        
        $company  =  trim($user["company"]);        
        if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) return true;
        JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
        $model = JModelLegacy::getInstance('Api', 'CtapiModel');
        $activeMods     =   $model->getCompanyMods($company);
        foreach ($activeMods as $k=>$v) {
            $activeMods[$k] = 0;
        }
        $post	= JRequest::getVar( 'jform', null);    
        
        if(!isset($post['api_update_mods'])) return false;
        
            $uid  =  intval($post['api_update_mods']);            
            if($uid > 0 && $uid  != intval($user['id'])) {
                return false;
        }
        
        
        $mods  =  array();
        foreach ($post as $k=>$v) {
            if(preg_match("#api_mods_(.*)#i", $k,$arr)) {
                $k  =  $arr[1];
                $mods[$k] = intval($v);
            }
        }
        if(!empty($mods)) {
            foreach ($mods as $k=>$v) {
                $activeMods[$k]  =  $v;
            }
        }
        $model->resetCompany($company);
        foreach ($activeMods as $k=>$v) {
            $obj  =  new stdClass();
            $obj->company   =   $company;
            $obj->mod       =   $k;
            $obj->enabled   =   intval($v);                
            $this->db->insertObject($model->companyModsTableName,$obj, 'id');
        }
    }
    
    // User Events
    // ====================================================================================
    
    
    /**
     * Utility method to act on a user after it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserBeforeSave($user, $isnew, $success, $msg = null)
    {
    }
    
    
    /**
     * This method should handle any login logic and report back to the subject
     *
     * @param    array    $user        Holds the user data
     * @param    array    $options     Array holding options (remember, autoregister, group)
     *
     * @return    boolean    True on success
     * @since    1.5
     */
    public function onUserLogin($user, $options = array())  {
        
        
    }
    
    public function onUserAfterLogin($options) {        
    
    }
    
    /**
     * This method should handle any logout logic and report back to the subject
     *
     * @param    array    $user       Holds the user data.
     * @param    array    $options    Array holding options (client, ...).
     *
     * @return    object    True on success
     * @since    1.5
     */
    public function onUserLogout($user, $options = array())
    {
            
    }
    
    /**
     * Utility method to act on a user before it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserBeforeDelete($user)
    {
    }
    
            
    
    /**
     * @param    string    $context    The context for the data
     * @param    int       $data       The user id
     * @param    object
     *
     * @return    boolean
     * @since    1.6
     */
    public function onContentPrepareData($context, $data)
    {
    }
}
