<?php
// no direct access
defined('_JEXEC') or die;

jimport('joomla.plugin.plugin');

/**
 * Example Folder Plugin
 *
 * @package      Joomla.Plugin
 * @subpackage   system.mixpanel
 * @since        1.5
 */
require_once(__DIR__."/rpc2api.php");
class plgSystemCuriooffice_ctapi extends JPlugin
{
    /**
     * Self instance
     *
     * @var plgSystemCuriooffice
     */
    public static $_self ;    
    /**
     * Constructor
     *
     * @access      public
     * @param       object  $subject The object to observe
     * @param       array   $config  An array that holds the plugin configuration
     * @since       1.6
     */
    
    public $params  =   null;
    public $apiUrl  =   null;
    public $apiUrlCo=   null;
    public $api     =   null;
    public $apico   =   null;
    public $api_last_user_id = 0;
    public $db      =   null;
    
    public function __construct(&$subject, $config)
    {
        parent::__construct( $subject, $config );
        $this->db   =   JFactory::getDBO();
        
        $this->app  =   JFactory::getApplication();        
        self::$_self = $this ;
        
        $this->params   =   new JRegistry($config['params']);
        $this->apiUrl   =   $this->params->get("api_url");
        $this->apiUrlCo =   $this->params->get("coapi_url");
        
        
        $this->api_last_user_id =   (int)$this->params->get("api_last_user_id");
        
        if(empty($this->apiUrl) == false)        
            $this->api      =   new RPC2Api($this->apiUrl);
        
        if(empty($this->apiUrlCo) == false)
            $this->apico    =   new RPC2Api($this->apiUrlCo);
        
        
    }
    
    /**
     * Get self object instance.
     *
     * @return  plgFolderExample
     */
    public static function getInstance()
    {
        return self::$_self ;
    }
    
    
    
    // system Events
    // ======================================================================================
	
	/**
     * Utility method to act on a user after it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserAfterSave($user, $isnew, $success, $msg = null)   {        
        $this->updateapiMods($user);
        
        $id  = intval($user['id']);
        $user = & JFactory::getUser($id);
        mt_srand(time());
        
        /*
        if(strlen(trim($user->unical_id)) < 4) {            
            $user->unical_id = mt_rand(9000000, 9999999);
            $obj =  new stdClass();
            $obj->id        = $user->id;
            $obj->unical_id = $user->unical_id;            
            $this->db->updateObject('#__users', $obj, 'id');
            $user = & JFactory::getUser($id);
        }
        */
        
        if(strlen(trim($user->api_token)) < 5) {
            $user->api_token = sha1(uniqid("u").time(). mt_rand(9000000, 9999999));            
            $obj =  new stdClass();
            $obj->id        = $user->id;
            $obj->api_token = $user->api_token;
            $this->db->updateObject('#__users', $obj, 'id');
            $user = & JFactory::getUser($id);
        }        
        
        
        
        
        $params =  array();
        $params['host'] =  $_SERVER['HTTP_HOST'];
        $params['id']   =  $user->id;
        $params['name'] =  $user->name;
        $params['username'] =  $user->username;
        $params['company'] =  $user->company;
        $params['email'] =  $user->email;
        $params['password'] =  $user->password2;
        $params['api_token'] =  $user->api_token;
        $params['api_type'] =  'ct';
        $params['rule_en'] =  $user->rule_text;
        $params['rule_is'] =  $user->rule_text_is;
        
        $params['address'] =  $user->address;
        $params['zip_code'] =  $user->zip_code;
        $params['town'] =  $user->town;
        $params['country'] =  $user->country;
        $params['tel'] =  $user->tel;
        $params['group_user'] =  $user->group_user;
        $params['unical_id'] =  $user->username;
        
        
        if(strlen(trim($user->username0)) > 2) {
            $params['name'] =  $user->username0;
        }   
        
        $groups = $user->groups;
                
        try {
            
            if(!in_array(8, $groups)) {
                if($this->api != null) {

                    $uid  = $this->api->call("system.updateUser",array($params));
                    if(!isset($uid['uid'])) 
                        throw new Exception("Api Error");                
                    if(strlen($uid['uid']) < 2) 
                        throw new Exception("Api Error");
                }

                if($this->apico != null) {
                    $uid  = $this->apico->call("system.updateUser",array($params));
                    if(!isset($uid['uid'])) 
                        throw new Exception("Api Error");                
                    if(strlen($uid['uid']) < 2) 
                        throw new Exception("Api Error");
                }
            }

            $table = new JTableExtension(JFactory::getDbo());
            $table->load(array('element' => 'curiooffice_ctapi'));
            $this->params->set('api_last_user_id', $user->id);
            $table->set('params', $this->params->toString());
            $table->store();
            
        } catch (Exception $e) {
            
        }
        
    }
    
    /**
     * Remove all sessions for the user name
     *
     * @param    array      $user       Holds the user data
     * @param    boolean    $succes     True if user was succesfully stored in the database
     * @param    string     $msg        Message
     *
     * @return    boolean
     * @since    1.6
     */
    public function onUserAfterDelete($user, $success, $msg)    {        
        $id  = intval($user['id']);
        $unical_id  = trim($user['unical_id']);
        if($this->api != null) {
            $this->api->call("system.deleteUser",array($_SERVER['HTTP_HOST'],$id));
        }
        if($this->apico != null) {
            $this->apico->call("system.deleteUser",array($_SERVER['HTTP_HOST'],$unical_id));
        }
    }
    
    /**
     * After Initialise Event.
     */
    public function onAfterInitialise() {        
        $dispatcher = JEventDispatcher::getInstance();
        $db = & JFactory::getDBO();
        $query  =   "SELECT * FROM #__users WHERE id > ".$db->quote($this->api_last_user_id)." AND block = 0 ORDER BY id ASC LIMIT 2";
        $db->setQuery($query);
        $results = $db->loadObjectList();
        $api_last_user_id = 0;
        foreach($results as $result) {
            $user  =  (array)$result;
            $api_last_user_id = (int) $user['id'];
            $dispatcher->trigger("onUserAfterSave", array($user, false, true, null));
        }
        /*
        if($api_last_user_id > 0) {
            
            $table = new JTableExtension(JFactory::getDbo());
            $table->load(array('element' => 'curiooffice_ctapi'));
            $this->params->set('api_last_user_id', $api_last_user_id);
            $table->set('params', $this->params->toString());
            $table->store();
        }
        */
    }
    
    /**
     * After Route Event.
     */
    public function onAfterRoute()
    {
        
    }
    
    /**
     * After Dispatch Event.
     */
    public function onAfterDispatch()
    {
        
    }
    
    /**
     * After Render Event.
     */
    public function onAfterRender()  {
        
    }
    
    
    
    // Content Events
    // ======================================================================================
    
    
    /**
     * Example prepare content method
     *
     * Method is called by the view
     *
     * @param    string    The context of the content being passed to the plugin.
     * @param    object    The content object.  Note $article->text is also available
     * @param    object    The content params
     * @param    int       The 'page' number
     * @since    1.6
     */
    public function onContentPrepare($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example after display title method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentAfterTitle($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example before display content method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentBeforeDisplay($context, &$article, &$params, $page=0)
    {
    }

    /**
     * Example after display content method
     *
     * Method is called by the view and the results are imploded and displayed in a placeholder
     *
     * @param    string        The context for the content passed to the plugin.
     * @param    object        The content object.  Note $article->text is also available
     * @param    object        The content params
     * @param    int           The 'page' number
     * @return    string
     * @since    1.6
     */
    public function onContentAfterDisplay($context, &$article, &$params, $page=0)
    {
    }
    
    /**
     * Example before save content method
     *
     * Method is called right before content is saved into the database.
     * Article object is passed by reference, so any changes will be saved!
     * NOTE:  Returning false will abort the save with an error.
     *You can set the error by calling $article->setError($message)
     *
     * @param    string      The context of the content passed to the plugin.
     * @param    object      A JTableContent object
     * @param    bool        If the content is just about to be created
     * @return   bool        If false, abort the save
     * @since    1.6
     */
    public function onContentBeforeSave($context, &$article, $isNew)
    {
    }
    
    /**
     * Example after save content method
     * Article is passed by reference, but after the save, so no changes will be saved.
     * Method is called right after the content is saved
     *
     * @param    string      The context of the content passed to the plugin (added in 1.6)
     * @param    object      A JTableContent object
     * @param    bool        If the content is just about to be created
     * @since    1.6
     */
    public function onContentAfterSave($context, &$article, $isNew)
    {
    }

    /**
     * Example before delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    object    The data relating to the content that is to be deleted.
     * @return   boolean
     * @since    1.6
     */
    public function onContentBeforeDelete($context, $data)
    {
    }
    
    /**
     * Example after delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    object    The data relating to the content that was deleted.
     * @return   boolean
     * @since    1.6
     */
    public function onContentAfterDelete($context, $data)
    {
    }

    /**
     * Example after delete method.
     *
     * @param    string    The context for the content passed to the plugin.
     * @param    array     A list of primary key ids of the content that has changed state.
     * @param    int       The value of the state that the content has been changed to.
     * @return    boolean
     * @since    1.6
     */
    public function onContentChangeState($context, $pks, $value)
    {
    }
    
    
    
    // Form Events
    // ====================================================================================
    
    
    /**
     * @param    JForm    $form    The form to be altered.
     * @param    array    $data    The associated data for the form.
     *
     * @return    boolean
     * @since    1.6
     */
    function onContentPrepareForm($form, $data)    {
        if (!($form instanceof JForm)) {
            return false;
        }        
        $name  = $form->getName();
        switch ($name) {
            case "com_users.user":                
                return $this->changeUserEditForm($form, $data);                
                break;
        }        
        return true;
    }
    
    
    private function changeUserEditForm($form, $data) {
        //return true;
        $company  =  trim($data->company);
        if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) return true;
        JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
        $model = JModelLegacy::getInstance('Api', 'CtapiModel');
        $allMods        =   $model->allMods();
        $activeMods     =   $model->getCompanyMods($company);
        
        
        /*
        echo "<pre>";
        var_dump($allMods);
        var_dump($activeMods);
        exit;
        //$activeMods     =   $model->getCompanyMods($company,$default  =  1)
        */
        
        $xml =  '<?xml version="1.0" encoding="utf-8"?><form><fieldset name="user_details">';
        //$xml .=  '<field type="spacer" name="sp_01" hr="true" />';
        $xml .=  '<field type="spacer" name="sp_02" label="Api Modules" />';
        
        foreach ($activeMods as $m=>$v) {
            $label  =  $m;
            if(isset($allMods[$m]))
                $label  =  $allMods[$m];
            $xml .= '<field name="api_mods_'.$m.'" type="radio" label="'.htmlspecialchars($label,ENT_QUOTES).'" description="['.htmlspecialchars($m,ENT_QUOTES).']" default="'. intval($v).'" class="btn-group btn-group-yesno" ><option value="1">JYES</option><option value="0">JNO</option></field>';
        }
        $xml .=  '<field name="api_update_mods" type="hidden" default="1" />';
        $xml .= '</fieldset></form>';
        $form->load($xml, false);
        
        return true;
    }
    
    public function updateapiMods($user) {
        $company  =  trim($user["company"]);        
        if(!is_file(JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php')) return true;
        JLoader::register('CtapiModelApi', JPATH_ROOT . '/administrator/components/com_ctapi/models/api.php');
        $model = JModelLegacy::getInstance('Api', 'CtapiModel');
        $activeMods     =   $model->getCompanyMods($company);
        foreach ($activeMods as $k=>$v) {
            $activeMods[$k] = 0;
        }
        $post	= JRequest::getVar( 'jform', null);        
        if(!isset($post['api_update_mods'])) return false;
        $mods  =  array();
        foreach ($post as $k=>$v) {
            if(preg_match("#api_mods_(.*)#i", $k,$arr)) {
                $k  =  $arr[1];
                $mods[$k] = intval($v);
            }
        }
        if(!empty($mods)) {
            foreach ($mods as $k=>$v) {
                $activeMods[$k]  =  $v;
            }
        }
        $model->resetCompany($company);
        foreach ($activeMods as $k=>$v) {
            $obj  =  new stdClass();
            $obj->company   =   $company;
            $obj->mod       =   $k;
            $obj->enabled   =   intval($v);                
            $this->db->insertObject($model->companyModsTableName,$obj, 'id');
        }
    }
    
    // User Events
    // ====================================================================================
    
    
    /**
     * Utility method to act on a user after it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserBeforeSave($user, $isnew, $success, $msg = null)
    {
    }
    
    
    /**
     * This method should handle any login logic and report back to the subject
     *
     * @param    array    $user        Holds the user data
     * @param    array    $options     Array holding options (remember, autoregister, group)
     *
     * @return    boolean    True on success
     * @since    1.5
     */
    public function onUserLogin($user, $options = array())  {
        
        
    }
    
    public function onUserAfterLogin($options) {        
    
    }
    
    /**
     * This method should handle any logout logic and report back to the subject
     *
     * @param    array    $user       Holds the user data.
     * @param    array    $options    Array holding options (client, ...).
     *
     * @return    object    True on success
     * @since    1.5
     */
    public function onUserLogout($user, $options = array())
    {
            
    }
    
    /**
     * Utility method to act on a user before it has been saved.
     *
     *
     * @param    array      $user       Holds the new user data.
     * @param    boolean    $isnew      True if a new user is stored.
     * @param    boolean    $success    True if user was succesfully stored in the database.
     * @param    string     $msg        Message.
     *
     * @return    void
     * @since    1.6
     */
    public function onUserBeforeDelete($user, $isnew, $success, $msg)
    {
    }
    
    
    
    /**
     * @param    string    $context    The context for the data
     * @param    int       $data       The user id
     * @param    object
     *
     * @return    boolean
     * @since    1.6
     */
    public function onContentPrepareData($context, $data)
    {
    }
}
