<?php
require_once "incl/twilio_php_master/Twilio/autoload.php";
use Twilio\Rest\Client;
       
class Notification {
   public function __construct($db)
   {
       $this->db=$db;
              
       $baldvin_sid = 'ACda9eeddca6d7c72c1bf2232472599e8d';
       $baldvin_token = 'b957e6514f44a02bbd398f56b974d417';
       $this->client = new Client($baldvin_sid, $baldvin_token);
   }
   
   public function getUserList()
   {
    $query = "SELECT id, tel, sms_text, audiofile_from_voice_call_url FROM #__users WHERE tel!=''";
    $this->db->setQuery($query);
    $user_list = $this->db->loadObjectList();
    return $user_list;
   }
   
   public function getPrepareItemList()
   {
        $query = "SELECT * FROM #__shedule_items WHERE status='0' AND notice_type!='-1'";
        $this->db->setQuery($query);
        $items = $this->db->loadObjectList();
        return $items;
   }
   
   public function getUserPhone($user_id){
      
       $query = "SELECT tel FROM #__users WHERE id='".(int)$user_id."'";

       $this->db->setQuery( $query );
       $tel_raw= $this->db->loadObject();
    
       $phone_fragment=explode("+", $tel_raw->tel);
       $phone_after_plus=$phone_fragment[1];
       $res=preg_match('/^\+?\d+$/', $phone_after_plus);
       $res=(bool)$res;
       
      
       if($res===true){//проверяем,стоит ли + перед номером и числовое ли значение дальше
           return $tel_raw->tel;
           
       } else{
           return false;
       }
   }
  
   public function sendSMS($phone, $sms_text, $schedule_id, $user_id) {
       $owner_id=$this->getOwnerId($user_id);
       $count_unit=$this->getCountUnit($owner_id);
       
       if($count_unit>=1){
           if($count_unit===21){
               $this->sendEmail($owner_id, $count_unit);
           }
           
            try {
                $this->client->messages->create(
                    $phone,//кому 
                    array(
                        "from" => "+12674334487",//от кого
                        "body" => $sms_text,
                    )
                );
                $result='success';
                //$this->updateScheduleItemStatus($schedule_id);
                $this->takeAwayQtyItem($owner_id);
                $count_unit=$this->getCountUnit($owner_id);
                
                if(is_integer(($count_unit-1)/1000)){
                    //minus qty
                    $this->takeAwayQty($owner_id);//minus qty packet
                }
            
            } catch (Exception $e) {
                $result = "Error: " . $e->getMessage();
            }
       } else{
           $result='quantity exceeded';
       }
       $this->addResultToSMSLog($result, $schedule_id, $user_id, $owner_id);
        
    }
    
    public function takeAwayQtyItem($owner_id)
    {
        $itemU = new stdClass;
        $user_manager = JFactory::getUser($owner_id);
        
        $itemU->id = $owner_id;       
        $itemU->count_sms_call_in_unit=$user_manager->count_sms_call_in_unit-1;

        $res=$this->db->updateObject( '#__users', $itemU, 'id' );   
    }
    
    public function takeAwayQty($owner_id)
    {
        $user_manager = JFactory::getUser($owner_id);
        $qty=$user_manager->qty_unit;
        
        $itemU = new stdClass;
        $itemU->id = $owner_id;        
        $itemU->qty_unit=$qty-1;
        
        $res=$this->db->updateObject( '#__users', $itemU, 'id' );
    }
    
    public function getCountUnit($owner_id)
    {
        $user_manager = JFactory::getUser($owner_id);
        return (int)$user_manager->count_sms_call_in_unit;
    }
    
    public function sendEmail($owner_id, $count_unit)
    {
        $config =& JFactory::getConfig();
        $sender = array($config->get('mailfrom'), $config->get('fromname'));
        $user_manager = JFactory::getUser($owner_id);
        
        $message = "The number of your units is 20. Please top up your account";
        $subject = "Warning";
        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient($user_manager->email);
        $mailer->addRecipient('developer3452@gmail.com');
        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE); 
        $mailer->setBody($message);
        $mailer->send();
    }
    
    public function addResultToSMSLog($status, $schedule_id, $user_id, $owner_id)
    {
        $user_id=(int)$user_id;
        $owner_id=(int)$owner_id;
        
        $time_send=time();//current time      
        $query = "INSERT INTO #__sms_log (id_shedule_item, time_send, status, user_id, owner_id) VALUES ('".$schedule_id."', '".$time_send."', '".$status."', '".$user_id."', '".$owner_id."')";    
        $this->db->setQuery($query);	 
        $this->db->query(); 
    }
   
   public function updateScheduleItemStatus($schedule_id)
   {
        $query = "UPDATE #__shedule_items SET status='1' WHERE id='".$schedule_id."'";
        $this->db->setQuery($query);
        $this->db->query();
   }
   
   public function makeCall($tel, $call_file_url, $schedule_item_id, $user_id) {
        $owner_id = $this->getOwnerId($user_id);
        $count_unit = $this->getCountUnit($owner_id);

        if ($count_unit >= 1) {
            if ($count_unit === 21) {
                $this->sendEmail($owner_id, $count_unit);
            }
            try {
                // Initiate a new outbound call
                $call = $this->client->account->calls->create(
                    $tel, //кому
                    "+12674334487", //от кого
                    array(
                        "url" => 'https://frost.curiotime.com/components/com_audit/assets/xml/demo.xml'
                    )
                );
                $result = "Succes: " . $call->sid;
                $this->takeAwayQtyItem($owner_id);
                $count_unit = $this->getCountUnit($owner_id);

                if (is_integer(($count_unit - 1) / 1000)) {
                    //minus qty
                    $this->takeAwayQty($owner_id); //minus qty packet
                }
            } catch (Exception $e) {
                $result = "Error: " . $e->getMessage();
            }
        } else {
            $result = 'quantity exceeded';
        }
        $this->addResultToCallLog($result, $schedule_item_id, $user_id, $owner_id); //add result to log
    }

    public function addResultToCallLog($status, $schedule_id, $user_id, $owner_id)
    {
        $user_id=(int)$user_id;
        $owner_id=(int)$owner_id;
        $time_send=time();//current time  
        
        $query = "INSERT INTO #__call_log (id_shedule_item, time, status, user_id, owner_id) VALUES ('".$schedule_id."', '".$time_send."', '".$status."', '".$user_id."', '".$owner_id."')";    
        $this->db->setQuery($query);	 
        $this->db->query();
    }
    
    public function getOwnerId($user_id)
    {
        $query = "SELECT owner_id FROM #__users WHERE id='".$user_id."'";
        $this->db->setQuery($query);
        $item = $this->db->loadObject();
        return $item->owner_id;
    }

}
