<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Video\V1\Room;

use Twilio\Deserialize;
use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Options;
use Twilio\Values;
use Twilio\Version;

/**
 * @property string sid
 * @property string roomSid
 * @property string accountSid
 * @property string status
 * @property string identity
 * @property \DateTime dateCreated
 * @property \DateTime dateUpdated
 * @property \DateTime startTime
 * @property \DateTime endTime
 * @property integer duration
 * @property string url
 * @property array links
 */
class RoomParticipantInstance extends InstanceResource {
    protected $_publishedTracks = null;

    /**
     * Initialize the RoomParticipantInstance
     * 
     * @param \Twilio\Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $roomSid The room_sid
     * @param string $sid The sid
     * @return \Twilio\Rest\Video\V1\Room\RoomParticipantInstance 
     */
    public function __construct(Version $version, array $payload, $roomSid, $sid = null) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = array(
            'sid' => Values::array_get($payload, 'sid'),
            'roomSid' => Values::array_get($payload, 'room_sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'status' => Values::array_get($payload, 'status'),
            'identity' => Values::array_get($payload, 'identity'),
            'dateCreated' => Deserialize::dateTime(Values::array_get($payload, 'date_created')),
            'dateUpdated' => Deserialize::dateTime(Values::array_get($payload, 'date_updated')),
            'startTime' => Deserialize::dateTime(Values::array_get($payload, 'start_time')),
            'endTime' => Deserialize::dateTime(Values::array_get($payload, 'end_time')),
            'duration' => Values::array_get($payload, 'duration'),
            'url' => Values::array_get($payload, 'url'),
            'links' => Values::array_get($payload, 'links'),
        );

        $this->solution = array('roomSid' => $roomSid, 'sid' => $sid ?: $this->properties['sid'],);
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     * 
     * @return \Twilio\Rest\Video\V1\Room\RoomParticipantContext Context for this
     *                                                           RoomParticipantInstance
     */
    protected function proxy() {
        if (!$this->context) {
            $this->context = new RoomParticipantContext(
                $this->version,
                $this->solution['roomSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch a RoomParticipantInstance
     * 
     * @return RoomParticipantInstance Fetched RoomParticipantInstance
     */
    public function fetch() {
        return $this->proxy()->fetch();
    }

    /**
     * Update the RoomParticipantInstance
     * 
     * @param array|Options $options Optional Arguments
     * @return RoomParticipantInstance Updated RoomParticipantInstance
     */
    public function update($options = array()) {
        return $this->proxy()->update($options);
    }

    /**
     * Access the publishedTracks
     * 
     * @return \Twilio\Rest\Video\V1\Room\RoomParticipant\PublishedTrackList 
     */
    protected function getPublishedTracks() {
        return $this->proxy()->publishedTracks;
    }

    /**
     * Magic getter to access properties
     * 
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get($name) {
        if (array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (property_exists($this, '_' . $name)) {
            $method = 'get' . ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     * 
     * @return string Machine friendly representation
     */
    public function __toString() {
        $context = array();
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Video.V1.RoomParticipantInstance ' . implode(' ', $context) . ']';
    }
}