<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_selectcalc_new
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

/**
 * Helper for mod_selectcalc_new
 *
 * @since  1.5
 */
//require(dirname(__FILE__) . '/assets/fpdf/fpdf.php');

class ModSelectcalcHelper {

    public static function getAjax() {


        $user = JFactory::getUser(884);
        $module_id = (int) $_POST['module_id'];
        $mod_row = & JTable::getInstance('Module', 'JTable');
        $mod_row->load($module_id);
        $params_backend = (array) json_decode($mod_row->params);


        if ($_GET['task'] == 'pdf') {
            echo ModCustomcalc1Helper::mygetPDF();
            exit;
        }
        if ($_GET['task'] == 'getsalaries') {
            $params = $_REQUEST['params'];
            $db = JFactory::getDbo();
            $query = $db->getQuery(true);
            $query->select('*');
            $query->from($db->quoteName('#__mod_selectcalc_sgs4'))->where(" contract_id = " . (int) $params[1]);
            $db->setQuery($query);
            $result = $db->loadObjectList();
            $values = unserialize($result[0]->values);
            $laun = preg_replace("/[^0-9]/", '', $params[0]['laun']);
            foreach ($values as $value) {
                if ($laun == preg_replace("/[^0-9]/", '', $value[0])) {
                    foreach ($value as $key1 => $value3)
                        $value[$key1] = str_replace(".", '', $value3);
                    $val->result = true;
                    $val->data = $value;
                    echo json_encode($val);
                    exit;
                }
            }
            $val->result = false;
            $val->data = ['0', '0', '0', '0'];
            echo json_encode($val);
            exit;
        }

        if ($_GET['task'] == 'save' && in_array('8', JFactory::getUser()->groups)) {

            foreach ($_POST['params'] as $param) {
                if (array_key_exists($param['name'], $params_backend)) {
                    $params_backend[$param['name']] = $param['value'];
                }
            }
            $updated_params = json_encode($params_backend);


            $item = new stdClass;
            $item->id = $module_id;
            $item->params = $updated_params;

            $db = & JFactory::getDBO();
            if (!$db->updateObject('#__modules', $item, 'id')) {
                return $db->stderr();
            } else {
                return 'Data save complete';
            }

            /* foreach( $_POST['params'] as $par) $params[$par["name"]] = $par["value"];
              $user->defParam('formparams', json_encode($params));
              $user->setParam('formparams', json_encode($params) ); $user->save( false );
              return 'Data save complete'; */
        }

        if ($_GET['task'] == 'load') {

            return json_encode($params_backend);

            //return $user->getParam('formparams', '');
        }
    }

    public static function mygetPDF() {

        require_once(dirname(__FILE__) . '/assets/tcpdf/config/tcpdf_config_alt.php');
        require_once(dirname(__FILE__) . '/assets/tcpdf/tcpdf.php');

        $pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

        $pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
        $pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
        $pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
        $pdf->SetFooterMargin(PDF_MARGIN_FOOTER);
        //$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);
        $pdf->setFontSubsetting(true);
        $pdf->SetFont('dejavusans', '', 14, '', true);
        $pdf->AddPage();


        $html = <<<EOD
		<style>	.prev > td{height:16px;padding:4px; vertical-align:middle;} .prev{font-size:10px; } 
				.second > td{height:14px;padding:4px; vertical-align:middle;} .second{font-size:8px;font-style: italic;} td{width:25%} 
				
				</style>
<a href="https://web2.ns1.kreativ.is/" style="text-decoration:none;color:#ff5a09;">Reiknivél tímalauna</a><br/>
<table style="font-size:8px;border-bottom:1px solid grey;padding:0px;margin:0px;"><tr><td>Launaliðir</td><td></td><td ALIGN="right">Launþegi</td><td ALIGN="right">Launagreiðandi</td></tr></table>
<table style="padding:0px;margin:0px;">
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Lögbundinn lífeyrissjóður</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Iðgjald launþega</td>
		<td style="width:100px;">4 %</td>
		<td style="width:120px;">0 kr.</td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mótframlag launagreiðanda</td>
		<td style="width:100px;">11.5 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;height:16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Endurhæfingarsjóður</td>
		<td style="width:100px;">0.5 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Séreignarsparnaður</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Iðgjald launþega</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;">0 kr.</td>
		<td></td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Mótframlag launagreiðanda</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Tryggingargjald</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Almennt tryggingargjald</td>
		<td style="width:100px;">5.4 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Fjársýsluskattur</td>
	<td style="width:100px;"></td>
	<td style="width:120px;"></td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Virkja fjársýsluskatt</td>
		<td style="width:100px;">5.5 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
		
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Stéttarfélag</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Félagsgjöld</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;">0 kr.</td>
		<td></td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Sjúkrasjóður</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;height:16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Orlofssjóður</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;height:16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Endurmenntunarsjóður</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Orlof</td>
	<td style="width:100px;"></td>
	<td style="width:120px;"></td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Launað frí</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Tekjuskattur og útsvar</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td></td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Þrep 1</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;">0 kr.</td>
		<td></td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Þrep 2</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;">0 kr.</td>
		<td></td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;font-weight:bold;">Persónuafsláttur</td>
	<td style="width:100px;"></td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Persónuafsláttur þinn</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;">0 kr.</td>
		<td></td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Persónuafsláttur maka</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;height:16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ónýttur persónuafsláttur</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
	<tr class="second" ALIGN="right">
		<td ALIGN="left" style="width:160px;height:16px">&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ónýttur persónuafsláttur maka</td>
		<td style="width:100px;">0 %</td>
		<td style="width:120px;"></td>
		<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:160px;"></td>
	<td style="width:100px;">Samtals:</td>
	<td style="width:120px;">0 kr.</td>
	<td>0 kr.</td></tr>
</table>
<table style="font-size:8px;border-bottom:1px solid grey;padding-top:30px;padding-left:0px;margin-top:30px;"><tr><td style="width:505px;">Útkoma</td></tr></table>
<table style="padding:0px;padding-top:5px;margin:0px;">
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:260px;font-weight:bold;">Heildarlaun</td>
	<td style="width:120px;"></td>
	<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:260px;font-weight:bold;">Útborguð laun</td>
	<td style="width:120px;"></td>
	<td>0 kr.</td></tr>
<tr class="prev" ALIGN="right">
	<td VALIGN="bottom" ALIGN="left" style="width:260px;font-weight:bold;">Heildarkostnaður launagreiðanda</td>
	<td style="width:120px;"></td>
	<td>0 kr.</td></tr></table>

EOD;

// Print text using writeHTMLCell()
        $pdf->writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

// ---------------------------------------------------------
// Close and output PDF document
// This method has several options, check the source code documentation for more information.
        return $pdf->Output('example_001.pdf', 'I');




        //return $pdf->Output();
        /*
          $pdf=new PDF();
          $pdf->AliasNbPages();
          $pdf->AddPage();
          $pdf->SetFont('Times','',12);
          for($i=1;$i<=40;$i++)
          $pdf->Cell(0,10,'Printing line number '.$i,0,1);
          $pdf->Output(); */
    }

    /**
     * Show online count
     *
     * @return  array  The number of Users and Guests online.
     *
     * @since   1.5
     * */
    public static function getOnlineCount() {
        $db = JFactory::getDbo();

        // Calculate number of guests and users
        $result = array();
        $user_array = 0;
        $guest_array = 0;

        $whereCondition = JFactory::getConfig()->get('shared_session', '0') ? 'IS NULL' : '= 0';

        $query = $db->getQuery(true)
                ->select('guest, client_id')
                ->from('#__session')
                ->where('client_id ' . $whereCondition);
        $db->setQuery($query);

        try {
            $sessions = (array) $db->loadObjectList();
        } catch (RuntimeException $e) {
            $sessions = array();
        }

        if (count($sessions)) {
            foreach ($sessions as $session) {
                // If guest increase guest count by 1
                if ($session->guest == 1) {
                    $guest_array ++;
                }

                // If member increase member count by 1
                if ($session->guest == 0) {
                    $user_array ++;
                }
            }
        }

        $result['user'] = $user_array;
        $result['guest'] = $guest_array;

        return $result;
    }

    /**
     * Show online member names
     *
     * @param   mixed  $params  The parameters
     *
     * @return  array   (array) $db->loadObjectList()  The names of the online users.
     *
     * @since   1.5
     * */
    public static function getOnlineUserNames($params) {
        $whereCondition = JFactory::getConfig()->get('shared_session', '0') ? 'IS NULL' : '= 0';

        $db = JFactory::getDbo();
        $query = $db->getQuery(true)
                ->select($db->quoteName(array('a.username', 'a.userid', 'a.client_id')))
                ->from('#__session AS a')
                ->where($db->quoteName('a.userid') . ' != 0')
                ->where($db->quoteName('a.client_id') . ' ' . $whereCondition)
                ->group($db->quoteName(array('a.username', 'a.userid', 'a.client_id')));

        $user = JFactory::getUser();

        if (!$user->authorise('core.admin') && $params->get('filter_groups', 0) == 1) {
            $groups = $user->getAuthorisedGroups();

            if (empty($groups)) {
                return array();
            }

            $query->join('LEFT', '#__user_usergroup_map AS m ON m.user_id = a.userid')
                    ->join('LEFT', '#__usergroups AS ug ON ug.id = m.group_id')
                    ->where('ug.id in (' . implode(',', $groups) . ')')
                    ->where('ug.id <> 1');
        }

        $db->setQuery($query);

        try {
            return (array) $db->loadObjectList();
        } catch (RuntimeException $e) {
            return array();
        }
    }

    public static function getContract() {

        $db = JFactory::getDbo();
        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__mod_selectcalc_sgs4'));
        $db->setQuery($query);
        $result = $db->loadObjectList();
        if (!sizeof($result)) {
            $fields1 = $db->quote(serialize(array('field1', 'field2', 'field3', 'field4', 'field5')));
            $values1 = $db->quote(serialize(array(array('1001', '1002', '1003', '1004', '1005'), array('2001', '2002', '2003', '2004', '2005'))));

            $query = $db->getQuery(true);
            $query->insert($db->quoteName('#__mod_selectcalc_sgs4'))
                    ->columns($db->quoteName(array('fields', 'values')))
                    ->values(implode(",", array("'" . $fields . "'", "'" . $values . "'")));

            $db->setQuery($query)->execute();
        }

        $query = $db->getQuery(true);
        $query->select('*');
        $query->from($db->quoteName('#__mod_selectcalc_sgs4'))->order('`contract_id` ASC');
        ;
        $db->setQuery($query);
        $result = $db->loadObjectList();

        return $result;
    }

    public static function uploadCsvFile($file) {

        if (!empty($file['name'])) {

            jimport('joomla.filesystem.file');
            $filename = JFile::makeSafe($file['name']);
            $src = $file['tmp_name'];
            $path = __DIR__ . '/uploads/';
            $dest = $path . $filename;

            if (strtolower(JFile::getExt($filename)) == 'csv') {
                if (JFile::upload($src, $dest)) {
                    self::parseCsvFile($dest);
                } else {
                    JFactory::getApplication()->enqueueMessage('File not loaded', 'error');
                }
            } else {
                JFactory::getApplication()->enqueueMessage('Incorrect format file', 'error');
            }
        }
    }

    public static function parseCsvFile($dest) {

        $file = file_get_contents($dest);
        $file = html_entity_decode($file);
        $file = preg_split('/\r/', $file);


        $db = JFactory::getDbo();

//		$query = "DROP TABLE `#__mod_selectcalc`";
//		$db->setQuery($query);
//		$db->query();

        $query = "CREATE TABLE IF NOT EXISTS `#__mod_selectcalc` ( `id` int(10) NOT NULL AUTO_INCREMENT, `laun` char(50), `description` text, `hours` float, `contract` int, PRIMARY KEY (`id`) ) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ";

        $db->setQuery($query);
        $db->query();

        $query = "TRUNCATE TABLE  `#__mod_selectcalc` ";
        $db->setQuery($query);
        $db->query();

        $arrResults = array();

        foreach ($file as $row) {
            $csvRow = str_getcsv($row, ',');
//                $arrResults[] = $csvRow;
            if ($csvRow[0] != '' && $csvRow[1] != '' && (int) $csvRow[2] > 0 && (int) $csvRow[3] > 0) {
                $query = $db->getQuery(true);
                $query->insert($db->quoteName('#__mod_selectcalc'))
                        ->columns($db->quoteName(array('laun', 'description', 'hours', 'contract')))
                        ->values(implode(",", array("'" . preg_replace("/[^0-9]/", '', $csvRow[0]) . "'", "'" . $csvRow[1] . "'", "'" . str_replace(",", ".", $csvRow[2]) . "'", "'" . $csvRow[3] . "'")));
                $db->setQuery($query)->execute();
            }
        }

        unlink($dest);
    }

}
