<?php
/**
 * @package     Joomla.Site
 * @subpackage  mod_customcalc6_new
 *
 * @copyright   Copyright (C) 2005 - 2019 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */

defined('_JEXEC') or die;

/**
 * Helper for mod_customcalc6_new
 *
 * @since  1.5
 */
class ModCustomcalc6Helper
{
	public static function getAjax(){

		if($_GET['task']=='draw'){
			//echo '<script src="/modules/mod_customcalc4/tmpl/jquery.editable.min.js" type="text/javascript"></script>';
			$module = JModuleHelper::getModule('mod_customcalc6_new');
		    	echo JModuleHelper::renderModule($module, array( 'style' => 'xhtml'));
		    	return;
		} 

		$user = JFactory::getUser();
		if($_GET['task']=='deletecontract'){
			if( in_array('8', $user->groups)){ return self::delContract((int)$_REQUEST['params']);
			} else return 'not access';
		} 

		if($_GET['task']=='newtable'){
			if( in_array('8', $user->groups)){ return self::addContract();
			} else return 'not access';
		} 
		if($_GET['task']=='edittable'){
			if( in_array('8', $user->groups)){
				$index = explode(":", $_REQUEST['params'][0]);
				$value = $_REQUEST['params'][1];
				if($index[1]=="contract_name") return self::updateContractName( $index[0], $value );
				if($index[1]=="contract_proc") return self::updateContractProc( $index, $value );
				
				return print_r(self::updateContract( $index, $value ), true);
			}
			else return 'not access';
		}
		$user = JFactory::getUser(884);
                $module_id = (int) $_POST['module_id'];
                $mod_row = & JTable::getInstance('Module', 'JTable');
                $mod_row->load($module_id);
                $params_backend = (array) json_decode($mod_row->params);
                
                
		if($_GET['task']=='save' && in_array('8', JFactory::getUser()->groups)){ 
                    
                
                    foreach ($_POST['params'] as $param) {
                        if (array_key_exists($param['name'], $params_backend)) {
                            $params_backend[$param['name']] = $param['value'];
                        }
                    }
                    $updated_params = json_encode($params_backend);

                    $item = new stdClass;
                    $item->id = $module_id;
                    $item->params = $updated_params;

                    $db = & JFactory::getDBO();
                    if (!$db->updateObject('#__modules', $item, 'id')) {
                        return $db->stderr();
                    } else {
                        return 'Data save complete';
                    } 
                
			/*foreach( $_POST['params'] as $par) $params[$par["name"]] = $par["value"];
			$user->defParam('formparams2', json_encode($params));
			$user->setParam('formparams2', json_encode($params) ); $user->save( false );
			return 'Data save complete';*/
                        
		}
		if($_GET['task']=='load'){
			//return $user->getParam('formparams2','');
                    return json_encode($params_backend);
		}

	}


	public static function getContract(){

	
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);
		$query->select( '*' );
	  	$query->from($db->quoteName('#__mod_customcalc6'));
		$db->setQuery($query);
		$result = $db->loadObjectList();
		if (!sizeof( $result )) {
			$fields1 = $db->quote( serialize(array('field1','field2','field3','field4','field5')));
			$values1 = $db->quote( serialize(array(array('1001','1002','1003','1004','1005'),array('2001','2002','2003','2004','2005'))));
			
			$query = $db->getQuery(true);
			$query->insert($db->quoteName('#__mod_customcalc6'))
					->columns($db->quoteName(array(  'fields' , 'values')))
					->values(  implode(",", array(  "'".$fields."'", "'".$values."'" )) );
					
			$db->setQuery($query)->execute();
		}

		$query = $db->getQuery(true);
		$query->select( '*' );
	  	$query->from($db->quoteName('#__mod_customcalc6'))->order('`contract_id` ASC');;
		$db->setQuery($query);
		$result = $db->loadObjectList();

		return $result;

	}
	
	public static function updateContract( $index, $value){

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( '*' );
		$query->from($db->quoteName('#__mod_customcalc6'))->where( $db->quoteName('contract_id') . ' = '. $db->quote((int)$index[0]));
		$db->setQuery($query);
		$result = $db->loadObject();

		if($index[1]){ // change value
			$tmp_value = unserialize($result->values); 
			$tmp_value[$index[1]-1][$index[2]] =  str_replace(['"',"'",'`'],"", $value) ;
			$result->values = serialize( $tmp_value );
			$db->updateObject('#__mod_customcalc6', $result, 'contract_id');
			return $tmp_value;
		} else { // change fields
			$tmp_value = unserialize($result->fields);
			$tmp_value[$index[2]] = str_replace(['"',"'",'`'],"", $value) ;
			$result->fields = serialize($tmp_value);
			$db->updateObject('#__mod_customcalc6', $result, 'contract_id');
			return $tmp_value;
		}
	}

	public static function updateContractName( $index, $value){

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( '*' );
		$query->from($db->quoteName('#__mod_customcalc6'))->where( $db->quoteName('contract_id') . ' = '. $db->quote((int)$index));
		$db->setQuery($query);
		$result = $db->loadObject();
		$result->contract_name = str_replace(['"',"'",'`'],"", $value);
		$db->updateObject('#__mod_customcalc6', $result, 'contract_id');
		return $tmp_value;
	}

	public static function updateContractProc( $index, $value){

		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->select( '*' );
		$query->from($db->quoteName('#__mod_customcalc6'))->where( $db->quoteName('contract_id') . ' = '. $db->quote((int)$index[0]));
		$db->setQuery($query);
		$result = $db->loadObject();

		$tmp_value = unserialize($result->contract_proc);
		$tmp_value[(int)$index[2]] = (float)$value;
		$result->contract_proc = serialize($tmp_value);
			
		$db->updateObject('#__mod_customcalc6', $result, 'contract_id');
		return $tmp_value;
	}

	public static function addContract(){

	
		$db = JFactory::getDbo();

		$query = $db->getQuery(true);
		//$name1 = serialize(array('en-GB' => 'New kontrakt', 'is-IS' => 'Ný samningur'));
		$proc1 = serialize(array('33','45','90'));
		$fields1 = serialize(array('Veldu launaflokk','Byrjunarl.','Eftir 1. ár','Eftir 3. ár','Eftir 5. ár'));
		$values1 = serialize(array(array('Launaflokkur','0','0','0','0'),array('0','0','0','0','0')));
			
			$query = $db->getQuery(true);
			$query->insert($db->quoteName('#__mod_customcalc6'))
					->columns($db->quoteName(array( 'contract_name','contract_proc', 'fields' , 'values')))
					->values(  implode(",", array(  $db->quote("New contract"),"'".$proc1."'","'".$fields1."'", "'".$values1."'" )) );
					//->values(  implode(",", array(  $name1, $proc1, $fields1, $values1 )) );
			$db->setQuery($query)->execute();


		return $db->insertid();
	}
	
	public static function delContract( $index ){

		$db = JFactory::getDbo();

		$query = $db->getQuery(true);
		$query->delete($db->quoteName('#__mod_customcalc6'))->where($db->quoteName('contract_id') . ' = ' . (int)$index); 
		$db->setQuery($query)->execute();

		return (string)$query;
	}
	
	public static function uploadCsvFile($file){
            
            if(!empty($file['name'])){
                
                jimport('joomla.filesystem.file');
                $filename = JFile::makeSafe($file['name']);
                $src = $file['tmp_name'];
                $path = __DIR__ . '/uploads/';
                $dest = $path . $filename;
                
                if ( strtolower(JFile::getExt($filename) ) == 'csv') {
                    if ( JFile::upload($src, $dest) ) { 
                        self::parseCsvFile($dest);
                    } else {
                       JFactory::getApplication()->enqueueMessage('File not loaded', 'error');
                    }
                } else {
                   JFactory::getApplication()->enqueueMessage('Incorrect format file', 'error');
                }
            }
            
    }
        
        
    public static function parseCsvFile($dest){
            
            $file = file_get_contents($dest);
            $file = html_entity_decode($file);
            $file = preg_split('/\r/', $file );
           
            $arrResults = array();
            foreach ($file as $row){
                 $csvRow = str_getcsv($row, ';');
                 $arrResults[] = $csvRow;
            }

			$db = JFactory::getDbo();
			$tmp_val = array();
			foreach($arrResults as $key => $value) {
				if ( $key == 0 ) $fields =  serialize(str_replace(['"',"'",'`'],"", $value));
				else if ( sizeof($value) == sizeof($arrResults[0]) ) $tmp_val[] = str_replace(['"',"'",'`'],"", $value);
			}
			$values = serialize( $tmp_val );

			if( (int)$_REQUEST['contract_id']>0 ){

				$result = new stdClass();
				$result->contract_id = (int)$_REQUEST['contract_id'];
				$result->fields = $fields;
				$result->values = $values;
				$db->updateObject('#__mod_customcalc6', $result, 'contract_id');
				
			} else {
				$query = $db->getQuery(true);
				$query->insert($db->quoteName('#__mod_customcalc6'))
					->columns($db->quoteName(array(  'fields' , 'values')))
					->values(  implode(",", array(  "'".$fields."'", "'".$values."'" )) );
				$db->setQuery($query)->execute();
			}
            
            unlink($dest);
    }

}
