<?php

/**
 * @package     Joomla.Site
 * @subpackage  mod_login
 *
 * @copyright   Copyright (C) 2005 - 2015 Open Source Matters, Inc. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 */
defined('_JEXEC') or die;

// Include the login functions only once
require_once __DIR__ . '/helper.php';

$params->def('greeting', 1);

$type = ModLoginHelper::getType();
$return = ModLoginHelper::getReturnURL($params, $type);
$twofactormethods = ModLoginHelper::getTwoFactorMethods();
$user = JFactory::getUser();


$app = JFactory::getApplication();
$template_name = $app->getTemplate();

if ($template_name != 'curiotimenew') {
    $layout = $params->get('layout', 'default');
    // Logged users must load the logout sublayout
    if (!$user->guest) {
        $layout .= '_logout';
    }
} else {
    $layout = 'login_new';
    // Logged users must load the logout sublayout
    if (!$user->guest) {
        $layout = 'logout_new';
    }
}



require JModuleHelper::getLayoutPath('mod_login', $layout);
