<?php
const _JEXEC = 1;

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
    define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);
    require_once JPATH_BASE . '/includes/defines.php';
}

// Get the framework.
require_once JPATH_LIBRARIES . '/import.legacy.php';

// Bootstrap the CMS libraries.
require_once JPATH_LIBRARIES . '/cms.php';

// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

require_once JPATH_BASE . '/includes/framework.php';

//jimport('joomla.application.component.controller');
$mainframe = & JFactory::getApplication('site');

$db = & JFactory::getDBO();
$user = & JFactory::getUser();


$l2 = $_GET['lang'];

$lang = JFactory::getLanguage();
//file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
if ($l2 == 'is') {

    $extension = 'com_spec_holiday2';
    $base_dir = JPATH_SITE;
    $language_tag = 'is-IS';
    $reload = true;
    $lang->load($extension, $base_dir, $language_tag, $reload);
} else {
    
    $extension = 'com_spec_holiday2';
    $base_dir = JPATH_SITE;
    $language_tag = 'en-GB';
    $reload = true;
    $lang->load($extension, $base_dir, $language_tag, $reload);
}
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_EDIT_PERIOD') ?></title>
    	<link type="text/css" rel="stylesheet" href="media/layout.css" />   
        <link href="//fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet" type="text/css">
        <link type="text/css" rel="stylesheet" href="media/layout_iframe_custom.css?time=<?=time()?>" />    
        <script src="js/jquery/jquery-1.9.1.min.js" type="text/javascript"></script>
    </head>
    <body>
        <?php
            // check the input
            is_numeric($_GET['id']) or die("invalid URL");
            
            require_once '_db.php';
            
            $stmt = $db->prepare('SELECT * FROM reservations WHERE id = :id');
            $stmt->bindParam(':id', $_GET['id']);
            $stmt->execute();
            $reservation = $stmt->fetch();
            
            /*echo '<pre>';
            print_r($reservation);
            echo '</pre>';*/
            //$id=(int)$_GET['id'];
            
            /*$query = "SELECT * FROM reservations WHERE `id` = '$id'";
            $db->setQuery($query);
            $reservation = $db->loadObject();*/
            
            $rooms = $db->query('SELECT * FROM rooms');
            
            $start_raw = $reservation['start']; // TODO parse and format
            $start_arr=explode('-', $start_raw);
            
            /*echo '<pre>';
            print_r($start_arr);
            echo '</pre>';*/
            
            $hours_separated_arr=explode(' ', $start_arr[2]);
            $hours_separated=$hours_separated_arr[0];
            /*echo '<pre>';
            print_r($hours_separated_arr);
            echo '</pre>';*/
            $start=$hours_separated.'-'.$start_arr[1].'-'.$start_arr[0];
        
            $end_raw = $reservation['end']; // TODO parse and format
            $end_arr=explode('-', $end_raw);
            $hours_separated_arr_end=explode(' ', $end_arr[2]);
            $hours_separated_end=$hours_separated_arr_end[0];
            
            $end=$hours_separated_end.'-'.$end_arr[1].'-'.$end_arr[0];
        ?>
        <form id="f" action="/index.php?option=com_spec_holiday2&task=editPeriod" style="padding:20px;">
            <input type="hidden" name="id" value="<?php print $_GET['id'] ?>" />
            <h1><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_EDIT_PERIOD') ?></h1>
            
            <div class="space">
                <div><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_START') ?></div>
                <div><input type="text" id="start" class="hidden_original_start" name="start" value="<?php print $reservation['start'] ?>" /></div>
                <div><input type="text"  class="new_start" value="<?php echo $start ?>" /></div>
            </div>
            
            <div class="space">
                <div><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_END') ?></div>
                <div><input type="text" id="end" class="hidden_original_end" name="end" value="<?php print $reservation['end'] ?>" /></div>
                <div><input type="text" class="new_end" value="<?php echo $end ?>" /></div>
            </div>
            <?php
               // echo $reservation['room_id'].' - '.$room['id'];
            ?>
            <div class="space hidden_block">
                <div>Room:</div>
                <div>
                    <select id="room" name="room">
                        <?php 
                            foreach ($rooms as $room) {
                                $selected = $reservation['room_id'] == $room['id'] ? ' selected="selected"' : '';
                                $id = $room['id'];
                                $name = $room['name'];
                                print "<option value='$id' $selected>$name</option>";
                            }
                        ?>
                    </select>
                </div>
            </div>
            
            <div class="space hidden_block">
                <div>Name: </div>
                <div><input type="text" id="name" name="name" value="<?php print $reservation['name'] ?>" /></div>
            </div>
            
            <div class="space">
                <div>Status:</div>
                <div>
                    <select id="status" name="status">
                        <?php 
                            $options = [
                                "Confirmed"=>[
                                    'status'=>"Confirmed",
                                    'selected'=>''
                                ], 
                                "Pending"=>[
                                    'status'=>"Pending",
                                    'selected'=>''
                                ],
                            ];
                            
                            if($reservation['status']=='New'){
                                $selected='selected';
                                $options['Confirmed']['selected']='selected';
                            } elseif($reservation['status']=='api_suggested'){
                                $selected='selected';
                                $options['Pending']['selected']='selected';
                            }
                            foreach ($options as $option) {
                                //$selected = $option == $reservation['status'] ? ' selected="selected"' : '';
                                $selected=$option['selected'];
                                
                                $id = $option['status'];
                                $name = $id;
                                print "<option value='$id' $selected>$name</option>";
                            }
                        ?>
                    </select>                
                </div>
            </div>
            
            <div class="space hidden_block">
                <div>Paid:</div>
                <div>
                    <select id="paid" name="paid">
                        <?php 
                            $options = array(0, 50, 100);
                            foreach ($options as $option) {
                                $selected = $option == $reservation['paid'] ? ' selected="selected"' : '';
                                $id = $option;
                                $name = $option."%";
                                print "<option value='$id' $selected>$name</option>";
                            }
                        ?>
                    </select>
                </div>
            </div>
            
            <div class="space">
                <input type="submit" class="lock_button" value="<?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_SAVE') ?>" /> <a href="javascript:close();"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_CANCEL') ?></a>
            </div>
        </form>
        
        <script type="text/javascript">
        function close(result) {
            if (parent && parent.DayPilot && parent.DayPilot.ModalStatic) {
                parent.DayPilot.ModalStatic.close(result);
            }
        }

        $("#f").submit(function () {
            console.log('submit');
            var f = $("#f");
          
            //2019-10-12 00:00:00-old format
            let js=$;
            js('.lock_button').attr("disabled", true);
                
            let 
                new_start=js('.new_start').val(),
                new_end=js('.new_end').val(),
                    
                new_start_formatted_arr=new_start.split('-'),
                new_start_formatted=new_start_formatted_arr[2]+'-'+new_start_formatted_arr[1]+'-'+new_start_formatted_arr[0]+' 00:00:00',
                    
                new_end_formatted_arr=new_end.split('-'),
                new_end_formatted=new_end_formatted_arr[2]+'-'+new_end_formatted_arr[1]+'-'+new_end_formatted_arr[0]+' 00:01:00';
                    
                console.log(new_start_formatted);
                console.log(new_end_formatted);
                js('.hidden_original_start').val(new_start_formatted);
                js('.hidden_original_end').val(new_end_formatted);
                
                $.post(f.attr("action"), f.serialize(), function (result) {
                    close(eval(result));
                });
                return false;
        });

        $(document).ready(function () {
            $("#name").focus();
        });
    
        </script>
    </body>
</html>
