<?php

/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Spec_holiday2 list modelloadEnevts
 */
class Spec_holiday2ModelTthtml5 extends JModelList {

    /**
     * Constructor
     *
     * @param    array          An optional associative array of configuration settings
     *
     * @see      JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'created_by', 'a.created_by',
                'state', 'a.state',
                'ordering', 'a.ordering',
            );
        }
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state
     *
     * Note. Calling getState in this method will result in recursion
     *
     * @param   string  $ordering   An optional ordering field
     * @param   string  $direction  An optional direction (asc|desc)
     *
     * @return  void
     *
     * @since   1.6
     */
    protected function populateState($ordering = null, $direction = null) {
        $app = JFactory::getApplication();
        $input = $app->input;

        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        // Load the list state
        $this->setState('list.start', $input->get('limitstart', 0, 'uint'));
        $this->setState('list.limit', $input->get('limit', $app->get('list_limit', 20), 'uint'));

        // List state information
        parent::populateState($ordering, $direction);
    }

    /**
     * Build an SQL query to load the list data
     *
     * @return    JDatabaseQuery
     * @since    1.6
     */
    protected function getListQuery() {
        $query = $this->_db->getQuery(true);

        $query->select('a.id, a.state, a.ordering');

        $query->from('`#__spec_holiday_views` AS a');

        $query->select('b.name as created_by');
        $query->leftJoin($this->_db->qn('#__users') . ' AS b ON b.id = a.created_by');

        $query->where('a.state = 1');

        // Search for this word
        $searchWord = $this->getState('filter.search');

        // Search in these columns
        $searchColumns = array(
            'b.name',
        );

        if (!empty($searchWord)) {
            if (stripos($searchWord, 'id:') === 0) {
                // Build the ID search
                $idPart = (int) substr($searchWord, 3);
                $query->where($this->_db->qn('a.id') . ' = ' . $this->_db->q($idPart));
            } else {
                $query = Spec_holidayHelpersFrontend::buildSearchQuery($searchWord, $searchColumns, $query);
            }
        }

        // Add the list ordering clause
        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');

        if ($orderCol && $orderDirn) {
            $query->order($this->_db->escape($orderCol . ' ' . $orderDirn));
        } else {
            $query->order('a.ordering');
        }

        return $query;
    }

    /** Method to get an array of data items
     *
     * @return  mixed An array of data on success, false on failure.
     */
    public function getItems() {
        $items = parent::getItems();

        include_once JPATH_COMPONENT_ADMINISTRATOR . '/helpers/form/view.php';

        $form = new FormViewSpec_holiday;

        $fieldOptions = $form->getFieldOptions();

        foreach ($items as $i => $item) {
            foreach ($item as $key => $value) {
                // If this field has options
                if (isset($fieldOptions[$key])) {
                    // Update the item key with the field option
                    $item->{$key} = JText::_($fieldOptions[$key][$value]);
                }
            }

            $items[$i] = $item;
        }

        return $items;
    }


    /****************************************/
    public function getManagerUsersObj($mode, $u_id)
    {
        if ($mode != 'api_html') {
            $owner_id = $this->user->owner_id;
        } else {
            $user = JFactory::getUser($u_id);
            $owner_id = $user->owner_id;
        }
        $db = & JFactory::getDBO();

        if(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        } else{
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        }



        return $data;
    }

    public function movePeriod()
    {
        $overlaps = $this->checkPeriod();
        $response = new stdClass();
        
        if ($overlaps) {
            
            $response->result = 'Error';
            $response->message = 'This reservation overlaps with an existing reservation.';
            $response->type='error';
        } else{
            $start=$this->db->escape(trim($_POST['newStart']));
            $end=$this->db->escape(trim($_POST['newEnd']));
            $id=(int)$_POST['id'];
            $resourse=$this->db->escape(trim($_POST['newResource']));
        
            /*$stmt = $db->prepare("UPDATE reservations SET start = :start, end = :end, room_id = :resource WHERE id = :id");
            $stmt->bindParam(':id', $_POST['id']);
            $stmt->bindParam(':start', $_POST['newStart']);
            $stmt->bindParam(':end', $_POST['newEnd']);
            $stmt->bindParam(':resource', $_POST['newResource']);
            $stmt->execute();


            $response = new Result();
            $response->result = 'OK';
            $response->message = 'Update successful';*/
            
            $item = new stdClass();
            $item->id = $id;
            $item->start = $start;
            $item->end = $end;
            $item->room_id=$resourse;
            
            if($this->db->updateObject('reservations', $item, 'id')){
                $response->result = 'OK';
                $response->message = 'Update successful';
                $response->type='success';
            }
        }
        
        return (array)$response;
    }
    
    private function checkPeriod()
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($data, true), FILE_APPEND | LOCK_EX);    
        //old code
        /*$stmt = $db->prepare("SELECT * FROM reservations WHERE NOT ((end <= :start) OR (start >= :end)) AND id <> :id AND room_id = :resource");
        $stmt->bindParam(':start', $_POST['newStart']);
        $stmt->bindParam(':end', $_POST['newEnd']);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':resource', $_POST['newResource']);
        $stmt->execute();
        $overlaps = $stmt->rowCount() > 0;*/
        
        $start=$this->db->escape(trim($_POST['newStart']));
        $end=$this->db->escape(trim($_POST['newEnd']));
        $id=(int)$_POST['id'];
        $resourse=$this->db->escape(trim($_POST['newResource']));
        
        $query = "SELECT * FROM reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND id <> '".$id."' AND room_id = '".$resourse."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        if(count($data)>0){
            $overlaps=true;
        }
        return $overlaps;
        
    }
    
    public function resizePeriod()
    {
        /*$stmt = $db->prepare("UPDATE reservations SET start = :start, end = :end WHERE id = :id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':start', $_POST['newStart']);
        $stmt->bindParam(':end', $_POST['newEnd']);
        $stmt->execute();


        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Update successful';

        header('Content-Type: application/json');
        echo json_encode($response);*/
        
        $response = new stdClass();
        $start=$this->db->escape(trim($_POST['newStart']));
        $end=$this->db->escape(trim($_POST['newEnd']));
        $id=(int)$_POST['id'];
        
        $item = new stdClass();
        $item->id = $id;
        $item->start = $start;
        $item->end = $end;
  
        if($this->db->updateObject('reservations', $item, 'id')){
            $response->result = 'OK';
            $response->message = 'Resize successful';
            $response->type='success';
            
            //get user id in reservations table(room_id field)
            //$user_id=$this->getUserByReservation($item->id);
            
            //add colors to Calendar page. See this screen http://prntscr.com/pkghey
            //$this->setCalendarDate($item->start, $item->end, $user_id, 'resize');
        }
        return (array)$response;
    }
    
    public function deletePeriod()
    {
        /*$stmt = $db->prepare("DELETE FROM reservations WHERE id = :id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->execute();

        class Result {}

        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Delete successful';

        header('Content-Type: application/json');
        echo json_encode($response);*/
        
        $response = new stdClass();
        $id=(int)$_POST['id'];
        
        /*$query = $this->db->getQuery(true)
            ->delete($this->db->quoteName('reservations'))
            ->where($this->db->quoteName('id') . ' = ' . $id);*/
        
        $query = "DELETE FROM `reservations` WHERE `id` = '$id';";
        $this->db->setQuery($query);
        //$this->db->query();
        
        //if($this->db->setQuery($query)){
        if($this->db->query()){
            $response->result = 'OK';
            $response->message = 'Delete successful';
            $response->type='success';
        }
        return (array)$response;
    }
    
    public function loadEnevts()
    {
        /*$start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        $end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];

        $stmt = $db->prepare("SELECT * FROM reservations WHERE NOT ((end <= :start) OR (start >= :end))");
        $stmt->bindParam(':start', $start);
        $stmt->bindParam(':end', $end);
        $stmt->execute();
        $result = $stmt->fetchAll();

        class Event {}
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);

        foreach($result as $row) {
            $e = new Event();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = "Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $events[] = $e;

    
        }

        header('Content-Type: application/json');
        echo json_encode($events);*/
        
        $start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        $end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];
        
        $query = "SELECT * FROM reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."'))";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = "Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $events[] = $e;

    
        }
       // file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($events, true), FILE_APPEND | LOCK_EX);
        return $events;
    }
    
    public function loadRooms()
    {
        /*$jinput = JFactory::getApplication()->input;

        $department_obj = $_REQUEST['dep'];
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($department_obj, true), FILE_APPEND | LOCK_EX);

        $department_arr = isset($department_obj) ? $department_obj : '';
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($department_arr, true), FILE_APPEND | LOCK_EX);

        //$owner_id = filter_input(INPUT_COOKIE, 'ownerID', FILTER_VALIDATE_INT);
        $owner_id=$user->owner_id;

        if($user->company==='Thingvangur'){
            //$query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' LIMIT 0,1";
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
        } else{
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
        }

        $db->setQuery($query);
        $rooms = $db->loadAssocList();

        class Room {
    
        }

        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr))
            continue;

            $r = new Room();
            $r->id = $room['id'];
            $r->name = $room['name'];
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }

        header('Content-Type: application/json');
        echo json_encode($result);*/
        
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id=$this->user->owner_id;
        
        if(in_array(6, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } elseif(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."' AND `is_hide`='0'";
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        }
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username=$room['username0']; } 
            elseif(!empty($room['username'])){ $final_username=$room['username']; }
            elseif(!empty($room['name'])){ $final_username=$room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($result, true), FILE_APPEND | LOCK_EX);

        return $result;

    }
    
    public function addPeriod()
    {
        /*$stmt = $db->prepare("INSERT INTO reservations (name, start, end, room_id, status, paid) VALUES (:name, :start, :end, :room, 'New', 0)");
        $stmt->bindParam(':start', $_POST['start']);
        $stmt->bindParam(':end', $_POST['end']);
        $stmt->bindParam(':name', $_POST['name']);
        $stmt->bindParam(':room', $_POST['room']);
        $stmt->execute();

        class Result {}

        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Created with id: '.$db->lastInsertId();
        $response->id = $db->lastInsertId();

        header('Content-Type: application/json');
        echo json_encode($response);*/
        
        $start=$this->db->escape(trim($_POST['start']));
        $end=$this->db->escape(trim($_POST['end']));
        $name=$this->db->escape(trim($_POST['name']));
        $room=(int)$_POST['room'];
        
        $item = new stdClass();
        $response=new stdClass();
        
        $item->id = null;
        $item->name = $name;
        $item->start=$start;
        $item->end = $end;
        $item->room_id=$room;
        $item->status='New';
        $item->paid=0;
  
        if($this->db->insertObject('reservations', $item)){
            $response->result = 'OK';
            
            $insert_id=$this->db->insertid();
            $response->message = 'Created with id: '.$insert_id;
            $response->id = $insert_id;
            $response->type='success';
            
            //get user id in reservations table(room_id field)
            //$user_id=$this->getUserByReservation($item->id);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($user_id, true), FILE_APPEND | LOCK_EX);
                
            $user_id=$room;
            //add colors to Calendar page. See this screen http://prntscr.com/pkghey
            $this->setCalendarDate($item->start, $item->end, $user_id, 'add');
        }
        return (array)$response;
    }
    
    public function editPeriod()
    {
        /*require_once '_db.php';

        $stmt = $db->prepare("UPDATE reservations SET name = :name, start = :start, end = :end, room_id = :room, status = :status, paid = :paid WHERE id = :id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':name', $_POST['name']);
        $stmt->bindParam(':start', $_POST['start']);
        $stmt->bindParam(':end', $_POST['end']);
        $stmt->bindParam(':room', $_POST['room']);
        $stmt->bindParam(':status', $_POST['status']);
        $stmt->bindParam(':paid', $_POST['paid']);
        $stmt->execute();

        class Result {}

        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Update successful';

        header('Content-Type: application/json');
        echo json_encode($response);*/
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($_POST, true), FILE_APPEND | LOCK_EX);
        $id=(int)$_POST['id'];
        $start=$this->db->escape(trim($_POST['start']));
        $end=$this->db->escape(trim($_POST['end']));
        $name=$this->db->escape(trim($_POST['name']));
        $room=(int)$_POST['room'];
        $status=$this->db->escape(trim($_POST['status']));
        $paid=$this->db->escape(trim($_POST['paid']));
        
        $item = new stdClass();
        $response=new stdClass();
        
        $item->id = $id;
        $item->name = $name;
        $item->start=$start;
        $item->end = $end;
       // $item->room_id=$room;
        $request_status=$status;
        
        if($status=='Confirmed'){
            $status='New';
        } elseif($status=='Pending'){
            $status='api_suggested';
        }
        $item->status=$status;
        $item->paid=$paid;
  
        $status_in_db=$this->loadHolidayStatus($item->id);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($status_in_db, true), FILE_APPEND | LOCK_EX);
            
        if($this->db->updateObject('reservations', $item, 'id')){
            $response->result = 'OK';
            $response->message = 'Update successful';
            $response->type='success';
            
           
            if($request_status==='Confirmed' && $status_in_db=='api_suggested'){
                //get user id in reservations table(room_id field)
                $user_id=$this->getUserByReservation($item->id);
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($user_id, true), FILE_APPEND | LOCK_EX);
                
                //add colors to Calendar page. See this screen http://prntscr.com/pkghey
                $this->setCalendarDate($item->start, $item->end, $user_id, 'update');
            }
        }
        return (array)$response;
    }

    private function loadHolidayStatus($id)
    {
        
        $query = "SELECT `status` FROM `reservations` WHERE `id` = '$id'";
        $this->db->setQuery($query);
        return $this->db->loadResult();
    }
    
    private function getUserByReservation($row_id)
    {
        $query = "SELECT `room_id` FROM reservations WHERE `id` = '$row_id'";
        $this->db->setQuery($query);
        $user_id = $this->db->loadResult();
        
        return $user_id; 
    }
    
    private function setCalendarDate($start, $stop, $user_id, $func_mode)
    {
        $date_start=$start;
        $date_end=$stop;
        
        //color code in calendar
        $new_status=6; 
        
        //include weekend. set 1 if need write in all days
        $weekend_status=1;
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
       
        $result= $this->addReportItems($user_id, $date_start, $date_end, $new_status, $weekend_status, $func_mode);
       //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($result, true), FILE_APPEND | LOCK_EX);
        return $result;
    }

    private function checkReportItemStatus($user_id, $date_year, $date_month, $date_day)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'"  AND `year`="'.$date_year.'" AND `month`="'.$date_month.'" AND `day`="'.$date_day.'"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        return $user_report->status;
    }
    
    private function reverseConvertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        //$from_date = $from_date_raw->format('d.m.Y');
        $from_date = $from_date_raw->format('U');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        //$to_date = $to_date_raw->format('d.m.Y');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    private function addReportItems($user_id, $date_start, $date_end, $new_status, $weekend_status, $func_mode)
    {
        //convert dates to linux timestump format
        if($func_mode==='update'){
            $dates=$this->reverseConvertDates($date_start, $date_end);
        } elseif($func_mode==='add'){
            $dates=$this->convertDates($date_start, $date_end);
        } elseif($func_mode==='resize'){
            $dates=$this->convertDatesCI($date_start, $date_end);
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($dates, true), FILE_APPEND | LOCK_EX);

        $year_start=date('Y', $dates['start']);
        $month_start=date('n', $dates['start']);
        $day_start=date('j', $dates['start']);
        
        
        $date_end = date('d-m-Y', strtotime(date('Y-m-d', $dates['end']).' +1day'));
        
        $from = DateTime::createFromFormat('U', $dates['start']);
        $to   =  DateTime::createFromFormat('U', $dates['end']);
        
        
        if($func_mode==='add' || $func_mode==='resize'){
           // $different = $from->diff($to)->format('%R%a');
            $to=$to->modify('+1 day');
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($different, true), FILE_APPEND | LOCK_EX);
        }
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
   
        
        $arrayOfDates = array_map(
            function($item){
                return $item->format('Y.n.j');
            
            },
            iterator_to_array($period)
        );
        $dates_array=[];
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);     
       
        
        //exit;
            
        foreach($arrayOfDates as $date){
            if($weekend_status=='1'){//include weekends
                $date_explode=explode('.', $date);
                $year=$date_explode[0];
                $month=$date_explode[1];
                $day=$date_explode[2];
            
                $dates_array[]['status']=$this->checkReportItemStatus($user_id, $year, $month, $day);
                $dates_array[]['day']=$day;
                $dates_array[]['month']=$month;
                $dates_array[]['year']=$year;
                $dates_array[]['typeof']=gettype( $date);
            
                $old_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
                if(!empty($old_item_status)){
                    $this->updateReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'update item status';           
                } else{            
                    $this->insertReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'add new report item';
                }
            } 
        }
        return json_encode($dates_array);
    }
    
    private function insertReportItem($user_id, $status_user, $year, $month, $day)
    {    
        $query = "INSERT INTO #__user_report_items (id_user, status, year, month, day) VALUES ('".$user_id."', '".$status_user."', '".$year."', '".$month."', '".$day."')";    
        $this->db->setQuery($query);	 
        $this->db->query(); 
    }
    
    private function updateReportItem($user_id, $status_user, $year, $month, $day)
    {
        $query = "UPDATE #__user_report_items SET `status`='".$status_user."' WHERE `id_user`='".$user_id."' AND `month`='".$month."' AND `year`='".$year."' AND `day`='".$day."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function convertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d', $from);
        //$from_date = $from_date_raw->format('Y-m-d 00:00:00');
        $from_date = $from_date_raw->format('U');

        $to_date_raw = DateTime::createFromFormat('Y-m-d', $to);
        //$to_date = $to_date_raw->format('Y-m-d 00:00:00');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    public function convertDatesCI($from, $to)
    {
        $from_explode=explode('T', $from);
        $from_date_raw = DateTime::createFromFormat('Y-m-d', $from_explode[0]);
        //$from_date = $from_date_raw->format('Y-m-d 00:00:00');
        $from_date = $from_date_raw->format('U');
        
        $to_explode=explode('T', $to);
        $to_date_raw = DateTime::createFromFormat('Y-m-d', $to_explode[0]);
        //$to_date = $to_date_raw->format('Y-m-d 00:00:00');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
}
