<?php
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modelitem');

class CtapiModelApi extends JModelItem {
    private $db;
    
    public $companyModsTableName  =  "#__api_company_mods";
    
    public function __construct() {
        $this->db = & JFactory::getDBO();
    }    
    
    
    public function resetCompanies() {
        $sql  =  "truncate table ".$this->companyModsTableName;
        $this->db->setQuery($sql);
        $this->db->query();
    }
    
    public function allMods() {
        $mods  =  array();        
        $tmp  = json_decode(file_get_contents("https://api.curiooffice.com/index.php?option=com_coapi&task=system.modules"),true);
        if(is_array($tmp))
            $mods  = $tmp;
        return $mods;
    }
    
    public function getUserMods($userId) {
        $user = & JFactory::getUser($userId); 
        if(empty($user) || $user->id < 1)
            return array();        
        $company = $user->company;
        return $this->getCompanyMods($company);
    }
    
    public function getCompanies($default = 1) {
        $query  =   "SELECT company FROM #__users WHERE company IS NOT NULL AND company  <> '' order by company ASC";
        $this->db->setQuery($query);
        $list =  $this->db->loadObjectList();
        $companies  =  array();
        foreach ($list as $obj) {
            $companies[$obj->company] = array();
        }
        foreach ($companies as $company=>$mods) {
            $companies[$company] = $this->getCompanyMods($company,$default);
        }
        return $companies;
    }
    
    public function getCompanyMods($company,$default  =  1) {
        $allMods  =  $this->allMods();
        $query  =   "SELECT * FROM {$this->companyModsTableName} WHERE company = ".$this->db->quote($company);
        $this->db->setQuery($query);
        $list =  $this->db->loadObjectList();
        $mods  =  array();
        foreach ($list as $item) {
            $mods[$item->mod] = intval($item->enabled);
        }
        foreach ($allMods as $m=>$label) {
            if(!isset($mods[$m]))
                $mods[$m]  = $default;
        }
        return $mods;
    }
    
}