<?php
/**
 *
 * Show the product details page
 *
 * @package	VirtueMart
 * @subpackage
 * @author Max Milbers, Eugen Stranz, Max Galt
 * @link http://www.virtuemart.net
 * @copyright Copyright (c) 2004 - 2014 VirtueMart Team. All rights reserved.
 * @license http://www.gnu.org/copyleft/gpl.html GNU/GPL, see LICENSE.php
 * VirtueMart is free software. This version may have been modified pursuant
 * to the GNU General Public License, and as distributed it includes or
 * is derivative of works licensed under the GNU General Public License or
 * other free or open source software licenses.
 * @version $Id: default.php 8842 2015-05-04 20:34:47Z Milbo $
 */
// Check to ensure this file is included in Joomla!
defined('_JEXEC') or die('Restricted access');

/* Let's see if we found the product */
if (empty($this->product)) {
	echo vmText::_('COM_VIRTUEMART_PRODUCT_NOT_FOUND');
	echo '<br /><br />  ' . $this->continue_link_html;
	return;
}


echo shopFunctionsF::renderVmSubLayout('askrecomjs',array('product'=>$this->product));



if(vRequest::getInt('print',false)){ ?>
<body onload="javascript:print();">
<?php } ?>
    
 

<div class="productdetails-view productdetails">
    

    
    <div class="left-coll-product">
        <?php
            echo $this->loadTemplate('images');
            $count_images = count ($this->product->images);
            if ($count_images > 1) {
                    echo $this->loadTemplate('images_additional');
            }
            

        ?>
        
    </div>
    
    <div class="right-coll-product">
        <div class="title-product"><h1><?php echo $this->product->product_name ?></h1></div>
        <div class="description-product">
            <?php echo $this->product->product_desc; ?>
        </div>
        <div class="price-product">
             <div class="spacer-buy-area">
                 <br>
		<?php
		

		if (is_array($this->productDisplayShipments)) {
		    foreach ($this->productDisplayShipments as $productDisplayShipment) {
			//echo $productDisplayShipment . '<br />';
		    }
		}
		if (is_array($this->productDisplayPayments)) {
		    foreach ($this->productDisplayPayments as $productDisplayPayment) {
			//echo $productDisplayPayment . '<br />';
		    }
		}
		echo shopFunctionsF::renderVmSubLayout('prices',array('product'=>$this->product,'currency'=>$this->currency));
		?> 
                 <div class="clear"></div>
                <?php
		echo shopFunctionsF::renderVmSubLayout('addtocart',array('product'=>$this->product));
		echo shopFunctionsF::renderVmSubLayout('stockhandle',array('product'=>$this->product));
		?>
	    </div>
            
        </div>
        
         
        
    </div>
    <div id="list-slider-prod">
        <div class="list-prod">
            <?php 
                 $imagesProductsLinks = VirtueMartControllerProductdetails::getImageIinksProducts(); 

                 if($imagesProductsLinks){
                     foreach ($imagesProductsLinks as $img){
                         $link = JRoute::_("index.php?option=com_virtuemart&view=productdetails&virtuemart_product_id=$img->virtuemart_product_id&virtuemart_category_id=13");
                         echo '<a href="'.$link.'"><img width="200" data-lazy="'.$img->file_url.'" class="product_thumb" src="'.$img->file_url.'"></a>';
                     }
                 }

            ?>
        </div>
    </div>    
    
<?php

// Show child categories
if (VmConfig::get('showCategory', 1)) {
	echo $this->loadTemplate('showcategory');
}

$j = 'jQuery(document).ready(function($) {
	Virtuemart.product(jQuery("form.product"));

	$("form.js-recalculate").each(function(){
		if ($(this).find(".product-fields").length && !$(this).find(".no-vm-bind").length) {
			var id= $(this).find(\'input[name="virtuemart_product_id[]"]\').val();
			Virtuemart.setproducttype($(this),id);

		}
	});
});';
//vmJsApi::addJScript('recalcReady',$j);

/** GALT
	 * Notice for Template Developers!
	 * Templates must set a Virtuemart.container variable as it takes part in
	 * dynamic content update.
	 * This variable points to a topmost element that holds other content.
	 */
$j = "Virtuemart.container = jQuery('.productdetails-view');
Virtuemart.containerSelector = '.productdetails-view';";

vmJsApi::addJScript('ajaxContent',$j);

echo vmJsApi::writeJS();
?> </div>
    
    
   
    
    
    
    




