<?php
/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

// No direct access
defined('_JEXEC') or die;

//JHTML::_('behavior.modal');
$app = JFactory::getApplication();
$paramsComponentGmap = JComponentHelper::getParams('com_spec_holiday');

$api_key = $paramsComponentGmap->get('key_map', 'AIzaSyBqAD4avBQ56KkFrFwrwb8vMRURe6qgURo');

$document = JFactory::getDocument();
$base_path = JURI::base();
$lang = & JFactory::getLanguage();
$langTag = $lang->getTag();
$db = & JFactory::getDBO();

$mapWidth = $paramsComponentGmap->get('Width', 100);
$u = JFactory::getUser();
if ($lang->getName() == "Íslenska (Ísland)") {
    $l = '/is';
    $l2 = 'is';
   
} else {
    $l = '/en';
    $l2 = 'en';
   
}
if ($u->get('guest')) {
    $app = JFactory::getApplication();
    $l = $l . '/curio-time';
    $app->redirect($l, false);
}
if (in_array(9, $u->groups)) {
    $app = JFactory::getApplication();
    $l = $l . '/curio-time';
    $app->redirect($l, false);
}

$document->addStyleSheet('/media/com_spec_holiday/css/popup_calendar.css?time=' . time());
$document->addStyleSheet('/media/com_spec_holiday/css/stylesheet.css?time=' . time());
$document->addStyleSheet('/media/com_spec_holiday/css/jquery_ui_themes_base.css');
JHtml::_('jquery.framework');
//$document->addStyleSheet('http://ajax.googleapis.com/ajax/libs/jqueryui/1.8.6/themes/cupertino/jquery-ui.css');

//calendar incl
$document->addScript('/media/com_spec_holiday/incl/popup_calendar/moment.min.js');
if($l2==='is'){
   $document->addScript('/media/com_spec_holiday/incl/datepicker_iframe/is.js'); 
}
$document->addStyleSheet('//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css');
$document->addScript('/media/com_spec_holiday/incl/popup_calendar/moment.min.js');
$document->addScript('/media/com_spec_holiday/incl/popup_calendar/daterangepicker.js');
$document->addStyleSheet('/media/com_spec_holiday/css/daterangepicker.css');
//end calendar incl

$document->addScript('/media/com_spec_holiday/js/component.js?time=' . time());

$document->addScript('/media/com_spec_holiday/incl/jquery-ui-1.12.1.custom/jquery-ui.min.js');
$document->addScript('/media/com_spec_holiday/incl/jquery-ui-touch-punch-master/jquery.ui.touch-punch.min.js');
$document->addScript('/media/com_spec_holiday/incl/jQuery-Mask-Plugin/dist/jquery.mask.min.js');
$document->addScript('/media/com_spec_holiday/js/moment.js');
$model=$this->getModel();


$user_id = $u->id;
$text_1 = 'Text1';
$text_2 = 'Text2';
$text_3 = 'Text3';
$text_4 = 'Text4';
$get_language=$l2;

if($get_language==='is'){
   $text_5='Hreinsa'; 
   $text_6="";
   $text_7="Helgar með vali";
   $text_8="Timafjöldi í tímaskýrslu:";
} else{
   $text_5='Clean colours'; 
   $text_6="";
   $text_7="include weekend";
   $text_8="Enter hours for pay period:";
}
//echo 'Current lang='.$l2;
?>
<script type="text/javascript">
    /*
 * Content-Type:text/javascript
 *
 * A bridge between iPad and iPhone touch events and jquery draggable, 
 * sortable etc. mouse interactions.
 * @author Oleg Slobodskoi  
 * 
 * modified by John Hardy to use with any touch device
 * fixed breakage caused by jquery.ui so that mouseHandled internal flag is reset 
 * before each touchStart event
 * 
 */
(function( $ ) {

    $.support.touch = typeof Touch === 'object';

    if (!$.support.touch) {
        return;
    }

    var proto =  $.ui.mouse.prototype,
    _mouseInit = proto._mouseInit;

    $.extend( proto, {
        _mouseInit: function() {
            this.element
            .bind( "touchstart." + this.widgetName, $.proxy( this, "_touchStart" ) );
            _mouseInit.apply( this, arguments );
        },

        _touchStart: function( event ) {
            if ( event.originalEvent.targetTouches.length != 1 ) {
                return false;
            }

            this.element
            .bind( "touchmove." + this.widgetName, $.proxy( this, "_touchMove" ) )
            .bind( "touchend." + this.widgetName, $.proxy( this, "_touchEnd" ) );

            this._modifyEvent( event );

            $( document ).trigger($.Event("mouseup")); //reset mouseHandled flag in ui.mouse
            this._mouseDown( event );

            return false;           
        },

        _touchMove: function( event ) {
            this._modifyEvent( event );
            this._mouseMove( event );   
        },

        _touchEnd: function( event ) {
            this.element
            .unbind( "touchmove." + this.widgetName )
            .unbind( "touchend." + this.widgetName );
            this._mouseUp( event ); 
        },

        _modifyEvent: function( event ) {
            event.which = 1;
            var target = event.originalEvent.targetTouches[0];
            event.pageX = target.clientX;
            event.pageY = target.clientY;
        }

    });

})( jQuery );

    'use strict';

            jQuery(document).ready(function ($) {
                var
                    js = $,
                    status = 0,
                    language='<?=$get_language?>',
                    changeColorforRange = 0;
                
                js('input[name="daterange"]').daterangepicker({
                    locale: {
                        format: 'DD.MM.YYYY',
                        <?php if($get_language==='is'){?>
                            applyLabel: 'Vista',
                        <?php } else{?>
                            applyLabel: 'Apply',
                        <?php } ?>
                        
                    },
                    "showCustomRangeLabel": false,
                    "alwaysShowCalendars": true,
                    "cancelClass": "btn-default custom_cancel", 
                    //startDate: '03/05/2005', endDate: '03/07/2005'
                });
                //js('input[name="daterange"]').daterangepicker({ beforeShowDay: $.datepicker.noWeekends });
          

                js.fn.removeClassWild = function (mask) {
                    return this.removeClass(function (index, cls) {
                        var re = mask.replace(/\*/g, '\\S+');
                        return (cls.match(new RegExp('\\b' + re + '', 'g')) || []).join(' ');
                    });
                };

                
                //js('#dateinput').trigger('click').trigger('focusout');

                js('.report_item_count.report_item_count_bckgr_white_add_period').on('click', function () {
                    js('.report_item_count').removeClass('bordered');
                    js(this).addClass('bordered');
                    status = 1;
                    js('.daterangepicker td.active').removeClassWild("active-*");
                    js('.daterangepicker td.active').addClass('active-blue0');
                    js('.selected-color').html('<style>.daterangepicker td.active, .daterangepicker td.active:hover{background-color: #26c2f0!important;}</style>');
                    if(changeColorforRange == 1){
                        js('.range-color').find('style').remove();
                        js('.range-color').html('<style>.in-range{color:#fff!important;background-color:#26c2f0!important;}</style>');
                    }
                    
                });
                js('.report_item_count.report_item_count_bckgr_white').on('click', function () {
                        js('.report_item_count').removeClass('bordered');
                        js(this).addClass('bordered');
                        status = 2;
                        js('.daterangepicker td.active').removeClassWild("active-*");
                        js('.daterangepicker td.active').addClass('active-white0');
                        js('.selected-color').html('<style>.daterangepicker td.active, .daterangepicker td.active:hover{background-color: #transparent!important;}</style>');
                        if(changeColorforRange == 1){
                            js('.range-color').find('style').remove();
                            js('.range-color').html('<style>.in-range{color:#fff !important;background-color:#transparent!important;}</style>');
                        }
                });
                
               
                js('input[name="daterange"]').on('apply.daterangepicker', function (ev, picker) { 
                    var 
                        pay_period_input=js('#pay_period_custom_val'),
                        pay_period_input_val=pay_period_input.val();
                        
                    if (status == 0) {
                        alert('<?=JText::_('COM_SPEC_HOLIDAY_ALERT_SELECT_ACTION'); ?>');
                        return false;
                    }
                    if(status==2){
                        var res_conf = confirm("<?=JText::_('COM_SPEC_HOLIDAY_ALERT_DELETE_PERIOD_ASK'); ?>");
                        if(res_conf!=true){
                            return false;
                        }
                    }
                    var
                        start_date00 = picker.startDate.format('DD-MM-YYYY'),
                        end_date00 = picker.endDate.format('DD-MM-YYYY');

                    console.log('Set new status: ' + status);
                    //js('.daterangepicker').attr('style', 'display: block !important');
                    
                    if(status===1){      
                        addPeriodToScale(start_date00, end_date00, status);
                    } else if(status===2){
                        removePeriodInScale(start_date00, end_date00, status);
                    }
                    //parent.updateDates(start_date00, end_date00, status, pay_period_input_val);//call update function from current not iframe page
                    //js('#dateinput').trigger('click');//dont hide calendar
                    return false;
                });
                
                js(document).on('click','.active.end-date',function(){
                    var color = js('td.start-date').css('backgroundColor');
                    //js('.end-date').parents('tr').find('.in-range').attr('style', 'color:#fff;background-color:'+color); 
                    js('.range-color').html('<style>.in-range{color:#fff!important;background-color: '+color+'!important;}</style>');
                    changeColorforRange = 1;
                });
                
                function addPeriodToScale(start, end, action) {         
                    var 
                        year=js('.flex_table-one-item.one_header_item-usename').text(),
                        user_id=Number(js('.select_user_list').val());
                
                    year=Number(year);
                    //alert(user_id);
                    //return false;
                    js.ajax({
                        type: "POST",
                        url: '/index.php?option=com_spec_holiday&task=addPeriodToScale',
                        beforeSend: function(){
                            js('.transition-loader').visible();
                        },
                        data: ({
                            "year": year, 
                            "start": start,
                            "end": end,
                            "user_id": user_id,
                            "lang": '<?=$l2?>'
                        }),
                        dataType: "json",
                        async: true,
                        success: function(data){ 
                            console.log(data);
                
                            if(data.error){
                                alert(data.error);
                                js('.transition-loader').invisible();
                            } else{
                                // alert('load new html');
                                //js('.flex_table-tbody').remove();    
                                js('.flex_table-tbody').html(data.html);
                                js('.change_task_wrapper').hide();
                                
                                var positions_arr=prepareDatesCoordinates();
                                combimeSeparateDates(positions_arr);
                            }   
                        }
                    });
    
                }
                
                function removePeriodInScale(start, end, action) {
                    var 
                        year=js('.flex_table-one-item.one_header_item-usename').text(),
                        user_id=Number(js('.select_user_list').val());
                
                    year=Number(year);
                    //alert(user_id);
                    //return false;
                    js.ajax({
                        type: "POST",
                        url: '/index.php?option=com_spec_holiday&task=removePeriodInScale',
                        beforeSend: function(){
                            js('.transition-loader').visible();
                        },
                        data: ({
                            "year": year, 
                            "start": start,
                            "end": end,
                            "user_id": user_id,
                            "lang": '<?=$l2?>'
                        }),
                        dataType: "json",
                        async: true,
                        success: function(data){ 
                            console.log(data);
                
                            if(data.error){
                                alert(data.error);
                                js('.transition-loader').invisible();
                            } else{
                                // alert('load new html');
                                //js('.flex_table-tbody').remove();    
                                js('.flex_table-tbody').html(data.html);
                                js('.change_task_wrapper').hide();
                                
                                var positions_arr=prepareDatesCoordinates();
                                combimeSeparateDates(positions_arr);
                            }   
                        }
                    });
                }
                
                //js('#pay_period_custom_val').mask('00:00', {});
               /******************************************************************************************/
                
                
                
                
                
                //component.js
                var 
        
                    saved_group_filter=''; 
        
   // js.noConflict();
   
    js.fn.visible = function() {
        return this.css('visibility', 'visible');
    };

    js.fn.invisible = function() {
        return this.css('visibility', 'hidden');
    };
    
    js('.dep_wrapper').on('click', function(){
        //js('.change_departament').trigger('click');
    });
    
    js('.change_departament').on('click', function(){
       //alert('dd');
       
       js.ajax({
            type: "POST",
            url: '/index.php?option=com_spec_holiday&task=getLayoutGroupsConfirm',
            data: ({          
                "lang": '<?=$l2?>'
            }),
            dataType: "json",
            async: true,
            success: function(data){ 
                if(data.html!=''){
                    js('.change_task_wrapper .data_option_wrapper').html(data.html);
                    js('.change_task_wrapper').show();
                    //this0.addClass('input_with_group_select');
                }
                console.log(data); 
                    
                        
            }
        });
    });
    
    var selected_option=js('.change_task_wrapper .data_option_wrapper .one_option');
        
    selected_option.live('click', function(){ 
        var 
            this0=js(this),
            val0=this0.attr('data-option-value').split('-')
              
        ;
        if(this0.hasClass('selected_option_active')){
            this0.find('i').removeClass('fa-check-circle-o').addClass('fa-circle-thin');
            this0.removeClass('selected_option_active');
        } else{
            this0.find('i').removeClass('fa-circle-thin').addClass('fa-check-circle-o');
            this0.addClass('selected_option_active');
        }    
    });
    
    //filter dep
    js('.applyFilteringByDepartment').live('click', function(){
        //alert('apply');     
        var 
            selected_groups=js('.selected_option_active'),
            selected_groups_arr=new Array(),
            i=0
        ;
                
        //js('.change_task_wrapper').hide();
        js.each(selected_groups, function(ik, iv){
            selected_groups_arr[i]=js(iv).text();
            i++;
        });
                
        //alert(selected_groups_arr.length);
        if(selected_groups_arr.length>0){
            var 
                from=js('#from').val(),
                to=js('#to').val(),
                calendar_value=js(".loop_calendar_wrapper").val(),
                all_rows=js('.flex_table-one-item.one_row'),
                year=js('.js_year_event').text();
        
           
            reloadScale(year, selected_groups_arr);
            
        } else{
            alert('Select one Departament!');
        }
    });
    
    js('.js_add_period_to_scale').on('click', function(){
       js('.add_period_block').show();
       //.js('.daterangepicker').attr('style', 'display: block !important');
       
       
      
    });
    
    
    js('.year_changes').on('click', function(){
        console.log('change year'); 
      
        var    
            year=js('.flex_table-one-item.one_header_item-usename').text(),
            is_prev=js(this).hasClass('year-prev'),
            mode;
            
        if(is_prev===true){
            mode='prev';
        } else if(is_prev===false){
            mode='next';
        }
           
        loadYear(year, mode);
    });
    var positions_arr=prepareDatesCoordinates();
    combimeSeparateDates(positions_arr);
    

    js(window).on('resize', function(){
	js('.clearresize').detach();
	console.log("resize");
        
        var positions_arr=prepareDatesCoordinates();
        combimeSeparateDates(positions_arr);
    });

    
    /**functions**/
    function reloadScale(year, department_obj) {
        console.log('js fn reloadScale');
        
        year=Number(year);
        //alert(isObject(department_obj));
        //department_obj=String(department_obj);
        //department_obj='d';
        
        if(!isObject(department_obj)){
            if(department_obj.length>0) return false;
        } 
        
        js.ajax({
            type: "POST",
            url: '/index.php?option=com_spec_holiday&task=loadScaleAjax',
            beforeSend: function(){
                js('.transition-loader').visible();
            },
            data: ({
                "year": year, 
                "department_obj": department_obj  
            }),
            dataType: "json",
            async: true,
            success: function(data){ 
                console.log(data);
                
                if(data.error){
                    alert(data.error);
                } else{
                   // alert('load new html');
                    //js('.flex_table-tbody').remove();    
                    js('.flex_table-tbody').html(data.html);
                    js('.change_task_wrapper').hide();
                    
                    var positions_arr=prepareDatesCoordinates();
                    combimeSeparateDates(positions_arr);
                }
                
                        
            }
        });
    }
    
    function loadYear(year, mode) {
        console.log('js fn loadYear');
        
        year=Number(year);
       

        js.ajax({
            type: "POST",
            url: '/index.php?option=com_spec_holiday&task=loadYear',
            beforeSend: function(){
                js('.transition-loader').visible();
            },
            data: ({
                "year": year, 
                "mode": mode  
            }),
            dataType: "json",
            async: true,
            success: function(data){ 
               // console.log(data);
                
                if(data.error){
                    alert(data.error);
                } else{
                   // alert('load new html');
                    //js('.flex_table-tbody').remove();    
                    js('.flex_table-tbody').html(data.html);
                    js('.change_task_wrapper').hide();
                    js('.js_year_event').text(data.new_year);
                    
                    var positions_arr=prepareDatesCoordinates();
                    combimeSeparateDates(positions_arr);
                }
                
                        
            }
        });
    }
    
    function isAN(value) {
        if(value instanceof Number)
        value = value.valueOf();
  
        return  isFinite(value) && value === parseInt(value, 10);
    }

    //console.info(isAN(1));
    //console.info(isAN(new Number(1)));
    //console.info(isAN(null));
       
    function isObject(val) {
        //alert('fn');
        if (val === null) { return false;}
        return ( (typeof val === 'function') || (typeof val === 'object') );
    }

	function dateParse( date ){
		var parts = date.split('.');
		return new Date(parts[2], parts[1] - 1, parts[0]);
	}

    function combimeSeparateDates(dates_items) {
            var 
                i=0,
                periods=new Array();
        
            js.each(js('.flex_table-one-subitem.one_date[data-period_start]'), function(ik, iv){
                var 
                    this0=js(iv),
                    current_iteration_date=this0.attr('data-date'),
                    start=this0.attr('data-period_start'),
                    end=this0.attr('data-period_end');

		if(dateParse(current_iteration_date)>=dateParse(start) && dateParse(current_iteration_date)<=dateParse(end)){
                    this0.invisible();
                    periods[i]=new Object();
                    periods[i].start=start;
                    periods[i].end=end;
                    //periods[i].month=this0.parent().attr('data-month');
                    periods[i].user_id=this0.parent().attr('data-user-id');
                    periods[i].position_edited=this0.attr('data-edited');
                }
                i++;
            });
        
        var clean_periods_obj = remove_duplicates(periods);
        console.log(clean_periods_obj);
        
        
        js.each(clean_periods_obj, function(index, value){ 

		clean_periods_obj[index].month = clean_periods_obj[index].start.split('.')[1];
            //console.log('Index: ' + index + '; Value: ' + clean_periods_obj[index].month);
            
            if(clean_periods_obj[index].start.length>0){
               
               
                js.each(js('.flex_table-one-item.one_cell.one_item-month[data-month="'+clean_periods_obj[index].month+'"][data-user-id="'+clean_periods_obj[index].user_id+'"]'), function(index0, value0){
                    var 
                        this0=js('.flex_table-one-item.one_cell.one_item-month[data-month="'+clean_periods_obj[index].month+'"][data-user-id="'+clean_periods_obj[index].user_id+'"]'),
                        it_value=js(value0);

			var this1 = jQuery('.flex_table-one-subitem[data-date="'+clean_periods_obj[index].start+'"]');
			var this2 = jQuery('.flex_table-one-subitem[data-date="'+clean_periods_obj[index].end+'"]');
			var width = parseInt((this2.parent().position().left+this2.position().left - (this1.parent().position().left+this1.position().left)));
			var newleft = this1.position().left;
                      
                    if(this0.find('*[data-period_start="'+clean_periods_obj[index].start+'"]')){
                        var 
                            count_markered_items=this0.find('*[data-period_start="'+clean_periods_obj[index].start+'"]').length,
                            //total_width=getPeriodWidth(this0.find('.markered[data-period_start="'+clean_periods_obj[index].start+'"]')),
                            total_left=getPeriodLeft(this0.find('.markered[data-period_start="'+clean_periods_obj[index].start+'"]')),
                            left=0;

                        var 
                            true_width_arr=this0.find('.one_date').attr('style').split(';'),
                            true_width_subarr=true_width_arr[0].split(':'),
                            true_width=parseFloat(true_width_subarr[1].trim()),
                            count_dates_in_month=this0.find('.one_date').length,
                            
                            total_width=getPeriodWidth(clean_periods_obj[index].start, clean_periods_obj[index].end, true_width);
                        
                       // console.log('true width '+true_width);
                       // console.log('count_dates_in_month='+count_dates_in_month);
                       
                        left=getLeft(clean_periods_obj[index].start, clean_periods_obj[index].end, true_width, count_markered_items, count_dates_in_month);
                      
                        var 
                            modify_start=clean_periods_obj[index].start.split('.'),
                            modify_end=clean_periods_obj[index].end.split('.'),
                            position_edited=this0.find('*[data-period_start="'+clean_periods_obj[index].start+'"]').attr('data-edited'),
                            x_position=this0.find('*[data-period_start="'+clean_periods_obj[index].start+'"]').attr('data-x_position');
                            
                        modify_start=modify_start[0]+'.'+modify_start[1];
                        modify_end=modify_end[0]+'.'+modify_end[1];
                        //console.log('clean_periods_obj[index].start='+clean_periods_obj[index].start+' clean_periods_obj[index].end='+clean_periods_obj[index].end+' x_position='+x_position);
                        
                        if(typeof x_position !== typeof undefined && x_position !== false && position_edited=='1'){
                            left=x_position;

                            /*this0.append('<div data-period-edited="1" class="flex_table-one-subitem one_period ui-state-active" data-period_start0="'+clean_periods_obj[index].start+'" data-period_end="'+clean_periods_obj[index].end+'" style="width:'+total_width+'%;left:'+left+'px !important;"><div class="period_pointer pointer_period_start"><div class="pointer_date_start">'+modify_start+'</div></div><div class="period_pointer pointer_period_end"><div class="pointer_date_end">'+modify_end+'</div></div></div>');*/
                            this0.append('<div data-period-edited="1" class="clearresize flex_table-one-subitem one_period ui-state-active" data-period_start0="'+clean_periods_obj[index].start+'" data-period_end="'+clean_periods_obj[index].end+'" style="width:'+width+'px;left:'+newleft+'px !important;"><div class="period_pointer pointer_period_start"><div class="pointer_date_start">'+modify_start+'</div></div><div class="period_pointer pointer_period_end"><div class="pointer_date_end">'+modify_end+'</div></div></div>');         
                        } else{
                            /* this0.append('<div class="flex_table-one-subitem one_period ui-state-active" data-period_start0="'+clean_periods_obj[index].start+'" data-period_end="'+clean_periods_obj[index].end+'" style="width:'+total_width+'%;left:'+left+'% !important;"><div class="period_pointer pointer_period_start"><div class="pointer_date_start">'+modify_start+'</div></div><div class="period_pointer pointer_period_end"><div class="pointer_date_end">'+modify_end+'</div></div></div>');         */
                            this0.append('<div class="clearresize flex_table-one-subitem one_period ui-state-active" data-period_start0="'+clean_periods_obj[index].start+'" data-period_end="'+clean_periods_obj[index].end+'" style="width:'+width+'px;left:'+newleft+'px !important;"><div class="period_pointer pointer_period_start"><div class="pointer_date_start">'+modify_start+'</div></div><div class="period_pointer pointer_period_end"><div class="pointer_date_end">'+modify_end+'</div></div></div>');         
                        }
                    }   
                });
            }
            
        });
      
        let left_start, period_end_coordinates_x, left_stop=0, old_period_start, old_period_end;
        var diff0;
        
        js('.flex_table-one-subitem.one_period').draggable({axis:"x", containment: ".flex_table-one-item.one_row", 
            start: function(e, ui) {
                console.log('start drag');
                
                let 
                    this0=js(this),
                    count_day_in_period=old_period_end
                ;
                  
                   
                
                old_period_start=js(this).attr('data-period_start0');
                old_period_end=js(this).attr('data-period_end');
                
                diff0=diffDate(old_period_start, old_period_end);

                console.log('diff period'+diff0);
                
                left_start=this0[0].getBoundingClientRect().left;  
            },
            drag: function(e, ui) {
                let 
                    this0=js(this),
                    position_in_current_moment=this0[0].getBoundingClientRect().left,
                    iterator3=0;
                    
              
                //console.log('position_in_current_moment '+position_in_current_moment);
                
                let  
                    dates_items_length=dates_items.length;
                
                setTimeout(function(){
                    js.each(dates_items, function(i, e){
                   // console.log('dd'+e.x, left_stop);
                   
                   // let isLastElement0;
                    //isLastElement0=typeof dates_items[iterator3+1].x;
                  //  if(typeof isLastElement0)
                    //console.log('isLastElement='+typeof isLastElement0);
                    
                    try {
                        /*if(isLastElement0==false){
                            //if left stop x < next iteration one date coordinate and left stop x >=current iteration one date coordinates
                            if(position_in_current_moment<dates_items[iterator3].x && position_in_current_moment>=e.x){
                                console.log('last');
                           
                                //new period start
                                let 
                                    new_period_start=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date'),
                                    new_period_start_raw=new_period_start.split('.'),
                                    popup_new_start=new_period_start_raw[0]+'.'+new_period_start_raw[1];
                        
                            
                                //alert('new period start='+new_period_start);
                                this0.find('.pointer_date_start').text(popup_new_start);
                                return false;
                            }
                         } else{*/
                             //if left stop x < next iteration one date coordinate and left stop x >=current iteration one date coordinates
                            if(position_in_current_moment<dates_items[iterator3+1].x && position_in_current_moment>=e.x){
                               // console.log('not last');
                                console.log('diff2 period'+diff0);
                                //new period start
                               let 
                                    new_period_start=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date'),
                                    new_period_start_raw=new_period_start.split('.'),
                                    popup_new_start=new_period_start_raw[0]+'.'+new_period_start_raw[1],
                                    
                                    //here
                                    popup_end=getDraggablePeriodStop(diff0, new_period_start)
                                    ;
                        
                            
                                //alert('new period start='+new_period_start);
                                this0.find('.pointer_date_start').text(popup_new_start);
                                this0.find('.pointer_date_end').text(popup_end);
                                return false;
                            }
                        // }
                    } catch(e) {
                       // alert('Error ' + e.name + ":" + e.message + "\n" + e.stack);
                    }
                    
                    iterator3++;
                    
                });
                },1)
            },
            stop: function(e, ui) {
                let 
                    this0=js(this),                    
                    dragposition = ui.position,
                    //el = allElementsFromPoint(event.clientX, event.clientY),
                    //stop_el = $(el).filter('.one_item-month').not($(this)),
                    true_width_arr=this0.attr('style').split(';'),
                    true_width_subarr=true_width_arr[0].split(':'),
                    period_width=parseFloat(true_width_subarr[1].trim())
                ;
                
                //period left stop position
                left_stop=this0[0].getBoundingClientRect().left;
                period_end_coordinates_x=left_stop+period_width;
                
                let 
                    iterator=0,
                    dates_items_length=dates_items.length;
                
                //alert(dates_items_length);
                js.each(dates_items, function(i, e){
                    //console.log('dd'+e.x, left_stop);
                    let isLastElement = i == dates_items.length -1;
                    
                    try {
                        if(isLastElement){
                            //if left stop x < next iteration one date coordinate and left stop x >=current iteration one date coordinates
                            if(left_stop<dates_items[iterator].x && left_stop>=e.x){
                                //alert('done');
                           
                                //new period start
                                let new_period_start=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date');
                        
                                //js('.js_p_event-0').remove();
                                js('.table_user_wrapper').prepend(' <p class="js_p_event-0">Set new period start: '+new_period_start+'</p>');
                                this0.attr('data-period_start0', new_period_start);
                                return false;
                            }
                         } else{
                             //if left stop x < next iteration one date coordinate and left stop x >=current iteration one date coordinates
                            if(left_stop<dates_items[iterator+1].x && left_stop>=e.x){
                                //alert('done');
                           
                                //new period start
                                let new_period_start=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date');
                        
                                //js('.js_p_event-0').remove();
                                js('.table_user_wrapper').prepend(' <p class="js_p_event-0">Set new period start: '+new_period_start+'</p>');
                                this0.attr('data-period_start0', new_period_start);
                                return false;
                            }
                         }
                    } catch(e) {
                        alert('Error ' + e.name + ":" + e.message + "\n" + e.stack);
                    }
                    
                    iterator++;
                    
                });
                
                //alert('start search new stop');
                let 
                    iterator2=0;
                    
                js.each(dates_items, function(i, e){
                   // console.log('dd'+e.x, left_stop);
                    let isLastElement = i == dates_items.length -1;
                    
                    try {
                        if(isLastElement){
                            
                        
                            //if left stop x < next iteration one date coordinate and left stop x >=current iteration one date coordinates
                            if(period_end_coordinates_x<dates_items[iterator2].x && period_end_coordinates_x>=e.x){
                                //alert('done');
                           
                                //new period start
                                let new_period_end=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date');
                        
                                //js('.js_p_event-0').remove();
                                js('.table_user_wrapper').prepend(' <p class="js_p_event-0">Set new period end: '+new_period_end+'</p>');
                                this0.attr('data-period_end', new_period_end);
                                return false;
                            }
                        } else{
                            if(period_end_coordinates_x<dates_items[iterator2+1].x && period_end_coordinates_x>=e.x){
                                //alert('done');
                           
                                //new period start
                                let new_period_end=js('.flex_table-one-subitem.one_date[data-key="'+e.key+'"]').attr('data-date');
                        
                                //js('.js_p_event-0').remove();
                                js('.table_user_wrapper').prepend(' <p class="js_p_event-0">Set new period end: '+new_period_end+'</p>');
                                this0.attr('data-period_end', new_period_end);
                                return false;
                            }
                        }
                    } catch(e) {
                        alert('Error ' + e.name + ":" + e.message + "\n" + e.stack);
                    }
                    
                    iterator2++;
                    
                });
                
                let 
                    period_start=js(this).attr('data-period_start0'),
                    period_end=js(this).attr('data-period_end'),
                    user_id=js(this).parent().attr('data-user-id');
                
                //savePosition(dragposition, period_start, period_end, user_id);
                savePeriod(old_period_start, old_period_end, period_start, period_end, user_id);
            }
        }).resizable({
            handles: 'e, w',
            
        });
        
        js('.transition-loader').invisible();
    }
    
  
    
    function allElementsFromPoint(x, y) {
       var element, elements = [];
        var old_visibility = [];
        while (true) {
            element = document.elementFromPoint(x, y);
            if (!element || element === document.documentElement) {
                break;
            }
            elements.push(element);
            old_visibility.push(element.style.visibility);
            element.style.visibility = 'hidden'; // Temporarily hide the element (without changing the layout)
        }
        for (var k = 0; k < elements.length; k++) {
            elements[k].style.visibility = old_visibility[k];
        }
        elements.reverse();
        return elements;
    }
    
    function prepareDatesCoordinates() {
        console.log('js fn prepareDatesCoordinates');
        
        let 
            arr=new Array(),
            i0=0;
        
        js.each(js('.flex_table-one-subitem.one_date'), function(i, e){
           let this0=js(e),
           date_position=this0[0].getBoundingClientRect(),
           date_unical_key=this0.attr('data-key');
            
           arr[i0]=new Object();
           arr[i0].key=date_unical_key;
           arr[i0].x=date_position.left;
           
           this0.attr('data-js-position', date_position.left);
           
           i0++;
        });
        console.log(arr);
        
        return arr;
    }
    
    function getNewDates(user_id, dragposition) {
        
    }
    
    function diffDate(start, end) {
        let start_arr=start.split('.');
        let start_normal=start_arr[1]+'-'+start_arr[0]+'-'+start_arr[2];
        
        let end_arr=end.split('.');
        let end_normal=end_arr[1]+'-'+end_arr[0]+'-'+end_arr[2];
        
        var date1 = new Date(start_normal);
        var date2 = new Date(end_normal);
        var daysLag = Math.ceil(Math.abs(date2.getTime() - date1.getTime()) / (1000 * 3600 * 24));
        
        return daysLag;
    }
    
    function getDraggablePeriodStop(different, popup_new_start) {
        console.log('js fn getDraggablePeriodStop');
        
       /* let start_arr=popup_new_start.split('.');
        console.log(start_arr);
        let start_normal=start_arr[1]+'-'+start_arr[0]+'-'+start_arr[2];*/
        
     
        
        return addDays(popup_new_start, different);
    }
    
    function addDays(date, days) {
        console.log('js fn addDays, date='+date+' days='+days);
        /*var result = new Date(date);
        result.setDate(result.getDate() + days);
        let final=result.toLocaleDateString('uk-UA').split('.');*/
        
        let 
            m = moment(date, 'DD.MM.YYYY');
        //console.log('m='+m);    
        let
            final=m.add(days, 'day').format('DD.MM');
        
        //return final[0]+'.'+final[1];
        return final;
    }

    function savePosition(position, period_start, period_end, user_id) {
           /* var pixels = position.left;
            var screenWidth = window.screen.width;
            var percent = (( screenWidth - pixels ) / screenWidth ); 
            alert(percent);*/
               
            js.ajax({
                type: "POST",
                url: '/index.php?option=com_spec_holiday&task=savePosition',
                beforeSend: function(){
                    js('.transition-loader').visible();
                },
                data: ({
                    'lang': '<?=$l2?>',
                    // 'position': {'left': percent, 'top': 0},
                    'position': position,
                    'period_start': period_start,
                    'period_end': period_end,
                    'user_id': user_id,
                    'year': js('.flex_table-one-item.one_header_item-usename').text(),
                }),
                dataType: "json",
                async: true,
                success: function(data){ 
                    console.log(data);
                    
                    if(data.error){
                        alert(data.error);
                        js('.transition-loader').invisible();
                    } else{
                        // alert('load new html');
                        //js('.flex_table-tbody').remove();    
                        js('.flex_table-tbody').html(data.html);
                        js('.change_task_wrapper').hide();
                        
                        var positions_arr=prepareDatesCoordinates();
                        combimeSeparateDates(positions_arr);
                    }   
                }
            });
       // }
        
    }
    
    function savePeriod(old_period_start, old_period_end, period_start, period_end, user_id) {
            js.ajax({
                type: "POST",
                url: '/index.php?option=com_spec_holiday&task=savePeriod',
                beforeSend: function(){
                    js('.transition-loader').visible();
                },
                data: ({
                    'lang': '<?=$l2?>',
                    'old_period_start': old_period_start,
                    'old_period_end': old_period_end,
                    'period_start': period_start,
                    'period_end': period_end,
                    'user_id': user_id,
                    'year': js('.flex_table-one-item.one_header_item-usename').text(),
                }),
                dataType: "json",
                async: true,
                success: function(data){ 
                    console.log(data);
                    
                    if(data.error){
                        alert(data.error);
                        js('.transition-loader').invisible();
                    } else{
                        // alert('load new html');
                        //js('.flex_table-tbody').remove();    
                        js('.flex_table-tbody').html(data.html);
                        js('.change_task_wrapper').hide();
                        
                        var positions_arr=prepareDatesCoordinates();
                        combimeSeparateDates(positions_arr);
                    }   
                }
            });
       // }
        
    }

    function findSize(el, size) {
        /* size must be 'width' or ' height' */
        return window.getComputedStyle
            ? getComputedStyle(el,null).getPropertyValue(size)
            : el['client'+size.substr(0,1).toUpperCase() + size.substr(1)] + 'px';
    }
    

    function getLeft(date_start, date_end, one_month_date_width, count_markered_items0, count_dates_in_month) {
       // console.log('js fn getLeft. date='+date_start, date_end, one_month_date_width, count_dates_in_month);
        
        var 
            date_start_arr=date_start.split('.'),
            day_start=date_start_arr[0],
            
            date_end_arr=date_end.split('.'),
            day_end=date_end_arr[0],
            month_end=date_end_arr[1],
            year_end=date_end_arr[2],
            
            left=0;
           
        //console.log('day_start'+day_start);
       
        left=(day_start-1)*one_month_date_width;
        
        //console.log(left);
        //console.log(one_month_date_width);
        
        var lastday = function(y,m){
            return  new Date(y, m, 0).getDate();
        };

        switch(day_start){
            case '01':
                left=0;
            break;     
        }
     
        //console.log(day_start, day_end);

        return left;
    }


    /*function getPeriodWidth(this_obj) {
        var total_width=0;
                       
        js.each(this_obj, function(i0, v0){
       
            total_width+=js(v0)[0].getBoundingClientRect().width;
                           
            //total_width += js(v0).width() / js(v0).parent().width() * 100;
        });
        if(total_width>=100){
            return 100;
        }
        return total_width;
    }*/

    function getPeriodWidth(date_start, date_end, one_date_width) {
         var 
            date_start_arr=date_start.split('.'),
            day_start=date_start_arr[0],
            
            date_end_arr=date_end.split('.'),
            day_end=date_end_arr[0],
            month_end=date_end_arr[1],
            year_end=date_end_arr[2],
            total_width;
         
        total_width=(day_end-day_start+1)*one_date_width;
        return total_width;
    }
    
    function getPeriodLeft(this_obj) {
        var total_left=0;
                       
        js.each(this_obj, function(i0, v0){  
            total_left+=js(v0)[0].getBoundingClientRect().left;   
            //console.log(total_left.left);
            //total_left=js(v0).css('left');
        });
        
        return total_left;
    }
    
    function remove_duplicates(objectsArray) {
        var usedObjects = {};

        for (var i=objectsArray.length - 1;i>=0;i--) {
            var so = JSON.stringify(objectsArray[i]);

            if (usedObjects[so]) {
                objectsArray.splice(i, 1);

            } else {
                usedObjects[so] = true;          
            }
        }

        return objectsArray;
    }
    
    js(document).mouseup(function (e) {
        //console.log(e.target);
        var container = js(".change_task_wrapper");
        //var e1=js(e);
        
        if (container.has(e.target).length === 0 && js(e.target).hasClass('selected_option_active')==false){
            //console.log('trigger0'+saved_group_filter);
            if(saved_group_filter!=='1'){
                container.hide();
                //js('#input_pay_period_search').removeClass('input_with_group_select');
            } else{
                //container.show();
            }
        } else{
           //container.show();
        }
    });
            });
        </script>

<div class="transition-loader">
    <div class="transition-loader-inner">
        <label></label>
        <label></label>
        <label></label>
        <label></label>
        <label></label>
        <label></label>
    </div>
</div>
<section class="com_holidays_new_wrapper">
    <div class="container-fluid">
        <div class="row-fluid">
            <div class="com_holidays_new-content">
                <h2 class="h2"><?=JText::_('COM_SPEC_HOLIDAY_NEW_H2'); ?></h2>
                
                <?php if (!in_array(2, $u->groups)) {?>
                    <aside class="dep_filter">
                        <div class="dep_wrapper">
                            <div class="change_departament"><?=JText::_('COM_SPEC_HOLIDAY_NEW_CHANGE_DEP')?></div>
                            <div class="change_task_wrapper">
                                <div class="data_option_wrapper"></div>
                            </div>
                        </div>
                        <div class="add_period_to_scale js_add_period_to_scale">
                            <?=JText::_('COM_SPEC_HOLIDAY_NEW_PERIOD')?>
                        </div>  
                    </aside>
                    <aside class="add_period_block">
                        <h2><?=JText::_('COM_SPEC_HOLIDAY_ADD_PERIOD_BLOCK_HEADER')?></h2>
                        
                        <div class="report_popup_count_row">
                            <div class="report_count_item">
                                <div class="report_item_count report_item_count_bckgr_white_add_period"></div>
                                <div class="report_item_text"><?=JText::_('COM_SPEC_HOLIDAY_ADD_PERIOD')?></div>
                            </div>
                            <div class="report_count_item">
                                <div class="report_item_count report_item_count_bckgr_white"></div>
                                <div class="report_item_text"><?=JText::_('COM_SPEC_HOLIDAY_REMOVE_PERIOD')?></div>
                            </div>
                        </div>
                        <div class="select_block_wrapper">
                         <?php
                               /* echo '<pre>';
                                print_r($this->user_list);
                                echo '</pre>';*/
                            ?>
                            <select class="select_user_list">
                                <?php
                                    foreach($this->user_list as $one_user_select){?>
                                        <option value="<?=$one_user_select->id?>"><?php
                                            if(!empty($one_user_select->username0)){ echo $one_user_select->username0; } 
                                            elseif(!empty($one_user_select->username)){ echo $one_user_select->username; }
                                            elseif(!empty($one_user_select->name)){ echo $one_user_select->name; }
                                        ?></option>
                                    <?php }
                                ?>
                                
                            </select>
                        
                        <input type="text" name="daterange" value="<?=date('d.m.Y', strtotime('now'))?> - <?=date('d.m.Y', strtotime('+2 days'))?>" id="dateinput"/>
                                
                            
                    <div class="selected-color">
        
                    </div>
                    <div class="range-color">
        
                    </div>
                    </div>
                </aside>
                <?php } ?>
                <div class="table_user_wrapper">
                    <!--<div class="test_resize ui-widget-content">resize test</div>-->
                    <div class="flex_table">
                        <div class="flex_table-header">
                            <div class="flex_table-one-item one_header_item one_header_item-user_img"></div>
                            <div class="flex_table-one-item one_header_item one_header_item-usename"><span class="js_year_event"><?=date('Y')?></span><div class="year_changes year-prev"><i class="fa fa-caret-left" aria-hidden="true"></i></div></div>
                            
                            <?php
                                /*echo '<pre>';
                                print_r($this->holidays_scale);
                                echo '</pre>';*/
                            
                                $total = count($this->month_list);
                                $counter = 0;
                                
                                foreach($this->month_list as $one_month)
                                {
                                    $counter++;
                                    if($counter == $total){?>
                                        <div class="flex_table-one-item one_header_item item_has_caret"><?=$one_month?><div class="year_changes year-next"><i class="fa fa-caret-right" aria-hidden="true"></i></div></div>
                                    <?php } else{
                                    ?>
                                        <div class="flex_table-one-item one_header_item"><?=$one_month?></div>
                                    <?php }   
                                }
                            ?>
                        </div>
                        <div class="flex_table-tbody">
                            <?php
                                foreach($this->user_list as $one_user)
                                {?>
                                    <div class="flex_table-one-item one_row" data-filter="<?=$one_user->group_user?>">
                                        <div class="flex_table-one-item one_cell one_item-user_img">
                                            <?=$model->getUserImg($one_user->id);?>
                                           
                                        </div>
                                        <div class="flex_table-one-item one_cell one_item-usename"><?=$one_user->username0?></div>
                                        
                                        <?php foreach($this->holidays_scale[$one_user->id] as $one_scale_month)
                                            {?>
                                            <div class="flex_table-one-item one_cell one_item-month" data-user-id="<?=$one_user->id?>" data-month="<?=$one_scale_month['month_number']?>">
                                                <?php
                                                    foreach($one_scale_month['dates']['all_dates'] as $one_date)
                                                    {
                                                        $unical_string=$model->generateRandomString(5);
                                                ?>
                                                    <?php if($one_date['position_edited']=='1'){?>
                                                         <div data-key="<?=$unical_string?>" data-x_position="<?=$one_date['x_position']?>" data-edited="<?=$one_date['position_edited']?>" data-date="<?=$one_date['date']?>" <?php if(!empty($one_date['period_start'])){?>data-period_start="<?=$one_date['period_start']?>"<?php } ?> <?php if(!empty($one_date['period_end'])){?>data-period_end="<?=$one_date['period_end']?>"<?php } ?> class="flex_table-one-subitem one_date<?php if($one_date['is_marked']=='true'){?> markered<?php } ?>" style="width:<?=$model->getDateCssWidth($one_scale_month['dates']['all_dates'])?>"></div>
                                                    <?php } else{?>
                                                         <div data-key="<?=$unical_string?>" data-edited="<?=$one_date['position_edited']?>" data-date="<?=$one_date['date']?>" <?php if(!empty($one_date['period_start'])){?>data-period_start="<?=$one_date['period_start']?>"<?php } ?> <?php if(!empty($one_date['period_end'])){?>data-period_end="<?=$one_date['period_end']?>"<?php } ?> class="flex_table-one-subitem one_date<?php if($one_date['is_marked']=='true'){?> markered<?php } ?>" style="width:<?=$model->getDateCssWidth($one_scale_month['dates']['all_dates'])?>"></div>
                                                    <?php }?>
                                                   
                                                <?php }    
                                                ?>
                                            </div>
                                        <?php
                                        }?>
                                    </div>
                            <?php }
                            ?>
                            
                        </div>
                    </div>
                    
                </div>
            </div>
        </div>
    </div>
</section>
