<?php
/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */

/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

class Spec_holidayController extends JControllerLegacy
{
      public function __construct($config = array()) {
       
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];

        parent::__construct($config);
    }
    /**
     * Method to display a view
     *
     * @param   bool  $cachable   If true, the view output will be cached
     * @param   bool  $urlparams  An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}
     *
     * @return  JControllerLegacy This object to support chaining
     *
     * @since   1.5
     */
    public function display($cachable = false, $urlparams = false)
    {
        return parent::display($cachable, $urlparams);
    }
    
    private function filter_input_fix ($type, $variable_name, $filter = FILTER_DEFAULT, $options = NULL )
    {
        $checkTypes =[
            INPUT_GET,
            INPUT_POST,
            INPUT_COOKIE
        ];

        if ($options === NULL) {
            // No idea if this should be here or not
            // Maybe someone could let me know if this should be removed?
            $options = FILTER_NULL_ON_FAILURE;
        }

        if (in_array($type, $checkTypes) || filter_has_var($type, $variable_name)) {
            return filter_input($type, $variable_name, $filter, $options);
        } else if ($type == INPUT_SERVER && isset($_SERVER[$variable_name])) {
            return filter_var($_SERVER[$variable_name], $filter, $options);
        } else if ($type == INPUT_ENV && isset($_ENV[$variable_name])) {
            return filter_var($_ENV[$variable_name], $filter, $options);
        } else {
            return NULL;
        }
    }
    
    /**
	* Proxy for getModel.
	* @since	1.6
    */
    public function &getModel($name = 'views', $prefix = 'Spec_holidayModel')
    {
	$model = parent::getModel($name, $prefix, array('ignore_request' => true));
	return $model;             
    }
                
    public function loadScaleAjax()
    { 
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $department_obj=$jinput->get('department_obj', '', 'ARRAY');
        //$_REQUEST['department_obj'];
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($department_obj, true), FILE_APPEND | LOCK_EX);
        
        $errors='';
        if(!empty($year)){
           $model=$this->getModel();
           $html=$model->loadScale($year, $department_obj);
        } else{
            $errors='Incorrect data format!';
        }
        
        print_r(json_encode([
            'year'=>$year,
            'department_obj'=>$department_obj,
            'error'=>$errors,
            'html'=>$html
        ]));
        JFactory::getApplication()->close();
    }
    
    public function addPeriodToScale()
    {
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $start=$jinput->get('start', '', 'STRING');
        $end=$jinput->get('end', '', 'STRING');
        $user_id=$jinput->get('user_id', '', 'INT');
        $lang=$jinput->get('lang', '', 'STRING');
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        if($lang=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $errors='';
        if(!empty($year) && !empty($start) && !empty($end) && !empty($user_id)){
           $model=$this->getModel();
           $check=$model->checkPeriod($start, $user_id);
           
              
           if($check==='period_not_exist'){
               $res=$model->addPeriodToScale($year, $start, $end, $user_id);
           } elseif($check==='period_already_exist'){
               $errors=JText::_('COM_SPEC_HOLIDAY_ALERT_DIAPASON_ALREADY_EXIST');
           }
           
           $html=$model->loadScale($year, '');
        } else{
            $errors.='Incorrect data format!';
        }
        
        print_r(json_encode([
            'year'=>$year,
            'res'=>$res,
            'error'=>$errors,
            'html'=>$html,
            'start'=>$start,
            'end'=>$end,
            'user_id'=>$user_id,
            'check_res'=>$check
        ]));
        JFactory::getApplication()->close();
    }
    
    private function normaliseYear($old_year, $mode)
    {
        if($mode=='prev'){
            $new_year=$old_year-1;
        } elseif($mode=='next'){
            $new_year=$old_year+1;
        }
        
        return (int)$new_year;
    }
    
    public function loadYear()
    { 
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $mode=$jinput->get('mode', '', 'STRING');
        
        $errors='';
        if(!empty($year)){
           $model=$this->getModel();
           $new_year=$this->normaliseYear($year, $mode);
           $html=$model->loadYear($new_year, $mode);
        } else{
            $errors='Incorrect data format!';
        }
        
        print_r(json_encode([
            'year'=>$year,
            'error'=>$errors,
            'html'=>$html,
            'new_year'=>$new_year,
            'mode'=>$mode
        ]));
        JFactory::getApplication()->close();
    }
    
    public function getLayoutGroupsConfirm()
    {
        $jinput = JFactory::getApplication()->input;
        $model=$this->getModel();
        $lang=$jinput->get('lang', '', 'STRING');
        $html=$model->getLayoutGroups($lang);
       
        print_r(json_encode([
            'html'=>$html
        ]));
        JFactory::getApplication()->close();
    }
    
    public function removePeriodInScale()
    {
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $start=$jinput->get('start', '', 'STRING');
        $end=$jinput->get('end', '', 'STRING');
        $user_id=$jinput->get('user_id', '', 'INT');
        $lang=$jinput->get('lang', '', 'STRING');
        
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        if($lang=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $errors='';
        if(!empty($year) && !empty($start) && !empty($end) && !empty($user_id)){
           $model=$this->getModel();
           //$check=$model->checkPeriod($start, $user_id);
           
              
           //if($check==='period_not_exist'){
               $res=$model->removePeriodInScale($start, $end, $user_id, 'external');
           /*} elseif($check==='period_already_exist'){
               $errors=JText::_('COM_SPEC_HOLIDAY_ALERT_DIAPASON_ALREADY_EXIST');
           }*/
           
           $html=$model->loadScale($year, '');
        } else{
            $errors.='Incorrect data format!';
        }
        
        print_r(json_encode([
            'year'=>$year,
            'res'=>$res,
            'error'=>$errors,
            'html'=>$html,
            'start'=>$start,
            'end'=>$end,
            'user_id'=>$user_id,
            'check_res'=>$check
        ]));
        JFactory::getApplication()->close();
    }
    
    public function savePosition()
    {
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $start=$jinput->get('period_start', '', 'STRING');
        $end=$jinput->get('period_end', '', 'STRING');
        $user_id=$jinput->get('user_id', '', 'INT');
        $lang=$jinput->get('lang', '', 'STRING');
        $position=$jinput->get('position', '', 'ARRAY');
        $position_left=$position['left'];
        //die('ddd');
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        if($lang=='is'){
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $errors='';
        if(!empty($year) && !empty($start) && !empty($end) && !empty($user_id)){
           $model=$this->getModel();
           //$check=$model->checkPeriod($start, $user_id);
           //echo $check;
           $res=$model->savePosition($start, $end, $user_id, $position_left); 
           
           if($check==='period_not_exist'){
               //$res=$model->addPeriodToScale($year, $start, $end, $user_id);
               $res='';
           } elseif($check==='period_already_exist'){
               $errors=JText::_('COM_SPEC_HOLIDAY_ALERT_DIAPASON_ALREADY_EXIST');
           }
           
           $html=$model->loadScale($year, '');
        } else{
            $errors.='Incorrect data format!';
        }
        
        print_r(json_encode([
            'res'=>$res,
            'error'=>$errors,
            'html'=>$html,
            'position'=>$position_left,
            'user_id'=>$user_id,
            'check_res'=>$check
        ]));
        JFactory::getApplication()->close();
    }
    
    public function savePeriod()
    {
        $jinput = JFactory::getApplication()->input;
        $year=$jinput->get('year', '', 'INT');
        $old_period_start=$jinput->get('old_period_start', '', 'STRING');
        $old_period_end=$jinput->get('old_period_end', '', 'STRING');
        
        $start=$jinput->get('period_start', '', 'STRING');
        $end=$jinput->get('period_end', '', 'STRING');
        $user_id=$jinput->get('user_id', '', 'INT');
        $lang=$jinput->get('lang', '', 'STRING');
       
        
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($_REQUEST, true), FILE_APPEND | LOCK_EX);
        if($lang=='is'){
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $errors='';
        if(!empty($year) && !empty($start) && !empty($end) && !empty($user_id)){
           $model=$this->getModel();
           //$check=$model->checkPeriod($start, $user_id);
           //echo $check;
           $res=$model->savePeriod($old_period_start, $old_period_end, $start, $end, $user_id, $year); 
           
           if($check==='period_not_exist'){
               //$res=$model->addPeriodToScale($year, $start, $end, $user_id);
               $res='';
           } elseif($check==='period_already_exist'){
               $errors=JText::_('COM_SPEC_HOLIDAY_ALERT_DIAPASON_ALREADY_EXIST');
           }
           
           $html=$model->loadScale($year, '');
        } else{
            $errors.='Incorrect data format!';
        }
        
        print_r(json_encode([
            'res'=>$res,
            'error'=>$errors,
            'html'=>$html,
          
            'user_id'=>$user_id,
            'check_res'=>$check
        ]));
        JFactory::getApplication()->close();
    }
}
