<?php
const _JEXEC = 1;

// Load system defines
if (file_exists(dirname(__DIR__) . '/defines.php')) {
    require_once dirname(__DIR__) . '/defines.php';
}

if (!defined('_JDEFINES')) {
    define('JPATH_BASE', $_SERVER['DOCUMENT_ROOT']);
    require_once JPATH_BASE . '/includes/defines.php';
}

// Get the framework.
require_once JPATH_LIBRARIES . '/import.legacy.php';

// Bootstrap the CMS libraries.
require_once JPATH_LIBRARIES . '/cms.php';

// Load the configuration
require_once JPATH_CONFIGURATION . '/configuration.php';

require_once JPATH_BASE . '/includes/framework.php';

//jimport('joomla.application.component.controller');
$mainframe = & JFactory::getApplication('site');

$db = & JFactory::getDBO();
$user = & JFactory::getUser();
$app = JFactory::getApplication();
$doc = JFactory::getDocument();

$l2 = $app->input->getString('lang');

$lang = JFactory::getLanguage();
$from_top_panel = $app->input->getInt('from_top_panel');
$selected_shift = $app->input->getString('selected_shift');
//echo '$selected_shift'.$selected_shift;
//echo '$from_top_panel:'.$from_top_panel;

if ($l2 == 'is') {
    $extension = 'com_shifts';
    $base_dir = JPATH_SITE;
    $language_tag = 'is-IS';
    $reload = true;
    $lang->load($extension, $base_dir, $language_tag, $reload);
} else {
    $extension = 'com_shifts';
    $base_dir = JPATH_SITE;
    $language_tag = 'en-GB';
    $reload = true;
    $lang->load($extension, $base_dir, $language_tag, $reload);
}

JLoader::register('Spec_holiday2ModelTthtml5', JPATH_ROOT . '/components/com_shifts/models/tthtml5.php');
$model_tthtml5 = JModelLegacy::getInstance('Tthtml5', 'Spec_holiday2Model');
$config = &JFactory::getConfig();
$enable_remove_shifts_by_color = $config->get('enable_remove_shifts_by_color');
//echo '$enable_remove_shifts_by_color:' . $enable_remove_shifts_by_color;
?>
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
        <title><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_EDIT_PERIOD') ?></title>
    	<link type="text/css" rel="stylesheet" href="media/layout.css" />
        <link href="//fonts.googleapis.com/css?family=Open+Sans" rel="stylesheet" type="text/css">
        <link href="/components/com_audit/assets/incl/font-awesome-4.7.0/css/font-awesome.min.css" rel="stylesheet" type="text/css" />
        <link type="text/css" rel="stylesheet" href="media/layout_iframe_edit.css?time=<?= time() ?>" />
        <!--<script type="text/javascript" src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.4/jquery.min.js"></script>-->
        
        <script src="js/jquery/jquery-1.9.1.min.js" type="text/javascript"></script>
      
        <script type="text/javascript" src="/components/com_audit/assets/incl/popup_calendar/moment.min.js"></script>
        
        <?php if($l2 == 'is'){?>
            <!--<script type="text/javascript" src="/components/com_audit/assets/incl/datepicker_iframe/is.js"></script>-->
            <script type="text/javascript" src="/components/com_audit/assets/incl/popup_calendar/moment_is.min.js?time=<?=time()?>"></script>
        <?php } else{?>
             <script type="text/javascript" src="/components/com_audit/assets/incl/popup_calendar/moment.min.js?time=<?=time()?>"></script>
        <?php } ?>
        <link rel="stylesheet" type="text/css" href="//cdn.jsdelivr.net/bootstrap/3/css/bootstrap.css" />

        <!-- Include Date Range Picker -->
         <!--<script type="text/javascript" src="/components/com_audit/assets/incl/popup_calendar/daterangepicker.js?time=<?=time()?>"></script>
        <link rel="stylesheet" type="text/css" href="/components/com_audit/assets/incl/popup_calendar/daterangepicker.css" />-->
        <script src="/components/com_audit/assets/incl/jQuery-Mask-Plugin/dist/jquery.mask.min.js" type="text/javascript"></script>
        <script src="/templates/curiotime/js/jquery.jeditable.back.js" type="text/javascript"></script>
        <script src="/components/com_audit/assets/scripts/jquery.cookie.js" type="text/javascript"></script>
        
        <!--calentim:-->
        <link href="https://fonts.googleapis.com/css?family=Roboto:300,400,400i,500,700" rel="stylesheet"/>
        <!--<link href="http://maxcdn.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css" rel="stylesheet"/>-->
      
        <script>window.jQuery || document.write('<script src="js/jquery/jquery-1.9.1.min.js" type="text/javascript"><\/script>');</script>
        <!-- .calentim includes -->
        <link href="/components/com_shifts/assets/incl/calentim/build/css/calentim.min.css?time=<?=time()?>" rel="stylesheet"/>
        <script src="/components/com_shifts/assets/incl/modile-detect/mobile-detect.js"></script>
        <script src="/components/com_shifts/assets/incl/calentim/build/js/calentim.min.js?time=<?=time()?>"></script>
        <!-- .end calentim includes -->
    </head>
    <body class="com_shifts_popup <?='body_lang-'.$l2?>"  style="min-width: 530px; max-width: 530px !important; overflow: visible">
        <div class="com_shifts_popup_content" style="overflow: visible" >
        <?php
            $owner_id = $user->owner_id;
        
            if(in_array(6, $user->groups) || in_array(10, $user->groups)){
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
                $db->setQuery($query);
                $rooms = $db->loadAssocList();
            } elseif(in_array(2,  $user->groups)){
                $query = "SELECT * FROM #__users WHERE `id` = '".$user->id."' AND `is_hide`='0'";
                $db->setQuery($query);
                $rooms = $db->loadAssocList();
            }
            usort($rooms, 'compare');
            
            function compare($a, $b)
            {
                //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
                $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
                $a = mb_strtolower($a['username0']);
                $b = mb_strtolower($b['username0']);

                for ($i = 0; $i < mb_strlen($a); $i++) {
                    if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                        continue;
                    }
                    if ($i > mb_strlen($b)) {
                        return 1;
                    }
                    if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                        return 1;
                    } else {
                        return -1;
                    }
                }
            }
            
            $start_request = $app->input->getString('start');
            $start_raw = substr($start_request, 0, 10); 
            $start_time_arr = explode(':', substr($start_request, 11, 13));
            $start_time = $start_time_arr[0].':'.$start_time_arr[1];
            $start_arr = explode('-', $start_raw);    
            $start = $start_arr[2].'.'.$start_arr[1].'.'.$start_arr[0];
            //$start = $start_arr[2].'.'.$start_arr[1];
            
            $end_request = $app->input->getString('end');
            $end_raw = substr($end_request, 0, 10); 
            $end_time_arr = explode(':', substr($end_request, 11, 13));
            $end_time = $end_time_arr[0].':'.$end_time_arr[1];
            $end_arr = explode('-', $end_raw);
            $end = $end_arr[2].'.'.$end_arr[1].'.'.$end_arr[0];
            //$end = $end_arr[2].'.'.$end_arr[1];
        ?>
        <div class="com_shifts_popup_header">
            <div class="com_shifts_popup_header_editable_wrapper"><span class="editable dialogTitle" id="shift_name"><?= JText::_('COM_SHIFTS_POPUP_DAYTIME') ?></span> <span class="js_event_header_time dialogTitle"><?=$start_time?>-<?=$end_time?></span></div>
        </div>
      
        <form id="f" action="/index.php?option=com_shifts&task=addPeriod" class="com_shifts_popup_form" style="padding:20px 20px 20px 20px;">
            <!--<h1><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_NEW_PERIOD') ?></h1>-->
             
            <input type="hidden" id="name" name="name" value="holiday" />
            
            <div class="calendar_row calendar_row1">
                <table style="width: 100%">
                    <tr>
                        <td style="vertical-align: top; padding: 2px 0px 0px 0px;  width: 72px; overflow: hidden ">
                            <div class="text_start"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_START') ?></div>
                            <div style="display:none"><input type="text" id="start" class="hidden_original_start" name="start" value="<?=$start ?>" /></div>
                        </td>
                        <td style="vertical-align: top; padding: 0px 0px 0px 0px;  width: 100px;  overflow: hidden; ">
                            <div class="text_start_1"><input type="text" disabled="disabled" class="new_start" value="<?=$start?>" /></div>
                        </td>
                        <td style="width: 20px; text-align: center; white-space: nowrapn; overflow: hidden" >
                            <i class="fa fa-calendar js_event_open_calendar" aria-hidden="true"/>
                            <!--<input type="text" name="daterange" value="<?=date('j.n.Y', strtotime($start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2].' '.$start_time))?> - <?=date('j.n.Y', strtotime($end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2].' '.$end_time))?>" id="dateinput"/>             -->
                            <input tabindex="0" autocomplete="off" type="input" id="calentim00" name="calendar-input" type="text" value="<?=$start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2].' '.$start_time?> - <?=$end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2].' '.$end_time?>" class="" value="" />    
                        </td>
                        <td style="vertical-align: top; padding: 2px 0px 0px 7px; width: 60px;  overflow: hidden; ">
                            <div class="text_end"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_END') ?></div>
                            <div style="display:none"><input type="text" id="end" name="end" class="hidden_original_end" value="<?=$end?>" /></div>
                        </td>
                        <td  style="vertical-align: top; padding: 0px 2px 0px 0px; width: 74px "><div class="text_end_1"><input type="text" disabled="disabled" class="new_end" value="<?=$end?>" /></div></td>
                        <td></td>
                    </tr>
                </table>
                
            </div>
            <div class="new_popup_header">
                <div class="new_popup_start">
                    <div class="new_popup_start_day">
                        <?=$start_arr[2]?>
                    </div>
                    <div class="new_popup_start_right_wrapper">
                        <div class="new_popup_start_month">
                            <?=$model_tthtml5->getMonthName(date('F', strtotime($start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2])), $l2).date(' Y', strtotime($start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2]))?>
                        </div>
                        <div class="new_popup_start_dayname">
                            <?=$model_tthtml5->getDayName(date('l', strtotime($start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2])), $l2)?>
                        </div>
                    </div>
                </div>
                <div class="new_popup_separator">
                    <i class="fa fa-angle-double-right" aria-hidden="true"></i>
                </div>
                 <div class="new_popup_end">
                    <div class="new_popup_start_day">
                        <?=$end_arr[2]?>
                    </div>
                    <div class="new_popup_start_right_wrapper">
                        <div class="new_popup_start_month">
                            <?=$model_tthtml5->getMonthName(date('F', strtotime($end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2])), $l2).date(' Y', strtotime($end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2]))?>
                        </div>
                        <div class="new_popup_start_dayname">
                            <?=$model_tthtml5->getDayName(date('l', strtotime($end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2])), $l2)?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="calendar_row_colors">
                <div class="colors_label js_event_open_calendar"><?= JText::_('COM_SHIFTS_POPUP_COLORS') ?></div>
                <div class="colors">
                    <?php for($i = 0; $i < 7; $i++){?>
                        <?php
                            $cur_i = $i + 1;
                            $color_item = 'circle-'.$cur_i;
                            $hex_code = $model_tthtml5->cssClassToHexConnector($color_item);
                          
                            $is_active = 0;
                            
                            if($hex_code == $selected_shift){
                                $is_active = 1;  
                            }
                        ?>
                        <div class="curcle_wrapper<?php if($is_active === 1){?> active_color<?php } ?>"><div class="circle-<?=$i+1?> js_event_set_color"></div></div>
                    <?php } if($enable_remove_shifts_by_color == '1'){?> 
                        <div class="curcle_wrapper-del"><div class="circle-<?=$i+1?> js_event_delete_all_with_selected_color">X</div></div>
                    <?php } ?>
                </div>
            </div>
            <div class="calendar_row calendar_row_hours">
                <div class="text_hours_from"><?= JText::_('COM_SHIFTS_POPUP_HOURS_FROM') ?></div>
                <div class="middle_hours_str"><i class="fa fa-caret-down" aria-hidden="true"></i></div>
                <div class="hours_from"><?=$start_time?></div>
            </div>
            <div class="calendar_row calendar_row_hours">
                <div class="text_hours_to"><?= JText::_('COM_SHIFTS_POPUP_HOURS_TO') ?></div>
                <div class="middle_hours_str"><i class="fa fa-caret-down" aria-hidden="true"></i></div>
                <div class="hours_to"><?=$end_time?></div> 
            </div>
             <div class="calendar_row calendar_row_texts_from_to">
                <div class="calendar_row_texts_from"><?= JText::_('COM_SHIFTS_POPUP_HOURS_FROM') ?></div>
                <div class="calendar_row_texts_from"><?= JText::_('COM_SHIFTS_POPUP_HOURS_TO') ?></div>
            </div>
            <div class="calendar_row calendar_row_time">
                <input type="text" id="time" value="" />
            </div>
            <div class="calendar_row2 space <?php if($from_top_panel != 1){?>hidden_block1<?php } else{?> user_select_wr<?php } ?>">
                <div class="pre_select_user_text"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_USER') ?></div> 
                <div>
                    <select id="room" name="room">
                        <?php
                        foreach ($rooms as $room) {
                            $selected = $_GET['resource'] == $room['id'] ? ' selected="selected"' : '';
                            $id = $room['id'];
                            if($id == $user->owner_id){
                                continue;
                            }
                            if(!empty($room['username0'])){ $final_username=$room['username0']; } 
                            elseif(!empty($room['username'])){ $final_username=$room['username']; }
                            elseif(!empty($room['name'])){ $final_username=$room['name']; }
            
                            //$name = $final_username;
                            print "<option value='$id' $selected>$final_username</option>";
                        }
                        ?> 
                    </select> 

                </div>
            </div> 
            
            <div class="space space-style-0">
                <button class="btn btn-sm btn-default button_style-1 js_event_submit_shift" type="button"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_SAVE') ?></button>
                <button class="btn btn-sm btn-default button_style-1 button_style-2 js_event_close_shift" type="button"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_CANCEL') ?></button>
                
                <input type="submit" class="lock_button" value="<?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_SAVE') ?>" /> 
                <a class="cancel_button" href="javascript:close();"><?= JText::_('COM_SPEC_HOLIDAY2_IFRAME_CANCEL') ?></a>
            </div>
            <input type="hidden" id="shift_color" name="shift_color" value="<?php if($from_top_panel =='1'){ echo $selected_shift; }?>"/>
            <input type="hidden" id="shift_header" name="shift_name" value="<?= JText::_('COM_SHIFTS_POPUP_DAYTIME') ?>"/>
            
        </form>

        <script type="text/javascript">

            jQuery(document).ready(function($){
                let js=$; 
                js('.new_start, .new_end').mask('00.00.0000 00:00');
                
                 $(".calentim").calentim(); 
            });

            function close(result) {
                if (parent && parent.DayPilot && parent.DayPilot.ModalStatic) {
                    parent.DayPilot.ModalStatic.close(result);
                }
            }

            $("#f").submit(function () {
                let 
                    js=$,
                    new_start=js('.new_start').val(),
                    new_end=js('.new_end').val(),
                    shift_color = js('#shift_color').val();
                 
                if(new_start.length == 0 || new_end.length == 0){
                    alert('Enter start and end!'); 
                    return false;
                } if(new_start.length < 10){
                    alert('Enter start with date format DD.MM.YYYY HH:II!');
                    return false;
                } if(new_end.length < 10){
                    alert('Enter end with date format DD.MM.YYYY HH:II!');
                    return false;
                } if(shift_color.length == 0){
                    alert('Select color!');
                    return false;
                }
                
                js('.lock_button').attr("disabled", true);
                
                let
                    new_start_formatted_arr = new_start.split('.'),
                    datetime_start_arr = new_start_formatted_arr[2].split(' '),
                    hours_from = js('.hours_from').text(),
                    //new_start_formatted = datetime_start_arr[0]+'-'+new_start_formatted_arr[1]+'-'+new_start_formatted_arr[0]+' '+datetime_start_arr[1],
                    new_start_formatted = datetime_start_arr[0]+'-'+new_start_formatted_arr[1]+'-'+new_start_formatted_arr[0]+' '+hours_from,
                    
                    new_end_formatted_arr = new_end.split('.'),
                    datetime_end_arr = new_end_formatted_arr[2].split(' '),
                    hours_to = js('.hours_to').text(),
                    //new_end_formatted = datetime_end_arr[0]+'-'+new_end_formatted_arr[1]+'-'+new_end_formatted_arr[0]+' '+datetime_end_arr[1];
                    new_end_formatted = datetime_end_arr[0]+'-'+new_end_formatted_arr[1]+'-'+new_end_formatted_arr[0]+' '+hours_to;
                    
                console.log(datetime_start_arr);
                console.log(new_start_formatted_arr);
                console.log(new_start_formatted);
                 
                console.log( datetime_end_arr);
                console.log(new_end_formatted_arr);
                console.log( new_end_formatted);
                //return false;
                
                console.log('.hidden_original_start='+new_start_formatted);
                console.log('.hidden_original_end='+new_end_formatted);
               // return false;
                
                js('.hidden_original_start').val(new_start_formatted);
                js('.hidden_original_end').val(new_end_formatted);
                //js('#shift_color').val(rgb2hex(shift_color));
                
                var f = $("#f");
                $.post(f.attr("action"), f.serialize(), function (result) {
                    //console.log(result);
                    close(eval(result));
                });
                return false;
            });

            $(document).ready(function ($) {
                let js = $,
                calentim_options = {
                    target: js("#calentim00"), 
                    showOn: "bottom",
                    autoAlign: false, 
                    format: "YYYY-MM-DD HH:mm", 
                    calendarCount: 2,  
                    hourFormat: 24,
                    locale: "en",
                    ranges: [
                        { title: "Today", startDate: moment().startOf("day"), endDate: moment().endOf("day") },
                        { title: "3 Days", startDate: moment().startOf("day"), endDate: moment().add(2, "days").endOf("day") },
                        { title: "5 Days", startDate: moment().startOf("day"), endDate: moment().add(4, "days").endOf("day") },
                        { title: "1 Week", startDate: moment().startOf("day"), endDate: moment().add(6, "days").endOf("day") },
                        { title: "Till Next Week", startDate: moment().startOf("day"), endDate: moment().endOf("week").endOf("day") },
                        { title: "Till Next Month", startDate: moment().startOf("day"), endDate: moment().endOf("month").endOf("day") },
                    ],
                    rangeLabel: "Ranges: ",
                    onafterselect: function(calentim, startDate, endDate){
                        // calentim: calentim object instance
                        // startDate: moment.js instance
                        // endDate: moment.js instance
                        
                        console.log('onafterselect', startDate, endDate);
                        setFrontTime(startDate, endDate);
                    }, 
                    onrangeselect: function(calentim, range){
                        // calentim: calentim object instance
                        // range: selected range definition
                        
                        console.log('onrangeselect', range);
                        let 
                            startDate = moment(range.startDate._d),
                            endDate = moment(range.endDate._d);
                    
                        setFrontTime(startDate, endDate);
                    }, 
                    ontimechange: function(calentim, startDate, endDate){
                        // calentim: calentim object instance
                        // startDate: the start date moment object
                        // endDate: the end date moment object
                        
                        console.log('ontimechange', startDate, endDate);
                        setFrontTime(startDate, endDate);
                    }
                };;
                
                $("#name").focus();
                
                calentim_options['ranges'][0]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_TODAY_BUTTON') ?>';
                calentim_options['ranges'][1]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_3D_BUTTON') ?>';
                calentim_options['ranges'][2]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_5D_BUTTON') ?>';
                calentim_options['ranges'][3]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_1W_BUTTON') ?>';
                calentim_options['ranges'][4]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_TILL_WEEK_BUTTON') ?>';
                calentim_options['ranges'][5]['title'] = '<?= JText::_('COM_SHIFTS_CALENTIM_TILL_MONTH_BUTTON') ?>';    
                calentim_options['rangeLabel'] = '<?= JText::_('COM_SHIFTS_CALENTIM_RANGE_TEXT') ?>';
                
                js(".js_event_open_calendar, .middle_hours_str").calentim(calentim_options);

                //init timepicker inline
                js("#time").calentim({
                    inline: true,
                    showCalendars: false,
                    format: "hh:mm",
                    hourFormat: 24,
                    startDate: moment("<?=$start_arr[0].'-'.$start_arr[1].'-'.$start_arr[2].' '.$start_time?>", 'YYYY-MM-DD HH:mm'),
                    endDate: moment("<?=$end_arr[0].'-'.$end_arr[1].'-'.$end_arr[2].' '.$end_time?>", 'YYYY-MM-DD HH:mm'), 
                    onafterselect: function(calentim, startDate, endDate){
                        // calentim: calentim object instance
                        // startDate: moment.js instance
                        // endDate: moment.js instance
                        
                        console.log('onafterselect', startDate, endDate);
                        setFrontTime1(startDate, endDate);
                    }, 
                    onrangeselect: function(calentim, range){
                        // calentim: calentim object instance
                        // range: selected range definition
                        
                        console.log('onrangeselect', range);
                        let 
                            startDate = moment(range.startDate._d),
                            endDate = moment(range.endDate._d);
                    
                        setFrontTime1(startDate, endDate);
                    }, 
                    ontimechange: function(calentim, startDate, endDate){
                        // calentim: calentim object instance
                        // startDate: the start date moment object
                        // endDate: the end date moment object
                        
                        console.log('ontimechange', startDate, endDate);
                        setFrontTime1(startDate, endDate);
                    },
                   
                });
                function setFrontTime(startDate, endDate){
                    console.log('js fn setFrontTime()');
                    
                    let 
                        start_moment = moment(startDate),
                        end_moment = moment(endDate),
                        
                        start_date00 = start_moment.format('DD.MM.YYYY HH:mm'),
                        end_date00 = end_moment.format('DD.MM.YYYY HH:mm'),
                        
                        start_time = start_moment.format('HH:mm'),
                        end_time = end_moment.format('HH:mm'); 
 
                    
                    js('.new_start').val(start_date00);
                    js('.new_end').val(end_date00);
                    
                    js('.hours_from').text(start_time);
                    js('.hours_to').text(end_time);
                    
                    js('.js_event_header_time').text(start_time+'-'+end_time);
                    
                    //set texts in header
                    js('.new_popup_start .new_popup_start_day').text(start_moment.format('DD'));
                    js('.new_popup_start .new_popup_start_month').text(start_moment.format('MMMM YYYY'));
                    js('.new_popup_start .new_popup_start_dayname').text(start_moment.format('dddd'));
                    
                    js('.new_popup_end .new_popup_start_day').text(end_moment.format('DD'));
                    js('.new_popup_end .new_popup_start_month').text(end_moment.format('MMMM YYYY'));
                    js('.new_popup_end .new_popup_start_dayname').text(end_moment.format('dddd'));
                    
                    //refresh timepicker
                    let time_instance = js("#time").data("calentim");
                    time_instance.setStart(start_moment);
                    time_instance.setEnd(end_moment);  
                }
                
                function setFrontTime1(startDate, endDate){
                    console.log('js fn setFrontTime1()');
                    
                    let 
                        start_moment = moment(startDate),
                        end_moment = moment(endDate),
                        
                        start_date00 = start_moment.format('DD.MM.YYYY HH:mm'),
                        end_date00 = end_moment.format('DD.MM.YYYY HH:mm'),
                        
                        start_time = start_moment.format('HH:mm'),
                        end_time = end_moment.format('HH:mm'); 

                    
                    js('.new_start').val(start_date00);
                    js('.new_end').val(end_date00);
                    
                    js('.hours_from').text(start_time);
                    js('.hours_to').text(end_time);
                    
                    js('.js_event_header_time').text(start_time+'-'+end_time);
                    //console.log('start_moment='+start_moment.format(''));
                    
                    //js('#calentim00').val(start_moment.format('YYYY-MM-DD HH:mm-YYYY-MM-DD HH:mm'));
                    
                    //set texts in header
                    js('.new_popup_start .new_popup_start_day').text(start_moment.format('DD'));
                    js('.new_popup_start .new_popup_start_month').text(start_moment.format('MMMM YYYY'));
                    js('.new_popup_start .new_popup_start_dayname').text(start_moment.format('dddd'));
                    
                    js('.new_popup_end .new_popup_start_day').text(end_moment.format('DD'));
                    js('.new_popup_end .new_popup_start_month').text(end_moment.format('MMMM YYYY'));
                    js('.new_popup_end .new_popup_start_dayname').text(end_moment.format('dddd'));
                    
                    //refresh calendar
                    let calendar_instance = js(".js_event_open_calendar, .middle_hours_str").data("calentim");
                    calendar_instance.setStart(start_moment);
                    calendar_instance.setEnd(end_moment);      
                }
                
                /*js('.js_event_open_calendar').on('click', function(){
                   js('#dateinput').css('visibility', 'visible').trigger('focus').css('visibility', 'hidden');
                });*/
                
                js('.js_event_submit_shift').on('click', function(){
                    js('#f').trigger('submit');
                });
                
                js('.js_event_close_shift').on('click', function(){
                   close();
                });
                
               js('.js_event_set_color').on('click', function(){
                    let 
                        item = js(this),
                        shift_color = js('#shift_color'),
                        selected_color = item.css('background-color'),
                        ctx = document.createElement('canvas').getContext('2d'),
                        hexColor;

                    ctx.strokeStyle = selected_color;
                    hexColor = ctx.strokeStyle;
                     
                    js('.js_event_set_color').parent().removeClass('active_color');
                    item.parent().addClass('active_color');
                    
                    shift_color.val(hexColor);
                });
                
                js('.editable').editable('/index.php?option=com_shifts&task=updateComShiftsHeader', {
                    data_value : js('.editable').html(),
                    cssclass: 'form_edit_header_com_shifts',
                    onblur:'submit',
                    onsubmit: function(settings, td){
                       
                    },
                    callback: function(data){
                        if(!isHTML(data)){
                           let shift_name = js.cookie('com_shifts_new_shift_name');
                           
                           js('#shift_header').val(shift_name);
                        }
                        
                    }
                });
                
                function isHTML(str) {
                    let a = document.createElement('div');
                    a.innerHTML = str;

                    for (var c = a.childNodes, i = c.length; i--; ) {
                        if (c[i].nodeType == 1) return true; 
                    }

                    return false;
                }
                
                /*js('.middle_hours_str').on('click', function(){
                   js('.js_event_open_calendar').trigger('click');
               });*/

                <?php require('./editable_calentim.php' );?>
             
                <?php if($enable_remove_shifts_by_color == '1'){?>
                    js('body').on('click', '.js_event_delete_all_with_selected_color', function(){
                        console.log('delete all shifts with selected color');
                    
                        if (!window.confirm('<?= JText::_('COM_SHIFTS_CONFIRM_DEL_SELECTED') ?>')) {
                            return false;
                        }
                    
                        let 
                            selected_color = js('#shift_color').val(),
                            start = window.parent.dp.visibleStart(),
                            end = window.parent.dp.visibleEnd(),
                            msg_success = '<?= JText::_('COM_SHIFTS_DELETE_ITEMS_BY_COLOR_SUCCESS') ?>',
                            popup_start = js('.hours_from').text(),
                            popup_end = js('.hours_to').text();
                
                        //alert(selected_color);
                    
                        js.ajax({
                            type: "POST",
                            url: '/index.php?option=com_shifts&task=removeShiftsByColor&<?= JSession::getFormToken(); ?>=1',
                            async: true,
                            data: ({
                               "start": start.toString(),
                               "end": end.toString(),
                               "lang1": '<?= $l2 ?>',
                               "selected_color": selected_color,
                               "start_time": popup_start,
                               "end_time": popup_end 
                            }),
                            dataType: "json",
                            success: function (data) {
                                console.log(data);

                                if (data.errors != null && data.errors.length > 0) {
                                    alert(data.errors); 
                                    return false;
                                } else {
                                    console.log('removed', data);

                                               
                                    try {
                                        alert(msg_success);
                                        window.parent.reloadCalendar();//uncomment after!!
                                        console.log('after reloadCalndar()2');
                                        js('.js_event_close_shift').trigger('click');
                                    } catch (e) {
                                        console.log(e);
                                    }
                                }
                            }, error: function (xhr, status) {
                                js('body').trigger('resize');
                                // check if xhr.status is defined in $.ajax.statusCode
                                // if true, return false to stop this function
                                if (typeof this.statusCode[xhr.status] != 'undefined') {
                                    return false;
                                }

                                // else continue
                           
                               alert('Error during the process of remove shifts by color: Error in server with code ' + xhr.status + ' and text: ' + xhr.statusText);
                            }, statusCode: {
                                /*404: function(response) {
                                    console.log('ajax.statusCode: 404');
                                }*/
                            }
                        });
                });
               <?php } ?>
            });

        </script>
        </div>
    </body>
</html>
