<?php

/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Spec_holiday2 list model
 */
class Spec_holiday2ModelViews extends JModelList {

    /**
     * Constructor
     *
     * @param    array          An optional associative array of configuration settings
     *
     * @see      JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'created_by', 'a.created_by',
                'state', 'a.state',
                'ordering', 'a.ordering',
            );
        }
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state
     *
     * Note. Calling getState in this method will result in recursion
     *
     * @param   string  $ordering   An optional ordering field
     * @param   string  $direction  An optional direction (asc|desc)
     *
     * @return  void
     *
     * @since   1.6
     */
    protected function populateState($ordering = null, $direction = null) {
        $app = JFactory::getApplication();
        $input = $app->input;

        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        // Load the list state
        $this->setState('list.start', $input->get('limitstart', 0, 'uint'));
        $this->setState('list.limit', $input->get('limit', $app->get('list_limit', 20), 'uint'));

        // List state information
        parent::populateState($ordering, $direction);
    }

    /**
     * Build an SQL query to load the list data
     *
     * @return    JDatabaseQuery
     * @since    1.6
     */
    protected function getListQuery() {
        $query = $this->_db->getQuery(true);

        $query->select('a.id, a.state, a.ordering');

        $query->from('`#__spec_holiday_views` AS a');

        $query->select('b.name as created_by');
        $query->leftJoin($this->_db->qn('#__users') . ' AS b ON b.id = a.created_by');

        $query->where('a.state = 1');

        // Search for this word
        $searchWord = $this->getState('filter.search');

        // Search in these columns
        $searchColumns = array(
            'b.name',
        );

        if (!empty($searchWord)) {
            if (stripos($searchWord, 'id:') === 0) {
                // Build the ID search
                $idPart = (int) substr($searchWord, 3);
                $query->where($this->_db->qn('a.id') . ' = ' . $this->_db->q($idPart));
            } else {
                $query = Spec_holidayHelpersFrontend::buildSearchQuery($searchWord, $searchColumns, $query);
            }
        }

        // Add the list ordering clause
        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');

        if ($orderCol && $orderDirn) {
            $query->order($this->_db->escape($orderCol . ' ' . $orderDirn));
        } else {
            $query->order('a.ordering');
        }

        return $query;
    }

    /** Method to get an array of data items
     *
     * @return  mixed An array of data on success, false on failure.
     */
    public function getItems() {
        $items = parent::getItems();

        include_once JPATH_COMPONENT_ADMINISTRATOR . '/helpers/form/view.php';

        $form = new FormViewSpec_holiday;

        $fieldOptions = $form->getFieldOptions();

        foreach ($items as $i => $item) {
            foreach ($item as $key => $value) {
                // If this field has options
                if (isset($fieldOptions[$key])) {
                    // Update the item key with the field option
                    $item->{$key} = JText::_($fieldOptions[$key][$value]);
                }
            }

            $items[$i] = $item;
        }

        return $items;
    }


    /****************************************/
    public function getManagerUsersObj($mode, $u_id)
    {
        if ($mode != 'api_html') {
            $owner_id = $this->user->owner_id;
        } else {
            $user = JFactory::getUser($u_id);
            $owner_id = $user->owner_id;
        }
        $db = & JFactory::getDBO();

        if(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        } else{
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        }



        return $data;
    }

    public function getMonthList($year)
    {
        $tag=$this->lang->getTag();
        if($tag==='is-IS'){
            $lang='is';
        }else{
            $lang='en';
        }

        $months_array=[
            "Jan."=>"Jan.",
            "Feb."=>"Feb.",
            "Mar."=>"Mars.",
            "Apr."=>"Apr.",
            "May"=>"Maí",
            "Jun."=>"Júní",
            "Jul."=>"Júlí",
            "Aug."=>"ág.",
            "Sep."=>"Sep.",
            "Oct."=>"Okt.",
            "Nov."=>"Nóv.",
            "Dec."=>"Des."
        ];

        if($lang==='en'){
            $res=array_keys($months_array);
        } elseif($lang==='is'){
            $res=array_values($months_array);
        }
        return $res;
    }

    public function getUserImg($user_id)
    {
        $user_img='d';
        if(empty($user_img)){
            $html='<i class="fa fa-user-circle-o" aria-hidden="true"></i>';
        } else{
            $html='<img src="/media/com_spec_holiday/img/demo.jpg" alt=""/>';
        }
        return $html;
    }

    public function getHolidaysScale($user_list)
    {
        $output_arr=[];
        $month_list=$this->specialGetMonthList();
        //$first_day_this_month = date('M-01-Y'); // hard-coded '01' for first day
        //$last_day_this_month  = date('M-t-Y');
        //$last_day_april_2010 = date('M-t-Y', strtotime('April 21, 2010'));

        foreach($user_list as $one_user){
            $i=0;
            foreach($month_list as $k=>$v){
                $output_arr[$one_user->id][$i]['month']=$k;
                $output_arr[$one_user->id][$i]['month_number']=date('m', strtotime('first day of '.$k));
                $output_arr[$one_user->id][$i]['dates']=$this->getPeriodInMonth($k, $one_user->id);

                $i++;
            }

        }

        return $output_arr;
    }

    private function specialGetMonthList()
    {
        $months_array=[
            "Jan"=>"Jan.",
            "Feb"=>"Feb.",
            "Mar"=>"Mars.",
            "Apr"=>"Apr.",
            "May"=>"Maí",
            "Jun"=>"Júní",
            "Jul"=>"Júlí",
            "Aug"=>"ág.",
            "Sep"=>"Sep.",
            "Oct"=>"Okt.",
            "Nov"=>"Nóv.",
            "Dec"=>"Des."
        ];

        return $months_array;
    }

    private function getPeriodInMonth($month_name, $user_id)
    {
        $first_day=date('d.m.Y', strtotime('first day of '.$month_name.' '.date('Y')));
        $last_day=date('d.m.Y', strtotime('last day of '.$month_name.' '.date('Y')));
        $count_dat_in_month=date('t', strtotime('first day of '.$month_name.' '.date('Y')));

        $period=[];
        //before opt
       /* for($i=1; $i<=$count_dat_in_month; $i++)
        {
            if($i===1){
                $period[$i]['date']=$first_day;
            } else{
                $dates_raw=explode('.', $period[$i-1]['date']);
                $period[$i]['date']=DateTime::createFromFormat('d.m.Y', ($dates_raw[0]+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            }
            $period[$i]['is_marked']=$this->getDateMarkedStatus($period[$i]['date'], $user_id);

            $period_start_stop=$this->getPeriods($period[$i]['date'], $user_id);
            $period[$i]['period_start']=$period_start_stop['start'];
            $period[$i]['period_end']=$period_start_stop['stop'];

            $one_date_obj=$this->getOneDateObj($period[$i]['date'], $user_id);
            $period[$i]['position_edited']=$one_date_obj->position_edited;
            $period[$i]['x_position']=$one_date_obj->x_position;
        }*/
        //$one_date_obj = $this->getOneMonthObj($month_name,$user_id);

        for($i=1; $i<=$count_dat_in_month; $i++)
        {
            if($i===1){
                $period[$i]['date']=$first_day;
            } else{
                $dates_raw=explode('.', $period[$i-1]['date']);
                $period[$i]['date']=DateTime::createFromFormat('d.m.Y', ($dates_raw[0]+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            }
            $one_date_obj=$this->getOneDateObj($period[$i]['date'], $user_id);

            $mark=$one_date_obj->is_marked;
            if(!empty($one_date_obj)){
                $mark=true;
            } else{
                $mark=false;
            }
            $period[$i]['is_marked']=$mark;

            //$period_start_stop=$this->getPeriods($period[$i]['date'], $user_id);
            $period[$i]['period_start']=$one_date_obj->period_start;
            $period[$i]['period_end']=$one_date_obj->period_end;

           //$one_date_obj=$this->getOneDateObj($period[$i]['date'], $user_id);
            $period[$i]['position_edited']=$one_date_obj->position_edited;
            $period[$i]['x_position']=$one_date_obj->x_position;
        }



        return [
            'first_day'=>$first_day,
            'last_day'=>$last_day,
            'count_day_in_month'=>$count_dat_in_month,
            'all_dates'=>$period
        ];
    }

    private function getOneMonthObj($month_name, $id_user){
        $db=$this->db;
        $query = $db->getQuery(true);

        $first_day=date('d.m.Y', strtotime('first day of '.$month_name.' '.date('Y')));
        $last_day=date('d.m.Y', strtotime('last day of '.$month_name.' '.date('Y')));
        $count_dat_in_month=date('t', strtotime('first day of '.$month_name.' '.date('Y')));
        $where = '';
        $period=[];
        $or = '';
        for($i=1; $i<=$count_dat_in_month; $i++)
        {
            if($i===1){
                $period[$i]['date']=$first_day;
            } else{
                $where = $where . ' OR ';
                $dates_raw=explode('.', $period[$i-1]['date']);
                $period[$i]['date']=DateTime::createFromFormat('d.m.Y', ($dates_raw[0]+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            }

            $where = $where . '('.$db->quoteName('date').'="'.$period[$i]['date'].'" AND '.$db->quoteName('id_user').'="'.$id_user.'")';
        }
        print_r($where);exit;

        $query->select('*');
        $query->from($db->quoteName('#__com_spec_holidays'));
        $query->where($db->quoteName('date').'="'.$date.'" AND '.$db->quoteName('id_user').'="'.$id_user.'"');

        // Reset the query using our newly populated query object.
        $db->setQuery($query);

        // Load the results as a list of stdClass objects (see later for more options on retrieving data).
        $results = $db->loadObject();
        return $results;
    }

    private function getOneDateObj($date, $id_user)
    {
        $db=$this->db;
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from($db->quoteName('#__com_spec_holidays'));
        $query->where($db->quoteName('date').'="'.$date.'" AND '.$db->quoteName('id_user').'="'.$id_user.'"');

        // Reset the query using our newly populated query object.
        $db->setQuery($query);

        // Load the results as a list of stdClass objects (see later for more options on retrieving data).
        $results = $db->loadObject();
        return $results;

    }

    private function getPeriodInMonthAndYear($month_name, $user_id, $year)
    {
        $first_day=date('d.m.Y', strtotime('first day of '.$month_name.' '.$year));
        $last_day=date('d.m.Y', strtotime('last day of '.$month_name.' '.$year));
        $count_dat_in_month=date('t', strtotime('first day of '.$month_name.' '.$year));

        $period=[];
        for($i=1; $i<=$count_dat_in_month; $i++)
        {
            if($i===1){
                $period[$i]['date']=$first_day;
            } else{
                $dates_raw=explode('.', $period[$i-1]['date']);
                $period[$i]['date']=DateTime::createFromFormat('d.m.Y', ($dates_raw[0]+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            }
            $period[$i]['is_marked']=$this->getDateMarkedStatus($period[$i]['date'], $user_id);

            $period_start_stop=$this->getPeriods($period[$i]['date'], $user_id);
            $period[$i]['period_start']=$period_start_stop['start'];
            $period[$i]['period_end']=$period_start_stop['stop'];

            $one_date_obj=$this->getOneDateObj($period[$i]['date'], $user_id);
            $period[$i]['position_edited']=$one_date_obj->position_edited;
            $period[$i]['x_position']=$one_date_obj->x_position;
        }



        return [
            'first_day'=>$first_day,
            'last_day'=>$last_day,
            'count_day_in_month'=>$count_dat_in_month,
            'all_dates'=>$period
        ];
    }

    private function getDateMarkedStatus($date, $id_user)
    {
        $db=$this->db;
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from($db->quoteName('#__com_spec_holidays'));
        $query->where($db->quoteName('date').'="'.$date.'" AND '.$db->quoteName('id_user').'="'.$id_user.'"');

        // Reset the query using our newly populated query object.
        $db->setQuery($query);

        // Load the results as a list of stdClass objects (see later for more options on retrieving data).
        $results = $db->loadObject();

        /*$query='SELECT * FROM #__com_spec_holidays WHERE `date`="'.$date.'" AND `id_user`="'.$id_user.'"';
        $this->db->setQuery( $query );
        $results = $this->db->loadObject();*/

        if(!empty($results)){
            return true;
        } else{
            return false;
        }
        //return false;
        //return mt_rand(false, true);
    }

    private function getPeriods($date, $id_user)
    {
        $db=$this->db;
        $query = $db->getQuery(true);

        $query->select('*');
        $query->from($db->quoteName('#__com_spec_holidays'));
        $query->where($db->quoteName('date').'="'.$date.'" AND '.$db->quoteName('id_user').'="'.$id_user.'"');
        //$query->limit('0,1');
        // Reset the query using our newly populated query object.
        $db->setQuery($query);

        // Load the results as a list of stdClass objects (see later for more options on retrieving data).
        $result = $db->loadObject();


        return [
            'start'=>$result->period_start,
            'stop'=>$result->period_end
        ];

    }

    public function getDateCssWidth($total_dates){
        return 100/count($total_dates).'%';
    }

    public function loadScale($year, $department_obj)
    {
        $user_list=$this->getManagerUsersObj('', '');
        $holidays_scale=$this->getHolidaysScaleWithYear($year, $user_list);
        $html='';

        foreach($user_list as $one_user)
        {
            if(!empty($department_obj) && !in_array($one_user->group_user, $department_obj)) continue;

            $html.='<div class="flex_table-one-item one_row" data-filter="'.$one_user->group_user.'">
                        <div class="flex_table-one-item one_cell one_item-user_img">'.
                            $this->getUserImg($one_user->id).'
                        </div>
                        <div class="flex_table-one-item one_cell one_item-usename">'.$one_user->username0.'</div>';
                            foreach($holidays_scale[$one_user->id] as $one_scale_month)
                            {
                                $html.='<div class="flex_table-one-item one_cell one_item-month" data-user-id="'.$one_user->id.'" data-month="'.$one_scale_month['month_number'].'">';
                                    foreach($one_scale_month['dates']['all_dates'] as $one_date)
                                    {
                                        $unical_string=$this->generateRandomString(5);
                                        if($one_date['position_edited']=='1'){
                                            $html.='<div data-key="'.$unical_string.'" data-x_position="'.$one_date['x_position'].'" data-edited="'.$one_date['position_edited'].'" data-date="'.$one_date['date'].'"';
                                            if(!empty($one_date['period_start'])){
                                                $html.='data-period_start="'.$one_date['period_start'].'"';
                                            } if(!empty($one_date['period_end'])){
                                                $html.='data-period_end="'.$one_date['period_end'].'"';
                                            }
                                            $html.=' class="flex_table-one-subitem one_date'; if($one_date['is_marked']=='true'){$html.=' markered'; }
                                                $html.='" style="width:'; $html.=$this->getDateCssWidth($one_scale_month['dates']['all_dates']).'">'
                                            . '</div>';
                                        } else{
                                            $html.='<div data-key="'.$unical_string.'" data-edited="'.$one_date['position_edited'].'" data-date="'.$one_date['date'].'"';
                                            if(!empty($one_date['period_start'])){
                                                $html.='data-period_start="'.$one_date['period_start'].'"';
                                            } if(!empty($one_date['period_end'])){
                                                $html.='data-period_end="'.$one_date['period_end'].'"';
                                            }
                                            $html.=' class="flex_table-one-subitem one_date'; if($one_date['is_marked']=='true'){$html.=' markered'; }
                                                $html.='" style="width:'; $html.=$this->getDateCssWidth($one_scale_month['dates']['all_dates']).'">'
                                            . '</div>';
                                        }
                                    }
                                $html.='</div>';

                            }
                            $html.='</div>';
         }

        return $html;
    }

    public function addPeriodToScaleOld($year)
    {
        $month_name='Juny';
        $first_day=date('d.m.Y', strtotime('first day of '.$month_name.' '.date('Y')));
        $count_dat_in_month=date('t', strtotime('first day of '.$month_name.' '.date('Y')));

        $dates_raw=explode('.', '11.06.'.$year);
        $period_start='11.06.'.$year;
        $period_end='17.06.'.$year;

        //11.06-12.06, insert one week
        for($i=10; $i<=16; $i++)
        {
            $item=new stdClass();
            $item->id=null;
            $item->date=DateTime::createFromFormat('d.m.Y', ($i+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            $item->is_markered=1;
            $item->id_user=$this->user->id;
            $item->in_month='06';
            $item->date_created=date('d.m.Y H:i:s');
            $item->timestamp_created=time();

            /*if($i===10){
               $period_start=DateTime::createFromFormat('d.m.Y', ($i+1).'.'.$dates_raw[1].'.'.$dates_raw[2])->format('d.m.Y');
            }*/
            $item->period_start=$period_start;
            $item->period_end=$period_end;


            $this->db->insertObject('#__com_spec_holidays', $item);
        }
        $this->db->insertid();

        //if(!empty($added_id)) $this->setPeriodAddDates($added_id, $dates_raw);
    }

    private function normilizeDate($start, $end)
    {
        return [
            'start'=>DateTime::createFromFormat('d-m-Y', $start),
            'end'=>DateTime::createFromFormat('d-m-Y', $end)
        ];
    }

    public function addPeriodToScale($year, $start, $end, $user_id)
    {
        $normal_dates=$this->normilizeDate($start, $end);
        $start_normal=$normal_dates['start'];
        $end_normal=$normal_dates['end'];


        $period=new DatePeriod($start_normal, new DateInterval('P1D'), $end_normal->add(new DateInterval('P1D')));

        $result = [];
        foreach ($period as $val)
        {
            $daykey = $val->format('d.m.Y');
            $result[] = $daykey;
        }

        $period_end=end($result);

        foreach($result as $one_date)
        {
            $one_date_object=DateTime::createFromFormat('d.m.Y', $one_date);
            $item=new stdClass();
            $item->id=null;
            $item->date=$one_date;
            $item->is_markered=1;
            $item->id_user=$user_id;
            $item->in_month=$one_date_object->format('m');
            $item->date_created=date('d.m.Y H:i:s');
            $item->timestamp_created=time();
            $item->period_start=$result[0];
            $item->period_end=$period_end;

            $this->db->insertObject('#__com_spec_holidays', $item);
        }
    }

    private function setPeriodAddDates($added_id, $dates_raw)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($added_id, true), FILE_APPEND | LOCK_EX);
    }

    /*private function normaliseYear($old_year, $mode)
    {
        if($mode=='prev'){
            $new_year=$old_year-1;
        } elseif($mode=='next'){
            $new_year=$old_year+1;
        }

        return (int)$new_year;
    }*/

    public function loadYear($year, $mode)
    {
        $user_list=$this->getManagerUsersObj('', '');

        $holidays_scale=$this->getHolidaysScaleWithYear($year, $user_list);
        $html='';

        foreach($user_list as $one_user)
        {
            //if(!empty($department_obj) && !in_array($one_user->group_user, $department_obj)) continue;

            $html.='<div class="flex_table-one-item one_row" data-filter="'.$one_user->group_user.'">
                        <div class="flex_table-one-item one_cell one_item-user_img">'.
                            $this->getUserImg($one_user->id).'
                        </div>
                        <div class="flex_table-one-item one_cell one_item-usename">'.$one_user->username0.'</div>';
                            foreach($holidays_scale[$one_user->id] as $one_scale_month)
                            {
                                $html.='<div class="flex_table-one-item one_cell one_item-month" data-user-id="'.$one_user->id.'" data-month="'.$one_scale_month['month_number'].'">';
                                    foreach($one_scale_month['dates']['all_dates'] as $one_date)
                                    {
                                        $unical_string=$this->generateRandomString(5);

                                        if($one_date['position_edited']=='1'){
                                            $html.='<div data-key="'.$unical_string.'" data-x_position="'.$one_date['x_position'].'" data-edited="'.$one_date['position_edited'].'" data-date="'.$one_date['date'].'"';
                                            if(!empty($one_date['period_start'])){
                                                $html.='data-period_start="'.$one_date['period_start'].'"';
                                            } if(!empty($one_date['period_end'])){
                                                $html.='data-period_end="'.$one_date['period_end'].'"';
                                            }
                                            $html.=' class="flex_table-one-subitem one_date'; if($one_date['is_marked']=='true'){$html.=' markered'; }
                                                $html.='" style="width:'; $html.=$this->getDateCssWidth($one_scale_month['dates']['all_dates']).'">'
                                            . '</div>';
                                        } else{
                                            $html.='<div data-key="'.$unical_string.'" data-edited="'.$one_date['position_edited'].'" data-date="'.$one_date['date'].'"';
                                            if(!empty($one_date['period_start'])){
                                                $html.='data-period_start="'.$one_date['period_start'].'"';
                                            } if(!empty($one_date['period_end'])){
                                                $html.='data-period_end="'.$one_date['period_end'].'"';
                                            }
                                            $html.=' class="flex_table-one-subitem one_date'; if($one_date['is_marked']=='true'){$html.=' markered'; }
                                                $html.='" style="width:'; $html.=$this->getDateCssWidth($one_scale_month['dates']['all_dates']).'">'
                                            . '</div>';
                                        }
                                    }
                                $html.='</div>';

                            }
                            $html.='</div>';
         }

        return $html;
    }

    public function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        $unical_key=hash('sha256', $randomString);
        return $unical_key;
    }

    private function getHolidaysScaleWithYear($year, $user_list)
    {
        $output_arr=[];
        $month_list=$this->specialGetMonthList();


        foreach($user_list as $one_user){
            $i=0;
            foreach($month_list as $k=>$v){
                $output_arr[$one_user->id][$i]['month']=$k;
                //here
                $output_arr[$one_user->id][$i]['month_number']=date('m', strtotime('first day of '.$k.' '.$year));
                $output_arr[$one_user->id][$i]['dates']=$this->getPeriodInMonthAndYear($k, $one_user->id, $year);

                $i++;
            }

        }

        return $output_arr;
    }

    public function checkPeriod($start, $user_id)
    {
        $normal_dates=$this->normilizeDate($start, $end);
        $start_normal=$normal_dates['start']->format('d.m.Y');
        //$end_normal=$normal_dates['end']->format('d.m.Y');

        $query='SELECT `id` FROM #__com_spec_holidays WHERE `period_start`="'.$start_normal.'" AND `id_user`="'.$user_id.'"';
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($query, true), FILE_APPEND | LOCK_EX);

        $this->db->setQuery($query);
        $res = $this->db->loadObject();
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($res, true), FILE_APPEND | LOCK_EX);
        if(empty($res)){
            return 'period_not_exist';
        } else{
            return 'period_already_exist';
        }
    }

    public function getLayoutGroups($l)
    {
        /*if($l=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday2';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }*/
        if($l=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday2';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        $db =$this->db;
        $current_user=& JFactory::getUser();
        $owner_id=$current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id'  ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();


        $final=$this->super_unique($res, 'group_user');
        $html='';
        $html1='';
        $html2='';

            foreach($final as $group){
                if(!empty($group['group_user'])){
                    $html.=''
                        . '<div class="one_option" data-option-value="'.$group['group_user'].'">'
                            . '<span>'.$group['group_user'].'</span>'
                            . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '</div>';
                }
            }



        if(!empty($html)){
                 $html1='<div class="one_option one_option_header">'.JText::_('COM_SPEC_HOLIDAY2_DEP_FILTER_INCL').'</div>';
                 $html2='<div class="bottom_apply_button_wrapper"><button type="button" class="btn btn-mini btn-primary applyFilteringByDepartment">'.JText::_('COM_SPEC_HOLIDAY2_DEP_FILTER_APPLY').'</button></div>';
                 return $html1.$html.$html2;
            } else{
                return '';
            }
    }

    public function getLayoutGroupsNewPsd($l)
    {
        /*if($l=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday2';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }*/
        if($l=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_spec_holiday2';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        $db =$this->db;
        $current_user=& JFactory::getUser();
        $owner_id=$current_user->owner_id;

        $query = "SELECT `id`, `group_user` FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `id` DESC";
        $db->setQuery($query);
        $res = $db->loadAssocList();


        $final=$this->super_unique($res, 'group_user');
        $html='';
        $html1='';
        $html2='';

            foreach($final as $group){
                if(!empty($group['group_user'])){
                    $html.=''
                        . '<div class="one_option" data-option-value="'.$group['group_user'].'">'
                            . '<span>'.$group['group_user'].'</span>'
                            . '<i class="fa fa-circle-thin" aria-hidden="true"></i>'
                        . '</div>';
                }
            }



        if(!empty($html)){
                 $html1='<div class="one_option one_option_header">'.JText::_('COM_SPEC_HOLIDAY2_DEP_FILTER_INCL').'</div>';
                 $html2='<div class="bottom_apply_button_wrapper"><button type="button" class="btn btn-primary btn-sm applyFilteringByDepartment button_style_pdf">'.JText::_('COM_SPEC_HOLIDAY2_DEP_FILTER_APPLY').'</button></div>';
                 return $html1.$html.$html2;
            } else{
                return '';
            }
    }
    
    private function super_unique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }

    public function removePeriodInScale($start, $end, $user_id, $mode)
    {
        if($mode!='internal'){
            $normal_dates=$this->normilizeDate($start, $end);
            $start_normal=$normal_dates['start'];
            $end_normal=$normal_dates['end'];
        } else{
            $normal_dates=[
                'start'=>DateTime::createFromFormat('d.m.Y', $start),
                'end'=>DateTime::createFromFormat('d.m.Y', $end)
            ];
            $start_normal=$normal_dates['start'];
            $end_normal=$normal_dates['end'];
        }

        $period=new DatePeriod($start_normal, new DateInterval('P1D'), $end_normal->add(new DateInterval('P1D')));

        $result = [];
        foreach ($period as $val)
        {
            $daykey = $val->format('d.m.Y');
            $result[] = $daykey;
        }

        $period_end=end($result);


        $query = "DELETE FROM `#__com_spec_holidays` WHERE `period_start` = '".$start_normal->format('d.m.Y')."' AND `period_end`='$period_end' AND `id_user`='$user_id';";
        $this->db->setQuery($query);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/spec_holidays.html', print_r($query, true), FILE_APPEND | LOCK_EX);
        $this->db->query();
    }

    public function savePosition($start, $end, $user_id, $position_left)
    {
        $query = "UPDATE `#__com_spec_holidays` SET `position_edited`='1', `x_position`='$position_left' WHERE `id_user`='".$user_id."' AND `period_start`='$start' AND `period_end`='$end'";
        $this->db->setQuery($query);
        $this->db->query();
    }

    public function savePeriod($old_period_start, $old_period_end, $start, $end, $user_id, $year)
    {
        /*$query = "UPDATE `#__com_spec_holidays` SET `position_edited`='1',  WHERE `id_user`='".$user_id."' AND `period_start`='$start' AND `period_end`='$end'";
        $this->db->setQuery($query);
        $this->db->query(); */

        $this->removePeriodInScale($old_period_start, $old_period_end, $user_id, 'internal');

        $normal_dates=[
            'start'=>DateTime::createFromFormat('d.m.Y', $start),
            'end'=>DateTime::createFromFormat('d.m.Y', $end)
        ];
        $start_normal=$normal_dates['start']->format('d-m-Y');
        $end_normal=$normal_dates['end']->format('d-m-Y');

        $this->addPeriodToScale($year, $start_normal, $end_normal, $user_id);
    }
}
