<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');

/**
 * Spec_holiday2 list modelloadEnevts
 */
class Spec_holiday2ModelTthtml5 extends JModelList {
    public static $db_static;
    public static $user_static;
    
    /**
     * Constructor
     *
     * @param    array          An optional associative array of configuration settings
     *
     * @see      JController
     * @since    1.6
     */
    public function __construct($config = array()) {
        if (empty($config['filter_fields'])) {
            $config['filter_fields'] = array(
                'id', 'a.id',
                'created_by', 'a.created_by',
                'state', 'a.state',
                'ordering', 'a.ordering',
            );
        }
        $this->db = &JFactory::getDBO();
        
        self::$db_static = &JFactory::getDBO();
        self::$user_static = & JFactory::getUser();
        
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        
        $this->server_key = 'AAAA8uprK_U:APA91bHVkdWyzApYugBARq2jFS1iZojYPLmFelemNPqU7LzuACC_Ja0Sg9ilI1VVsoIUcvSVNG8WLHZCz69oVaCVVbwoEbbnTcx60WCuGbO66q-9uSZRJPNpKiv_1I4BYTUsarWaFhP_';
        $this->firebase_url = 'https://fcm.googleapis.com/fcm/send';
        $this->users_table = '#__users';
        $this->table_shifts = '#__com_shifts_reservations';
        
        parent::__construct($config);
    }

    /**
     * Method to auto-populate the model state
     *
     * Note. Calling getState in this method will result in recursion
     *
     * @param   string  $ordering   An optional ordering field
     * @param   string  $direction  An optional direction (asc|desc)
     *
     * @return  void
     *
     * @since   1.6
     */
    protected function populateState($ordering = null, $direction = null) {
        $app = JFactory::getApplication();
        $input = $app->input;

        $search = $this->getUserStateFromRequest($this->context . '.filter.search', 'filter_search');
        $this->setState('filter.search', $search);

        // Load the list state
        $this->setState('list.start', $input->get('limitstart', 0, 'uint'));
        $this->setState('list.limit', $input->get('limit', $app->get('list_limit', 20), 'uint'));

        // List state information
        parent::populateState($ordering, $direction);
    }

    /**
     * Build an SQL query to load the list data
     *
     * @return    JDatabaseQuery
     * @since    1.6
     */
    protected function getListQuery() {
        $query = $this->_db->getQuery(true);

        $query->select('a.id, a.state, a.ordering');

        $query->from('`#__spec_holiday_views` AS a');

        $query->select('b.name as created_by');
        $query->leftJoin($this->_db->qn('#__users') . ' AS b ON b.id = a.created_by');

        $query->where('a.state = 1');

        // Search for this word
        $searchWord = $this->getState('filter.search');

        // Search in these columns
        $searchColumns = array(
            'b.name',
        );

        if (!empty($searchWord)) {
            if (stripos($searchWord, 'id:') === 0) {
                // Build the ID search
                $idPart = (int) substr($searchWord, 3);
                $query->where($this->_db->qn('a.id') . ' = ' . $this->_db->q($idPart));
            } else {
                $query = Spec_holidayHelpersFrontend::buildSearchQuery($searchWord, $searchColumns, $query);
            }
        }

        // Add the list ordering clause
        $orderCol = $this->state->get('list.ordering');
        $orderDirn = $this->state->get('list.direction');

        if ($orderCol && $orderDirn) {
            $query->order($this->_db->escape($orderCol . ' ' . $orderDirn));
        } else {
            $query->order('a.ordering');
        }

        return $query;
    }

    /** Method to get an array of data items
     *
     * @return  mixed An array of data on success, false on failure.
     */
    public function getItems() {
        $items = parent::getItems();

        include_once JPATH_COMPONENT_ADMINISTRATOR . '/helpers/form/view.php';

        $form = new FormViewSpec_holiday;

        $fieldOptions = $form->getFieldOptions();

        foreach ($items as $i => $item) {
            foreach ($item as $key => $value) {
                // If this field has options
                if (isset($fieldOptions[$key])) {
                    // Update the item key with the field option
                    $item->{$key} = JText::_($fieldOptions[$key][$value]);
                }
            }

            $items[$i] = $item;
        }

        return $items;
    }


    /****************************************/
    public function getManagerUsersObj($mode, $u_id)
    {
        if ($mode != 'api_html') {
            $owner_id = $this->user->owner_id;
        } else {
            $user = JFactory::getUser($u_id);
            $owner_id = $user->owner_id;
        }
        $db = & JFactory::getDBO();

        if(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        } else{
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
            $db->setQuery($query);
            $data = $db->loadObjectList();
        }



        return $data;
    }

    public function movePeriod()
    {
        $overlaps = $this->checkPeriod();
        $response = new stdClass();
        
        if ($overlaps) {
            
            $response->result = 'Error';
            $response->message = 'This reservation overlaps with an existing reservation.';
            $response->type='error';
        } else{
            $start=$this->db->escape(trim($_POST['newStart']));
            $end=$this->db->escape(trim($_POST['newEnd']));
            $id = (int)$_POST['id'];
            $resourse=$this->db->escape(trim($_POST['newResource']));
             $old_shift_data = $this->getShiftForInternalUse($id);
            //$user_id = $this->app->input->getString('room_id');
            //echo '$user_id:'.$user_id;
            
            /*$stmt = $db->prepare("UPDATE #__com_shifts_reservations SET start = :start, end = :end, room_id = :resource WHERE id = :id");
            $stmt->bindParam(':id', $_POST['id']);
            $stmt->bindParam(':start', $_POST['newStart']);
            $stmt->bindParam(':end', $_POST['newEnd']);
            $stmt->bindParam(':resource', $_POST['newResource']);
            $stmt->execute();


            $response = new Result();
            $response->result = 'OK';
            $response->message = 'Update successful';*/ 
            
            $item = new stdClass();
            $item->id = $id;
            $item->start = $start;
            $item->end = $end;
            $item->room_id=$resourse;
            
            if($this->db->updateObject('#__com_shifts_reservations', $item, 'id')){
                $response->result = 'OK';
                $response->message = 'Update successful';
                $response->type='success';
                
               
                $user_id = $old_shift_data->room_id;
                
                /*echo '<pre>$old_shift_data:';
                print_r($old_shift_data);
                echo '</pre>';
                
                echo '<pre>new shift:';
                print_r($item);
                echo '</pre>';*/
                
                $this->removeOldMessagesOnThisShift($item, $user_id);
                $this->addMessageInApi($item, $old_shift_data, $this->lang, $user_id, 'move_shift');
            }
        }
        
        return (array)$response;
    }
    
    private function checkPeriod()
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($data, true), FILE_APPEND | LOCK_EX);    
        //old code
        /*$stmt = $db->prepare("SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= :start) OR (start >= :end)) AND id <> :id AND room_id = :resource");
        $stmt->bindParam(':start', $_POST['newStart']);
        $stmt->bindParam(':end', $_POST['newEnd']);
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':resource', $_POST['newResource']);
        $stmt->execute();
        $overlaps = $stmt->rowCount() > 0;*/
        
        $start=$this->db->escape(trim($_POST['newStart']));
        $end=$this->db->escape(trim($_POST['newEnd']));
        $id=(int)$_POST['id'];
        $resourse=$this->db->escape(trim($_POST['newResource']));
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND id <> '".$id."' AND room_id = '".$resourse."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        if(count($data)>0){
            $overlaps=true;
        }
        return $overlaps;
        
    }
    
    public function resizePeriod()
    {
        /*$stmt = $db->prepare("UPDATE #__com_shifts_reservations SET start = :start, end = :end WHERE id = :id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->bindParam(':start', $_POST['newStart']);
        $stmt->bindParam(':end', $_POST['newEnd']);
        $stmt->execute();


        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Update successful';

        header('Content-Type: application/json');
        echo json_encode($response);*/
        /*echo '<pre>';
        print_r($_POST);
        echo '</pre>';*/
        
        $id = (int)$_POST['id'];
      
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `id` = '".$id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        $response = new stdClass();
        $start_request = $this->db->escape(trim($_POST['newStart']));
        $end_request = $this->db->escape(trim($_POST['newEnd']));
        $start_request_arr = explode('T', $start_request);
        $end_request_arr = explode('T', $end_request);
        /*echo '<pre>$start_request_arr:';
        print_r($start_request_arr);
        echo '</pre>';*/
        
        $start = $data->start;
        $start_db_arr = explode(' ', $start);
        
        $end = $data->end;
        $end_db_arr = explode(' ', $end);
        
        $final_start = $start_request_arr[0].' '.$start_db_arr[1];
        $final_end = $end_request_arr[0].' '.$end_db_arr[1];
        //echo '$final_end:'.$final_end;
        //exit;
        
        $item = new stdClass();
        $item->id = $id;
        $item->start = $final_start;
        $item->end = $final_end;
  
        if($this->db->updateObject('#__com_shifts_reservations', $item, 'id')){
            $response->result = 'OK';
            $response->message = 'Resize successful';
            $response->type = 'success';
            
            //$old_shift_data = $this->getShiftForInternalUse($id); 
            $user_id = $data->room_id;
            
            /*echo '<pre>old data:';
            print_r($data);
            echo '</pre>';
            
            echo '<pre>new data:';
            print_r($item);
            echo '</pre>';
            
            echo '<pre>';
            print_r($user_id);
            echo '</pre>';*/
            $this->removeOldMessagesOnThisShift($item, $user_id);
            $this->addMessageInApi($item, $data, $this->lang, $user_id, 'resize_period');
            
            //get user id in #__com_shifts_reservations table(room_id field)
            //$user_id=$this->getUserByReservation($item->id);
            
            //add colors to Calendar page. See this screen http://prntscr.com/pkghey
            //$this->setCalendarDate($item->start, $item->end, $user_id, 'resize');
        }
        return (array)$response;
    }
    
    public function deletePeriod()
    {
        /*$stmt = $db->prepare("DELETE FROM #__com_shifts_reservations WHERE id = :id");
        $stmt->bindParam(':id', $_POST['id']);
        $stmt->execute();

        class Result {}

        $response = new Result();
        $response->result = 'OK';
        $response->message = 'Delete successful';

        header('Content-Type: application/json');
        echo json_encode($response);*/
        
        $response = new stdClass();
        $id=(int)$_POST['id'];
        
        /*$query = $this->db->getQuery(true)
            ->delete($this->db->quoteName('#__com_shifts_reservations'))
            ->where($this->db->quoteName('id') . ' = ' . $id);*/
        $old_shift_data = $this->getShiftForInternalUse($id);
        
        $query = "DELETE FROM #__com_shifts_reservations WHERE `id` = '$id';";
        $this->db->setQuery($query);
        //$this->db->query();
        
        //if($this->db->setQuery($query)){
        if($this->db->query()){
            $response->result = 'OK';
            $response->message = 'Delete successful';
            $response->type='success';
            
            //$this->deleteApiMessages($id);
            $this->removeOldMessagesOnThisShift($old_shift_data, $old_shift_data->room_id);
            $this->addMessageInApiAboutDelete($old_shift_data, $old_shift_data->room_id);
        }
        return (array)$response;
    }
    
    public function loadEnevts()
    {
        $start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        $end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];
        
        $availableUsers  =  array(-1);
        $rms  = $this->loadRooms();
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE room_id in (".join(",",$availableUsers).") AND   NOT ((end <= '".$start."') OR (start >= '".$end."'))";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            //$e->text = $row['name'];
            $e->text = '';
            $e->start = $row['start'];
            $e->end= $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date   = json_decode($row['icon_date'],true);
            $e->tasks_ids = $row['tasks_ids'];
            $e->standart_tasks_ids = $row['standart_tasks_ids'];
            $e->message_time = $row['message_time'];
            $e->message_date = $row['message_date'];
            
            if(empty($e->icon_date))
                $e->icon_date  =  array();
            
            $days  = array();
            $start  =   strtotime(date("Y-m-d 00:00:00", strtotime($e->start)));
            $end    =   strtotime(date("Y-m-d 00:00:00", strtotime($e->end)));
            $day    =   $start;
            if($start <= $end) {
                
                for(;$day <= $end;) {
                
                    $cd =   date("Y-m-d",$day);
                    $days[$cd] = 0;
                    foreach ($e->icon_date as $dateKey=>$di) {
                        if($di['date'] == $cd) {
                            $days[$cd]  =   array('id'=>$e->id,"date"=>$dateKey,'isodate'=>$cd); 
                        }
                    }
                    $day  = strtotime("+1 day",$day);
                    if($day > $end)
                        break;
                    }
            }
            $e->days   =   $days;
            $events[] = $e;
        }
        
       
        return $events;
    }
    
    public function loadRooms()
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id = $this->user->owner_id;
       //$visible_manager = $_REQUEST['vmngr'];
       
        $visible_manager = false;
        if(in_array(6, $this->user->groups) || in_array(10, $this->user->groups)){
            if($visible_manager == true){
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
            } else{
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id`!='".$this->user->owner_id."' ORDER BY `username0` ASC";
            }
            
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } elseif(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."' AND `is_hide`='0'";
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        }
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username=$room['username0']; } 
            elseif(!empty($room['username'])){ $final_username=$room['username']; }
            elseif(!empty($room['name'])){ $final_username=$room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($result, true), FILE_APPEND | LOCK_EX);

        return $result;

    }
    
    public static function loadRoomsStatic()
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id = self::$user_static->owner_id;
        
        if(in_array(6, self::$user_static->groups)){
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0'";
            self::$db_static->setQuery($query);
            $rooms = self::$db_static->loadAssocList();
        } elseif(in_array(2, self::$user_static->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".self::$user_static->id."' AND `is_hide`='0'";
            self::$db_static->setQuery($query);
            $rooms = self::$db_static->loadAssocList();
        }
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username=$room['username0']; } 
            elseif(!empty($room['username'])){ $final_username=$room['username']; }
            elseif(!empty($room['name'])){ $final_username=$room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $result[] = $r;
        }
        

        return $result;

    }
    
    public function addPeriod()
    {
        $start = $this->db->escape(trim($_POST['start']));
        $end = $this->db->escape(trim($_POST['end']));
        
        $start_obj = DateTime::createFromFormat('Y-m-d H:i', $start);
        $end_obj = DateTime::createFromFormat('Y-m-d H:i', $end);
        if($end_obj < $start_obj){
            $end = $end_obj->modify('+1day')->format('Y-m-d H:i');
        }
        
        $name = $this->db->escape(trim($_POST['name']));
        $room = (int) $_POST['room'];

        $item = new stdClass();
        $response = new stdClass();

        $item->id = null;
        $item->name = $name;
        $item->start = $start;
        $item->end = $end;
        $item->room_id = $room;

        if (in_array(2, $this->user->groups)) {
            $item->status = 'api_suggested';
        } elseif (in_array(6, $this->user->groups) || in_array(10, $this->user->groups)) {
            $item->status = 'New';
        }

        $item->paid = 0;
        $item->shift_color = $this->db->escape($this->app->input->getString('shift_color'));
        $item->shift_name = $this->db->escape($this->app->input->getString('shift_name'));

        //return $item;

        if ($this->db->insertObject('#__com_shifts_reservations', $item)) {
            $response->result = 'OK';

            $insert_id = $this->db->insertid();
            $response->message = 'Created with id: ' . $insert_id;
            $response->id = $insert_id;
            $response->type = 'success';

            //get user id in #__com_shifts_reservations table(room_id field)
            //$user_id=$this->getUserByReservation($item->id);
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($user_id, true), FILE_APPEND | LOCK_EX);

            $user_id = $room;
            //add colors to Calendar page. See this screen http://prntscr.com/pkghey
            //$this->setCalendarDate($item->start, $item->end, $user_id, 'add');
        }
        return (array) $response;
    }
    
    private function getShiftForInternalUse($id)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `id` = '".(int)$id."'";
        $this->db->setQuery($query);
        return $this->db->loadObject();
    }
    
    public function editPeriod()
    {  
        $id = (int)$_POST['id'];
        $start = $this->db->escape(trim($_POST['start']));
        $end = $this->db->escape(trim($_POST['end']));
        $name = $this->db->escape(trim($_POST['name']));
        $room = (int)$_POST['room'];
        $status = $this->db->escape(trim($_POST['status']));
        $paid = $this->db->escape(trim($_POST['paid']));
        
        $app = JFactory::getApplication();
        $user_id = $app->input->get('room_id');
        
        $item = new stdClass();
        $response = new stdClass();
            
        $old_shift_data = $this->getShiftForInternalUse($id);
        
        $item->id = $id;
        $item->name = $name;
        $item->start = $start;
        $item->end = $end;
       // $item->room_id=$room;
        $request_status = $status;
        
        $lang = trim($this->db->escape($_POST['iframe_lang']));
        if($lang == 'is'){
            if($status == 'Staðfest'){
                $status = 'New';
            } elseif($status == 'Biðstaða'){
                $status = 'api_suggested';
            }
        } else{
            if($status=='Confirmed'){
                $status='New';
            } elseif($status=='Pending'){
                $status='api_suggested';
            }
        }
        
        $item->status = $status;
        $item->paid = $paid;
        $item->shift_color = $this->db->escape($this->app->input->getString('shift_color'));
        
        //$status_in_db = $this->loadHolidayStatus($item->id);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($status_in_db, true), FILE_APPEND | LOCK_EX);
            
        if($this->db->updateObject('#__com_shifts_reservations', $item, 'id')){
            $response->result = 'OK';
            $response->message = 'Update successful';
            $response->type = 'success';
            
            $this->removeOldMessagesOnThisShift($item, $user_id);
            $this->addMessageInApi($item, $old_shift_data, $lang, $user_id, 'edit_shift');
           
            //if($request_status==='Confirmed' && $status_in_db=='api_suggested'){
                //get user id in #__com_shifts_reservations table(room_id field)
                //$user_id=$this->getUserByReservation($item->id);
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($user_id, true), FILE_APPEND | LOCK_EX);
                
                //add colors to Calendar page. See this screen http://prntscr.com/pkghey
                //$this->setCalendarDate($item->start, $item->end, $user_id, 'update');
            //} 
        }
        return (array)$response;
    }

    private function removeOldMessagesOnThisShift($item, $user_id)
    {
        $query = "DELETE FROM #__app_api_messages WHERE `shift_id` = '".$item->id."' AND `user_id`='".$user_id."' AND `message_type`='shifts_changes'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function convertDatesToUnix($date, $type)
    {
        switch($type){
            case '1':
                $date_converted = DateTime::createFromFormat('Y-m-d H:i', $date);
                $date_unix = $date_converted->format('U');
                
                break;
            case '2':
                $date_converted = DateTime::createFromFormat('Y-m-d H:i:s', $date);
                $date_unix = $date_converted->format('U');
                
                break;
            case '3':
                $date_converted = DateTime::createFromFormat('Y-m-d\TH:i:s', $date);
                $date_unix = $date_converted->format('U');
                
                break;
        }
        
        
        return $date_unix;
    }
    
    private function addMessageInApi($data_obj, $old_data_obj, $lang, $user_id, $type)
    {
        $not_permitted_keys = [
            'paid',
            'id',
            'name'
        ];
        /*echo '<pre>$old_data_obj:';
        print_r($old_data_obj);
        echo '</pre>';*/
        
        $difference_arr = new stdClass();
        foreach($data_obj as $k=>$v){
            if(in_array($k, ['start', 'end'])){
                if($type == 'edit_shift'){
                    $formatted_date_new = $this->convertDatesToUnix($v, '1');
                    $formatted_date_old = $this->convertDatesToUnix($old_data_obj->{$k}, '2');
                } elseif($type == 'move_shift'){
                    $formatted_date_new = $this->convertDatesToUnix($v, '3');
                    $formatted_date_old = $this->convertDatesToUnix($old_data_obj->{$k}, '2');
                } elseif($type == 'resize_period'){
                    $formatted_date_new = $this->convertDatesToUnix($v, '2');
                    $formatted_date_old = $this->convertDatesToUnix($old_data_obj->{$k}, '2');
                }
                
                //compare unix timestamps
                if($formatted_date_new != $formatted_date_old){
                    $difference_arr->{$k} = $v; 
                }
            } else{
                if($v != $old_data_obj->{$k}){
                    if(!in_array($k, $not_permitted_keys)){
                        $difference_arr->{$k} = $v;
                    }
                }
            }
        }
        
        /*echo '<pre>$difference_arr:';
        print_r($difference_arr);
        echo '</pre>';
        echo 'count $difference_arr?'.count((array)$difference_arr);*/
        
     if(count((array)$difference_arr)>0) {
            //don't remove this code
            /*$lang_parts_en = [
                'start' => 'date start',
                'end' => 'date end',
                'shift_color' => 'shift color'
            ];
            $lang_parts_is = [
                'start' => 'date start',
                'end' => 'date end',
                'shift_color' => 'shift color'
            ];
            $text_en = 'Hello, your shift has been changed by the manager. Actual information:' . PHP_EOL;
            $text_is = 'Hello, your shift has been changed by the manager. Actual information:' . PHP_EOL;

            foreach ($difference_arr as $different_item_k => $different_item_v) {
                $text_en .= $lang_parts_en[$different_item_k] . ' = ' . $different_item_v . PHP_EOL;
                $text_is .= $lang_parts_is[$different_item_k] . ' = ' . $different_item_v . PHP_EOL;
            }*/
            //end don't remove this code
         
            //new message text
            $text_en = 'Your Schedules from '.$old_data_obj->start.' - '.$old_data_obj->end.' has been changed';
            $text_is = 'Vaktaplan þitt '.$old_data_obj->start.' - '.$old_data_obj->end.' hefur breyst';
            
            $item = new stdClass();
            $item->id = null;
            $item->user_id = (int) $user_id;
            $item->text_en = $this->db->escape($text_en);
            $item->text_is = $this->db->escape($text_is);
            $item->is_read = 0;
            $item->timestamp = time();
            $item->date_create = date('d.m.y H:i:s');
            $item->shift_id = $data_obj->id;
            $item->status = 0;
            $item->message_type = 'shifts_changes';
            $item->subject_en = $this->db->escape('Your schedules has changed');
            $item->subject_is = $this->db->escape('Vaktaplan hefur breyst');
            $item->about_changes = 1;
            
            $this->db->insertObject('#__app_api_messages', $item);
        }
    }
    
    private function loadHolidayStatus($id)
    {
        $query = "SELECT `status` FROM #__com_shifts_reservations WHERE `id` = '$id'";
        $this->db->setQuery($query);
        return $this->db->loadResult();
    }
    
    private function getUserByReservation($row_id)
    {
        $query = "SELECT `room_id` FROM #__com_shifts_reservations WHERE `id` = '$row_id'";
        $this->db->setQuery($query);
        $user_id = $this->db->loadResult();
        
        return $user_id; 
    }
    
    private function setCalendarDate($start, $stop, $user_id, $func_mode)
    {
        $date_start=$start;
        $date_end=$stop;
        
        //color code in calendar
        $new_status=6; 
        
        //include weekend. set 1 if need write in all days
        $weekend_status=1;
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
       
        $result= $this->addReportItems($user_id, $date_start, $date_end, $new_status, $weekend_status, $func_mode);
       //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($result, true), FILE_APPEND | LOCK_EX);
        return $result;
    }

    private function checkReportItemStatus($user_id, $date_year, $date_month, $date_day)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'"  AND `year`="'.$date_year.'" AND `month`="'.$date_month.'" AND `day`="'.$date_day.'"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        return $user_report->status;
    }
    
    private function reverseConvertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        //$from_date = $from_date_raw->format('d.m.Y');
        $from_date = $from_date_raw->format('U');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        //$to_date = $to_date_raw->format('d.m.Y');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    private function addReportItems($user_id, $date_start, $date_end, $new_status, $weekend_status, $func_mode)
    {
        //convert dates to linux timestump format
        if($func_mode==='update'){
            $dates=$this->reverseConvertDates($date_start, $date_end);
        } elseif($func_mode==='add'){
            $dates=$this->convertDates($date_start, $date_end);
        } elseif($func_mode==='resize'){
            $dates=$this->convertDatesCI($date_start, $date_end);
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($dates, true), FILE_APPEND | LOCK_EX);

        $year_start=date('Y', $dates['start']);
        $month_start=date('n', $dates['start']);
        $day_start=date('j', $dates['start']);
        
        
        $date_end = date('d-m-Y', strtotime(date('Y-m-d', $dates['end']).' +1day'));
        
        $from = DateTime::createFromFormat('U', $dates['start']);
        $to   =  DateTime::createFromFormat('U', $dates['end']);
        
        
        if($func_mode==='add' || $func_mode==='resize'){
           // $different = $from->diff($to)->format('%R%a');
            $to=$to->modify('+1 day');
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($different, true), FILE_APPEND | LOCK_EX);
        }
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
   
        
        $arrayOfDates = array_map(
            function($item){
                return $item->format('Y.n.j');
            
            },
            iterator_to_array($period)
        );
        $dates_array=[];
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5_1.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);     
       
        
        //exit;
            
        foreach($arrayOfDates as $date){
            if($weekend_status=='1'){//include weekends
                $date_explode=explode('.', $date);
                $year=$date_explode[0];
                $month=$date_explode[1];
                $day=$date_explode[2];
            
                $dates_array[]['status']=$this->checkReportItemStatus($user_id, $year, $month, $day);
                $dates_array[]['day']=$day;
                $dates_array[]['month']=$month;
                $dates_array[]['year']=$year;
                $dates_array[]['typeof']=gettype( $date);
            
                $old_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
                if(!empty($old_item_status)){
                    $this->updateReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'update item status';           
                } else{            
                    $this->insertReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'add new report item';
                }
            } 
        }
        return json_encode($dates_array);
    }
    
    private function insertReportItem($user_id, $status_user, $year, $month, $day)
    {    
        $query = "INSERT INTO #__user_report_items (id_user, status, year, month, day) VALUES ('".$user_id."', '".$status_user."', '".$year."', '".$month."', '".$day."')";    
        $this->db->setQuery($query);	 
        $this->db->query(); 
    }
    
    private function updateReportItem($user_id, $status_user, $year, $month, $day)
    {
        $query = "UPDATE #__user_report_items SET `status`='".$status_user."' WHERE `id_user`='".$user_id."' AND `month`='".$month."' AND `year`='".$year."' AND `day`='".$day."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function convertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d', $from);
        //$from_date = $from_date_raw->format('Y-m-d 00:00:00');
        $from_date = $from_date_raw->format('U');

        $to_date_raw = DateTime::createFromFormat('Y-m-d', $to);
        //$to_date = $to_date_raw->format('Y-m-d 00:00:00');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    public function convertDatesCI($from, $to)
    {
        $from_explode=explode('T', $from);
        $from_date_raw = DateTime::createFromFormat('Y-m-d', $from_explode[0]);
        //$from_date = $from_date_raw->format('Y-m-d 00:00:00');
        $from_date = $from_date_raw->format('U');
        
        $to_explode=explode('T', $to);
        $to_date_raw = DateTime::createFromFormat('Y-m-d', $to_explode[0]);
        //$to_date = $to_date_raw->format('Y-m-d 00:00:00');
        $to_date = $to_date_raw->format('U');
        
        return [
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    public function checkPermission($type, $individual_params)
    {
        $res='0';

        switch($type){
           
            case 'update_shift_header':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'cloneUserShifts':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                $user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id && $user_id_for_clone_obj->owner_id == $owner_id)){
                    $res = '1';
                } 
            break;
            case 'getСircles':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                /*$user_id_from_request = $individual_params['user_from_request'];
                $user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                $user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);*/
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id && $user_id_for_clone_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'approveShift':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 

                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }  
            break;
            
            case 'separateShift':
                $user   = $individual_params['user_obj'];
                $id     = intval($individual_params['id']);
                $user_joomla = $this->user;
                $query = "SELECT `room_id` FROM #__com_shifts_reservations WHERE `id` = ".intval($id);     
                
                $this->db->setQuery($query);
                $user_id = (int) $this->db->loadResult();                
                
                $user  = JFactory::getUser($user_id);
                if(intval($user_joomla->owner_id) == intval($user->owner_id)) {
                    $res = '1';
                }                  
            break;
            case 'saveState':
               $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                //$user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                //$user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id)){
                    $res = '1';
                } 
            break;
            case 'getMonths':
                $res = '1';
            break;
            case 'cloneMonthData':
                $res = '1';
            break;
            case 'saveUserIcon':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id)){
                    $res = '1';
                } 
            break;
            case 'getUsersIconsUsed':
                $res = '1';
            break;
            case 'saveInput':
                $res = '1';
            break;
            case 'confirmApiMessages':
                $res = '1';
            break;
            case 'getUsersPercents':
                $res = '1';
            break;
            case 'attachSheduleToTask':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id)){
                    $res = '1';
                } 
            break;
            case 'removeScheduleMessage':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id)){
                    $res = '1';
                } 
            break;
            case 'saveAvbState':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'loadAvbsState':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'getUsedIconsListForManager':
                $res = '1';
            break;
            case 'saveAvbSchedule':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'loadAvbSchedules':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'deleteAvbSchedule':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
               
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'cloneWithPeriod':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
               
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
            case 'removeShiftsByColor':
                  $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                               
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
               
        
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 /*&& ($user_from_request_obj->owner_id == $owner_id)*/){
                    $res = '1';
                } 
            break;
        }
        
       return $res;
    }
    
    public function cloneUserShifts($user_id, $user_for_clone, $start, $end)
    {
        $user_shifts = json_decode($this->loadUserEnevtsForClone($user_id, $start, $end));
        /*echo '<pre>$user_shifts';
        print_r($user_shifts);
        echo '</pre>';
        return false;*/
        
        if(!empty($user_shifts)){
            $this->deleteAllUserShifts($user_for_clone, $start, $end);
            
            foreach($user_shifts as $one_shift){
                $this->addPeriodForCloneProcess($user_for_clone, $one_shift);
            }
            return JText::_('COM_SHIFTS_SUCCESS_CLONE_SHIFTS'); 
        } else{
            throw new Exception(JText::_('COM_SHIFTS_ERROR_CLONE_EMPTY_USERS_SHIFTS'));
        }
      
    }
    
    private function deleteAllUserShifts($user_for_clone, $start, $end)
    {
        if($user_for_clone == 0){
            return false;
        }
        $query = "DELETE FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND `room_id` = '$user_for_clone'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function loadUserEnevts($user_id, $start, $end)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND `room_id` = '$user_id' AND `status` != 'pending_available' AND `shift_color`!='transparent'";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $events[] = $e;
        }
        
       
        return json_encode($events);
    }
    
    private function loadUserEnevtsForClone($user_id, $start, $end)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND `room_id` = '$user_id'";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        //echo $query;
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date = $row['icon_date'];
            
            $events[] = $e;
        }
        
       
        return json_encode($events);
    }
    
    private function addPeriodForCloneProcess($user_for_clone, $one_shift)
    {
        $start = $this->db->escape(trim($one_shift->start));
        $end = $this->db->escape(trim($one_shift->end));
        $name = $this->db->escape(trim($one_shift->text));
        $room = (int)$user_for_clone;
        
        $item = new stdClass();
        $response = new stdClass();
            
        $item->id = null;
        $item->name = $name;
        $item->start = $start;
        $item->end = $end;
        $item->room_id = $room;
        
        if(in_array(2, $this->user->groups)){
            $item->status = 'api_suggested';
        } elseif(in_array(6, $this->user->groups)){
            $item->status = $one_shift->status;
        }
       
        $item->paid=0;
        //$item->shift_color = $this->db->escape($this->app->input->getString('shift_color'));
        //$item->shift_name = $this->db->escape($this->app->input->getString('shift_name'));
        
        $item->shift_color = $one_shift->shift_color;
        $item->shift_name = $one_shift->shift_name;
        $item->shift_message = $this->db->escape($one_shift->shift_message);
        $item->icon_date = $one_shift->icon_date;
        
        if($this->db->insertObject('#__com_shifts_reservations', $item)){
            $response->result = 'OK';
            
            $insert_id=$this->db->insertid();
            $response->message = 'Created with id: '.$insert_id;
            $response->id = $insert_id;
            $response->type='success';
        }
        
        return (array)$response;
    }
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    public function getAllColors($user_id, $start, $end,$unique  =  false) 
    {
        $rooms = json_decode(ShiftsController::loadRoomsStatic());
        $all_shifts = $this->loadEnevts1($start, $end);
        
       
        
        
        if(!empty($rooms)){  
            $final_html = '';
            
            foreach($rooms as $one_user){
                $user_shifts = json_decode($this->loadUserEnevts($one_user->id, $start, $end));
                $i = 0;
                //
                foreach($user_shifts as $one_shift){
                    
                    $colors_arr[$one_user->id][$i] = $one_shift->shift_color;
                    $starts_arr[$one_user->id][$i] = $one_shift->start;
                    $ends_arr[$one_user->id][$i] = $one_shift->end;
                    
                    $i++;
                } 
            }
  
            $index = 0;
            $allShifts = array();
            
            foreach($rooms as $one_user) {
                $user_shifts = json_decode($this->loadUserEnevts($one_user->id, $start, $end));
                //$result = array_unique((array)$user_shifts);
                $user_shifts_to_array = (array)$user_shifts;
                
                
                
                foreach($user_shifts as $one_shift){ 
                    
                    $start_raw = $one_shift->start; 
                    $stop_raw = $one_shift->end; 
                    //echo '$one_shift->start:'.$one_shift->start.PHP_EOL;
                    //echo '$one_shift->end:'.$one_shift->end.PHP_EOL;
            
                    $start_final = $this->normalizeShiftFormat($start_raw);
                    $stop_final = $this->normalizeShiftFormat($stop_raw);
                    
                    $final_hours_string = $start_final.'-'.$stop_final;
                    
                   
                    
                    if(!in_array((array)$one_shift->start, (array)$all_shifts) /*&& !in_array($one_shift->end, (array)$user_shifts)*/ /*&& !in_array($one_shift->shift_color, $colors_arr)*/){
                        $key  =  trim($one_shift->shift_color.$final_hours_string);
                        if(!$unique)
                            $key  = $index++;
                        
                        $datetime_arr_start = explode(' ', $one_shift->start);
                        $datetime_arr_end = explode(' ', $one_shift->end);
                        
                        $allShifts[$key]    =   '<div class="one_c_wrapper swiper-slide"><div onclick="callPopup(this);" data-shift-color="'.$one_shift->shift_color.'" data-start="'.$one_shift->start.'" data-end="'.$one_shift->end.'" data-shift-name="'.$one_shift->shift_name.'" class="circle-item" title="'.JText::_('COM_SHIFTS_NEW_SHIFT_NAME').': '.$datetime_arr_start[1].'-'.$datetime_arr_end[1].'" style="background: '.$one_shift->shift_color.'"></div><span>'.$final_hours_string.'</span></div>';
                        $final_html .= '<div class="one_c_wrapper swiper-slide"><div onclick="callPopup(this);" data-shift-color="'.$one_shift->shift_color.'" data-start="'.$one_shift->start.'" data-end="'.$one_shift->end.'" data-shift-name="'.$one_shift->shift_name.'" class="circle-item" title="'.JText::_('COM_SHIFTS_NEW_SHIFT_NAME').': '.$datetime_arr_start[1].'-'.$datetime_arr_end[1].'" style="background: '.$one_shift->shift_color.'"></div><span>'.$final_hours_string.'</span></div>';
                        
                    }
                }
                
                
                if(count($allShifts) > 0) {
                    $final_html  = "";                    
                    foreach ($allShifts as $key=>$one_shift_html) {
                        $final_html .= '<!-- '.$key.' --> '.$one_shift_html;
                    }
                }
                
                
                if(0) {
                    echo "<pre>";
                    var_dump($allShifts);
                    exit;
                }
                
            }
            
            
           
            return $final_html;    
        } 
    }
    
    public function loadEnevts1($start, $end)
    {
        //$start = isset($_POST['start']) ? $_POST['start'] : $_GET['start'];
        //$end = isset($_POST['end']) ? $_POST['end'] : $_GET['end'];
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND `status` != 'pending_available' AND `shift_color`!='transparent'";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $events[] = $e;

    
        }
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($events, true), FILE_APPEND | LOCK_EX);
        return $events;
    }
    
    public function getAllColorsOld($user_id, $start, $end) 
    {
       $rooms = json_decode(ShiftsController::loadRoomsStatic());

        if(!empty( $rooms)){  
            $final_html = '';
            
            foreach($rooms as $one_user){
                $user_shifts = json_decode($this->loadUserEnevts($one_user->id, $start, $end));
                $i = 0;
                //
                foreach($user_shifts as $one_shift){
                    
                    $colors_arr[$one_user->id][$i] = $one_shift->shift_color;
                    $starts_arr[$one_user->id][$i] = $one_shift->start;
                    $ends_arr[$one_user->id][$i] = $one_shift->end;
                    
                    $i++;
                } 
            }
            
            /*echo '<pre>$starts_ar:';
            print_r($starts_arr);
            echo '</pre>'; 
            
            echo '<pre>$ends_arr:';
            print_r($ends_arr);
            echo '</pre>'; 
            
            echo '<pre>$colors_arr:'; 
            print_r($colors_arr);
            echo '</pre>';*/
           
            foreach($rooms as $one_user){
                $user_shifts = json_decode($this->loadUserEnevts($one_user->id, $start, $end));
                //$result = array_unique((array)$user_shifts);
                $user_shifts_to_array = (array)$user_shifts;
                
                //$result = $this->superUnique($user_shifts_to_array, 'shift_color');
                //$result_to_obj = (object)$result;
                
                foreach($user_shifts as $one_shift){ 
                    echo '<pre>';
                    print_r($one_shift);
                    echo '</pre>';
                    
                    
                    $start_raw = $one_shift->start; 
                    $stop_raw = $one_shift->end; 
                    
                    $start_final = $this->normalizeShiftFormat($start_raw);
                    $stop_final = $this->normalizeShiftFormat($stop_raw);
                    
                    $final_hours_string = $start_final.'-'.$stop_final;
                    
                   
                    //if(!in_array($one_shift->start, $starts_arr) && !in_array($one_shift->end, $ends_arr) /*&& !in_array($one_shift->shift_color, $colors_arr)*/){
                        $final_html .= '<div class="one_c_wrapper swiper-slide"><div class="circle-item" title="'.$one_shift->shift_name.': '.$one_shift->start.'-'.$one_shift->end.'" style="background: '.$one_shift->shift_color.'"></div><span>'.$final_hours_string.'</span></div>';
                   // }
                }      
                
                
            }
           
            return $final_html;    
        } 
    }
    
    private function normalizeShiftFormat($raw_hours)
    {
        $start_hours_arr = explode(' ', $raw_hours);
        $start_final_arr = explode(':', $start_hours_arr[1]);
        $start_final = $start_final_arr[0].':'.$start_final_arr[1];
        
        return $start_final;
    }
    
    private function loadAllUsersShifts($user_id, $start, $end)
    {
        $query = "SELECT * FROM #__com_shifts_reservations WHERE NOT ((end <= '".$start."') OR (start >= '".$end."')) AND `room_id` = '$user_id'";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        $events = array();

        date_default_timezone_set("UTC");
        $now = new DateTime("now");
        $today = $now->setTime(0, 0, 0);
        
        foreach($result as $row) {
            $e = new stdClass();
            $e->id = $row['id'];
            $e->text = $row['name'];
            $e->start = $row['start'];
            $e->end = $row['end'];
            $e->resource = $row['room_id'];
            $e->bubbleHtml = '';//"Reservation details: <br/>".$e->text;
    
            // additional properties
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $events[] = $e;
        }
        
       
        return json_encode($events);
    }
    
    public function editComShiftsHeader($shift_header, $input_id)
    {
        /*$query = "UPDATE #__com_shifts_reservations SET `status`='".$status_user."' WHERE `id_user`='".$user_id."' AND `month`='".$month."' AND `year`='".$year."' AND `day`='".$day."'";
        $this->db->setQuery($query);
        $this->db->query();*/

        $item = new stdClass();
        $item->shift_name = $this->db->escape($shift_header);
        $item->id = (int)$input_id;
        
        $this->db->updateObject('#__com_shifts_reservations', $item, 'id');
        
        return $item->shift_name;
    }
    
    public function cssClassToHexConnector($class)
    {
        if(empty($class)){
            exit;
            
        }
        
        $connectors_arr = [
            'circle-1' => '#009cdd',
            'circle-2' => '#8bc2ae',
            'circle-3' => '#ffca00',
            'circle-4' => '#77c0d2',
            'circle-5' => '#d3277c',
            'circle-6' => '#9b9b9a', 
            'circle-7' => '#f39524',
        ];
        
        return $connectors_arr[$class]; 
    }
    
    public function approveShift($user_id, $shift_id)
    {
        $query = "UPDATE #__com_shifts_reservations SET `shift_color`='#8bc2ae', `status`='New' WHERE `room_id`='".$user_id."' AND `id`='$shift_id'";
        $this->db->setQuery($query);
        if($this->db->query()){
            return JText::_('COM_SHIFTS_SUCCESS_APPROVE_SHIFTS'); 
        }
    }
    
    public function separateShift($id,$date) {
        $user = $individual_params['user_obj'];
        $user_joomla = $this->user;
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `id` = ". intval($id);
        $this->db->setQuery($query);
        $event = $this->db->loadObject();
        if(empty($event)) {
            JText::_('COM_SHIFTS_NOT_FOUNT');
        }
        $arr = array();
        $startTime  = date("H:i:s",strtotime($event->start));
        $endTime    = date("H:i:s",strtotime($event->end));
        
        $startDate  = strtotime(date("Y-m-d", strtotime($event->start)));
        $iDate      = strtotime(date("Y-m-d", strtotime($event->start)));
        $day        = strtotime(date("Y-m-d", strtotime($date)));
        $dayf       = date("d.m.Y", strtotime($date));
        $endDate    = strtotime(date("Y-m-d", strtotime($event->end)));
        
        $icon_date  = json_decode($event->icon_date,true);
        if(empty($icon_date))
            $icon_date  =  array();
        
        if(isset($icon_date[$dayf])) {
            unset($icon_date[$dayf]);
            $index  = 0;
            if($startDate <= $endDate) {
                for(;$iDate <= $endDate;) {                
                    if(!isset($arr[$index]))
                        $arr[$index] =  array("start"=>$startDate,"end"=>$endDate,"status"=>"pending_work","icon_date"=>array(),'shift_color'=>$event->shift_color);

                    $iDateF =   date("d.m.Y",$iDate);
                    if(isset($icon_date[$iDateF])) {
                        $arr[$index]['icon_date'][$iDateF] = $icon_date[$iDateF];
                    }

                    if($day == $iDate) {
                        if($startDate < $iDate) {
                            $arr[$index]["end"] = strtotime("-1 day",$iDate);
                            $index ++;
                        }                    
                        $arr[$index] =  array("start"=>$day,"end"=>$day,"status"=>"pending_available","icon_date"=>array(),'shift_color'=>"transparent");
                        $iDate = strtotime("+1 day",$iDate);
                        $startDate  =   $iDate;
                        $index ++;
                        continue;
                    }
                    $iDate = strtotime("+1 day",$iDate);
                }
                $index  =  0;


                if(count($arr)) {

                    /*
                    foreach ($arr as $k=>$v) {
                        $arr[$k]['start'] =  date("Y-m-d",$v['start']);
                        $arr[$k]['end'] =    date("Y-m-d",$v['end']);                    
                    }
                    */

                    foreach ($arr as $index=>$t) {
                        $event->start       =  date("Y-m-d ".$startTime,$t['start']);
                        $event->end         =  date("Y-m-d ".$endTime,$t['end']);
                        
                        if($t['status'] == "pending_available") {
                            $event->start       =  date("Y-m-d H:i:s",$t['start']);
                            $event->end         =  date("Y-m-d H:i:s",$t['end']);
                        }
                        
                        
                        $event->status      =  $t['status'];
                        $event->shift_color =  $t['shift_color'];
                        $event->icon_date= json_encode($t['icon_date']);
                        
                        
                        if($index == 0) {
                            $this->db->updateObject('#__com_shifts_reservations',$event, 'id');
                        } else {
                            $event->id  =  null;
                            $this->db->insertObject('#__com_shifts_reservations', $event);
                        }
                        
                    }
                }
            }
        }
    }
    
    public function breakTimelineAsDays($id) {
        $user = $individual_params['user_obj'];
        $user_joomla = $this->user;
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `id` = ". intval($id);
        $this->db->setQuery($query);
        $event = $this->db->loadObject();
        if(empty($event)) {
            throw new Exception(JText::_('COM_SHIFTS_NOT_FOUNT'));
        }        
        $days  = array();
        $start  =   strtotime(date("Y-m-d 00:00:00", strtotime($event->start)));
        $end    =   strtotime(date("Y-m-d 00:00:00", strtotime($event->end)));
        $day    =   $start;
        if($start <= $end) {
            for(;$day <= $end;) {

                $cd =   date("Y-m-d",$day);
                $days[$cd] = array('start'=>$cd." ".date("H:i:s",strtotime($event->start)),"end"=>$cd." ".date("H:i:s",strtotime($event->end)));
                $day  = strtotime("+1 day",$day);
                if($day > $end)
                    break;
                }
        }
        $index  = 0;
        foreach ($days as $t) {
            $event->start   =   $t['start'];
            $event->end     =   $t['end'];
            if($index == 0) {
                $this->db->updateObject('#__com_shifts_reservations',$event, 'id');
            } else {
                $event->id  =  null;
                $this->db->insertObject('#__com_shifts_reservations', $event);
            }
            $index ++;
        }
        return $days;
        
    }
    
    public function getMonthName($en_month, $lang)
    {
        if($lang != 'is'){
            return $en_month;
        }
        
        $date_obj = DateTime::createFromFormat('F', $en_month);

        $mount_array=[
            "January" => "Janúar",
            "February" => "Febrúar",
            "March" => "Mars",
            "April" => "Apríl",
            "May" => "Maí",
            "June" => "Júní",
            "July" => "Júlí",
            "August" => "Ágúst",
            "September" => "September",
            "October" => "Október",
            "November" => "Nóvember",
            "December" => "Desember"
        ];
        
        $formatted_date = $date_obj->format("F");
        $currentDate = str_replace($date_obj->format('F'), $mount_array[$date_obj->format('F')], $formatted_date);
        
        return $currentDate;
    }
    
    public function getDayName($en_month, $lang) {
        if ($lang != 'is') {
            return $en_month;
        }

        $date_obj = DateTime::createFromFormat('l', $en_month);

        $mount_array = [
            "Monday" => "Mánudagur",
            "Tuesday" => "Þriðjudagur",
            "Wednesday" => "Miðvikudagur",
            "Thursday" => "Fimmtudagur",
            "Friday" => "Föstudagur",
            "Saturday" => "Laugardagur",
            "Sunday" => "Sunnudagur"
        ];

        $formatted_date = $date_obj->format("l");
        $currentDate = str_replace($date_obj->format('l'), $mount_array[$date_obj->format('l')], $formatted_date);

        return $currentDate;
    }
    
    private function getInputValueById($input_id)
    {
        $arr = [
            'shift_one_month' => 1, 
            'shift_3_month' => 3, 
            'shift_6_month' => 6
        ];
        
        return $arr[$input_id];
    }
    
    public function saveState($input_id, $lang, $manager)
    {
        $db_value = $this->getInputValueById($input_id);
        
        $query = "SELECT * FROM #__com_shifts_filter_state WHERE `id_manager` = '$manager' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        if(count($res)>1){
            throw new Exception(JText::_('COM_SHIFTS_ERROR_IN_DB'));
        } elseif(count($res) == 0){
            $item = new stdClass();
            $item->id = null;
            $item->id_manager = (int)$manager;
            $item->filter_state = $db_value;
            
            $this->db->insertObject('#__com_shifts_filter_state', $item);
        } else{
            $item = new stdClass();
            $item->id = $res[0]->id;
            $item->id_manager = $res[0]->id_manager;
            $item->filter_state = $db_value;
            
            $this->db->updateObject('#__com_shifts_filter_state', $item, 'id');
        }
    }
    
    public function getState($manager, $lang)
    {
        $query = "SELECT * FROM #__com_shifts_filter_state WHERE `id_manager` = '$manager' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $res = $this->db->loadObjectList();
        
        return $res[0];
        
    }
    
    public function getMonths($from_date, $to_date, $lang, $month)
    {
        $from_date= date("Y-m-d\TH:i:s");
        $to_date  = date("Y-m-d\TH:i:s", strtotime("+6 month"));
        $start    = DateTime::createFromFormat('Y-m-d\TH:i:s', $from_date)->modify('first day of this month');
        $end      = DateTime::createFromFormat('Y-m-d\TH:i:s', $to_date)->modify('first day of this month');
        $interval = DateInterval::createFromDateString('1 month');
        $period   = new DatePeriod($start, $interval, $end);
        
        $final = [];
        foreach ($period as $dt) {
            $final[] = $this->getIcelandicMonth($dt->format("F"), $lang).$dt->format(" Y");
        }
        
        return $final;
    }
    
    private function getIcelandicMonth($month, $lang)
    {
        if($lang != 'is'){
           return $month;
        }
        
        $months_array=[
            "January" => "Janúar",
            "February" => "Febrúar",
            "March" => "Mars",
            "April" => "Apríl",
            "May" => "Maí",
            "June" => "Júní",
            "July" => "Júlí",
            "August" => "Ágúst",
            "September" => "September",
            "October" => "Október",
            "November" => "Nóvember",
            "December" => "Desember"
        ];
        
        return $months_array[$month];
    }
    
    
    
    public function cloneMonthData($start, $end, $lang, $normalized_month_parent, $normalized_month_for_copy, $year, $year_for_copy)
    {
        try{
            $current_month_data = $this->getMonthData($normalized_month_parent, $year, $normalized_month_for_copy, $year_for_copy);
            $this->cloneMonth($current_month_data, $normalized_month_for_copy, $year_for_copy);
        } catch (Exception $ex) {

        }
       
        
        return $current_month_data;
    }
    
    private function deleteOldMonthData($normalized_month_for_copy, $availableUsers, $year_for_copy)
    {
        $current_month_raw_obj = DateTime::createFromFormat('F Y', $normalized_month_for_copy.' '.$year_for_copy);
        $current_month_unix_obj = $current_month_raw_obj->modify('first day of this month 00:00');
        $current_month_unix = $current_month_unix_obj->format('U');
        
        $end_of_month_obj = clone $current_month_raw_obj;
        $end_of_month_obj_unix = $end_of_month_obj->modify('last day of this month 23:59');
        $end_of_month_unix = $end_of_month_obj_unix->format('U');
        
        $query = "DELETE FROM #__com_shifts_reservations WHERE `room_id` in (".join(",", $availableUsers).") AND UNIX_TIMESTAMP(start) >= '$current_month_unix' AND UNIX_TIMESTAMP(end) <= '$end_of_month_unix'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function cloneMonth($current_month_data, $normalized_month_for_copy, $year_for_copy)
    {
        if(!empty($current_month_data)){
           // $this->deleteOldMonthData($normalized_month_for_copy, $year_for_copy);
            
            foreach ($current_month_data as $one_row) {
                $item = new stdClass();

                foreach ($one_row as $k => $v) {
                    if (!in_array($k, ['id', 'start', 'end', 'icon_date'])) {
                        if($k == 'status' && $v == 'pending_available'){
                            continue 2;
                        }
                        $item->$k = $v;
                    } else{
                        switch($k){
                            case 'start':
                            case 'end':
                                $month_for_copy_obj = DateTime::createFromFormat('F Y', $normalized_month_for_copy.' '.$year_for_copy);
                                
                                $start_original = $v;
                                $start_original_arr = explode(' ', $start_original);
                                
                                $original_start_time = $start_original_arr[1];
                                $original_start_date = $start_original_arr[0];
                                $original_start_date_arr = explode('-', $original_start_date);
                                $start_modify = $month_for_copy_obj->format('Y-m-').$original_start_date_arr[2].' '.$original_start_time;
                                
                                $item->$k = $start_modify;
                            break;
                            case 'icon_date':
                                /*$month_for_copy_obj = DateTime::createFromFormat('F Y', $normalized_month_for_copy.' '.$year_for_copy);
                                
                                $start_original = $v;
                                $start_original_arr = explode(' ', $start_original);
                                
                                $original_start_time = $start_original_arr[1];
                                $original_start_date = $start_original_arr[0];
                                $original_start_date_arr = explode('-', $original_start_date);
                                $start_modify = $original_start_date_arr[2].$month_for_copy_obj->format('m.Y');
                                
                                foreach(json_decode($k) as $one_json_item_key){
                                    //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/icon_data_shifts.html', print_r($one_json_item_key, true), FILE_APPEND | LOCK_EX);
                                }
                                //$item->$k = $start_modify;*/
                            break;
                           
                        }
                    }
                }

                $this->db->insertObject('#__com_shifts_reservations', $item);
            }
        }
    }
    
    private function getMonthData($current_month, $year_parent_month, $normalized_month_for_copy, $year_for_copy)
    {
        
        $availableUsers  =  array(-1);
        $rms  = $this->loadRooms();
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
        $current_month_raw_obj = DateTime::createFromFormat('F Y', $current_month.' '.$year_parent_month);
       // return $current_month_raw_obj;
        
        $current_month_unix_obj = $current_month_raw_obj->modify('first day of this month 00:00');
        $current_month_unix = $current_month_unix_obj->format('U');
        
        $next_month_raw_obj = clone $current_month_raw_obj;
        $next_month_raw_unix_obj = $next_month_raw_obj->modify('first day of next month 00:00');
        $next_month_raw_unix = $next_month_raw_unix_obj->format('U');
        
        $this->deleteOldMonthData($normalized_month_for_copy, $availableUsers, $year_for_copy);
        
        $query = "SELECT * FROM #__com_shifts_reservations WHERE `room_id` in (".join(",", $availableUsers).") AND UNIX_TIMESTAMP(start) >= '$current_month_unix' AND UNIX_TIMESTAMP(end) < '$next_month_raw_unix' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $result = $this->db->loadAssocList();
        
        //return $result;
        $events = [];

        date_default_timezone_set("UTC");
       
        
        foreach($result as $row) {
            $e = new stdClass();
            
            $e->id = $row['id'];
            $e->name = $row['name'];
            $e->start = $row['start'];
            $e->end= $row['end'];
            $e->room_id = $row['room_id'];
            $e->status = $row['status'];
            $e->paid = $row['paid'];
            $e->shift_color = $row['shift_color'];
            $e->shift_name = $row['shift_name'];
            $e->shift_message = $row['shift_message'];
            $e->icon_date = $row['icon_date'];

            
            $events[] = $e;
        }
        
       
        return $events;
    }
    
    public function getIconsCodes()
    {
        return [
            'standart' => [
                'pizza-slice',
                'cocktail',
                'restaurant',
                'spoon-and-fork',
                'aim',
                'like',
                'male',
                'telephone',
                'tea',
                'bar-code',
                'briefcase',
                'bucket1',
                'cart-alt',
                'eye',
                'favourite',
                'invisible',
                'info',
                'learn',
                'light-bulb',
                'listening',
                'live-support',
                'money',
                'moon',
                'mop',
                'mustache',
                'tools-alt-2',
                'doctor',
                'nurse',
                'car-alt-3',
                'rocket-alt-1',
                'student',
                'teacher',
                'woman-in-glasses',
                'users',
                'girl',
                'funky-man',
                'waiter',
                'boy',
                'business-man-alt-1',
                'man-in-glasses',
                'support',
                'id-card',
                'laughing',
                'smirk',
                'wink-smile',
                'confounded',
                'cycling',
                'racing-flag-alt'
            ],
            'circles' => [
                '<span class=\"circle_as_icon circle-red js_event_store_this_item_same_as_element_i\" style=\"background:#e81224\"></span>',
                '<span class=\"circle_as_icon circle-blue js_event_store_this_item_same_as_element_i\" style=\"background:#0078d7\"></span>',
                '<span class=\"circle_as_icon circle-green js_event_store_this_item_same_as_element_i\" style=\"background:#16c60c\"></span>',
                '<span class=\"circle_as_icon circle-yellow js_event_store_this_item_same_as_element_i\" style=\"background:#fce100\"></span>',
                '<span class=\"circle_as_icon circle-purple js_event_store_this_item_same_as_element_i\" style=\"background:#886ce4\"></span>',
                '<span class=\"circle_as_icon circle-orange js_event_store_this_item_same_as_element_i\" style=\"background:#f7630c\"></span>',
                
                '<span class=\"circle_as_icon circle-blackgreen js_event_store_this_item_same_as_element_i\" style=\"background:#0e5a20\"></span>',
                '<span class=\"circle_as_icon circle-pink js_event_store_this_item_same_as_element_i\" style=\"background:#ed12c6\"></span>',
                '<span class=\"circle_as_icon circle-ocean js_event_store_this_item_same_as_element_i\" style=\"background:#15edfb\"></span>',
                '<span class=\"circle_as_icon circle-blackred js_event_store_this_item_same_as_element_i\" style=\"background:#a0172e\"></span>',
                '<span class=\"circle_as_icon circle-pinkpink js_event_store_this_item_same_as_element_i\" style=\"background:#90128c\"></span>',
                '<span class=\"circle_as_icon circle-orangeorange js_event_store_this_item_same_as_element_i\" style=\"background:#d8523c\"></span>',
            ]
        ];
    } 
    
    public function saveUserIcon($start, $end, $lang, $user_id, $selected_icon)
    {
        $item = new stdClass();
        $item->id = $user_id;
        $item->user_position_icon = $this->db->escape($selected_icon);
            
        if($this->db->updateObject('#__users', $item, 'id')){
            return $item->user_position_icon;
        }
    }
    
    //hh
    public function getUsersIconsUsed($cell_date)
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id = $this->user->owner_id;
        //$visible_manager = $_REQUEST['vmngr'];
       
        $visible_manager = false;
        if(in_array(6, $this->user->groups)){
            if($visible_manager == true){
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
            } else{
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id`!='".$this->user->owner_id."' ORDER BY `username0` ASC";
            }
            
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } elseif(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."' AND `is_hide`='0'";
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } 
        
                            
        $result = [];

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            $r->user_position_icon = $room['user_position_icon'];
            $r->input_value = '';
          
            if(!empty($r->user_position_icon)){
                $config = [
                    'date' => $cell_date,
                    'icon_in_current_row' => $room['user_position_icon']
                ];
                $r->input_value = $this->getInputValue($config);
                
                $result[$r->user_position_icon] = $r;
            }
        }
       /* echo '<pre>';
        print_r($result);
        echo '</pre>';*/
        
        $html = '';
        foreach ($result as $icon) {
            $status_current_item_is_circle = 0;
            $final_css_class = $icon->user_position_icon;
            
            
            if (!empty($final_css_class)) {
                $stored_icon_classes_arr = explode(' ', $final_css_class);

                if (count($stored_icon_classes_arr) > 1 && $stored_icon_classes_arr[0] !== 'icofont') {
                    $status_current_item_is_circle = 1;
                    $final_css_class = 'circle_internal_in_popup ' . $stored_icon_classes_arr[0] . ' ' . $stored_icon_classes_arr[1]  . ' ' . $stored_icon_classes_arr[2];
                    //$icon = '<span class="' . $final_css_class . '"></span>';
                } else{
                     $status_current_item_is_circle = 0;
                }
            } else{
                 $status_current_item_is_circle = 0;
            }


            $html .= '<div class="one_option_wrapper">'
                    . '<div class="half_left">';
            
                if( $status_current_item_is_circle === 1){
                    $html .= '<span class="' . $final_css_class . '"></span>';
                } else{
                    $html .= '<i class="' . $final_css_class . '"></i>';
                }
                
                $html .=  '</div>'
                    . '<div class="half_right">'
                        . '<input type="text" data-date="' . $cell_date . '" class="option_input" value="' . $icon->input_value . '"/>'
                    . '</div>'
                    . '</div>';
        }
        
        return $html;
      
    }
    
    private function getInputValue($config)
    {
        //$val = $config['val'];
        $date = $config['date'];
        $icon_in_current_row = $config['icon_in_current_row'];
        $manager_id = $this->user->owner_id;
        
        $query = "SELECT * FROM #__com_shifts_saved_icons WHERE `manager_id` = '$manager_id' AND `cell_date` ='$date' AND `row_icon_code` = '" . trim($icon_in_current_row) . "'";
        //echo  $query ;
        //exit;
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        return $result[0]->input_value;
    }
    
   
    public function saveAvbState(array $config)
    {
        $date = strip_tags($config['date']);
        $val_raw = strip_tags($config['val']);
        
        
        if($val_raw == 'true'){
            $val = 1;
        } else{
         
           $val = 0;
        }
        /*echo '<pre>$val_raw';
        print_r($val_raw);
        echo '</pre>';*/
        $manager_id = $this->user->owner_id;
        $table = '#__com_shifts_available_buttons_state';
        
        $query = "SELECT * FROM ".$table." WHERE `manager_id` = '$manager_id' AND `cell_date` ='$date'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        /*echo '<pre>';
        print_r($result);
        echo '</pre>';*/
        if(count($result) > 1){
            throw new Exception(JText::_('COM_SHIFTS_NEW_AVB_BUTTON_ERROR_ERROR_IN_DB'));
        } elseif(count($result) === 1){
            $item = new stdClass();
            
            $item->id = $result[0]->id;
            $item->manager_id = $result[0]->manager_id;
            $item->cell_date = $result[0]->cell_date;
            $item->available_button_state = $this->db->escape($val);
            
           $this->db->updateObject($table, $item, 'id');
        } elseif(count($result) === 0){
            $item = new stdClass();
            
            $item->id = null;
            $item->manager_id = $manager_id;
            $item->cell_date = $date;
            $item->available_button_state = $this->db->escape($val);
            $item->timestamp_create = time();
            $item->date_create = date('d.m.Y H:i:s');
            
            $this->db->insertObject($table, $item);
        }
        /*echo '<pre>';
        print_r($item);
        echo '</pre>';*/
        return $val;
    }
    
    public function saveInput($config)
    {
        $val = $config['val'];
        $date = $config['date'];
        $icon_in_current_row = $config['icon_in_current_row'];
        $manager_id = $this->user->owner_id;
        
        $query = "SELECT * FROM #__com_shifts_saved_icons WHERE `manager_id` = '$manager_id' AND `cell_date` ='$date' AND `row_icon_code` = '$icon_in_current_row'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        //echo $query;
        if(count($result) > 1){
            throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_IN_DB'));
        } elseif(count($result) === 1){
            $item = new stdClass();
            
            $item->id = $result[0]->id;
            $item->manager_id = $result[0]->manager_id;
            $item->cell_date = $result[0]->cell_date;
            $item->row_icon_code = $this->db->escape($icon_in_current_row);
            $item->input_value = $this->db->escape($val);
            
            $this->db->updateObject('#__com_shifts_saved_icons', $item, 'id');
        } elseif(count($result) === 0){
            $item = new stdClass();
            
            $item->id = null;
            $item->manager_id = $manager_id;
            $item->cell_date = $date;
            $item->row_icon_code = $this->db->escape($icon_in_current_row);
            $item->input_value = $this->db->escape($val);
            $item->timestamp_create = time();
            $item->date_create = date('d.m.Y H:i:s');
            
            $this->db->insertObject('#__com_shifts_saved_icons', $item);
        }
    }
    
    public function getUsedIconsListForManager()
    {
        $manager_id = $this->user->owner_id;
        
        $query = "SELECT * FROM #__com_shifts_saved_icons WHERE `manager_id` = '$manager_id' ORDER BY `cell_date` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        
        /*$newArr = array_filter($list, function($arr){ /* `$arr` gets value of one nested array on each pass 
            return $arr;
        });*/
        
        $final = []; 
        
        
        foreach($list as $a_pair){
            $input = 0;
            
            /*$query = "SELECT * FROM #__com_shifts_saved_icons WHERE `manager_id` = '$manager_id' AND `cell_date`='$a_pair->cell_date' ORDER BY `cell_date` ASC";
            $this->db->setQuery($query);
            $item_as_dates = $this->db->loadObjectList();*/
            
            $used_icons = $this->getUsersIconsUsedForInternalUse($a_pair->cell_date);
            
            foreach($used_icons as $use_icon){
                $input += $use_icon->input_value;
            }
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/getUsedIconsListForManager.html', print_r($used_icons, true), FILE_APPEND | LOCK_EX);
            /*foreach($item_as_dates as $date_item){
                 
                if (!empty($date_item->cell_date)) {
                    $used_icons = $this->getUsersIconsUsedForInternalUse($date_item->cell_date);
                    //$row = $used_icons[$date_item->user_position_icon];

                    file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/getUsedIconsListForManager.html', print_r($used_icons, true), FILE_APPEND | LOCK_EX);

                    if (in_array($date_item->user_position_icon, (array) $used_icons)) {
                        $input += $date_item->input_value;
                    } else {
                        //$input -= $date_item->input_value;
                    }
                }

                /*$item = null;
                foreach($used_icons as $struct) {
                    if ($date_item->user_position_icon == $struct->user_position_icon) {
                        $item = $struct;
                         $input += $date_item->input_value;
                        break;
                    } else{
                       
                    }
                }*/
                //foreach($used_icons as $icon_item){
                    //if(in_array($date_item->user_position_icon, $used_icons, TRUE)){
                    //if(property_exists($used_icons->cell_date, $date_item->user_position_icon)){
                        //$input += $date_item->input_value;
                       
                   // } else{
                       //  continue;
                    //}
                    //$input += $date_item->input_value;
               // }
               //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/getUsedIconsListForManager.html', print_r($used_icons, true), FILE_APPEND | LOCK_EX);
               
            /*}*/
            $final[$a_pair->cell_date] = $input;
        }
        
        return ['total' => $final, 'list' => $list];
    }
    
    public function getUsersIconsUsedForInternalUse($cell_date)
    {
        $department_obj = $_REQUEST['dep'];
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id = $this->user->owner_id;
       //$visible_manager = $_REQUEST['vmngr'];
       
        $visible_manager = false;
        if(in_array(6, $this->user->groups) || in_array(10, $this->user->groups)){
            if($visible_manager == true){
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' ORDER BY `username0` ASC";
            } else{
                $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id`!='".$this->user->owner_id."' ORDER BY `username0` ASC";
            }
            
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } elseif(in_array(2, $this->user->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->id."' AND `is_hide`='0'";
            $this->db->setQuery($query);
            $rooms = $this->db->loadAssocList();
        } 
        
        
        $result = [];

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            $r->user_position_icon = $room['user_position_icon'];
            $r->input_value = '';
            //$r->cell_date = $room['cell_date'];
                    
            if(!empty($r->user_position_icon) && !empty($cell_date)){
                $config = [
                    'date' => $cell_date,
                    'icon_in_current_row' => $r->user_position_icon
                ];
                $data = $this->getInputValueForInternalUse($config);
                $r->input_value = $data->input_value;
                $r->cell_date = $data->cell_date;
                
                $result[$r->user_position_icon] = $r;
            }
        }
       /* echo '<pre>';
        print_r($result);
        echo '</pre>';*/
        
        /*$html = '';
        foreach($result as $icon){
            $html .= '<div class="one_option_wrapper"><div class="half_left"><i class="'.$icon->user_position_icon.'"></i></div><div class="half_right"><input type="text" data-date="'.$cell_date.'" class="option_input" value="'.$icon->input_value.'"/></div></div>';
        }
        return $html;*/
        return $result;
    }
    
    private function getInputValueForInternalUse($config)
    {
        //$val = $config['val'];
        $date = $config['date'];
        $icon_in_current_row = $config['icon_in_current_row'];
        $manager_id = $this->user->owner_id;
        
        $query = "SELECT * FROM #__com_shifts_saved_icons WHERE `manager_id` = '$manager_id' AND `cell_date` ='$date' AND `row_icon_code` = '$icon_in_current_row'";
        $this->db->setQuery($query);
        $result = $this->db->loadObjectList();
        
        return $result[0];
    }
    
    public function confirmApiMessages()
    { 
        $availableUsers  =  array(-1);
        $rms  = $this->loadRooms();
        if(!empty($rms)) {
            foreach ($rms as $r) {
                $availableUsers[] = intval($r->id);
            }
        }
        
	$query = "UPDATE  #__app_api_messages SET `status` = '1' WHERE `user_id` in (".join(",", $availableUsers).") AND `is_read` = '0' AND `status` = '0' AND `message_type` = 'shifts_changes' AND `about_changes` = '1'";
        $this->db->setQuery($query);
        $this->db->query();
        
        //from /cli/send_notifications_to_firebase.php part
        $query = "SELECT * FROM  #__app_api_messages WHERE `user_id` in (" . join(",", $availableUsers) . ") AND `is_read` = '0' AND `status` = '1' AND `message_type` = 'shifts_changes' AND `about_changes` = '1'";     
        $this->db->setQuery($query);
        $messages_object = $this->db->loadObjectList();
                    
        if(!empty($messages_object)){
            //$this->out(print_r($messages_object, true));
            /*echo '<pre>';
            print_r($messages_object);
            echo '</pre>';*/
            $res = $this->storeToFirebase($messages_object);              
        }
    }
    
    private function storeToFirebase( array $messages) {

        $url = $this->firebase_url;
        $YOUR_API_KEY = $this->server_key; // Server key
        $not_perm_users = [
            -1
        ];
        
        
        foreach($messages as $one_message){
            $user_obj = & JFactory::getUser($one_message->user_id);
          
            //$this->out('$user_obj->app_client_enable_push:')->out($user_obj->app_client_enable_push);
            /*if($user_obj->id != 3844){
                continue;
            }*/
            //$this->out('$user:')->out(print_r($user_obj, true));
            if(in_array($user_obj->id, $not_perm_users)){
                continue;
            } /*if($user_obj->app_client_enable_push == 0){
                continue; 
            }*/
            
            $YOUR_TOKEN_IDS = json_decode($user_obj->firebase_device_ids, true); // Client token id
            /*echo '<pre>$YOUR_TOKEN_IDS:';
            print_r($YOUR_TOKEN_IDS);
            echo '</pre>';*/
            $devices_push_status = json_decode($user_obj->app_client_enable_push, true);//clien push status from devices
            //$this->out('$devices_push_status:')->out(print_r($devices_push_status));
                    
            $count_user_devices = count($YOUR_TOKEN_IDS);
            
            if ($count_user_devices === 1) {
                /*echo '<pre>$devices_push_status[$YOUR_TOKEN_IDS[0]]';
                print_r($devices_push_status[$YOUR_TOKEN_IDS[0]]);
                echo '</pre>';*/
                
                if($devices_push_status[$YOUR_TOKEN_IDS[0]] == 0){
                    continue;
                }
                $request_body = [
                    'to' => $YOUR_TOKEN_IDS[0],
                    'notification' => [
                        'title' => $one_message->subject_en,
                        'body' => $one_message->text_en,
                        'icon' => 'https://newdev.curiotime.com/templates/curiotimenew/favicon.ico',
                        'click_action' => 'https://curiotime.com',
                    ],
                ];      
            } elseif($count_user_devices > 1){
                $request_body = [
                    'notification' => [
                        'title' => $one_message->subject_en,
                        'body' => $one_message->text_en,
                        'icon' => 'https://newdev.curiotime.com/templates/curiotimenew/favicon.ico',
                        'click_action' => 'https://curiotime.com',
                    ]
                ];
            
                $request_body['registration_ids'] = [];
                    
                foreach($YOUR_TOKEN_IDS as $one_user_device){
                    //$this->out('$devices_push_status:')->out($devices_push_status[$one_user_device]);
                    /*echo '<pre>$devices_push_status[$one_user_device]';
                    print_r($devices_push_status[$one_user_device]);
                    echo '</pre>';*/
                    
                    if($devices_push_status[$one_user_device] == 0){
                        //$this->out('pp');
                        continue;
                    } else{
                   
                        $request_body['registration_ids'][] = $one_user_device;
                    }
                }
            }
            //$this->out(print_r($request_body, true)); 
        
        
            $fields = json_encode($request_body);

            $request_headers = [
                'Content-Type: application/json',
                'Authorization: key=' . $YOUR_API_KEY,
            ];
            //sleep(1);
            
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, $url); 
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_HTTPHEADER, $request_headers);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
            $response = json_decode(curl_exec($ch));
            curl_close($ch);
            
            //$this->out('firebase response:');
            /*echo '<pre>firebase response:';
            print_r($response, true);
            echo '</pre>';*/
            //$this->out(print_r($response, true));
            
            $this->updateScheduleStatus($one_message, $user_obj->id);
            $this->addLogRow($response, $user_obj->id);
             
            //return $response;
        }
    }
    
    private function updateScheduleStatus($schedule, int $user_id)
    {
       $query = "UPDATE  #__app_api_messages SET `is_read` = '1' WHERE `id` = '".$schedule->id."' AND `user_id` = '".$user_id."'";
       //$this->out($query);
       $this->db->setQuery($query);
       $this->db->query();
    }
    
    private function addLogRow($response, int $user_id): void
    {
        $item = new stdClass();
        $item->id = null;
        $item->user_id = $user_id;
        $item->timestamp_create = time();
        $item->date_create = date('d.m.Y H:i:s');
        $item->response = json_encode($response);
        
        $this->db->insertObject('#__firebase_logs', $item);
    }
    
    private function deleteApiMessages($shift_id)
    {
        $query = "DELETE FROM #__app_api_messages WHERE `shift_id` = '".(int)$shift_id."' AND `message_type` = 'shifts_changes'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function addMessageInApiAboutDelete($data_obj, $user_id)
    {

        $text_en = 'Your Schedules from '.$data_obj->start.' - '.$data_obj->end.' has been deleted';
        $text_is = 'Your Schedules from '.$data_obj->start.' - '.$data_obj->end.' has been deleted';
            
        $item = new stdClass();
        $item->id = null;
        $item->user_id = (int) $user_id;
        $item->text_en = $this->db->escape($text_en);
        $item->text_is = $this->db->escape($text_is);
        $item->is_read = 0;
        $item->timestamp = time();
        $item->date_create = date('d.m.y H:i:s');
        $item->shift_id = $data_obj->id;
        $item->status = 0;
        $item->message_type = 'shifts_changes';
        $item->subject_en = $this->db->escape('Your schedules has been deleted');
        $item->subject_is = $this->db->escape('Your schedules has been deleted');
        $item->about_changes = 1;
        
        $this->db->insertObject('#__app_api_messages', $item);
    }
    
    public function getHolidaysFromAdmin()
    {
        $query_h = "SELECT title, CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop,
        holidays_type_90, holidays_type_45 FROM #__holiday WHERE published = '1' AND language = 'all' ORDER BY `id` DESC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        $final = [];
        $i = 0;
        foreach($res as $one_holiday){
            $start_obj = DateTime::createFromFormat('Y-m-d H:i', $one_holiday->start);
            $stop_obj = DateTime::createFromFormat('Y-m-d H:i', $one_holiday->stop);
            
            $final[$i] = $one_holiday;
            $final[$i]->formatted_start = $start_obj->format('Y-m-d');
            $final[$i]->formatted_stop = $stop_obj->format('Y-m-d');
            
            $i++;
        }
        
        return $final; 
    }
    
    public function getUserPercents($start, $end)
    {
        $rooms = json_decode(ShiftsController::loadRoomsStatic());
                 
        if(!empty($rooms)){   
            foreach($rooms as $one_user){
                $user_shifts = json_decode($this->loadUserEnevts($one_user->id, $start, $end));
  
                $final_percents[$one_user->id] = round((count((array)$user_shifts)*100) / $this->getWorksDay($start, $end));
            }      
        } 
    
        return $final_percents;
    }
    
    private function getWorksDay($start, $end)
    {
        $date_start = new DateTime($start);
        $date_end = new DateTime($end);
        
        /*$diff = $date_end->diff($date_start);
        $work_day_count = $date_start->modify($diff->format('%R%a').' weekday');
        
        $final_diff = $date_end->diff($date_start);
        echo '$work_day_count'.$work_day_count.PHP_EOL;
        //echo $date->format('Y-m-d');
        return $work_day_count;*/
        
        return $this->getWeekdayDifference($date_start, $date_end);
    }
    
    private function getWeekdayDifference(\DateTime $startDate, \DateTime $endDate)
    {
        $days = 0;

        while($startDate->diff($endDate)->days > 0) {
            $days += $startDate->format('N') < 6 ? 1 : 0;
            $startDate = $startDate->add(new \DateInterval("P1D"));
        }

        return $days;
    }
    
    public function removeScheduleMessage($user_id, $shift_id, $type)
    {
        if(empty($type)){
            $query = "DELETE FROM #__com_shifts_reservations WHERE `id` = '$shift_id' AND `room_id` = '$user_id' ;";
            $this->db->setQuery($query);
            $this->db->query();
        } else{
            $query = "UPDATE #__com_shifts_reservations SET `icon_date`='' WHERE `id` = '$shift_id' AND `room_id` = '$user_id' ;";
            $this->db->setQuery($query);
            $this->db->query();
        }
        
    }
    
    
    public function loadAvbsState(): array
    {
        $query_h = "SELECT * FROM #__com_shifts_available_buttons_state WHERE `manager_id` = '".$this->user->owner_id."' ORDER BY `id` ASC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        $final = [];
        foreach($res as $one_date){
            $final[$one_date->cell_date] = $one_date->available_button_state;
        }
        
        
        return $final;
        
    }
    
    /**
     * canceled. old method
     */
    /*public function loadAvbsState()
    {
        $query_h = "SELECT * FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$this->user->owner_id."' ORDER BY `id` ASC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        $final = [];
        foreach($res as $one_date){
            $final[$one_date->date] = 1;
        }
        
        
        return $final;
        
    }*/
    
    public function saveAvbSchedule(string $hours, string $cell_date, string $schedule_color)
    {
        $query_h = "SELECT * FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$this->user->owner_id."' AND `date` = '$cell_date' AND `schedule_value` = '$hours' AND `schedule_color` = '$schedule_color' ORDER BY `id` ASC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        if (count($res) == 0) {
            $item = new stdClass();
            $item->id = null;
            $item->manager_id = $this->user->owner_id;
            $item->date = $cell_date;
            $item->schedule_value = $hours;
            $item->schedule_color = $schedule_color;
            $item->creation_time = time();
            $item->creation_date = date('d.m.Y H:i:s');

            $res['res'] = $this->db->insertObject('#__com_shifts_av_shedules', $item);
            $res['id'] = $this->db->insertid();
            
            return $res;
        }
        
        /*echo '<pre>';
        print_r($res);
        echo '</pre>';*/  
    }
    
    public function loadAvbSchedules(string $date)
    {
        $query_h = "SELECT * FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$this->user->owner_id."' AND `date` = '$date' ORDER BY `id` ASC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        return $res;
    }
    
    public function deleteAvbSchedule(int $id)
    {
        $query_h = "SELECT * FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$this->user->owner_id."' AND `id` = '$id'";         
        $this->db->setQuery( $query_h );
        $date = $this->db->loadObject()->date;
        
        $query = "DELETE FROM #__com_shifts_av_shedules WHERE `id` = '$id' AND `manager_id` = '".$this->user->owner_id."';";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $date;
    }
    
    private function loadCompanyUsersId(int $user_id) {
        $owner_id = & JFactory::getUser($user_id)->owner_id;
        
        //load users of manager
        $query = "SELECT `id` FROM $this->users_table WHERE `owner_id` = '".$owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $manager_users = $this->db->loadObjectList();
        $all_user_id = array_column($manager_users, 'id');
        
        return $all_user_id;
    }
    
    public function cloneWithPeriod(string $lang, string $period_start, string $period_stop, string $clone_to)
    {   
        $period_start_obj = DateTime::createFromFormat('d.m.Y H:i:s', $period_start.' 00:00:00');
        $period_stop_obj = DateTime::createFromFormat('d.m.Y H:i:s', $period_stop.' 00:00:00');

        $period_stop_clone = clone $period_stop_obj;
        $period_stop_plus_1 = $period_stop_clone->modify('+1day');
        
        $date_clone_to_obj = DateTime::createFromFormat('d.m.Y H:i:s', $clone_to.' 00:00:00');
        $all_user_id = $this->loadCompanyUsersId($this->user->owner_id);
        
        $interval = new DateInterval('P1D');
        $daterange = new DatePeriod($period_start_obj, $interval, $period_stop_plus_1);
        $dates_array = [];
                
        foreach($daterange as $date1) {
            $dates_array[] = $date1->format('Y-m-d');
        }
        
        if(!empty($all_user_id)){
            $query = "SELECT * FROM " . $this->db->quoteName($this->table_shifts) . " WHERE " . $this->db->quoteName('room_id') . " IN(" . implode(",", $all_user_id) . ") AND " . $this->db->quoteName('status') . " !=  'pending_available' AND " . $this->db->quoteName('shift_color') . "!='transparent' ORDER BY " . $this->db->quoteName('id') . " ASC";
            $this->db->setQuery($query);
            $shifts = $this->db->loadObjectList();
            
            $shifts_for_clone = [];
            foreach($shifts as $shift){
                $shift_start = $shift->start;
                $shift_end = $shift->end;
                 
                $shift_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', $shift_start);
                $shift_end_obj = DateTime::createFromFormat('Y-m-d H:i:s', $shift_end);

                $start_subs = substr($shift_start, 0, 10);
                $end_subs = substr($shift_end, 0, 10);
                
              
                if(in_array($start_subs, $dates_array) || in_array($end_subs, $dates_array) || (($shift_start_obj->format('U') < $period_start_obj->format('U') && in_array($end_subs, $dates_array)) || ($shift_start_obj->format('U') < $period_start_obj->format('U') && $shift_end_obj->format('U') > $period_stop_plus_1->format('U')))){
                    $shifts_for_clone[] = $shift;
                }
            }
            
            $sql = '';
            $new_shifts_to_clone = []; 
            foreach($shifts_for_clone as $shift){ 
                $new_shift = $shift;
                $current_shift_date_clone_to_obj = clone $date_clone_to_obj;
                
                $shift_start = $shift->start;
                $shift_end = $shift->end;
                
                $shift_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', substr($shift_start, 0, 10).' 00:00:00');
                $shift_start_obj_clone = clone $shift_start_obj;
                $shift_start_obj_clone1 = clone $shift_start_obj;
                
                $shift_end_obj = DateTime::createFromFormat('Y-m-d H:i:s', substr($shift_end, 0, 10).' 00:00:00');
                
                $shift_end_obj_clone_obj = clone $shift_end_obj;
 
               
                // start new code -------
                // new shift start
                $new_shift_start = $shift_start_obj <= $period_start_obj ? $current_shift_date_clone_to_obj : $current_shift_date_clone_to_obj->modify('+'.($shift_start_obj->diff($period_start_obj)->days).' day');
                
                // number of days for new shift
                $old_shift_start = $shift_start_obj <= $period_start_obj ? $period_start_obj : $shift_start_obj;
                $old_shift_end = $shift_end_obj >= $period_stop_obj ? $period_stop_obj : $shift_end_obj;
                $old_shift_days = $old_shift_end->diff($old_shift_start)->days;
                
                // new shift end
                $new_shift_end = clone $new_shift_start;
                $new_shift_end = $new_shift_end->modify('+'.($old_shift_days).' day');
                
                // update cloned shifts with new start and end dates
                $new_shift = clone $shift; 
                $shift_start_time = new DateTime($shift->start);
                $shift_end_time = new DateTime($shift->end);
                
                date_time_set($new_shift_start, $shift_start_time->format("H"), $shift_start_time->format("i"), '00');
                date_time_set($new_shift_end, $shift_end_time->format("H"), $shift_end_time->format("i"), '00');
                
                $new_shift->start = $new_shift_start->format('Y-m-d H:i:s');
                $new_shift->end = $new_shift_end->format('Y-m-d H:i:s');
                
                // array with new shifts
                $new_shifts_to_clone[] = $new_shift;
                // end new code -------
            }
          
             if(!empty($new_shifts_to_clone)){
                $delete_from = clone $period_start_obj;
                $extract = max(array_column($new_shifts_to_clone, 'end'));  
                $max_end_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $extract);

                $min = min(array_column($new_shifts_to_clone, 'end'));  // or use max()
                $min_end_date_obj = DateTime::createFromFormat('Y-m-d H:i:s', $min);
                

                $query_del = "DELETE FROM " . $this->db->quoteName($this->table_shifts) . " WHERE UNIX_TIMESTAMP(start) >= " . $min_end_date_obj->format('U') . " AND UNIX_TIMESTAMP(end) <= " . $max_end_date_obj->format('U') . " AND " . $this->db->quoteName('room_id') . " IN(" . implode(",", $all_user_id) . ")";
                $this->db->setQuery($query_del);
                $this->db->query();
            }

            $not_perm_keys = [
                'id',
                'icon_date'        
            ];
            
            $sql = "INSERT INTO " . $this->db->quoteName($this->table_shifts) . " (`name`, `start`, `end`, `room_id`, `status`, `paid`, `shift_color`, `shift_name`, `shift_message`, `tasks_ids`, `standart_tasks_ids`, `message_time`, `message_date`) VALUES";
            foreach($new_shifts_to_clone as $one_shift){
                $sql .= "(";
                foreach($one_shift as $k => $v){
                    if(in_array($k, $not_perm_keys)) continue;
                    $sql .= $this->db->quote($v) . ", ";
                }
                $sql = chop($sql, ", ");
                $sql .= "), ";
            }
            $sql = chop($sql, ", ");
            $sql .= ";";
            
           
            $this->db->setQuery($sql);	 
            $res = $this->db->query();
        }
        
        return [
            'new_shifts_to_clone' => $new_shifts_to_clone,
            //'insert_sql' => $sql,
            'insert_result' => $res,
            //'query_del' => $query_del,
            'delete_from' => $min_end_date_obj->format('d.m.Y H:i:s'),
            'delete_to' => $max_end_date_obj->format('d.m.Y H:i:s')
         ];  
    } 
    
    public function removeShiftsByColor(string $lang, string $selected_color, string $start_time, string $end_time) {
        $all_user_id = $this->loadCompanyUsersId($this->user->owner_id);
        $start_time_completed = $start_time . ':00';
        $end_time_completed = $end_time . ':00';
        
        //$query_del = "DELETE FROM " . $this->db->quoteName($this->table_shifts) . " WHERE " . $this->db->quoteName('shift_color') . " = " . $this->db->quote($selected_color) . " AND " . $this->db->quoteName('start') . " LIKE " . $this->db->quote($start_time_completed) . " AND " . $this->db->quoteName('end') . " LIKE " . $this->db->quote($end_time_completed) . " AND " . $this->db->quoteName('room_id') . " IN(" . implode(",", $all_user_id) . ")";
        $query_del = "DELETE FROM " . $this->db->quoteName($this->table_shifts) . " WHERE " . $this->db->quoteName('shift_color') . " = " . $this->db->quote($selected_color) . " AND CAST(" . $this->db->quoteName('start') . " AS TIME) = " . $this->db->quote($start_time_completed) . " AND CAST(" . $this->db->quoteName('end') . " AS TIME) = " . $this->db->quote($end_time_completed) . " AND " . $this->db->quoteName('room_id') . " IN(" . implode(",", $all_user_id) . ")";
        $this->db->setQuery($query_del);
        $res = $this->db->query();
                            
        return $query_del; 
    }
}
