<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
/**
 * @version     1.0.0
 * @package     com_spec_holiday_1.0.0
 * @copyright   Copyright (C) 2019. All rights reserved.
 * @license     GNU General Public License version 2 or later; see LICENSE.txt
 * @author      SMG <developer3452@gmail.com> - #
 */
defined('_JEXEC') or die;

jimport('joomla.application.component.modellist');


class Spec_holiday2ModelApp_api extends JModelList {

    /**
     * Constructor
     *
     * @param    array          An optional associative array of configuration settings
     *
     * @see      JController
     * @since    1.6
     */
    public function __construct($config1 = array()) 
    {
      
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        $this->config = &JFactory::getConfig(); 
       
        parent::__construct($config1);
    }

    private function convertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('d.m.Y', $from);
        $from_date = $from_date_raw->format('Y-m-d 00:00:00');
       

        $to_date_raw = DateTime::createFromFormat('d.m.Y', $to);
        $to_date = $to_date_raw->format('Y-m-d 00:00:00');
        
        return [
            'from'=>$from_date,
            'to'=>$to_date
        ];
    }
    
    private function checkPeriod($dates, $user_id)
    {
        $from=$dates['from'];
        $to=$dates['to'];
        
        if($from==$to){
            $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE start='$from' AND end='$to' AND room_id = '$user_id'";
            $this->db->setQuery($query);
            $reservations = $this->db->loadObject();  
        } else{
            $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE NOT ((end <= '$from') OR (start >= '$to')) AND room_id = '$user_id'";
            $this->db->setQuery($query);
            $reservations = $this->db->loadObject();
        }
        
        
        return $reservations->count;
    }
    
    private function checkPeriodShifts($dates, $user_id,$icon_date = "")
    {
        $from=$dates['from'];
        $to=$dates['to'];
        
        if($from==$to){
            if(strlen($icon_date) > 0)
                $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE date(start)=date('$from') AND date(end)=date('$to') AND room_id = '$user_id'";
            else
                $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE start='$from' AND end='$to' AND room_id = '$user_id'";
            $this->db->setQuery($query);
            $reservations = $this->db->loadObject();  
        } else{
            if(strlen($icon_date) > 0) {
                $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE NOT ((date(end) <= date('$from')) OR (date(start) >= date('$to'))) AND room_id = '$user_id'";
            } else {
                $query = "SELECT COUNT(*) AS 'count' FROM #__com_shifts_reservations WHERE NOT ((end <= '$from') OR (start >= '$to')) AND room_id = '$user_id'";
            }
            $this->db->setQuery($query);
            $reservations = $this->db->loadObject();
        }
        
        
        return $reservations->count;
    }
    
    private function convertDatesShifts($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('d.m.Y H:i', $from);
        $from_date = $from_date_raw->format('Y-m-d H:i:s');
       

        $to_date_raw = DateTime::createFromFormat('d.m.Y H:i', $to);
        $to_date = $to_date_raw->format('Y-m-d H:i:s');
        
        return [
            'from'=>$from_date,
            'to'=>$to_date
        ];
    }
    
    public function setShiftForApi($user_id, $from, $to, $lang, $shift_color, $shift_name, $date, $status, $message,$icon_date  =  "")
    {
        //point
        if($status === 'pending_available'){
            /*$to_date = $this->plus1Day($date);
            $dates_arr = $this->convertDatesShifts($date.' 00:00', $to_date); 
            $check_period = $this->checkPeriodShifts($dates_arr, $user_id);*/
        
            return $this->setShiftMessage($user_id, $date, $type = '', $lang, $message);
        } if($status === 'pending_work'){
            
        }
        
        $dates_arr = $this->convertDatesShifts($from, $to);
        $start = $dates_arr['from'];
        $end = $dates_arr['to'];
        
        $startTime  =   strtotime($start);
        $endTime    =   strtotime($end);
        
        if(strlen(trim($icon_date)) > 4) {
            $icon_time  =   strtotime($icon_date);
            if($icon_time < $startTime) {
                $icon_date  = date("d.m.Y",$startTime);
            }                
            if($icon_time > $endTime) {
                $icon_date  = date("d.m.Y",$endTime);
            }
        }
        $check_period = $this->checkPeriodShifts($dates_arr, $user_id,$icon_date);
        $user_id    = intval($user_id);
        if($check_period == 0){
            
            $name = 'holiday';
            $room = (int)$user_id;        
            $item = new stdClass();
            $response = new stdClass();        
            $item->id = null;
            $item->name = $name;
            $item->start = $start;
            $item->end = $end;
            $item->room_id = $room;
            $item->status = 'New';
            $item->paid = 0;
            $item->shift_color = $shift_color;
            $item->shift_name = $this->db->escape($shift_name);
            $item->shift_message = $message;
            
            $icon_date_arr  =  array();
            if(empty($icon_date) == false && strlen($icon_date) > 4) {
                
                $t  = strtotime($icon_date);
                $icon_date_arr[$icon_date] = array('date'=>date("Y-m-d",$t));
                $item->status = $status;
            }            
            $item->icon_date = json_encode($icon_date_arr);
            if($this->db->insertObject('#__com_shifts_reservations', $item)){
                $insert_id = $this->db->insertid();
                //$response->message = 'Created with id: '.$insert_id;
                $response->insert_id = $insert_id;
                $response->type = 'success';
            }
            return (array)$response;
        } elseif( empty($icon_date) == false && strlen($icon_date) > 4) {
            
            $query = "SELECT * FROM #__com_shifts_reservations WHERE date(start)=date(".$this->db->quote($start).") AND date(end)=date(".$this->db->quote($end).") AND room_id = '$user_id' limit 1";
            $this->db->setQuery($query);
            $item = $this->db->loadObject();  
            if(empty($item))
                return 'error-0';
            $icon_date_arr = json_decode($item->icon_date,true);
            if(empty($icon_date_arr))
                $icon_date_arr  =  array();
            if(empty($icon_date) == false && strlen($icon_date) > 4) {
                if(!isset($icon_date_arr[$icon_date]))
                    $icon_date_arr[$icon_date] = array('date'=>date("Y-m-d", strtotime($icon_date)));
            }
            
            $item->icon_date = json_encode($icon_date_arr);
            $item->start = $start;
            $item->end = $end;           
            $item->shift_message = $message;
            $this->db->updateObject('#__com_shifts_reservations',$item, 'id');            
            $response = new stdClass();
            $response->insert_id = $item->id;
            $response->type = 'success';
            
            return $response;
        }        
        else{
            return 'error-0';
        }
        
    }
    
    public function setHolidayFromCalendar($user_id, $from, $to)
    {
        $dates_arr=$this->convertDates($from, $to);
        $check_period=$this->checkPeriod($dates_arr, $user_id);
        
        if($check_period==0){
            $start=$dates_arr['from'];
            $end=$dates_arr['to'];
            $name='holiday';
            $room=(int)$user_id;
        
            $item = new stdClass();
            $response=new stdClass();
        
            $item->id = null;
            $item->name = $name;
            $item->start=$start;
            $item->end = $end;
            $item->room_id=$room;
            $item->status='New';
            $item->paid=0;
  
            if($this->db->insertObject('reservations', $item)){
                //$response->result = 'OK';
            
                $insert_id=$this->db->insertid();
                //$response->message = 'Created with id: '.$insert_id;
                $response->insert_id = $insert_id;
                $response->type='success';
            }
            return (array)$response;
        } else{
            return 'error-0';
        }
       
    }
    
    public function getHolidaysApi($user_id)   {
        $query = "SELECT `id`, `start`, `end`, `status` FROM `reservations` WHERE  `room_id` = ".$this->db->quote($user_id)."  order by `start` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        if(empty($list))
            $list  =  array();
        foreach ($list as $key=>$reservation) {
            $final  =   $this->reverseConvertDates($reservation->start, $reservation->end);
            $reservation->start =   $final->start;
            $reservation->end   =   $final->end;        
            if($reservation->status==='api_suggested'){
                $reservation->status='Pending';
            } elseif($reservation->status==='New'){
                $reservation->status='Confirmed';
            }
            $list[$key] = (array)$reservation;
        }        
        return $list;
    }
    
    private function loadAvailableSchedules(int $user_id, object $from_obj, object $to_obj)
    {
        $user_obj = JFactory::getUser($user_id);
        $from = $from_obj->format('U');
        $to = $to_obj->format('U');
        
        $query_h = "SELECT `id`, `date`, `schedule_value`, `schedule_color` FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$user_obj->owner_id."' AND UNIX_TIMESTAMP(`date`) >= '".$from."' AND UNIX_TIMESTAMP(`date`) <= '".$to."' ORDER BY `id` ASC";         
        //return $user_obj;
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        $final = [];
        foreach($res as $one_av_schedule_key => $one_av_schedule_val){
            $date = DateTime::createFromFormat('Y-m-d H:i:s', $one_av_schedule_val->date . '00:00:00');
            $final[$date->format('d.m.Y')][] = $one_av_schedule_val;
        }
        
        return $final;
    }
    
    public function getUserShiftsApi($user_id, $from, $to)
    {
      
        $enable_sort_by_date = '1';
        
        if($enable_sort_by_date === '1'){
            
            $query = "SELECT `id`, `start`, `end`, `status`, `shift_name`, `shift_color`, `icon_date`, `room_id` FROM `#__com_shifts_reservations` WHERE `room_id` = " . $this->db->quote($user_id) . " AND `status` != 'pending_available'  ORDER BY `start` ASC";
            $this->db->setQuery($query);
            $list_raw = $this->db->loadObjectList();
            
            $enable_attach_task_to_shedules = $this->config->get('enable_attach_task_to_shedules');
            $enable_orange_ellipsis_in_schedules_page_and_app_api = $this->config->get('enable_orange_ellipsis_in_schedules_page_and_app_api');
            $from_to_unix = $this->convertDatesToUnix2($from, $to);
            
            $from_obj = DateTime::createFromFormat('d.m.Y H:i:s', $from . '00:00:00');
            $to_obj = DateTime::createFromFormat('d.m.Y H:i:s', $to . '23:59:59');
            
            $to_plus1_obj = clone $to_obj;
            $to_plus1_obj->modify('+23 hour 59 minutes');
                    
            $period = new DatePeriod(
                //new DateTime($schedule_start_obj->modify('-1hour')->format('Y-m-d H:i:s')),
                new DateTime($from_obj->format('Y-m-d H:i:s')),
                new DateInterval('P1D'),
                new DateTime($to_obj->format('Y-m-d H:i:s'))
            );
                    
                  
            $normal_array_of_dates = [];
            $i = 0;
            
            try{
                $available_schedules_all = $this->loadAvailableSchedules($user_id, $from_obj, $to_obj);
            } catch (Exception $ex) {

            }
            
            
            //making period array        
            foreach ($period as $key => $value) {
                $formatted_value = $value->format('d.m.Y');
                        
                /*$normal_array_of_dates[$formatted_value]['with_seconds'] = $value->format('d.m.Y H:i:s');
                $normal_array_of_dates[$formatted_value]['date'] = $formatted_value;*/
                $normal_array_of_dates[$formatted_value]['unix'] = $value->format('U');
                //$normal_array_of_dates[$formatted_value]['iso_full'] = $value->format('Y-m-d H:i:s');
                //$normal_array_of_dates[$formatted_value]['iso_date'] = $value->format('Y-m-d');
                
                unset($formatted_value);
                $i++;
            }
            
            
            if (empty($list))
                $list = [];
            
            $formatted_shifts_arr = [];
           
            
            //foreach period
            foreach ($normal_array_of_dates as $key_day => $one_date) {
                $normal_array_of_dates[$key_day]['is_holiday45'] = $this->checkDateHoliday('45', $key_day);
                $normal_array_of_dates[$key_day]['is_holiday90'] = $this->checkDateHoliday('90', $key_day);
                
                
                
                        
                foreach ($list_raw as $key => $shift) {
                    //unset($normal_array_of_dates[$key_day]['show_av_button']);
                    $shift_start_dt = new DateTime($shift->start);
                    $shift_start_unix = strtotime($shift_start_dt->format('Y-m-d'));
                    $shift_end_dt = new DateTime($shift->end);
                    $shift_end_unix = strtotime($shift_end_dt->format('Y-m-d'));
                   
                  
                    
                    if($one_date['unix'] >= $shift_start_unix && $one_date['unix'] <= $shift_end_unix){  
                        
                        if ($shift->status === 'api_suggested') {
                            $shift->status = 'Pending';
                        } elseif ($shift->status === 'New') {
                            $shift->status = 'Confirmed';
                        } 
                        $final = $this->reverseConvertDates($shift->start, $shift->end);
                        $times = $this->convertDatesToTime($shift->start, $shift->end);
                        $unix_dates = $this->convertDatesToUnix(trim($shift->start), trim($shift->end));
                        
                        $shift->start_converted = $final->start;
                        $shift->end_converted = $final->end;
                    
                        $shift->start_time = $times->start;
                        $shift->end_time = $times->end;
                        $shift->icon_date = json_decode($shift->icon_date, true);
                        if (empty($shift->icon_date)){
                            $shift->icon_date = [];
                        }
                        
                        $normal_array_of_dates[$key_day]['total_hours_on_date'] = $this->calcTotalAsOneDate($user_id, $shift, $unix_dates)['formatted'];
                        $total_hours += $this->calcTotalAsOneDate($user_id, $shift, $unix_dates)['float'];          
                        $normal_array_of_dates[$key_day]['info'] = (array)$shift;
                         
                    
                        if ($enable_attach_task_to_shedules == '1') {
                            $normal_array_of_dates[$key_day]['info']['tasks'] = $this->loadAttachedTasksForSchedules($user_id, $shift->id); 
                        }
                        
                        
                    }
                }
                
            }
            if (!empty($normal_array_of_dates)) {
                $exploded_total_hours = explode('.', $total_hours);
                if (count($exploded_total_hours) > 1) {
                    $normal_array_of_dates['total_hours'] = $exploded_total_hours[0] . ':' . $exploded_total_hours[1];
                } else {
                    $normal_array_of_dates['total_hours'] = $exploded_total_hours[0];
                }
            }

            $normal_array_of_dates['colors'] = [
                'weekends' => '#d6c294',
                'holidays45' => '#7cb2b3',
                'holidays90' => '#c59a85'
            ];
            
            if($enable_orange_ellipsis_in_schedules_page_and_app_api == '1'){
                foreach ($normal_array_of_dates as $key_day => $one_date) {
                    if(isset($one_date['info']) && count($one_date['info']) > 0){
                        $normal_array_of_dates[$key_day]['show_av_button'] = 0;
                    } else{
                        //echo $key_day.PHP_EOL;
                        $not_permitted_fields = [
                            'total_hours',
                            'colors'
                        ];
                        
                        if(!in_array($key_day, $not_permitted_fields)){
                            $normal_array_of_dates[$key_day]['show_av_button'] = $this->checkAvButtonVisibylity($key_day, (int)$user_id);
                            if($normal_array_of_dates[$key_day]['show_av_button'] == 1){
                                $normal_array_of_dates[$key_day]['available_schedules'] = $available_schedules_all[$key_day];
                            }
                        }
                        
                    }
                    
                }
            }
            
            return $normal_array_of_dates;
            
        } else {
            $query = "SELECT `id`, `start`, `end`, `status`, `shift_name`, `shift_color`, `icon_date`, `room_id` FROM `#__com_shifts_reservations` WHERE `room_id` = " . $this->db->quote($user_id) . "  ORDER BY `start` ASC";
            $this->db->setQuery($query);
            $list_raw = $this->db->loadObjectList();
            $enable_attach_task_to_shedules = $this->config->get('enable_attach_task_to_shedules');

            $from_to_unix = $this->convertDatesToUnix2($from, $to);


            if (empty($list))
                $list = [];

            foreach ($list_raw as $key => $reservation) {
                $final = $this->reverseConvertDates($reservation->start, $reservation->end);
                $unix_dates = $this->convertDatesToUnix(trim($reservation->start), trim($reservation->end));
                $times = $this->convertDatesToTime($reservation->start, $reservation->end);

                if ($unix_dates->start >= $from_to_unix->start && $unix_dates->end <= $from_to_unix->end) {//point
                    /* echo '<pre>$from_to_unix from:';
                      print_r(date('d.m.Y H:i:s', $from_to_unix->start));
                      echo '</pre>';

                      echo '<pre>$from_to_unix from:';
                      print_r(date('d.m.Y H:i:s', $from_to_unix->end));
                      echo '</pre>'; */

                    $reservation->start_converted = $final->start;
                    $reservation->end_converted = $final->end;

                    $reservation->start_time = $times->start;
                    $reservation->end_time = $times->end;

                    $reservation->start_timestamp = $unix_dates->start;
                    $reservation->end_timestamp = $unix_dates->end;

                    if ($reservation->status === 'api_suggested') {
                        $reservation->status = 'Pending';
                    } elseif ($reservation->status === 'New') {
                        $reservation->status = 'Confirmed';
                    }
                    $reservation->icon_date = json_decode($reservation->icon_date, true);
                    if (empty($reservation->icon_date))
                        $reservation->icon_date = array();


                    $list[$key] = (array) $reservation;


                    if ($enable_attach_task_to_shedules == '1') {
                        $list[$key]['tasks'] = $this->loadAttachedTasksForSchedules($user_id, $reservation->id);
                    }


                    //$list[$key]['total_hours_for_schedule'] = $this->calcTotal($user_id, $reservation, $unix_dates);
                    $list[$key]['total_hours_on_date'] = $this->calcTotalAsOneDate($user_id, $reservation, $unix_dates)['formatted'];
                    $total_hours += $this->calcTotalAsOneDate($user_id, $reservation, $unix_dates)['float'];
                    //$list[$key]['total_hours_on_date'] = $this->calcTotalAsOneDate($user_id, $reservation, $unix_dates);
                }
            }

            if (!empty($list)) {
                $exploded_total_hours = explode('.', $total_hours);
                if (count($exploded_total_hours) > 1) {
                    $list['total_hours'] = $exploded_total_hours[0] . ':' . $exploded_total_hours[1];
                } else {
                    $list['total_hours'] = $exploded_total_hours[0];
                }
            }



            return $list;
        }
    }
    
    private function checkAvButtonVisibylity(string $date_string, int $user_id): int
    {
        $date = DateTime::createFromFormat('d.m.Y H:i:s', $date_string . '00:00:00');
        $user_obj = JFactory::getUser($user_id);
     
        $query = "SELECT * FROM #__com_shifts_available_buttons_state WHERE `manager_id` = '".$user_obj->owner_id."' AND `cell_date`= '".$date->format('Y-m-d')."' ORDER BY `id` ASC";  
        $this->db->setQuery( $query );
        $res = $this->db->loadObjectList();
        
        
        return (int)$res[0]->available_button_state;
    }
    
    private function checkDateHoliday($type, $date)
    {
        //point
        $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');
        //return $date_obj->format('Y-m-d');
        
        $query_h = "SELECT title, CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop,
        holidays_type_90, holidays_type_45
        FROM #__holiday WHERE date = '" . $date_obj->format('Y-m-d') . "' AND published = '1' AND language = 'all'";

                            
        $this->db->setQuery($query_h);
        $holiday_h1 = $this->db->loadObjectList();
        
        if(!empty($holiday_h1[0])){
            $is_90 = $holiday_h1[0]->holidays_type_90;
            $is_45 = $holiday_h1[0]->holidays_type_45;
            
           if($type == '45'){
               $res = $is_45;
           } elseif($type == '90'){
               $res = $is_90;
           } else{
               $res = false;
           }
        } else{
            $res = 0;
        }
        
        return $res;
    }
    
    private function toFixed($number, $decimals) 
    {
        return number_format($number, $decimals, '.', "");
    }
    
    //calc total for one schedule
    private function calcTotal($user_id, $schedule_object, $unix_dates)
    {
        
        $start_unix = $unix_dates->start;
        $end_unix = $unix_dates->end;
        
        $start_date = date('Y-m-d H:i:s', $start_unix);
        $end_date = date('Y-m-d H:i:s', $end_unix);
        
        $start_hours = date('H:i:s', $start_unix);
        $end_hours = date('H:i:s', $end_unix);
        
        $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $interval_on_days_obj = $date2->diff($date1);
        $interval_on_days = $interval_on_days_obj->days + 1;
        
        
        $custom_start = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d '.$start_hours));
        $custom_end = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d '.$end_hours));
        $diff_in_hours = $custom_start->diff($custom_end);

        if($diff_in_hours->format('%a') > 0){
            $hour1 = $diff_in_hours->format('%a') * 24;
        }
        if($diff_in_hours->format('%h.%i') > 0){  
            $hour2 = $diff_in_hours->h . '.' . $diff_in_hours->i;
        }
        
        $shift_time = $diff_in_hours->h.':'.$diff_in_hours->i;
        $shift_time_sec = strtotime("1970-01-01 $shift_time UTC");
        $shift_total_sec = $shift_time_sec * $interval_on_days; 
        //$shift_time_sec = $shift_total_sec;
        $zero    = new DateTime("@0");
        $offset  = new DateTime("@$shift_total_sec");
        $diff    = $zero->diff($offset);
        
        return [
            'formatted' => sprintf("%02d:%02d", $diff->days * 24 + $diff->h, $diff->i),
            'float' => sprintf("%02d.%02d", $diff->days * 24 + $diff->h, $diff->i),
            '$start_date' => $start_date,
            '$end_date' => $end_date,
            '$interval_on_days' => $interval_on_days
        ];
 
    }
    
    private function getDkTaskList()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasks();
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    public function getPrepareUserListNewPsd()
    {
        $query = "SELECT * FROM #__users WHERE `owner_id` = '".$this->user->owner_id."' AND `id`!='".$this->user->owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    private function getSortedDkTaskList()
    {
         $config = &JFactory::getConfig();  
        //$enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        if($this->user->sync_dk_tasks != 1){
            $data = [];
            return json_encode($data);
        }
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    //point
    private function loadAttachedTasksForSchedules($user_id, $schift_id)
    {
        $args = func_get_args();
        $lang = $args[0];
        
        JLoader::register('AuditModelCollect', JPATH_ROOT . '/components/com_audit/models/collect.php');
        $model = JModelLegacy::getInstance('Collect', 'AuditModel');
        $res = $model->getAttachedTasksListForShiftsForAppApi('en',  $schift_id, $user_id, 'only_attached');
      
        return $res; 
    }
    
    public function getHolidayApi($user_id, $id)
    {
        $query = "SELECT `id`, `start`, `end`, `status` FROM `reservations` WHERE `id`='$id' AND `room_id` = '$user_id'";
        $this->db->setQuery($query);
        $reservation = $this->db->loadObject();
        
        $final=$this->reverseConvertDates($reservation->start, $reservation->end);
        $reservation->start=$final->start;
        $reservation->end=$final->end;
        
        if($reservation->status==='api_suggested'){
            $reservation->status='Pending';
        } elseif($reservation->status==='New'){
            $reservation->status='Confirmed';
        }
        
        return $reservation;
    }
    
    private function reverseConvertDates($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        $from_date = $from_date_raw->format('d.m.Y');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        $to_date = $to_date_raw->format('d.m.Y');
        
        return (object)[
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    private function convertDatesToTime($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        $from_date = $from_date_raw->format('H:i');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        $to_date = $to_date_raw->format('H:i');
        
        return (object)[
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }

    private function convertDatesToUnix($from, $to)
    {
        /*$from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        $from_date = $from_date_raw->format('U');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        $to_date = $to_date_raw->format('U');*/
        
        $from_date_raw = strtotime($from);
        $to_date_raw = strtotime($to);
        
        return (object)[
            'start'=>$from_date_raw,
            'end'=>$to_date_raw
        ];
    }
    
    private function convertDatesToUnix2($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('d.m.Y H:i:s', $from.' 00:00:00');
        $from_date = $from_date_raw->format('U');
       

        $to_date_raw = DateTime::createFromFormat('d.m.Y H:i:s', $to.' 00:00:00');
        $to_date = $to_date_raw->format('U');
        
       
        
        return (object)[
            'start' => $from_date,
            'end' => $to_date
        ];
    }
    
    public function getShiftApi($user_id, $id)
    {
        $query = "SELECT `id`, `start`, `end`, `status`, `shift_name`, `shift_color` FROM `#__com_shifts_reservations` WHERE `id`='$id' AND `room_id` = '$user_id'";
        $this->db->setQuery($query);
        $reservation = $this->db->loadObject();
        
        $final = $this->convertShiftDate($reservation->start, $reservation->end);
        $times = $this->convertDatesToTime($reservation->start, $reservation->end);
        $unix_dates = $this->convertDatesToUnix(trim($reservation->start), trim($reservation->end));
        
        $reservation->start_converted = $final->start;
        $reservation->end_converted = $final->end;
        
        $reservation->start_time = $times->start;
        $reservation->end_time = $times->end;
        
        $reservation->start_timestamp = $unix_dates->start;
        $reservation->end_timestamp = $unix_dates->end;
            
        if($reservation->status === 'api_suggested'){
            $reservation->status = 'Pending';
        } elseif($reservation->status === 'New'){
            $reservation->status = 'Confirmed';
        }
        
        $reservation->icon_date = json_decode($reservation->icon_date,true);
        if(empty($reservation->icon_date))
            $reservation->icon_date  =  array();

        return $reservation;
    }
    
    private function convertShiftDate($from, $to)
    {
        $from_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $from);
        $from_date = $from_date_raw->format('d.m.Y');
       

        $to_date_raw = DateTime::createFromFormat('Y-m-d H:i:s', $to);
        $to_date = $to_date_raw->format('d.m.Y');
        
        return (object)[
            'start'=>$from_date,
            'end'=>$to_date
        ];
    }
    
    private function plus1Day($date)
    {
        $date_obj = DateTime::createFromFormat('d.m.Y H:i', $date.' 00:01');
        
        return date('d.m.Y H:i', strtotime($date_obj->format('Y-m-d H:i').''));
    }
    
    public function setShiftMessage($user_id, $date, $type, $lang, $message, $write_date_sended = false)
    {
        $to_date = $this->plus1Day($date);
        $dates_arr = $this->convertDatesShifts($date.' 00:00', $to_date); 
        $check_period = $this->checkPeriodShifts($dates_arr, $user_id);
       
        if($check_period == 0){
            $start = $dates_arr['from'];
            $end = $dates_arr['to']; 
            $name = 'holiday';
            $room = (int)$user_id;
        
            $item = new stdClass();
            $response = new stdClass();
        
            $item->id = null;
            $item->name = $name;
            $item->start = $start;
            $item->end = $end;
            $item->room_id = $room;
            $item->status = 'pending_available';
            $item->paid = 0;
            $item->shift_color = 'transparent';
            $item->shift_name = 'Daytime';
            $item->shift_message = $this->db->escape($message);
            
            if($write_date_sended === true){
                $item->message_time = time();
                $item->message_date = date('d.m.Y H:i:s');
            }
            if($this->db->insertObject('#__com_shifts_reservations', $item)){
                $insert_id = $this->db->insertid();
                //$response->message = 'Created with id: '.$insert_id;
                $response->insert_id = $insert_id;
                $response->type = 'success';
            }
            return (array)$response;
        } else{
            return 'error-0';
        }
    }
    
    private function loadManagerUsers($manager_id)
    {
        $query = "SELECT * FROM `#__users` WHERE `owner_id` = '".$this->db->escape($manager_id)."' AND `id` !='".$this->db->escape($manager_id)."'  ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $res = $this->db->loadAssocList();
        
        return $res;
    }
    
    private function convertDateToUnix($date)
    {
        $date_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date.'00:00:00');
        
        return $date_obj->format('U');
    }
    
    private function getUsername($user_id)
    {
        $user_obj = JFactory::getUser($user_id);
        
        $user_from_request_name = '';
        if (!empty($user_obj->username0)) {
            $user_from_request_name = $user_obj->username0;
        } elseif (!empty($user_obj->username)) {
            $user_from_request_name = $user_obj->username;
        } elseif (!empty($user_obj->name)) {
            $user_from_request_name = $user_obj->name;
        } else{
            $user_from_request_name = 'empty_username';
        }
        
        return $user_from_request_name;
    }
    
    //hh6
    public function getCompanySchedulesAsDate($manager_id, $date)
    {
        $manager_users = $this->loadManagerUsers($manager_id);
        $final_imploded = [];
         
        foreach($manager_users as $one_user){
            $final_imploded[$one_user['id']] = $one_user['id'];
        }
        $user_ids = implode(",", $final_imploded);
        
        $query = "SELECT `id`, `start`, `end`, `status`, `shift_color`, `room_id` FROM `#__com_shifts_reservations` WHERE `room_id` IN(" . $user_ids . ")  ORDER BY `start` ASC";
        $this->db->setQuery($query);
        $list_raw = $this->db->loadObjectList();
        
        $enable_attach_task_to_shedules = $this->config->get('enable_attach_task_to_shedules');
        $converted_date = $this->convertDateToUnix($date);
      
        $from_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');
        $to_obj = DateTime::createFromFormat('d.m.Y H:i:s', $date . '23:59:59');
        $raw_date = DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');    
          
       
       
        $final = [];
        $dates = [];
        
        if(empty($list)){
            $list = [];
        }
            
        
        
       
        
        foreach ($list_raw as $key => $reservation) {
            $final1 = $this->reverseConvertDates($reservation->start, $reservation->end);
            $unix_dates = $this->convertDatesToUnix(trim($reservation->start), trim($reservation->end));
            $times = $this->convertDatesToTime($reservation->start, $reservation->end);
            $user_id = $reservation->room_id;
            ///
            $schedule_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', $reservation->start);
            $schedule_end_obj  = DateTime::createFromFormat('Y-m-d H:i:s', $reservation->end);
            $schedule_start_obj_unix = $schedule_start_obj->format('U');
            $schedule_end_obj_unix = $schedule_end_obj->format('U');
            
            $period = new DatePeriod(
                new DateTime($schedule_start_obj->format('Y-m-d H:i:s')),
                new DateInterval('P1D'),
                new DateTime($schedule_end_obj->format('Y-m-d H:i:s'))
            );
            
            $normal_array_of_dates = [];
            $i = 0;
                    
                    
            foreach ($period as $key => $value) {
                $normal_array_of_dates[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                $normal_array_of_dates[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                $normal_array_of_dates[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                $i++;
            }
            
            if(count($normal_array_of_dates) == 1 && $schedule_start_obj_unix >= $date_unix_start && $schedule_end_obj_unix <= $date_unix_end){
               
                $final_schedules[] = $reservation;
                //$final_schedules_one_dates[] = $reservation;
            } elseif(($schedule_start_obj_unix <= $date_unix_start && $schedule_end_obj_unix >= $date_unix_end) || in_array($raw_date->format('d.m.Y'), array_column($normal_array_of_dates, 'date'))){
                
                
                //$final_schedules_multi_dates[] = $reservation;
                $final_schedules[] = $reservation;
            }
         
         
           
        }
        
      
        $i = 0;
        foreach($final_schedules as $key => $reservation){
            $final1 = $this->reverseConvertDates($reservation->start, $reservation->end);
            $unix_dates = $this->convertDatesToUnix(trim($reservation->start), trim($reservation->end));
            $times = $this->convertDatesToTime($reservation->start, $reservation->end);
            $user_id = $reservation->room_id;
            
             $reservation->requested_date = $date;
                
                $reservation->start_converted = $final1->start;
                $reservation->end_converted = $final1->end;

                $reservation->start_time = $times->start;
                $reservation->end_time = $times->end;

                $reservation->start_timestamp = $unix_dates->start;
                $reservation->end_timestamp = $unix_dates->end;

                if ($reservation->status === 'api_suggested') {
                    $reservation->status = 'Pending';
                } elseif ($reservation->status === 'New') {
                    $reservation->status = 'Confirmed';
                }
                
                $reservation->user_id = $reservation->room_id;
                $reservation->username = $this->getUsername($user_id);
                
                unset($reservation->room_id);
                
                $final[$i] = (array) $reservation;

               
                if ($enable_attach_task_to_shedules == '1') {
                    $final[$i]['tasks'] = $this->loadAttachedTasksForSchedules($user_id, $reservation->id);
                } 
                
                //calculate totals for one date(but not one schedule)
                $final[$i]['total_hours_for_date'] = $this->calcTotalAsOneDate($user_id, $reservation, $unix_dates)['formatted'];
                
                //calc total for one schedule
                //$total_for_schedule += $this->calcTotal($user_id, $reservation, $unix_dates)['float'];
                
                $i++;
        }
        
        //calculate totals from month by requested date
        $final['total_hours_for_month'] = $this->calcMonthlyTotalAsDate($date, $list_raw, $converted_date)['total_for_schedule'];
        //$final['total_hours_for_month'] = $this->calcMonthlyTotalAsDate($date, $list_raw, $converted_date); 
        //$final['total_hours_for_month'] = $total_for_schedule;
        
        return $final;
       
    }
    
    //hh6
    private function calcMonthlyTotalAsDate($date, $schedules_object, $converted_date)
    {
       
        $date_object = DateTime::createFromFormat('d.m.Y H:i:s', $date.' 00:00:00');
        $month = $date_object->format('m');
        $year = $date_object->format('Y');
        
        $month_first_date = DateTime::createFromFormat('d.m.Y H:i:s', '01.'.$month.'.'.$year.' 00:00:00');
        $month_last_date_obj = clone $month_first_date;
        $month_last_date = $month_last_date_obj->modify('last day of this month, 23:59:59');
        
        $i = 0;
        $total_for_schedule = 0;
        $filtered_schedules = [];
        
        foreach ($schedules_object as $key => $reservation) {
            //$final1 = $this->reverseConvertDates($reservation->start, $reservation->end);
            //hh6
            if($reservation->end == '0000-00-00 00:00:00'){
                continue;
            }
            $unix_dates = $this->convertDatesToUnix(trim($reservation->start), trim($reservation->end));
            /*echo '<pre>';
            print_r($reservation);
            echo '</pre>';*/
            //$times = $this->convertDatesToTime($reservation->start, $reservation->end);
            $user_id = $reservation->room_id;
            
        
            
            
            if ($unix_dates->start >= $month_first_date->format('U') && $unix_dates->end <= $month_last_date->format('U') ) {
                $total_for_schedule += $this->calcTotal($user_id, $reservation, $unix_dates)['float'];
                $filtered_schedules[] = $reservation;
                
                        
                $i++;
            }
        }
        
        $total_for_schedule_arr = explode('.', $total_for_schedule);
        if(count($total_for_schedule_arr) > 1){
            $total_for_schedule = $total_for_schedule_arr[0] . ':' . $total_for_schedule_arr[1];
        } else{
            $total_for_schedule = $total_for_schedule_arr[0];
        }
        
        return [
            //'$schedules_object' => $schedules_object,
            '$filtered_schedules' => $filtered_schedules,
            'total_for_schedule' => $total_for_schedule,
            
            '$unix_dates->start' => date('d.m.Y H:i:s', $unix_dates->start),
            '$month_first_date' => $month_first_date->format('d.m.Y H:i:s'),
            '$unix_dates->end' => date('d.m.Y H:i:s', $unix_dates->end),
            '$month_last_date' => $month_last_date->format('d.m.Y H:i:s'),
            
        ];
    }
    
    private function calcTotalAsOneDate($user_id, $schedule_object, $unix_dates)
    {
        $start_unix = $unix_dates->start;
        $end_unix = $unix_dates->end;
        
        $start_date = date('Y-m-d H:i:s', $start_unix);
        $end_date = date('Y-m-d H:i:s', $end_unix);
        
        $start_hours = date('H:i:s', $start_unix);
        $end_hours = date('H:i:s', $end_unix);
        
       /* $date1 = new DateTime($start_date);
        $date2 = new DateTime($end_date);
        $interval_on_days = $date1->diff($date2) + 1;*/
        
        $custom_start = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d '.$start_hours));
        $custom_end = DateTime::createFromFormat('Y-m-d H:i:s', date('Y-m-d '.$end_hours));
        $diff_in_hours = $custom_start->diff($custom_end);

        if($diff_in_hours->format('%a') > 0){
            $hour1 = $diff_in_hours->format('%a') * 24;
        }
        if($diff_in_hours->format('%h.%i') > 0){  
            $hour2 = $diff_in_hours->h . '.' . $diff_in_hours->i;
        }
        
        $shift_time = $diff_in_hours->h.':'.$diff_in_hours->i;
        $shift_time_sec = strtotime("1970-01-01 $shift_time UTC");
        $shift_total_sec = $shift_time_sec * 1; //old is $interval_on_days
        //$shift_time_sec = $shift_total_sec;
        $zero    = new DateTime("@0");
        $offset  = new DateTime("@$shift_total_sec");
        $diff    = $zero->diff($offset);
        
        return [
            'formatted' => sprintf("%02d:%02d", $diff->days * 24 + $diff->h, $diff->i),
            'float' => sprintf("%02d.%02d", $diff->days * 24 + $diff->h, $diff->i)
        ];

    }
    
    private function loadSchedulesByDate($date_obj, $user_id)
    {
        //$raw_date = DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');
        $date_unix = $date_obj->format('U');
        
        $query = "SELECT * FROM `#__com_shifts_reservations` WHERE `room_id` IN(" . $user_id . ") AND (UNIX_TIMESTAMP(start) >= '".$date_unix . "' OR (UNIX_TIMESTAMP(end) > '".$date_unix."' && UNIX_TIMESTAMP(start) <= '".$date_unix . "')) ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $schedules = $this->db->loadObjectList();
        
        return $schedules; 
        
    }
    
    private function removeWhiteSchedule($schedule_obj)
    {
        $query = "DELETE FROM #__com_shifts_reservations WHERE `id` = '".$schedule_obj->id."';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function addYellowIcon($schedule_obj, $date_obj, $message, $write_date_sended = false)
    {
        
        $icon_date_arr = [
            $date_obj->format('d.m.Y') => ['date' => $date_obj->format('Y-m-d')]
        ];
        if(empty($icon_date_arr)){
            $icon_date_arr  =  [];
        }
               
        /*if(empty($date) == false && strlen($date) > 4) {
            if(!isset($icon_date_arr[$icon_date])){
                $icon_date_arr[$icon_date] = [
                    'date' => date("Y-m-d", strtotime($icon_date))
                ];
            }
                    
        }*/
        $item = new stdClass();
        $item->id = (int)$schedule_obj->id;
        $item->icon_date = json_encode($icon_date_arr);
        $item->start = $schedule_obj->start;
        $item->end = $schedule_obj->end;           
        $item->shift_message = strip_tags($this->db->escape($message));
        if($write_date_sended === true){
            $item->message_time = time();
            $item->message_date = date('d.m.Y H:i:s');
        }
        
        $this->db->updateObject('#__com_shifts_reservations', $item, 'id');     
            
        $response = new stdClass();
        $response->insert_id = $item->id;
        $response->type = 'success';
        
        return $response;
    }
    
    public function addScheduleMessageForApi($user_id, $lang, $shift_color, $shift_name, $date, $message, $icon_date  =  "")
    {
       
        $status = '';
        $raw_date = DateTime::createFromFormat('d.m.Y H:i:s', $date . '00:00:00');
       
        $date_end_obj = clone $raw_date;
        $date_end = $date_end_obj->modify('+23 hours 59 minutes');
       
        
        $schedule_by_date = $this->loadSchedulesByDate($raw_date, $user_id);
        $date_unix_start = $raw_date->format('U');//start date unix
        $date_unix_end = $date_end->format('U');//end date unix
      
        
        $final_schedules_one_dates = [];
        $final_schedules_multi_dates = [];
       
        $current_time = time();
        $current_time_object = DateTime::createFromFormat('U', $current_time);
            
        foreach($schedule_by_date as $one_schedule){
           
           // $startTime = strtotime($one_schedule->start);
            //$endTime = strtotime($one_schedule->end);
            
            $schedule_start_obj = DateTime::createFromFormat('Y-m-d H:i:s', $one_schedule->start);
            $schedule_end_obj  = DateTime::createFromFormat('Y-m-d H:i:s', $one_schedule->end);
            $schedule_start_obj_unix = $schedule_start_obj->format('U');
            $schedule_end_obj_unix = $schedule_end_obj->format('U');
            
            $period = new DatePeriod(
                new DateTime($schedule_start_obj->format('Y-m-d H:i:s')),
                new DateInterval('P1D'),
                new DateTime($schedule_end_obj->format('Y-m-d H:i:s'))
            );
                    
                  
            $normal_array_of_dates = [];
            $i = 0;
                    
                    
            foreach ($period as $key => $value) {
                $normal_array_of_dates[$value->format('d.m.Y')]['with_seconds'] = $value->format('d.m.Y H:i:s');
                $normal_array_of_dates[$value->format('d.m.Y')]['date'] = $value->format('d.m.Y');
                $normal_array_of_dates[$value->format('d.m.Y')]['unix'] = $value->format('U');
                        
                $i++;
            }
           
            
            //if($schedule_start_obj_unix <= $date_unix_end){
            if(count($normal_array_of_dates) == 1 && $schedule_start_obj_unix >= $date_unix_start && $schedule_end_obj_unix <= $date_unix_end){
               
            
                $final_schedules_one_dates[] = $one_schedule;
             } 
             //  if(in_array($current_time_object->format('d.m.Y'), array_column($normal_array_of_dates, 'date')) && ($current_time >= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] && $current_time <= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] + 60)){
             elseif(($schedule_start_obj_unix <= $date_unix_start && $schedule_end_obj_unix >= $date_unix_end) || in_array($raw_date->format('d.m.Y'), array_column($normal_array_of_dates, 'date')) /*&& ($current_time >= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] /*&& $current_time <= $normal_array_of_dates[$current_time_object->format('d.m.Y')]['unix'] + 60))*/){
                /*echo '<pre>$one_schedule1:';
                print_r($one_schedule);
                echo '</pre>';
                
                echo 'From1:' . date('d.m.Y H:i:s', $schedule_start_obj_unix).PHP_EOL;
                echo 'To1:' . date('d.m.Y H:i:s', $schedule_end_obj_unix).PHP_EOL;*/
                
                $final_schedules_multi_dates[] = $one_schedule;
            }
        }
        
       
        
        $count_schedules = count($final_schedules_one_dates);
        $count_multi_dates_schedules = count($final_schedules_multi_dates);
        $res = '';
        
        //not forget rewrite messages if send 10!
        if($count_schedules > 0){
            //throw new Exception('Dates overlap an existing period!');
            $status = '';
            
            //remove and add message on (!) small white icon
            if($count_schedules == 1 && $final_schedules_one_dates[0]->status == 'pending_available'){
                $this->removeWhiteSchedule($final_schedules_one_dates[0]);
                $write_date_sended = true;
                $res = $this->setShiftMessage($user_id, $date, $type = '', $lang, $message, $write_date_sended);
                return $res;
            } elseif($count_schedules == 1 && $final_schedules_one_dates[0]->status == 'New'){//add yellow (!) icon to existing one date standart schedule
                $write_date_sended = true;
                $res = $this->addYellowIcon($final_schedules_one_dates[0], $raw_date, $message, $write_date_sended);
                return $res;
            } 
        } 
        
        if($count_multi_dates_schedules > 0){
            //remove and add message on (!) small white icon
            if($count_multi_dates_schedules == 1 && $final_schedules_multi_dates[0]->status == 'pending_available'){
                
            } elseif($count_multi_dates_schedules == 1 && $final_schedules_multi_dates[0]->status == 'New'){//add yellow (!) icon to existing one date standart schedule
                $write_date_sended = true;
                $res = $this->addYellowIcon($final_schedules_multi_dates[0], $raw_date, $message, $write_date_sended);
                return $res;
            }
        }
        
        if($count_schedules == 0){
            $write_date_sended = true;
            $res = $this->setShiftMessage($user_id, $date, $type = '', $lang, $message, $write_date_sended);
        }
        
        return $res; 
    }
    
    public function getAvailableSchedulesAsDate(object $user_obj, string $date)
    {
        //$user_manager = JFactory::getUser($user_obj->owner_id);
        
        $query_h = "SELECT `id`, `date`, `schedule_value`, `schedule_color` FROM #__com_shifts_av_shedules WHERE `manager_id` = '".$user_obj->owner_id."' AND `date` = '$date' ORDER BY `id` ASC";         
        $this->db->setQuery( $query_h );
        $res = $this->db->loadObjectList();
        
        return $res;
    }
}
