<?php

/**
 * @version     1.0.0
 * @package     com_shifts_1.0.0_j3x
 * @copyright   Copyright (C) 2020. All rights reserved.
 * @license     Proprietary software license
 * @author      developer3452 <developer3452@gmail.com> - #
 */
// No direct access
defined('_JEXEC') or die;

jimport('joomla.application.component.controller');

class ShiftsController extends JControllerLegacy {
    
    protected static $db1; 
    protected static $user1;
    protected static $app_static;


    public function __construct($config = array()) {

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->sitename = empty($_SERVER['HTTPS']) ? 'http://' : 'https://' . $_SERVER['SERVER_NAME'];
        
        self::$db1 = &JFactory::getDBO();
        self::$user1 = & JFactory::getUser();
        self::$app_static = JFactory::getApplication();
        
        parent::__construct($config);
    }

    /**
     * Method to display a view
     *
     * @param   bool  $cachable   If true, the view output will be cached
     * @param   bool  $urlparams  An array of safe url parameters and their variable types, for valid values see {@link JFilterInput::clean()}
     *
     * @return  JControllerLegacy This object to support chaining
     *
     * @since   1.5
     */
    public function display($cachable = false, $urlparams = false) {
        return parent::display($cachable, $urlparams);
    }

    private function filter_input_fix($type, $variable_name, $filter = FILTER_DEFAULT, $options = NULL) {
        $checkTypes = [
            INPUT_GET,
            INPUT_POST,
            INPUT_COOKIE
        ];

        if ($options === NULL) {
            // No idea if this should be here or not
            // Maybe someone could let me know if this should be removed?
            $options = FILTER_NULL_ON_FAILURE;
        }

        if (in_array($type, $checkTypes) || filter_has_var($type, $variable_name)) {
            return filter_input($type, $variable_name, $filter, $options);
        } else if ($type == INPUT_SERVER && isset($_SERVER[$variable_name])) {
            return filter_var($_SERVER[$variable_name], $filter, $options);
        } else if ($type == INPUT_ENV && isset($_ENV[$variable_name])) {
            return filter_var($_ENV[$variable_name], $filter, $options);
        } else {
            return NULL;
        }
    }

    /**
     * Proxy for getModel.
     * @since	1.6
     */
    public function &getModel($name = 'views', $prefix = 'Spec_holiday2Model') {
        $model = parent::getModel($name, $prefix, array('ignore_request' => true));
        return $model;
    }
    
    public static function &getModel1($name = 'views', $prefix = 'Spec_holiday2Model') {
        $model = parent::getModel($name, $prefix, array('ignore_request' => true));
        return $model;
    }

    

    public function getLayoutGroupsConfirm() {
        $jinput = JFactory::getApplication()->input;
        $model = $this->getModel();
        $lang = $jinput->get('lang', '', 'STRING');
        $html = $model->getLayoutGroups($lang);

        print_r(json_encode([
            'html' => $html
        ]));
        JFactory::getApplication()->close();
    }

    public function movePeriod() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->movePeriod();

        print_r(json_encode($res));
        JFactory::getApplication()->close();
    }

    public function resizePeriod() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->resizePeriod();

        print_r(json_encode($res));

        JFactory::getApplication()->close();
    }

    public function deletePeriod() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->deletePeriod();

        print_r(json_encode($res));
        JFactory::getApplication()->close();
    }

    public function addPeriod() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->addPeriod();

        print_r(json_encode($res));

        JFactory::getApplication()->close();
    }

    public function editPeriod() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->editPeriod();

        print_r(json_encode($res));

        JFactory::getApplication()->close();
    }

    public function loadEnevts() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->loadEnevts();

        print_r(json_encode($res));
        JFactory::getApplication()->close();
    }

    public function loadRooms() {
        header('Content-Type: application/json');

        $model = $this->getModel('Tthtml5');
        $res = $model->loadRooms();

        print_r(json_encode($res));
        JFactory::getApplication()->close();
    }
    
    public static function loadRoomsStatic() {
        header('Content-Type: application/json');

        $department_obj = self::$app_static->input->getString('dep');
        $department_arr = isset($department_obj) ? $department_obj : '';
        $owner_id = self::$user1->owner_id;
        
        if(in_array(6, self::$user1->groups) || in_array(10, self::$user1->groups)){
            $query = "SELECT * FROM #__users WHERE `owner_id` = '$owner_id' AND `is_hide`='0' AND `id`!='$owner_id' ORDER BY `username0` ASC";
            self::$db1->setQuery($query);
            $rooms = self::$db1->loadAssocList();
        } elseif(in_array(2, self::$user1->groups)){
            $query = "SELECT * FROM #__users WHERE `id` = '".self::$user1->id."' AND `is_hide`='0' AND `id`!='$owner_id' ORDER BY `username0` ASC";
            self::$db1->setQuery($query);
            $rooms = self::$db1->loadAssocList();
        }
        
        
        $result = array();

        foreach ($rooms as $room) {
            if (!empty($department_arr) && !in_array($room['group_user'], $department_arr)){
                continue;
            }

            $r = new stdClass();
            $r->id = $room['id'];
            
            if(!empty($room['username0'])){ $final_username=$room['username0']; } 
            elseif(!empty($room['username'])){ $final_username=$room['username']; }
            elseif(!empty($room['name'])){ $final_username=$room['name']; }
            
            $r->name = $final_username;
            $r->capacity = 1;
            $r->status = 2;
            $r->user_position_icon = $room['user_position_icon'];
            $result[] = $r;
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/tthtml5.html', print_r($result, true), FILE_APPEND | LOCK_EX);

        return json_encode($result);
    }

    public function setHolidayApi() {
        header('Content-Type: application/json');
        $user_id = (int) $_REQUEST['u_id'];
        $from = $_REQUEST['from'];
        $to = $_REQUEST['to'];
        $model = $this->getModel('App_api');

        $res = $model->setHolidayApi($user_id, $from, $to);


        echo json_encode($res);
        JFactory::getApplication()->close();
    }

    public function getHolidayApi() {
        header('Content-Type: application/json');
        $user_id = (int) $_REQUEST['u_id'];
        $id = (int) $_REQUEST['id'];

        $model = $this->getModel('App_api');

        $res = $model->getHolidayApi($user_id, $id);
        echo json_encode($res);
        JFactory::getApplication()->close();
    }
    
    public function updateComShiftsHeader()
    {
        $shift_header = $this->app->input->getString('value');
        $input_id = $this->app->input->getString('id');
        $perm_arr = [
            'shift_name'
        ];
        
        try {
            $data['errors'] = "";
            
            if (empty($input_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_INPUT_ID'));
            }
            if (!in_array($input_id, $perm_arr)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_NOT_PERM_INPUT_ID'));
            } 
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj'=>$this->user,
            ];
            $permission_check = $model->checkPermission('update_shift_header', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_EDIT_HEADER_ERROR_PERMISSION'));
            }
            
            $time = strtotime('now + 1day'); // 1 day lifetime
            $recorded_shift_header = $this->db->escape($shift_header);
            $this->app->input->cookie->set('com_shifts_new_shift_name', $recorded_shift_header, $time, $this->app->get('cookie_path', '/'), $this->app->get('cookie_domain'), $this->app->isSSLConnection());

            $data['res'] = $recorded_shift_header;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
           
        if(!empty($data['errors'])){
            echo '<span class="color_red">'.$data['errors'].'</span>';
        } else{
            echo $data['res'];
        }
        JFactory::getApplication()->close();
    }

    public function cloneUserShifts()
    {
        $user_id = $this->app->input->getInt('user_id');
        $user_for_clone = $this->app->input->getInt('user_for_clone');
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        
        try {
            $data['errors'] = "";
            
            if (empty($user_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_USER_ID'));
            }
            if (empty($user_for_clone)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_USER_FOR_CLONE_ID'));
            } 
            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_END'));
            }
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user,
                'user_for_clone_obj' => $user_for_clone,
                'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('cloneUserShifts', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_CLONE_PERMISSION'));
            }

            $res = $model->cloneUserShifts($user_id, $user_for_clone, $start, $end);

            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function getAllColors()
    { 
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        
        try {
            $data['errors'] = "";
            
            
            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_IN_GET_ALL_CIRCLESS_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_IN_GET_ALL_CIRCLESS_ERROR_EMPTY_END'));
            }
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user,
            ]; 
           
            $permission_check = $model->checkPermission('getСircles', $individual_params);

            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_IN_GET_ALL_CIRCLESS_ERROR_PERMISSION'));
            }

            $res = $model->getAllColors($this->user->id, $start, $end,true); 
            
            $data['html'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function editComShiftsHeader()
    {
        $shift_header = $this->app->input->getString('value');
        $input_id_arr = explode('-', $this->app->input->getString('id'));
        $input_id = $input_id_arr[0];
        
        $perm_arr = [
            'shift_name'
        ];
        /*echo '<pre>';
        print_r($_REQUEST);
        echo '</pre>';*/
        
        try {
            $data['errors'] = "";
            
            if (empty($input_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_INPUT_ID'));
            }
            if (!in_array($input_id, $perm_arr)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_NOT_PERM_INPUT_ID'));
            } 
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj'=>$this->user,
            ];
            $permission_check = $model->checkPermission('update_shift_header', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_EDIT_HEADER_ERROR_PERMISSION'));
            }

            $recorded_shift_header = $model->editComShiftsHeader($shift_header, $input_id_arr[1]);
            
            $data['res'] = $recorded_shift_header;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
           
        if(!empty($data['errors'])){
            echo '<span class="color_red">'.$data['errors'].'</span>';
        } else{
            echo $data['res'];
        }
        JFactory::getApplication()->close();
    }
    
    public function separateShift() {
        $data       =   array('status'=>0,'message'=>"",'error'=>"");        
        $id         =   $this->app->input->getInt('id');
        $date       =   $this->app->input->getString("date");
        $data['id']     =   $id;
        $data['date']   =   $date;
        try {
            if (empty($id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_SHIFT_ID_APPROVE_SHIFT'));
            }
            $model = $this->getModel('Tthtml5');
            $individual_params = [
                'id'       => $id,
                'user_obj' => $this->user,
                'user_from_request' =>$this->user->id
            ];
            $permission_check = $model->checkPermission('separateShift', $individual_params);
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_PERMISSION_APPROVE_SHIFT'));
            }
            $model->separateShift($id,$date);
            $data['message']    =   JText::_('COM_SHIFTS_SUCCESS_APPROVE_SHIFTS');
            $data['status']     =   1;
        } catch (Exception $e) {
            $data['error'] = $e->getMessage();
        }
        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function breakTimelineAsDays() {
        $data       =   array('status'=>0,'message'=>"",'error'=>"");        
        $id         =   $this->app->input->getInt('id');
        $data['id']     =   $id;
        try {
            if (empty($id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_BREAK_DAYS'));
            }
            $model = $this->getModel('Tthtml5');
            $individual_params = [
                'id'       => $id,
                'user_obj' => $this->user,
                'user_from_request' =>$this->user->id
            ];
            $permission_check = $model->checkPermission('separateShift', $individual_params);
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_BREAK_DAYS_PERMISSION'));
            }
            $data['out']     =   $model->breakTimelineAsDays($id);
            $data['message']    =   JText::_('COM_SHIFTS_SUCCESS_BREAK');
            $data['status']     =   1;
        } catch (Exception $e) {
            $data['error'] = $e->getMessage();
        }
        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    
    
    public function approveShift()
    {
        $user_id = $this->app->input->getInt('user_id');
        $shift_id = $this->app->input->getInt('shift_id');

        try {
            $data['errors'] = "";
            
            if (empty($user_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_USER_ID_APPROVE_SHIFT'));
            }
            if (empty($shift_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_SHIFT_ID_APPROVE_SHIFT'));
            } 
            
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user,
                'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('approveShift', $individual_params);
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_PERMISSION_APPROVE_SHIFT'));
            }
            $res = $model->approveShift($user_id, $shift_id);
            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function saveState()
    {
        $input_id = $this->app->input->getString('input_id');
        $lang = $this->app->input->getString('lang');
        $manager = $this->app->input->getInt('manager');
        
        try {
            $data['errors'] = "";
            
            if (empty($input_id) || !in_array($input_id, ['shift_one_month', 'shift_3_month', 'shift_6_month'])) {
                throw new Exception(JText::_('COM_SHIFTS_SAVE_STATE_ERROR_EMPTY_INPUT_ID'));
            }
            if (empty($lang)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_LANG'));
            } 
            if (empty($manager)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_MANAGER'));
            }
            
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user,
                'user_from_request' => $manager
            ];
            
            $permission_check = $model->checkPermission('saveState', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_ERROR_SAVE_STATE_PERMISSION'));
            }

            $res = $model->saveState($input_id, $lang, $manager);

            $data['res'] = $res;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    private static function getEnglishMonthName($month)
    {
        mb_internal_encoding('UTF-8');
        //$month = mb_convert_case($month, MB_CASE_TITLE);
       
        $months_array = [
            "Janúar" => "January",
            "Febrúar" => "February",
            "Mars" => "March",
            "Apríl" => "April",
            "Maí" => "May",
            "Júní" => "June",
            "Júlí" => "July",
            "Ágúst" => "August",
            "September" => "September",
            "Október" => "October",
            "Nóvember" => "November",
            "Desember" => "December",
            
            "January" => "January",
            "February" => "February",
            "March" => "March",
            "April" => "April",
            "May" => "May",
            "June" => "June",
            "July" => "July",
            "August" => "August",
            "September" => "September",
            "October" => "October",
            "November" => "November",
            "December" => "December",
            
            "Jan." => "January",
            "Feb." => "February",
            "Mars" => "March",
            "Apr." => "April",
            "Maí" => "May",
            "Jún." => "June",
            "Júl." => "July",
            "Ág." => "August",
            "Sept." => "September",
            "Okt." => "October",
            "Nóv." => "November",
            "Des." => "December",
            
            //"Jan." => "January",
            //"Feb." => "February",
            "Mar." => "March",
            //"Apr." => "April",
            "Mai" => "May",
            "Jun." => "June",
            "Jul." => "July",
            "Aug." => "August",
            //"Sept." => "September",
            //"Okt." => "October",
            "Nov." => "November",
            "Dec." => "December"
        ];
        
        return $months_array[$month];
    }
    
    public function getMonths()
    {
        $month = $this->app->input->getString('month');
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');

        try {
            $data['errors'] = "";
            
            if (empty($month)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_MONTH'));
            }
            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_EMPTY_END'));
            }
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_EMPTY_LANG'));
            }
            
            $month_arr = explode(' ', $month);
            if($lang == 'is'){
                $normalized_month = self::getEnglishMonthName($month_arr[0]);
            } else{
                $normalized_month = $month_arr[0];
            }
           
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user
            ];
            
            $permission_check = $model->checkPermission('getMonths', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_ERROR_PERMISSION'));
            }

            $res = $model->getMonths($start, $end, $lang, $normalized_month);

            $data['res'] = $res;
            /*$data['month_name'] = $normalized_month;
            $data['month'] = $month;
            $data['lang'] = $lang;
            $data['start'] = $start;
            $data['end'] = $end;*/
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function cloneMonthData()
    {
        $month = strip_tags($this->app->input->getString('parent_month'));
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');
        $month_for_copy = strip_tags($this->app->input->getString('month_for_copy'));
        
        try {
            $data['errors'] = "";
            
            if (empty($month)) {
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_EMPTY_MONTH'));
            }
            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_EMPTY_END'));
            }
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_EMPTY_LANG'));
            }
            if(empty($month_for_copy)){
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_EMPTY_MONTH_FOR_COPY'));
            }
            
            $month_arr = explode(' ', $month);
            $month_for_copy_arr = explode(' ', $month_for_copy);
            
            //($lang == 'is'){
                $normalized_month_parent = self::getEnglishMonthName($month_arr[0]);
                $normalized_month_for_copy = self::getEnglishMonthName($month_for_copy_arr[0]);
            /*} else{
                $normalized_month_parent = $month_arr[0];
                $normalized_month_for_copy = $month_for_copy_arr[0];
            }*/
            $year_parent_month = $month_arr[1];
            $year_for_copy = $month_for_copy_arr[1];
            
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user
            ];
            
            $permission_check = $model->checkPermission('cloneMonthData', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_CLONE_MONTHS_ERROR_PERMISSION'));
            }

            $res = $model->cloneMonthData($start, $end, $lang, $normalized_month_parent, $normalized_month_for_copy, $year_parent_month, $year_for_copy);

            $data['res'] = $res;
            $data['normalized_month_parent'] = $normalized_month_parent;
            $data['normalized_month_for_copy'] = $normalized_month_for_copy;
            $data['month_for_copy_arr'] = $month_for_copy_arr;
            $data['month_arr'] = $month_arr;
            
            /*$data['month'] = $month;
            $data['lang'] = $lang;*/
            $data['start'] = $start;
            $data['end'] = $end;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function saveUserIcon()
    {
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');
        $user_id = $this->app->input->getInt('user');
        $selected_icon = $this->app->input->getString('selected_icon');
        
        try {
            $data['errors'] = "";

            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_EMPTY_END'));
            }
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_EMPTY_LANG'));
            }
            if (empty($user_id)) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_EMPTY_USER_ID'));
            }

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('saveUserIcon', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_PERMISSION'));
            }

            $res = $model->saveUserIcon($start, $end, $lang, $user_id, $selected_icon);

            $data['res'] = $res;
           
            $data['start'] = $start;
            $data['end'] = $end;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getUsersIcons()
    {
        $lang = $this->app->input->getString('lang1');
        //$length = $this->app->input->getInt('length');
       
        try {
            $data['errors'] = "";

           
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_POPUP_ERROR_EMPTY_LANG'));
            }

            $users = json_decode(self::loadRoomsStatic());
            $data['res'] = $users;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getUsersIconsUsed()
    {
        
        $lang = $this->app->input->getString('lang1');
        $cell_date = $this->app->input->getString('cell_date');
        
        try {
            $data['errors'] = "";

          
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_EMPTY_LANG'));
            }
            if(empty($cell_date) || $this->validateDate($cell_date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_INCORRECT_DATE'));
            }

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('getUsersIconsUsed', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_PERMISSION'));
            }

            $html = $model->getUsersIconsUsed($cell_date);

            $data['html'] = $html;
            
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function saveAvbState()
    {
        $l2 = $this->app->input->getString('lang1');
        $val = $this->app->input->getString('val');
        $date = $this->app->input->getString('cell-date');
        
        
        try {
            $data['errors'] = "";

          
            if (empty($l2) && in_array($l2, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVB_BUTTON_ERROR_EMPTY_LANG'));
            }
            if(empty($date) || $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVB_BUTTON_ERROR_INCORRECT_DATE'));
            }
            

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('saveAvbState', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVB_BUTTON_ERROR_PERMISSION'));
            }

            $res = $model->saveAvbState([
                'val' => $val,
                'date' => $date,
            ]);

            $data['res'] = $res;
            $data['lang'] = $l2;
            $data['state'] = $val;
            
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();

    }
    
    public function saveInput()
    {
        $l2 = $this->app->input->getString('lang1');
        $val = $this->app->input->getInt('val');
        $date = $this->app->input->getString('cell-date');
        $icon_in_current_row = trim($this->app->input->getString('icon_in_current_row'));
        /*$lang = JFactory::getLanguage();
        
        if ($l2 == 'is') {
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_shifts';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            
            $lang->load($extension, $base_dir, $language_tag, $reload);
        } else {
            $lang->setLanguage('en-GB');
            $lang->load();
            $extension = 'com_shifts';
            $base_dir = JPATH_SITE;
            $language_tag = 'en-GB';
            $reload = true;
            
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }*/
        
        try {
            $data['errors'] = "";

          
            if (empty($l2) && in_array($l2, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_EMPTY_LANG'));
            }
            if(empty($date) || $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_INCORRECT_DATE'));
            }
            if(empty($icon_in_current_row)){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_ICON_CODE_EMPTY'));
            }

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('saveInput', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_USER_POSITIONS_ICONS_DROPDOWN_ERROR_PERMISSION'));
            }

            $res = $model->saveInput([
                'val' => $val,
                'date' => $date,
                'icon_in_current_row' => $icon_in_current_row
            ]);

            $data['res'] = $res;
            $data['lang'] = $l2;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();

    }
    
    private function validateDate($date, $format = 'Y-m-d H:i:s') 
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    private static function validateDateStatic($date, $format = 'Y-m-d H:i:s') 
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }
    
    public function getUsedIconsListForManager()
    {
        $l2 = $this->app->input->getString('lang1');
        //$val = $this->app->input->getInt('val');
        //$date = $this->app->input->getString('cell-date');
        //$icon_in_current_row = $this->app->input->getString('icon_in_current_row');
        
        
        try {
            $data['errors'] = "";

          
            if (empty($l2) && in_array($l2, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_MANAGER_USED_ICONS_ERROR_EMPTY_LANG'));
            }
            /*if(empty($date) || $this->validateDate($date, 'Y-m-d') === false){
                throw new Exception(JText::_('COM_SHIFTS_MANAGER_USED_ICONS_ERROR_INCORRECT_DATE'));
            }*/
            

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('getUsedIconsListForManager', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_MANAGER_USED_ICONS_ERROR_PERMISSION'));
            }

            $res = $model->getUsedIconsListForManager();

            $data['res'] = $res;
            $data['lang'] = $l2;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function confirmApiMessages()
    {
        $l2 = $this->app->input->getString('lang1');

        try {
            $data['errors'] = "";

          
            if (empty($l2) && in_array($l2, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_CONFIRM_MESSAGE_ERROR_EMPTY_LANG'));
            }

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('confirmApiMessages', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_CONFIRM_MESSAGE_ERROR_PERMISSION'));
            }

            $res = $model->confirmApiMessages();

            $data['res'] = $res;
            $data['lang'] = $l2;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getUsersPercents()
    {
        $l2 = $this->app->input->getString('lang1');
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        
        try {
            $data['errors'] = "";

          
            if (empty($l2) && in_array($l2, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_GET_USERS_PERCENTS_ERROR_EMPTY_LANG'));
            } if(empty($start)){
                throw new Exception(JText::_('COM_SHIFTS_GET_USERS_PERCENTS_ERROR_EMPTY_START'));
            } if(empty($end)){
                throw new Exception(JText::_('COM_SHIFTS_GET_USERS_PERCENTS_ERROR_EMPTY_END'));
            }

            $model = $this->getModel('Tthtml5'); 
             
            $individual_params = [
                'user_obj' => $this->user,
                //'user_from_request' => $user_id
            ];
            
            $permission_check = $model->checkPermission('getUsersPercents', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_GET_USERS_PERCENTS_ERROR_PERMISSION'));
            }

            $res = $model->getUserPercents($start, $end);

            $data['res'] = $res;
            //$data['lang'] = $l2;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function getLayoutGroupsConfirmNewPsd() {
        $jinput = JFactory::getApplication()->input;
        $model = $this->getModel();
        $lang = $jinput->get('lang', '', 'STRING');
        $html = $model->getLayoutGroupsNewPsd($lang);

        print_r(json_encode([
            'html' => $html
        ]));
        JFactory::getApplication()->close();
    }
    
    public function getMonthsNewPsd()
    {
        $month = $this->app->input->getString('month');
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');

        try {
            $data['errors'] = "";
            
            if (empty($month)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_MONTH'));
            }
            if (empty($start)) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_ERROR_EMPTY_START'));
            }
            if (empty($end)) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_EMPTY_END'));
            }
            if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_EMPTY_LANG'));
            }
            
            $month_arr = explode(' ', $month);
            if($lang == 'is'){
                $normalized_month = self::getEnglishMonthName($month_arr[0]);
            } else{
                $normalized_month = $month_arr[0];
            }
           
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user
            ];
            
            $permission_check = $model->checkPermission('getMonths', $individual_params);
            
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_GET_MONTHS_ERROR_PERMISSION'));
            }

            $res = $model->getMonths($start, $end, $lang, $normalized_month);

            $data['res'] = $res;
            /*$data['month_name'] = $normalized_month;
            $data['month'] = $month;
            $data['lang'] = $lang;
            $data['start'] = $start;
            $data['end'] = $end;*/
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close(); 
    }
    
    public function attachSheduleToTask(){
        $app = $this->app;
        $user_id = $app->input->getInt('user_id');
        $lang = $app->input->getString('lang1');
        $mode = $app->input->getString('mode');
        $selected_tasks = $app->input->getObject('selected_task');
        $ordering = $app->input->getObject('ordering');
        $schedule_id = $app->input->getInt('schedule_id');
        $click_option = $app->input->getObject('click_option');
        $selected_standart_task = $app->input->getObject('selected_standart_task');
        
        try {
            $data['errors'] = "";
             
            if(empty($user_id)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_USER_ID'));
            } if(empty($lang)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_LANG'));
            } if(empty($mode)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_MODE'));
            } if(empty($ordering)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_ORDERING'));
            } if(empty($schedule_id)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_SCHEDULE_ID'));
            } if(empty($click_option)){
                throw new Exception(JText::_('COM_AUDIT_NEW_TASK_MANAGER_DK_TASKS_ATTACH_ERROR_EMPTY_CLICK_OPTION'));
            } /*if(empty($selected_standart_task)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_ATTACH_TASK_TO_SHIFT_ERROR_EMPTY_CLICK_STANDART_TASKS'));
            }*/
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser($user_id);
            
            $individual_params = [
                'user_obj' =>  $user
            ]; 
            $permission_check = $model->checkPermission('attachSheduleToTask', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_ATTACH_SHEDULE_TO_TASK_ERROR_PERMISSION'));
            }
          
            JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $model_task_manager->attachSheduleToTask($user_id, $mode, $selected_tasks, $ordering, $schedule_id, $click_option, $selected_standart_task);
            
            //$data['res'] = $res['res'];
            //$data['saved_task_id'] = $res['saved_task_id'];
            //$data['selected_tasks'] = $selected_tasks;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function removeScheduleMessage()
    {
        $app = $this->app;
        $user_id = $app->input->getInt('u_id');
        $lang = strip_tags($app->input->getString('lang1'));
        $shift_id = $app->input->getInt('shift_id');
        $type = strip_tags($app->input->getString('type'));
        
        try {
            $data['errors'] = "";
             
            if(empty($user_id)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_REMOVE_MESSAGE_ERROR_EMPTY_USER_ID'));
            } if(empty($lang)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_REMOVE_MESSAGE_ERROR_EMPTY_LANG'));
            } if(empty($shift_id)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_REMOVE_MESSAGE_ERROR_EMPTY_SHIFT_ID'));
            } /*if(empty($type)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_REMOVE_MESSAGE_ERROR_EMPTY_TYPE'));
            } */
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser($user_id);
            
            $individual_params = [
                'user_obj' =>  $user
            ]; 
            $permission_check = $model->checkPermission('removeScheduleMessage', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_REMOVE_MESSAGE_ERROR_PERMISSION'));
            }
          
            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            //$model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model->removeScheduleMessage($user_id, $shift_id, $type);
            
            $data['res'] = $res;
           
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function loadAvbsState()
    {
        $app = $this->app;
        $lang = strip_tags($app->input->getString('lang1'));

        try {
            $data['errors'] = "";
             
            if(empty($lang)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_LOAD_AVAILABLES_BUTTON_STATE_ERROR_EMPTY_LANG'));
            } 
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser();
            
            $individual_params = [
                'user_obj' =>  $user
            ]; 
            $permission_check = $model->checkPermission('loadAvbsState', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_LOAD_AVAILABLES_BUTTON_STATE_ERROR_PERMISSION'));
            }
          
            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            //$model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model->loadAvbsState();
            
            $data['res'] = $res;
           
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function saveAvbSchedule()
    {
        $app = $this->app;
        $lang = strip_tags($app->input->getString('lang1'));
        $hours = strip_tags($app->input->getString('hours'));
        $cell_date = strip_tags($app->input->getString('cell-date'));
        $schedule_color = strip_tags($app->input->getString('schedule_color'));
        
        try {
            $data['errors'] = "";
             
            if(empty($lang)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_SAVE_ERROR_EMPTY_LANG'));
            } if(empty($hours)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_SAVE_ERROR_EMPTY_HOURS'));
            } if(empty($cell_date)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_SAVE_ERROR_EMPTY_CELL_DATE'));
            }  if(empty($schedule_color)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_SAVE_ERROR_EMPTY_SHIFT_COLOR'));
            } 
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser();
            
            $individual_params = [
                'user_obj' =>  $user
            ]; 
            $permission_check = $model->checkPermission('saveAvbSchedule', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_SAVE_ERROR_PERMISSION'));
            }
          
            //JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            //$model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');
            $res = $model->saveAvbSchedule($hours, $cell_date, $schedule_color);
            
            $data['res'] = $res['res'];
            $data['id'] = $res['id'];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function loadAvbSchedules()
    {
        $app = $this->app;
        $lang = strip_tags($app->input->getString('lang1'));
        $cell_date = strip_tags($app->input->getString('cell-date'));
        
        
        try {
            $data['errors'] = "";
             
            if(empty($lang)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_LOAD_ERROR_EMPTY_LANG'));
            } if(empty($cell_date)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_LOAD_ERROR_EMPTY_CELL_DATE'));
            } 
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser();
            
            $individual_params = [
                'user_obj' =>  $user
            ]; 
            $permission_check = $model->checkPermission('loadAvbSchedules', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_LOAD_ERROR_PERMISSION'));
            }
          
           
            $res = $model->loadAvbSchedules($cell_date);
            
            $data['res'] = $res;
           
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function deleteAvbSchedule()
    {
        $app = $this->app;
        $lang = strip_tags($app->input->getString('lang1'));
        $id = $app->input->getInt('id');
        
        
        try {
            $data['errors'] = "";
             
            if(empty($lang)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_DELETE_SCHEDULE_ERROR_EMPTY_LANG'));
            } if(empty($id)){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_DELETE_SCHEDULE_ERROR_EMPTY_ID'));
            } 
            
            $model = $this->getModel('Tthtml5');
            $user = JFactory::getUser();
            
            $individual_params = [
                'user_obj' =>  $user,
                //'schedule_id' => $id
            ]; 
            $permission_check = $model->checkPermission('deleteAvbSchedule', $individual_params);
  
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_NEW_AVAILABLE_SCHEDULES_DELETE_SCHEDULE_ERROR_PERMISSION'));
            }
          
           
            $res = $model->deleteAvbSchedule($id);
            
            $data['date'] = $res;
           
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        }  

        echo json_encode($data);
        
        JFactory::getApplication()->close();
    }
    
    public function editPopupHours()
    {
        $shift_header = $this->app->input->getString('value');
        $input_id = $this->app->input->getString('id');
        $perm_arr = [
            'shift_name'
        ];
        
        try {
            $data['errors'] = "";
            
            /*if (empty($input_id)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_EMPTY_INPUT_ID'));
            }
            if (!in_array($input_id, $perm_arr)) {
                throw new Exception(JText::_('COM_SHIFTS_ERROR_NOT_PERM_INPUT_ID'));
            } */
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user,
            ];
            $permission_check = $model->checkPermission('update_shift_header', $individual_params);
            
            if($permission_check == '0'){
                throw new Exception(JText::_('COM_SHIFTS_EDIT_HEADER_ERROR_PERMISSION'));
            }
            
            $time = strtotime('now + 1day'); // 1 day lifetime
            $recorded_shift_header = $this->db->escape($shift_header); 
            //$this->app->input->cookie->set('com_shifts_new_shift_name', $recorded_shift_header, $time, $this->app->get('cookie_path', '/'), $this->app->get('cookie_domain'), $this->app->isSSLConnection());

            $data['res'] = $recorded_shift_header;
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 
           
        if(!empty($data['errors'])){
            echo '<span class="color_red">'.$data['errors'].'</span>';
        } else{
            echo $data['res'];
        }
        JFactory::getApplication()->close();
    }
    
    public function editPopupMinutes()
    {
        
    }
    
    public function cloneWithPeriod()
    {
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');
        $period_value = $this->app->input->getString('period_value');
        $clone_value = $this->app->input->getString('clone_value');

        try {
            //$data['errors'] = "";
             
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error during the process of clone selected period: Invalid security token. Pls., reload page'));
            } if (empty($start)) {
                throw new Exception(JText::_('Error during the process of clone selected period: Empty start'));
            } if (empty($end)) {
                throw new Exception(JText::_('Error during the process of clone selected period: Empty end'));
            } if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('Error during the process of clone selected period: Empty lang'));
            } if(empty($period_value) /*|| $this->validateDate($period_value, 'd.m.Y-d.m.Y') === false*/){
               
                throw new Exception(JText::_('Error during the process of clone selected period: Empty period_value'));
            } else{
                $period_arr = explode('-', $period_value);
                $period_start = $period_arr[0];
                $period_end = $period_arr[1];
                
                if($this->validateDate($period_start, 'd.m.Y') === false){
                    throw new Exception(JText::_('Error during the process of clone selected period: Incorrect period start format'));
                } if($this->validateDate($period_end, 'd.m.Y') === false){
                    throw new Exception(JText::_('Error during the process of clone selected period: Incorrect period end format'));
                }
                
                $period_start_obj = DateTime::createFromFormat('d.m.Y H:i:s', $period_start . ' 00:00:00');
                $period_stop_obj = DateTime::createFromFormat('d.m.Y H:i:s', $period_end . ' 00:00:00');
                $period_stop_clone = clone $period_stop_obj;
                $period_stop_plus_1 = $period_stop_clone->modify('+1day');
                $clone_to_object = DateTime::createFromFormat('d.m.Y H:i:s', $clone_value . ' 00:00:00');
                
                $interval = new DateInterval('P1D');
                $daterange = new DatePeriod($period_start_obj, $interval, $period_stop_plus_1);
                $dates_array = [];
                
                foreach($daterange as $date1) {
                    $dates_array[] = $date1->format('d.m.Y');
                }
                
                if(in_array($clone_to_object->format('d.m.Y'), $dates_array)){
                    throw new Exception(JText::_('Error during the process of clone selected period: Clone to must be after period!'));
                }
            }
            
           
            
            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user
            ];
            
            $permission_check = $model->checkPermission('cloneWithPeriod', $individual_params);
            if($permission_check == '0'){
                throw new Exception(JText::_('Error during the process of clone selected period: permission denied'));
            }

            $res = $model->cloneWithPeriod($lang, $period_start, $period_end, $clone_value);

           
            $data = [
                'errors' => '',
                'res' => $res,
                'start' => $start,
                'end' => $end,
                'period_start_obj' => $period_start_obj->format('d.m.Y H:i:s'),
                'period_end_obj' => $period_stop_obj->format('d.m.Y H:i:s'),
            ];
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
    
    public function removeShiftsByColor() {
        $start = $this->app->input->getString('start');
        $end = $this->app->input->getString('end');
        $lang = $this->app->input->getString('lang1');
        $selected_color = strip_tags($this->app->input->getString('selected_color'));
        $start_time = strip_tags($this->app->input->getString('start_time'));
        $end_time = strip_tags($this->app->input->getString('end_time'));
        
        try {
            $data['errors'] = "";
            
            if(!JSession::checkToken('request')){//new correct checking token
                throw new Exception(JText::_('Error during the process of remove shifts by color: Invalid security token. Pls., reload page'));
            } if (empty($start)) {
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty scale start'));
            } if (empty($end)) {
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty scale end'));
            } if (empty($lang) && in_array($lang, ['en', 'is'])) {
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty lang'));
            } if(empty($selected_color)){
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty selected color'));
            } if(empty($start_time) || $this->validateDate($start_time, 'H:i') === false){
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty or incorrect start time'));
            } if(empty($end_time) || $this->validateDate($end_time, 'H:i') === false){
                throw new Exception(JText::_('Error during the process of remove shifts by color: Empty or incorrect end time'));
            }

            $model = $this->getModel('Tthtml5');
             
            $individual_params = [
                'user_obj' => $this->user
            ];
            
            $permission_check = $model->checkPermission('removeShiftsByColor', $individual_params);
            if($permission_check == '0'){
                throw new Exception(JText::_('Error during the process of remove shifts by color: Permission denied'));
            }

            $res = $model->removeShiftsByColor($lang, $selected_color, $start_time, $end_time);
 
           
            $data['res'] = $res;
              
             
     
        } catch (Exception $e) {
            $data['errors'] = $e->getMessage();
        } 

        echo json_encode($data);
        JFactory::getApplication()->close();
    }
}
