<?php
/** @var $this AuditViewTime_Wages */
defined( '_JEXEC' ) or die; // No direct access
$menu = JFactory::getApplication()->getMenu();
$menuItem = $menu->getActive();
$user = JFactory::getUser();
$date = date('Y.m.d');
$doc = JFactory::getDocument();

$lang =& JFactory::getLanguage();

if (!in_array(8, $user->groups) && !in_array(6, $user->groups)) {
    $app = JFactory::getApplication();
    $l = $l . '/curio-time';
    $app->redirect($l, false);
}

if($user->get('guest') || in_array(9, $user->groups)){
    if($lang->getName()=="Íslenska (Ísland)"){
        $l = '/is';
        
    }
    else{
        $l = '/en';
        
    }
    $app    = JFactory::getApplication();
    $l = $l.'/curio-time';
    $app->redirect($l, false);
   
}
if($lang->getName()=="Íslenska (Ísland)"){
   $l2='is';
} else{
    $l2='en';
}
$doc->addStyleSheet($this->baseurl . '/components/com_audit/assets/styles/page_settings.css?time=' . time());
$doc->addStyleSheet($this->baseurl . '/components/com_audit/assets/incl/font-awesome-4.7.0/css/font-awesome.min.css');

$config = &JFactory::getConfig();
$enable_sick_child = $config->get('enable_sick_child');
$enable_dropbox_token_in_settings = $config->get('enable_dropbox_token_in_settings');
$enable_combine_option_for_confirm_and_pay_period = $config->get('enable_combine_option_for_confirm_and_pay_period');

$filesModel = JModelLegacy::getInstance('Ctapi', 'AuditModel');
?>
<script src="/components/com_audit/assets/incl/jQuery-Mask-Plugin/dist/jquery.mask.min.js" type="text/javascript"></script>
<div class="item-page time-wages">
     <h1 class="h_style-0">
        <img src="/images/menu-icons/new_menu/menu-icon6.png" alt="Stillingar">
        <span><?php echo $menuItem->title ?></span>
     </h1>
</div>

<div class="item-page-body time-wages">
    <div class="subtitle"><h1 class="h1_header_settings"><?php echo JText::_('COM_AUDIT_CALCULATION'); ?></h1></div>
    <?php
        /*echo '<pre>';
        print_r($this->dk_headers);
        echo '</pre>';*/
    ?>
    <table id="table-time-wages">
        <tr>
            <th></th>
            <?php
                $model=JModelLegacy::getInstance('Rules', 'AuditModel');
                $first_rule_id=$this->date[0]->id;
                $def_rule=$this->date[0];
                $one_rule_headers=$model->getTexts('default', $first_rule_id, $l2);
                
                /*echo '<pre>';
                print_r($one_rule_headers);
                echo '</pre>';*/
                
                /*echo '<pre>';
                print_r($first_rule_id);
                echo '</pre>';*/
            ?>
            <th><div class="edit_header_text" id="daytime_text-<?=$first_rule_id?>-<?=$l2?>"><?=$one_rule_headers->daytime_text?></div></th>
            <th><div class="edit_header_text" id="after_hours_text-<?=$first_rule_id?>-<?=$l2?>"><?=$one_rule_headers->after_hours_text?></div></th>
            <th><div class="edit_header_text" id="night_time_text-<?=$first_rule_id?>-<?=$l2?>"><?=$one_rule_headers->night_time_text?></div></th>
            <th><div class="edit_header_text" id="weekends_text-<?=$first_rule_id?>-<?=$l2?>"><?=$one_rule_headers->weekends_text?></div></th>
            <th><div class="edit_header_text" id="holidays_text-<?=$first_rule_id?>-<?=$l2?>"><?=$one_rule_headers->holidays_text?></div></th>
        </tr>
        <?php if(!empty($this->date)): ?>
        <?php
            /*echo '<pre>';
            print_r($this->date);
            echo '</pre>';*/
        ?>
        
            
            <?php $i = 1; foreach ($this->date as $field):?>
            <?php if($i <= 2): ?>
                
                <tr>
                    <td style="text-align: right" class="td_css_event_width">
                        <?php 
                          if($i == 1){
                              echo JText::_('COM_AUDIT_TIME_CARD_CALCULATION_START'); 
                          }
                          if($i == 2){
                              echo JText::_('COM_AUDIT_TIME_CARD_CALCULATION_END'); 
                          }
                        ?>
                    </td>
                    <?php
                        if($i == 1){?>
                            <td class="center-text edit3" id="day_time-<?=$field->id?>-<?=$user->id?>"><?=$field->day_time?></td>
                        <?php } else{?>
                            <td class="center-text td_break td_edit_extra_time" id="day_time-<?=$field->id?>-<?=$user->id?>">          
                                <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit3<?php } ?>" id="day_time-<?=$field->id?>-<?=$user->id?>"><?=$field->day_time?></div>
                                
                                <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                                    <div class="edit_break_time_wrapper">
                                        <i class="fa fa-clock-o" aria-hidden="true"></i>
                                        <div class="time_container">
                                            <div class="time_container_content">
                                                <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_EXTRA_POPUP')?></label>
                                                <input id="extra_hours-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->extra_hours?>"/>
                                            </div>
                                        </div>
                                    </div>
                                <?php } ?>
                            </td> 
                        <?php } ?>
                   
                    <td class="center-text edit3" id="after_hours-<?=$field->id?>-<?=$user->id?>"><?=$field->after_hours?></td>
                    <td class="center-text edit3" id="night_time-<?=$field->id?>-<?=$user->id?>"><?=$field->night_time?></td>
                    <td class="center-text edit3" id="overtime_work-<?=$field->id?>-<?=$user->id?>"><?=$field->overtime_work?></td>
                    <td class="center-text edit3" id="public_holidays-<?=$field->id?>-<?=$user->id?>"><?=$field->public_holidays?></td>
                </tr>
                
                <?php endif; ?> 
               
                   
              
            <?php $i++; endforeach; ?>
                
                <?php
                    /*echo '<pre>';
                    print_r($this->break);
                    echo '</pre>';*/
                ?>
                <tr class="js_cut_break">
                    <td style="text-align: right"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_HEADER')?></td>
                    <td class="center-text td_break" >
                        <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit_break_val<?php } ?>" id="day_break_time-<?=$this->break->id?>"><?=$this->break->day_break_time?></div>
                        <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                        <div class="edit_break_time_wrapper">
                            <i class="fa fa-clock-o" aria-hidden="true"></i>
                            <div class="time_container">
                                <div class="time_container_content">
                                    <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_POPUP')?></label>
                                    <input id="day_time_to_break-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->day_time_to_break?>"/>
                                </div>
                               
                            </div>
                        </div>
                        <?php } ?>
                    </td>
                    <td class="center-text td_break" >
                        <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit_break_val<?php } ?>" id="after_hours_break_time-<?=$this->break->id?>"><?=$this->break->after_hours_break_time?></div>
                        <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                        <div class="edit_break_time_wrapper">
                            <i class="fa fa-clock-o" aria-hidden="true"></i>
                            <div class="time_container">
                                <div class="time_container_content">
                                    <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_POPUP')?></label>
                                    <input id="after_hours_time_to_break-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->after_hours_time_to_break?>"/>
                                </div>
                               
                            </div>
                        </div>
                        <?php } ?>
                    </td>
                    <td class="center-text td_break" >
                        <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit_break_val<?php } ?>" id="night_time_break_time-<?=$this->break->id?>"><?=$this->break->night_time_break_time?></div>
                        <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                        <div class="edit_break_time_wrapper">
                            <i class="fa fa-clock-o" aria-hidden="true"></i>
                            <div class="time_container">
                                <div class="time_container_content">
                                    <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_POPUP')?></label>
                                    <input id="night_time_time_to_break-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->night_time_time_to_break?>"/>
                                </div>
                               
                            </div>
                        </div>
                        <?php } ?>
                    </td>
                    <td class="center-text td_break" >
                        <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit_break_val<?php } ?>" id="overtime_work_break_time-<?=$this->break->id?>"><?=$this->break->overtime_work_break_time?></div>
                        <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                        <div class="edit_break_time_wrapper">
                            <i class="fa fa-clock-o" aria-hidden="true"></i>
                            <div class="time_container">
                                <div class="time_container_content">
                                    <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_POPUP')?></label>
                                    <input id="overtime_work_time_to_break-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->overtime_work_time_to_break?>"/>
                                </div>
                               
                            </div>
                        </div>
                        <?php } ?>
                    </td>
                    <td class="center-text td_break" >
                        <div class="<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>edit_break_val<?php } ?>" id="public_holidays_break_time-<?=$this->break->id?>"><?=$this->break->public_holidays_break_time?></div>
                        <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
                        <div class="edit_break_time_wrapper">
                            <i class="fa fa-clock-o" aria-hidden="true"></i>
                            <div class="time_container">
                                <div class="time_container_content">
                                    <label for="appt-time0"><?=JText::_('COM_AUDIT_TIME_CARD_BREAK_POPUP')?></label>
                                    <input id="public_holidays_time_to_break-<?=$this->break->id?>-popup" type="text" name="appt-time" class="input_time" value="<?=$this->break->public_holidays_time_to_break?>"/>
                                </div>
                               
                            </div>
                        </div>
                        <?php } ?>
                    </td>
                </tr>
        <?php endif; ?>
                
    </table>
    <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
    <div class="spec_table_wrapper">
      <?php
            /*echo '<pre>';
            print_r($this->dk_headers);
            echo '</pre>';*/
      ?>
    <table class="table_spec_headers">
        <tbody>
                <tr class="tr_dk_holidays tr_dk_holidays_header">
                    <td><?=JText::_('COM_AUDIT_TIME_DK_HEADER_SETTINGS')?></td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=$one_rule_headers->daytime_text?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->daytime_pos_header?>" id="edit_dk_headers-daytime"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=$one_rule_headers->after_hours_text?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->after_hours_pos_header?>" id="edit_dk_headers-aftertime"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=$one_rule_headers->night_time_text?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->night_pos_header?>" id="edit_dk_headers-night"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=$one_rule_headers->weekends_text?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->weekends_pos_header?>" id="edit_dk_headers-weekends"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=JText::_('COM_AUDIT_TIME_DK_HEADER_HOL90')?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->holidays_90_pos_header?>" id="edit_dk_headers-hol90"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=JText::_('COM_AUDIT_TIME_DK_HEADER_HOL45')?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->holidays_45_pos_header?>" id="edit_dk_headers-hol45"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK')?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->sick_pos_header?>" id="edit_dk_headers-sick"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php if($enable_sick_child=='1'){?>
                <tr class="tr_dk_holidays">
                    <td>
                        <div class="dk_header_wrapper">
                            <div class="dk_settings_text"><?=JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD')?></div>
                            <div class="dk_settings_input">
                                <input type="text" value="<?=$this->dk_headers->sick_child_pos_header?>" id="edit_dk_headers-sick_child"/>
                            </div>
                        </div>
                    </td>
                </tr>
                <?php } ?>
        </tbody>
    </table>
    <div class="filter_state_wrapper">
        <div class="one_item_page_rules_item">
            <input type="checkbox" class="custom_checkbox" id="sick_status" <?php if($this->sick_state==1){?>checked<?php } ?>>
            <label for="sick_status" class="label_rule_item"><?= JText::_('COM_AUDIT_SICK_INCLUDE') ?></label>
        </div>
    </div>
    <?php 
        
        if($enable_sick_child=='1'){?>
            <div class="filter_state_wrapper">
                <div class="one_item_page_rules_item">
                    <input type="checkbox" class="custom_checkbox" id="sick_child_status" <?php if($this->sick_child_state==1){?>checked<?php } ?>>
                    <label for="sick_child_status" class="label_rule_item"><?= JText::_('COM_AUDIT_SICK_CHILD_INCLUDE') ?></label>
                </div> 
            </div>
        <?php } ?>
    <div class="filter_state_wrapper">
            <?php
                //echo $this->quote_home_status;
                /*echo '<pre>';
                print_r($user);
                echo '</pre>';*/
            ?>
            <div class="one_item_page_rules_item">
                <input type="checkbox" class="custom_checkbox" id="quote_home_status" <?php if($this->quote_home_status==1){?>checked<?php } ?>>
                <label for="quote_home_status" class="label_rule_item"><?= JText::_('COM_AUDIT_QUOTE_HOME') ?></label>
            </div>
    </div>
     
    </div>
    <?php } ?>
</div>
<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
<?php
    /*echo '<pre>';
    print_r($this->companyImages);
    echo '</pre>';*/
    ?>

<div class="users_import_wrapper">
            <div class="fileUpload btn btn-primary import_wrapper">
                <span style=""><?=JText::_('COM_AUDIT_SETTINGS_EXCEL_IMPORT')?></span>
                <input class="input_import_users" type="file" name="csv"/>
            </div>
            <div class="import_loader">
                <i class="fa fa-refresh fa-spin fa-fw"></i>
            </div>
<div class="uploadFiles">
    <div class="upload-logo">
        <form id="uploadLogo" method="POST">
            <div class="fileUpload btn btn-primary">
                <span><?php echo JText::_('COM_AUDIT_SELECT_LOGO'); ?></span>
                <input type="file" class="upload upload-logo-input" name="logo" onchange="readURL(this, 'logo');" />
                <input type="hidden" name="typeImg" value="logo">
            </div>
            <button class="btn btn-primary button_clear" type="button"><?=JText::_('COM_AUDIT_SETTINGS_CLEAR')?></button>
            <?php if($user->subscription == 1): ?> 
                <br>
                <img id="imgLogo" src="/images/company_images/<?=$this->companyImages->logo?>?time=<?=time()?>" <?php if($this->companyImages->logo){ echo 'style="display:inline"';}?> class="settings_minilogo"/>
            <?php endif; ?> 
        </form>
    </div>
    <div class="upload-bg">
        <form id="uploadBg" method="POST">
            <div class="fileUpload btn btn-primary">
                <span><?php echo JText::_('COM_AUDIT_SELECT_BG'); ?></span>
                <input type="file" class="upload upload-bg-input" name="bg" onchange="readURL(this, 'bg');" />
                <input type="hidden" name="typeImg" value="bg">
            </div>
            <button class="btn btn-primary button_clear_bg" type="button"><?=JText::_('COM_AUDIT_SETTINGS_CLEAR')?></button>
            <br>
            <img id="imgBg" src="/images/company_images/<?=$this->companyImages->bg?>?time=<?=time()?>"  <?php if($this->companyImages->bg){ echo 'style="display:inline"';}?>  class="settings_bg"/>
        </form>
    </div>
    <?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
        <!--<div class="users_import_wrapper">
            <div class="fileUpload btn btn-primary import_wrapper">
                <span style=""><?=JText::_('COM_AUDIT_SETTINGS_EXCEL_IMPORT')?></span>
                <input class="input_import_users" type="file" name="csv"/>
            </div>
            <div class="import_loader">
                <i class="fa fa-refresh fa-spin fa-fw"></i>
            </div>-->
            <div class="import_message_wrapper">
                <?php
                    $arrayQueue = JFactory::getApplication()->getMessageQueue();
                    foreach($arrayQueue as $messQueue){
                        if($messQueue['type']=='addcsv') {
                            $arr_message = json_decode($messQueue['message']);
                            foreach($arr_message as $mess) echo '<p style="margin:0px;padding:0px;">'.$mess.'</p>';
                        }
                    }
                    
                    $enable_unlimited_import_users = $config->get('enable_unlimited_import_users');
                    if($enable_unlimited_import_users=='1'){
                        $form_action='/system_addons/import_users.php';
                    } else{
                        $form_action='/index.php?task=addUserCSV';
                    }
                    ?>
            </div>
           <form id="formCSV" style="display:none" action="<?=$form_action?>" method="post" class="form-horizontal" enctype="multipart/form-data"></form>
           <div class="sync_wrapper" style="display:none">
                <?php       
                    $model_sync=JModelLegacy::getInstance('Sync', 'AuditModel');
                    $sync_status=$model_sync->getStatus();
                    //echo $sync_status;
        
                    if($sync_status=='1'){
                         //echo 'sync enabled';
                    } else{
                        //echo 'sync disabled';
                    }
                ?>
                <div class="sync_checkbox_wr">
                    <div class="sync_checkbox_circle"></div>
                </div>
                <div class="sync_text">
                    <span><?=JText::_('COM_AUDIT_SETTINGS_SYNC_START')?></span>
                    <div class="sync_loader">
                        <i class="fa fa-refresh fa-spin fa-fw"></i>
                    </div>
                </div>
            </div>
           
        </div>
        
    <?php } ?>
</div>
    <?php if (in_array(8, $user->groups) || in_array(6, $user->groups)) { ?>
        <?php if ($enable_dropbox_token_in_settings == '1') { ?>
            <?php
                $company_token=$filesModel->getCloudAccessToken()['token'];
                /*echo '<pre>';
                print_r($company_token);
                echo '</pre>';*/
            ?>
            <div class="settings_dropbox_token_wr">
                <form id="bropbox_access_token">
                    <div class="fields-inp">
                        <div class="label-inp"><?= JText::_('COM_AUDIT_SETTINGS_ACCESS_TOKEN_HEADER') ?></div>
                        <div class="field-inp"><input class="db_access_token" type="text" name="access_token" value="<?=$company_token?>"></div>
                        <div class="error"></div>
                    </div>      
                    <input type="hidden" name="action" value="save_bropbox">
                    <button id="save_dropbox_token" class="btn btn-small" type="button"><span class="icon-save"></span><?= JText::_('COM_AUDIT_SETTINGS_ACCESS_TOKEN_SAVE_BUTTON') ?></button>
                </form>
            </div>
        <?php } if($enable_combine_option_for_confirm_and_pay_period  == '1' && $this->system_mode =='confirm'){?>
            <div class="combine_confirm_and_pay_period_wr">
                <div class="filter_state_wrapper">
                    <div class="one_item_page_rules_item">
                        <input type="checkbox" class="custom_checkbox" id="combine_checkbox_enable" <?php if($this->combine_confirm_and_pp == 1){?>checked<?php } ?>>
                        <label for="combine_checkbox_enable" class="label_rule_item"><?= JText::_('COM_AUDIT_SETTINGS_COMBINE_CHECKBOX_OPTION_ENABLE') ?></label>
                    </div>
                </div>
                <div class="filter_state_wrapper">
                    <div class="one_item_page_rules_item">
                        <input type="checkbox" class="custom_checkbox" id="combine_checkbox_disable" <?php if($this->combine_confirm_and_pp == 0){?>checked<?php } ?>>
                        <label for="combine_checkbox_disable" class="label_rule_item"><?= JText::_('COM_AUDIT_SETTINGS_COMBINE_CHECKBOX_OPTION_DISABLE') ?></label>
                    </div>
                </div>
            </div>
        <?php } ?>
    <?php } ?>
<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>


<script>
    'use strict';

    jQuery(document).ready(function($){
        var 
            js = $,
            sync_in_progress='<?=JText::_('COM_AUDIT_SETTINGS_SYNC_IN_PROGRESS')?>',
            sync_start_text='<?=JText::_('COM_AUDIT_SETTINGS_SYNC_START')?>'
        ;
           
        
        js('#sick_status').on('change', function(){
            //alert('filtering');
            
            var 
                this0=js(this),
                state=this0.prop("checked");
       
            //alert(state);
            js.ajax({
                type: "POST",
                url: '/index.php?task=updateSickState',
                data: ({
                    "state": state,
                
                }),
                dataType: "json",
                async: true,
                success: function(data){ 
                    console.log(data);      
       
                }
            });
       
        });
        
        js('#sick_child_status').on('change', function(){
            //alert('filtering');
            
            var 
                this0=js(this),
                state=this0.prop("checked");
       
            //alert(state);
            js.ajax({
                type: "POST",
                url: '/index.php?task=updateSickChildState',
                data: ({
                    "state": state,
                
                }),
                dataType: "json",
                async: true,
                success: function(data){ 
                    console.log(data);      
       
                }
            });
       
        });
        
        js('#quote_home_status').on('change', function(){
            //alert('filtering');
            
            let 
                this0=js(this),
                state=this0.prop("checked");
       
            //alert(state);
            js.ajax({
                type: "POST",
                url: '/index.php?task=updateQuoteHome',
                data: ({
                    "state": state,
                
                }),
                dataType: "json",
                async: true,
                success: function(data){ 
                    console.log(data);      
       
                }
            });
       
        });
        
        <?php if($enable_combine_option_for_confirm_and_pay_period == '1'){?>
            js('.combine_confirm_and_pay_period_wr input[type="checkbox"]').on('change', function(){

                let  
                    this0=js(this),
                    //state=this0.prop("checked"),
                    input_id = this0.attr('id');
                    
                this0.attr('disabled', 'disabled');
                
                js('.combine_confirm_and_pay_period_wr input[type="checkbox"]').removeAttr('checked');
               
                this0.attr('checked', 'checked');
                
                //alert(state);
                js.ajax({ 
                    type: "POST",
                    url: '/index.php?task=setCombineConfirmAndPpStatus',
                    data: ({
                        "input_id": input_id,
                        "lang": '<?=$l2?>'
                    }),
                    dataType: "json",
                    async: true,
                    success: function(data){ 
                        
                        
                        if(data.errors != null && data.errors.length>0){
                            alert(data.errors);
                            return false;
                        } 
                        console.log(data);
                        this0.removeAttr('disabled', 'disabled');
                    }, error: function(xhr, status) {
                        // check if xhr.status is defined in $.ajax.statusCode
                        // if true, return false to stop this function
                        if (typeof this.statusCode[xhr.status] != 'undefined') {
                            return false;
                        }
                        // else continue
                        console.log(xhr);
                        alert('Error in server with code '+xhr.status+' and text: '+xhr.statusText);
                        this0.removeAttr('disabled', 'disabled');
                    }, statusCode: {
                        /*404: function(response) {
                            console.log('ajax.statusCode: 404');
                        }*/
                    } 
                });
       
            });
        <?php } ?>
        
        js('.sync_checkbox_wr').on('click', function(){
            //alert('click');
            
            var
                this0=js(this),
                status,
                sync_ask_text='<?=JText::_('COM_AUDIT_SETTINGS_SYNC_ASK')?>'
                ;
               
            if(this0.hasClass('active_sync_checkbox_wr')){
                
            } else{
                var conf=confirm(sync_ask_text);
                
                if(conf===true){
                    //alert('start sync');
                    this0.addClass('active_sync_checkbox_wr');
                
                    js.ajax({
                        type: "POST",
                        url: '/index.php?task=startAPISync',
                        async: true,      
                        beforeSend: function(){     
                            js('.sync_wrapper .sync_text span').text(sync_in_progress);
                            js('.sync_loader').show();
                        },
                        data: ({ }), 
                        dataType: "json",                   
                        success: function(data){
                            js('.sync_loader').hide();
                            js('.sync_wrapper .sync_text span').text(sync_start_text);
                            this0.removeClass('active_sync_checkbox_wr');
                            
                            var errors=data.errors;

                            console.log('Sync complete');
                   
                            //console.log(data.errors);
                            if(errors.length>0){
                                alert('Sync comlete. You have '+errors.length+' errors');
                                //necessary hack without it, html is displayed as text
                                js('.import_message_wrapper').html($("<div>").html(data.errors_html).text());

                            } else{
                                //js('.import_message_wrapper').html($("<div>").html(data.errors_html).text());
                                alert('Sync comlete.');
                            }
                        }
                    });
                }
            }
               
            
        });
    });
</script> 
<?php } ?>
<?php } else{?>
<style>
    .center-text.td_break{
    text-align: center
}
</style>
<?php } ?>

<style>
    #table-time-wages{
        width: 100%;
        border:1px solid #ccc;
        border-collapse: collapse;
        margin-bottom: 20px;
    }
    
    #table-time-wages td, #table-time-wages th{
        border:1px solid #ccc;
        border-collapse: collapse;
        padding: 5px;
        text-transform: uppercase;
        height: 30px;
        font-weight: normal;
    }
    
    #table-time-wages th{
        background: #FED580;
    }
    
    .item-page-body.time-wages{
        padding:30px;
    }
    
    .name-u{
        font-size: 22px;
        margin-bottom: 10px;
        text-transform: uppercase;
    }
    
    .edit3{
        text-align: center;
    }
    
    input{
        width: 50px;
    }
    form{
        margin: 0px;
        padding: 0px;
    }
    
   
</style>
<?php if(in_array(8, $user->groups) || in_array(6, $user->groups)){ ?>
<script>
    function validateEditableInput(val){
        //
        console.log('js fn validateEditableInput');
        
        try{
            var val_arr=val.split(':');
        } catch(e){
            return '0';
        }
        console.log(val_arr);
      
         try{
           if(val.length==0){
               return '1';
           }
           if(Number(val_arr[0])<=24){
                return '1';    
           } else{
               return '0';
           } 
        } catch(e){
            return '0';
        }
         //return '1';
    }
    
    function validateEditableInputWithPlus(val){
        console.log('js fn validateEditableInputWithPlus');
            console.log(val);
        // try{
            var val_arr=val.split('+');

            console.log(val_arr);
    
            //+00:00 pattern
            if(val_arr.length==2){
                console.log('+ mode');
                 val_arr=val.split(':');
                try{
                    if(val.length==0){
                        return '1';
                    }
                    if(Number(val_arr[0])<=24){  
                        return '1';
                    } else{
                        return '0';
                    } 
                } catch(e){
                    return '0';
                }
                //return '1';
            }
            
            //00:00 pattern
            if(val_arr.length==1){
                val_arr=val.split(':');
                
                try{
                    if(val.length==0){
                        return '1';
                    }
                    if(Number(val_arr[0])<=24){  
                        return '1';
                    } else{
                        return '0';
                    } 
                } catch(e){
                    return '0';
                }
            }
        }
    
    <?php if($user->subscription == 1): ?>
    jQuery(document).ready(function(){
        
        jQuery('.edit3').editable('/index.php?task=updateTable', {
            data_value : function(){
                var data=jQuery('.edit3').html();               
                return data;
            },
            cssclass: 'input_placeedit',
            onblur:'submit',
            data: function(data){               
                return data;
            },
            onsubmit: function(settings, td){
                var input = jQuery(td).find('input');
                var original = input.val();
                
                var res=validateEditableInput(original);
               // var res='1';
                console.log('onsubmit:'+original);
                
                if(res==='1'){
                    input.removeClass('border_red');
                    return original;
                } else{
                    input.addClass('border_red');
                    return false;
                }
            },
            callback: function(){
               
            }
        }); 
    });
    <?php else: ?>
    jQuery(document).on('click','.edit3',function(){
        SqueezeBox.resize({x: 300, y: 145});
        SqueezeBox.fromElement('#free-license');
        return false;
    });    
   <?php endif; ?>    
    
    var js=jQuery;
    
function readURL(input, typeImg) {
    
    
    if (input.files && input.files[0]) {
        var reader = new FileReader();
        reader.onload = function (e) {
            if(typeImg == 'logo'){
                //alert('readURL');
                js('#imgLogo').attr('src', e.target.result).show();
            }
            else{
                js('#imgBg').attr('src', e.target.result).show();
            }
           
        };
        
        reader.readAsDataURL(input.files[0]);
    }
    
    
    uploadImages(typeImg);
}


function uploadImages(typeImg){
    //alert('uploadImages');
    if(typeImg == 'logo'){
          var form = js('#uploadLogo');
          var formData = new FormData(form[0]);
    }
    else{
          var form = js('#uploadBg');
          var formData = new FormData(form[0]);
    }
   
   
    js.ajax({
        type: "POST",
        url: '/index.php?task=uploadImages',
        data: formData,
        processData: false,
        contentType: false,
        success: function(res) {
            console.log('success ajax');
        }
    });
   
}

jQuery(document).on('click','input.upload',function(e){
      var license = <?php echo $user->subscription?>;  
      if(license == 0){
          SqueezeBox.resize({x: 300, y: 145});
          SqueezeBox.fromElement('#free-license');
          return false;
      }
});

jQuery(document).ready(function($){
    var js=$;
    var tr_break=js('.js_cut_break');
    js('#table-time-wages tbody tr:eq(1)').after('<tr>'+tr_break.html()+'</tr>');
    
    js('.edit_break_time_wrapper i').on('click', function(){
        //alert('show');
        var this0=js(this).parent();
        
        if(this0.find('.time_container').hasClass('time_container_active')){
            this0.find('.time_container').removeClass('time_container_active');
        } else{
             this0.find('.time_container').addClass('time_container_active');
        }
        
    });
    
   
    
     js(document).mouseup(function (e) {
        //console.log(e.target);
        var container = js(".time_container");
        if (container.has(e.target).length === 0 && e.target.hasClass('fa')==false){
            container.removeClass('time_container_active');
        }
    });
    
   
    js('.edit_break_val').editable('/index.php?task=editBreakTime', {
        data: function (value, settings) {
            //alert(value.trim());
            return value.trim();
        },
        data_value: js('.edit_break_val').text(),
        cssclass: 'input_hours',
        onblur: 'submit',
        onsubmit: function(settings, td){ 
            //alert('edit break');
            var 
                input = js(td).find('input'),
                original = input.val(),
                res=validateEditableInputWithPlus(original),
                //res=validateEditableInput(original),
                current_element=input.parent().parent().attr('id'),
                input_time=js('#'+current_element).parent().find('.input_time')
            ;
            
            console.log('current id='+current_element);
            if(input_time.val()==''){
                //alert('save input time');
                input_time.val('00:30');
                input_time.trigger('focusout');
            }
            
            if(res==='1'){
                input.removeClass('border_red');
                return true;
            } else{
                input.addClass('border_red');
                return false;
            }
        },
        callback: function (data) {
 
        }
    });
    
   /* js('.edit_break_val .input_hours').live('keypress', function (event) {
        if(event.charCode==13){
            return true;
        }
        //console.log(js('.edit_break_val .input_hours input').val());   
        //console.log('keypress');
        var regex = new RegExp("^[+:0-9]+$");
        var key = String.fromCharCode(!event.charCode ? event.which : event.charCode);
        if (!regex.test(key)) {
            event.preventDefault();
            return false;
        }
    });*/
    
    /*js('.edit_break_val .input_hours').live('keyup', function (event) {
        let val=js('.edit_break_val .input_hours input').val();
        console.log(val.length);   
        
    });*/
    
    
    js('.input_time').on('focusout', function(){
        console.log('saving');
        
        var this0=js(this);
        var id=this0.attr('id');
        var value0=this0.val().trim();
        
        var res=validateEditableInput(value0);
        //var res='1';
        
        if(res==='1'){
            this0.removeClass('border_red');
             
            js.ajax({
                type: "POST",
                url: '/index.php?task=editBreakTime',
                async: true,
                data: ({"id": id, "value": value0}),
                dataType: "text",
                beforeSend: function(data){
                    if(data.length===1){
                        switch(data){
                            case '0':
                    
                            break;
                            default:
                                data='0'+data+':00'; 
                            break;
                        }
                    }
                },
                success: function(data){
                   
                    console.log(data);
                
                    this0.addClass('border_green');
                    this0.val(data);
                    setTimeout(function(){
                        this0.removeClass('border_green');                     
                    }, 500);
                }
            }); 
        } else{
             this0.addClass('border_red');
        }
        
    });
    
    js('.dk_settings_input input').on('focusout', function(){
        console.log('saving');
        
        var this0=js(this);
        var id=this0.attr('id');
        var value0=this0.val().trim();
        
        //var res=validateEditableInput(value0);
        var res='1';
        
        if(res==='1'){
            //alert(value0);
            this0.removeClass('border_red');
             
            js.ajax({
                type: "POST",
                url: '/index.php?task=editDkHeader',
                async: true,
                data: ({"id": id, "value": value0}),
                dataType: "text",
                beforeSend: function(data){
                    
                },
                success: function(data){
                   
                    console.log(data);
                
                    this0.addClass('border_green');
                    this0.val(data);
                    setTimeout(function(){
                        this0.removeClass('border_green');                     
                    }, 500);
                }
            }); 
        } else{
             this0.addClass('border_red');
        }
        
    });
    js('.button_clear_bg').on('click', function(){
           
            js.ajax({
                type: "POST",
                url: '/index.php?task=setDefaultSettingsImg',
                async: true,
                data: ({"type":'bg'}), 
                dataType: "json",
                success: function(data){
                    console.log(data); 
                    var default_url=data.default_logo_url;
                    js('.settings_bg').attr('src', default_url);
                }
            });
    });
    js('.button_clear').on('click', function(){
            //alert('click');
            js.ajax({
                type: "POST",
                url: '/index.php?task=setDefaultSettingsImg',
                async: true,
                data: ({"type":'logo'}), 
                dataType: "json",
                success: function(data){
                    console.log(data); 
                    var default_url=data.default_logo_url;
                    js('.settings_minilogo').attr('src', default_url);
                }
            });
    });
    
    <?php if ($enable_dropbox_token_in_settings == '1') { ?>
        function saveCloudAccessToken(formId) {
        console.log('js fn saveCloudAccessToken()');
        
        let 
            form     = js('#'+formId),
            formData = new FormData(form[0]);

        js("#bropbox_access_token .error").text('');
        
        js.ajax({
            type: "POST",
            url: '/index.php?task=setCloudAccessToken',
            data: formData,
            processData: false,
            contentType: false,
            success: function(res) {             
                let result = js.parseJSON(res);
                if (result.status == 1) {
                    alert('<?php echo JText::_('CURIO_SAVED_SETTINGS'); ?>'+" "+result.error);
                }
                else {
                    js("#bropbox_access_token .error").text('<?= JText::_('COM_AUDIT_SETTINGS_ACCESS_TOKEN_ERROR_INVALID') ?>');
                    js(".settings_dropbox_token_wr input.db_access_token").val("");
                    
                    setTimeout(function(){
                        alert('<?php echo JText::_('CURIO_NOT_SAVED_SETTINGS'); ?>'+" "+result.error);
                    },600);
                }
            }
        });
        
        return false;
    }
          
        js('#save_dropbox_token').on('click', function(){
            saveCloudAccessToken('bropbox_access_token');
        });
    <?php } ?>

    //make editable headers
    js('.edit_header_text').editable('/index.php?task=updateHeaderDEFRuleText', {
        data_value : js('.edit_header_text').html(),
        cssclass: 'form_edit_header_text',
        onblur:'submit',
        onsubmit: function(settings, td){
            var input = js(td).find('input');
            var original = input.val();
                
           
        },
        callback: function(data){
            console.log(JSON.parse(data));
        }
    });
   
    
    js('.input_import_users').on('change', function(){
        <?php if($enable_unlimited_import_users=='1'){?>
            function guidGenerator() {
                var S4 = function() {
                    return (((1+Math.random())*0x10000)|0).toString(16).substring(1);
                };
                return (S4()+S4()+"-"+S4()+"-"+S4()+"-"+S4()+"-"+S4()+S4()+S4());
            }
        
            var import_interval=0,
            token=guidGenerator();
    
            js('.import_loader').show();

            var data = new FormData();
            js.each(js(':file')[0].files, function(i, file) {
                data.append('file-'+i, file);
                data.append('manager_id', '<?=$user->id?>');
                data.append('token', token);
            });
        
            js.ajax({
                url: '/index.php?task=csvImport',
                data: data,
                cache: false,
                contentType: false,
                beforeSend: function(){
                    import_interval=1;
                },
                /*dataType: "json",*/
                processData: false,
                method: 'POST',
               
                success: function(data){
                    console.log(data);
                   // js('.import_loader').hide();
                    //js('#formCSV').trigger('reset');
                    
                    let html='',
                    error_incorrect_format='Incorrect format!',
                    error_file_is_not_upload='File is not upload.',
                    error_files_is_empty='Select and upload one file!';
            
                    if(data=='code-0'){
                        import_interval=0;
                        html='<p style="margin:0px;padding:0px;color:red">'+error_incorrect_format+'</p>'
                        js('.import_message_wrapper').empty().html(html);
                        js('.import_loader').hide();
                        js('#formCSV').trigger('reset');
                    }
                    if(data=='code-1'){
                        import_interval=0;
                        html='<p style="margin:0px;padding:0px;color:red">'+error_file_is_not_upload+'</p>'
                        js('.import_message_wrapper').empty().html(html);
                        js('.import_loader').hide();
                        js('#formCSV').trigger('reset');
                    }
                    if(data=='code-2'){
                        import_interval=0;
                        html='<p style="margin:0px;padding:0px;color:red">'+error_files_is_empty+'</p>'
                        js('.import_message_wrapper').empty().html(html);
                        js('.import_loader').hide();
                        js('#formCSV').trigger('reset');
                    }
                }
            });   
            
            setInterval(function(){
                setTimeout(function(){
                    try {
                        if( import_interval==1){
                            console.log('start csv import check');
                            
                            js.ajax({
                                url: '/index.php?task=checkCsvImport',
                                data: ({'token': token}),
                                cache: false,
                                dataType: "json",     
                                method: 'POST',
                                success: function(data){
                                    console.log(data);
                                    
                                    if(data.res.id){
                                        import_interval=0;
                                        
                                        //alert('success import');
                                        
                                        let 
                                            messages=JSON.parse(data.res.messages),
                                            html='',
                                            success_messages='Import completed successfully';
                                    
                                        console.log(messages);
                                        
                                        if(messages.length>0){
                                            js.each(messages, function(e,i){
                                                html+='<p style="margin:0px;padding:0px;">'+i+'</p>';
                                            });
                                        } else{
                                            html='<p style="margin:0px;padding:0px;color:green">'+success_messages+'</p>'
                                        }
                                        js('.import_message_wrapper').empty().html(html);
                                        
                                        js('.import_loader').hide();
                                        js('#formCSV').trigger('reset');
                                    }
                                    
                    
                                }
                            });
                        }
                    } catch (e) {
			
                    }
                },10);
            }, 1000);
            
        <?php } else{?>
            js('.import_loader').show();
            js('#formCSV').append(js(this)).submit();
        <?php } ?>
        
    });
   
    var interval_mask=setInterval(function(){
        if(js('.input_hours input').length>0){
            console.log('enable edit_break_val input mask');
            
            js('.input_hours input').mask('+00:00',  {
                translation: {
                    '+': {
                        pattern: /[\+]/, optional: true
                    }
                }
            });
            
            clearInterval(interval_mask);
        }
    },100);
    
    var interval_mask0=setInterval(function(){
        if(js('.input_time').length>0){
            console.log('enable input_time mask');
            js('.input_time').mask('00:00');
            clearInterval(interval_mask0);
        }
    },100);
    var interval_mask1=setInterval(function(){
        if(js('.input_placeedit input').length>0){
            console.log('enable input_time mask');
            js('.input_placeedit input').mask('00:00');
            clearInterval(interval_mask1);
        }
    },100);
    
    
        
   
   
});


</script>
<?php } else{?>
<script>
    jQuery(document).ready(function($){
    var js=$;
    var tr_break=js('.js_cut_break');
    js('#table-time-wages tbody tr:eq(1)').after('<tr>'+tr_break.html()+'</tr>');
    
   
});
</script>
<?php } ?>
<div id="free-license">
    <?php echo JText::_('COM_AUDIT_FREE_LICENSE'); ?>
</div>