<?php

defined('_JEXEC') or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewTask_manager_new extends JViewLegacy {

    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        $user = JFactory::getUser();
        $sys_modules = AuditController::getSystemModules();

        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }

        try {
            if ($sys_modules['enable_task_manager'] != '1') {
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_ERROR_PERMISSION'), 500);
            }
            $this->config = &JFactory::getConfig();
            $this->enable_task_manager_dk_api = $this->config->get('enable_task_manager_dk_api');
            $this->enable_adding_default_tasks = $this->config->get('enable_adding_default_tasks');
            $this->enable_gps_type_of_tasks = $this->config->get('enable_gps_type_of_tasks');
            $this->enable_automatick_clock_icon_in_task_manager = $this->config->get('enable_automatick_clock_icon_in_task_manager');
            
            JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
            $model_dk = JModelLegacy::getInstance('DK', 'AuditModel'); 
            
            //$api_dk_tasks = $model_dk->getDkTasks();
            $this->api_dk_tasks = $api_dk_tasks;
            //$this->api_dk_subtasks = $model_dk->getDkSubtasks();
           
            
        } catch (Exception $e) {
            $msg = $e->getMessage();
            $code = $e->getCode();
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }


        JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
        $model = JModelLegacy::getInstance('Task_manager', 'AuditModel');
        $this->sync_with_main_tasks_state = $model->getSyncWithMainTasksState();
        
        // $model = $this->getModel('Task_manager');
        $task_list = $model->getTaskList();
        if($this->enable_adding_default_tasks == '1' && empty(json_decode($task_list))){
            $model->addDefaultTasks();
            $task_list = $model->getTaskList();
        }
        $user_list = $model->getPrepareUserListNewPsd();
        


       
        $enable_subtask_delete = $this->config->get('enable_subtask_delete');

        if ($enable_subtask_delete != '1') {
            if (count(json_decode($task_list)) > 0) {
                $model->setDefaultSubtasks(json_decode($task_list));
            }
        }
        //jimport('joomla.application.component.controller');

        if($this->enable_gps_type_of_tasks == '1'){
            $this->stored_radius_obj = $model->getRadius(); 
            $this->gmaps_api_key = $this->config->get('gmaps_api_key');
        }
        $this->assignRef('task_list', json_decode($task_list));
        $this->assignRef('user_list', json_decode($user_list));
        $this->assignRef('model', $model);
        $this->assignRef('sys_modules', $sys_modules);

        parent::display($tpl);
    }

}
