<?php
defined( '_JEXEC' ) or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewTask_manager extends JViewLegacy
{
    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        $user = JFactory::getUser();
        $sys_modules = AuditController::getSystemModules();
        
        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        try{
            if($sys_modules['enable_task_manager'] != '1'){
                throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_ERROR_PERMISSION'), 500);
            }
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
       
        
        $model = $this->getModel('Task_manager');
        $task_list=$model->getTaskList();
        $user_list=$model->getPrepareUserList();
        
        
        
        $config=&JFactory::getConfig();  
        $enable_subtask_delete=$config->get('enable_subtask_delete');
        
        if ($enable_subtask_delete != '1') {
            if (count(json_decode($task_list)) > 0) {
                $model->setDefaultSubtasks(json_decode($task_list));
            }
        }
        //jimport('joomla.application.component.controller');
        
        
        $this->assignRef('task_list', json_decode($task_list));
        $this->assignRef('user_list', json_decode($user_list));
        $this->assignRef('model', $model);
        $this->assignRef('sys_modules', $sys_modules);
        
        parent::display($tpl);
    }
    
   

}