<?php
defined( '_JEXEC' ) or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewRules_new extends JViewLegacy
{
    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display() {
        $user = JFactory::getUser();
        $sys_modules = AuditController::getSystemModules();
        
        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        /*echo '<pre>';
        print_r($sys_modules);
        echo '</pre>';*/
        try{
            if($sys_modules['enable_rules'] != '1'){
                throw new Exception(JText::_('COM_AUDIT_RULES_ERROR_PERMISSION'), 500);
            }
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        //$model = $this->getModel('Rules');
        //$table_status = $model->checkTable();
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
        $model = JModelLegacy::getInstance('Rules', 'AuditModel');        
        
        $table = $model->getTableWithRules();       
        $table_shifts=$model->getTableShifts();
        $table_loops=$model->getTableLoops();
        $table_spec_rules=$model->getTableSpecRules();
        $getBreakarray=json_decode($model->getBreakArray());
        $config=&JFactory::getConfig();
        $new_button_enable=$config->get('enable_new_rule');
        $enable_loop_4_weeks_rule=$config->get('enable_loop_4_weeks_rule');
        $enable_prefill_union_rules = $config->get('enable_prefill_union_rules');
        
        $lang_obj = & JFactory::getLanguage();
        if ($lang_obj->getName() == "Íslenska (Ísland)") {
            $lang = 'is';
        } else{
            $lang = 'en';
        }
        
       
        
        //echo date('d.m.Y H:i:s', strtotime($user->registerDate)).PHP_EOL;
        //echo date('d.m.Y H:i:s', strtotime('2022-19-05 13:40:00'));
        
        if($enable_prefill_union_rules == '1' && $user->is_added_prefilled_union_rules != 1 && strtotime($user->registerDate) > DateTime::createFromFormat('Y-m-d H:i:s', '2022-05-19 13:40:00')->format('U')){
            $model->addPrefilledRules('union', $lang);
        }
         if($new_button_enable=='1'){
            $table_rules0 = $model->getTableRules0();
        }
        $this->assignRef('rules', $table);
        $this->assignRef('shifts', $table_shifts);
        $this->assignRef('loops', $table_loops);
        $this->assignRef('break', $getBreakarray);
        $this->assignRef('spec_rules', $table_spec_rules);
        $this->assignRef('rules0', $table_rules0);
        
        if($enable_loop_4_weeks_rule=='1'){
            $table_loops4=$model->getTableLoops4();
            $this->assignRef('loops4', $table_loops4);
        }
        
        $this->assignRef('config', $config);
        
     
        $this->setLayout('default');
        
        parent::display($tpl);
    }
    
   

}