<?php
defined( '_JEXEC' ) or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewRules extends JViewLegacy
{
    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display() {
        $user = JFactory::getUser();
        $sys_modules = AuditController::getSystemModules();
        
        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        /*echo '<pre>';
        print_r($sys_modules);
        echo '</pre>';*/
        try{
            if($sys_modules['enable_rules'] != '1'){
                throw new Exception(JText::_('COM_AUDIT_RULES_ERROR_PERMISSION'), 500);
            }
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        $model = $this->getModel('Rules');
        //$table_status = $model->checkTable();
        
        $table=$model->getTableWithRules();       
        $table_shifts=$model->getTableShifts();
        $table_loops=$model->getTableLoops();
        $table_spec_rules=$model->getTableSpecRules();
        $getBreakarray=json_decode($model->getBreakArray());
        $config=&JFactory::getConfig();
        $new_button_enable=$config->get('enable_new_rule');
        $enable_loop_4_weeks_rule=$config->get('enable_loop_4_weeks_rule');
        
        if($new_button_enable=='1'){
            $table_rules0=$model->getTableRules0();
        }
        
        $this->assignRef('rules', $table);
        $this->assignRef('shifts', $table_shifts);
        $this->assignRef('loops', $table_loops);
        $this->assignRef('break', $getBreakarray);
        $this->assignRef('spec_rules', $table_spec_rules);
        $this->assignRef('rules0', $table_rules0);
        
        if($enable_loop_4_weeks_rule=='1'){
            $table_loops4=$model->getTableLoops4();
            $this->assignRef('loops4', $table_loops4);
        }
        
        $this->assignRef('config', $config);
        
        $enable_rules_header_editable=$config->get('enable_rules_header_editable');
        if($enable_rules_header_editable=='1'){
            $this->setLayout('default_with_editable');
        }
        parent::display($tpl);
    }
    
   

}