<?php

defined('_JEXEC') or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewRoute_map extends JViewLegacy {

    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        $app = JFactory::getApplication();

        $this->task = $app->input->getCmd('task');
        $this->view = $app->input->getCmd('view');
        $this->u_id = $app->input->getInt('user_id');
        $this->route_id = $app->input->getInt('route_id');

        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        try {
            $u = JFactory::getUser();
            $lang = & JFactory::getLanguage();
            
            if ($lang->getName() == "Íslenska (Ísland)") {
                $l2 = 'is';
            } else {
                $l2 = 'en';
            }
            $config = &JFactory::getConfig();

            $enable_gps_task_changes = $config->get('enable_gps_task_changes');
            if($enable_gps_task_changes != '1'){
                throw new Exception(JText::_('COM_AUDIT_ROUTE_MAP_ERROR_DISABLED'));
            }

            if (empty($this->u_id)) {
                JLoader::register('AuditModelReport', JPATH_ROOT . '/components/com_audit/models/report.php');
                $model_reportz = JModelLegacy::getInstance('report', 'AuditModel');
                $this->u_id = $model_reportz->getFirstCompanyUserId();
            }
            
            $model = JModelLegacy::getInstance('Gps', 'AuditModel');
            $this->user = JFactory::getUser($this->u_id);
            if (empty($this->route_id)) {
                
                //load last user route id
                //$last_user_route = $model->getUserRoutes($this->user)[0];
                $last_user_route = $model->getUserRouteWithCustom($this->user->id, null);
                
                if(empty($last_user_route['standart'])){
                    throw new Exception('User don\'t have routes');  
                }
                
                $this->route_id = $last_user_route['standart'][0]->id;
                $this->route = $last_user_route['standart'][0];
                $this->custom = $last_user_route['custom'];
            }
            
            if (!empty($this->route_id)) {
                //$this->route = $model->getRoute($this->user, $this->route_id);
                $route = $model->getUserRouteWithCustom($this->user->id, $this->route_id);
                $this->route = $route['standart'][0];
                $this->custom = $route['custom'];
                
                /*echo '<pre>$this->route';
                print_r($this->route);
                echo '</pre>';
                
                echo '<pre>$this->custom';
                print_r($this->custom);
                echo '</pre>';*/
                //exit;
            }
            
            $this->start_obj = json_decode($this->route->from_coordinates, true);
            if(!empty($this->start_obj)){
                $this->formatted_start = $model->formatCoordinates($this->start_obj);
            }
            $this->stop_obj = json_decode($this->route->to_coordinates, true);
            if(!empty($this->stop_obj)){
                $this->formatted_stop = $model->formatCoordinates($this->stop_obj);
            }
            $this->final_gps = array_merge($this->formatted_start, $this->formatted_stop);
            
            //$this->routes = $model->getRoutes($this->u_id, $this->date);
            //$this->tr_ids = [];
            //foreach($this->routes['standart'] as $route){
            //$this->tr_ids[] = 'tr-'.$route->id;
            //}
            JLoader::register('AuditModelTask_manager', JPATH_ROOT . '/components/com_audit/models/task_manager.php');
            $model_task_manager = JModelLegacy::getInstance('Task_manager', 'AuditModel');

            //$this->available_tasks = $model_task_manager->loadTaskListForDnT($l2, $this->user);
            $this->model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
            $this->countries_list = $this->model_settings->getCountriesList();
          
            $this->map_center_json = $this->user->routes_map_center;
            $this->map_center = json_decode($this->map_center_json);
            
            
            //$saved_country = $model0->getSavedCountry()->gmap_center;
            
            
            $this->field_list = [
                'manual_time' => [
                    'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_MANUAL_TIME'),
                    'field_value' => 'manual_time'
                ],
                'manual_text' => [
                    'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_MANUAL_TEXT'),
                    'field_value' => 'manual_text'
                ],
                'auto_col_text' => [
                    'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_AUTO_COL_TEXT'),
                    'field_value' => 'auto_col_text'
                ],
                'numbers' => [
                    'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_NUMBERS'),
                    'field_value' => 'numbers'
                ],
                'total' => [
                    'field_name' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEVICES_N_TOOLS_PAGE_FIELDS_POPUP_TOTAL'),
                    'field_value' => 'total'
                ]
            ];

            $this->map_key = 'AIzaSyCqyCP48wsmm8wwMm77mwfDBQJbnbqTzrU'; //current site key
            //$this->map_key = 'AIzaSyBqAD4avBQ56KkFrFwrwb8vMRURe6qgURo';//frumherji key
            
            $from_decoded = json_decode($this->route->from_coordinates);
            $this->from_formatted = $from_decoded->lat . ',' . $from_decoded->lng;
            $to_decoded = json_decode($this->route->to_coordinates);
            $this->to_formatted = $to_decoded->lat . ',' . $to_decoded->lng;
            
        } catch (Exception $e) {
            $msg = $e->getMessage();
            $code = $e->getCode();
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        parent::display($tpl);
    }

}
