<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/

defined( '_JEXEC' ) or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewEarned_income_new extends JViewLegacy
{
    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {  
      
        $app = JFactory::getApplication();
        

        $user_id_from_request = $app->input->getInt('u_id');
        $lang = $app->input->getString('lang');
        $calc_params = $app->input->getObject('calc_params');
       
        $pay_period = $app->input->getObject('pay_period');
        $config = &JFactory::getConfig();
        $enable_excel_button_in_ei_page = $config->get('enable_excel_button_in_ei_page');
        /*echo '<pre>';
        print_r($pay_period);
        echo '</pre>';*/
        
        try {
            if($user_id_from_request==0){
                // exception generating code
                throw new Exception(JText::_('COM_AUDIT_ERROR_NO_USER_ID'), 500);
            }
            /*if(empty($calc_params)){
                throw new Exception(JText::_('COM_AUDIT_ERROR_NO_CALC_PARAMS'), 500);
            }*/
            $user_from_request = JFactory::getUser($user_id_from_request);
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            
            $pay_period_from_saves = $model->loadEIPeriod($user_from_request);
            
            /*echo '<pre>';
            print_r($pay_period_from_saves);
            echo '</pre>';*/
            
            if(empty($pay_period)){
                throw new Exception(JText::_('COM_AUDIT_ERROR_NO_PAY_PERIOD'), 500);
            }
            $individual_params=[
                'user_obj'=>$user_from_request,
            ];
            $permission_check = $model->checkPermission('openEIPage', $individual_params);
            if($permission_check == 0){
                throw new Exception(JText::_('COM_AUDIT_EARNED_INCOME_ERROR_PERMISSION'), 500);
            }
           
            $user_from_request_name = '';
            if(!empty($user_from_request->username0)){ 
                $user_from_request_name = $user_from_request->username0;
            } elseif(!empty($user_from_request->username)){ 
                $user_from_request_name = $user_from_request->username;
            } elseif(!empty($user_from_request->name)){ 
               $user_from_request_name = $user_from_request->name;    
            }
            
            if(!empty($pay_period_from_saves['from']) && !empty($pay_period_from_saves['to'])){
                $pay_period = $pay_period_from_saves;
                $converted_from_to = $model->convertPayPeriodFromTo4((array)$pay_period);
                $all_items_user = $model->getAllEarnedIncomeRecords2((array)$pay_period, $user_from_request);
            } else{
                $converted_from_to = $model->convertPayPeriodFromTo((array)$pay_period);
                $all_items_user = $model->getAllEarnedIncomeRecords(0, $user_from_request);
            }
           
            //$converted_from_to2 = $model->convertPayPeriodFromTo2((array)$pay_period); 
           
          
            
            $not_permitted_field_array = AuditController::getNotPermittedEarnedIncomeKeys();
            $totals = $model->calcEarnedIncomeTotals($all_items_user, $not_permitted_field_array);
            
           
            $next_user = $model->getNextUser($user_from_request->id, $lang);
          
            
            $this->assignRef('user', $user_from_request);
            $this->assignRef('user_from_request_name', $user_from_request_name);
            $this->assignRef('calc_params', $calc_params);
            $this->assignRef('all_items_user', $all_items_user);
            $this->assignRef('pay_period', $pay_period);
            $this->assignRef('not_permitted_field_array', $not_permitted_field_array);
            $this->assignRef('totals', $totals);
            $this->assignRef('count_totals', count($totals));
            $this->assignRef('model_calc', $model);
            $this->assignRef('converted_from_to', $converted_from_to);
            $this->assignRef('next_user', $next_user);
            $this->assignRef('lang', $lang);
            $this->assignRef('enable_excel_button_in_ei_page', $enable_excel_button_in_ei_page);
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        $this->loadHelper('audit');
        parent::display($tpl);
    }
}