<?php

defined('_JEXEC') or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewCompany_mods extends JViewLegacy {

    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        $this->app = JFactory::getApplication();

        $this->task = $this->app->input->getCmd('task');
        $this->view = $this->app->input->getCmd('view');
        //$this->u_id = $app->input->getInt('user_id');
        //$this->route_id = $app->input->getInt('route_id');

        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        try {
            $u = JFactory::getUser();
            $lang = & JFactory::getLanguage();
            
            if ($lang->getName() == "Íslenska (Ísland)") {
                $l2 = 'is';
            } else {
                $l2 = 'en';
            }
            $config = &JFactory::getConfig();
            $this->user = $u;
            
            
            JLoader::register('CtapiModelApi', JPATH_ADMINISTRATOR . '/components/com_ctapi/models/api.php');
            $this->model = JModelLegacy::getInstance('Api', 'CtapiModel');
            $document = JFactory::getDocument();
               

            $this->companies = $this->model->getCompanies(1);
            $this->mods = $this->model->allMods();
            $this->enable_default_rules = $config->get('enable_default_rules');
            $this->default_rules_base_company = $config->get('default_rules_base_company');
            $this->enable_active_company = $config->get('enable_active_company');
            $this->enable_prices_in_reseller_page = $config->get('enable_prices_in_reseller_page');
            
            if($this->enable_prices_in_reseller_page == '1'){
                JLoader::register('AuditModelReseller', JPATH_ROOT . '/components/com_audit/models/reseller.php');
                $model_reseller = JModelLegacy::getInstance('Reseller', 'AuditModel');
            
                $this->stored_default_price = $model_reseller->getDefaultPrice();
                $this->total_fees = 0;
                
                foreach ($this->companies as $company => $mods) {
                    if (($this->enable_default_rules == '1' && !empty($this->default_rules_base_company) && in_array($company, $this->default_rules_base_company)) || $company == 'Sample Company')
                        continue;
                    
                    foreach ($this->mods as $mod => $modLabel) {
                        if(in_array($mod, array("subs_price"))){
                            $this->total_fees += $mods[$mod];
                        }
                    }
                }
            }
            if($this->enable_active_company == '1'){
                $this->mods['pending'] = JText::_('COM_AUDIT_COMPANY_MODS_PENDING');
                $this->mods['active'] = JText::_('COM_AUDIT_COMPANY_MODS_ACTIVE');
                
                
            }
            
            //calc total users limit
            foreach ($this->companies as $company => $mods){
                if(($this->enable_default_rules == '1' && !empty($this->default_rules_base_company) && in_array($company, $this->default_rules_base_company)) || $company == 'Sample Company') continue;
                foreach ($this->mods as $mod => $modLabel){
                    if (in_array($mod, ["user_limit"])){
                        if (!empty($mods[$mod])) {
                            $this->calculated_total += intval($mods[$mod]);
                        } else {
                            $res_check = $this->model->checkCompanyIsNew($company);
                            if ($res_check->company_is_new == 1) {
                                $this->calculated_total += $this->model->saveNewCompany($company);
                            } 
                        } 
                    }
                    if($this->enable_active_company == '1' && in_array($mod, ["active"])){
                        if (!empty($mods[$mod])) {
                            $this->calculated_active += intval($mods["user_limit"]);
                        }      
                    }
                }
            }
        } catch (Exception $e) {
            $msg = $e->getMessage();
            $code = $e->getCode();
            $this->app->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        parent::display($tpl);
    }

}
