<?php

defined('_JEXEC') or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewCalc_New extends JViewLegacy {

    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $app = JFactory::getApplication();
        $user_id_from_request = $app->input->getInt('u_id');
        
        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        try {
            if($user_id_from_request == 0){
                // exception generating code
                throw new Exception(JText::_('COM_AUDIT_ERROR_NO_USER_ID'), 500);
            }
            
             
            $user_from_request = JFactory::getUser($user_id_from_request);
            $lang = & JFactory::getLanguage();


            if ($lang->getName() == "Íslenska (Ísland)") {
                $l2 = 'is';
            } else {
                $l2 = 'en';
            }
            
            $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
            $company_mods = $model_reg->getAvailableMudules($user_from_request->company, $l2);
            if($company_mods['status'] == '1'){
                $enable_calc = $company_mods['data']['enable_calculator'];
            } else{
                $enable_calc = 0;
            }
            
            if($enable_calc == 0){
                throw new Exception(JText::_('COM_AUDIT_EMPL_STAFF_AVL_MODULE_ERROR_NOT_ENABLED_ALERT'), 500);
            }
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            $individual_params=[
                'user_obj'=>$user_from_request,
            ];
            $permission_check = $model->checkPermission('openCalcPage', $individual_params);
            if($permission_check == 0){
                throw new Exception(JText::_('COM_AUDIT_CALC_ERROR_PERMISSION'), 500);
            }
            
            $user_from_request_name = '';
            if(!empty($user_from_request->username0)){ 
                $user_from_request_name = $user_from_request->username0;
            } elseif(!empty($user_from_request->username)){ 
                $user_from_request_name = $user_from_request->username;
            } elseif(!empty($user_from_request->name)){ 
               $user_from_request_name = $user_from_request->name;    
            }
            
            
            $user_save = $model->loadCurrentUserSave($user_from_request);
            $from_to_user = $model->getFromToForCalc($user_from_request->id);
            $config = &JFactory::getConfig();
            $enable_excel_button_in_ei_page = $config->get('enable_excel_button_in_ei_page');
            
            $this->assignRef('enable_excel_button_in_ei_page', $enable_excel_button_in_ei_page);
            $this->assignRef('user_from_request_name', $user_from_request_name);
            $this->assignRef('user_save', $user_save);
            $this->assignRef('from_to_default', $from_to_user);
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        $this->loadHelper('audit');
        parent::display($tpl);
    }

}
