<?php

defined('_JEXEC') or die; // No direct access

/**
 * View for  current element
 * @author 
 */
class AuditViewCalc_For_New_Module extends JViewLegacy {

    /**
     * Method of display current template
     * @param type $tpl
     */
    public function display($tpl = null) {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $app = JFactory::getApplication();
        $user_id_from_request = $app->input->getInt('u_id');
        $user_id_raw_from_request = $app->input->get('u_id');
        $open_ei = $app->input->getString('open_ei');
        
        $session = JFactory::getSession();
        $sessionQueue = $session->get('application.queue');
        if (count($sessionQueue)) {
            $session->set('application.queue', null);
        }
        
        try {
            if($user_id_from_request == 0){
                // exception generating code
                $model_reportz = JModelLegacy::getInstance('report', 'AuditModel');
                $user_id_from_request = $model_reportz->getFirstCompanyUserId();
               // throw new Exception(JText::_('COM_AUDIT_ERROR_NO_USER_ID'), 500);
            }
            
             
            $user_from_request = JFactory::getUser($user_id_from_request);
            $lang = & JFactory::getLanguage();


            if ($lang->getName() == "Íslenska (Ísland)") {
                $l2 = 'is';
            } else {
                $l2 = 'en';
            }
            
            $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
            $company_mods = $model_reg->getAvailableMudules($user_from_request->company, $l2);
            if($company_mods['status'] == '1'){
                $enable_calc = $company_mods['data']['enable_calculator'];
            } else{
                $enable_calc = 0;
            }
            
            if($enable_calc == 0){
                throw new Exception(JText::_('COM_AUDIT_EMPL_STAFF_AVL_MODULE_ERROR_NOT_ENABLED_ALERT'), 500);
            }
          
            if (!file_exists( $_SERVER['DOCUMENT_ROOT'] . '/modules/mod_customcalc7/mod_customcalc7.php')){
                throw new Exception('Please, install mod_customcalc7 firstly.');
            }
            
            
            JLoader::register('AuditModelCalc', JPATH_ROOT . '/components/com_audit/models/calc.php');
            $model = JModelLegacy::getInstance('Calc', 'AuditModel');
            $individual_params=[
                'user_obj'=>$user_from_request,
            ];
            $permission_check = $model->checkPermission('openCalcPage', $individual_params);
            if($permission_check == 0){
                throw new Exception(JText::_('COM_AUDIT_CALC_ERROR_PERMISSION'), 500);
            }
            
            $user_from_request_name = '';
            if(!empty($user_from_request->username0)){ 
                $user_from_request_name = $user_from_request->username0;
            } elseif(!empty($user_from_request->username)){ 
                $user_from_request_name = $user_from_request->username;
            } elseif(!empty($user_from_request->name)){ 
               $user_from_request_name = $user_from_request->name;    
            }
            
            
            $user_save = $model->loadCurrentUserSave($user_from_request);
            $from_to_user = $model->getFromToForCalc($user_from_request->id);
            $config = &JFactory::getConfig();
            $enable_excel_button_in_ei_page = $config->get('enable_excel_button_in_ei_page');
            
            ///load pay period(from and to dates)
            $model_pay_period = JModelLegacy::getInstance('Custom_pay_period', 'AuditModel');
            $from_to = json_decode($model_pay_period->getInputsPayPeriod($user_from_request->id));

            $current_date = date('d.m.Y');

            $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
            $from_date2 = $from_date1->format('d');
            $from_date = $from_date2 . date('.m.Y');
            
            $day = 0;
            if (date('m') == 02) {
                switch ($from_date2) {
                    case 29:
                        if (!date('L')) {
                            $day = 86400;
                            $from_date = '28' . date('.m.Y');
                        }
                    break;
                    case 30:
                        $day = 86400 * 2;
                        $from_date = '28' . date('.m.Y');
                    break;
                    case 31:
                        $day = 86400 * 3;
                        $from_date = '28' . date('.m.Y');
                    break;
                }
            }
            
            $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
            $to_date2 = $to_date1->format('d');
            $to_date1_clone = clone $to_date1;

            if ($from_date2 == '01')
                //$to_date = $to_date2 . date('.m.Y');
                $to_date = DateTime::createFromFormat('d.m.Y H:i:s', date('d.m.Y H:i:s', strtotime('last day of this month')))->format('d.m.Y');
            else
                $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));

            //echo '<br/>'.$from_date;

            if ($current_date < $from_date) {

                $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

                $from_date_strtotime = strtotime($from_date_row . '-1months') + $day;
                //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
                $from_date = date('d.m.Y', $from_date_strtotime);
                $from_date00 = date('Y-m-d', $from_date_strtotime);
                $count_days_in_month = date('t', strtotime($from_date00));

                if ($count_days_in_month == 31 && date('m') != 02) {
                    $from_date_strtotime = strtotime($from_date_row . '-1months');
                    $from_date = date('d.m.Y', $from_date_strtotime);
                }


                $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
                $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
                $to_date = date('d.m.Y', $to_date_strtotime);
            }
            ///
          
              
            $this->assignRef('enable_excel_button_in_ei_page', $enable_excel_button_in_ei_page);
            $this->assignRef('user_from_request_name', $user_from_request_name);
            $this->assignRef('user_save', $user_save);
            $this->assignRef('from_to_default', $from_to_user);
            $this->user_from_request = $user_from_request;
            $this->pp_from = $from_date; 
            $this->pp_to = $to_date;
            $this->pp_url = $l2 . '/pay-period-clock/pay_period_new/' . $user_from_request->id;
            $this->pure_calc_url = $l2 . '/calc-for-new-module?u_id=' . $user_from_request->id;
            
            $this->user_id_raw_from_request = $user_id_raw_from_request;
            $this->open_ei = $open_ei;
        } catch (Exception $e) {
            $msg = $e->getMessage(); 
            $code = $e->getCode(); 
            JFactory::getApplication()->enqueueMessage($msg, 'error', $code);
        }

        if (count($errors = $this->get('Errors'))) {
            throw new Exception(implode("\n", $errors));
        }
        
        $this->loadHelper('audit');
        parent::display($tpl);
    }

}
