<?php

// No direct access
defined('_JEXEC') or die;

/**

 * @author

 */
class AuditModelUniconta extends JModelLegacy {

    public $uniconta_access_path;
    public $uniconta_tasks_path;
    
    public function __construct() 
    {
        parent::__construct();
 
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
	$this->config = &JFactory::getConfig(); 
        $this->current_home_path = $this->config->get('current_home_path');
        
        $this->uniconta_access_path = 'https://odata.uniconta.com/api/Entities/EmployeeClient';
        $this->uniconta_tasks_path = 'https://odata.uniconta.com/api/Entities/ProjectClient';
        $this->uniconta_table_name = '#__uniconta_tasks';
        $this->subtask_table_name = '#__uniconta_subtasks';
    }
    
    public function checkAccessData(string $username, string $password)
    {
        $data = [
           'username' => $username,
           'password' => $password
        ];
        $res = 0;
        $responses = $this->curlCall($this->uniconta_access_path, $data);
        if(!empty($responses['curl_response'])){
            $res = 1;
        }
        return $res;
    }
    
    public function curlCall($url, $data, $as_object = null)
    {
        $curl = curl_init();
        

        $post = http_build_query($data);
        $options = [
            CURLOPT_URL => $url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_CUSTOMREQUEST => 'GET',
            CURLOPT_POSTFIELDS => $post,
            CURLOPT_CONNECTTIMEOUT => 0,
            CURLOPT_USERPWD => $data['username'] . ':' . $data['password']
        ];

        curl_setopt_array($curl, $options);
        $out = curl_exec($curl);
        curl_close($curl);
        
        if($as_object === 1){
            $res = json_decode(trim($out), false);
        } else{
            $res = json_decode(trim($out), true);
        }
        
        if(empty($res)){
            $res = [];
        }
        
        return [
            'raw_curl_response' => $out,
            'curl_response' => $res
        ];
    }
    
    public function updateUnicontaAccess(string $username, string $password)
    {
        $item = new stdClass;
        
        $item->id = $this->user->owner_id;
        $item->uniconta_uname = $username;
        $item->uniconta_upassw = $password;
        
        if(!empty($this->user->uniconta_uname) && !empty($this->user->uniconta_upassw) && ($this->user->uniconta_uname != $username || $this->user->uniconta_upassw != $password)){
            $query = "DELETE FROM $this->uniconta_table_name WHERE `id_user` = '".$this->user->owner_id."';";
            $this->db->setQuery($query);
            $this->db->query();
        
            $query = "DELETE FROM $this->subtask_table_name WHERE `id_user` = '".$this->user->owner_id."';";
            $this->db->setQuery($query);
            $this->db->query();
        }
        $this->db->updateObject( '#__users', $item, 'id' );  
        
        
    }
    
    public function updateUnicontaState($state, string $lang)
    {
        $item = new stdClass;
        if($state === 'true'){
            $state = 1;
        } else{
            $state = 0;
        }
        $item->id = $this->user->owner_id;
        $item->uniconta_state = $state;
       
        
        $this->db->updateObject( '#__users', $item, 'id' ); 
    }
    
    public function updateUnicontaSyncTasksState($state, string $lang)
    {
        $item = new stdClass;
        if($state === 'true'){
            $state = 1;
        } else{
            $state = 0;
        }
        $item->id = $this->user->owner_id;
        $item->sync_uniconta_tasks = $state;
       
        
        $this->db->updateObject( '#__users', $item, 'id' ); 
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res = '0';
        
        switch($type){
            case 'loadUnicontaTasks':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $user_id_from_request = $individual_params['user_from_request'];
                //$user_id_for_clone = $individual_params['user_for_clone_obj'];
                
                $user_from_request_obj = & JFactory::getUser($user_id_from_request);
                //$user_id_for_clone_obj = & JFactory::getUser($user_id_for_clone);
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && ($user_from_request_obj->owner_id == $owner_id)){
                    $res = '1';
                }
            break;
        }
      
       
       return $res;
    }
    
    public function loadUnicontaTasks()
    {
        $data = [
           'username' => $this->user->uniconta_uname,
           'password' => $this->user->uniconta_upassw
        ];
       
        $responses = $this->curlCall($this->uniconta_tasks_path, $data, 1);
        //$responses['curl_response'][153]->Name = 'nytt verk TEST';
        //$responses['curl_response'][153]->Account = '007';
        return $responses['curl_response'];
    }
    
    
}