<?php

// No direct access
defined('_JEXEC') or die;

/**
 * @author 
 */
class AuditModelTime_Wages extends JModelLegacy {
    
    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->user = JFactory::getUser();
        $this->config = &JFactory::getConfig();
        $this->enablelimit_for_total_hours_in_all_fields = $this->config->get('enablelimit_for_total_hours_in_all_fields');
        $this->current_url = $this->config->get('current_url');
        $this->enable_separate_pay_holidays = $this->config->get('enable_separate_pay_holidays');
        
        //include JPATH_ROOT . '/app_api/php-image-resize-master/lib/ImageResize.php';
    }
    
    public function getTable() {
        $user = JFactory::getUser();
        $date = date('Y-m-d');
        //$query = "SELECT * FROM #__audit_time_wages WHERE date_format(date, '%Y%m') = date_format('$date', '%Y%m') AND id_user = '$user->id'";
        //$query = "SELECT * FROM #__audit_time_wages ";

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `id`, `id_user`, `day_time`, `after_hours`, `night_time`, `overtime_work`, `public_holidays` FROM #__audit_time_wages WHERE id_user = '$id_user'";
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();
        
        $model_rules=JModelLegacy::getInstance('rules', 'AuditModel');
               
        if(empty($data[0]->day_time)){
            $data[0]->day_time=$model_rules->getDefaultTimeWagesValues('day_time_start');   
            $data[0]->mode='is_empty';
        } if(empty($data[0]->after_hours)){
            $data[0]->after_hours=$model_rules->getDefaultTimeWagesValues('after_hours_start');  
            $data[0]->mode='is_empty';
        } if(empty($data[0]->overtime_work)){
            $data[0]->overtime_work=$model_rules->getDefaultTimeWagesValues('overtime_work_start');
            $data[0]->mode='is_empty';            
        } if(empty($data[0]->public_holidays)){
            $data[0]->public_holidays=$model_rules->getDefaultTimeWagesValues('public_holidays_start'); 
            $data[0]->mode='is_empty';
        } if(empty($data[0]->night_time)){
            $data[0]->night_time=$model_rules->getDefaultTimeWagesValues('night_time_start');   
            $data[0]->mode='is_empty';
        }
        
        if(empty($data[1]->day_time)){
            $data[1]->day_time=$model_rules->getDefaultTimeWagesValues('day_time_end');   
            $data[1]->mode='is_empty';
        } if(empty($data[1]->after_hours)){
            $data[1]->after_hours=$model_rules->getDefaultTimeWagesValues('after_hours_end'); 
            $data[1]->mode='is_empty';
        } if(empty($data[1]->overtime_work)){
            $data[1]->overtime_work=$model_rules->getDefaultTimeWagesValues('overtime_work_end');
            $data[1]->mode='is_empty';            
        } if(empty($data[1]->public_holidays)){
            $data[1]->public_holidays=$model_rules->getDefaultTimeWagesValues('public_holidays_end'); 
            $data[1]->mode='is_empty';
        } if(empty($data[1]->night_time)){
            $data[1]->night_time=$model_rules->getDefaultTimeWagesValues('night_time_end');   
            $data[1]->mode='is_empty';
        }
        //$data=(object)$data;
        
        return $data;
    }

     public function createTable(...$a) {
        $args=func_get_args();
        $params=  $args[0];
        
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();
        if (!empty($params)) {
            $date = $params;
        } else {
            $date = date('Y-m-d');
        }


        for ($i = 0; $i < 3; $i++) {
            $item = new stdClass;
            $item->id = NULL;
            $item->id_user = $user->id;
            $item->day_time = "";
            $item->after_hours = "";
            $item->night_time="";
            $item->overtime_work = "";
            $item->public_holidays = "";
            
            $item->day_break_time="";
            $item->day_time_to_break="";
            $item->after_hours_break_time="";
            $item->after_hours_time_to_break="";
            $item->night_time_break_time="";
            $item->night_time_time_to_break="";
            $item->overtime_work_break_time="";
            $item->overtime_work_time_to_break="";
            $item->public_holidays_break_time="";
            $item->public_holidays_time_to_break="";
            
            $item->date = $date;
            $db->insertObject('#__audit_time_wages', $item, 'id');
        }
    }

    public function updateTable() {

        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
       
        
      
           $query = "UPDATE #__audit_time_wages SET $field='$valueField' WHERE id='$id'";
           $db->setQuery($query);
           if ($db->query()) {
                echo $valueField;
                /*echo '<pre>';
                print_r($valueField0);
                echo '</pre>';*/
           } 
        
        
    }
    
    public function checkTable()
    {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();
        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }
        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }
        
        $query = "SELECT * FROM #__audit_time_wages WHERE id_user = '$id_user'";
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();
        
        if(!empty($data)){
            $res='success';
        } else{
            $res='error';
        }
        
        return $res;
    }
    
    private function resizeImage($path, $width) {
        include JPATH_ROOT . '/app_api/php-image-resize-master/lib/ImageResize.php';
        
        $image = new Gumlet\ImageResize($path);
        $image->resizeToWidth($width);
        
        jimport( 'joomla.filesystem.file' );
            
        if (JFile::exists($path)) {
            JFile::delete($path);
        }
           
            
        $image->save($path);
    }
    
     public function uploadImagesNewPsd() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();
        jimport('joomla.filesystem.file');
        
        $typeImg = $_POST['typeImg'];

        $file = JRequest::getVar($typeImg, null, 'files', 'array');
       
        if (!empty($file)) {
            
            $userCompany = strtolower(str_replace(' ', '_', $user->company));
            $filename = JFile::makeSafe($file['name']);
            $src = $file['tmp_name'];

            $newFileName = $userCompany . '_' . str_replace($filename, $typeImg, $filename);
            $newFileName = str_replace(' ', '', $newFileName) . '.png';

            $dest = $_SERVER['DOCUMENT_ROOT'] . '/images/company_images/' . $newFileName;
            if (JFile::upload($src, $dest)) {
                if($typeImg == "logo"){
                    $this->resizeImage($dest, 300);
                } elseif($typeImg == "bg"){
                    $this->resizeImage($dest, 1920);
                }
                
                $company = $this->getCompanyImages($user->company);

                if (empty($company->company)) {
                    $item = new stdClass;
                    $item->id = NULL;
                    $item->id_user = $user->id;
                    $item->company = $user->company;
                    $item->$typeImg = $newFileName;
                    $db->insertObject('#__company_media', $item, 'id');
                } else {
                    $item = new stdClass;
                    $item->company = $user->company;
                    $item->$typeImg = $newFileName;
                    $db->updateObject('#__company_media', $item, 'company');
                }
            }
        }
    }
    
    public function uploadImages() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();
        jimport('joomla.filesystem.file');
        
        $typeImg = $_POST['typeImg'];

        $file = JRequest::getVar($typeImg, null, 'files', 'array');
       
        if (!empty($file)) {
            
            $userCompany = strtolower(str_replace(' ', '_', $user->company));
            $filename = JFile::makeSafe($file['name']);
            $src = $file['tmp_name'];

            $newFileName = $userCompany . '_' . str_replace($filename, $typeImg, $filename);
            $newFileName = str_replace(' ', '', $newFileName) . '.png';

            $dest = $_SERVER['DOCUMENT_ROOT'] . '/images/company_images/' . $newFileName;
            if (JFile::upload($src, $dest)) {
                $company = $this->getCompanyImages($user->company);

                if (empty($company->company)) {
                    $item = new stdClass;
                    $item->id = NULL;
                    $item->id_user = $user->id;
                    $item->company = $user->company;
                    $item->$typeImg = $newFileName;
                    $db->insertObject('#__company_media', $item, 'id');
                } else {
                    $item = new stdClass;
                    $item->company = $user->company;
                    $item->$typeImg = $newFileName;
                    $db->updateObject('#__company_media', $item, 'company');
                }
            }
        }
    }

    public static function getCompanyImages($companyName) {
        $db = & JFactory::getDBO();
        $query = "SELECT * FROM #__company_media WHERE company = '$companyName'";
        $db->setQuery($query);
        $company = $db->loadObject();
        $config = JFactory::getConfig();
         
        if(empty($company->logo)){   
            if($config->get('enable_new_logo')=='1'){
                $company->logo='default_logo_new.png';  
            } else{
                $company->logo='default_logo.png';  
            }
                           
        }
        if(empty($company->bg)){                  
            $company->bg='default_bg1.jpg';                  
        }
        
        return $company;
    }
    
    public function getCountriesList()
    {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_URL, 'https://restcountries.com/v2/all');
        $countries_json = curl_exec($ch);
        curl_close($ch); 
        $obj = json_decode($countries_json);
        
        return $obj;
    }
    
    public function getSavedCountry()
    {
        $user_joomla = JFactory::getUser()->id;
        $db = & JFactory::getDBO();
        $query = "SELECT `gmap_center` FROM #__users WHERE `id` = '".$user_joomla."'";
        $db->setQuery($query);
        $res = $db->loadObjectList();
        
        if(empty($res[0]->gmap_center)){
            $res[0]->gmap_center='Iceland';
        }
        return $res[0];
    }
    
    public function getBreakArray()
    {
        $user = $this->user;
        $date = date('Y-m-d');
        
        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT * FROM #__audit_time_wages WHERE id_user = '$id_user'";
       
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data[0]);
    }
    
    public function editBreakTime($input)
    {
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];
        
      
            $idField = explode('-', $idField);
            $field = $idField[0];
            $id = $idField[1];
        
        
        $date = date('Y-m-d');
        
         switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        $query = "UPDATE #__audit_time_wages SET $field='$valueField' WHERE id='$id'";
        $this->db->setQuery($query);
        
        //return $query;
        if ($this->db->query()) {
            return $valueField;
        } 
    }
    
    public function setRuleNumber($rule_number, $user_id)
    {
       $user_with_request=JFactory::getUser($user_id);
       if($this->user->owner_id==$user_with_request->owner_id){
            $query = "UPDATE #__users SET `rule_number`='$rule_number' WHERE `id`='$user_id'";
            $this->db->setQuery($query);       
            return $this->db->query();
       } else{
           return 'error';
       }
      
    }
    
    public function setDefaultSettingsImg($type)
    {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();
        
        $item = new stdClass;
        $item->company = $user->company;
        $config=&JFactory::getConfig();
        
        switch($type){
            case 'logo':
                if($config->get('enable_new_logo')=='1'){
                    $item->logo = 'default_logo_new.png';
                } else{
                    $item->logo = 'default_logo.png';
                }
            
               
                $res=empty($_SERVER['HTTPS'])?'http://':'https://'.$_SERVER['SERVER_NAME'].'/images/company_images/'.$item->logo;
                break;
            case 'bg':
                $item->bg = 'default_bg1.jpg';
                $res=empty($_SERVER['HTTPS'])?'http://':'https://'.$_SERVER['SERVER_NAME'].'/images/company_images/'.$item->bg;
                break;
        }
        
        $db->updateObject('#__company_media', $item, 'company');
        
        return $res;
    }
    
    public function generateRandomString($length = 5) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public function generateTestExcel($count)
    {
        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        
        $csv_array=[];
        $i=0;
        
        $filename='CSV_test_import-'.$count.'-users-'.time().'.csv';
        $pathFile = JPATH_BASE . DS . 'tmp_test_import'.DS.$filename;
        
        for($i1=0; $i1<$count; $i1++){
            $csv_array[$i]=[
                $this->generateRandomString().'_unical_id',
                $this->generateRandomString().'_import_username',
                $this->generateRandomString().'_password',
                'test'.$this->generateRandomString().'@test.com',
                'test_dep'
            ];
                
            $i++;
        }
            
        $fp = fopen($pathFile, 'w');
        fwrite($fp,b"\xEF\xBB\xBF");//add special iceland symbols
            
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);               
    }
    
    public function getUploadedFile($token)
    {      
        return 'tmp_upload_excel_import/'.$token.'.xlsx';
    }
    
    public function setSyncStatus($status)
    {
       
        
        /*$to1 = 'developer3452@gmail.com';
        $subject = 'Ultima set sync';

        $headers = "From: info@curiotime.com\r\n";

        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message = '<pre>trigger</pre>';
        mail($to1, $subject, $message, $headers);*/
        
        $item = new stdClass();
        $item->id = $this->user->id;
        $item->sync_status = (int)$status;

        //$this->db->updateObject('#__users', $item, 'id');
        
        $query = "UPDATE #__users SET `sync_status`='$status' WHERE `id`='".$this->user->id."'";
        $this->db->setQuery($query);  
        file_put_contents('/home/curiotime/ultima.curiotime.com/logs/sync_settings.html', print_r($query, true), FILE_APPEND | LOCK_EX);       
        return $this->db->query();
    }
    
    public function editDkHeader($input) {
        $idField = $input['id'];
        $valueField = strip_tags($this->db->escape($input['value']));        
        $valueField  =  trim($valueField);
        $field = explode('-', $idField);
        $type=$field[1];
       
        switch($type){
            case 'daytime':
                $table_field='daytime_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 101;
            break;
            case 'aftertime':
                $table_field='after_hours_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 102;
            break;
            case 'night':
                $table_field='night_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 103;
            break;
            case 'weekends':
                $table_field='weekends_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 104;
            break;
            case 'hol90':
                $table_field='holidays_90_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 105;
            break;
            case 'hol45':
                $table_field='holidays_45_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 106;
            break;
            case 'sick':
                $table_field='sick_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 107;
            break;
            case 'sick_child':
                $table_field='sick_child_pos_header';
                $valueField  =  (intval($valueField) > 0) ? $valueField : 108;
            break;
            default: 
                if($this->enable_separate_pay_holidays == '1'){
                    if($type == 'pay_hol'){
                        $table_field = 'pay_hol_pos_header';
                        $valueField = (intval($valueField) > 0) ? $valueField : 110;
                    }
                }
            break;
        }
        
        $query = "UPDATE #__dk_headers SET $table_field = '$valueField' WHERE id_manager = '".$this->user->id."'";
        $this->db->setQuery($query);
        if ($this->db->query()) {
            return $valueField;
        } 
    }
    
    public function getDkHeaders() {        
        $user = $this->user;
        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        } else {
            $query = "SELECT * FROM #__users WHERE company = ".$this->db->quote($this->user->company)." order by id ASC limit 1"; 
            $this->db->setQuery($query);
            $manager = $this->db->loadObject();
            $id_user =  $manager->id;
        }
        
        $query = "SELECT * FROM #__dk_headers WHERE id_manager = '$id_user'"; 
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $this->createDkHeadersRow($id_user);
            
            $query = "SELECT * FROM #__dk_headers WHERE id_manager = '$id_user'"; 
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        }
        $data  =  $this->getDefaultValuesFromConfig($data);
        return json_encode($data);
    }
    
    private function getDefaultValuesFromConfig($data) {
        $merging_fields_default_values = (array)$this->config->get('merging_fields_default_values');
        
        if(intval($data->daytime_pos_header) < 1)   $data->daytime_pos_header = $merging_fields_default_values['daytime_pos_header'];
        if(intval($data->after_hours_pos_header) < 1)   $data->after_hours_pos_header = $merging_fields_default_values['after_hours_pos_header'];
        if(intval($data->night_pos_header) < 1)   $data->night_pos_header = $merging_fields_default_values['night_pos_header'];
        if(intval($data->weekends_pos_header) < 1)   $data->weekends_pos_header = $merging_fields_default_values['weekends_pos_header'];        
        if(intval($data->holidays_90_pos_header) < 1)   $data->holidays_90_pos_header = $merging_fields_default_values['holidays_90_pos_header'];
        if(intval($data->holidays_45_pos_header) < 1)   $data->holidays_45_pos_header = $merging_fields_default_values['holidays_45_pos_header'];        
        if(intval($data->sick_pos_header) < 1)   $data->sick_pos_header = $merging_fields_default_values['sick_pos_header']; 
        if(intval($data->sick_child_pos_header) < 1)   $data->sick_child_pos_header = $merging_fields_default_values['sick_child_pos_header'];  
        if($this->enable_separate_pay_holidays == '1'){
            if(intval($data->pay_hol_pos_header) < 1)   $data->pay_hol_pos_header = $merging_fields_default_values['pay_hol_pos_header'];  
        }
        
        
        return $data;
    }
    
    private function updateDefaults($data) {
        if(intval($data->daytime_pos_header) < 1)   $data->daytime_pos_header = 101;
        if(intval($data->after_hours_pos_header) < 1)   $data->after_hours_pos_header = 102;
        if(intval($data->night_pos_header) < 1)   $data->night_pos_header = 103;
        if(intval($data->weekends_pos_header) < 1)   $data->weekends_pos_header = 104;        
        if(intval($data->holidays_90_pos_header) < 1)   $data->holidays_90_pos_header = 105;
        if(intval($data->holidays_45_pos_header) < 1)   $data->holidays_45_pos_header = 106;        
        if(intval($data->sick_pos_header) < 1)   $data->sick_pos_header = 107; 
        if(intval($data->sick_child_pos_header) < 1)   $data->sick_child_pos_header = 108;  
        return $data;
    }
    
    private function calcOverflow($user_obj, $global_bottom_total_h = null, $global_bottom_total_m = null, $limit_for_total_in_all_fields)
    {
        $res = [
            'h' => 0,
            'm' => 0
        ];
        $limit_for_total_in_all_fields_arr = explode(':', $limit_for_total_in_all_fields);
        $limit_in_minutes = ($limit_for_total_in_all_fields_arr[0] * 60) + $limit_for_total_in_all_fields_arr[1];
        $global_totals_in_minutes = $global_bottom_total_h * 60 + $global_bottom_total_m;
        $final_in_minutes = $global_totals_in_minutes - $limit_in_minutes;
        if ($final_in_minutes > 0) {
            $res = [
                'h' => 0,
                'm' => $final_in_minutes
            ];
        }
        /*echo '$limit_in_minutes:' . $limit_in_minutes . PHP_EOL;
        echo '$global_totals_in_minutes:' . $global_totals_in_minutes . PHP_EOL;
        echo '$final_in_minutes: $global_totals_in_minutes - $limit_in_minutes = ' . $final_in_minutes;*/
        
        return $res; 
    }
    
    private function getEarnMinObject(int $owner_id,  $union_rule_id = null)
    {
        $query = "SELECT * FROM #__subrules_minutes WHERE `parent_rule_id` = '" . $union_rule_id . "' AND `manager_id` = '" . $owner_id . "'";
        $this->db->setQuery($query);
        $obj = $this->db->loadObjectList()[0];
        
        return $obj;
    }
    
    public function getDkHeadersForTotal($uid=0, $global_bottom_total_h = null, $global_bottom_total_m = null, $union_rule_id = null, $hours_blue = null) {        
        if(isset($_REQUEST['u_id']) && intval($_REQUEST['u_id']) > 0) {
            $this->user =      JFactory::getUser(intval($_REQUEST['u_id']));            
        }        
        if($uid > 0) {
            $this->user =      JFactory::getUser(intval($uid));            
        }        
        if((empty($this->user) || $this->user->id < 1) || isset($_REQUEST['user_id'])) {
            $this->user = JFactory::getUser($_REQUEST['user_id']);
        }
        if(empty($this->user) || $this->user->id < 1) {
            $this->user = JFactory::getUser();
        }        
        $data  = json_decode($this->getDkHeaders());
        /*echo '<pre>$data';
        print_r($data);
        echo '</pre>';*/
        $retData  =  [];
        
        $retData['daytime'] =  ['pos'=>$data->daytime_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_DAYTIME'),'c1'=>"daytime_wrapper",'c2'=>"t-hours t-daytime"];
        $retData['after_hours'] =  ['pos'=>$data->after_hours_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_AFTER_WORK'),'c1'=>"afterwork_wrapper",'c2'=>"t-afterwork"];
        $retData['night'] =  ['pos'=>$data->night_pos_header,'label'=>JText::_('COM_AUDIT_TIME_CARD_CALCULATION_NIGHT_TIME'),'c1'=>"night_time_wrapper",'c2'=>"t-night_time"];
        $retData['weekends'] =  ['pos'=>$data->weekends_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_WEEKEND'),'c1'=>"weekend_wrapper",'c2'=>"t-weekend"];
        
        //gg2
        if($this->enablelimit_for_total_hours_in_all_fields == '1'){
            $limit_for_total_in_all_fields_obj = $this->getEarnMinObject($this->user->owner_id, $union_rule_id);
            $checkbox_overflow_limit_as_overtime = $limit_for_total_in_all_fields_obj->limit_as_overtime;
            $checkbox_overflow_limit_as_overtime2 = $limit_for_total_in_all_fields_obj->limit_as_overtime2;
            $limit_for_total_in_all_fields = $limit_for_total_in_all_fields_obj->new_limit;
            
            if(!empty($limit_for_total_in_all_fields) && $limit_for_total_in_all_fields !== '000:00'){
                $limit_arr = explode(':', $limit_for_total_in_all_fields);
                $limit_h = $limit_arr[0];
                $limit_m = $limit_arr[1];
                 
                /*echo '<pre>$limit_arr';
                print_r($limit_arr);
                echo '</pre>';*/
            }
           
            
            $calc_overflow_h = 0;
            $calc_overflow_m = 0;
            
            if(!empty($limit_for_total_in_all_fields) && $limit_for_total_in_all_fields !== '000:00' && ($checkbox_overflow_limit_as_overtime != 0 || $checkbox_overflow_limit_as_overtime2 != 0)){
                $calc_overflow = $this->calcOverflow($this->user, $global_bottom_total_h, $global_bottom_total_m, $limit_for_total_in_all_fields);
            
                $calc_overflow_h = $calc_overflow['h'];
                $calc_overflow_m = $calc_overflow['m'];
                
              
                ($checkbox_overflow_limit_as_overtime2 == 0) ? $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H') : $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H') . " 2"; 
             
                $retData['overtime'] =  [
                    'pos' => 'abc', ///will convert to 0
                    'label' => $text, 
                    'c1' => "overtime_wrapper", 
                    'c2' => "t-overtime",
                    'h' => $calc_overflow_h,
                    'm' => $calc_overflow_m
                ];
                $retData['monthly_limit'] =  [
                    'pos' => '1', 
                    'label' => JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_TXT'), 
                    'c1' => "monthly_l_wrapper", 
                    'c2' => "t-m_limit",
                    'h' => $limit_h,
                    'm' => $limit_m
                ];
            }
           
        }//hh
        
        if($this->enable_separate_pay_holidays == '1'){
            $hours_blue_arr = explode('.', $hours_blue);
           
            $retData['pay_hol'] =  [
                    'pos' => $data->pay_hol_pos_header, 
                    'label' => JText::_('COM_AUDIT_PAY_PERIOD_NEW_PAY_HOL'), 
                    'c1' => "pay_hol_wrapper", 
                    'c2' => "t-pay_hol",
                    'h' => $hours_blue_arr[0],
                    'm' => $hours_blue_arr[1]
            ];
        }
        
        $retData['holidays_90'] =  ['pos'=>$data->holidays_90_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 90%",'c1'=>"holidays_wrapper",'c2'=>"t-holidays"];
        $retData['holidays_45'] =  ['pos'=>$data->holidays_45_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 45%",'c1'=>"holidays_wrapper_45",'c2'=>"t-holidays"];
        $retData['sick'] =  ['pos'=>$data->sick_pos_header,'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK'),'c1'=>"sick_wrapper",'c2'=>"t-holidays"];
        
        $sick_child_state=$this->getSickChildStateAndConfig($this->user->owner_id);
        if($sick_child_state=='1'){
            $retData['sick_child'] =  [
                'pos'=>$data->sick_child_pos_header,
                'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD'),
                'c1'=>"sick_child_wrapper",
                'c2'=>"t-sick_child"
            ];
        }
        
        foreach ($retData as $k => $v) {
            if(in_array($k, ['overtime', 'monthly_limit', 'pay_hol'])){ 
                continue; 
            }
            $retData[$k]['h'] =  0;
            $retData[$k]['m'] =  0;
        }
        return $retData;
    }
    
    public function getDkHeadersForTotal2($uid=0, $global_bottom_total_h = null, $global_bottom_total_m = null, $union_rule_id = null) {        
        if(isset($_REQUEST['u_id']) && intval($_REQUEST['u_id']) > 0) {
            $this->user =      JFactory::getUser(intval($_REQUEST['u_id']));            
        }        
        if($uid > 0) {
            $this->user =      JFactory::getUser(intval($uid));            
        }        
        if((empty($this->user) || $this->user->id < 1) || isset($_REQUEST['user_id'])) {
            $this->user = JFactory::getUser($_REQUEST['user_id']);
        }
        if(empty($this->user) || $this->user->id < 1) {
            $this->user = JFactory::getUser();
        }        
        $data  = json_decode($this->getDkHeaders());
        
        $retData  =  array();
      
        $retData['daytime'] =  array('pos'=>$data->daytime_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_DAYTIME'),'c1'=>"daytime_wrapper",'c2'=>"t-hours t-daytime");
        $retData['after_hours'] =  array('pos'=>$data->after_hours_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_AFTER_WORK'),'c1'=>"afterwork_wrapper",'c2'=>"t-afterwork");
        $retData['night'] =  array('pos'=>$data->night_pos_header,'label'=>JText::_('COM_AUDIT_TIME_CARD_CALCULATION_NIGHT_TIME'),'c1'=>"night_time_wrapper",'c2'=>"t-night_time");
        $retData['weekends'] =  array('pos'=>$data->weekends_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_WEEKEND'),'c1'=>"weekend_wrapper",'c2'=>"t-weekend");
        
        //gg2
        if($this->enablelimit_for_total_hours_in_all_fields == '1'){
            $limit_for_total_in_all_fields_obj = $this->getEarnMinObject($this->user->owner_id, $union_rule_id);
            $checkbox_overflow_limit_as_overtime = $limit_for_total_in_all_fields_obj->limit_as_overtime;
            $checkbox_overflow_limit_as_overtime2 = $limit_for_total_in_all_fields_obj->limit_as_overtime2;
            $limit_for_total_in_all_fields = $limit_for_total_in_all_fields_obj->new_limit;
            
            if(!empty($limit_for_total_in_all_fields) && $limit_for_total_in_all_fields !== '000:00'){
                $limit_arr = explode(':', $limit_for_total_in_all_fields);
                $limit_h = $limit_arr[0];
                $limit_m = $limit_arr[1];  
            }
            /*echo '<pre>$limit_for_total_in_all_fields';
            print_r($limit_for_total_in_all_fields);
            echo '</pre>';*/
            
            $calc_overflow_h = 0;
            $calc_overflow_m = 0;
            
            if(!empty($limit_for_total_in_all_fields) && $limit_for_total_in_all_fields !== '000:00' && ($checkbox_overflow_limit_as_overtime != 0 || $checkbox_overflow_limit_as_overtime2 != 0)){
                $calc_overflow = $this->calcOverflow($this->user, $global_bottom_total_h, $global_bottom_total_m, $limit_for_total_in_all_fields);
            
                $calc_overflow_h = $calc_overflow['h'];
                $calc_overflow_m = $calc_overflow['m'];
                
              
                ($checkbox_overflow_limit_as_overtime2 == 0) ? $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H') : $text = JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_H') . " 2"; 
             
                $retData['overtime'] =  [
                    'pos' => 'abc', 
                    'label' => $text, 
                    'c1' => "overtime_wrapper", 
                    'c2' => "t-overtime",
                    'h' => $calc_overflow_h,
                    'm' => $calc_overflow_m
                ];
                $retData['monthly_limit'] =  [
                    'pos' => '1', 
                    'label' => JText::_('COM_AUDIT_PAY_PERIOD_NEW_LIM_FOR_ALL_FIELDS_TXT'), 
                    'c1' => "monthly_l_wrapper", 
                    'c2' => "t-m_limit",
                    'h' => $limit_h,
                    'm' => $limit_m
                ];
            }
           
        }
        $retData['holidays_90'] =  array('pos'=>$data->holidays_90_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 90%",'c1'=>"holidays_wrapper",'c2'=>"t-holidays90");
        $retData['holidays_45'] =  array('pos'=>$data->holidays_45_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 45%",'c1'=>"holidays_wrapper_45",'c2'=>"t-holidays45");
        $retData['sick'] =  array('pos'=>$data->sick_pos_header,'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK'),'c1'=>"sick_wrapper",'c2'=>"t-holidays_sick");
        
        $sick_child_state=$this->getSickChildStateAndConfig($this->user->owner_id);
        if($sick_child_state=='1'){
            $retData['sick_child'] =  [
                'pos'=>$data->sick_child_pos_header,
                'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD'),
                'c1'=>"sick_child_wrapper",
                'c2'=>"t-sick_child"
            ];
        }
        
        foreach ($retData as $k=>$v) {
            if(in_array($k, ['overtime', 'monthly_limit'])){ 
                continue; 
            }
            
            $retData[$k]['h'] =  0;
            $retData[$k]['m'] =  0;
        }
        return $retData;
    }
    
    //gg2
    public function sumDkHeadersForTotal($totals) {
        $pos  =  array();
        foreach ($totals as $k=>$item) {
            $item['pos']  = intval($item['pos']);
            
            if(isset($pos[$item['pos']])) {
                $pos[$item['pos']]['h'] += $item['h'];
                $pos[$item['pos']]['m'] += $item['m'];
            } else {
                $pos[$item['pos']] = $item;
                $pos[$item['pos']]['key'] = $k;
            }
        }
        $totals2  =  array();
        foreach ($pos as $item) {
            $totals2[$item['key']] = $item;
        }
        return $totals2;
    }
    
    
    private function createDkHeadersRow($id_user) {
        $item = new stdClass;
        $item->id = NULL;
        $item->id_manager=$id_user;
           
        $this->db->insertObject('#__dk_headers', $item, 'id');
    }
    
    public function updateSickState($state) {
        /*if($this->user->sick_state==1){
            $state=0;
        } else{
            $state=1;
        }
        $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->owner_id."'";  
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/settings.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        
        if((int)$data->sick_state==1){
            $state=1;
        } else{
            $state=0;
            
        }*/
       /* $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->owner_id."'";  
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        $state=$data->sick_state;
        
        $item = new stdClass;
        $item->id = $this->user->owner_id;
        if($state==0){
            $item->sick_state=1;
        } else{
            $item->sick_state=0;
        }
       
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/settings.html', print_r($state, true), FILE_APPEND | LOCK_EX);   
        $this->db->updateObject('#__users', $item, 'id');
        
       /* $query = "UPDATE #__users SET `sick_state`='$state' WHERE `id`='".$data->id."'";
        $this->db->setQuery($query);
        $this->db->query();*/
        
        $item=new stdClass();
        $item->id=$this->user->owner_id;
        $item->sick_state=$state;
        $this->db->updateObject('#__users', $item, 'id');
       
        return $state;
        
    }
    
    public function getSickState($user_id) {
        $u=&JFactory::getUser($user_id);
        return $u->sick_state;
    }
    
    public function getQuoteHomeStatus($user_id) {
        $u = &JFactory::getUser($user_id);
        return $u->quote_home_status;
    }
    
    public function updateQuoteHome($state) {
        $item = new stdClass();
        $item->id = $this->user->owner_id;
        $item->quote_home_status = $state;
        $this->db->updateObject('#__users', $item, 'id');
       
        return $state;
        
    }
    
    public function updateSickChildState($state) {
        /*if($this->user->sick_state==1){
            $state=0;
        } else{
            $state=1;
        }
        $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->owner_id."'";  
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/settings.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        
        if((int)$data->sick_state==1){
            $state=1;
        } else{
            $state=0;
            
        }*/
       /* $query = "SELECT * FROM #__users WHERE `id` = '".$this->user->owner_id."'";  
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        $state=$data->sick_state;
        
        $item = new stdClass;
        $item->id = $this->user->owner_id;
        if($state==0){
            $item->sick_state=1;
        } else{
            $item->sick_state=0;
        }
       
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/settings.html', print_r($state, true), FILE_APPEND | LOCK_EX);   
        $this->db->updateObject('#__users', $item, 'id');
        
       /* $query = "UPDATE #__users SET `sick_state`='$state' WHERE `id`='".$data->id."'";
        $this->db->setQuery($query);
        $this->db->query();*/
        
        $item=new stdClass();
        $item->id=$this->user->owner_id;
        $item->sick_child_state=$state;
        $this->db->updateObject('#__users', $item, 'id');
       
        return $state;
    }
    
    public function getSickChildState($user_id) {
        $u=&JFactory::getUser($user_id);
        return $u->sick_child_state;
    }
    
    public function getSickChildStateAndConfig($user_id) {
        $config = &JFactory::getConfig();
        $u = &JFactory::getUser($user_id);
        $sick_child_state = $u->sick_child_state;
        $sick_child_state_with_config = $config->get('enable_sick_child');

        $res = 0;
        if ($sick_child_state == '1' && $sick_child_state_with_config == '1') {
            $res = 1;
        }
        return $res;
    }

    public function getDkHeadersForTotalWithLang($uid=0, $lang) {        
        if(isset($_REQUEST['u_id']) && intval($_REQUEST['u_id']) > 0) {
            $this->user =      JFactory::getUser(intval($_REQUEST['u_id']));            
        }        
        if($uid > 0) {
            $this->user =      JFactory::getUser(intval($uid));            
        }        
        if((empty($this->user) || $this->user->id < 1) || isset($_REQUEST['user_id'])) {
            $this->user = JFactory::getUser($_REQUEST['user_id']);
        }
        if(empty($this->user) || $this->user->id < 1) {
            $this->user = JFactory::getUser();
        }        
        $data  = json_decode($this->getDkHeaders());
        
        $retData  =  array();
      
        if($lang=='is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $retData['daytime'] =  array('pos'=>$data->daytime_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_DAYTIME'),'c1'=>"daytime_wrapper",'c2'=>"t-hours t-daytime");
        $retData['after_hours'] =  array('pos'=>$data->after_hours_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_AFTER_WORK'),'c1'=>"afterwork_wrapper",'c2'=>"t-afterwork");
        $retData['night'] =  array('pos'=>$data->night_pos_header,'label'=>JText::_('COM_AUDIT_TIME_CARD_CALCULATION_NIGHT_TIME'),'c1'=>"night_time_wrapper",'c2'=>"t-night_time");
        $retData['weekends'] =  array('pos'=>$data->weekends_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_WEEKEND'),'c1'=>"weekend_wrapper",'c2'=>"t-weekend");
        $retData['holidays_90'] =  array('pos'=>$data->holidays_90_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 90%",'c1'=>"holidays_wrapper",'c2'=>"t-holidays");
        $retData['holidays_45'] =  array('pos'=>$data->holidays_45_pos_header,'label'=>JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS')." 45%",'c1'=>"holidays_wrapper_45",'c2'=>"t-holidays");
        $retData['sick'] =  array('pos'=>$data->sick_pos_header,'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK'),'c1'=>"sick_wrapper",'c2'=>"t-holidays");
        
        $sick_child_state=$this->getSickChildStateAndConfig($this->user->owner_id);
        if($sick_child_state=='1'){
            $retData['sick_child'] =  [
                'pos'=>$data->sick_child_pos_header,
                'label'=>JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD'),
                'c1'=>"sick_child_wrapper",
                'c2'=>"t-sick_child"
            ];
        }
        
        foreach ($retData as $k=>$v) {
            $retData[$k]['h'] =  0;
            $retData[$k]['m'] =  0;
        }
        return $retData;
    }
    
    public function getCombineConfirmAndPpStatus($user_id)
    {
        $u = &JFactory::getUser($user_id);
        return $u->combine_confirm_and_pp;
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res='0';
        
        switch($type){ 
            case 'saving_combine_checkbox':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setSyncDkUsersStatus':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
            case 'setShiftsNotificationStatus':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
            case 'setQuoteTypeForHome':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
            case 'setCTNotificationStatus':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
            case 'attachUsersForSendNotifications':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
            case 'setSyncDkTasksStatus':
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                }
            break;
        }
      
       
       return $res;
    }
    
    public function setCombineConfirmAndPpStatus($input_id){
        /*$item = new stdClass();
        $item->id = $this->user->owner_id;*/
        $state = 0;
        
        if($input_id == 'combine_checkbox_enable'){
            $state = 1;
        } elseif($input_id == 'combine_checkbox_disable'){
            $state = 0;
        }
        /*$item->combine_confirm_and_pp = $state;
        $this->db->updateObject('#__users', $item, 'id');*/
       
        
        $query = "UPDATE #__users SET `combine_confirm_and_pp`='$state' WHERE `owner_id`='".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $state;
    }
    
    public function setSyncDkUsersStatus(){
        $state = 0;
        
        $query = 'SELECT `id`, `sync_dk_users` FROM #__users WHERE `id`="'.$this->user->owner_id.'"';
        $this->db->setQuery( $query );
        $manager = $this->db->loadObject(); 
        
        if($manager->sync_dk_users == 0){
            $state = 1;
        } else{
            $state = 0;
        }
        
        $query = "UPDATE #__users SET `sync_dk_users`='$state' WHERE `owner_id`='".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $state;
    }
    
    public function getCombineConfirmAndPpStatusByCompany()
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/

        $company = JFactory::getApplication()->input->cookie->getString( 'company' );
        //echo $company;
        
        if(empty($company)){
            return 0;
        }
        $query='SELECT `id`, `combine_confirm_and_pp` FROM #__users WHERE `company`="'.$company.'" ORDER BY `id` ASC';
        $this->db->setQuery( $query );
        $manager = $this->db->loadObjectList()[0]; 
            
        $u = $manager;
        return $u->combine_confirm_and_pp;
    }
    
    public function getGroupTitles($id)
    {
        $db = $this->db;
        $query = $db->getQuery(true);
        $query->select('title')->from('#__usergroups')->where('id IN (' . implode(',', array_values(JFactory::getUser($id)->groups)) . ')');
        $db->setQuery($query);
        
        return $db->loadColumn()[0];
   }
   
   public function saveMngrEmailNewPsd($new_value)
   { 
        $item = new stdClass;
        $item->id = $this->user->id;
        $item->email = $this->db->escape($new_value);
        
        $this->db->updateObject('#__users', $item, 'id');
   }
    
   public function getCompanyDkToken($manager_id)
   {
        $query = 'SELECT `id`, `dk_token` FROM #__users WHERE `owner_id`="'.$manager_id.'" ORDER BY `id` ASC';
        $this->db->setQuery( $query );
        return $this->db->loadObjectList()[0]->dk_token; 
   }
   
   public function saveDkToken($new_value)
   {
       $item = new stdClass;
       $item->id = $this->user->owner_id;
       $item->dk_token = $this->db->escape($new_value);
        
       $this->db->updateObject('#__users', $item, 'id');
   }
   
   public function setShiftsNotificationStatus($input_name, $lang, $state)
   { 
        if($state == 'true'){
            $auto_report = 1;
        } else{
            $auto_report = 0;
        }
        
        $item = new stdClass;
        $item->id = $this->user->owner_id;
        $field_name = 'shifts_'.$input_name;
        
        $item->$field_name = $auto_report;
        
        if($this->db->updateObject('#__users', $item, 'id')){
            return 1;
        }
        else{
            return 0;
        } 
   }
   
   public function setCTNotificationStatus(string $input_name, string $lang, string $state)
   {
       if($state == 'true'){
            $auto_report = 1;
        } else{
            $auto_report = 0;
        }
        
        $item = new stdClass;
        $item->id = $this->user->owner_id;
        $field_name = $input_name;
        
        $item->$field_name = $auto_report;
        
        if($this->db->updateObject('#__users', $item, 'id')){
            return 1;
        }
        else{
            return 0;
        } 
   }
   
   public function getJokesModuleStatus($owner_id)
   {
       $u = &JFactory::getUser($owner_id);
       return $u->jokes_home_status;
   }
   
   public function setQuoteTypeForHome(string $value, string $state)
   {    
        /*echo '<pre>';
        print_r(func_get_args());
        echo '</pre>';*/
        
        if($state == 'true'){
            $state = 1;
        } if($state == 'false'){
            $state = 0;
        }
        $item = new stdClass();
        $item->id = $this->user->owner_id;
        
        switch($value){
            case 'ww':
                $item->quote_home_status = $state;
                $item->jokes_home_status = 0;
            break;
            case 'jokes':
                $item->jokes_home_status =  $state;
                $item->quote_home_status = 0;
            break;
        }
        
        //old(radio) way
        /*if($value == 'ww'){
            $item->quote_home_status = 1;
            $item->jokes_home_status = 0;
        } elseif($value == 'jokes'){
            $item->jokes_home_status =  1;
            $item->quote_home_status = 0;
        }*/
      
        $this->db->updateObject('#__users', $item, 'id');
       
        return $this->db->quote($value);
       
   }
   
   public function attachUsersForSendNotifications(int $user_id, string $mode)
   {
        $user = JFactory::getUser($user_id);
        $query = "SELECT `attached_users_for_send_notifications` FROM #__users WHERE `id` = '".$user->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        switch($mode){
            case 'add':
                if(!empty($data->attached_users_for_send_notifications)){
                    $attached_users_new = $data->attached_users_for_send_notifications.','.$user_id;
                } else{
                    $attached_users_new = $user_id;
                }
                $item = new stdClass();
                $item->id = $user->owner_id;
                $item->attached_users_for_send_notifications = $attached_users_new;
                $this->db->updateObject('#__users', $item, 'id');
            break;
            case 'remove':
                $arr = [];
                $str_arr = explode(',',  $data->attached_users_for_send_notifications);

                foreach($str_arr as $one_user){
                    if($one_user != $user_id){
                        $arr[] = $one_user; 
                    } 
                }
                
                $attached_users_new = implode(',', $arr);
                
                $item = new stdClass();
                $item->id = $user->owner_id;
                $item->attached_users_for_send_notifications = $attached_users_new;
                $this->db->updateObject('#__users', $item, 'id');
            
            break;
        }
   }
   
   public function getAttachedUsersToCtNotifications(object $user_obj)
   {
       
        $query = "SELECT `attached_users_for_send_notifications` FROM #__users WHERE `id` = '".$user_obj->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        return $data->attached_users_for_send_notifications;  
    }
    
    public function setSyncDkTasksStatus()
    {
        $state = 0;
        
        $query = 'SELECT `id`, `sync_dk_tasks` FROM #__users WHERE `id` = "'.$this->user->owner_id.'"';
        $this->db->setQuery( $query );
        $manager = $this->db->loadObject(); 
        
        if($manager->sync_dk_tasks == 0){
            $state = 1;
        } else{
            $state = 0;
        }
        
        $query = "UPDATE #__users SET `sync_dk_tasks` = '$state' WHERE `owner_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $state;
    }
    
    public function setLimitOfUsers(string $lang, int $value)
    {
        $query = "SELECT `enabled` FROM #__api_company_mods WHERE `company` = '".$this->user->company."' AND `mod` = 'user_limit'";
        $this->db->setQuery($query);
        $old_limit = $this->db->loadResult();
        
        $query = "UPDATE #__api_company_mods SET `enabled` = '$value' WHERE `company` = '".$this->user->company."' AND `mod` = 'user_limit'";
        $this->db->setQuery($query);
        if($this->db->query()){
            if($old_limit != $value){
                $this->sendEmailToManager($old_limit, $value);
            }
        }  
        
    }
    
    public function setDisableSubscription(string $lang, string $value)
    {
        $item = new stdClass;
        $item->id = $this->user->owner_id;
        if($value === 'true'){
           $state = 1;
        } else{
            $state = 0;
        }
        
        $item->disable_subscription = $state;
        
        if($this->db->updateObject('#__users', $item, 'id')){
            $this->addLogAboutDisableSubscription($item);
        }
    }
    
    private function addLogAboutDisableSubscription(stdClass $subs_obj)
    {
        $item = new stdClass;
        $item->id = null;
        $item->manager_id = $this->user->owner_id;
        $item->created_at = date('Y-m-d H:i:s');
        $item->created_timestamp = time();
        $item->chk_state = $subs_obj->disable_subscription;
        $item->ip = $_SERVER['REMOTE_ADDR'];
        
        $this->db->insertObject('#__subscription_new_log', $item);
    }
    
    private function sendEmailToManager($old_limit, $new_limit)
    {
        $config = $this->config;
        $sender = array($config->get('mailfrom'), $config->get('fromname'));
        $user_sended = & JFactory::getUser($this->user->owner_id);
        $subject = "Manager changed user limit";
        
        $message = "<p><strong>Company:</strong> $user_sended->company</p>";
        $message .= "<p><strong>Url:</strong> $this->current_url</p>";
        $message .= "<p><strong>Date:</strong> " . date('d.m.Y H:i:s') . "</p>";
        $message .= "<p><strong>Old limit:</strong> " . $old_limit . "</p>";
        $message .= "<p><strong>New limit:</strong> " . $new_limit . "</p>";
        
        $mailer = JFactory::getMailer();
        $mailer->setSender($sender);
        $mailer->addRecipient('developer3452@gmail.com');
        //$mailer->addRecipient('info@uxdesign.is');
        $mailer->addBcc('info@uxdesign.is');
      
                      
        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE);
        $mailer->setBody($message);
        $mailer->send();
        //echo 'sended';
    }
   
}