<?php
/*ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);*/
// No direct access
defined('_JEXEC') or die;

/**

 * @author 

 */
class AuditModelTask_manager extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->password_current_api='KIis3223*>XNWIUe8329od';
        $this->config = &JFactory::getConfig();
        $this->enable_task_manager_dk_api = $this->config->get('enable_task_manager_dk_api');
        $this->enable_uniconta_tasks = $this->config->get('enable_uniconta_tasks');
        $this->uniconta_table_name = '#__uniconta_tasks';
        $this->subtask_table_name = '#__uniconta_subtasks';
        
        $this->radius_table_name = '#__gps_radius';
        $this->enable_gps_type_of_tasks = $this->config->get('enable_gps_type_of_tasks');
        $this->enable_automatick_clock_icon_in_task_manager = $this->config->get('enable_automatick_clock_icon_in_task_manager');
    }
    
    public function getTaskList()
    {
        $config = &JFactory::getConfig();  
        //$enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    public function addOneTask($lang)
    {
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        $item=new stdClass();
        $item->id=null;
        $item->id_user=$this->user->id;
        $item->text=JText::_('COM_AUDIT_TASK_MANAGER_EMPTY_TASK_TEXT');
        
        $this->db->insertObject('#__audit_task_list', $item);
        return $this->db->insertid();
        
    }
    
    public function deleteTask($row_id)
    {
        $query = "DELETE FROM `#__audit_task_list` WHERE `id` = '$row_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function loadTaskList(...$a)
    {
        $args=func_get_args();
        $lang=  $args[0];
        
        $task_list=json_decode($this->getTaskList());
        $this->user_list=json_decode($this->getPrepareUserList());
       
        $count = $i=0;
        $html = '';
        
        $config=&JFactory::getConfig();  
        $enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        $enable_dropbox_api = $config->get('enable_dropbox_api');
        
        $task_sortable_class='';
        if($enable_sortable_in_task_manager_and_api=='1'){
            $task_sortable_class='';      
        }
        
        if($lang=='is'){
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        foreach($task_list as $one_task){
            
        $html .= '
            <div class="one_item_page_rules '.$task_sortable_class.'" id="one_task-'.$one_task->id.'">';
                if($enable_sortable_in_task_manager_and_api=='1'){
                    $html .='<div class="move-icon-box"><i class="icon-menu"></i></div>';
                } 
                $html .='<div class="one_item_page_rules_item">
                    <div class="task_icon">'.++$count.'.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">
                    <div class="edit_task" id="edit_task-'.$one_task->id.'">'.$one_task->text.'</div>
                </div>';
                
                if($enable_dropbox_api=='1'){
                    $html .='<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox" data-task-id="'.$one_task->id.'">
                        <button class="btn btn-small" type="button"><span class="icon-image" style="width:18px;"></span>'.JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES').'</button>    
                    </div>';
                } 
                
                $html .='
                <div class="one_item_page_rules_item item_subtasks" data-task_id="'.$one_task->id.'">
                    <img src="/components/com_audit/assets/images/folder-icon.png" alt="" class="toggle_subtask"/>
                </div>
                <div class="one_item_page_rules_item item_user_binding" data-task_id="'.$one_task->id.'">
                    <img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_attach_task"/>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                            ';
                            foreach($this->user_list as $one_user){
                                $task_status=$this->getAttachedTaskStatus($one_user->id, $one_task->id);
                                $html .='<div class="one_option';
                                if($task_status==='1'){ 
                                    $html .=' selected_option_active';
                                }  
                                $html .='" data-option-value="'.$one_user->id.'" data-option-task-id="'.$one_task->id.'">
                                    <span>'.$one_user->username0.'</span>
                                        <i class="fa ';
                                        if($task_status==='1'){ 
                                            $html .='fa-check-circle-o';       
                                        } else{
                                            $html .='fa-circle-thin';       
                                        } 
                                        $html .='" aria-hidden="true"></i>
                                    </div>';
                            } 
                            $html .='
                        </div>
                    </div>     
                </div>
                <div class="one_item_page_rules_item item_delete_task" data-task_id="'.$one_task->id.'">
                    <div class="item_rules_close_wrapper">
                        <p>X</p>
                    </div>
                </div>';
                //unset($subtasks_list);      
                $subtasks_list=$this->getSubtasks($one_task->id);
               
                
        
               $html.='
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';
                    
                        if(empty($subtasks_list)){
                            //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                            if($enable_subtask_delete=='1'){
                                $parent_class='data_subtask-no_line';
                                $def_text='';
                                $row_class='no-line';
                            } else{
                                $def_text=JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                                $row_class='';
                            }
                                                        
                            $html.='
                                <div class="data_subtask '.$parent_class.'">
                                     <div class="add_new_sutasck" data-parent-id="'.$one_task->id.'">>></div>
                                     <div class="edit_subtask new_subtask '.$row_class.'" id="parent_id-'.$one_task->id.'-new">'.$def_text.'</div>
                                </div>';
                        } 
                            foreach($subtasks_list as $one_subtask){
                                $html.='<div class="data_subtask" data-option-task-id="'.$one_subtask->id.'">
                                            <div class="add_new_sutasck" data-parent-id="'.$one_task->id.'">>></div>
                                            <div class="edit_subtask" id="edit_task-'.$one_subtask->id.'">'.$one_subtask->text.'</div>';
                                
                                            if($enable_subtask_delete=='1'){
                                                $html.='<div class="delete_subtask" data-id="'.$one_subtask->id.'" data-parent-id="'.$one_task->id.'"><i class="fa fa-times" aria-hidden="true"></i></div>';
                                            }
                                $html.='</div>';
                            } 
                        
                        $html.='
                    </div>
                </div>
             </div>';

             $i++?>
        <?php } 
        
        return $html;
    }
    
    public function editTask($id, $text)
    {
	if ($_REQUEST['lang'] == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
		if($text != ''){
			$item = new stdClass();
			$item->id =$id;
			$item->text = $text;
			$this->db->updateObject('#__audit_task_list', $item, 'id');
		} else $text = JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_TASK_TEXT');
        
        return $text;
    }
    
    private function getSyncWithMainTasksStateWithUserId(int $user_id)
    {
        $user_obj = JFactory::getUser($user_id);
        //$manager_obj = JFactory::getUser($user_obj->owner_id);
        
        $table_name = '#__task_manager_main_tasks_sync_state';
         
        $query = "SELECT * FROM $table_name WHERE `manager_id` = '".$user_obj->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $state = $data[0]->state;
        if(is_null($state)){
            $state = 0;
        }
        
        return $state;
    }
    
    private function getSubmenuTaskListWithUserId(int $user_id)
    {
        $user_obj = JFactory::getUser($user_id);
        $enable_sortable_in_task_manager_and_api = '1';
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_submenu_task_list WHERE `id_user` = '".$user_obj->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    public function getLayoutTaskSelect($user_id, $mode)
    {
        $enable_326_task_changes_in_task_manager = $this->config->get('enable_326_task_changes_in_task_manager');
        $checkbox_sync_with_main_tasks_state = $this->getSyncWithMainTasksStateWithUserId($user_id);
        
      
        $all_submenu_tasks = json_decode($this->getSubmenuTaskListWithUserId($user_id));
        
            
        if($mode === 'password'){   
            $pass = $this->db->escape($_POST['pass']);
        
            $query = "SELECT * FROM #__users WHERE `password2` = '".$pass."'";
            $this->db->setQuery($query);
            $select_user_by_password = $this->db->loadObject();
        
            $user_by_password = JFactory::getUser((int)$select_user_by_password->id);
            $user = JFactory::getUser((int)$user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            
            $query = "SELECT * FROM #__users WHERE `owner_id` = '".$user->owner_id."' AND password2 = '".$pass."'";
            $this->db->setQuery($query);
            $userlist = $this->db->loadAssoc();
            if($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token)){
                $subtasks_dk_list = json_decode($this->getDkSubtasksForHomepage($manager_obj->id));
            }
           
        
        
            if(is_array($userlist)){
                $userlist = $userlist['id'];  
            } else{
                $userlist = '';
            }

            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$user->owner_id."' ORDER BY `id` DESC";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();
            
            if($this->enable_task_manager_dk_api == '1' && $manager_obj->sync_dk_tasks == '1'){
                $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$user_by_password->owner_id."' ORDER BY `id` DESC";
                $this->db->setQuery($query);
                $dk_task_list = $this->db->loadObjectList();
                
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($dk_task_list, true), FILE_APPEND | LOCK_EX);
            }
          
        
            $prepare_task_list_array=[];
            foreach($task_list as $one_task){
                if(!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))){
                    unset($subtask_list);
                    if($checkbox_sync_with_main_tasks_state == 1 || $one_task->sync_with_submenu == 1){
                        $subtask_list = $all_submenu_tasks;
                    } else{
                         $subtask_list = $this->getSubtasks($one_task->id);
                    }
                    //$subtask_list=$this->getSubtasks($one_task->id);
                    
                    $html .= '<div class="one_option" data-option-value="'.$one_task->id.'">'
                        . '<div class="task_trigger">'
                            . '<img src="/components/com_audit/assets/images/new-icon.png" alt=""/>'
                        . '</div>'
                        . '<div class="task_text">'.$one_task->text.'</div>';
                    
                    if(!empty($subtask_list)){
                        $html .=  '<div class="toggle_subtasks_home d-flex justify-content-center align-content-center">'
                            . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                        . '</div>'
                        . '<div class="subtask_list_home_wr">'
                            . '<div class="subtask_list_home">';
                                    foreach($subtask_list as $one_subtask){
                                        $html.='<div class="one_subtask">'.
                                            $one_subtask->text.
                                        '</div>';
                                    }
                           
                            $html.='</div>'
                                . '</div>'
                      . '</div>';
                    }
                    
                
                }
            
            } 
            
            if ($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == '1' && $manager_obj->sync_uniconta_tasks != '1') {
            foreach($dk_task_list as $one_task){
                if(!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))){
                    
                    
                    $html.='<div class="one_option one_dk_option" data-option-value="'.$one_task->id.'">'
                        . '<!--<div class="task_trigger">'
                            . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                        . '</div>-->'
                        . '<div class="task_trigger">'
                            . '<img src="/components/com_audit/assets/images/new-icon.png" alt=""/>'
                        . '</div>'
                        . '<div class="task_text">'.$one_task->original_id.' | '.$one_task->text.'</div>'
                        . '<!--<div class="toggle_subtasks_home">'
                            . '<img src="/components/com_audit/assets/images/folder-icon.png" alt=""/>'
                        . '</div>-->'
                        . '<div class="toggle_subtasks_home d-flex justify-content-center align-content-center">'
                            . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                        . '</div>'
                        . '<div class="subtask_list_home_wr">'
                            . '<div class="subtask_list_home">';
                                    foreach($subtasks_dk_list as $one_subtask){
                                        $html.='<div class="one_subtask">'.
                                            $one_task->original_id.' | '.$one_task->text .' | '.$one_subtask->DESCRIPTION .
                                        '</div>';
                                    }
                           
                            $html.='</div>'
                                . '</div>'
                      . '</div>';
                
                }
            
            }
            }
            
            //Uniconta
            if ($this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '".$user_by_password->owner_id."' ORDER BY `id` DESC";
                $this->db->setQuery($query);
                $uniconta_task_list = $this->db->loadObjectList(); 
                //hh8
                $subtasks_list = $this->getUnicontaSubtasks();
		/*echo '<pre>$subtasks_list';
                print_r($subtasks_list);
                echo '</pre>';*/
                foreach($uniconta_task_list as $one_task){
                if(!empty($one_task->number0) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))){   
                    $html .= '<div class="one_option one_dk_option" data-option-value="'.$one_task->id.'">'
                        . '<!--<div class="task_trigger">'
                            . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                        . '</div>-->'
                        . '<div class="task_trigger">'
                            . '<img src="/components/com_audit/assets/images/new-icon.png" alt=""/>'
                        . '</div>'
                        . '<div class="task_text">'. $one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name . '</div>'
                        . '<!--<div class="toggle_subtasks_home">'
                            . '<img src="/components/com_audit/assets/images/folder-icon.png" alt=""/>'
                        . '</div>-->';
                    
                        $add_subtask = 0;
                        foreach($subtasks_list as $one_subtask){
                            if($one_subtask->parent_id === $one_task->id){
                                $add_subtask = 1;
                            }
                        }
                        if(!empty($subtasks_list) && $add_subtask === 1){
                            $html .= '<div class="toggle_subtasks_home d-flex justify-content-center align-content-center">'
                                . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                            . '</div>';
                        }
                        
                        $html .= '<div class="subtask_list_home_wr">'
                            . '<div class="subtask_list_home">';
                                    foreach($subtasks_list as $one_subtask){
                                        if($one_subtask->parent_id === $one_task->id){
                                            $html .= '<div class="one_subtask">'.
                                                $one_subtask->name .
                                            '</div>';
                                        }
                                    }
                           
                            $html.='</div>'
                                . '</div>'
                      . '</div>';
                
                            
                }
            
            }
            }
            
            $password_correct='0';
            if(!empty($select_user_by_password)){
                $password_correct='1';
            }
            $this->recordLog($pass, $user_id, $prepare_task_list_array, $user_by_password, $password_correct);
        
            return $html;
        } elseif($mode === 'not_password'){
            $user = JFactory::getUser((int)$user_id);
            $manager_obj = JFactory::getUser($user->owner_id);
            /*echo '<pre>$user';
            print_r($user);
            echo '</pre>';
            exit;*/
            
            $config = &JFactory::getConfig();  
            //$enable_subtask_delete = $config->get('enable_subtask_delete');
            $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        
            if($enable_sortable_in_task_manager_and_api == '1'){
                $order_by='`ordering`';
            } else{
                $order_by='`id` DESC';
            }
            if($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token)){
                $subtasks_dk_list = json_decode($this->getDkSubtasksForHomepage($user->owner_id));
            }
            
            $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$user->owner_id."' AND `attached_users`='' ORDER BY $order_by";
            $this->db->setQuery($query);
            $task_list = $this->db->loadObjectList();
            
            if($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == '1' && $manager_obj->sync_uniconta_tasks != '1'){
                $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$user->owner_id."' AND `attached_users`='' AND `JobStatus` = '1' ORDER BY $order_by";
                $this->db->setQuery($query);
                $dk_task_list = $this->db->loadObjectList();
                
                //load task from DK api
                if(empty($dk_task_list)){
                    $dk_task_list_for_api = json_decode($this->getDkTaskListForHomepage($user->owner_id));
                }
               
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($dk_task_list, true), FILE_APPEND | LOCK_EX);
            }
            
            
            foreach($task_list as $one_task){
                if($one_task->text != ''){
                    unset($subtask_list);
                    if($checkbox_sync_with_main_tasks_state == 1 || $one_task->sync_with_submenu == 1){
                        $subtask_list = $all_submenu_tasks;
                    } else{
                         $subtask_list = $this->getSubtasks($one_task->id);
                    }
                    /*echo '<pre>$subtasks_list:';
                    print_r($subtask_list);
                    echo '</pre>';*/
                
                    $html .= '<div class="one_option" data-option-value="'.$one_task->id.'">'
                        . '<!--<div class="task_trigger">'
                            . '<img src="/components/com_audit/assets/images/new-icon.png" alt=""/>'
                        . '</div>-->'
                        . '<div class="task_text">'.$one_task->text.'</div>';
                    
                    if(!empty($subtask_list)){
                        $html .= '<div class="toggle_subtasks_home d-flex justify-content-center align-content-center">'
                            . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                        . '</div>'
                        . '<div class="subtask_list_home_wr">'
                            . '<div class="subtask_list_home">';
                                    foreach($subtask_list as $one_subtask){
                                        $html.='<div class="one_subtask js_event-0">'.
                                            $one_subtask->text.
                                        '</div>';
                                    }
                           
                            $html .= '</div>'
                                . '</div>';
                     
                    }
                      $html .=   '</div>';
                        
                        
                }
            } 
            if ($this->enable_task_manager_dk_api == '1' && !empty($manager_obj->dk_token) && $manager_obj->sync_dk_tasks == '1' && $manager_obj->sync_uniconta_tasks != '1') {
                if (empty($dk_task_list)) {
                    foreach ($dk_task_list_for_api as $one_task) {
                        $html .= '<div class="one_option one_dk_option" data-option-value="' . $one_task->Number . '">'
                                . '<div class="task_text">' . $one_task->Number . ' | ' . $one_task->Name . '</div>'
                                . '<div class="toggle_subtasks_home">'
                                    . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>>'
                                . '</div>'
                                . '<div class="subtask_list_home_wr">'
                                    . '<div class="subtask_list_home">';
                        foreach ($subtasks_dk_list as $one_subtask) {
                            $html .= '<div class="one_subtask js_event-0">' .
                                    $one_task->Number . ' | ' . $one_task->Name . ' | ' . $one_subtask->DESCRIPTION .
                                    '</div>';
                        }

                        $html .= '</div>'
                                . '</div>'
                                . '</div>';
                    }
                } else {
                    foreach ($dk_task_list as $one_task) {
                        //if ($one_task->text != '') {
                        //$subtask_list=$this->getSubtasks($one_task->id);

                        $html .= '<div class="one_option one_dk_option" data-option-value="' . $one_task->id . '">'
                                . '<div class="task_text">' . $one_task->original_id . ' | ' . $one_task->text . '</div>'
                                . '<div class="toggle_subtasks_home">'
                                    . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                                . '</div>'
                                . '<div class="subtask_list_home_wr">'
                                . '<div class="subtask_list_home">';
                        foreach ($subtasks_dk_list as $one_subtask) {
                            $html .= '<div class="one_subtask js_event-0">' .
                                    $one_task->original_id . ' | ' . $one_task->text . ' | ' . $one_subtask->DESCRIPTION .
                                    '</div>';
                        }

                        $html .= '</div>'
                                . '</div>'
                                . '</div>';
                    }
                    //}
                }
            }
            
            if ($this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '" . $user->owner_id . "' AND `attached_users`='' ORDER BY $order_by";
                $this->db->setQuery($query);
                $uniconta_task_list = $this->db->loadObjectList(); 
                
                $subtasks_list = $this->getUnicontaSubtasks();
            }
            
            if (!empty($uniconta_task_list) && $this->enable_uniconta_tasks == '1' && $manager_obj->sync_uniconta_tasks == '1' && !empty($manager_obj->uniconta_uname) && !empty($manager_obj->uniconta_upassw)) {
                foreach ($uniconta_task_list as $one_task) {  
                        $html .= '<div class="one_option one_dk_option" data-option-value="' . $one_task->id . '">'
                                . '<div class="task_text">' . $one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name . '</div>';
                       
                        $add_subtask = 0;
                        foreach($subtasks_list as $one_subtask){
                            if($one_subtask->parent_id === $one_task->id){
                                $add_subtask = 1;
                            }
                        }
                        if(!empty($subtasks_list) && $add_subtask === 1){
                                $html .= '<div class="toggle_subtasks_home">'
                                    . '<i class="fa fa-caret-down css_event_i_toggle_subtasks" aria-hidden="true"></i>'
                                . '</div>';
                        } 
                        
                        $html .= '<div class="subtask_list_home_wr">'
                                . '<div class="subtask_list_home">';
                        
                        foreach ($subtasks_list as $one_subtask) {
                            if($one_subtask->parent_id === $one_task->id){
                                $html .= '<div class="one_subtask js_event-0">' .
                                     $one_subtask->name .
                                '</div>';
                            }
                        }

                        $html .= '</div>'
                                . '</div>'
                                . '</div>';
                }
            }
            
            return $html;
        }
    }
    
    
    //old method, not api spec task select
    public function getLayoutSpecificTaskSelect($user_id)
    {
        $pass = $this->db->escape($_POST['pass']);
        
        $query = "SELECT * FROM #__users WHERE `password2` = '".$pass."'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();
        
        $user_by_password = JFactory::getUser((int)$select_user_by_password->id);
	$user = JFactory::getUser((int)$user_id);
        
        $query = "SELECT * FROM #__users WHERE `owner_id` = '".$user->owner_id."' AND password2 = '".$pass."'";
        $this->db->setQuery($query);
        $userlist = $this->db->loadAssoc();
        
        
        $to1 = 'developer3452@gmail.com';
        $subject = 'Tak manager home test0';
        $headers = "From: info@curiotime.com\r\n";
        //$headers .= "Reply-To: ". strip_tags($_POST['req-email']) . "\r\n";
        //$headers .= "CC: susan@example.com\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";     
    
        
        
	if(is_array($userlist)){
            $userlist = $userlist['id'];  
        } else{
            $userlist = '';
        }

        $query = "SELECT * FROM #__audit_task_list WHERE `id_user` = '".$user->owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $task_list = $this->db->loadObjectList();
        
        $message = '<pre>'.print_r($task_list, true).'</pre>';
        mail($to1, $subject, $message, $headers);
        
        $prepare_task_list_array=[];
        foreach($task_list as $one_task){
            if(!empty($one_task->text) && !empty($select_user_by_password) && in_array($user_by_password->id, explode(',', $one_task->attached_users)) && in_array($userlist, explode(',', $one_task->attached_users))){
                $html.='<div class="one_option" data-option-value="'.$one_task->id.'">'.$one_task->text.'</div>';
                $prepare_task_list_array[]['text']=$one_task->text;
                $prepare_task_list_array[]['task_id']=$one_task->id;
                $prepare_task_list_array[]['attached_users']=$one_task->attached_users;
                
            }
            
        }
        $password_correct='0';
        if(!empty($select_user_by_password)){
            $password_correct='1';
        }
        $this->recordLog($pass, $user_id, $prepare_task_list_array, $user_by_password, $password_correct);
        
        return $html;
    }
    
    public function recordLog($pass, $user_id, $prepare_task_list_array, $user_by_password, $password_correct)
    {
        $item=new stdClass();
        $user = JFactory::getUser($user_id);
        
        $item->id=null;
        $item->timestamp=time();
        $item->datetime=date('d.m.Y H:i:s');
        $item->password2=$pass;
        $item->owner_id_cookie=$user_id;
        $item->task_list=json_encode($prepare_task_list_array);
        $item->company=$user->company;
        $item->username=$user_by_password->username0;
        
        $tablet_browser = 0;
        $mobile_browser = 0;

        if (preg_match('/(tablet|ipad|playbook)|(android(?!.*(mobi|opera mini)))/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $tablet_browser++;
        }
 
        if (preg_match('/(up.browser|up.link|mmp|symbian|smartphone|midp|wap|phone|android|iemobile)/i', strtolower($_SERVER['HTTP_USER_AGENT']))) {
            $mobile_browser++;
        }
 
        if ((strpos(strtolower($_SERVER['HTTP_ACCEPT']),'application/vnd.wap.xhtml+xml') > 0) or ((isset($_SERVER['HTTP_X_WAP_PROFILE']) or isset($_SERVER['HTTP_PROFILE'])))) {
            $mobile_browser++;
        }
 
        $mobile_ua = strtolower(substr($_SERVER['HTTP_USER_AGENT'], 0, 4));
        $mobile_agents = array(
            'w3c ','acs-','alav','alca','amoi','audi','avan','benq','bird','blac',
            'blaz','brew','cell','cldc','cmd-','dang','doco','eric','hipt','inno',
            'ipaq','java','jigs','kddi','keji','leno','lg-c','lg-d','lg-g','lge-',
            'maui','maxo','midp','mits','mmef','mobi','mot-','moto','mwbp','nec-',
            'newt','noki','palm','pana','pant','phil','play','port','prox',
            'qwap','sage','sams','sany','sch-','sec-','send','seri','sgh-','shar',
            'sie-','siem','smal','smar','sony','sph-','symb','t-mo','teli','tim-',
            'tosh','tsm-','upg1','upsi','vk-v','voda','wap-','wapa','wapi','wapp',
            'wapr','webc','winw','winw','xda ','xda-');
 
        if (in_array($mobile_ua,$mobile_agents)) {
            $mobile_browser++;
        }
 
        if (strpos(strtolower($_SERVER['HTTP_USER_AGENT']),'opera mini') > 0) {
            $mobile_browser++;
            //Check for tablets on opera mini alternative headers
            $stock_ua = strtolower(isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])?$_SERVER['HTTP_X_OPERAMINI_PHONE_UA']:(isset($_SERVER['HTTP_DEVICE_STOCK_UA'])?$_SERVER['HTTP_DEVICE_STOCK_UA']:''));
            if (preg_match('/(tablet|ipad|playbook)|(android(?!.*mobile))/i', $stock_ua)) {
                $tablet_browser++;
            }
        }
 
        if ($tablet_browser > 0) {
            // do something for tablet devices
            $browser='tablet';
  
        }
        else if ($mobile_browser > 0) {
            // do something for mobile devices
            $browser='mobile';
        }
        else {
            // do something for everything else
            $browser='desctop';
        }   
        
        
        $item->device=$browser;
        $item->user_agent=$_SERVER['HTTP_USER_AGENT'];
        $item->password_correct=$password_correct;
        
        $this->db->insertObject('#__homepage_specific_task_log', $item);
    }
    
    public function getPrepareUserList()
    {
        $query = "SELECT * FROM #__users WHERE `owner_id` = '".$this->user->owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    public function updateAttachedTask($user_id, $mode, $task_id)
    {
        $user=JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM #__audit_task_list WHERE `id_user` = '".$user->owner_id."' AND `id`='".$task_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        switch($mode){
            case 'add':
                if(!empty($data->attached_users)){
                    $attached_users_new=$data->attached_users.','.$user_id;
                } else{
                    $attached_users_new=$user_id;
                }
               
                
                $item = new stdClass();
                $item->id = $task_id;
                $item->attached_users = $attached_users_new;
                $this->db->updateObject('#__audit_task_list', $item, 'id');
            break;
            case 'remove':
                $arr=[];
                $str_arr=explode(',',  $data->attached_users);

                foreach($str_arr as $one_user){
                    if($one_user!=$user_id){
                        $arr[]=$one_user; 
                    } 
                }
                
                $attached_users_new=implode(',', $arr);
                
                $item = new stdClass();
                $item->id = $task_id;
                $item->attached_users = $attached_users_new;
                $this->db->updateObject('#__audit_task_list', $item, 'id');
                //return $attached_users_new;
            break;
        }
    }
    
    public function getAttachedTaskStatus($user_id, $task_id)
    {
        $user=JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM #__audit_task_list WHERE `id_user` = '".$user->owner_id."' AND `id`='".$task_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(in_array($user_id, explode(',', $data->attached_users))){
            return'1';
        } else{
            return '0';
        }
        
       
    }
    
    public function getAttachedDkTaskStatus($user_id, $task_id)
    {
        $user=JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM #__audit_dk_task_list WHERE `id_user` = '".$user->owner_id."' AND `id`='".$task_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(in_array($user_id, explode(',', $data->attached_users))){
            return '1';
        } else{
            return '0';
        }
        
       
    }
    
    public function getLayoutSpecificTaskAPISelect($user_id , $lang)
    {
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        } 
        
        $pass = $this->db->escape($_POST['pass']);
        
        $user = JFactory::getUser((int)$user_id);
        $query = "SELECT * FROM #__users WHERE `password2` = '".$pass."' AND `owner_id` = '".$user->owner_id."'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();
        
        $user_by_password = JFactory::getUser((int)$select_user_by_password->id);
	
        
        $query = "SELECT * FROM #__users WHERE `owner_id` = '".$user->owner_id."' AND password2 = '".$pass."'";
        $this->db->setQuery($query);
        $userlist = $this->db->loadAssoc();

        
	if(is_array($userlist)){
            $userlist = $userlist['id'];  
        } else{
            $userlist = '';
        }


        $password_correct='0';
        if(!empty($select_user_by_password)){
            $password_correct='1';
        }
       
        $token=$user_by_password->api_token;
        $result=$this->apiGetTaskList($token);

        $to1 = 'developer3452@gmail.com';
        $subject = 'API ultima getLayoutSpecificTaskAPISelect()';
        $headers = "From: info@curiotime.com\r\n";
        $headers .= "MIME-Version: 1.0\r\n";
        $headers .= "Content-Type: text/html; charset=UTF-8\r\n";
        $message = '<pre>'.print_r($user_by_password, true).'</pre>';
        //mail($to1, $subject, $message, $headers);

        if(!empty($result->result)){
           
            $i=0;

            foreach($result->result as $one_task){
                if(!empty($one_task->field4)){
                    if($one_task->start=='0'){
                        $title='Start task';
                        $start_stop_mode='start_co';
                    } elseif($one_task->start=='1'){
                        $title='Stop task';
                        $start_stop_mode='stop_co';
                    }
                    
                    $html.=
                    '<div class="one_option" data-option-value="'.$one_task->id.'">'
                        .'<div class="one_option_task_text">'
                            .$one_task->field4
                        .'</div>'
                        .'<div class="one_option_fields_wrapper">'
                            .'<div class="one_option_fields_one_field">'
                                .'<input value="'.$one_task->field2.'" type="text" style="background: #d7d9cf !important; -webkit-padding-before: 0 !important" class="input_one_option input_api_hours" placeholder="'.JText::_('COM_AUDIT_HOME_API_TASKS_HOUR').'"/>'
                            .'</div>'
                            .'<div class="one_option_fields_one_field">'
                                .'<input value="'.$one_task->unit.'" type="text" style="background: #d7d9cf !important; -webkit-padding-before: 0 !important" class="input_one_option input_api_unit" placeholder="'.JText::_('COM_AUDIT_HOME_API_TASKS_UNIT').'"/>'
                            .'</div>'
                            .'<div class="one_option_fields_one_field">'
                                .'<input value="'.$one_task->field3.'" type="text" style="background: #d7d9cf !important; -webkit-padding-before: 0 !important" class="input_one_option input_api_item" placeholder="'.JText::_('COM_AUDIT_HOME_API_TASKS_ITEM').'"/>'
                            .'</div>'
                            .'<div class="one_option_fields_one_field">';
                    if($one_task->start=='0'){
                        //$html.='<i class="fa fa-play '.$start_stop_mode.'" id="co_start_task-'.$one_task->id.'" aria-hidden="true" data-task-id="'.$one_task->id.'" title="'.$title.'"></i>';    
                        $html.='<img src="/components/com_audit/assets/images/start.png" alt="" class="img_api_select_icon icon_start '.$start_stop_mode.'" id="co_start_task-'.$one_task->id.'" data-task-id="'.$one_task->id.'" title="'.$title.'"/>';                    
                    } elseif($one_task->start=='1'){
                        //$html.='<i class="fa fa-stop-circle '.$start_stop_mode.'" id="co_start_task-'.$one_task->id.'" aria-hidden="true" data-task-id="'.$one_task->id.'" title="'.$title.'"></i>';      
                         $html.='<img src="/components/com_audit/assets/images/stop.png" alt="" class="img_api_select_icon icon_start '.$start_stop_mode.'" id="co_start_task-'.$one_task->id.'" data-task-id="'.$one_task->id.'" title="'.$title.'"/>';                                        
                    }  
                    $html.=
                            '</div>'
                        .'</div>'
                    .'</div>';
                    

                }
                $i++;
            }
        }


        return [
            'html'=>$html,
            'response'=>$result->result
        ];
    }
    
    public function preparePassw($passw)
    {
        return password_hash($passw, PASSWORD_BCRYPT);
    }
    
    public function apiGetTaskList($token)
    {
        if( $curl = curl_init() ) { 
            //prepare password from api
            $prepare_passw=$this->preparePassw($this->password_current_api);

            $options=[  
               CURLOPT_URL=>empty($_SERVER['HTTPS'])?'http://':'https://'.$_SERVER['SERVER_NAME'].'/api/api.php',
               CURLOPT_RETURNTRANSFER=>true,
               CURLOPT_POST=>true,
               CURLOPT_POSTFIELDS=>[
                  'passw'=>$prepare_passw,
                  'action'=>'getTaskList',
                  'token'=>$token
               ],
             
            ];

            curl_setopt_array($curl, $options);
            $out = curl_exec($curl);
         
            curl_close($curl);

            return json_decode($out);
        } else{
            exit('Curl not init');
        }
    }
    
    public function startCOTaskAPI($pass, $user_id, $task_id, $hours, $unit, $item, $mode, $lat, $lng)
    {
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        } 
        
        $pass = $this->db->escape($pass);
        $mode= $this->db->escape($mode);
        $user = JFactory::getUser((int)$user_id);
       
        $query = "SELECT * FROM #__users WHERE `password2` = '".$pass."' AND `owner_id` = '".$user->owner_id."'";
        $this->db->setQuery($query);
        $select_user_by_password = $this->db->loadObject();
        
        $user_by_password = JFactory::getUser((int)$select_user_by_password->id);
        $token=$user_by_password->api_token;
        
        
        if(!empty($select_user_by_password)){
            if( $curl = curl_init() ) { 
                //prepare password from api
                $prepare_passw=$this->preparePassw($this->password_current_api);

                $options=[  
                    CURLOPT_URL=>empty($_SERVER['HTTPS'])?'http://':'https://'.$_SERVER['SERVER_NAME'].'/api/api.php',
                    CURLOPT_RETURNTRANSFER=>true,
                    CURLOPT_POST=>true,
                    CURLOPT_POSTFIELDS=>[
                        'passw'=>$prepare_passw,
                        'action'=>'startCOTime',
                        'token'=>$token,
                        'id'=>$task_id,
                        'hours'=>$hours,
                        'unit'=>$unit,
                        'item'=>$item,
                        'mode'=>$mode,
                        'lat'=>$lat,
                        'lng'=>$lng
                    ]
                ];

                curl_setopt_array($curl, $options);
                $out = curl_exec($curl);
         
                curl_close($curl);

                return json_decode($out);
            } else{
                exit('Curl not init');
            }
        
        }
    }
    
    public function getSubtasks($parent_id)
    {
        $parent_id=(int)$parent_id;
        $query = "SELECT * FROM #__audit_subtasks_list WHERE `parent_id` = '".$parent_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $list = $this->db->loadObjectList();
        
        return $list;
    }
    
    private function getDkSubtasks()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkSubtasks();
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    private function getDkSubtasksForHomepage($manager_id)
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkSubtasksForHomepage($manager_id);
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    public function getDkSubtasksForApi($manager_id)
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkSubtasksForApi($manager_id);
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    public function addSubTask($value, $parent_id, $lang)
    {
        $value=$this->db->escape($value);
        $item=new stdClass();
        $item->id=null;
        $item->id_user=$this->user->id;
        $item->text=$value;
        $item->parent_id=$parent_id;
        
        $this->db->insertObject('#__audit_subtasks_list', $item);
        
        setcookie('added_subtask_id', $this->db->insertid(),  time()+(60*60*24));
        return $value;
    }
    
    public function editSubTask(...$a)
    {
        $args = func_get_args();
        $rule_id = $args[0];
        $value = $args[1];
        $lang = $args[2];
        
          
                
        $value=$this->db->escape($value);
        $item=new stdClass();
        $item->id=(int)$rule_id;
        $item->id_user=$this->user->id;
        $item->text=$value;
        
        
        $this->db->updateObject('#__audit_subtasks_list', $item, 'id');
        return $value;
    }
    
    public function addSubTaskForButton($value, $parent_id, $lang)
    {
        $value=$this->db->escape($value);
        $item=new stdClass();
        $item->id=null;
        $item->id_user=$this->user->id;
        $item->text=$value;
        $item->parent_id=$parent_id;
        
        $this->db->insertObject('#__audit_subtasks_list', $item);
        return $this->db->insertid();
    }
    
    public function getHtmlOneSubtask($subtask_id, $parent_id, $subtask_text)
    {
        $config=&JFactory::getConfig();  
        $enable_subtask_delete=$config->get('enable_subtask_delete');
        
        $html='
            <div class="data_subtask" data-option-task-id="'.$subtask_id.'">
                <div class="add_new_sutasck" data-parent-id="'.$parent_id.'">>></div>
                <div class="edit_subtask" id="edit_task-'.$subtask_id.'">'.$subtask_text.'</div>';
        
                if($enable_subtask_delete=='1'){
                    $html.='<div class="delete_subtask" data-id="'.$subtask_id.'" data-parent-id="'.$parent_id.'"><i class="fa fa-times" aria-hidden="true"></i></div>';
                }
                
        $html.='</div>
        ';
        
        return $html;
    }
    
    public function deleteSubTask($parent_id)
    {
        $query = "DELETE FROM `#__audit_subtasks_list` WHERE `parent_id` = '$parent_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function checkPermissionDeleteSubtask($user_id){
        if($user_id==0){
            exit;
        }
        $user_check=& JFactory::getUser($user_id);
        $manager_id=$user_check->owner_id;
        
        if($manager_id!=$user_check->id){
            $res='0';
        } else{
            $res='1';
        }
        
        return $res;
    }
    
    public function deleteOneSubTask($id, $parent_id)
    {
        if($id==0){
            exit;
        }
        
        $query = "DELETE FROM `#__audit_subtasks_list` WHERE `parent_id` = '$parent_id' AND `id` = '$id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function setDefaultSubtasks($task_array)
    {
        foreach($task_array as $one_task)
        {
            $subtasks_list=$this->getSubtasks($one_task->id);
            
            if(empty($subtasks_list)){
               /* if($lang=='is'){
                    $value='Breyta nýjum undirliti';
                } else{
                    $value='Edit new subtask';
                }*/
                if ($this->lang == 'is') {
                    $this->lang->setLanguage('is-IS');
                    $this->lang->load();
                } 
                $value=JText::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                
                $this->addSubTaskForButton($value, $one_task->id, $this->lang);
            }
        }
    }
    
    public function setTasksOrdering($data) 
    {
        $ids = explode(',', $data);
        
        $item = new stdClass;
        $i = 1;
        
        foreach ($ids as $id) {
            $curr_id=explode('-', $id)[1];
            
            $item->id = $curr_id;
            $item->ordering = $i;
            $this->db->updateObject('#__audit_task_list', $item, 'id');
            $i++;
        }
    }
    
    private function checkDkTaskExisting($id)
    {
        $query = "SELECT * FROM #__audit_dk_task_list WHERE `id` = '".(int)$id."'";
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($query.PHP_EOL, true), FILE_APPEND | LOCK_EX);
        $this->db->setQuery($query);
        $data = $this->db->loadObject()->id;
        
        if(empty($data)){
            return 0;
        } else{
            return 1;
        }
    }
    
    public function setTasksOrderingForDkTasksNewPsd($data, $tasks_info)
    {
        $ids = explode(',', $data);
        
        $item = new stdClass;
        $i = 1;
        
        foreach ($tasks_info as $id) {
            //$dk_task_info =  explode('-', $id);
            //$curr_id = $dk_task_info[1];
            //$dk_task_name = $dk_task_info[2];
            $curr_id  = $id['task_id'];
            $dk_task_name = $id['task_name'];
            
           // $item->original_id = preg_replace("/[^0-9]/", '', $curr_id);
            $item->ordering = $i;
            $item->text = trim($this->db->escape($dk_task_name));
            $check_existing = $this->checkDkTaskExisting($curr_id);
            if($check_existing !=1){
                $item->id = null;
               
                $item->id_user = $this->user->owner_id;
                $item->original_id = $curr_id;
                $this->db->insertObject('#__audit_dk_task_list', $item, 'id');
            } else{
                $item->id = $curr_id;
                $this->db->updateObject('#__audit_dk_task_list', $item, 'id');
            }
            
            
            $i++;
        }
    }
    
    public function loadTaskListNewPsd(...$a)
    {
        $args = func_get_args();
        $lang = $args[0];
        
        $task_list = json_decode($this->getTaskList());
        $this->user_list = json_decode($this->getPrepareUserListNewPsd());
       
        $count = $i =0;
        $html = '';
        
        $config = &JFactory::getConfig();
        $enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        $enable_dropbox_api = $config->get('enable_dropbox_api');
        $enable_gps_task_changes = $config->get('enable_gps_task_changes');
        $enable_326_task_changes_in_task_manager = $config->get('enable_326_task_changes_in_task_manager');
        $checkbox_sync_with_main_tasks_state = $this->getSyncWithMainTasksState();
        
       // if($checkbox_sync_with_main_tasks_state == 1){
            $all_submenu_tasks = json_decode($this->getSubmenuTaskList());
       // }
       
        $task_sortable_class='';
        if($enable_sortable_in_task_manager_and_api=='1'){
            $task_sortable_class='';      
        }
        
        if($lang=='is'){
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        foreach($task_list as $one_task){
            
        $html .= '
            <div class="one_item_page_rules '.$task_sortable_class.'" id="one_task-'.$one_task->id.'">';
                if($enable_sortable_in_task_manager_and_api == '1'){
                    $html .= '<div class="move-icon-box"><i class="icon-menu"></i></div>';
                } 
                $html .='<div class="one_item_page_rules_item">
                    <div class="task_icon">'.++$count.'.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">  
                    <div class="edit_task" id="edit_task-'.$one_task->id.'"';  
                    if($this->enable_gps_type_of_tasks == '1' && $one_task->is_gps_task == 1){
                        $html .= 'style="display:none"'; 
                    } $html .= '>' . $one_task->text . '</div>';
                
                    if($this->enable_gps_type_of_tasks == '1'){
                        $task_id = $one_task->id;
                        $autocomplete_html_id = 'one_task_autocomplete-' . $task_id;
                                           
                        if($one_task->is_gps_task == 1){
                            $array_of_autocompetes[] = $autocomplete_html_id;
                        }
                        
                        $html .= '<input type="text" data-task-id="' . $one_task->id . '" value="' . $one_task->task_address . '" class="input_autocomplete js_event_autocomplete" id="' . $autocomplete_html_id . '"';  
                        if($this->enable_gps_type_of_tasks == '1' && $one_task->is_gps_task == 1){ 
                            $html .= 'style="display:block"';  
                        } else{
                            $html .= 'style="display:none"'; 
                        }
                        $html .= '/>';
                    }
                        
                    $html .= '</div>';
                
                if($this->enable_automatick_clock_icon_in_task_manager == '1'){
                    $auto  = ($one_task->is_auto == 1) ? '/components/com_audit/assets/images/task_manager/auto_active.png' : '/components/com_audit/assets/images/task_manager/auto.png';
                    $auto_marker_class  = ($one_task->is_auto == 1) ? ' active_auto' : '';
                                    
                    $html .= '<div class="mr-3 active_icon one_standart_margin" data-task-id="' . $one_task->id . '">  
                        <img src="' . $auto . '" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_ACTIVE') . '" class="js_event_toggle_task_auto' . $auto_marker_class . '"/>
                    </div>';
                }
                if($this->enable_gps_type_of_tasks == '1'){
                    $marker  = ($one_task->is_gps_task == 1) ? '/components/com_audit/assets/images/task_manager/marker_active.png' : '/components/com_audit/assets/images/task_manager/marker.png';
                    $marker_class  = ($one_task->is_gps_task == 1) ? ' active_gps_task' : '';
            
                    $html .= '<div class="img_gps_radius_in_task_wr"><img src="' . $marker . '" data-task-id="' . $one_task->id . '" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_TITLE') . '" class="img_gps_radius_in_task js_event_set_this_task_as_gps_task' . $marker_class .'"/></div>';                     
                }
               
                if($enable_dropbox_api == '1'){
                    $html .='<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox one_standart_margin" data-task-id="'.$one_task->id.'">
                        <!--<button class="btn btn-outline-info btn-sm" type="button"><i class="fa fa-picture-o" aria-hidden="true"></i>'.JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES').'</button>-->
                            <img src="/components/com_audit/assets/images/task_manager/camera.png" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_CAMERA') .'" class="open_files_new_img"/>
                    </div>';
                } if($enable_gps_task_changes == '1'){
                    $one_task_item_devices_n_tools_class = '';
                                        
                    if($one_task->is_for_devices_n_tools == 1){
                        $one_task_item_devices_n_tools_img_src = '/components/com_audit/assets/images/task_manager/tools_active.png';
                        $one_task_item_devices_n_tools_class = ' attached_to_devices';
                    } else{
                        $one_task_item_devices_n_tools_img_src = '/components/com_audit/assets/images/task_manager/tools.png';
                    }
                                        
                    $html .= '<div class="one_item_page_rules_item item_devices_n_tools one_standart_margin" data-task-id="'.$one_task->id.'">
                        <img src="' . $one_task_item_devices_n_tools_img_src . '" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_TOOLS') .'" class="js_event_toggle_task_to_devices_n_tools' . $one_task_item_devices_n_tools_class . '"/>
                    </div>';
                }
                 if($enable_326_task_changes_in_task_manager == '1'){
                    if($one_task->sync_with_submenu == '1'){
                        $style_class = 'style-4';
                        $src = '/components/com_audit/assets/images/task_manager/sync-to-subtask_active.png';
                    } else{
                        $style_class = 'style-5';
                        $src = '/components/com_audit/assets/images/task_manager/sync-to-subtask.png';
                    }
                    /*$html .= '<button class="btn btn-info ';
                    
                    if($checkbox_sync_with_main_tasks_state != 1){ 
                        $html .= 'js_event_attach_submenu_tasks_to_task ';
                    }
                    $html .= 'mr-3 '.$style_class.'" type="button" data-task-id="'. $one_task->id .'"><i class="fa fa-caret-square-o-down" aria-hidden="true"></i></button>';*/
                    $html .= '<div class="one_standart_margin">';
                        $html .= '<img src="' . $src . '" alt="" class="';
                        if($this->sync_with_main_tasks_state != 1){
                            $html .= 'js_event_attach_submenu_tasks_to_task'; 
                        } 
                        $html .= ' mr-3 '. $style_class . '" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_SYNC') . '" data-task-id="'.  $one_task->id . '"/>';
                    $html .= '</div>';
                }
                $html .='
                <div class="one_item_page_rules_item item_subtasks one_standart_margin" data-task_id="'.$one_task->id.'">
                    <!--<img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_subtask"/>-->
                    <img src="/components/com_audit/assets/images/gps/open_subtasks.png" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_SUBTASK') .'" class="toggle_subtask"/>
                </div>
                <div class="one_item_page_rules_item item_user_binding one_standart_margin" data-task_id="'.$one_task->id.'">
                    <!--<i class="fa fa-user-circle toggle_attach_task i_toggle_subtask" aria-hidden="true"></i>-->
                    <!--<img src="/components/com_audit/assets/images/gps/attached_users.png" alt="" class="toggle_attach_task"/>-->
                    <img src="/components/com_audit/assets/images/task_manager/private-task.png" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_PRIVATE_TASK') .'" class="toggle_attach_task"/>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                            ';
                            foreach($this->user_list as $one_user){
                                $task_status=$this->getAttachedTaskStatus($one_user->id, $one_task->id);
                                $html .='<div class="one_option';
                                if($task_status==='1'){ 
                                    $html .=' selected_option_active';
                                }  
                                $html .='" data-option-value="'.$one_user->id.'" data-option-task-id="'.$one_task->id.'">
                                    <span>'.$one_user->username0.'</span>
                                        <i class="fa ';
                                        if($task_status==='1'){ 
                                            $html .='fa-check-circle-o';       
                                        } else{
                                            $html .='fa-circle-thin';       
                                        } 
                                        $html .='" aria-hidden="true"></i>
                                    </div>';
                            } 
                            $html .='
                        </div>
                    </div>     
                </div>
                <div class="one_item_page_rules_item item_delete_task one_standart_margin" data-task_id="'.$one_task->id.'">
                    <div class="item_rules_close_wrapper">
                        <!--<p>X</p>-->
                        <!--<img src="/components/com_audit/assets/images/gps/del.png" alt="" class="img_del_task"/>-->
                        <img src="/components/com_audit/assets/images/task_manager/delete.png" alt="" title="' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_GPS_ICON_DEL') .'" class="img_del_task"/>
                    </div>
                </div>';

                if($checkbox_sync_with_main_tasks_state == 1 || $one_task->sync_with_submenu == 1){
                    $subtasks_list = $all_submenu_tasks;
                } else{
                    $subtasks_list = $this->getSubtasks($one_task->id);
                }
        
               $html .= '
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';
                    
                        if(empty($subtasks_list)){
                            //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                            if($enable_subtask_delete == '1'){
                                $parent_class='data_subtask-no_line';
                                $def_text='';
                                $row_class='no-line';
                            } else{
                                $def_text=JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                                $row_class='';
                            }
                                                        
                            $html.='
                                <div class="data_subtask '.$parent_class.'">
                                     <div class="add_new_sutasck" data-parent-id="'.$one_task->id.'">>></div>
                                     <div class="edit_subtask new_subtask '.$row_class.'" id="parent_id-'.$one_task->id.'-new">'.$def_text.'</div>
                                </div>';
                        } 
                            foreach($subtasks_list as $one_subtask){
                                $html.='<div class="data_subtask" data-option-task-id="'.$one_subtask->id.'">
                                            <div class="add_new_sutasck" data-parent-id="'.$one_task->id.'">>></div>
                                            <div class="edit_subtask" id="edit_task-'.$one_subtask->id.'">'.$one_subtask->text.'</div>';
                                
                                            if($enable_subtask_delete=='1'){
                                                $html.='<div class="delete_subtask" data-id="'.$one_subtask->id.'" data-parent-id="'.$one_task->id.'"><i class="fa fa-times" aria-hidden="true"></i></div>';
                                            }
                                $html.='</div>';
                            } 
                        
                        $html.='
                    </div>
                </div>
             </div>';

             $i++?>
        <?php } 
        
        return $html;
    }
    
    private function compare($a, $b)
    {
        //$alphabet = 'aąbcćdeęfghijklłmnnoóqprstuvwxyzźż'; // i used polish letters
        $alphabet =  'aábcdðeéfghiíjklmnoópqrstuúvwxyýzþæö';
        
        $a = mb_strtolower($a->username0);
        $b = mb_strtolower($b->username0);

        for ($i = 0; $i < mb_strlen($a); $i++) {
            if (mb_substr($a, $i, 1) == mb_substr($b, $i, 1)) {
                continue;
            }
            if ($i > mb_strlen($b)) {
                return 1;
            }
            if (mb_strpos($alphabet, mb_substr($a, $i, 1)) > mb_strpos($alphabet, mb_substr($b, $i, 1))) {
                return 1;
            } else {
                return -1;
            }
        }
    }

    public function getPrepareUserListNewPsd()
    {
        $query = "SELECT * FROM #__users WHERE `owner_id` = '".$this->user->owner_id."' AND `id`!='".$this->user->owner_id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        usort($data, [$this, 'compare']);
        ksort($data);  
          
        return json_encode($data);
    }
    
    private function getDkTaskList()
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasks();
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    private function getDkTaskListForHomepage($manager_id)
    {
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasksApi($manager_id);
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    public function getDkTaskListAppApi($manager_id)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($manager_id, true), FILE_APPEND | LOCK_EX);
        JLoader::register('AuditModelDk', JPATH_ROOT . '/components/com_audit/models/dk.php');
        $model_dk = JModelLegacy::getInstance('Dk', 'AuditModel');
        $dk_tasks = $model_dk->getDkTasksApi($manager_id);
        
        if($dk_tasks->Message){
            throw new Exception('Error on DK server with text: '.$dk_tasks->Message);
        }
        
        return json_encode($dk_tasks);
    }
    
    private function getSortedDkTaskList()
    {
        $config = &JFactory::getConfig();  
        //$enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_dk_task_list WHERE `id_user` = '".$this->user->owner_id."' AND `JobStatus` = '1' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    public function loadDkTasks(...$a) 
    {
        $args = func_get_args();
        $lang = $args[0];

        $task_list = json_decode($this->getDkTaskList());
        $sorted_dk_task_list = json_decode($this->getSortedDkTaskList());
        $this->user_list = json_decode($this->getPrepareUserListNewPsd());
       
        $count = $i = 0;
        $html = '';

        $config = &JFactory::getConfig();
        $enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        $enable_dropbox_api = $config->get('enable_dropbox_api');

        $task_sortable_class = '';
        if ($enable_sortable_in_task_manager_and_api == '1') {
            $task_sortable_class = '';
        }

        if ($lang == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $subtasks_list = json_decode($this->getDkSubtasks());
        /*echo '<pre>';
        print_r($subtasks_list);
        echo '</pre>';
        exit;*/
        $html .= '<input type="hidden" class="js_event_active_dk_tasks"/>';
        
        //load Dk tasks from API
        if(empty($sorted_dk_task_list)){
            $html .= '<input type="hidden" class="js_event_is_loaded_not_saved_dk_tasks"/>';
            foreach ($task_list as $one_task) {
            
            
            $html .= '
                <div class="one_item_page_rules ' . $task_sortable_class . ' one_dk_task" id="one_task-' . $one_task->Number . '-'.$one_task->Name.'" data-dk-task-id="'.$one_task->Number.'" data-dk-task-name="'.$one_task->Name.'">';
                if ($enable_sortable_in_task_manager_and_api == '1') {
                    $html .= '<div class="move-icon-box"><i class="icon-menu"></i></div>';
                }
            $html .= '<div class="one_item_page_rules_item">
                    <div class="task_icon">' . ++$count . '.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">
                    <div class="edit_task" id="edit_task-' . $one_task->Number . '">' . $one_task->Number.' | '.$one_task->Name .'</div>
                </div>';

            if ($enable_dropbox_api == '1') {
                $html .= '<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox_for_dk" data-task-id="' . $one_task->Number . '">
                        <button class="btn btn-outline-info btn-sm" type="button"><i class="fa fa-picture-o" aria-hidden="true"></i>' . JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES') . '</button>    
                    </div>';
            }

            $html .= '
                <div class="one_item_page_rules_item item_subtasks" data-task_id="' . $one_task->Number . '">
                    <img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_subtask"/>
                </div>
                <div class="one_item_page_rules_item item_user_binding" data-task_id="' . $one_task->Number . '">
                    <i class="fa fa-user-circle toggle_attach_task i_toggle_subtask" aria-hidden="true"></i>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                            ';
            foreach ($this->user_list as $one_user) {
                $task_status = $this->getAttachedDkTaskStatus($one_user->id, $one_task->id);
                $html .= '<div class="one_option';
                if ($task_status === '1') {
                    $html .= ' selected_option_active';
                }
                $html .= '" data-option-value="' . $one_user->id . '" data-option-task-id="' . $one_task->Number . '">
                                    <span>' . $one_user->username0 . '</span>
                                        <i class="fa ';
                if ($task_status === '1') {
                    $html .= 'fa-check-circle-o';
                } else {
                    $html .= 'fa-circle-thin';
                }
                $html .= '" aria-hidden="true"></i>
                                    </div>';
            }
            $html .= '
                        </div>
                    </div>     
                </div>
                ';
            


            $html .= '
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';

            if (empty($subtasks_list)) {
                //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                if ($enable_subtask_delete == '1') {
                    $parent_class = 'data_subtask-no_line';
                    $def_text = '';
                    $row_class = 'no-line';
                } else {
                    $def_text = JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                    $row_class = '';
                }

                /*$html .= '
                                <div class="data_subtask ' . $parent_class . '">
                                     <div class="add_new_sutasck" data-parent-id="' . $one_task->id . '">>></div>
                                     <div class="edit_subtask new_subtask ' . $row_class . '" id="parent_id-' . $one_task->id . '-new">' . $def_text . '</div>
                                </div>';*/
            }
            foreach ($subtasks_list as $one_subtask) {
                $html .= '<div class="data_subtask" data-option-task-id="">
                                            <!--<div class="add_new_sutasck" data-parent-id="">>></div>-->
                                            <div class="edit_subtask" id="edit_task-">' .$one_task->Number.' | '.$one_task->Name .' | '.$one_subtask->DESCRIPTION. '</div>';

                if ($enable_subtask_delete == '1') {
                    //$html .= '<div class="delete_subtask" data-id="' . $one_subtask->id . '" data-parent-id="' . $one_task->id . '"><i class="fa fa-times" aria-hidden="true"></i></div>';
                }
                $html .= '</div>';
            }

            $html .= '
                    </div>
                </div>
             </div>';

            $i++;
       

            }
        } else{//load DK tasks from DB
            foreach ($sorted_dk_task_list as $one_task) {
                /*if(!in_array($one_task->original_id, array_column($task_list, 'Number'))){//this code actualize task list(if delete on DK server-delete here)
                    continue; 
                }*/
                if(!empty($one_task->JobStatus) && $one_task->JobStatus != 1){
                    continue;
                }
                $html .= '
                <div class="one_item_page_rules ' . $task_sortable_class . ' one_dk_task" id="one_task-' . $one_task->id.'-'.$one_task->text.'" data-dk-task-id="'.$one_task->id.'" data-dk-task-name="'.$one_task->text.'">';
                if ($enable_sortable_in_task_manager_and_api == '1') {
                    $html .= '<div class="move-icon-box"><i class="icon-menu"></i></div>';
                }
                $html .= '<div class="one_item_page_rules_item">
                    <div class="task_icon">' . ++$count . '.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">
                    <div class="edit_task" id="edit_task-' . $one_task->id . '">' . $one_task->original_id.' | '.$one_task->text .'</div>
                </div>';

            if ($enable_dropbox_api == '1') {
                $html .= '<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox_for_dk" data-task-id="' . $one_task->id . '">
                        <button class="btn btn-outline-info btn-sm" type="button"><i class="fa fa-picture-o" aria-hidden="true"></i>' . JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES') . '</button>    
                    </div>';
            }

            $html .= '
                <div class="one_item_page_rules_item item_subtasks" data-task_id="' . $one_task->id . '">
                    <!--<img src="/components/com_audit/assets/images/folder-icon.png" alt="" class="toggle_subtask"/>-->
                    <img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_subtask"/>
                </div>
                <div class="one_item_page_rules_item item_user_binding" data-task_id="' . $one_task->id . '">
                    <i class="fa fa-user-circle toggle_attach_task i_toggle_subtask" aria-hidden="true"></i>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                 ';
            foreach ($this->user_list as $one_user) {
                $task_status = $this->getAttachedDkTaskStatus($one_user->id, $one_task->id);
                $html .= '<div class="one_option';
                if ($task_status === '1') {
                    $html .= ' selected_option_active';
                }
                $html .= '" data-option-value="' . $one_user->id . '" data-option-task-id="' . $one_task->id . '">
                                    <span>' . $one_user->username0 . '</span>
                                        <i class="fa ';
                if ($task_status === '1') {
                    $html .= 'fa-check-circle-o';
                } else {
                    $html .= 'fa-circle-thin';
                }
                $html .= '" aria-hidden="true"></i>
                                    </div>';
            }
            $html .= '
                        </div>
                    </div>     
                </div>';
          
             $html .= '
               
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';

            if (empty($subtasks_list)) {
                //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                if ($enable_subtask_delete == '1') {
                    $parent_class = 'data_subtask-no_line';
                    $def_text = '';
                    $row_class = 'no-line';
                } else {
                    $def_text = JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                    $row_class = '';
                }

               /* $html .= '
                                <div class="data_subtask ' . $parent_class . '">
                                     <div class="add_new_sutasck" data-parent-id="' . $one_task->id . '">>></div>
                                     <div class="edit_subtask new_subtask ' . $row_class . '" id="parent_id-' . $one_task->id . '-new">' . $def_text . '</div>
                                </div>';*/
            }
            foreach ($subtasks_list as $one_subtask) {
                $html .= '<div class="data_subtask" data-option-task-id="">
                                            <!--<div class="add_new_sutasck" data-parent-id="">>></div>-->
                                            <div class="edit_subtask" id="edit_task-">' . $one_task->original_id.' | '.$one_task->text .' | '.$one_subtask->DESCRIPTION . '</div>';

                if ($enable_subtask_delete == '1') {
                    //$html .= '<div class="delete_subtask" data-id="' . $one_subtask->id . '" data-parent-id="' . $one_task->id . '"><i class="fa fa-times" aria-hidden="true"></i></div>';
                }
                $html .= '</div>';
            }

            $html .= '
                    </div>
                </div>
             </div>';

            $i++
        ?>
        <?php

        }
        }
        return $html;
    }
    
    //point
    public function storeDkTasksToDb()
    {
        $table = '#__audit_dk_task_list';
        
        $user = $this->user;
        $query = "SELECT * FROM ".$table." WHERE `id_user` = '" . $this->user->owner_id . "'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList(); 

        if(empty($data)){
            $task_list = json_decode($this->getDkTaskList());
            //$sorted_dk_task_list = json_decode($this->getSortedDkTaskList());
            //$this->user_list = json_decode($this->getPrepareUserListNewPsd());

            $i = 1;

            foreach ($task_list as $one_dk_task) {
                $curr_id = $this->db->escape($one_dk_task->Number);
                $dk_task_name = $this->db->escape($one_dk_task->Name);
                
                $item = new stdClass();
                $item->id = null;
                $item->ordering = $i;
                $item->text = trim($dk_task_name);
                //$check_existing = $this->checkDkTaskExisting($curr_id);

                $item->id_user = $this->user->owner_id;
                $item->original_id = $curr_id;
                $this->db->insertObject('#__audit_dk_task_list', $item, 'id');

                $i++;
            }
        }
    }
    
    //point
    public function updateAttachedDkTask($user_id, $mode, $task_id, $ids_arr) {
        $table = '#__audit_dk_task_list';
        
        $user = JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM ".$table." WHERE `id_user` = '" . $user->owner_id . "' AND `id`='" . $task_id . "'";
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($query.PHP_EOL, true), FILE_APPEND | LOCK_EX);
        $this->db->setQuery($query);
        $data = $this->db->loadObject(); 
        
            
        if (empty($data)) {
          
            //$ids_arr = explode(',', $ids);
            
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/dk_tasks.html', print_r($ids_arr, true), FILE_APPEND | LOCK_EX);
            $item = new stdClass;
            $i = 1;

            foreach ($ids_arr as $id) {
                //$dk_task_info = explode('-', $id);
                
                //$curr_id = $dk_task_info[1];
                //$dk_task_name = $dk_task_info[2];
                $curr_id  = $id['task_id'];
                $dk_task_name = $id['task_name'];
                
                // $item->original_id = preg_replace("/[^0-9]/", '', $curr_id);
                $item->ordering = $i;
                $item->text = trim($this->db->escape($dk_task_name));
                $check_existing = $this->checkDkTaskExisting($curr_id);

                if ($check_existing != 1) {
                    $item->id = null;

                    $item->id_user = $this->user->owner_id;
                    $item->original_id = $curr_id;
                    $this->db->insertObject('#__audit_dk_task_list', $item, 'id');
                } else {
                    $item->id = $curr_id;
                    $this->db->updateObject('#__audit_dk_task_list', $item, 'id');
                }


                $i++;
            }
            
        } /*else {*/ 
            switch ($mode) {
                case 'add':
                    if (!empty($data->attached_users)) {
                        $attached_users_new = $data->attached_users . ',' . $user_id;
                    } else {
                        $attached_users_new = $user_id;
                    }

                    $item = new stdClass();
                    if (empty($data)) {
                        $item->original_id = $task_id;
                        $item->attached_users = $attached_users_new;

                        $res = $this->db->updateObject($table, $item, 'original_id');
                    } else{
                        $item->id = $task_id;
                        $item->attached_users = $attached_users_new;

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                   
                    break;
                case 'remove':
                    $arr = [];
                    $str_arr = explode(',', $data->attached_users);

                    foreach ($str_arr as $one_user) {
                        if ($one_user != $user_id) {
                            $arr[] = $one_user;
                        }
                    }

                    $attached_users_new = implode(',', $arr);
                    $item = new stdClass();
                    if (empty($data)) {
                        $item->original_id = $task_id;
                        $item->attached_users = $attached_users_new;

                        $res = $this->db->updateObject($table, $item, 'original_id');
                    } else{
                        $item->id = $task_id;
                        $item->attached_users = $attached_users_new;

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                   
                   
                    break;
            }
        //}
            
        if (empty($data)) {
            $query = "SELECT * FROM ".$table." WHERE `id_user` = '" . $user->owner_id . "' AND `original_id`='" . $task_id . "'";
        } else{
            $query = "SELECT * FROM ".$table." WHERE `id_user` = '" . $user->owner_id . "' AND `id`='" . $task_id . "'";
        }
        $this->db->setQuery($query);
        $saved_task = $this->db->loadObjectList()[0]; 
        
        return [
            'res' => $res,
            'saved_task_id' => $saved_task->id
        ];
    }
    
    public function attachSheduleToTask($user_id, $mode, $task_ids, $ids_arr, $schedule_id, $click_option, $selected_standart_task)
    {
        //$current_args = func_get_args();

        $table = '#__com_shifts_reservations';
        $table_dk_tasks = '#__audit_dk_task_list';
        $table_standart_tasks = '#__audit_task_list';
        $user = JFactory::getUser($user_id);
        $click_option_id = $click_option['id'];
        
        if(empty($task_ids) && $click_option['type'] === 'dk' /*&& empty($selected_standart_task)*/ && $mode == 'remove'){
          
            unset($task_ids);
            
            
            $task_ids = [
                [
                    'task_id' => $click_option_id
                ]
            ];
            
        } if($click_option['type'] === 'standart' && empty($selected_standart_task) && $mode == 'remove'){
            
            
            $selected_standart_task = [
                [
                    'task_id' => $click_option_id
                ]
            ];
        } /*if(empty($task_ids) && $click_option['type'] === 'standart' && !empty($selected_standart_task) && $mode == 'remove'){
            echo 'pp2'.PHP_EOL;
            unset($task_ids);
            //echo 'empty mode'.PHP_EOL;
            
            $task_ids = [
                [
                    'task_id' => $click_option_id
                ]
            ];
            /*$selected_standart_task = [
                [
                    'task_id' => $click_option_id
                ]
            ];*//*
        }  if(empty($task_ids) && $click_option['type'] === 'dk' && !empty($selected_standart_task) && $mode == 'remove'){
            echo 'pp2'.PHP_EOL;
            unset($task_ids);
            //echo 'empty mode'.PHP_EOL;
            
            $task_ids = [
                [
                    'task_id' => $click_option_id
                ]
            ];
            /*$selected_standart_task = [
                [
                    'task_id' => $click_option_id
                ]
            ];*//*
        }  */
        
        /*echo '<pre>$task_ids:';
        print_r($task_ids);
        echo '</pre>';
        
        echo '<pre>$selected_standart_task:';
        print_r($selected_standart_task);
        echo '</pre>';*/
        //exit;
        /*elseif(!empty($task_ids) && !empty($click_option) && empty($selected_standart_task)){
            echo 'pp1'.PHP_EOL;
            unset($selected_standart_task);
            //echo 'empty mode'.PHP_EOL;
            
            $selected_standart_task = [
                [
                    'task_id' => $click_option
                ]
            ];
            
        }*/
        /*if(empty($task_ids) && !empty($click_option) && !empty($selected_standart_task)){
            echo 'pp0'.PHP_EOL;
            unset($task_ids);
            //echo 'empty mode'.PHP_EOL;
            
            $task_ids = [
                [
                    'task_id' => $click_option
                ]
            ];
            
        } */
        /*if(!empty($task_ids) && !empty($click_option) && empty($selected_standart_task)){
            echo 'pp0'.PHP_EOL;
            unset($selected_standart_task);
            //echo 'empty mode'.PHP_EOL;
            //unset($task_ids);
            
            $selected_standart_task = [
                [
                    'task_id' => $click_option
                ]
            ];
            
        }*/
        
        
        
        //foreach DK tasks
        foreach($task_ids as $one_task){
            /*echo '<pre>$one_task:';
            print_r($one_task);
            echo '</pre>';*/
            
            $query = "SELECT * FROM ".$table." WHERE `id` = '" . $schedule_id . "' AND `room_id`='" . $user->id . "'";
            $this->db->setQuery($query);
            $data_shift = $this->db->loadObject();
        
            //$user = JFactory::getUser($user_id);
            //check existing DK task in DB
            $query = "SELECT * FROM ".$table_dk_tasks." WHERE (`id` = '" . $one_task['task_id'] . "' OR `original_id` ='".$one_task['task_id']."') AND `id_user`='" . $user->owner_id . "'";
            $this->db->setQuery($query);
            $data_dk_task = $this->db->loadObject(); 
        
            
            
            /*echo '<pre>';
            print_r($data_shift);
            echo '</pre>';
            exit;*/
            
        if (empty($data_dk_task)) {
            continue;
            
            $item = new stdClass;
            $i = 1;

            foreach ($ids_arr as $id) {
                //$dk_task_info = explode('-', $id);
                
                //$curr_id = $dk_task_info[1];
                //$dk_task_name = $dk_task_info[2];
                $curr_id  = $id['task_id'];
                $dk_task_name = $id['task_name'];
                
                // $item->original_id = preg_replace("/[^0-9]/", '', $curr_id);
                $item->ordering = $i;
                $item->text = trim($this->db->escape($dk_task_name));
                $check_existing = $this->checkDkTaskExisting($curr_id);

                if ($check_existing != 1) {
                    $item->id = null;

                    $item->id_user = $this->user->owner_id;
                    $item->original_id = $curr_id;
                    $this->db->insertObject('#__audit_dk_task_list', $item, 'id');
                } else {
                    $item->id = $curr_id;
                    $this->db->updateObject('#__audit_dk_task_list', $item, 'id');
                }


                $i++;
            }
            
        } 
        switch ($mode) {
                case 'add':
                    if (!empty($data_shift->tasks_ids)) {
                        $attached_users_new = $data_shift->tasks_ids . ',' . $one_task['task_id'];
                    } else {
                        $attached_users_new = $one_task['task_id'];
                    }
                    
                    $final = [];
                    foreach(explode(',', $attached_users_new) as $one_attached_task){
                        $final[$one_attached_task] = $one_attached_task;
                    }
                    
                    
                    $item = new stdClass();
                    if (empty($data_shift->tasks_ids)) {
                        $item->id = $data_shift->id;
                        $item->tasks_ids = implode($final, ',');

                        $res = $this->db->updateObject($table, $item, 'id');
                    } else{
                        $item->id = $data_shift->id;
                        $item->tasks_ids = implode($final, ',');

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                   
                    break;   
                case 'remove':
                    $arr = [];
                    $str_arr = explode(',', $data_shift->tasks_ids);

                    foreach ($str_arr as $one_attached_task) {
                        if ($one_attached_task != $click_option_id) {
                            $arr[] = $one_attached_task;
                        }
                    }
   
                    $attached_tasks = implode(',', $arr);
                   
                    $item = new stdClass();
                    if (empty($data_shift->tasks_ids)) {
                        $item->id = $data_shift->id;
                        $item->tasks_ids = $attached_tasks;

                        $res = $this->db->updateObject($table, $item, 'id');
                    } else{
                        $item->id = $data_shift->id;
                        $item->tasks_ids = $attached_tasks;

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                   
                   
                    break;
            }
           
            
          
        }
        
        //standart tasks
        /*$query = "SELECT * FROM ".$table." WHERE `id` = '" . $schedule_id . "' AND `room_id`='" . $user->id . "'";
        $this->db->setQuery($query);
        $data_shift = $this->db->loadObject(); */
        
        //foreach standart tasks
        foreach($selected_standart_task as $one_task){
            //continue;
            $query = "SELECT * FROM ".$table." WHERE `id` = '" . $schedule_id . "' AND `room_id`='" . $user->id . "'";
            $this->db->setQuery($query);
            $data_shift = $this->db->loadObject();
            
            /*echo '<pre>$data_shift:';
            print_r($data_shift);
            echo '</pre>';*/
            
            switch ($mode) {
                case 'add':
                    if (!empty($data_shift->standart_tasks_ids)) {
                        $attached_users_new = $data_shift->standart_tasks_ids . ',' . $one_task['task_id'];
                    } else {
                        $attached_users_new = $one_task['task_id'];
                    }
                    
                    $final = [];
                    foreach(explode(',', $attached_users_new) as $one_attached_task){
                        $final[$one_attached_task] = $one_attached_task;
                    }
                    
                    
                    $item = new stdClass();
                    if (empty($data_shift->standart_tasks_ids)) {
                        $item->id = $data_shift->id;
                        $item->standart_tasks_ids = implode($final, ',');

                        $res = $this->db->updateObject($table, $item, 'id');
                    } else{
                        $item->id = $data_shift->id;
                        $item->standart_tasks_ids = implode($final, ',');

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                   
                    break;   
                case 'remove':
                    $arr = [];
                    $str_arr = explode(',', $data_shift->standart_tasks_ids);

                    foreach ($str_arr as $one_attached_task) {
                        if ($one_attached_task != $click_option['id']) {
                            $arr[] = $one_attached_task;
                        }
                    }
   
                    $attached_tasks = implode(',', $arr);
                   
                    $item = new stdClass();
                    if (empty($data_shift->standart_tasks_ids)) {
                        $item->id = $data_shift->id;
                        $item->standart_tasks_ids = $attached_tasks;

                        $res = $this->db->updateObject($table, $item, 'id');
                    } else{
                        $item->id = $data_shift->id;
                        $item->standart_tasks_ids = $attached_tasks;

                        $res = $this->db->updateObject($table, $item, 'id');
                    }
                    break;
            }

        }
       
    }
    
    public function deleteCompanyDkTasks()
    {
        $query = "DELETE FROM `#__audit_dk_task_list` WHERE `id_user` = '".$this->user->owner_id."';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getSubmenuTaskList()
    {
        
        $enable_sortable_in_task_manager_and_api = '1';
        if($enable_sortable_in_task_manager_and_api=='1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT * FROM #__audit_submenu_task_list WHERE `id_user` = '".$this->user->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    public function load3rdTaskList(...$a) {
        $args = func_get_args();
        $lang = $args[0];

        $task_list = json_decode($this->getSubmenuTaskList());
        $this->user_list = json_decode($this->getPrepareUserListNewPsd());

        $count = $i = 0;
        $html = '';

        $config = &JFactory::getConfig();
        $enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        $enable_dropbox_api = $config->get('enable_dropbox_api');

        $task_sortable_class = '';
        if ($enable_sortable_in_task_manager_and_api == '1') {
            $task_sortable_class = '';
        }

        if ($lang == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $html = '<div class="row">'
                . '<div class="col-9 js_event_submenu_tasks_sortable">';
        
        foreach ($task_list as $one_task) {

            $html .= '
            <div class="one_item_page_rules ' . $task_sortable_class . '" id="one_task-' . $one_task->id . '">';
            if ($enable_sortable_in_task_manager_and_api == '1') {
                $html .= '<div class="move-icon-box"><i class="icon-menu"></i></div>';
            }
            $html .= '<div class="one_item_page_rules_item">
                    <div class="task_icon">' . ++$count . '.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">
                    <div class="js_event_edit_submenu_task edit_subtask_block" id="edit_task-' . $one_task->id . '">' . $one_task->text . '</div>
                </div>';

            if ($enable_dropbox_api == '1') {
                $html .= '<!--<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox" data-task-id="' . $one_task->id . '">
                        <button class="btn btn-outline-info btn-sm" type="button"><i class="fa fa-picture-o" aria-hidden="true"></i>' . JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES') . '</button>    
                    </div>-->';
            }

            $html .= '
                <!--<div class="one_item_page_rules_item item_subtasks" data-task_id="' . $one_task->id . '">
                    <!--<img src="/components/com_audit/assets/images/folder-icon.png" alt="" class="toggle_subtask"/>
                    <img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_subtask"/>
                </div>-->
                <!--<div class="one_item_page_rules_item item_user_binding" data-task_id="' . $one_task->id . '">
                    <i class="fa fa-user-circle toggle_attach_task i_toggle_subtask" aria-hidden="true"></i>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                            ';
            foreach ($this->user_list as $one_user) {
                $task_status = $this->getAttachedTaskStatus($one_user->id, $one_task->id);
                $html .= '<div class="one_option';
                if ($task_status === '1') {
                    $html .= ' selected_option_active';
                }
                $html .= '" data-option-value="' . $one_user->id . '" data-option-task-id="' . $one_task->id . '">
                                    <span>' . $one_user->username0 . '</span>
                                        <i class="fa ';
                if ($task_status === '1') {
                    $html .= 'fa-check-circle-o';
                } else {
                    $html .= 'fa-circle-thin';
                }
                $html .= '" aria-hidden="true"></i>
                                    </div>';
            }
            $html .= '
                        </div>
                    </div>     
                </div>-->
                <div class="one_item_page_rules_item js_event_delete_submenu_task" data-task_id="' . $one_task->id . '">
                    <div class="item_rules_close_wrapper">
                        <p>X</p>
                    </div>
                </div>';
            //unset($subtasks_list);      
            $subtasks_list = $this->getSubtasks($one_task->id);



            $html .= '
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';

            if (empty($subtasks_list)) {
                //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                if ($enable_subtask_delete == '1') {
                    $parent_class = 'data_subtask-no_line';
                    $def_text = '';
                    $row_class = 'no-line';
                } else {
                    $def_text = JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                    $row_class = '';
                }

                $html .= '
                                <div class="data_subtask ' . $parent_class . '">
                                     <div class="add_new_sutasck" data-parent-id="' . $one_task->id . '">>></div>
                                     <div class="edit_subtask new_subtask ' . $row_class . '" id="parent_id-' . $one_task->id . '-new">' . $def_text . '</div>
                                </div>';
            }
            foreach ($subtasks_list as $one_subtask) {
                $html .= '<div class="data_subtask" data-option-task-id="' . $one_subtask->id . '">
                                            <div class="add_new_sutasck" data-parent-id="' . $one_task->id . '">>></div>
                                            <div class="edit_subtask" id="edit_task-' . $one_subtask->id . '">' . $one_subtask->text . '</div>';

                if ($enable_subtask_delete == '1') {
                    $html .= '<div class="delete_subtask" data-id="' . $one_subtask->id . '" data-parent-id="' . $one_task->id . '"><i class="fa fa-times" aria-hidden="true"></i></div>';
                }
                $html .= '</div>';
            }

            $html .= '
                    </div>
                </div>
             </div>
             ';

            $i++;
                

        }
        $html .= '</div>'
        . ''
                . '<div class="col-3"><div class="form_edit_manager_wrapper1">
                    <form class="form-inline needs-validation" id="uploadLogo" method="POST" enctype="multipart/form-data">
                                                   <div class="form-row form_row_upload_label">
                                                        <label for="dropbox_access_tkn112">' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_SUBMENU_TASKS_IMPORT_USERS_LABEL').'
                                                            <div class="import_loader">
                                                                <i class="fa fa-refresh fa-spin fa-fw"></i>
                                                            </div>
                                                        </label>
                                                    </div>
                                                    <div class="form-row form_row_files">
                                                        <div class="custom-file">
                                                            <input type="file" name="logo" class="required custom-file-input" id="input_upl_csv"  >
                                                            <label class="custom-file-label" for="input_upl_logo" data-browse="+">' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_SUBMENU_TASKS_IMPORT_USERS_INSIDE_LABEL') . '</label>
                                                            <div class="invalid-feedback import_message_wrapper"></div>
                                                            <div class="valid-feedback success_message"></div>
                                                        </div>
                                                    </div>
                                                     
                                                 <button type="submit" class="d-none js_event_upload_xls">submit</button>   
                                            </form>
                                            </div>
                                            <div class="combine_confirm_and_pay_period_wr">
                                                
                                                <div class="filter_state_wrapper last_fltr">
                                                    <div class="one_item_page_rules_item">';
        
                                                    $checkbox_state = $this->getSyncWithMainTasksState();
                                                    
                                                    $checked = '';
                                                    if ($checkbox_state == 1) {
                                                        $checked = 'checked';
                                                    }
                                                    
                                                    $html .= '
                                                        <input type="checkbox" class="custom_checkbox js_event_sync_to_all" '.$checked.' id="sync_to_all_main_tasks">
                                                        <label for="sync_to_all_main_tasks" class="label_rule_item">' . JText::_('COM_AUDIT_TASK_MANAGER_NEW_SUBMENU_TASKS_IMPORT_USERS_CHECKBOX') . '</label>
                                                    </div>
                                                </div>
                                                
                                            </div></div></div>';
        return $html;
    }
    
    public function addOneSubmenuTask(string $lang)
    {
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        $item = new stdClass();
        $item->id = null;
        $item->id_user = $this->user->id;
        $item->text = JText::_('COM_AUDIT_TASK_MANAGER_EMPTY_TASK_TEXT');

        $this->db->insertObject('#__audit_submenu_task_list', $item);
        return $this->db->insertid();
    }
    
    public function deleteSubmenuTask(string $lang, int $task_id)
    {
        $query = "DELETE FROM `#__audit_submenu_task_list` WHERE `id` = '$task_id';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function editSubmenuTask(string $value, string $field_name, int $rule_id, string $lang)
    { 
        
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        $item = new stdClass();
        $item->id = $rule_id;
        $item->id_user = $this->user->id;
        $item->text = $this->db->escape($value);

        $this->db->updateObject('#__audit_submenu_task_list', $item, 'id');
        return $this->db->escape($value);
    }
    
    public function setSubmenuTasksOrdering($data) 
    {
        $ids = explode(',', $data);
        
        $item = new stdClass;
        $i = 1;
        
        foreach ($ids as $id) {
            $curr_id = explode('-', $id)[1];
            
            $item->id = $curr_id;
            $item->ordering = $i;
            $this->db->updateObject('#__audit_submenu_task_list', $item, 'id');
            
            $i++;
        }
    }
    
    public function attachSubmenuTasksToTask(string $lang, int $parent_task_id, string $mode)
    {
        /*$query = "DELETE FROM `#__audit_subtasks_list` WHERE `parent_id` = '$parent_task_id' AND `id_user` = '".$this->user->id."';";
        $this->db->setQuery($query);
        $this->db->query();
        
        $submenu_tasks = json_decode($this->getSubmenuTaskList());//load submenu tasks for current manager
        //$submenu_tasks_ids = array_column($submenu_tasks, 'id');//get array of ids submenu tasks
        
        
        
        foreach($submenu_tasks as $one_submenu_task){
          
            $item = new stdClass();
            $item->id = null;
            $item->id_user = $this->user->id;
            $item->text = strip_tags($this->db->escape($one_submenu_task->text));
            $item->parent_id = $parent_task_id;
        
            $this->db->insertObject('#__audit_subtasks_list', $item);
            
        }*/
        
        if($mode == 'true'){
            $state = 0;
        } else{
            $state = 1;
        }
        $query = "UPDATE `#__audit_task_list` SET `sync_with_submenu`='$state' WHERE `id` = '$parent_task_id' AND `id_user` = '".$this->user->id."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    private function generateRandomString($length = 10) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public function uploadTaskManagerCsv()
    { 
        $user = $this->user;
        $db = $this->db;
        
        jimport('joomla.filesystem.file');
        jimport('joomla.filesystem.folder');
         
        $typeImg = 'logo';

        $file = JRequest::getVar($typeImg, null, 'files', 'array');
        $perm_ext = [
            'xlsx',
            'xlsm'
        ];
        
        if (!empty($file)) {
            $filename = JFile::makeSafe($file['name']);
            $src = $file['tmp_name'];
            $ext = JFile::getExt($filename);
            
            if(!in_array($ext, $perm_ext)){
                throw new Exception(JText::_('COM_AUDIT_NEW_IMPORT_XLS_ERROR_EXTENSION'));
            }
           
            $newFileName = hash('sha1', $this->generateRandomString(5)) . '.' . $ext;
            
            
            $folder = 'tmp_csv_task_manager';
           
            

            if (!JFolder::exists(JPATH_BASE . DS . $folder)) {
                JFolder::create(JPATH_BASE . DS . $folder);
            }
            $dest = JPATH_BASE . DS  .$folder. DS . $newFileName;
            
          
            
            if (JFile::upload($src, $dest)) {
                $this->openExcel($dest);
            }
        }
    }
    
    private function openExcel(string $full_file_path)
    {
        require_once JPATH_LIBRARIES . '/PHPExcel/Classes/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        
        $excel_path = $full_file_path;
        $objPHPExcel = PHPExcel_IOFactory::load($excel_path);

        $sheet = $objPHPExcel->getActiveSheet();
        $rowIterator = $sheet->getRowIterator();

        $count = 0;
        $notice = [];
        $data_for_db = [];
        
        for ($i = 1; $i <= $sheet->getHighestRow(); $i++) {
            $task_name = strip_tags($sheet->getCellByColumnAndRow(0, $i)->getValue());
            $data_for_db[] = $task_name;
          
            //echo $task_name.PHP_EOL;
           
                
        }
        $this->addSubmenuTasksFromFile($data_for_db);
        
        //$new_user_id = $this->addUserFromCsv($data, $manager_id); //add new user, return id
            
        if ($count == 0) {
            $notice = array('No user records. Users exists or incorrect file format.');
        }
        //if(!empty($notice)){
          // $this->setImportMessages($excel_token, $notice);
       // }
        
      
        return $notice;
    }
    
    private function addSubmenuTasksFromFile(array $task_text)
    {
        foreach($task_text as $one_task)
        {
            $item = new stdClass();
            $item->id = null;
            $item->id_user = $this->user->id;
            $item->text = $this->db->escape($one_task);

            $this->db->insertObject('#__audit_submenu_task_list', $item);
           
        }
    }
    
    public function saveSyncToAllMainTasksCheckboxState(string $state)
    {
        $table_name = '#__task_manager_main_tasks_sync_state';
        
        if($state == 'true'){
            $state = 1;
        } else{
            $state = 0;
        }
        
        $query = "SELECT * FROM $table_name WHERE `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $row_count = count($data);
        
        if($row_count == 0){
            $item = new stdClass();
            
            $item->id = null;
            $item->manager_id = $this->user->owner_id;
            $item->state = $state;
            $item->time_create = time();
            $item->date_create = date('d.m.Y H:i:s');
            
            $this->db->insertObject($table_name, $item);
        } elseif($row_count == 1){
            $item = new stdClass();
            
            $item->id = $data[0]->id;
            $item->manager_id = $this->user->owner_id;
            $item->state = $state;
            $item->time_create = time(); 
            $item->date_create = date('d.m.Y H:i:s');
            
            $this->db->updateObject($table_name, $item, 'id');
        } else{
            throw new Exception(JText::_('COM_AUDIT_TASK_MANAGER_NEW_SAVE_SYNC_STATE_ERROR_DB'));
        }
        
        //update main task table
        $query = "UPDATE `#__audit_task_list` SET `sync_with_submenu`='$state' WHERE `id_user` = '".$this->user->id."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getSyncWithMainTasksState()
    {
        $table_name = '#__task_manager_main_tasks_sync_state';
         
        $query = "SELECT * FROM $table_name WHERE `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $state = $data[0]->state;
        if(is_null($state)){
            $state = 0;
        }
        
        return $state;
    }
    
    public function getSyncWithMainTasksStateApi(int $manager_id)
    {
        $table_name = '#__task_manager_main_tasks_sync_state';
         
        $query = "SELECT * FROM $table_name WHERE `manager_id` = '".$manager_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $state = $data[0]->state;
        if(is_null($state)){
            $state = 0;
        }
        
        return $state;
    }
    
    public function getSubmenuTaskListApi(int $manager_id)
    {
        
        $enable_sortable_in_task_manager_and_api = '1';
        if($enable_sortable_in_task_manager_and_api == '1'){
            $order_by='`ordering`';
        } else{
            $order_by='`id` DESC';
        }
        
        $query = "SELECT `id`, `text`, `id_user` FROM #__audit_submenu_task_list WHERE `id_user` = '".$manager_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $final = [];
        $i = 0;
        foreach($data as $one_subtask)
        {
            $final[$i] = $one_subtask;
            $final[$i]->attached_users = '';
            $final[$i]->parent_id = '';
            
            $i++; 
        }
        
        return $final;
    }
    
    public function addDefaultTasks($owner_id = null)
    {
        if(!empty($owner_id)){
            $user_id = $owner_id;
            
           
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('en-GB');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'en-GB';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
            
        
        } else{
            $user_id = $this->user->owner_id;
        }
        
        define('DEFAULT_TASK_LIST',  [
            [
                'text' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEFAULT_TASK_BREAK'),
                'id_user' => $user_id,
            ],
            [
                'text' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEFAULT_TASK_SICK'),
                'id_user' => $user_id,
            ],
            [
                'text' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEFAULT_TASK_SICK_CHILD'),
                'id_user' => $user_id,
            ],
            [
                'text' => JText::_('COM_AUDIT_TASK_MANAGER_NEW_DEFAULT_TASK_AWAY'),
                'id_user' => $user_id,
            ]
        ]);
        
        foreach(DEFAULT_TASK_LIST as $one_task){
            $item = new stdClass();
            $item->id = null;
            $item->text = $one_task['text'];
            $item->id_user = $one_task['id_user'];

            $this->db->insertObject('#__audit_task_list', $item);
        }
    }
    
    private function getUnicontaTaskList()
    {
        JLoader::register('AuditModelUniconta', JPATH_BASE . '/components/com_audit/models/uniconta.php');
        $model = JModelLegacy::getInstance('Uniconta', 'AuditModel');
        
        return $model->loadUnicontaTasks();
    }
    
    private function getSortedUnicontaTaskList()
    {
        $order_by = '`ordering`';

        $query = "SELECT * FROM $this->uniconta_table_name WHERE `id_user` = '".$this->user->owner_id."' ORDER BY $order_by";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return json_encode($data);
    }
    
    private function getUnicontaSubtasks()
    {
        $query = "SELECT * FROM $this->subtask_table_name WHERE `id_user` = '".$this->user->owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    public function getUnicontaSubtasksForApi(int $owner_id)
    {
        $query = "SELECT * FROM $this->subtask_table_name WHERE `id_user` = '".$owner_id."' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    public function loadUnicontaTasks($lang)
    {
        $task_list = json_decode($this->getUnicontaTaskList());
        $sorted_uniconta_task_list = json_decode($this->getSortedUnicontaTaskList());
        $this->user_list = json_decode($this->getPrepareUserListNewPsd());
       
        $count = $i = 0;
        $html = '';

        $config = &JFactory::getConfig();
        $enable_subtask_delete = $config->get('enable_subtask_delete');
        $enable_sortable_in_task_manager_and_api = $config->get('enable_sortable_in_task_manager_and_api');
        $enable_dropbox_api = $config->get('enable_dropbox_api');

        $task_sortable_class = '';
        if ($enable_sortable_in_task_manager_and_api == '1') {
            $task_sortable_class = '';
        }

        if ($lang == 'is') {
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        $subtasks_list = $this->getUnicontaSubtasks();
     
        /*echo '<pre>';
        print_r($subtasks_list);
        echo '</pre>';
        exit;*/
        $html .= '<input type="hidden" class="js_event_active_dk_tasks"/>';
        
        //load Uniconta tasks from DB
            foreach ($sorted_uniconta_task_list as $one_task) {
                /*if(!in_array($one_task->original_id, array_column($task_list, 'Number'))){//this code actualize task list(if delete on DK server-delete here)
                    continue; 
                }*/
                /*if(!empty($one_task->JobStatus) && $one_task->JobStatus != 1){
                    continue;
                }*/
                $html .= '
                <div class="one_item_page_rules ' . $task_sortable_class . ' one_uniconta_task" id="one_task-' . $one_task->id.'-'.$one_task->number0.'" data-dk-task-id="'.$one_task->id.'" data-dk-task-name="'.$one_task->name.'">';
                if ($enable_sortable_in_task_manager_and_api == '1') {
                    $html .= '<div class="move-icon-box"><i class="icon-menu"></i></div>';
                }
                $html .= '<div class="one_item_page_rules_item">
                    <div class="task_icon">' . ++$count . '.
                        <!--i class="fa fa-play" aria-hidden="true"></i-->
                    </div>
                </div> 
                
                <div class="one_item_page_rules_item item_edit_task">
                    <div class="edit_task" id="edit_task-' . $one_task->id . '">' . $one_task->number0 . ' | ' . $one_task->account . ' | ' . $one_task->name . '</div>
                </div>';

            if ($enable_dropbox_api == '1') {
                $html .= '<div class="one_item_page_rules_item item_dropbox_files js_event_open_files_dropbox_for_uniconta" data-task-id="' . $one_task->id . '">
                        <button class="btn btn-outline-info btn-sm" type="button"><i class="fa fa-picture-o" aria-hidden="true"></i>' . JText::_('COM_AUDIT_TASK_MANAGER_DROPBOX_FILES') . '</button>    
                    </div>';
            }

            $html .= '
                <div class="one_item_page_rules_item item_subtasks" data-task_id="' . $one_task->id . '">
                    <!--<img src="/components/com_audit/assets/images/folder-icon.png" alt="" class="toggle_subtask"/>-->
                    <img src="/components/com_audit/assets/images/add-icon.png" alt="" class="toggle_subtask"/>
                </div>
                <div class="one_item_page_rules_item item_user_binding" data-task_id="' . $one_task->id . '">
                    <i class="fa fa-user-circle toggle_attach_task i_toggle_subtask" aria-hidden="true"></i>
                    <div class="attach_task_to_user_wrapper">
                        <div class="data_option_wrapper">
                 ';
            foreach ($this->user_list as $one_user) {
                $task_status = $this->getAttachedUsersToUnicontaTaskStatus($one_user->id, $one_task->id);
                $html .= '<div class="one_option';
                if ($task_status === '1') {
                    $html .= ' selected_option_active';
                }
                $html .= '" data-option-value="' . $one_user->id . '" data-option-task-id="' . $one_task->id . '">
                                    <span>' . $one_user->username0 . '</span>
                                        <i class="fa ';
                if ($task_status === '1') {
                    $html .= 'fa-check-circle-o';
                } else {
                    $html .= 'fa-circle-thin';
                }
                $html .= '" aria-hidden="true"></i>
                                    </div>';
            }
            $html .= '
                        </div>
                    </div>     
                </div>';
          
             $html .= '
               
               <div class="subtask_wrapper">
                    <div class="data_subtasks_wrapper">';

            if (empty($subtasks_list)) {
                //JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT')
                if ($enable_subtask_delete == '1') {
                    $parent_class = 'data_subtask-no_line';
                    $def_text = '';
                    $row_class = 'no-line';
                } else {
                    $def_text = JTEXT::_('COM_AUDIT_TASK_MANAGER_EMPTY_SUBTASK_TEXT');
                    $row_class = '';
                }

               /* $html .= '
                                <div class="data_subtask ' . $parent_class . '">
                                     <div class="add_new_sutasck" data-parent-id="' . $one_task->id . '">>></div>
                                     <div class="edit_subtask new_subtask ' . $row_class . '" id="parent_id-' . $one_task->id . '-new">' . $def_text . '</div>
                                </div>';*/
            }
            foreach ($subtasks_list as $one_subtask) {
                 if($one_subtask->parent_id === $one_task->id){
                $html .= '<div class="data_subtask" data-option-task-id="">
                                            <!--<div class="add_new_sutasck" data-parent-id="">>></div>-->
                                            <div class="edit_subtask" id="edit_task-'.$one_task->id.'">' . $one_subtask->name . '</div>';

                if ($enable_subtask_delete == '1') {
                    //$html .= '<div class="delete_subtask" data-id="' . $one_subtask->id . '" data-parent-id="' . $one_task->id . '"><i class="fa fa-times" aria-hidden="true"></i></div>';
                }
                $html .= '</div>';
                 }
            }

            $html .= '
                    </div>
                </div>
             </div>';

            $i++
        ?>
        <?php

        }
        
        return $html;
    }
    
    private function getAttachedUsersToUnicontaTaskStatus($user_id, $task_id)
    {
        $user=JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM $this->uniconta_table_name WHERE `id_user` = '".$user->owner_id."' AND `id`='".$task_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(in_array($user_id, explode(',', $data->attached_users))){
            return'1';
        } else{
            return '0';
        }
    }
    
    public function updateAttachedUnicontaTask($user_id, $mode, $task_id, $ids_arr) 
    {
        $user = JFactory::getUser($user_id);
        $query = "SELECT `attached_users` FROM $this->uniconta_table_name WHERE `id_user` = '".$user->owner_id."' AND `id`='".$task_id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        switch ($mode) {
            case 'add':
                if (!empty($data->attached_users)) {
                    $attached_users_new = $data->attached_users . ',' . $user_id;
                } else {
                    $attached_users_new = $user_id;
                }


                $item = new stdClass();
                $item->id = $task_id;
                $item->attached_users = $attached_users_new;
                $this->db->updateObject($this->uniconta_table_name, $item, 'id');
                break;
            case 'remove':
                $arr = [];
                $str_arr = explode(',', $data->attached_users);

                foreach ($str_arr as $one_user) {
                    if ($one_user != $user_id) {
                        $arr[] = $one_user;
                    }
                }

                $attached_users_new = implode(',', $arr);

                $item = new stdClass();
                $item->id = $task_id;
                $item->attached_users = $attached_users_new;
                $this->db->updateObject($this->uniconta_table_name, $item, 'id');
                //return $attached_users_new;
                break;
        }
    }
    
    public function setTasksOrderingForUnicontaTasks($data, $tasks_info)
    {
        $ids = explode(',', $data);
        
        $item = new stdClass;
        $i = 1;
        
        foreach ($tasks_info as $id) {
            //$dk_task_info =  explode('-', $id);
            //$curr_id = $dk_task_info[1];
            //$dk_task_name = $dk_task_info[2];
            $curr_id  = $id['task_id'];
            $dk_task_name = $id['task_name'];
            
           // $item->original_id = preg_replace("/[^0-9]/", '', $curr_id);
            $item->ordering = $i;
            $item->name = trim($this->db->escape($dk_task_name));
            $check_existing = $this->checkUnicontaTaskExisting($curr_id);
            if($check_existing !=1){
                $item->id = null;
               
                $item->id_user = $this->user->owner_id;
                $item->number0 = $curr_id;
                $this->db->insertObject($this->uniconta_table_name, $item, 'id');
            } else{
                $item->id = $curr_id;
                $this->db->updateObject($this->uniconta_table_name, $item, 'id');
            }
            
            
            $i++;
        }
    }
    
    private function checkUnicontaTaskExisting($id)
    {
        $query = "SELECT * FROM $this->uniconta_table_name WHERE `id` = '".(int)$id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject()->id;
        
        if(empty($data)){
            return 0;
        } else{
            return 1;
        }
    }
    
    public function deleteCompanyUnicontaTasks()
    {
        $query = "DELETE FROM $this->uniconta_table_name WHERE `id_user` = '".$this->user->owner_id."';";
        $this->db->setQuery($query);
        $this->db->query();
        
        $query = "DELETE FROM $this->subtask_table_name WHERE `id_user` = '".$this->user->owner_id."';";
        $this->db->setQuery($query);
        $this->db->query();
    } 
    
    public function attachTaskToDevicesnTools(string $lang, int $parent_task_id, string $mode)
    {
        if($mode === 'true'){
            $state = 0;
        } else{
            $state = 1;
        }
        $query = "UPDATE `#__audit_task_list` SET `is_for_devices_n_tools` = '$state' WHERE `id` = '$parent_task_id' AND `id_user` = '".$this->user->id."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function loadTaskListForDnT(string $lang, object $user, $user_id = null)
    {
        if($user->id == 0 && $user_id = 'all'){
            $user = $this->user;
        }
        $query = "SELECT * FROM `#__audit_task_list` WHERE `id_user` = '".$user->owner_id."' AND `is_for_devices_n_tools` = '1'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function prepareSelectHtml(array $data)
    {
        
    }
    
    public function storeGpsRadius(string $lang, $radius) {
        //$this->radius_table_name
        $owner_id = $this->user->owner_id;
        
        $query = "SELECT `id` FROM `$this->radius_table_name` WHERE `manager_id` = '$owner_id'";
        $this->db->setQuery($query);
        $id = $this->db->loadResult();
        
        if(empty($id)){
            $item->id = null;
            $item->radius = $radius;
            $item->manager_id = $owner_id;
            $item->created_at = date('Y-m-d H:i:s');
            
            $this->db->insertObject($this->radius_table_name, $item);
        } else{
            $item->id = $id;
            $item->radius = $radius;
            $item->manager_id = $owner_id;
            $item->updated_at = date('Y-m-d H:i:s');
            
            $this->db->updateObject($this->radius_table_name, $item, 'id');
        }
       
    }
    
    public function getRadius() {
        $owner_id = $this->user->owner_id;
        
        $query = "SELECT * FROM `$this->radius_table_name` WHERE `manager_id` = '$owner_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        $data = (empty($data)) ? 50 : $data;
        return $data;
    }
    
    public function setTaskTypeAsGps(string $lang, int $task_id, string $mode) {
        if($mode === 'true'){
            $state = 1;
        } else{
            $state = 0;
        }
        
        $query = "UPDATE " . $this->db->quoteName('#__audit_task_list') . " SET " . $this->db->quoteName('is_gps_task') . " = '$state' WHERE " . $this->db->quoteName('id') . " = '$task_id' AND " . $this->db->quoteName('id_user') . " = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $state;
    }
    
    public function storeGpsTaskPlace(string $lang, int $task_id, string $place, float $lat, float $lng) {
        $coordinates = [
            'lat' => $lat,
            'lng' => $lng
        ];
        $coordinates_json = json_encode($coordinates);
        
        $query = "UPDATE " . $this->db->quoteName('#__audit_task_list') . " SET " . $this->db->quoteName('task_address') . " = '" . $this->db->escape($place) . "', " . $this->db->quoteName('task_coordinates') . " = '$coordinates_json' WHERE " . $this->db->quoteName('id') . " = '$task_id' AND " . $this->db->quoteName('id_user') . " = '" . $this->user->owner_id . "'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getTaskAddressesForMap(string $lang) {
        $query = "SELECT * FROM " . $this->db->quoteName('#__audit_task_list') . " WHERE " . $this->db->quoteName('id_user') . " = '" . $this->db->escape($this->user->owner_id) . "' AND " . $this->db->quoteName('is_gps_task'). " = '1'";
        $this->db->setQuery($query);
        $task_list = $this->db->loadObjectList();
      
        $final_array = [];
        $i = 0;
        foreach($task_list as $one_task){
            $task_coordinates = json_decode($one_task->task_coordinates);
            
                $final_array[strval($i)]['info'] =
                        '<strong>Address:</strong><br/>'
                        . $one_task->task_address . '<br/>'
                       
                ;
                $final_array[strval($i)]['lat' ]    =   $task_coordinates->lat;
                $final_array[strval($i)]['lng']     =  $task_coordinates->lng;
                $final_array[strval($i)]['user_id'] =   $this->user->owner_id;

            $i++;
        }
        
       
        
        foreach ($final_array as $key=>$info) {
            
            $info['userId'] = intval($info['user_id']);
            $info['float_lat'] = floatval($info['lat']);
            $info['float_lng'] = floatval($info['lng']);
            $final_array[$key] = $info;
        }
        
        $groups =  array();
        $final_array_copy   =   (array) $final_array;    
        
        foreach ($final_array as $key1=>$info1) {
            $lat1  = $info1['float_lat'];
            $lng1  = $info1['float_lng'];
            
            foreach ($final_array as $key2=>$info2) {
                //if($key1 == $key2)     continue;
                
                $lat2  = $info2['float_lat'];
                $lng2  = $info2['float_lng'];
                
                $diff1  =  abs( abs($lat1) - abs($lat2) );
                $diff2  =  abs( abs($lng1) - abs($lng2) );
                if($this->range >= $diff1 && $this->range >= $diff2) {
                    $groups[$key1][] = $key2;
                }
            }
        }
        $list  =  array();
        foreach ($groups as $g=>$items) {            
            $nameArr  =  array();
            foreach ($items as $k) {
                if(!isset($final_array[$k]))
                    continue;
                $nameArr[]  = trim(strip_tags($final_array_copy[$k]['info']));
                unset($final_array[$k]);
            }            
            if(empty($nameArr))
                continue;            
            $list[$g] = $final_array_copy[$g];
            $list[$g]['info'] = "<strong>".join("<br>",$nameArr)."</strong>";
            unset($final_array[$g]);
        }
        foreach ($final_array as $k=>$v) {
            $list[$k]   =   $v;
        }
        
        return $list;
    }
    
    public function seAutoClockInTask(string $lang, int $task_id, string $mode) {
        if($mode === 'true'){
            $state = 1;
        } else{
            $state = 0;
        }
        
        $query = "UPDATE " . $this->db->quoteName('#__audit_task_list') . " SET " . $this->db->quoteName('is_auto') . " = '$state' WHERE " . $this->db->quoteName('id') . " = '$task_id' AND " . $this->db->quoteName('id_user') . " = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        $this->db->query();
        
        return $state;
    }
}
