<?php
// No direct access
defined( '_JEXEC' ) or die;

/*
 * https://phppot.com/php/how-to-manage-recurring-payments-using-paypal-subscriptions-in-php/
 * http://paypal.github.io/PayPal-PHP-SDK/sample/#payments
 * https://stackoverflow.com/questions/30958176/paypal-rest-sdk-api-get-token
 */

/*
error_reporting(E_ALL);
ini_set("display_errors", 1);
*/
require_once (JPATH_LIBRARIES."/custom/vendor/autoload.php");
use PayPal\Auth\OAuthTokenCredential;

use PayPal\Api\ChargeModel;
use PayPal\Api\Currency;
use PayPal\Api\MerchantPreferences;
use PayPal\Api\PaymentDefinition;
use PayPal\Api\Plan;
use PayPal\Api\Patch;
use PayPal\Api\PatchRequest;
use PayPal\Common\PayPalModel;
use PayPal\Rest\ApiContext;

use PayPal\Api\Agreement;
use PayPal\Api\Payer;
use PayPal\Api\ShippingAddress;


class AuditModelSubscription2 extends JModelLegacy {
    private $db;
    private $app;
    private $doc;
    private $lang;
    public  $currency  =  "EUR";
    public  $currencyLabel  =  '';
    /**
     *
     * @var PayPal\Rest\ApiContext
     */
    public  $tokenCredential    =  null;
    public  $apiContext         =  null;
    
    
    private $clientId       =   "AYeS_ApE14YcIVJ4kK4Il5LBVeKEAsiUB1ynXwC-JnT4pJ_t8-mZ8RiU7MWWNrrCPAybrbpJnB0qffee";
    private $clientSecret   =   "EC-fWtsOERj2SlDsrfmkjhzx85_NtgE6YiYcgdMlZgFOdUcS4Yx1GhH17Ue0q2EdtP6cAsEUnHDR718f";
    private $testMode       =   true;
    
    protected $table        =   "#__subscription";
    
    public function __construct() { 
        parent::__construct();        
        $this->db   =   JFactory::getDBO();
        $this->app  =   JFactory::getApplication();
        $this->doc  =   JFactory::getDocument();
        $this->lang =   JFactory::getLanguage();
        
        $this->lang->load('com_audit', JPATH_SITE,$this->lang->getTag(),true);
        if($this->testMode) {
            $this->testModeInfo();
        }
        
        $this->tokenCredential = new OAuthTokenCredential(
            $this->clientId,
            $this->clientSecret
        );
        $this->apiContext = new ApiContext($this->tokenCredential);
        
        $sdkConfig = array (
            "mode" => "live"
        );
        if($this->testMode) {
            $sdkConfig['mode']  =   'sandbox';
        }        
        $this->apiContext->setConfig($sdkConfig);
        mt_srand(time());
    }
    
    public function getSettings() {        
        $this->currencyLabel    =   JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_CURRENCY');
        $plan = array();
        $plan['subscr_ct']      =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_CT_CHECKBOX'),'price'=>3.90,'paid'=>false);
        $plan['subscr_kiosk']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_KIOSK_CHECKBOX'),'price'=>2.30,'paid'=>false);
        $plan['subscr_app']     =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_APP_CHECKBOX'),'price'=>1.60,'paid'=>false);
        
        $settings = array('plan'=>$plan);
        $settings['discount']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_DISCOUNT_HEADER'),'price'=>1.60);
        $settings['subscr_users']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_USERS_HEADER'),'price'=>0,'value'=>0);
        $settings['currency']       =   $this->currency;
        $settings['currencyLabel']  =   $this->currencyLabel;
        return $settings;
    }
    
    public function submitSubscription($obj) {    
        $obj->local_id  =   $this->generateId();            
        $obj->plan_id   =   0;
        $obj->create_at =   time();
        $obj->update_at =   time();
        $obj->status    =   0;
        $obj->currency =    $this->currency;
        
        $this->db->insertObject($this->table, $obj,'id');
        $id =   (int)$this->db->insertid();
        if( $id <=0 )
            throw new Exception("Error. Can't save transaction into database.");
        $query = "SELECT *  FROM ".$this->table."  WHERE id = ".$this->db->quote($id);
        $this->db->setQuery($query);
        $localSubscription  =   $this->db->loadObject();
        if(empty($localSubscription)) {
            throw new Exception("Error. Can't load transaction.");
        }
        $createdPlan  = $this->createPlan($localSubscription);
        $id  = $createdPlan->getId();
        if(strlen(trim($id)) > 0) {
            
            $localSubscription->plan_id   =   $id;            
            $this->db->updateObject($this->table,$localSubscription, 'id' );
            return $this->getApprovalLink($createdPlan);
        } else {
            throw new Exception("Can't create subscription plan");
        }
        throw new Exception("Can't create subscription");
    }
    
    
    protected function getApprovalLink($createdPlan) {
        $patch = new Patch();
        $value = new PayPalModel('{"state":"ACTIVE"}');
        $patch->setOp('replace')
            ->setPath('/')
            ->setValue($value);
        $patchRequest = new PatchRequest();
        $patchRequest->addPatch($patch);
        
        
        
        $createdPlan->update($patchRequest,$this->apiContext);
        
        $patchedPlan = Plan::get($createdPlan->getId(),$this->apiContext);
        
        // Create new agreement
        $startDate = date('c', time());
        $agreement = new Agreement();
        $agreement->setName('Subscription Agreement')
        ->setDescription('PHP Tutorial Plan Subscription Billing Agreement')
        ->setStartDate($startDate);

        // Set plan id
        $plan = new Plan();
        $plan->setId($patchedPlan->getId());
        $agreement->setPlan($plan);
/*
        // Add payer type
        $payer = new Payer();
        $payer->setPaymentMethod('paypal');
        $agreement->setPayer($payer);
        
        $shippingAddress = new ShippingAddress();
        $shippingAddress->setLine1('111 First Street');
        //$shippingAddress->setRecipientName('Test');
        $shippingAddress->setCity('Saratoga');
        $shippingAddress->setState('CA');
        $shippingAddress->setPostalCode('95070');
        $shippingAddress->setCountryCode('US');;
        $agreement->setShippingAddress($shippingAddress);
  */      
        // Create agreement
        $agreement = $agreement->create($this->apiContext);
        // Extract approval URL to redirect user
        return $agreement->getApprovalLink();
    }
    
    protected function createPlan($localSubscription) {
        $price          =   $localSubscription->total;
        $description    =   $localSubscription->plan;  //$_SERVER['HTTP_HOST']." : ".$localSubscription->company;
        //$name           =   $localSubscription->plan;
        $name           =   $localSubscription->company." (".$price.")";
        $name           =   $_SERVER['HTTP_HOST'];
        
        $currency       =   $this->currency;
        $parsms  =  array(
            'option'    =>  'com_audit',
            'task'      =>  'subscription.success',
            //'id'        =>  $localSubscription->id
        );
        $successUrl  =  "https://".$_SERVER['HTTP_HOST']."/index.php?".http_build_query($parsms);
        
        $parsms  =  array(
            'option'    =>  'com_audit',
            'task'      =>  'subscription.cancel',
            //'id'        =>  $localSubscription->id
        );
        $cancelUrl  =  "https://".$_SERVER['HTTP_HOST']."/index.php?".http_build_query($parsms);
        
        
        // Create a new instance of Plan object
        $plan = new Plan();
        // # Basic Information
        // Fill up the basic information that is required for the plan
        $plan->setName($name)->setDescription($description)->setType('fixed');

        // # Payment definitions for this billing plan.
        $paymentDefinition = new PaymentDefinition();
        $paymentDefinition->setName('Regular Payments')
            ->setType('REGULAR')
            ->setFrequency('Month')
            ->setFrequencyInterval("1")
            ->setCycles(60)
            ->setAmount(new Currency(array('value' =>$price, 'currency' =>$this->currency)));

        // Charge Models
        $chargeModel = new ChargeModel();
        ///$chargeModel->setType('SHIPPING')->setAmount(new Currency(array('value' => $price, 'currency' => $currency)));
        $chargeModel->setType('SHIPPING')->setAmount(new Currency(array('value' => 0, 'currency' => $this->currency)));
        $paymentDefinition->setChargeModels(array($chargeModel));

        
        
        
        $merchantPreferences = new MerchantPreferences();
        // ReturnURL and CancelURL are not required and used when creating billing agreement with payment_method as "credit_card".
        // However, it is generally a good idea to set these values, in case you plan to create billing agreements which accepts "paypal" as payment_method.
        // This will keep your plan compatible with both the possible scenarios on how it is being used in agreement.
        $merchantPreferences->setReturnUrl($successUrl)
            ->setCancelUrl($cancelUrl)
            ->setAutoBillAmount("yes")
            ->setInitialFailAmountAction("CONTINUE")
            ->setMaxFailAttempts("0")
            ->setSetupFee(new Currency(array('value' => 0, 'currency' => $currency)));


        $plan->setPaymentDefinitions(array($paymentDefinition));
        $plan->setMerchantPreferences($merchantPreferences);
        
        $createdPlan = $plan->create($this->apiContext);
        return $createdPlan;
        /*
        try {
            
            echo "<pre>";
            var_dump($createdPlan->id);exit;
            
        } catch (PayPal\Exception\PayPalConnectionException $ex) {
            echo $ex->getCode();
            echo $ex->getData();
            die($ex);
        } catch (Exception $ex) {
            die($ex);
        }
        */
    }
    
    public function success() {
        echo "<pre>";
        var_dump($_REQUEST);
        echo "</pre>";
        exit;
    }
    
    public function cancel() {
        echo "<pre>";
        var_dump($_REQUEST);
        echo "</pre>";
        exit;
    }
    
    
    public  function generateId() {        
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
          // 32 bits for "time_low"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff),
          // 16 bits for "time_mid"
          mt_rand(0, 0xffff),
          // 16 bits for "time_hi_and_version",
          // four most significant bits holds version number 4
          mt_rand(0, 0x0fff) | 0x4000,
          // 16 bits, 8 bits for "clk_seq_hi_res",
          // 8 bits for "clk_seq_low",
          // two most significant bits holds zero and one for variant DCE1.1
          mt_rand(0, 0x3fff) | 0x8000,
          // 48 bits for "node"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }
    
    
    
    private function testModeInfo() {
        /**
         * 
         * Business
         * 
        */
        //$this->clientId       =   "AZo9lJ7ut0yFtIuqznq8yTuht-utHaXGjOUY4bEi8wGIlXbLvDRWQDezETUrKOAqszrzrSnrEZQxlW07";
        //$this->clientSecret   =   "EFUYuZbXo0hiqS_m7HjA7Y8yvsuzjyGCZhrjUMDBh7zCNThQEGkSPMic96g4LtESUNQMQDn-L61zuhOe";
    }
    
    public function getAccessToken() {
        $sdkConfig = array(
            "mode" => "live"
        );
        
        if($this->testMode) {
            $sdkConfig = array(
                "mode" => "sandbox"
            );
        }
        return $this->tokenCredential->getAccessToken($sdkConfig);
    }
    
}