<?php
// No direct access
defined( '_JEXEC' ) or die;

/**
 * https://github.com/paypal/Checkout-PHP-SDK
 * 
 * https://phppot.com/php/how-to-manage-recurring-payments-using-paypal-subscriptions-in-php/
 * http://paypal.github.io/PayPal-PHP-SDK/sample/#payments
 * https://stackoverflow.com/questions/30958176/paypal-rest-sdk-api-get-token
 */
/*
error_reporting(E_ALL);
ini_set("display_errors", 1);
*/

require_once("paypal/PayPalClient.php");


class AuditModelSubscription extends JModelLegacy {
    private $db;
    private $app;
    private $doc;
    private $lang;
    public  $currency  =  "EUR";
    public  $currencyLabel  =  '';
    /**
     *
     * @var PayPal\Rest\ApiContext
     */
    public  $tokenCredential    =  null;
    public  $apiContext         =  null;
    
    protected $table        =   "#__subscription";
    
    public function __construct() { 
        parent::__construct();        
        $this->db   =   JFactory::getDBO();
        $this->app  =   JFactory::getApplication();
        $this->doc  =   JFactory::getDocument();
        $this->lang =   JFactory::getLanguage();
        
        $this->lang->load('com_audit', JPATH_SITE,$this->lang->getTag(),true);        
        mt_srand(time());
    }
    
    public function getSettings() {        
        $this->currencyLabel    =   JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_CURRENCY');
        $plan = array();
        $plan['subscr_ct']      =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_CT_CHECKBOX'),'price'=>3.90,'paid'=>false);
        $plan['subscr_kiosk']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_KIOSK_CHECKBOX'),'price'=>2.30,'paid'=>false);
        $plan['subscr_app']     =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_APP_CHECKBOX'),'price'=>1.60,'paid'=>false);
        
        

        $settings = array('plan'=>$plan);
        $settings['discount']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_DISCOUNT_HEADER'),'price'=>1.60);
        $settings['subscr_users']   =   array('label'=>JText::_('COM_AUDIT_SETTINGS_NEW_SUBSCR_USERS_HEADER'),'price'=>0,'value'=>0);
        $settings['currency']       =   $this->currency;
        $settings['currencyLabel']  =   $this->currencyLabel;
        
        $localSubscription = $this->loadActiveSubscription();
        if(!empty($localSubscription)) {        
            foreach ($settings['plan'] as $k=>$val) {
                if(intval($localSubscription->$k)) {
                    $settings['plan'][$k]['paid'] = true;
                }
            }
            $settings['subscr_users']['value'] = $localSubscription->subscr_users;
        }
        return $settings;
    }
    
    public function loadActiveSubscription() {
        $user = JFactory::getUser();
        $user_id   =   $user->owner_id;
        $query = "SELECT *  FROM ".$this->table."  WHERE user_id = ".$this->db->quote($user_id)." AND status =1 limit 1";
        $this->db->setQuery($query);
        $localSubscription  =   $this->db->loadObject();
        return $localSubscription;
    }
    
    public function confirmSubscription($id,$subscription_id) {
        
        $client =  new PayPalClient();
        $query = "SELECT *  FROM ".$this->table."  WHERE id = ".$this->db->quote($id);
        $this->db->setQuery($query);
        $localSubscription  =   $this->db->loadObject();
        if(empty($localSubscription)) {
            throw new \Exception("Subscription not fouund.");
        }
        if($localSubscription->subscription_id != $subscription_id) {
            throw new \Exception("Subscription id incorrect.");
        }
        $client->confirmSubscription($localSubscription);
        $this->db->updateObject($this->table,$localSubscription,'id');
        return $localSubscription;
        
    }
    
    public function submitSubscription($obj) {    
        
        
        $obj->local_id  =   $this->generateId();            
        $obj->plan_id   =   0;
        $obj->create_at =   time();
        $obj->update_at =   time();
        $obj->status    =   0;
        $obj->currency =    $this->currency;
        
        $this->db->insertObject($this->table, $obj,'id');
        $id =   (int)$this->db->insertid();
        if( $id <=0 )
            throw new Exception("Error. Can't save transaction into database.");
        $query = "SELECT *  FROM ".$this->table."  WHERE id = ".$this->db->quote($id);
        $this->db->setQuery($query);
        $localSubscription  =   $this->db->loadObject();
        $client =  new PayPalClient();
        $subscription    =    $client->createSubscription($localSubscription);
        if(!empty($subscription)) {
            if($subscription->status == "APPROVAL_PENDING") {
                foreach ($subscription->links as $link) {
                    if($link->rel == "approve") {
                        $localSubscription->approve_link    =   $link->href;
                    }
                }
            }
            $this->db->updateObject($this->table,$localSubscription,'id');
            return $subscription;
        }
        return null;
    }
    
    public  function generateId() {        
        return sprintf('%04x%04x-%04x-%04x-%04x-%04x%04x%04x',
          // 32 bits for "time_low"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff),
          // 16 bits for "time_mid"
          mt_rand(0, 0xffff),
          // 16 bits for "time_hi_and_version",
          // four most significant bits holds version number 4
          mt_rand(0, 0x0fff) | 0x4000,
          // 16 bits, 8 bits for "clk_seq_hi_res",
          // 8 bits for "clk_seq_low",
          // two most significant bits holds zero and one for variant DCE1.1
          mt_rand(0, 0x3fff) | 0x8000,
          // 48 bits for "node"
          mt_rand(0, 0xffff), mt_rand(0, 0xffff), mt_rand(0, 0xffff)
        );
    }    
}