<?php

// No direct access
defined('_JEXEC') or die;

/**

 * @author 

 */
class AuditModelRules extends JModelLegacy {

    public function __construct() {
        parent::__construct();

        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->config = &JFactory::getConfig();
        
        $this->enable_new_style_autocompletion_hours_in_rules = $this->config->get('enable_new_style_autocompletion_hours_in_rules');
        
    }

    public function getTableWithRules() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id_user` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id_user` = '$id_user' ORDER BY `id` ASC";
        }
        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();

        return $data;
    }
    
    public function getTableSpecRules() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__audit_spec_rules WHERE `id_user` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__audit_spec_rules WHERE `id_user` = '$id_user' ORDER BY `id` ASC";
        }
        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();

       

        return $data;
    }
    
    public function getTableRules0() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }

        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__audit_rules0 WHERE `id_user` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__audit_rules0 WHERE `id_user` = '$id_user' ORDER BY `id` ASC";
        }
        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();
        
        return $data;
    }
    
    public function getUnionRulesInCompany($company) {
        $manager_id=$this->getManagerIdInCompany($company);

        $query = "SELECT * FROM #__audit_rules0 WHERE `id_user` = '$manager_id' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }

    private function getManagerIdInCompany($company) {
        $query = "SELECT `id`, `company`, `owner_id` FROM #__users WHERE `company` = '$company'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        $manager_id=$data[0]->owner_id;
        return $manager_id;
    }
    
    public function getBreakArray() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT * FROM #__audit_time_wages WHERE id_user = '$id_user'";

        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return json_encode($data[0]);
    }

    public function addOneRule() {
        $item = new stdClass();
        $item->id_user = $this->user->id;
        $item->date = date('Y-m-d');
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        $this->db->insertObject('#__audit_time_wages_with_rules', $item);
        $id = $this->db->insertid();

        return $id;
    }
    
    public function addOneRule0() {
        $item = new stdClass(); 
        $item->id_user = $this->user->id;
        $item->date = date('Y-m-d');
 
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        
        $this->db->insertObject('#__audit_rules0', $item);
        $id = $this->db->insertid();
        
        return $id;
    }
    
    public function addSpecRule() {
        $item = new stdClass();
        $item->id_user = $this->user->id;
        $item->date = date('Y-m-d');
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        $this->db->insertObject('#__audit_spec_rules', $item);
        $id = $this->db->insertid();

        return $id;
    }

    public function addOneShift() {
        $ids = [];

        $item = new stdClass();
        $item->user_id = $this->user->id;
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        $this->db->insertObject('#__shift_parent', $item);
        $parent_id = $this->db->insertid();

        $day = 1;
        for ($i = 1; $i <= 7; $i++) {
            $item = new stdClass();
            $item->id_user = $this->user->id;
            $item->date = date('Y-m-d');
            $item->parent_id = $parent_id;
            if ($day <= 5) {
                $item->day = $day;
            } elseif ($day == 6) {
                $item->day = 'weekends';
            } else {
                $item->day = 'holidays';
            }

            $this->db->insertObject('#__audit_shifts', $item);
            $id = $this->db->insertid();

            $ids[] = $id;
            $day++;
        }

        $item = new stdClass();
        $item->id = $parent_id;
        $item->child_ids = implode(',', $ids);

        $this->db->updateObject('#__shift_parent', $item, 'id');
        //$id=$this->db->insertid();

        return $parent_id;
    }
    
    public function addOneLoop() {
        $ids = [];

        $item = new stdClass();
        $item->user_id = $this->user->id;
        $item->loop_start_date=date('d.m.Y');
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        $this->db->insertObject('#__loop_parent', $item);
        $parent_id = $this->db->insertid();

        $day = 1;
        for ($i = 1; $i <= 7; $i++) {
            $item = new stdClass();
            $item->id_user = $this->user->id;
            $item->date = date('Y-m-d');
            $item->parent_id = $parent_id;
            
            $item->week=1;
            
            if ($day <= 5) {
                $item->day = $day;
            } elseif ($day == 6) {
                $item->day = 'weekends';
            } else {
                $item->day = 'holidays';
            }

            $this->db->insertObject('#__audit_loops', $item);
            $id = $this->db->insertid();

            $ids[] = $id;
            $day++;
        }
        
        $day = 1;
        for ($i = 1; $i <= 7; $i++) {
            $item = new stdClass();
            $item->id_user = $this->user->id;
            $item->date = date('Y-m-d');
            $item->parent_id = $parent_id;
            $item->week=2;
            
            if ($day <= 5) {
                $item->day = $day;
            } elseif ($day == 6) {
                $item->day = 'weekends';
            } else {
                $item->day = 'holidays';
            }

            $this->db->insertObject('#__audit_loops', $item);
            $id = $this->db->insertid();

            $ids[] = $id;
            $day++;
        }

        $item = new stdClass();
        $item->id = $parent_id;
        $item->child_ids = implode(',', $ids);

        $this->db->updateObject('#__loop_parent', $item, 'id');
        //$id=$this->db->insertid();

        return $parent_id;
    }

    public function checkRuleID($rule_id) {
        $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id_user` = '" . $this->user->id . "' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }
    
    public function checkRule0ID($rule_id) {
        $query = "SELECT * FROM #__audit_rules0 WHERE `id_user` = '" . $this->user->id . "' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }
    
    public function checkSpecRuleID($rule_id) {
        $query = "SELECT * FROM #__audit_spec_rules WHERE `id_user` = '" . $this->user->id . "' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }

    public function checkShiftID($shift_id) {
        $query = "SELECT * FROM #__shift_parent WHERE `user_id` = '" . $this->user->id . "' AND `id`='$shift_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
      
        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }
    
    public function checkLoopID($loop_id) {
        $query = "SELECT * FROM #__loop_parent WHERE `user_id` = '" . $this->user->id . "' AND `id`='$loop_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
     
        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }
    
    public function checkLoop4ID($loop_id) {
        $query = "SELECT * FROM #__loop4_parent WHERE `user_id` = '" . $this->user->id . "' AND `id`='$loop_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
     
        if (!empty($data[0])) {
            return '1';
        } else {
            return '0';
        }
    }
    
    public function getOneRule($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }
    
    public function getOneRule0($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_rules0 WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }
    
    public function getOneSpecRule($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_spec_rules WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }

    public function getOneShift($shift_id) {
        $final_array = [];
        $shift_id = (int) $shift_id;
        $query = "SELECT * FROM #__shift_parent WHERE `id`='$shift_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        $query = "SELECT * FROM #__audit_shifts WHERE `parent_id`='$shift_id' AND `id_user`='" . $this->user->id . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $childern = $this->db->loadObjectList();

        $final_array = [
            'parent_row' => $data,
            'child_rows' => $childern
        ];

        return (object) $final_array;
    }
    
    public function getOneLoop($loop_id) {
        $final_array = [];
        $loop_id = (int) $loop_id;
        $query = "SELECT * FROM #__loop_parent WHERE `id`='$loop_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        $query = "SELECT * FROM #__audit_loops WHERE `parent_id`='$loop_id' AND `id_user`='" . $this->user->id . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $childern = $this->db->loadObjectList();
        
        /*$query = "SELECT * FROM #__audit_loops WHERE `parent_id`='$loop_id' AND `id_user`='" . $this->user->id . "' AND `day`='weekends' ORDER BY `day` ASC";
        $this->db->setQuery($query);
        $weekends = $this->db->loadObjectList();
        
        array_push($childern, $weekends);
        
        $query = "SELECT * FROM #__audit_loops WHERE `parent_id`='$loop_id' AND `id_user`='" . $this->user->id . "' AND `day`='holidays' ORDER BY `day` ASC";
        $this->db->setQuery($query);
        $holidays = $this->db->loadObjectList();
        
        array_push($childern, $holidays);*/

        $final_array = [
            'parent_row' => $data,
            'child_rows' => $childern
        ];

        return (object) $final_array;
    }

    public function getToBreakInfo($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_time_wages_with_rules WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id,
            'sql'=>$query
        ];

        return json_encode($output);
    }
    
    public function getToBreakInfoRulesNew($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_rules0 WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id,
            'sql'=>$query
        ];

        return json_encode($output);
    }
    
    public function getToBreakInfoSpec($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_spec_rules WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id,
            'sql'=>$query
        ];

        return json_encode($output);
    }

    public function getToBreakInfoShifts($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_shifts WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id
        ];

        return json_encode($output);
    }
    
    public function getToBreakInfoLoop($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_loops WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id
        ];

        return json_encode($output);
    }

    private function deleteUnionRuleAddons($parent_id)
    {
        $parent_id=(int)$parent_id;
        
        if(!empty($parent_id)){
            $query = "DELETE FROM #__subrules_holidays WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            $query = "DELETE FROM #__subrules_minutes WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            $query = "DELETE FROM #__subrules_sick_child WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            $query = "DELETE FROM #__union_overworks WHERE `parent_rule` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
        }
        
    }
    
    private function deleteShiftAddons($parent_id)
    {
        $parent_id=(int)$parent_id;
        
        if(!empty($parent_id)){
            $query = "DELETE FROM #__subrules_holidays_week WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            $query = "DELETE FROM #__subrules_for_earning_week WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            $query = "DELETE FROM #__subrules_sick_child_week WHERE `parent_rule_id` = '$parent_id';";
            $this->db->setQuery($query);
            $this->db->query();
            
            
        }
        
    }
    
    public function deleteRule($row_id, $mode) {
        //here
        $mode = explode('-', $mode);
        $mode0 = $mode[0];

        switch ($mode0) {
            case 'rule_list_item':
                $query = "DELETE FROM `#__audit_time_wages_with_rules` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                $this->resetUsersRules($row_id, 'rule_list_item');
                break;
            case 'rule_list_item0':
                $query = "DELETE FROM `#__audit_rules0` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                $this->resetUsersRules($row_id, 'rule_list_item0');
                $this->deleteUnionRuleAddons($row_id);
                break;
            case 'shift_list_item':
                $query1 = "DELETE FROM `#__audit_shifts` WHERE `parent_id` = '$row_id';";
                $this->db->setQuery($query1);
                $this->db->query();


                $query = "DELETE FROM `#__shift_parent` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                
                $this->resetUsersRules($row_id, 'shift_list_item');
                $this->deleteShiftAddons($row_id);
                break;
            case 'loop_list_item':
                $query1 = "DELETE FROM `#__audit_loops` WHERE `parent_id` = '$row_id';";
                $this->db->setQuery($query1);
                $this->db->query();


                $query = "DELETE FROM `#__loop_parent` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                $this->resetUsersRules($row_id, 'loop_list_item');
                break;
            case 'loop4_list_item':
                $query1 = "DELETE FROM `#__audit_loops4` WHERE `parent_id` = '$row_id';";
                $this->db->setQuery($query1);
                $this->db->query();


                $query = "DELETE FROM `#__loop4_parent` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                $this->resetUsersRules($row_id, 'loop4_list_item');
                break;
            case 'spec_rule_list_item':
                $query = "DELETE FROM `#__audit_spec_rules` WHERE `id` = '$row_id';";
                $this->db->setQuery($query);
                $this->db->query();
                
                $this->resetUsersRules($row_id, 'spec_rule_list_item');
                break;
        }
        
        
        
        //file_put_contents(JPATH_BASE .DS.'delete_rules_log.txt', '\n'.$query1, FILE_APPEND | LOCK_EX);
        
    }
    
    private function resetUsersRules($row_id, $mode){
        $cell='';
        
        switch ($mode) {
            case 'rule_list_item':
                $cell='rule_number';

                break;
            case 'rule_list_item0':
                $cell='rule_number0';

                break;
            case 'shift_list_item':
                $cell='shift_number';
                
                break;
            case 'loop_list_item':
                $cell='loop_number';
                
                break;
            case 'loop4_list_item':
                $cell='loop4_number';
                
                break;
            case 'spec_rule_list_item':
                $cell='spec_number';
                
                break;
        }
        
        if(!empty($cell)){
            $query = "UPDATE #__users SET $cell='0' WHERE `owner_id`='".$this->user->owner_id."' AND $cell='".$row_id."'";
            $this->db->setQuery($query);
            $this->db->query();
        }
        
       
        
        //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/upd_total.html', print_r($query1, true), FILE_APPEND | LOCK_EX); 
    }

    public function setHtml($rules_array, $mode, $lang) {

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        switch ($mode) {
            case 'rules':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="rule_list_item-' . $one_rule->id . '">
                                <label for="rule_list_item-' . $one_rule->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_RULE_WORD') . ' <span class="js_recount_rules">' . $i . '</span></label>
                            </div>     
                            <div class="one_item_page_rules_item item_edit_rule">
                                <img src="/components/com_audit/assets/images/edit_rule_small.svg" alt="" data-rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
            case 'rules0':
                $html = '';
                $i = 1;

                if($lang==='is'){
                    $this->lang->setLanguage('is-IS');
                    $this->lang->load();
                    $extension = 'com_audit';
                    $base_dir = JPATH_SITE;
                    $language_tag = 'is-IS';
                    $reload = true;
                    $this->lang->load($extension, $base_dir, $language_tag, $reload);
                }
                
                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete0">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="rule_list_item0-' . $one_rule->id . '">
                                <label for="rule_list_item0-' . $one_rule->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_UNION_RULE') . '<span class="js_recount_rules0">' . $i . '</span></label>
                            </div>     
                            <div class="one_item_page_rules_item item_edit_rule0" data-rule-id="'.$one_rule->id.'">
                                <img src="/components/com_audit/assets/images/yellow.png" alt="" data-rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
            case 'shifts':
                $html = '';
                $ia = 1;

                foreach ($rules_array as $one_shift) {
                    $html .= '
                        <div class="one_item_page_rules shift_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="shift_list_item-' . $one_shift->id . '">
                                <label for="shift_list_item-' . $one_shift->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_SHIFT_WORD') . ' <span class="js_recount_shifts">' . $ia . '</span></label>
                            </div>     
                            <div class="one_item_page_rules_item item_edit_shift">
                                <img src="/components/com_audit/assets/images/edit_shift_small.svg" alt="" data-shift-id="' . $one_shift->id . '"/>
                            </div>
                        </div>
                    ';
                    $ia++;
                }
                break;
            case 'loops':
                $html = '';
                $ib = 1;

                foreach ($rules_array as $one_loop) {
                    $html .= '
                        <div class="one_item_page_rules loop_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="loop_list_item-' . $one_loop->id . '">
                                <label for="loop_list_item-' . $one_loop->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_LOOP_WORD') . ' <span class="js_recount_loops">' . $ib . '</span></label>
                            </div>     
                            <div class="one_item_page_rules_item item_edit_loop">
                                <img src="/components/com_audit/assets/images/edit_loop_small.svg" alt="" data-loop-id="' . $one_loop->id . '"/>
                            </div>
                        </div>
                    ';
                    $ib++;
                }
                break;
            case 'spec':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="spec_rule_list_item-' . $one_rule->id . '">
                                <label for="spec_rule_list_item-' . $one_rule->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_SPEC_RULE_WORD') . ' <span class="js_recount_spec_rules">' . $i . '</span></label>
                            </div>     
                            <div class="one_item_page_rules_item item_edit_spec_rule">
                                <img src="/components/com_audit/assets/images/edit_spec_small.svg" alt="" data-spec_rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
        }




        return $html;
    }

    public function setHtmlWithEditableRulesHeaderTopLevel($rules_array, $mode, $lang) {

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        switch ($mode) {
            case 'rules':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="rule_list_item-' . $one_rule->id . '">
                                <label for="rule_list_item-' . $one_rule->id . '"></label>';
                                $html.='<span id="standart_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_RULE_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_rules">&nbsp;' . $i . '</span>';
                                    $html .=  '<span class="js_recount_rules"> ' . $i . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_rule">
                                <img src="/components/com_audit/assets/images/edit_rule_small.svg" alt="" data-rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
            case 'rules0':
                $html = '';
                $i = 1;

                if($lang==='is'){
                    $this->lang->setLanguage('is-IS');
                    $this->lang->load();
                    $extension = 'com_audit';
                    $base_dir = JPATH_SITE;
                    $language_tag = 'is-IS';
                    $reload = true;
                    $this->lang->load($extension, $base_dir, $language_tag, $reload);
                }
                
                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete0">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="rule_list_item0-' . $one_rule->id . '">
                                <label for="rule_list_item0-' . $one_rule->id . '"></label>';
                                $html.='<span id="union_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_UNION_RULE');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                   // $html .=  '<span class="js_recount_rules0">&nbsp;' . $i . '</span>';
                                    $html .=  '<span class="js_recount_rules0"> ' . $i . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_rule0" data-rule-id="'.$one_rule->id.'">
                                <img src="/components/com_audit/assets/images/yellow.png" alt="" data-rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
                
            case 'shifts':
                $html = '';
                $ia = 1;

                foreach ($rules_array as $one_shift) {
                    $html .= '
                        <div class="one_item_page_rules shift_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="shift_list_item-' . $one_shift->id . '">
                                <!--<label for="shift_list_item-' . $one_shift->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_SHIFT_WORD') . ' <span class="js_recount_shifts">' . $ia . '</span></label>-->
                                    
                                <label for="shift_list_item-' . $one_shift->id . '"></label>';
                                $html.='<span id="shift_rule_editable-'.$one_shift->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_shift->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_SHIFT_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_shifts">&nbsp;' . $ia . '</span>';
                                    $html .=  '<span class="js_recount_shifts"> ' . $ia . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_shift">
                                <img src="/components/com_audit/assets/images/edit_shift_small.svg" alt="" data-shift-id="' . $one_shift->id . '"/>
                            </div>
                        </div>
                    ';
                    $ia++;
                }
                break;
            case 'loops':
                $html = '';
                $ib = 1;

                foreach ($rules_array as $one_loop) {
                    $html .= '
                        <div class="one_item_page_rules loop_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="loop_list_item-' . $one_loop->id . '">
                                <!--<label for="loop_list_item-' . $one_loop->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_LOOP_WORD') . ' <span class="js_recount_loops">' . $ib . '</span></label>-->
                                    
                                <label for="loop_list_item-' . $one_loop->id . '"></label>';
                                $html.='<span id="loop_rule_editable-'.$one_loop->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_loop->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_LOOP_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_loops">&nbsp;' . $ib . '</span>';
                                    $html .=  '<span class="js_recount_loops">' . $ib . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_loop">
                                <img src="/components/com_audit/assets/images/edit_loop_small.svg" alt="" data-loop-id="' . $one_loop->id . '"/>
                            </div>
                        </div>
                    ';
                    $ib++;
                }
                break;
            case 'loops4':
                $html = '';
                $ic = 1;

                foreach ($rules_array as $one_loop) {
                    $html .= '
                        <div class="one_item_page_rules loop4_after_reload">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="loop4_list_item-' . $one_loop->id . '">
                                               
                                <label for="loop4_list_item-' . $one_loop->id . '"></label>';
                                $html.='<span id="loop4_rule_editable-'.$one_loop->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_loop->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_LOOP_4');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_loops4">&nbsp;' . $ic . '</span>';
                                    $html .=  '<span class="js_recount_loops4"> ' . $ic . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_loop4" data-loop4-id="' . $one_loop->id . '">
                                <img src="/components/com_audit/assets/images/edit_loop_small.svg" alt="" data-loop4-id="' . $one_loop->id . '"/>
                            </div>
                        </div>
                    ';
                    $ic++;
                }
                break;
            case 'spec':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item">
                                <input type="checkbox" class="custom_checkbox" id="spec_rule_list_item-' . $one_rule->id . '">
                                <!--<label for="spec_rule_list_item-' . $one_rule->id . '" class="label_rule_item">' . JText::_('COM_AUDIT_RULES_SPEC_RULE_WORD') . ' <span class="js_recount_spec_rules">' . $i . '</span></label>-->
                                
                                <label for="spec_rule_list_item-' .$one_rule->id . '"></label>';
                                $html.='<span id="monthly_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_SPEC_RULE_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_spec_rules">&nbsp;' . $i . '</span>';
                                    $html .=  '<span class="js_recount_spec_rules"> ' . $i . '</span>';
                                }
                                $html.='
                            </div>     
                            <div class="one_item_page_rules_item item_edit_spec_rule">
                                <img src="/components/com_audit/assets/images/edit_spec_small.svg" alt="" data-spec_rule-id="' . $one_rule->id . '"/>
                            </div>
                        </div>
                    ';
                    $i++;
                }
                break;
        }




        return $html;
    }
    
    public function setHtmlWithEditableRulesHeaderTopLevelNewPsd($rules_array, $mode, $lang) {

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        switch ($mode) {
            case 'rules':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item item_edit_rule">
                                <!--<img src="/components/com_audit/assets/images/edit_rule_small.svg" alt="" data-rule-id="' . $one_rule->id . '"/>-->
                                <i class="fa fa-caret-down" aria-hidden="true" data-rule-id="'.$one_rule->id.'"></i>
                            </div>
                            <div class="one_item_page_rules_item">';
                                $html .= '<span id="standart_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_RULE_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html .= '</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_rules">&nbsp;' . $i . '</span>';
                                    $html .=  '<span class="js_recount_rules"> ' . $i . '</span>';
                                }
                                $html .= '<input type="checkbox" class="custom_checkbox" id="rule_list_item-' . $one_rule->id . '">
                                <label for="rule_list_item-' . $one_rule->id . '"></label>
                            </div>     
                            
                        </div>
                    ';
                    $i++;
                }
                break;
            case 'rules0':
                $html = '';
                $i = 1;

                if($lang==='is'){
                    $this->lang->setLanguage('is-IS');
                    $this->lang->load();
                    $extension = 'com_audit';
                    $base_dir = JPATH_SITE;
                    $language_tag = 'is-IS';
                    $reload = true;
                    $this->lang->load($extension, $base_dir, $language_tag, $reload);
                }
                
                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete0">
                            <div class="one_item_page_rules_item item_edit_rule0" data-rule-id="'.$one_rule->id.'">
                                <i class="fa fa-caret-down" aria-hidden="true" data-rule-id="'.$one_rule->id.'"></i>
                            </div>
                            <div class="one_item_page_rules_item">';
                                $html .= '<span id="union_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_UNION_RULE');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html .= '</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_rules0">&nbsp;' . $i . '</span>';
                                    $html .=  '<span class="js_recount_rules0"> ' . $i . '</span>';
                                }
                                $html .= '<input type="checkbox" class="custom_checkbox" id="rule_list_item0-' . $one_rule->id . '">
                                <label for="rule_list_item0-' . $one_rule->id . '"></label>
                            </div>     
                            
                        </div>
                    ';
                    $i++;
                }
                break;
                
            case 'shifts':
                $html = '';
                $ia = 1;

                foreach ($rules_array as $one_shift) {
                    $html .= '
                        <div class="one_item_page_rules shift_after_delete">
                            <div class="one_item_page_rules_item item_edit_shift">
                                <!--<img src="/components/com_audit/assets/images/edit_shift_small.svg" alt="" data-shift-id="' . $one_shift->id . '"/>-->
                                <i class="fa fa-caret-down" aria-hidden="true" data-shift-id="'.$one_shift->id.'"></i>
                            </div>
                            <div class="one_item_page_rules_item">';
                                $html.='<span id="shift_rule_editable-'.$one_shift->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_shift->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_SHIFT_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_shifts">&nbsp;' . $ia . '</span>';
                                    $html .=  '<span class="js_recount_shifts"> ' . $ia . '</span>';
                                }
                                $html.='<input type="checkbox" class="custom_checkbox" id="shift_list_item-' . $one_shift->id . '">
                                <label for="shift_list_item-' . $one_shift->id . '"></label>
                            </div>     
                        </div>
                    ';
                    $ia++;
                }
                break;
            case 'loops':
                $html = '';
                $ib = 1;

                foreach ($rules_array as $one_loop) {
                    $html .= '
                        <div class="one_item_page_rules loop_after_delete">
                            <div class="one_item_page_rules_item item_edit_loop">
                                <!--<img src="/components/com_audit/assets/images/edit_loop_small.svg" alt="" data-loop-id="' . $one_loop->id . '"/>-->
                                <i class="fa fa-caret-down" aria-hidden="true" data-loop-id="'.$one_loop->id.'"></i>
                            </div>
                            <div class="one_item_page_rules_item">';
                                $html.='<span id="loop_rule_editable-'.$one_loop->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_loop->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_LOOP_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html.='</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_loops">&nbsp;' . $ib . '</span>';
                                    $html .=  '<span class="js_recount_loops"> ' . $ib . '</span>';
                                }
                                $html.='<input type="checkbox" class="custom_checkbox" id="loop_list_item-' . $one_loop->id . '">       
                                <label for="loop_list_item-' . $one_loop->id . '"></label>
                            </div>     
                           
                        </div>
                    ';
                    $ib++;
                }
                break;
            case 'loops4':
                $html = '';
                $ic = 1;

                foreach ($rules_array as $one_loop) {
                    $html .= '
                        <div class="one_item_page_rules loop4_after_reload">
                            <div class="one_item_page_rules_item item_edit_loop4" data-loop4-id="' . $one_loop->id . '">
                                <!--<img src="/components/com_audit/assets/images/edit_loop_small.svg" alt="" data-loop4-id="' . $one_loop->id . '"/>-->
                                <i class="fa fa-caret-down" aria-hidden="true" data-loop4-id="'.$one_loop->id.'"></i>    
                            </div>
                            <div class="one_item_page_rules_item">';
                                $html .= '<span id="loop4_rule_editable-'.$one_loop->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_loop->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_LOOP_4');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html .= '</span>';
                                
                                if(empty($rule_name)){
                                    //$html .=  '<span class="js_recount_loops4">&nbsp;' . $ic . '</span>';
                                    $html .=  '<span class="js_recount_loops4"> ' . $ic . '</span>';
                                }
                                $html .= '<input type="checkbox" class="custom_checkbox" id="loop4_list_item-' . $one_loop->id . '">                                         
                                <label for="loop4_list_item-' . $one_loop->id . '"></label>
                            </div>     
                            
                        </div>
                    ';
                    $ic++;
                }
            break;
            case 'spec':
                $html = '';
                $i = 1;

                foreach ($rules_array as $one_rule) {
                    $html .= '
                        <div class="one_item_page_rules rule_after_delete">
                            <div class="one_item_page_rules_item item_edit_spec_rule">
                                <!--<img src="/components/com_audit/assets/images/edit_spec_small.svg" alt="" data-spec_rule-id="' . $one_rule->id . '"/>-->
                                <i class="fa fa-caret-down" aria-hidden="true" data-spec_rule-id="'.$one_rule->id.'"></i>
                            </div>
                            <div class="one_item_page_rules_item">
                                ';
                                $html .= '<span id="monthly_rule_editable-'.$one_rule->id.'" class="label_rule_item editable_rule_header">';
                                    $rule_name=$one_rule->rule_name;
                                    if(empty($rule_name)){
                                        $html .= JText::_('COM_AUDIT_RULES_SPEC_RULE_WORD');
                                    } else{
                                        $html .= $rule_name;
                                    }      
                                $html .= '</span>';
                                
                                if(empty($rule_name)){
                                    //$html .= '<span class="js_recount_spec_rules">&nbsp;' . $i . '</span>';
                                    $html .= '<span class="js_recount_spec_rules"> ' . $i . '</span>';
                                }
                                $html .= '<input type="checkbox" class="custom_checkbox" id="spec_rule_list_item-' . $one_rule->id . '">
                                <label for="spec_rule_list_item-' .$one_rule->id . '"></label>
                            </div>        
                        </div>
                    ';
                    $i++;
                }
                break;
        }

        return $html;
    }
    
    public function editBreakTimeWithRules($input) {
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_time_wages_with_rules SET $field='$valueField' WHERE `id`='$id'";
        $this->db->setQuery($query);

        //return $query;
        if ($this->db->query()) {
            return $valueField;
        }
    }
    
    public function editBreakTimeWithRules0($input) {
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        $final_value=$this->autocompletion($valueField);
        
        $query = "UPDATE #__audit_rules0 SET $field='$final_value' WHERE `id`='$id'";
        $this->db->setQuery($query);

        //return $query;
        if ($this->db->query()) {
            return $final_value;
        }
    }
    
    
    public function editBreakTimeSpec($input) {
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }//
        
        $query = "UPDATE #__audit_spec_rules SET $field='$valueField' WHERE `id`='$id'";
        $this->db->setQuery($query);

        //return $query;
        if ($this->db->query()) {
            return $valueField;
        }
    }

    public function editBreakTimeWithShifts($input) {
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_shifts SET $field='$valueField' WHERE `id`='$id'";
        $this->db->setQuery($query);

        //return $query;
        if ($this->db->query()) {
            return $valueField;
        }
    }
    
    public function editBreakTimeWithLoops($input) {
        //$this->addLogString($input, 'global_log.txt');
        
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_loops SET $field='$valueField' WHERE `id`='$id'";
        $this->db->setQuery($query);

        //return $query;
        if ($this->db->query()) {
            return $valueField;
        }
    }

    public function updateTableWithRules() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_time_wages_with_rules SET $field='$valueField' WHERE `id`='$id'";
        $db->setQuery($query);
        if ($db->query()) {
            echo $valueField;
        }
    }
    
    public function updateTableWithRules0() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        
        $permitted_fields_with_3 = [
            'daytime_limit',
            //'aw_limit'
        ];
        if (in_array($field, $permitted_fields_with_3)) {
            $final_value = $this->autocompletionWithPattern($valueField);
        } else {
            $final_value = $this->autocompletion($valueField);
        }

        //$reg=preg_match('/^(\d{3}):(\d{2})$/', $valueField);

        $query = "UPDATE #__audit_rules0 SET $field = '" . $db->escape($final_value) . "' WHERE `id`=' $id '";
        $db->setQuery($query);
        
        if ($db->query()) {
            define('UNION_RULE_ID', $id);

            if($this->enable_new_style_autocompletion_hours_in_rules && UNION_RULE_ID > 0){
                $query = "SELECT * FROM #__audit_rules0 WHERE `id`='" . UNION_RULE_ID . "' AND `id_user`='" . $this->user->id . "'";
                $this->db->setQuery($query);
                $union_rule = $this->db->loadObjectList()[0];
            
                if($field === 'day_time_end' && !empty($union_rule->day_time_start) && empty($union_rule->after_hours_start)){
                    $query = "UPDATE #__audit_rules0 SET `after_hours_start` = '" . $db->escape($final_value) . "', `after_hours_end` = '23:59', `night_time_start` = '00:00', `night_time_end`= '" . $db->escape($union_rule->day_time_start) . "' WHERE `id`='" . UNION_RULE_ID . "'";
                    $db->setQuery($query);
                    $db->query();
                }
                
                /*if($field === 'day_time_end' && empty($union_rule->after_hours_start)){        
                    $query = "UPDATE #__audit_rules0 SET `after_hours_start` = '" . $db->escape($final_value) . "' WHERE `id`='" . UNION_RULE_ID . "'";
                    $db->setQuery($query);
                    $db->query();
                } if($field === 'after_hours_end' && empty($union_rule->night_time_start)){        
                    $query = "UPDATE #__audit_rules0 SET `night_time_start` = '" . $db->escape($final_value) . "' WHERE `id`='" . UNION_RULE_ID . "'";
                    $db->setQuery($query);
                    $db->query();
                } if($field === 'night_time_start' && !empty($union_rule->day_time_start) && empty($union_rule->night_time_end)){        
                    $query = "UPDATE #__audit_rules0 SET `night_time_end` = '" . $db->escape($union_rule->day_time_start) . "' WHERE `id`='" . UNION_RULE_ID . "'";
                    $db->setQuery($query);
                    $db->query();
                }*/
            }
        
            echo $final_value;
        }
    }

    public function autocompletionWithPattern($valueField)
    {
        //echo strlen($valueField).'<br/>';
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                /*echo '<pre>';
                print_r($valueField0);
                echo '</pre>';*/
                $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                /*echo '<pre>';
                print_r($valueField0);
                echo '</pre>';*/
                $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':00';
                break;
            case 5:
                $valueField0=str_split($valueField, 1);
                /*echo '<pre>';
                print_r($valueField0);
                echo '</pre>';*/
                $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':0'.$valueField0[4];
                break;
        }
        
        return $valueField;
    }
    
    public function updateTableSpecRules() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];
        $mode=$_REQUEST['mode00'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        if($mode!='extra'){
            switch(strlen($valueField)){
                case 0:
                
                break;
                case 1:
                    $valueField='0'.$valueField.':00';
                break;
                case 2:
                    $valueField0=str_split($valueField, 1);
                
                    if($valueField0[0]=='0'){
                        $valueField='0'.$valueField0[1].':00';
                    } else{
                        $valueField=$valueField0[0].$valueField0[1].':00';
                    }
                break;
                case 3:
                    $valueField0=str_split($valueField, 1);
                    $valueField=$valueField0[0].$valueField0[1].':00';
                break;
                case 4:
                    $valueField0=str_split($valueField, 1);
                
                    $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
            }
        } else{
            //for monthly limit autocomplete
            switch(strlen($valueField)){
                case 0:
                    //save empty value
                break;
                case 1:
                    //1=>''-lock in browser js
                    $valueField='';
                break;
                case 2:
                    //17=>''-lock in browser js
                   $valueField='';
                break;
                case 3:
                    //173=>'173:00'
                    $valueField0=str_split($valueField, 1);
                    $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':00';
                break;
                case 4:
                    //173:=>'173:00'
                    $valueField0=str_split($valueField, 1);
                    $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':00';
                break;
                case 5:
                    //173:1=>'173:10'
                    $valueField0=str_split($valueField, 1);
                    $valueField=$valueField0[0].$valueField0[1].$valueField0[2].':'.$valueField0[4].'0';
                break;
            }
        }
        
        $query = "UPDATE #__audit_spec_rules SET $field='$valueField' WHERE `id`='$id'";
        $db->setQuery($query);
        if ($db->query()) {
            echo $valueField;
        }
    }

    public function updateTableWithShifts() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_shifts SET $field='$valueField' WHERE `id`='$id'";
        $db->setQuery($query);
        if ($db->query()) {
            echo $valueField;
        }
    }
    
    public function updateTableWithLoops() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        $query = "UPDATE #__audit_loops SET $field='$valueField' WHERE `id`='$id'";
        $db->setQuery($query);
        if ($db->query()) {
            echo $valueField;
        }
    }

    public function getSelectedRuleNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->rule_number;
        if ($user_rule_number == 0) {
            //$user_rule_number = 1;
            $mode = 1;
        }

        return json_encode([
            'rule_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function getSelectedSpecNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->spec_number;
        if ($user_rule_number == 0) {
            //$user_rule_number = 1;
            $mode = 1;
        }

        return json_encode([
            'spec_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }

    public function getTableShifts() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }

        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__shift_parent WHERE `user_id` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__shift_parent WHERE `user_id` = '$id_user' ORDER BY `id` ASC";
        }
        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();



        return $data;
    }
    
    public function getTableLoops() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__loop_parent WHERE `user_id` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__loop_parent WHERE `user_id` = '$id_user' ORDER BY `id` ASC";
        }

        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();



        return $data;
    }

    public function getSelectedShiftNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->shift_number;

        if ($user_rule_number == 0) {
            //$user_rule_number=1;
            $mode = 1;
        }

        return json_encode([
            'shift_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function getSelectedLoopNumber($user_id) {
        //here
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->loop_number;

        if ($user_rule_number == 0) {
            //$user_rule_number=1;
            $mode = 1;
        }

        return json_encode([
            'loop_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }

    public function setRuleNumber($rule_number, $user_id) {
        /*echo '<pre>';
        print_r(func_get_args());
        echo '</pre>';*/
        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);
        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `rule_number`='$rule_number' WHERE `id`='$user_id'";
            $this->db->setQuery($query);
            //echo $query;
            return $this->db->query();
        } else {
            return 'error';
        }
    }
    
    public function setRuleNumberInHome($rule_number, $user_id) 
    {
        $this->clearItems($user_id); 
        
        $query = "UPDATE #__users SET `rule_number`='$rule_number' WHERE `id`='$user_id'";
        $this->db->setQuery($query);          
        $this->db->query();
    }

    public function setSpecNumberInHome($rule_number, $user_id) 
    {
        $this->clearItems($user_id);
      
        $query = "UPDATE #__users SET `spec_number`='$rule_number' WHERE `id`='$user_id'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function setSpecNumber($rule_number, $user_id) {
        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);
        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `spec_number`='$rule_number' WHERE `id`='$user_id'";
            $this->db->setQuery($query);
            return $this->db->query();
        } else {
            return 'error';
        }
    }

    public function setShiftNumber($rule_number, $user_id) {

        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);

        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `shift_number`='$rule_number' WHERE `id`='$user_id'";

            //file_put_contents(JPATH_BASE . DS . 'delete_rules_log.txt', print_r($query . '\n', true), FILE_APPEND | LOCK_EX);
            $this->db->setQuery($query);
            return $this->db->query();
        } else {
            return 'error';
        }
    }
    
    public function setShiftNumberInHome($rule_number, $user_id) 
    {

        $this->clearItems($user_id);

        $query = "UPDATE #__users SET `shift_number`='$rule_number' WHERE `id`='$user_id'"; 
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function setLoopNumber($rule_number, $user_id) {

        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);

        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `loop_number`='$rule_number' WHERE `id`='$user_id'";

            $this->db->setQuery($query);
            return $this->db->query();
        } else {
            return 'error';
        }
    }
    
    public function setLoopNumberInHome($rule_number, $user_id) 
    {

        $this->clearItems($user_id);
       
        $query = "UPDATE #__users SET `loop_number`='$rule_number' WHERE `id`='$user_id'";
        $this->db->setQuery($query);
        $this->db->query(); 
    }

    public function clearItems($user_id) {
        $query = "UPDATE #__users SET `rule_number`='0', `shift_number`='0', `loop_number`='0', `spec_number`='0', `rule_number0`='0', `loop4_number`='0' WHERE `id`='$user_id'";
        $this->db->setQuery($query);
        return $this->db->query();
    }

    public function getDay($number, $lang) {
        if ($lang === 'is') {
            $arr = [
                1 => 'Mánudagur',
                2 => 'Þriðjudagur',
                3 => 'Miðvikudagur',
                4 => 'Fimmtudag',
                5 => 'Föstudagur',
                'weekends' => 'Helgi',
                'holidays' => 'Frídagar'
            ];
        } else {
            $arr = [
                1 => 'Monday',
                2 => 'Tuesday',
                3 => 'Wednesday',
                4 => 'Thursday',
                5 => 'Friday',
                'weekends' => 'Weekends',
                'holidays' => 'Holidays'
            ];
        }

        return $arr[$number];
    }
    
    
    
    public function getTimeWagesInfo($user_id, $lang, $day, $date, $is_confirm)
    {
        $args = func_get_args();
        $user_id =  $args[0];
        $lang = $args[1];
        $day = $args[2];
        $date = $args[3];
        $is_confirm = $args[4];
        
        $user_id=(int)$user_id;
        
        if($is_confirm=='1'){
            $user_from_request=JFactory::getUser($user_id);
            $owner_id_custom=$user_from_request->owner_id;
        
            $selected_rule=json_decode($this->getSelectedRuleNumber($user_id))->rule_number;
            $selected_shift=json_decode($this->getSelectedShiftNumber($user_id))->shift_number;
            $selected_loop=json_decode($this->getSelectedLoopNumber($user_id))->loop_number;
            $selected_spec=json_decode($this->getSelectedSpecNumber($user_id))->spec_number;
            $selected_union=json_decode($this->getSelectedUnionNumber($user_id))->rule_number0;
            $selected_loop4=json_decode($this->getSelectedLoop4Number($user_id))->loop4_number;
        }  else{
            $selected_rule=json_decode($this->getSelectedRuleNumber($user_id))->rule_number;
            $selected_shift=json_decode($this->getSelectedShiftNumber($user_id))->shift_number;
            $selected_loop=json_decode($this->getSelectedLoopNumber($user_id))->loop_number;
            $selected_spec=json_decode($this->getSelectedSpecNumber($user_id))->spec_number;
            $selected_union=json_decode($this->getSelectedUnionNumber($user_id))->rule_number0;
            $selected_loop4=json_decode($this->getSelectedLoop4Number($user_id))->loop4_number;
            
            $user_from_request=JFactory::getUser($user_id);
            $owner_id_custom=$user_from_request->owner_id;
        }
        //$user_from_request=JFactory::getUser($user_id);
        //$owner_id_custom=$user_from_request->owner_id;
            
        if($selected_rule==='0' && $selected_shift==='0' && $selected_loop==='0' && $selected_spec==='0' && $selected_union==='0' && $selected_loop4==='0'){
            $mode='default';//of settings page
                 
            $query_h = "SELECT * FROM #__audit_time_wages WHERE id_user = '$owner_id_custom'";
            $this->db->setQuery( $query_h );
            $audit_time_wages = $this->db->loadObjectList(); 
            
            
            
            //default values, if page settings empty
            if (empty($audit_time_wages[0]->day_time)) {
                $audit_time_wages[0]->day_time = $this->getDefaultTimeWagesValues('day_time_start');
            } if (empty($audit_time_wages[0]->after_hours)) {
                $audit_time_wages[0]->after_hours = $this->getDefaultTimeWagesValues('after_hours_start');
            } if (empty($audit_time_wages[0]->overtime_work)) {
                $audit_time_wages[0]->overtime_work = $this->getDefaultTimeWagesValues('overtime_work_start');
            } if (empty($audit_time_wages[0]->public_holidays)) {
                $audit_time_wages[0]->public_holidays = $this->getDefaultTimeWagesValues('public_holidays_start');
            } if (empty($audit_time_wages[0]->night_time)) {
                $audit_time_wages[0]->night_time = $this->getDefaultTimeWagesValues('night_time_start');
            } if (empty($audit_time_wages[0]->extra_hours)) {
                $audit_time_wages[0]->extra_hours = $this->getDefaultTimeWagesValues('extra_hours');
            }

            if (empty($audit_time_wages[1]->day_time)) {
                $audit_time_wages[1]->day_time = $this->getDefaultTimeWagesValues('day_time_end');
            } if (empty($audit_time_wages[1]->after_hours)) {
                $audit_time_wages[1]->after_hours = $this->getDefaultTimeWagesValues('after_hours_end');
            } if (empty($audit_time_wages[1]->overtime_work)) {
                $audit_time_wages[1]->overtime_work = $this->getDefaultTimeWagesValues('overtime_work_end');
            } if (empty($audit_time_wages[1]->public_holidays)) {
                $audit_time_wages[1]->public_holidays = $this->getDefaultTimeWagesValues('public_holidays_end');
            } if (empty($audit_time_wages[1]->night_time)) {
                $audit_time_wages[1]->night_time = $this->getDefaultTimeWagesValues('night_time_end');
            } if (empty($audit_time_wages[1]->extra_hours)) {
                $audit_time_wages[1]->extra_hours = $this->getDefaultTimeWagesValues('extra_hours');
            }

        } elseif($selected_rule!=='0'){
            $mode='rule';
            $rule_id=$user_from_request->rule_number;
            //here8
            try{
                $audit_time_wages=$this->getSelectedRuleObj($rule_id);
                //$audit_time_wages='test';
                //$this->addLogString($audit_time_wages, 'global_log.txt');
                
                $query_h = "SELECT * FROM #__audit_time_wages WHERE `id_user` = '$owner_id_custom'";
                $this->db->setQuery( $query_h );
                $audit_time_wages_settings = $this->db->loadObjectList(); 
                
                //if db value in table rules is empty
                if(empty($audit_time_wages->day_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time)) {
                        $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                    } else{
                        $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time;
                    }
                  
                } //if db value rule is empty
                if(empty($audit_time_wages->day_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->day_time)) {
                        $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                    } else{
                        $audit_time_wages->day_time_end=$audit_time_wages_settings[1]->day_time;
                    }
                  
                }
                if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[0]->extra_hours;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours)) {
                        $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                    } else{
                        $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->after_hours)) {
                        $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                    } else{
                        $audit_time_wages->after_hours_end=$audit_time_wages_settings[1]->after_hours;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time)) {
                        $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                    } else{
                        $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->night_time)) {
                        $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                    } else{
                        $audit_time_wages->night_time_end=$audit_time_wages_settings[1]->night_time;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work)) {
                        $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                    } else{
                        $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->overtime_work)) {
                        $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                    } else{
                        $audit_time_wages->overtime_work_end=$audit_time_wages_settings[1]->overtime_work;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays)) {
                        $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                    } else{
                        $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->public_holidays)) {
                        $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                    } else{
                        $audit_time_wages->public_holidays_end=$audit_time_wages_settings[1]->public_holidays;
                    }
                  
                }
   
            } catch (Exception $ex) {
                $this->addLogString($ex, 'global_log.txt');
            }
 
        } elseif($selected_shift!=='0'){
            $mode='shift';         
            //$day=date('N');
            //$day=6;
            $shift_id=$user_from_request->shift_number;                        
            //$dayDate_h = date('Y-m-d');
            $dayDate_h=$date;
            
            //check public holidays
            $query_h = "SELECT title, CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop
                    FROM #__holiday WHERE date = '". $dayDate_h."' AND published = '1' AND language = 'all'";
            $this->db->setQuery( $query_h );
            $holiday_h1 = $this->db->loadObject();           
            //$this->addLogString($holiday_h1, 'global_log.txt');
                    
           
            if($date===date('Y-m-d', strtotime($holiday_h1->start))){
               //is holiday
                $day='holidays';
            }

            $compare_array=[
                1=>1,
                2=>2,
                3=>3,
                4=>4,
                5=>5,
                6=>'weekends',
                7=>'weekends',
                'holidays'=>'holidays'
            ];
            $current_day=$compare_array[$day];

            $query = "SELECT * FROM #__audit_shifts WHERE `parent_id`='$shift_id' AND `id_user`='" . $owner_id_custom . "' AND `day`='$current_day' ORDER BY `day` ASC";
            $this->db->setQuery($query);
            $audit_time_wages = $this->db->loadObject();           
            //$this->addLogString($audit_time_wages, 'global_log.txt');
            //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_union.html', print_r($audit_time_wages, true), FILE_APPEND | LOCK_EX);
             
            //if db value rule is empty
            if(empty($audit_time_wages->day_time_start)){       
                //check settings page value
                if (empty($audit_time_wages_settings[0]->day_time)) {
                    $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                } else{
                    $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time;
                }   
            } //if db value rule is empty
            if(empty($audit_time_wages->day_time_end)){       
                //check settings page value
                if (empty($audit_time_wages_settings[1]->day_time)) {
                    $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                } else{
                    $audit_time_wages->day_time_end=$audit_time_wages_settings[1]->day_time;
                }       
            }
           if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[1]->extra_hours;
                    }
                  
            }
            
           
            if(empty($audit_time_wages->after_hours_start)){       
                //check settings page value
                if (empty($audit_time_wages_settings[0]->after_hours)) {
                    $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                } else{
                    $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours;
                }         
            }
            if(empty($audit_time_wages->after_hours_end)){       
                //check settings page value
                if (empty($audit_time_wages_settings[1]->after_hours)) {
                    $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                } else{
                    $audit_time_wages->after_hours_end=$audit_time_wages_settings[1]->after_hours;
                }   
            }
            if(empty($audit_time_wages->night_time_start)){       
                //check settings page value
                if (empty($audit_time_wages_settings[0]->night_time)) {
                    $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                } else{
                    $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time;
                }    
            }
            if(empty($audit_time_wages->night_time_end)){       
                //check settings page value
                if (empty($audit_time_wages_settings[1]->night_time)) {
                    $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                } else{
                    $audit_time_wages->night_time_end=$audit_time_wages_settings[1]->night_time;
                }      
            }
            if(empty($audit_time_wages->overtime_work_start)){       
                //check settings page value
                if (empty($audit_time_wages_settings[0]->overtime_work)) {
                   $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                } else{
                    $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work;
                }   
            }
            if(empty($audit_time_wages->overtime_work_end)){       
                //check settings page value
                if (empty($audit_time_wages_settings[1]->overtime_work)) {
                    $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                } else{
                    $audit_time_wages->overtime_work_end=$audit_time_wages_settings[1]->overtime_work;
                }  
            }
            if(empty($audit_time_wages->public_holidays_start)){       
                //check settings page value
                if (empty($audit_time_wages_settings[0]->public_holidays)) {
                   $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                } else{
                    $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays;
                } 
            }
            if(empty($audit_time_wages->public_holidays_end)){       
                //check settings page value
                if (empty($audit_time_wages_settings[1]->public_holidays)) {
                   $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                } else{
                    $audit_time_wages->public_holidays_end=$audit_time_wages_settings[1]->public_holidays;
                }   
            }
        } elseif($selected_loop!=='0'){
            $mode='loop';         
            $loop_id=$user_from_request->loop_number; 
            
            $query = "SELECT * FROM #__loop_parent WHERE `id`='$loop_id'";
            $this->db->setQuery($query);
            $loop = $this->db->loadObject();
            
            $loop_start_date_obj=DateTime::createFromFormat('d.m.Y', $loop->loop_start_date);
            $loop_start_date=$loop_start_date_obj->format('U');
                       
            if(!empty($date)){                
                $date_from_pay_period_obj=DateTime::createFromFormat('Y-m-d', $date);
                $date_from_pay_period=$date_from_pay_period_obj->format('U');
                $log_file_name='loop_less_mode_log.txt';
               
                //if date from pay period < date loop start
                if($date_from_pay_period < $loop_start_date){                 
                    $this->addLogString('$loop_start_date='.date('d-m-Y', $loop_start_date).' $date_from_pay_period='.date('d-m-Y', $date_from_pay_period).', mode = <<', $log_file_name);

                    $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                    $count_day=$interval->d; // count days
                    $count_day=(int)$count_day;
                    
                    ///tests:////////////////////////////////////////////////////////////////// 
                    //$count_day=21; 
                    $count_day_test_array=[
                        1,2,3,4,5,6,7,//week 1
                        8,9,10,11,12,13,14,//week 2
                        15,16,17,18,19,20,21,//week 1
                        22,23,24,25,26,27,28,//week 2
                        29,30,31,32,33,34,35,//week 1
                        36,37,38,39,40,41,42//week 2   
                    ];
                   /* foreach($count_day_test_array as $count_day){
                        $this->addLogString('count_day='.$count_day, $log_file_name);
                                
                        if($count_day%14!=0 && $count_day%14<=7){
                            $week=1;
                        } elseif($count_day%14<14 && $count_day%14>7){
                            $week=2;
                        } else{
                            $week=2;
                        }
                        
                        $this->addLogString('$week='.$week, $log_file_name);
                    }*/
                    ///end tests//////////////////////////////////////////////////////////////
                    
                    $this->addLogString('count_day='.$count_day, $log_file_name);
                                
                    /*if($count_day>=1 && $count_day<=7){
                        $week=1;
                       
                    } elseif($count_day>7 && $count_day<=14){
                        $week=2;
                        $this->addLogString('$week='.$week, $log_file_name);
                    } elseif($count_day>14 && $count_day<=21){
                        $week=1;
                        $this->addLogString('$week='.$week, $log_file_name);
                    } elseif($count_day>21 && $count_day<=28){
                        $week=2;
                        $this->addLogString('$week='.$week, $log_file_name);
                    } elseif($count_day>28 && $count_day<=35){
                        $week=1;
                        $this->addLogString('$week='.$week, $log_file_name);
                    }elseif($count_day>7){
                        if($count_day%14==0){
                            $week=2;
                        } elseif($count_day%14>0){
                            $week=1;
                        } else{
                            $week=2;
                        }
                    }*/

                    //$interval->y; // count years
                    //$interval->h; // count hours
                    //$interval->i; // count minutes
                    
                    if($count_day%14!=0 && $count_day%14<=7){
                        $week=1;
                    } elseif($count_day%14<14 && $count_day%14>7){
                        $week=2;
                    } else{
                        $week=2;
                    }
                    
                    //$this->addLogString($holiday_h1, 'global_log.txt');
                    //file_put_contents(JPATH_BASE.DS.'logs/global_log.txt', print_r($holiday_h1.PHP_EOL, true), FILE_APPEND | LOCK_EX);    
                } elseif($date_from_pay_period == $loop_start_date){    
                    //$log_file_name='loop_equal_mode_log.txt';
                    $this->addLogString('$loop_start_date='.date('d-m-Y', $loop_start_date).' $date_from_pay_period='.date('d-m-Y', $date_from_pay_period).', mode ====', $log_file_name);
                    $week=1;  
                } elseif($date_from_pay_period > $loop_start_date){
                    //$log_file_name='loop_equal_mode_log.txt';
                    $this->addLogString('$loop_start_date='.date('d-m-Y', $loop_start_date).' $date_from_pay_period='.date('d-m-Y', $date_from_pay_period).', mode >>', $log_file_name);
                    
                    $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                    $count_day=$interval->d; // count days
                    $count_day=(int)$count_day;
                    
                    ///tests:////////////////////////////////////////////////////////////////// 
                    //$count_day=21; 
                    $count_day_test_array=[
                        1,2,3,4,5,6,7,//week 1
                        8,9,10,11,12,13,14,//week 2
                        15,16,17,18,19,20,21,//week 1
                        22,23,24,25,26,27,28,//week 2
                        29,30,31,32,33,34,35,//week 1
                        36,37,38,39,40,41,42//week 2   
                    ];
                   /* foreach($count_day_test_array as $count_day){
                        $this->addLogString('count_day='.$count_day, $log_file_name);
                                
                        if($count_day%14!=0 && $count_day%14<=7){
                            $week=1;
                        } elseif($count_day%14<14 && $count_day%14>7){
                            $week=2;
                        } else{
                            $week=2;
                        }
                        
                        $this->addLogString('$week='.$week, $log_file_name);
                    }*/
                    ///end tests//////////////////////////////////////////////////////////////
                    if($count_day%14!=0 && $count_day%14<=7){
                        $week=1;
                    } elseif($count_day%14<14 && $count_day%14>7){
                        $week=2;
                    } else{
                        $week=2;
                    }
                    
                    $this->addLogString('count_day='.$count_day, $log_file_name);
                }
                
                $dayDate_h=$date;
                
                //check holidays
                $query_h = "SELECT title, CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop
                    FROM #__holiday WHERE date = '". $dayDate_h."' AND published = '1' AND language = 'all'";
                $this->db->setQuery( $query_h );
                $holiday_h1 = $this->db->loadObject();   
                
                if ($this->db->getErrorNum()) {  
                    file_put_contents(JPATH_BASE.DS.'logs/global_log.txt', print_r($this->db->getErrorMsg(), true), FILE_APPEND | LOCK_EX); 
                    //return false;  
                } else{
                   // file_put_contents(JPATH_BASE.DS.'logs/global_log.txt', print_r($holiday_h1, true), FILE_APPEND | LOCK_EX); 
                }
                
                if($date===date('Y-m-d', strtotime($holiday_h1->start))){
                    //is holiday
                    $day='holidays';
                }

                $compare_array=[
                    1=>1,
                    2=>2,
                    3=>3,
                    4=>4,
                    5=>5,
                    6=>'weekends',
                    7=>'weekends',
                    'holidays'=>'holidays'
                ];
                $current_day=$compare_array[$day];
                
                //get loop values
                $query = "SELECT * FROM #__audit_loops WHERE `parent_id`='$loop_id' AND `id_user`='" . $owner_id_custom . "' AND `day`='$current_day' AND `week`='$week' ORDER BY `day` ASC";
                $this->db->setQuery($query);
                $audit_time_wages = $this->db->loadObject();
                file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_union.html', print_r($audit_time_wages, true), FILE_APPEND | LOCK_EX);
                //get default values
                $query_h = "SELECT * FROM #__audit_time_wages WHERE `id_user` = '$owner_id_custom'";
                $this->db->setQuery( $query_h );
                $audit_time_wages_settings = $this->db->loadObjectList(); 
                
                //if db value rule is empty
                if(empty($audit_time_wages->day_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time)) {
                        $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                    } else{
                        $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time;
                    }   
                } //if db value rule is empty
                if(empty($audit_time_wages->day_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->day_time)) {
                        $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                    } else{
                        $audit_time_wages->day_time_end=$audit_time_wages_settings[1]->day_time;
                    }       
                }
                if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[0]->extra_hours;
                    }
                  
                }
               
                if(empty($audit_time_wages->after_hours_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours)) {
                        $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                    } else{
                        $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours;
                    }         
                }
                if(empty($audit_time_wages->after_hours_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->after_hours)) {
                        $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                    } else{
                        $audit_time_wages->after_hours_end=$audit_time_wages_settings[1]->after_hours;
                    }   
                }
                if(empty($audit_time_wages->night_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time)) {
                        $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                    } else{
                        $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time;
                    }        
                }
                if(empty($audit_time_wages->night_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->night_time)) {
                        $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                    } else{
                        $audit_time_wages->night_time_end=$audit_time_wages_settings[1]->night_time;
                    }      
                }
                if(empty($audit_time_wages->overtime_work_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work)) {
                        $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                    } else{
                        $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work;
                    }   
                }
                if(empty($audit_time_wages->overtime_work_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->overtime_work)) {
                        $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                    } else{
                        $audit_time_wages->overtime_work_end=$audit_time_wages_settings[1]->overtime_work;
                    }  
                }
                if(empty($audit_time_wages->public_holidays_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays)) {
                        $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                    } else{
                        $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays;
                    } 
                }
                if(empty($audit_time_wages->public_holidays_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->public_holidays)) {
                        $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                    } else{
                        $audit_time_wages->public_holidays_end=$audit_time_wages_settings[1]->public_holidays;
                    }   
                }
            } 
        } elseif($selected_loop4!=='0'){//here14
            $mode='loop4';         
            $loop_id=$user_from_request->loop4_number; 
            
            $query = "SELECT * FROM #__loop4_parent WHERE `id`='$loop_id'";
            $this->db->setQuery($query);
            $loop = $this->db->loadObject();
            /*echo '<pre>';
            print_r($user_from_request);
            echo '</pre>';
            exit;*/
            
            $loop_start_date_obj=DateTime::createFromFormat('d.m.Y', $loop->loop_start_date);
            
            $loop_start_date=$loop_start_date_obj->format('U');
          
            if(!empty($date)){                
                $date_from_pay_period_obj=DateTime::createFromFormat('Y-m-d', $date);
                
                $date_from_pay_period=$date_from_pay_period_obj->format('U');
              
               
                //if date from pay period < date loop start
                if($date_from_pay_period < $loop_start_date){                 
                   
                    $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format 

                    $count_day=$interval->days; // count days
                    $count_day=(int)$count_day;
                    
                    if ($interval->invert == 1) {
     
                        //echo 'invert mode';

                        if ($count_day % 28 > 0 && $count_day % 28 < 7) {
                            $week = 4;
                        } elseif ($count_day % 28 >= 7 && $count_day % 28 < 14) {
                            $week = 3;
                        } elseif ($count_day % 28 >= 14 && $count_day % 28 < 21) {
                            $week = 2;
                        } elseif ($count_day % 28 == 0) {
                            $week = 1;
                        } else {
                            $week = 1;
                        }
                    } else {
                        $loop_start_date_obj->modify('-1 day');
                        $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format 

                        $count_day=$interval->days; // count days
                        $count_day=(int)$count_day;
                        /* echo '<pre>';
                          print_r($interval);
                          echo '</pre>'; */

                        $count_day = $interval->days; // count days

                        if ($count_day % 28 > 0 && $count_day % 28 < 7) {
                            $week = 1;
                        } elseif ($count_day % 28 >= 7 && $count_day % 28 < 14) {
                            $week = 2;
                        } elseif ($count_day % 28 >= 14 && $count_day % 28 < 21) {
                            $week = 3;
                        } elseif ($count_day % 28 == 0) {
                            $week = 4;
                        } else {
                            $week = 4;
                        }
                    }
                } elseif($date_from_pay_period == $loop_start_date){ 
                    $week=1;  
                } elseif ($date_from_pay_period > $loop_start_date) {
                    //echo $loop_start_date_obj->format('d.m.Y').' == '.$date_from_pay_period_obj->format('d.m.Y');
                    $loop_start_date_obj->modify('-1 day');
                    $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format 

                    $count_day=$interval->days; // count days
                    $count_day=(int)$count_day;

                    if ($count_day % 28 > 0 && $count_day % 28 < 7) {
                        $week = 1;
                    } elseif ($count_day % 28 >= 7 && $count_day % 28 < 14) {
                        $week = 2;
                    } elseif ($count_day % 28 >= 14 && $count_day % 28 < 21) {
                        $week = 3;
                    } elseif ($count_day % 28 == 0) {
                        $week = 4;
                    } else {
                        $week = 4;
                    }
                }


                // echo '$week=' . $week . ' date='.$date_from_pay_period_obj->format('d.m.Y').'<br/>';

                $dayDate_h=$date;
                
                //check holidays
                $query_h = "SELECT title, CONCAT_WS(' ', date, start_time) start, CONCAT_WS(' ', date2, end_time) stop
                    FROM #__holiday WHERE date = '". $dayDate_h."' AND published = '1' AND language = 'all'";
                $this->db->setQuery( $query_h );
                $holiday_h1 = $this->db->loadObject();   
                
                if ($this->db->getErrorNum()) {  
                    file_put_contents(JPATH_BASE.DS.'logs/global_log.txt', print_r($this->db->getErrorMsg(), true), FILE_APPEND | LOCK_EX); 
                    //return false;  
                } else{
                   // file_put_contents(JPATH_BASE.DS.'logs/global_log.txt', print_r($holiday_h1, true), FILE_APPEND | LOCK_EX); 
                }
                
                if($date===date('Y-m-d', strtotime($holiday_h1->start))){
                    //is holiday
                    $day='holidays';
                }

                $compare_array=[
                    1=>1,
                    2=>2,
                    3=>3,
                    4=>4,
                    5=>5,
                    6=>'weekends',
                    7=>'weekends',
                    'holidays'=>'holidays'
                ];
                $current_day=$compare_array[$day];
                
                //get loop values
                $query = "SELECT * FROM #__audit_loops4 WHERE `parent_id`='$loop_id' AND `id_user`='" . $owner_id_custom . "' AND `day`='$current_day' AND `week`='$week' ORDER BY `day` ASC";
                $this->db->setQuery($query);
                $audit_time_wages = $this->db->loadObject();

                //get default values
                $query_h = "SELECT * FROM #__audit_time_wages WHERE `id_user` = '$owner_id_custom'";
                $this->db->setQuery( $query_h );
                $audit_time_wages_settings = $this->db->loadObjectList(); 
                
                //if db value rule is empty
                if(empty($audit_time_wages->day_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time)) {
                        $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                    } else{
                        $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time;
                    }   
                } //if db value rule is empty
                if(empty($audit_time_wages->day_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->day_time)) {
                        $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                    } else{
                        $audit_time_wages->day_time_end=$audit_time_wages_settings[1]->day_time;
                    }       
                }
                if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[0]->extra_hours;
                    }
                  
                }
               
                if(empty($audit_time_wages->after_hours_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours)) {
                        $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                    } else{
                        $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours;
                    }         
                }
                if(empty($audit_time_wages->after_hours_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->after_hours)) {
                        $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                    } else{
                        $audit_time_wages->after_hours_end=$audit_time_wages_settings[1]->after_hours;
                    }   
                }
                if(empty($audit_time_wages->night_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time)) {
                        $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                    } else{
                        $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time;
                    }        
                }
                if(empty($audit_time_wages->night_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->night_time)) {
                        $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                    } else{
                        $audit_time_wages->night_time_end=$audit_time_wages_settings[1]->night_time;
                    }      
                }
                if(empty($audit_time_wages->overtime_work_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work)) {
                        $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                    } else{
                        $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work;
                    }   
                }
                if(empty($audit_time_wages->overtime_work_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->overtime_work)) {
                        $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                    } else{
                        $audit_time_wages->overtime_work_end=$audit_time_wages_settings[1]->overtime_work;
                    }  
                }
                if(empty($audit_time_wages->public_holidays_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays)) {
                        $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                    } else{
                        $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays;
                    } 
                }
                if(empty($audit_time_wages->public_holidays_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->public_holidays)) {
                        $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                    } else{
                        $audit_time_wages->public_holidays_end=$audit_time_wages_settings[1]->public_holidays;
                    }   
                }
            } 
        } //end loop4
        elseif($selected_spec!=='0'){
            $mode='spec';
            $rule_id=$user_from_request->spec_number;
            
            try{
                //here
                $audit_time_wages=$this->getSelectedSpecObj($rule_id);
               
                
                $query_h = "SELECT * FROM #__audit_time_wages WHERE `id_user` = '$owner_id_custom'";
                $this->db->setQuery( $query_h );
                $audit_time_wages_settings = $this->db->loadObjectList(); 
                
                //if db value rule is empty
                if(empty($audit_time_wages->day_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time)) {
                        $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                    } else{
                        $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time;
                    }
                  
                } //if db value rule is empty
                if(empty($audit_time_wages->day_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->day_time)) {
                        $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                    } else{
                        $audit_time_wages->day_time_end=$audit_time_wages_settings[1]->day_time;
                    }
                  
                }
                if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[0]->extra_hours;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours)) {
                        $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                    } else{
                        $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->after_hours)) {
                        $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                    } else{
                        $audit_time_wages->after_hours_end=$audit_time_wages_settings[1]->after_hours;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time)) {
                        $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                    } else{
                        $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->night_time)) {
                        $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                    } else{
                        $audit_time_wages->night_time_end=$audit_time_wages_settings[1]->night_time;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work)) {
                        $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                    } else{
                        $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->overtime_work)) {
                        $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                    } else{
                        $audit_time_wages->overtime_work_end=$audit_time_wages_settings[1]->overtime_work;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays)) {
                        $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                    } else{
                        $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[1]->public_holidays)) {
                        $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                    } else{
                        $audit_time_wages->public_holidays_end=$audit_time_wages_settings[1]->public_holidays;
                    }
                  
                }
   
            } catch (Exception $ex) {
                $this->addLogString($ex->getMessage(), 'global_log.txt');
            }
 
        } elseif($selected_union!=='0'){
            $mode='union';
            $rule_id=$user_from_request->rule_number0;
            
            try{
                //here8
                $audit_time_wages=$this->getSelectedUnionObj($rule_id);
                //$audit_time_wages='test';
                //$this->addLogString($audit_time_wages, 'global_log.txt');
                
               $query_h = "SELECT * FROM #__audit_time_wages WHERE `id_user` = '$owner_id_custom'";
                $this->db->setQuery( $query_h );
                $audit_time_wages_settings = $this->db->loadObjectList(); 
               
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_union.html', print_r($audit_time_wages_settings, true), FILE_APPEND | LOCK_EX);
                
                //if db value rule is empty
                if(empty($audit_time_wages->day_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time_start)) {
                        $audit_time_wages->day_time_start = $this->getDefaultTimeWagesValues('day_time_start'); 
                    } else{
                        $audit_time_wages->day_time_start=$audit_time_wages_settings[0]->day_time_start;
                    }
                  
                } //if db value rule is empty
                if(empty($audit_time_wages->day_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->day_time_end)) {
                        $audit_time_wages->day_time_end = $this->getDefaultTimeWagesValues('day_time_end'); 
                    } else{
                        $audit_time_wages->day_time_end=$audit_time_wages_settings[0]->day_time_end;
                    }
                  
                }
                if(empty($audit_time_wages->extra_hours)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->extra_hours)) {
                        $audit_time_wages->extra_hours = $this->getDefaultTimeWagesValues('extra_hours'); 
                    } else{
                        $audit_time_wages->extra_hours=$audit_time_wages_settings[0]->extra_hours;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours_start)) {
                        $audit_time_wages->after_hours_start = $this->getDefaultTimeWagesValues('after_hours_start'); 
                    } else{
                        $audit_time_wages->after_hours_start=$audit_time_wages_settings[0]->after_hours_start;
                    }
                  
                }
                if(empty($audit_time_wages->after_hours_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->after_hours_end)) {
                        $audit_time_wages->after_hours_end = $this->getDefaultTimeWagesValues('after_hours_end'); 
                    } else{
                        $audit_time_wages->after_hours_end=$audit_time_wages_settings[0]->after_hours_end;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time_start)) {
                        $audit_time_wages->night_time_start= $this->getDefaultTimeWagesValues('night_time_start'); 
                    } else{
                        $audit_time_wages->night_time_start=$audit_time_wages_settings[0]->night_time_start;
                    }
                  
                }
                if(empty($audit_time_wages->night_time_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->night_time_end)) {
                        $audit_time_wages->night_time_end= $this->getDefaultTimeWagesValues('night_time_end'); 
                    } else{
                        $audit_time_wages->night_time_end=$audit_time_wages_settings[0]->night_time_end;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work_start)) {
                        $audit_time_wages->overtime_work_start= $this->getDefaultTimeWagesValues('overtime_work_start'); 
                    } else{
                        $audit_time_wages->overtime_work_start=$audit_time_wages_settings[0]->overtime_work_start;
                    }
                  
                }
                if(empty($audit_time_wages->overtime_work_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->overtime_work_end)) {
                        $audit_time_wages->overtime_work_end= $this->getDefaultTimeWagesValues('overtime_work_end'); 
                    } else{
                        $audit_time_wages->overtime_work_end=$audit_time_wages_settings[0]->overtime_work_end;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_start)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays_start)) {
                        $audit_time_wages->public_holidays_start= $this->getDefaultTimeWagesValues('public_holidays_start'); 
                    } else{
                        $audit_time_wages->public_holidays_start=$audit_time_wages_settings[0]->public_holidays_start;
                    }
                  
                }
                if(empty($audit_time_wages->public_holidays_end)){       
                    //check settings page value
                    if (empty($audit_time_wages_settings[0]->public_holidays_end)) {
                        $audit_time_wages->public_holidays_end= $this->getDefaultTimeWagesValues('public_holidays_end'); 
                    } else{
                        $audit_time_wages->public_holidays_end=$audit_time_wages_settings[0]->public_holidays_end;
                    }
                  
                }
   
            } catch (Exception $ex) {
                $this->addLogString($ex, 'global_log.txt');
            }
 
        }
          
            
        return [
            'selected_rule'=>$selected_rule,
            'selected_shift'=>$selected_shift,
            'selected_loop'=>$selected_loop,
            'selected_spec'=>$selected_spec,
            'selected_union'=>$selected_union,
            'selected_loop4'=>$selected_loop4,
            'mode'=>$mode,
            'result'=>$audit_time_wages,
            'sql'=>$query.'; <br/>'.$query_h
        ];     
    }
    
    public function getWeekNumber($user_id, $date)
    {
        if(!empty($date)){    
            $user_id=(int)$user_id;
            $user_from_request=JFactory::getUser($user_id);
            $loop_id=$user_from_request->loop_number; 
            
            $query = "SELECT * FROM #__loop_parent WHERE `id`='$loop_id'";
            $this->db->setQuery($query);
            $loop = $this->db->loadObject();
            
            $loop_start_date_obj=DateTime::createFromFormat('d.m.Y', $loop->loop_start_date);
            $loop_start_date=$loop_start_date_obj->format('U');
            
            $date_from_pay_period_obj=DateTime::createFromFormat('Y-m-d', $date);
            $date_from_pay_period=$date_from_pay_period_obj->format('U');
           
            if($date_from_pay_period < $loop_start_date){                 
                $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                $count_day=$interval->d; // count days
                $count_day=(int)$count_day;
                     
                if($count_day%14!=0 && $count_day%14<=7){
                    $week=1;
                } elseif($count_day%14<14 && $count_day%14>7){
                    $week=2;
                } else{
                    $week=2;
                }  
            } elseif($date_from_pay_period == $loop_start_date){           
                $week=1;  
            } elseif($date_from_pay_period > $loop_start_date){
                $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                $count_day=$interval->d; // count days
                $count_day=(int)$count_day;
                         
                if($count_day%14!=0 && $count_day%14<=7){
                    $week=1;
                } elseif($count_day%14<14 && $count_day%14>7){
                    $week=2;
                } else{
                    $week=2;
                }
            }   
        }
        
        return $week;
    }
    
    public function getWeekNumberLoop4($user_id, $date)
    {
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);
        return 1;*/
        
        if(!empty($date)){    
            $user_id=(int)$user_id;
            $user_from_request=JFactory::getUser($user_id);
            $loop_id=$user_from_request->loop_number; 
            
            $query = "SELECT * FROM #__loop4_parent WHERE `id`='$loop_id'";
            $this->db->setQuery($query);
            $loop = $this->db->loadObject();
            
            $loop_start_date_obj=DateTime::createFromFormat('d.m.Y', $loop->loop_start_date);
            $loop_start_date=$loop_start_date_obj->format('U');
            
            $date_from_pay_period_obj=DateTime::createFromFormat('Y-m-d', $date);
            $date_from_pay_period=$date_from_pay_period_obj->format('U');
            echo '$date_from_pay_period='.$date_from_pay_period.' $week='.$week;
            if($date_from_pay_period < $loop_start_date){                 
                $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                $count_day=$interval->d; // count days
                $count_day=(int)$count_day;
                     
                if($count_day%14!=0 && $count_day%14<=7){
                    $week=1;
                } elseif($count_day%14<14 && $count_day%14>7){
                    $week=2;
                } else{
                    $week=2;
                }  
            } elseif($date_from_pay_period == $loop_start_date){           
                $week=1;  
            } elseif($date_from_pay_period > $loop_start_date){
                $interval = $loop_start_date_obj->diff($date_from_pay_period_obj); // get different in DateInterval format  
                $count_day=$interval->d; // count days
                $count_day=(int)$count_day;
                         
                if($count_day%14!=0 && $count_day%14<=7){
                    $week=1;
                } elseif($count_day%14<14 && $count_day%14>7){
                    $week=2;
                } else{
                    $week=2;
                }
            }   
        }
       
        return $week;
    }
    
    public function getSelectedRuleObj($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }
    
    public function getSelectedSpecObj($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_spec_rules WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }
    
    public function getSelectedUnionObj($rule_id) {
        $rule_id = (int) $rule_id;
        $query = "SELECT * FROM #__audit_rules0 WHERE `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        return $data;
    }
    
    
    public function addLogString($text, $filename)
    {
        //$text.='\n';
        file_put_contents(JPATH_BASE.DS.'logs/'.$filename, print_r($text.PHP_EOL, true), FILE_APPEND | LOCK_EX);
    }
    
    public function getDefaultTimeWagesValues($key)
    {
        $arr=[
            'day_time_start'=>'08:00',
            'day_time_end'=>'16:00',
            
            'after_hours_start'=>'16:00',
            'after_hours_end'=>'23:59',
            
            'night_time_start'=>'00:00',
            'night_time_end'=>'07:59',
            
            'overtime_work_start'=>'00:00',
            'overtime_work_end'=>'23:59',
            
            'public_holidays_start'=>'00:00',
            'public_holidays_end'=>'23:59',
            
            'extra_hours'=>'00:00'
            
           /* 'day_break_time'=>'01:00',
            'day_time_to_break'=>'08:00',
            
            'after_hours_break_time'=>'00:15',
            'after_hours_time_to_break'=>'04:00',
            
            'night_time_break_time'=>'00:30',
            'night_time_time_to_break'=>'04:00',
            
            'overtime_work_break_time'=>'00:15',
            'overtime_work_time_to_break'=>'05:00',
            
            'public_holidays_break_time'=>'00:15',
            'public_holidays_time_to_break'=>'05:00'*/
        ];
        
        return $arr[$key];
    }
    
    public function setLoopStart($date, $parent_id)
    {
        $item = new stdClass();
        $item->id = $parent_id;
        $item->loop_start_date=$date;
      
        $this->db->updateObject('#__loop_parent', $item, 'id');
    }
    
    public function getDayExtend($number, $lang) {
        if ($lang === 'is') {
            $arr = [
                1 => 'Mánudagur',
                2 => 'Þriðjudagur',
                3 => 'Miðvikudagur',
                4 => 'Fimmtudag',
                5 => 'Föstudagur',
                6 => 'Laugardagur',
                7 => 'Upprisa'
            ];
        } else {
            $arr = [
                1 => 'Monday',
                2 => 'Tuesday',
                3 => 'Wednesday',
                4 => 'Thursday',
                5 => 'Friday',
                6 => 'Saturday',
                7 => 'Sunday'
            ];
        }

        return $arr[$number];
    }
    
    public function getModeName($key, $lang)
    {
        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        
        $arr=[
            'default'=>JText::_('COM_AUDIT_PAY_PERIOD_MODE_DEFAULT'),
            'rule'=>JText::_('COM_AUDIT_PAY_PERIOD_MODE_RULE'),
            'shift'=>JText::_('COM_AUDIT_PAY_PERIOD_MODE_SHIFT'),
            'loop'=>JText::_('COM_AUDIT_PAY_PERIOD_MODE_LOOP'),
            'loop4'=>JText::_('COM_AUDIT_RULES_LOOP_4'),
            'spec'=>'Monthly rule',
            'union'=>'Union rule'
        ];
        
        return $arr[$key];
    }
    
    public function updateHeaderRuleText($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__rules_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__rules_texts', $item);
        } else{
            $query = "UPDATE #__rules_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function updateHeaderRule0Text($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__rules0_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__rules0_texts', $item);
        } else{
            $query = "UPDATE #__rules0_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function getTexts($mode, $rule_id, $lang)
    {
        $mode=$this->db->escape($mode);
        $lang=$this->db->escape($lang);
        $rule_id=(int)$rule_id;
        
        if($lang==='is'){
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }
        
        if($mode=='rule'){
            $query = "SELECT * FROM #__rules_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='rule0' || $mode=='union'){
            $query = "SELECT * FROM #__rules0_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='default'){
            $query = "SELECT * FROM #__audit_time_wages_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='shift'){
            $query = "SELECT * FROM #__audit_shift_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='loop'){
            $query = "SELECT * FROM #__audit_loop_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='spec'){
            $query = "SELECT * FROM #__audit_spec_rules_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        } elseif($mode=='loop4'){
            $query = "SELECT * FROM #__audit_loop4_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $data = $this->db->loadObject();
        }
        
        /*echo '<pre>';
        print_r($query);
        echo '</pre>';*/
        //here7
        empty($data->daytime_text) ? $data->daytime_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_DATTIME0') : $data->daytime_text=$data->daytime_text;
       
       /* if($this->config->get('enable_overtime_mode_in_union')=='1'){
             empty($data->after_hours_text) ? $data->after_hours_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_OVERWORK1') : $data->after_hours_text=$data->after_hours_text;
        } else{*/
             empty($data->after_hours_text) ? $data->after_hours_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_AFTER_HOURS0') : $data->after_hours_text=$data->after_hours_text;
       // }
       
        empty($data->night_time_text) ? $data->night_time_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_NIGHT_TIME0') : $data->night_time_text=$data->night_time_text;
        empty($data->weekends_text) ? $data->weekends_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_OVERTIME_WORK0') : $data->weekends_text=$data->weekends_text;
        empty($data->holidays_text) ? $data->holidays_text=JText::_('COM_AUDIT_TIME_CARD_CALCULATION_PUBLIC_HOLIDAY0') : $data->holidays_text=$data->holidays_text;
        
        return $data;
    }
    
    //here8
    public function getUserRuleForText($user_id)
    {
        $user_id=(int)$user_id;
        
        $selected_rule=json_decode($this->getSelectedRuleNumber($user_id))->rule_number;
        $selected_shift=json_decode($this->getSelectedShiftNumber($user_id))->shift_number;
        $selected_loop=json_decode($this->getSelectedLoopNumber($user_id))->loop_number;
        $selected_spec=json_decode($this->getSelectedSpecNumber($user_id))->spec_number;
        $selected_union=json_decode($this->getSelectedUnionNumber($user_id))->rule_number0;
        $selected_loop4=json_decode($this->getSelectedLoop4Number($user_id))->loop4_number;
         
        $user_from_request=JFactory::getUser($user_id);
        $owner_id_custom=$user_from_request->owner_id;
            
        if($selected_rule==='0' && $selected_shift==='0' && $selected_loop==='0' && $selected_spec==='0' && $selected_union==='0' && $selected_loop4==='0'){
            $mode='default';
           
            $query = "SELECT * FROM #__audit_time_wages WHERE `id_user`='$owner_id_custom'";
            $this->db->setQuery($query);
            $data = $this->db->loadObjectList();
            
            $rule_id=$data[0]->id;
        } elseif($selected_rule!=='0'){
            $mode='rule';
            $rule_id=$user_from_request->rule_number;
        } elseif($selected_shift!=='0'){
            $mode='shift';
            $rule_id=$user_from_request->shift_number;    
        } elseif($selected_loop!=='0'){
            $mode='loop';         
            $rule_id=$user_from_request->loop_number;
        } elseif($selected_spec!=='0'){
            $mode='spec';
            $rule_id=$user_from_request->spec_number;
        } elseif($selected_union!=='0'){
            $mode='union';
            $rule_id=$user_from_request->rule_number0;
        } elseif($selected_loop4!=='0'){
            $mode='loop4';
            $rule_id=$user_from_request->loop4_number;
        }
        
        return [
            'mode'=>$mode,
            'rule_id'=>$rule_id
        ];
    }
    
    public function updateHeaderDEFRuleText($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__audit_time_wages_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__audit_time_wages_texts', $item);
        } else{
            $query = "UPDATE #__audit_time_wages_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function updateHeaderSpecRuleText($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__audit_spec_rules_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__audit_spec_rules_texts', $item);
        } else{
            $query = "UPDATE #__audit_spec_rules_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function updateHeaderShiftText($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__audit_shift_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__audit_shift_texts', $item);
        } else{
            $query = "UPDATE #__audit_shift_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function updateHeaderLoopText($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__audit_loop_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__audit_loop_texts', $item);
        } else{
            $query = "UPDATE #__audit_loop_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function getRandomString($length=4)
    { 
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $charactersLength = strlen($characters);
        $randomString = '';
        for ($i = 0; $i < $length; $i++) {
            $randomString .= $characters[rand(0, $charactersLength - 1)];
        }
        return $randomString;
    }
    
    public function updateUserCheckbox($id, $mode, $rule_id)
    {
        //$user_spec_rule=$this->getSelectedSpecObj($this->user->spec_number);
        
        $query = "UPDATE #__audit_spec_rules SET `checkbox_after`='0', `checkbox_night`='0' WHERE `id`='".$rule_id."'";
        $this->db->setQuery($query);
        $this->db->query();
            
        /*$item = new stdClass();
        $item->id=$this->user->id;
        $item->checkbox_after=0;
        $item->checkbox_night=0;
        $this->db->updateObject('#__users', $item, 'id');*/
        
        $item = new stdClass();
        $item->id = $rule_id;
        switch($id){
            case 'checkbox_spec_rule_afterwork':
                $item->checkbox_after=$mode;
                break;
            case 'checkbox_spec_rule_night':
                $item->checkbox_night=$mode;   
                break;
        }
      
        $this->db->updateObject('#__audit_spec_rules', $item, 'id');
    }
    
    public function getSubrules($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_for_earning WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function getSubrulesForWeek($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_for_earning_week WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function addSubrule($parent_rule, $lang)
    {
        $item = new stdClass();
        $item->date_create=date('d.m.Y H:i:s');
        $item->timestamp_create=time();
        $item->manager_id=$this->user->id;
        $item->parent_rule_id=(int)$parent_rule;
        $item->lang=$this->db->escape($lang);
        
        return $this->db->insertObject('#__subrules_for_earning', $item);
    }
    
    public function addSubruleForWeek($parent_rule, $lang)
    {
        $item = new stdClass();
        $item->date_create=date('d.m.Y H:i:s');
        $item->timestamp_create=time();
        $item->manager_id=$this->user->id;
        $item->parent_rule_id=(int)$parent_rule;
        $item->lang=$this->db->escape($lang);
        
        return $this->db->insertObject('#__subrules_for_earning_week', $item);
    }
    
    public function getSubrulesHtml($subrules_obj, $lang0)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/subrules.html', print_r($subrules_ob, true), FILE_APPEND | LOCK_EX);
        //chmod($_SERVER['DOCUMENT_ROOT'] . '/logs/collect.html', 0777);
        
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $html='<tr>
                        <th class="td_style-11"><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_6').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_1').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_2').'</div></th>
                        <!--<th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_3').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_4').'</div></th>-->
                    </tr>
                    <!--<tr>
                        <td class="td_style-10 js_event_add_subrule">
                            <i class="fa fa-calendar" aria-hidden="true"></i><span>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_5').'</span></td>
                        <td><div class="new_rule_table_edit">1</div></td>
                        <td><div class="new_rule_table_edit">2</div></td>
                        <td><div class="new_rule_table_edit">3</div></td>
                        <td><div class="new_rule_table_edit">4</div></td>
                    </tr>-->';
        
        foreach($subrules_obj as $one_row){ 
            $html.='
                    
                    <tr>
                        <td class="td_style-10 js_event_add_subrule">
                            <div class="add_new_row" style="display: none;">
                                    <img src="/components/com_audit/assets/images/arrow.png" alt="">
                            </div>
                            <i class="fa fa-calendar" aria-hidden="true"></i><div class="editable" id="new_rule_table_edit-rule_name-'.$one_row->id.'">'.$one_row->rule_name.'</div>
                                <div class="edit_year_range_wrapper">
                                    <div class="time_container">
                                        <div class="time_container_content">
                                           
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_FROM').'</span>
                                            <input type="text" class="year_range_input year_from" id="edit_year_range-from-'.$one_row->id.'" value="'.$one_row->year_from.'"/>
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_TO').'</span>
                                            <input type="text" class="year_range_input year_to" id="edit_year_range-to-'.$one_row->id.'" value="'.$one_row->year_to.'"/>
                                        </div>
                                    </div>
                                </div>
                        </td>
                            <td><div id="new_rule_table_edit-days-'.$one_row->id.'">'.$one_row->days.'</div></td>
                            <td class="new_rule_table_edit_with_del"><div id="new_rule_table_edit-hours-'.$one_row->id.'">'.$one_row->hours.'</div><div class="delete_table_row" id="row_id-'.$one_row->id.'"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>
                            <!--<td><div id="new_rule_table_edit-total_days-'.$one_row->id.'">'.$one_row->total_days.'</div></td>
                            <td class="new_rule_table_edit_with_del"><div id="new_rule_table_edit-total_hours-'.$one_row->id.'">'.$one_row->total_hours.'</div><div class="delete_table_row" id="row_id-'.$one_row->id.'"><i class="fa fa-window-close" aria-hidden="true"></i></div></td>-->
                    </tr>';
         } 
        //ob_end_flush();
        return $html;
    }
    
    public function getSubrulesHtmlNewPsd($subrules_obj, $lang0)
    {
        
        $lang = $this->lang;
        if($lang0 === 'is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $html = '<tr>
                        <th class="td_style-11"><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_6').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_1').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_2').'</div></th>
                        <!--<th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_3').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_4').'</div></th>-->
                    </tr>
                    <!--<tr>
                        <td class="td_style-10 js_event_add_subrule">
                            <i class="fa fa-calendar" aria-hidden="true"></i><span>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_5').'</span></td>
                        <td><div class="new_rule_table_edit">1</div></td>
                        <td><div class="new_rule_table_edit">2</div></td>
                        <td><div class="new_rule_table_edit">3</div></td>
                        <td><div class="new_rule_table_edit">4</div></td>
                    </tr>-->';
        
        foreach($subrules_obj as $one_row){ 
            $html .= '
                    
                    <tr>
                        <td class="td_style-10 js_event_add_subrule">
                            <div class="add_new_row" style="display: none;">
                                <img src="/components/com_audit/assets/images/arrow.png" alt="">
                                
                            </div>
                            <i class="fa fa-calendar" aria-hidden="true"></i><div class="editable" id="new_rule_table_edit-rule_name-'.$one_row->id.'">'.$one_row->rule_name.'</div>
                                <div class="edit_year_range_wrapper">
                                    <div class="time_container">
                                        <div class="time_container_content">
                                           
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_FROM').'</span>
                                            <input type="text" class="year_range_input year_from" id="edit_year_range-from-'.$one_row->id.'" value="'.$one_row->year_from.'"/>
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_TO').'</span>
                                            <input type="text" class="year_range_input year_to" id="edit_year_range-to-'.$one_row->id.'" value="'.$one_row->year_to.'"/>
                                        </div>
                                    </div>
                                </div>
                        </td>
                            <td class="td_style-13"><div id="new_rule_table_edit-days-'.$one_row->id.'">'.$one_row->days.'</div></td>
                            <td class="td_style-13 new_rule_table_edit_with_del"><div id="new_rule_table_edit-hours-'.$one_row->id.'">'.$one_row->hours.'</div><div class="delete_table_row" id="row_id-'.$one_row->id.'"><!--<i class="fa fa-window-close" aria-hidden="true"></i>-->X</div></td>
                            <!--<td><div id="new_rule_table_edit-total_days-'.$one_row->id.'">'.$one_row->total_days.'</div></td>
                            <td class="new_rule_table_edit_with_del"><div id="new_rule_table_edit-total_hours-'.$one_row->id.'">'.$one_row->total_hours.'</div><div class="delete_table_row" id="row_id-'.$one_row->id.'"><!--<i class="fa fa-window-close" aria-hidden="true"></i>-->X</div></td>-->
                    </tr>';
         } 
        //ob_end_flush();
        return $html;
    }
    
    public function getSubrulesHtmlNewPsdForWeek($subrules_obj, $lang0)
    {
        
        $lang = $this->lang;
        if($lang0 === 'is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $html = '<tr>
                        <th class="td_style-11"><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_6').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_1').'</div></th>
                        <th><div>'.JText::_('COM_AUDIT_RULES_YELLOW_RULE_HEADERS_2').'</div></th>
                </tr>
        ';
        
        foreach($subrules_obj as $one_row){ 
            $html .= '
                    
                    <tr>
                        <td class="td_style-10 js_event_add_subrule">
                            <div class="add_new_row_for_week" style="display: none;">
                                <img src="/components/com_audit/assets/images/arrow.png" alt="">     
                            </div>
                            <i class="fa fa-calendar" aria-hidden="true"></i><div class="editable" id="new_rule_table_edit-rule_name-'.$one_row->id.'">'.$one_row->rule_name.'</div>
                                <div class="edit_year_range_wrapper">
                                    <div class="time_container">
                                        <div class="time_container_content">
                                           
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_FROM').'</span>
                                            <input type="text" class="year_range_input_for_week year_from" id="edit_year_range-from-'.$one_row->id.'" value="'.$one_row->year_from.'"/>
                                            <span>'.JText::_('COM_AUDIT_YEAR_RANGE_TO').'</span>
                                            <input type="text" class="year_range_input_for_week year_to" id="edit_year_range-to-'.$one_row->id.'" value="'.$one_row->year_to.'"/>
                                        </div>
                                    </div>
                                </div>
                        </td>
                            <td class="td_style-13"><div id="new_rule_table_edit-days-'.$one_row->id.'">'.$one_row->days.'</div></td>
                            <td class="td_style-13 new_rule_table_edit_with_del"><div id="new_rule_table_edit-hours-'.$one_row->id.'">'.$one_row->hours.'</div><div class="delete_table_row_for_week" id="row_id-'.$one_row->id.'"><!--<i class="fa fa-window-close" aria-hidden="true"></i>-->X</div></td>
                            <!--<td><div id="new_rule_table_edit-total_days-'.$one_row->id.'">'.$one_row->total_days.'</div></td>
                            <td class="new_rule_table_edit_with_del"><div id="new_rule_table_edit-total_hours-'.$one_row->id.'">'.$one_row->total_hours.'</div><div class="delete_table_row" id="row_id-'.$one_row->id.'"><!--<i class="fa fa-window-close" aria-hidden="true"></i>-->X</div></td>-->
                    </tr>';
         } 
       
        return $html;
    }
    
    public function deleteSubrule($row_id)
    {
        $query="DELETE FROM `#__subrules_for_earning` WHERE `id` = '".(int)$row_id."';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function deleteSubruleForWeek($row_id)
    {
        $query="DELETE FROM `#__subrules_for_earning_week` WHERE `id` = '".(int)$row_id."';";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function updateEarnSickTime($value, $field_name, $rule_id, $lang = null)
    {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/rules_test.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
        
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
        
        
        $query = "SELECT * FROM #__subrules_for_earning WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if (!empty($data)) {
            if ($field_name == 'rule_name') {
                $query = "UPDATE #__subrules_for_earning SET `rule_name`='$value', `rule_name_is`='$value' WHERE `id`='$rule_id'";
            } else{
                $query = "UPDATE #__subrules_for_earning SET $field_name='$value' WHERE `id`='$rule_id'";
            }

           
            $this->db->setQuery($query);
            $this->db->query();
        }


        return $value;
    }
    
    public function updateEarnSickTimeForWeek($value, $field_name, $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
        
        
        $query = "SELECT * FROM #__subrules_for_earning_week WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            
        } else{
            $query = "UPDATE #__subrules_for_earning_week SET $field_name='$value' WHERE `id`='$rule_id'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function addDefaultSubrules($parent_rule, $lang0)
    {
        $lang = $this->lang;
        if($lang0 === 'is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info = [
            [
                'rule_name' => '0-1 Year',
                'rule_name_is' => '0-1 ár',
                'days' => '2',
                'hours' => '16'
            ],
            [
                'rule_name' => '1-2 Years',
                'rule_name_is' => '0-1 ár',
                'days' => '2',
                'hours' => '16'
            ],
            [
                'rule_name' => 'More than 2 Years',
                'rule_name_is' => 'Meira en 2 ár',
                'days' => '2.5',
                'hours' => '20'
            ],
            [
                'rule_name' => 'More than 3 Years',
                'rule_name_is' => 'Meira en 3 ár',
                'days' => '3',
                'hours' => '24'
            ],
            [
                'rule_name' => 'More than 5 Years',
                'rule_name_is' => 'Meira en 5 ár',
                'days' => '4',
                'hours' => '32'
            ]
        ];
        
        //one row must be empty name. It's true $i <= 5
        for ($i = 0; $i <= 5; $i++) {
            $item = new stdClass();
            $item->rule_name = $rule_info[$i]['rule_name'];
            $item->rule_name_is = $rule_info[$i]['rule_name_is'];

            $item->days = $rule_info[$i]['days'];
            $item->hours = $rule_info[$i]['hours'];

            $item->date_create = date('d.m.Y H:i:s');
            $item->timestamp_create = time();
            $item->manager_id = $this->user->id;
            $item->parent_rule_id = (int) $parent_rule;
            $item->lang = $this->db->escape($lang0);

            $this->db->insertObject('#__subrules_for_earning', $item);
        }
    }
    
    public function addDefaultSubrulesForWeek($parent_rule, $lang0)
    {
        $lang = $this->lang;
        if($lang0 === 'is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME0'),
                'days'=>'2',
                'hours'=>'16'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME1'),
                'days'=>'2',
                'hours'=>'16'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]
        ];
        
        for($i = 0; $i <= 5; $i++){
            $item = new stdClass();
            $item->rule_name = $rule_info[$i]['rule_name'];
            $item->days = $rule_info[$i]['days'];
            $item->hours = $rule_info[$i]['hours'];
            
            $item->date_create = date('d.m.Y H:i:s');
            $item->timestamp_create = time();
            $item->manager_id = $this->user->id;
            $item->parent_rule_id = (int)$parent_rule;
            $item->lang = $this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_for_earning_week', $item);
        }    
    }
    
    public function editYearRange($value, $type, $id)
    {
        $int_id_arr=explode('-', $id);
        $int_id=$int_id_arr[2];
        
        $item = new stdClass();
        $item->id=$int_id;
        if($type=='from'){
           $item->year_from=(int)$value; 
           $res=$item->year_from;
        } elseif($type=='to'){
           $item->year_to=(int)$value;  
           $res=$item->year_to;
        }

        if($this->db->updateObject('#__subrules_for_earning', $item, 'id')){
            return $res;
        }
    }
    
    public function editYearRangeForWeek($value, $type, $id)
    {
        $int_id_arr=explode('-', $id);
        $int_id=$int_id_arr[2];
        
        $item = new stdClass();
        $item->id=$int_id;
        if($type=='from'){
           $item->year_from=(int)$value; 
           $res=$item->year_from;
        } elseif($type=='to'){
           $item->year_to=(int)$value;  
           $res=$item->year_to;
        }

        if($this->db->updateObject('#__subrules_for_earning_week', $item, 'id')){
            return $res;
        }
    }
    
    public function getSubrulesHolidays($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_holidays WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function getSubrulesHolidaysForWeekRule($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_holidays_week WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function getSubrulesSickChild($parent_rule) 
    {
        $query = "SELECT * FROM #__subrules_sick_child WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function getSubrulesSickChildForWeekRule($parent_rule) 
    {
        $query = "SELECT * FROM #__subrules_sick_child_week WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function addDefaultHolidaysSubrules($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>'',
                'days'=>'2',
                'hours'=>'16'
            ],
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'2',
                'hours'=>'16'
            ],*/
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]*/
        ];
        $i=0;
        //for($i=0; $i<1; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->days=$rule_info[$i]['days'];
            $item->hours=$rule_info[$i]['hours'];
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_holidays', $item);
        //}
    }
    
     public function addDefaultHolidaysSubrulesForWeekRule($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>'',
                'days'=>'2',
                'hours'=>'16'
            ],
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'2',
                'hours'=>'16'
            ],*/
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]*/
        ];
        $i=0;
        //for($i=0; $i<1; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->days=$rule_info[$i]['days'];
            $item->hours=$rule_info[$i]['hours'];
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_holidays_week', $item);
        //}
    }
    
    public function addDefaultSickChildSubrules($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>'',//JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'1',
                'hours'=>'8'
            ],
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'2',
                'hours'=>'16'
            ],*/
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]*/
        ];
        $i=0;
        //for($i=0; $i<1; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->days=$rule_info[$i]['days'];
            $item->hours=$rule_info[$i]['hours'];
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_sick_child', $item);
        //}
    }
    
    public function addDefaultSickChildSubrulesForWeekRule($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>'',//JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'1',
                'hours'=>'8'
            ],
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'2',
                'hours'=>'16'
            ],*/
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]*/
        ];
        $i=0;
        //for($i=0; $i<1; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->days=$rule_info[$i]['days'];
            $item->hours=$rule_info[$i]['hours'];
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_sick_child_week', $item);
        //}
    }
    
    public function getSubrulesMinutes($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_minutes WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function getSubrulesMinutesWeek($parent_rule)
    {
        $query = "SELECT * FROM #__subrules_minutes_week WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        
        return $data;
    }
    
    public function addDefaultSubrulesMinutes($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SUBRULES_MINUTES_TEXT'),
                'minutes'=>'',
                //'date_start'=>date('d.m.Y')
            ], 
        ];
        $i=0;
        $count=count($rule_info);
        
        for($i=0; $i<$count; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->minutes=$rule_info[$i]['minutes'];
           
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            //$item->date_start=$rule_info[$i]['date_start'];
            $item->timestamp_start=time();
            $item->checkbox_all_days=0;
            $item->is_enable = 1;
            
            $this->db->insertObject('#__subrules_minutes', $item);
        }
    }
    
    public function addDefaultSubrulesMinutesWeek($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SUBRULES_MINUTES_TEXT'),
                'minutes'=>'',
                //'date_start'=>date('d.m.Y')
            ], 
        ];
        $i=0;
        $count=count($rule_info);
        
        for($i=0; $i<$count; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->minutes=$rule_info[$i]['minutes'];
           
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            //$item->date_start=$rule_info[$i]['date_start'];
            $item->timestamp_start=time();
            $item->checkbox_all_days=1;
            $item->is_enable = 1;
            
            $this->db->insertObject('#__subrules_minutes_week', $item);
        }
    }
    
    public function addSickChildSubrule($parent_rule, $lang0)
    {
        $lang=$this->lang;
        if($lang0==='is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $rule_info=[
            /*[
                'rule_name'=>'',
                'days'=>'2',
                'hours'=>'16'
            ],*/
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_UNION_RULE_DEFAULT_SICK_CHILD_TEXT'),
                'days'=>'2',
                'hours'=>'16'
            ],
            /*[
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME2'),
                'days'=>'2.5',
                'hours'=>'20'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME3'),
                'days'=>'3',
                'hours'=>'24'
            ],
            [
                'rule_name'=>JText::_('COM_AUDIT_RULES_YELLOW_RULE_DEFAULT_NAME4'),
                'days'=>'4',
                'hours'=>'32'
            ]*/
        ];
        $i=0;
        //for($i=0; $i<=1; $i++){
            $item = new stdClass();
            $item->rule_name=$rule_info[$i]['rule_name'];
            $item->days=$rule_info[$i]['days'];
            $item->hours=$rule_info[$i]['hours'];
            
            $item->date_create=date('d.m.Y H:i:s');
            $item->timestamp_create=time();
            $item->manager_id=$this->user->id;
            $item->parent_rule_id=(int)$parent_rule;
            $item->lang=$this->db->escape($lang0);
            
            $this->db->insertObject('#__subrules_holidays', $item);
        //}
    }
    
    public function updateHolidaysTableFields($value, $field_name, $rule_id)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        //$lang=$this->db->escape($lang);
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/subrules.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
        
        $query = "SELECT * FROM #__subrules_holidays WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/subrules0.html', print_r($data, true), FILE_APPEND | LOCK_EX);
        if(empty($data)){
            /*$item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__subrules_holidays', $item);*/
        } else{
            $query = "UPDATE #__subrules_holidays SET $field_name='$value' WHERE `id`='$rule_id'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function updateHolidaysTableFieldsForWeek($value, $field_name, $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
        
        $query = "SELECT * FROM #__subrules_holidays_week WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            
        } else{
            $query = "UPDATE #__subrules_holidays_week SET $field_name = '$value' WHERE `id`='$rule_id'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function cloneRules($id, $lang, $type)
    {
        switch($type){
            case 'union_rule':
                return $this->cloneUnionRule($id, $lang);
            case 'standart_rule':
                return $this->cloneStandartRule($id, $lang);
            case '1_week_rule':
                return $this->cloneOneWeekRule($id, $lang);
            case '2_week_rule':
                return $this->cloneTwoWeekRule($id, $lang);
            case '4_week_rule':
                return $this->cloneFourWeekRule($id, $lang);
            case 'monthly_rule':
                return $this->cloneMonthlyRule($id, $lang);
        }
    }
    
     private function cloneMonthlyRule(int $id, string $lang1): int{
        $table_4_week = '#__audit_spec_rules';
        
        
        $query = "SELECT * FROM $table_4_week WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        
     

        if ($lang1 == 'is') {
            
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        if (!empty($data)) {
            $not_permitted_fields = [
                'id',
                'date',
                'rule_name'
            ];

            foreach ($data as $k => $v) {
                $item = new stdClass();
                $item->id = null;
                
                foreach($v as $key => $one_child_rule){
                    if (!in_array($key, $not_permitted_fields)) {
                        $item->$key = $one_child_rule;
                    } else{
                        if($key == 'date'){
                            $item->$key = date('Y-m-d');
                        }
                        if ($key == 'rule_name') {
                            if (empty($one_child_rule)) {
                                $one_child_rule = JText::_('COM_AUDIT_RULES_SPEC_RULE_WORD') . ' copy';
                            } else {
                                $one_child_rule .= ' copy';
                            }
                            
                             $item->$key = $one_child_rule;
                        }
                    }
                    
                }
                
               
                $this->db->insertObject($table_4_week, $item);
                $insert_id = $this->db->insertid();
                
                $four_monthly_rule_texts = $this->loadRulesTexts('monthly', $id, $lang1);
                
                if(!empty($four_monthly_rule_texts)){ 
                    $this->cloneTexts('monthly', $four_monthly_rule_texts, $insert_id);   
                }
            }
          
        }

        return $insert_id;
    }
    
    private function cloneFourWeekRule(int $id, string $lang1): int{
        $table_4_week = '#__audit_loops4';
        $table_parent = '#__loop4_parent';
        
        $query = "SELECT * FROM $table_4_week WHERE `parent_id` = '$id' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        $query = "SELECT * FROM $table_parent WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data_parent = $this->db->loadObject();
        

        if ($lang1 == 'is') {
            
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        if (!empty($data)) {
            $not_permitted_fields = [
                'id',
                'parent_id',
                'date'
            ];

            foreach ($data as $k => $v) {
                $item = new stdClass();
                $item->id = null;
                
                foreach($v as $key => $one_child_rule){
                    if (!in_array($key, $not_permitted_fields)) {
                        $item->$key = $one_child_rule;
                    } else{
                        if($key == 'date'){
                            $item->$key = date('Y-m-d');
                        }
                    }
                }
                
               
                $this->db->insertObject($table_4_week, $item);
                $insert_ids[] = $this->db->insertid();
            }
            $inserted_id_string = implode(',', $insert_ids);
            
          
            
            $not_permitted_fields_parent = [
                'id'
            ];
            
            if(!empty($insert_ids)){
                $item1 = new stdClass();
                $item1->id = null;
                
                //clone shift parent item
                foreach($data_parent as $key => $one_field){
                    if (!in_array($key, $not_permitted_fields_parent)) {
                         if ($key == 'rule_name') {
                            if (empty($one_field)) {
                                $one_field = JText::_('COM_AUDIT_RULES_LOOP_4') . ' copy';
                            } else {
                                $one_field .= ' copy';
                            }
                        }
                        $item1->$key = $one_field;
                    }
                }
                
                $this->db->insertObject($table_parent, $item1);
                $insert_id = $this->db->insertid();
                
                //set new cloned shift parent
                $query = "UPDATE $table_4_week SET `parent_id` = '$insert_id' WHERE `id` IN($inserted_id_string)";
                $this->db->setQuery($query);
                $this->db->query();
            }

            //clone rule headers
            $four_week_rule_texts = $this->loadRulesTexts('4_weeks', $id, $lang1);
            /*echo '<pre>';
            print_r($one_week_rule_texts);
            echo '</pre>';*/
            if(!empty($four_week_rule_texts)){
                $this->cloneTexts('4_weeks', $four_week_rule_texts, $insert_id);
            }
            
            
            
            return $insert_id;
        }
    }
    
    private function cloneTwoWeekRule(int $id, string $lang1): int{
        $table_2_week = '#__audit_loops';
        $table_parent = '#__loop_parent';
        
        $query = "SELECT * FROM $table_2_week WHERE `parent_id` = '$id' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        $query = "SELECT * FROM $table_parent WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data_parent = $this->db->loadObject();
        

        if ($lang1 == 'is') {
            
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        if (!empty($data)) {
            $not_permitted_fields = [
                'id',
                'parent_id'
            ];

            foreach ($data as $k => $v) {
                $item = new stdClass();
                $item->id = null;
                
                foreach($v as $key => $one_child_rule){
                    if (!in_array($key, $not_permitted_fields)) {
                        $item->$key = $one_child_rule;
                    }
                }
                
               
                $this->db->insertObject($table_2_week, $item);
                $insert_ids[] = $this->db->insertid();
            }
            $inserted_id_string = implode(',', $insert_ids);
            
          
            
            $not_permitted_fields_parent = [
                'id'
            ];
            
            if(!empty($insert_ids)){
                $item1 = new stdClass();
                $item1->id = null;
                
                //clone shift parent item
                foreach($data_parent as $key => $one_field){
                    if (!in_array($key, $not_permitted_fields_parent)) {
                         if ($key == 'rule_name') {
                            if (empty($one_field)) {
                                $one_field = JText::_('COM_AUDIT_RULES_LOOP_WORD') . ' copy';
                            } else {
                                $one_field .= ' copy';
                            }
                        }
                        $item1->$key = $one_field;
                    }
                }
                
                $this->db->insertObject($table_parent, $item1);
                $insert_id = $this->db->insertid();
                
                //set new cloned shift parent
                $query = "UPDATE $table_2_week SET `parent_id` = '$insert_id' WHERE `id` IN($inserted_id_string)";
                $this->db->setQuery($query);
                $this->db->query();
            }

            //clone rule headers
            $two_week_rule_texts = $this->loadRulesTexts('2_weeks', $id, $lang1);
            /*echo '<pre>';
            print_r($one_week_rule_texts);
            echo '</pre>';*/
            if(!empty($two_week_rule_texts)){
                $this->cloneTexts('2_weeks', $two_week_rule_texts, $insert_id);
            }
            
            
            
            return $insert_id;
        }
    }
    
    private function cloneOneWeekRule($id, $lang1): int{
        $query = "SELECT * FROM #__audit_shifts WHERE `parent_id` = '$id' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        $query = "SELECT * FROM #__shift_parent WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data_parent = $this->db->loadObject();
        //echo '$lang:'.$lang;
        

        if ($lang1 == 'is') {
            
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        if (!empty($data)) {
            $not_permitted_fields = [
                'id',
                'parent_id'
            ];

            foreach ($data as $k => $v) {
                $item = new stdClass();
                $item->id = null;
                
                foreach($v as $key => $one_child_rule){
                    if (!in_array($key, $not_permitted_fields)) {
                        $item->$key = $one_child_rule;
                    }
                }
                
               
                $this->db->insertObject('#__audit_shifts', $item);
                $insert_ids[] = $this->db->insertid();
            }
            $inserted_id_string = implode(',', $insert_ids);
            
          
            
            $not_permitted_fields_parent = [
                'id'
            ];
            
            if(!empty($insert_ids)){
                $item1 = new stdClass();
                $item1->id = null;
                
                //clone shift parent item
                foreach($data_parent as $key => $one_field){
                    if (!in_array($key, $not_permitted_fields_parent)) {
                         if ($key == 'rule_name') {
                            if (empty($one_field)) {
                                $one_field = JText::_('COM_AUDIT_RULES_SHIFT_WORD') . ' copy';
                            } else {
                                $one_field .= ' copy';
                            }
                        }
                        $item1->$key = $one_field;
                    }
                }
                
                $this->db->insertObject('#__shift_parent', $item1);
                $insert_id = $this->db->insertid();
                
                //set new cloned shift parent
                $query = "UPDATE #__audit_shifts SET `parent_id`='$insert_id' WHERE `id` IN($inserted_id_string)";
                $this->db->setQuery($query);
                $this->db->query();
            }

            //clone rule headers
            $one_week_rule_texts = $this->loadRulesTexts('1_week', $id, $lang1);
            /*echo '<pre>';
            print_r($one_week_rule_texts);
            echo '</pre>';*/
            if(!empty($one_week_rule_texts)){
                $this->cloneTexts('1_week', $one_week_rule_texts, $insert_id);
            }
            
            //start clone buttom tables
            $subrules_holidays = $this->getSubrulesHolidaysForWeekRule($id);
            /*echo '<pre>$subrules_holidays:';
            print_r($subrules_holidays);
            echo '</pre>';*/
            
            if(!empty($subrules_holidays)){
               $this->cloneSubrulesHolidaysForWeekRule($subrules_holidays, (int)$insert_id); 
            }
            
            $enable_sick_child = $this->config->get('enable_sick_child');
            if ($enable_sick_child == '1') {
                $subrules_holidays_sick_child = $this->getSubrulesSickChildForWeekRule($id);
                /*echo '<pre>';
                print_r($subrules_holidays);
                echo '</pre>';*/
                if (!empty($subrules_holidays_sick_child)) {
                    $this->cloneSubrulesSickChildForWeekRule($subrules_holidays_sick_child, (int)$insert_id);
                }
            }
            
            $subrules = $this->getSubrulesForWeek($id);

            if (!empty($subrules)) {
                /*echo '<pre>';
                print_r($subrules);
                echo '</pre>';*/
                
                $this->cloneSubrulesForWeek($subrules, (int)$insert_id);
            }
            
            $enable_earn_minutes = $this->config->get('enable_earn_minutes');
            if($enable_earn_minutes == '1'){
                $subrules_minutes = $this->getSubrulesMinutesWeek($id);
                /*echo '<pre>';
                print_r($subrules_minutes);
                echo '</pre>';*/
                if (!empty($subrules_minutes)) {
                    $this->cloneSubrulesMinutesWeek($subrules_minutes, (int)$insert_id);                                                
                }
            }
            //end clone buttom tables
            
            return $insert_id;
        }
    }
    
    private function cloneSubrulesMinutesWeek(array $original_subrules, int $parent_id): void
    {
        $not_permitted_arr = [
            'id',
            'parent_rule_id',
            'date_create',
            'timestamp_create'
        ];
        
        foreach($original_subrules as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k => $v){
                if(!in_array($k, $not_permitted_arr)){
                    $item->$k = $v;
                } else{
                    if($k == 'parent_rule_id'){
                        $item->parent_rule_id = $parent_id;
                    } if($k == 'date_create'){
                        $item->$k = date('d.m.Y H:i:s');
                    } if($k == 'timestamp_create'){
                        $item->$k = time();
                    }
                }
                
            }
            
            $this->db->insertObject('#__subrules_minutes_week', $item);
        }  
    }
    
    private function cloneSubrulesForWeek(array $original_subrules, int $parent_id): void
    {
        $not_permitted_arr = [
            'id',
            'parent_rule_id',
            'date_create',
            'timestamp_create'
        ];
        
        foreach($original_subrules as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k => $v){
                if(!in_array($k, $not_permitted_arr)){
                    $item->$k = $v;
                } else{
                    if($k == 'parent_rule_id'){
                        $item->parent_rule_id = $parent_id;
                    } if($k == 'date_create'){
                        $item->$k = date('d.m.Y H:i:s');
                    } if($k == 'timestamp_create'){
                        $item->$k = time();
                    }
                }
                
            }
            
            $this->db->insertObject('#__subrules_for_earning_week', $item);
        }  
    }
    
    private function cloneSubrulesSickChildForWeekRule(array $original_subrules, int $parent_id): void
    {
        $not_permitted_arr = [
            'id',
            'parent_rule_id',
            'date_create',
            'timestamp_create'
        ];
        
        foreach($original_subrules as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k => $v){
                if(!in_array($k, $not_permitted_arr)){
                    $item->$k = $v;
                } else{
                    if($k == 'parent_rule_id'){
                        $item->parent_rule_id = $parent_id;
                    } if($k == 'date_create'){
                        $item->$k = date('d.m.Y H:i:s');
                    } if($k == 'timestamp_create'){
                        $item->$k = time();
                    }
                }
            }
            
            $this->db->insertObject('#__subrules_sick_child_week', $item);
        }  
    }
    
    private function cloneSubrulesHolidaysForWeekRule(array $original_subrules, int $parent_id): void
    {
        $not_permitted_arr = [
            'id',
            'parent_rule_id',
            'date_create',
            'timestamp_create'
        ];
        
        foreach($original_subrules as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k => $v){
                if(!in_array($k, $not_permitted_arr)){
                    $item->$k = $v;
                } else{
                    if($k == 'parent_rule_id'){
                        $item->parent_rule_id = $parent_id;
                    } if($k == 'date_create'){
                        $item->$k = date('d.m.Y H:i:s');
                    } if($k == 'timestamp_create'){
                        $item->$k = time();
                    }
                }
            }
            
            $this->db->insertObject('#__subrules_holidays_week', $item);
        }  
    }
    
    private function cloneStandartRule($id, $lang1) {
        $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        /* cho '<pre>';
          print_r($data);
          echo '</pre>';
          return false; */

        if ($lang1 == 'is') {
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

        if (!empty($data)) {
            $item = new stdClass();
            $item->id = null;

            foreach ($data as $k => $v) {
                if ($k != 'id') {
                    if ($k == 'rule_name') {
                        if (empty($v)) {
                            $v = JText::_('COM_AUDIT_RULES_RULE_WORD') . ' copy';
                        } else {
                            $v .= ' copy';
                        }
                    }
                    $item->$k = $v;
                }
            }
           
            //clone this table https://prnt.sc/pwak1t
            $this->db->insertObject('#__audit_time_wages_with_rules', $item);
            $insert_id = $this->db->insertid();
            
            $standart_rule_texts = $this->loadRulesTexts('standart_rule', $id, $lang1);
            if(!empty($standart_rule_texts)){
                $this->cloneTexts('standart_rule', $standart_rule_texts, $insert_id);
            }

            return $insert_id;
        }
    }

    private function loadRulesTexts(string $type, int $rule_id, string $lang): object
    {
        switch($type){
            case 'union':
                $query = "SELECT * FROM #__rules0_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();
            break;
            case 'standart_rule':
                $query = "SELECT * FROM #__rules_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();  
            break;
            case '1_week':
                $query = "SELECT * FROM #__audit_shift_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();  
            break;
            case '2_weeks':
                $query = "SELECT * FROM #__audit_loop_texts WHERE `rule_id` = '$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();  
            break;
            case '4_weeks':
                $query = "SELECT * FROM #__audit_loop4_texts WHERE `rule_id` = '$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();  
            break;
            case 'monthly':
                $query = "SELECT * FROM #__audit_spec_rules_texts WHERE `rule_id` = '$rule_id' AND `lang`='$lang'";
                $this->db->setQuery($query);
                $data = $this->db->loadObject();  
            break;
        }
        
        if(empty($data)){
            $data = new stdClass();
        }
        
        return $data;
    }
    
    private function cloneTexts(string $type, object $object_of_rules, int $inserted_id): bool
    {
        switch ($type) {
            case 'union':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__rules0_texts', $item);
            break;
            case 'standart_rule':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__rules_texts', $item);
            break;
            case '1_week':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__audit_shift_texts', $item);
            break;
            case '2_weeks':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__audit_loop_texts', $item);
            break;
            case '4_weeks':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__audit_loop4_texts', $item);
            break;
            case 'monthly':
                $item = new stdClass();
                $item->id = null;
                
                $not_permitted_fields = [
                    'id', 
                    'rule_id'
                ];
                
                foreach ($object_of_rules as $k => $v) {
                    if (!in_array($k, $not_permitted_fields)) {
                        
                        $item->$k = $v;
                    } elseif($k === 'rule_id'){
                        $item->$k = $inserted_id;
                    }
                }

                $res = $this->db->insertObject('#__audit_spec_rules_texts', $item);
            break;
        }
        
        return $res;
    }
    
    public function cloneUnionRule($id, $lang1)
    {
        $query = "SELECT * FROM #__audit_rules0 WHERE `id` = '$id'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
       
         if($lang1 == 'is'){
            //$this->lang->setLanguage('is-IS');
            //$this->lang->load();
            $lang = JFactory::getLanguage();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        if(!empty($data)){
            $item = new stdClass();
            $item->id = null;
            
            foreach($data as $k=>$v){
                if($k!='id'){
                    if($k=='rule_name'){
                        if(empty($v)){
                            $v=JText::_('COM_AUDIT_RULES_UNION_RULE').' copy';
                        } else{
                            $v.=' copy';
                        }
                        
                    }
                    $item->$k=$v;
                } 
                
            }
            //clone this table https://prnt.sc/pwak1t
            $this->db->insertObject('#__audit_rules0', $item);
            $insert_id = $this->db->insertid();
            
            $union_rule_texts = $this->loadRulesTexts('union', $id, $lang1);
            if(!empty($union_rule_texts)){
                $this->cloneTexts('union', $union_rule_texts, $insert_id);
            }
            
            
            
            
            //clone this table https://prnt.sc/pwafsh
            $subrules_holidays=$this->getSubrulesHolidays($id);
            if(!empty($subrules_holidays)){
               $this->cloneHolidaysRows($subrules_holidays, $insert_id); 
            }
            
            //clone this table https://prnt.sc/pwaety
            $subrules_sicktime=$this->getSubrules($id);
            if(!empty($subrules_sicktime)){
               $this->cloneSicktimeRows($subrules_sicktime, $insert_id); 
            }
            $config=&JFactory::getConfig();
            $enable_earn_minutes=$config->get('enable_earn_minutes');
            $enable_new_part_union = $config->get('enable_new_part_union');
            
            $subrules_sick_child = $this->getSubrulesSickChild($id);
            if(!empty($subrules_sick_child)){
                $this->cloneSubrulesSickChild($subrules_sick_child, $insert_id);
            }
            
            if($enable_earn_minutes=='1'){
                $subrules_minutes=$this->getSubrulesMinutes($id);
                if(!empty($subrules_minutes)){
                    $this->cloneEarnMinutesRows($subrules_minutes, $insert_id);  
                }
            }
            if($enable_new_part_union == '1'){
                $subrules_new_part = $this->getSubrulesTrue($id, 'new_part');
                
                if(!empty($subrules_new_part)){
                    $this->cloneSubrules($subrules_new_part, 'new_part', $insert_id);
                }
            }
            
            $enable_overtime_mode_in_union=$config->get('enable_overtime_mode_in_union');
            if($enable_overtime_mode_in_union=='1'){
                $overworks_object=$this->getOverworks($id);
                if(!empty($overworks_object)){
                    $this->cloneOverworks($overworks_object, $insert_id);
                }
            }
            
        }
       

        return $insert_id;
    }
    
    private function cloneSubrules($subrules, $type, $insert_id)
    {
        if ($type === 'new_part') {
            $not_perm_arr = [
                'id',
                'parent_rule_id'
            ];

            foreach ($subrules as $one_row) {
                $item = new stdClass();

                foreach ($one_row as $k => $v) {
                    if (!in_array($k, $not_perm_arr)) {
                        $item->$k = $v;
                    } if ($k == 'parent_rule_id') {
                        $item->parent_rule_id = (int) $insert_id;
                    }
                }

                $this->db->insertObject('#__subrules_new_part', $item);
            }
        }
    }
    
    private function cloneSubrulesSickChild($subrules, $insert_id)
    {
        //if ($type === 'new_part') {
            $not_perm_arr = [
                'id',
                'parent_rule_id'
            ];

            foreach ($subrules as $one_row) {
                $item = new stdClass();

                foreach ($one_row as $k => $v) {
                    if (!in_array($k, $not_perm_arr)) {
                        $item->$k = $v;
                    } if ($k == 'parent_rule_id') {
                        $item->parent_rule_id = (int) $insert_id;
                    }
                }

                $this->db->insertObject('#__subrules_sick_child', $item);
            }
        //}
    }
    
    private function cloneOverworks($subrules_sicktime, $insert_id)
    {
        foreach($subrules_sicktime as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k=>$v){
                if($k!='id' && $k!='parent_rule'){
                    $item->$k=$v;
                }
                if($k=='parent_rule'){
                    $item->parent_rule=(int)$insert_id;
                }
            }
            
            $this->db->insertObject('#__union_overworks', $item);
        }
    }
    
    private function cloneEarnMinutesRows($subrules_sicktime, $insert_id)
    {
        foreach($subrules_sicktime as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k=>$v){
                if($k!='id' && $k!='parent_rule_id'){
                    $item->$k=$v;
                }
                if($k=='parent_rule_id'){
                    $item->parent_rule_id=(int)$insert_id;
                }
            }
            
            $this->db->insertObject('#__subrules_minutes', $item);
        }  
    }
    
    private function cloneSicktimeRows($subrules_sicktime, $insert_id)
    {
        foreach($subrules_sicktime as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k=>$v){
                if($k!='id' && $k!='parent_rule_id'){
                    $item->$k=$v;
                }
                if($k=='parent_rule_id'){
                    $item->parent_rule_id=(int)$insert_id;
                }
            }
            
            $this->db->insertObject('#__subrules_for_earning', $item);
        }  
    }
    
    private function cloneHolidaysRows($subrules_holidays, $insert_id)
    {
        foreach($subrules_holidays as $one_row){
            $item = new stdClass();
            
            foreach($one_row as $k=>$v){
                if($k!='id' && $k!='parent_rule_id'){
                    $item->$k=$v;
                }
                if($k=='parent_rule_id'){
                    $item->parent_rule_id=(int)$insert_id;
                }
            }
            
            $this->db->insertObject('#__subrules_holidays', $item);
        }  
    }
    
    public function setUnionNumber($rule_number, $user_id) {
        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);
        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `rule_number0`='$rule_number' WHERE `id`='$user_id'";
            $this->db->setQuery($query);
            return $this->db->query();
        } else {
            return 'error';
        }
    }
    
    public function setUnionNumberInHome($rule_number, $user_id) 
    {
        $this->clearItems($user_id);

        $query = "UPDATE #__users SET `rule_number0`='$rule_number' WHERE `id`='$user_id'";
        //echo $query;
        
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getSelectedUnionNumber($user_id) {
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->rule_number0;
        if ($user_rule_number == 0) {
            //$user_rule_number = 1;
            $mode = 1;
        }

        return json_encode([
            'rule_number0' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function setWorkStartDate($user_id, $final_date) {
        $user=JFactory::getUser($user_id);
        $input_date_obj=DateTime::createFromFormat('d.m.Y', $final_date);
        
        //$user->work_start_timestamp=$input_date_obj->format('U');
        //$user->work_start_date=$input_date_obj->format('d.m.Y');
        /*try{
            $user->save();
        } catch (Exception $ex) {
            return $ex;
        }*/
        
        $work_start_timestamp=$input_date_obj->format('U');
        $work_start_date=$input_date_obj->format('d.m.Y');
        
        $query = "UPDATE #__users SET `work_start_timestamp`='$work_start_timestamp', `work_start_date`='$work_start_date' WHERE `id`='$user_id'";
        $this->db->setQuery($query);
        return $this->db->query();
         
        //return $input_date_obj->format('U');
    }
    
    public function setRuleTopLevelHeader($value, $field_name, $rule_id) {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
    
        switch($field_name){
            case 'union_rule_editable':
                $query = "UPDATE #__audit_rules0 SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            case 'standart_rule_editable':
                $query = "UPDATE #__audit_time_wages_with_rules SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            case 'shift_rule_editable':
                $query = "UPDATE #__shift_parent SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            case 'loop_rule_editable':
                $query = "UPDATE #__loop_parent SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            case 'monthly_rule_editable':
                $query = "UPDATE #__audit_spec_rules SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            case 'loop4_rule_editable':
                $query = "UPDATE #__loop4_parent SET `rule_name`='$value' WHERE `id`='$rule_id'";
                break;
            default:
                'error in editable id';
                break;
        }
        
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function updateEarnMinutes($value, $field_name, $rule_id)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
            
        $permitted_fields=[
            'rule_name',
            'minutes',
            //'date_start'
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        if($field_name=='minutes'){
            $value=(int)$value;
        }
        $query = "UPDATE #__subrules_minutes SET $field_name='$value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function updateEarnMinutesWeek($value, $field_name, $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
            
        $permitted_fields = [
            'rule_name',
            'minutes'
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        if($field_name == 'minutes'){ 
            $value = (int)$value;
        }
        $query = "UPDATE #__subrules_minutes_week SET $field_name='$value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function setMinutesEarnDate($rule_id, $final_date) {
        // $user=JFactory::getUser($user_id);
        
        $input_date_obj=DateTime::createFromFormat('d.m.Y', $final_date);

        $work_start_timestamp=$input_date_obj->format('U');
        $work_start_date=$input_date_obj->format('d.m.Y');
        
        $query = "UPDATE #__subrules_minutes SET `timestamp_start`='$work_start_timestamp', `date_start`='$work_start_date' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query();
        
    }
    
    public function setMinutesEarnDateWeek($rule_id, $final_date) {
        // $user=JFactory::getUser($user_id);
        
        $input_date_obj=DateTime::createFromFormat('d.m.Y', $final_date);

        $work_start_timestamp=$input_date_obj->format('U');
        $work_start_date=$input_date_obj->format('d.m.Y');
        
        $query = "UPDATE #__subrules_minutes_week SET `timestamp_start`='$work_start_timestamp', `date_start`='$work_start_date' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query();
        
    }
    
    public function updateSickChildTableFields($value, $field_name, $rule_id)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
            
        $permitted_fields=[
            'rule_name',
            'days',
            'hours'
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        if($field_name=='minutes'){
            $value=(int)$value;
        }
        $query = "UPDATE #__subrules_sick_child SET $field_name='$value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function updateSickChildTableFieldsForWeek($value, $field_name, $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
            
        $permitted_fields=[
            'rule_name',
            'days',
            'hours'
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        if($field_name == 'minutes'){
            $value = (int)$value;
        }
        $query = "UPDATE #__subrules_sick_child_week SET $field_name = '$value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function addOverworkColumn($parent_id, $lang) 
    {

        try {
            $count = count($this->getOverworks($parent_id));
            //echo $count;
            if ($count > 1) {
                throw new Exception('code-0');
            } 
            if ($lang == 'is') {
                $this->lang->setLanguage('is-IS');
                $this->lang->load();
            }

            $item = new stdClass();

            $item->parent_rule = (int) $parent_id;
            $item->overwork_start = '';
            $item->overwork_break_time = '';
            $item->overwork_time_to_break = '';
            $item->overwork_stop = '';
            $item->overwork_limit = '';
            $item->timestamp_create = time();
            $item->date_create = date('d.m.Y H:i:s');
            $item->id_user = $this->user->id; 
            
            $count = count($this->getOverworks($parent_id))+2;
            $item->overwork_name = JText::_('COM_AUDIT_RULES_OVERWORK_WORD').' '.$count;

            $this->db->insertObject('#__union_overworks', $item);
            return $this->db->insertid();
        } catch (Exception $e) {
            return $e->getMessage();
        }
    }

    public function getOverworks($parent_id)
    {
        $query = "SELECT * FROM #__union_overworks WHERE `parent_rule`='$parent_id' AND `id_user`='".$this->user->id."' ORDER BY `id` DESC";
        $this->db->setQuery($query);
        return $this->db->loadObjectList();
    }
    
    public function deleteOverwork($id)
    {
        $parent_id='not';
        
        if(!empty($id)){
            $query = "SELECT `parent_rule` FROM #__union_overworks WHERE `id`='$id' AND `id_user`='".$this->user->id."'";
            $this->db->setQuery($query);
            $parent_id=$this->db->loadResult();
        
            $query = "DELETE FROM #__union_overworks WHERE `id` = '$id';";
            $this->db->setQuery($query);
            $this->db->query();
            
           
        }
        return $parent_id;
    }
    
    public function updateOverworksFields($value, $field_name, $rule_id){
        /*echo '<pre>';
        print_r(func_get_args());
        echo '</pre>';*/
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
            
        $permitted_fields=[
            'overwork_name',
            'overwork_start',
            'overwork_break_time',
            'overwork_stop', 
            'overwork_limit'
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        if($field_name!='overwork_name'){
            $final_value=$this->autocompletion($value);
        } else{
            $final_value=$value;
        }
        $query = "UPDATE #__union_overworks SET $field_name='$final_value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $final_value;
    }
    
    public function autocompletion($valueField)
    {
       
        if(strlen($valueField) === 5){//if 00:00 pattern
            $arr = explode(':', $valueField);
            $count = count($arr);
            if($count === 2){
                if($arr[0] > 23 || $arr[1] > 59){
                    $valueField = '23:59';
                }
            }
        }
        
        switch (strlen($valueField)) {
            case 0:

                break;
            case 1:
                $valueField = '0' . $valueField . ':00';
                break;
            case 2:
                $valueField0 = str_split($valueField, 1);

                if ($valueField0[0] == '0') {
                    $valueField = '0' . $valueField0[1] . ':00';
                } else {
                    $valueField = $valueField0[0] . $valueField0[1] . ':00';
                }
                break;
            case 3:
                $valueField0 = str_split($valueField, 1);
                $valueField = $valueField0[0] . $valueField0[1] . ':00';
                break;
            case 4:
                $valueField0 = str_split($valueField, 1);
                $valueField = $valueField0[0] . $valueField0[1] . ':' . $valueField0[3] . '0';
                break;
        }
        
        if($valueField == '24:00'){
            $valueField = '23:59';
        }
        
        return $valueField;
    }
    
    public function editBreakTimeUnionOwerwork($value, $field_name, $rule_id){
       
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
            
        $permitted_fields=[
            'overwork_time_to_break',
            
        ];
        if(!in_array($field_name, $permitted_fields)){
            return '<span style="color:red;">Permission denied!</span>';
        }
        
        $final_value=$this->autocompletion($value);
      
        $query = "UPDATE #__union_overworks SET $field_name='$final_value' WHERE `id`='$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $final_value;
    }
    
    public function setEarnMinutesCheckbox($id, $mode, $rule_id)
    {
        $permitted_fields=[
            'earn_min_all_days',
            'earn_min_work_days'
        ];
        if(!in_array($id, $permitted_fields)){
            throw new Exception('enter correct id!');
        }
        
        $query = "UPDATE #__subrules_minutes SET `checkbox_all_days`='0', `checkbox_work_days`='0' WHERE `id`='".$rule_id."'";
        $this->db->setQuery($query);
        $this->db->query();

        $item = new stdClass();
        $item->id = $rule_id;
        switch($id){
            case 'earn_min_all_days':
                $item->checkbox_all_days=$mode;
                break;
            case 'earn_min_work_days':
                $item->checkbox_work_days=$mode;   
                break;
        }
      
        $this->db->updateObject('#__subrules_minutes', $item, 'id');
    }
    
    public function setEarnMinutesCheckboxWeek($id, $mode, $rule_id)
    {
        $permitted_fields = [
            'earn_min_all_days',
            'earn_min_work_days'
        ];
        if(!in_array($id, $permitted_fields)){
            throw new Exception('enter correct id!');
        }
        
        $query = "UPDATE #__subrules_minutes_week SET `checkbox_all_days`='0', `checkbox_work_days`='0' WHERE `id`='".$rule_id."'";
        $this->db->setQuery($query);
        $this->db->query();

        $item = new stdClass();
        $item->id = $rule_id;
        switch($id){
            case 'earn_min_all_days':
                $item->checkbox_all_days=$mode;
                break;
            case 'earn_min_work_days':
                $item->checkbox_work_days=$mode;   
                break;
        }
      
        $this->db->updateObject('#__subrules_minutes_week', $item, 'id');
    }
    
    public function getTableLoops4() {
        $user = $this->user;
        $date = date('Y-m-d');

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups) || in_array(10, $user->groups)) {
            $id_user = @$user->owner_id;
        }

        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
            $query = "SELECT * FROM #__loop4_parent WHERE `user_id` = '$id_user' AND `is_default_rule` = '1' ORDER BY `id` ASC";
        } else{
            $query = "SELECT * FROM #__loop4_parent WHERE `user_id` = '$id_user' ORDER BY `id` ASC";
        }
        
        $db = & JFactory::getDBO();
        $db->setQuery($query);
        $data = $db->loadObjectList();



        return $data;
    }
    
    public function addOneLoop4() {
        $ids = [];

        $item = new stdClass();
        $item->user_id = $this->user->id;
        $item->loop_start_date=date('d.m.Y');
        
        $enable_default_rules_status = AuditController::getDefaultRuleStatus($this->user->company);
        if($enable_default_rules_status === 1){
           $item->is_default_rule = 1;
        }
        
        $this->db->insertObject('#__loop4_parent', $item);
        $parent_id = $this->db->insertid();

        for($ia=0; $ia<=3; $ia++){
            $day = 1;
            for ($i = 1; $i <= 7; $i++) {
                $item = new stdClass();
                $item->id_user = $this->user->id;
                $item->date = date('Y-m-d');
                $item->parent_id = $parent_id;
            
                $item->week=$ia+1;
            
                if ($day <= 5) {
                    $item->day = $day;
                } elseif ($day == 6) {
                    $item->day = 'weekends';
                } else {
                    $item->day = 'holidays';
                }

                $this->db->insertObject('#__audit_loops4', $item);
                $id = $this->db->insertid();

                $ids[] = $id;
                $day++;
            }
        }

        $item = new stdClass();
        $item->id = $parent_id;
        $item->child_ids = implode(',', $ids);

        $this->db->updateObject('#__loop4_parent', $item, 'id');
        
        return $parent_id;
    }
    
    public function getOneLoop4($loop_id) {
        $final_array = [];
        $loop_id = (int) $loop_id;
        $query = "SELECT * FROM #__loop4_parent WHERE `id`='$loop_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadObject();

        $query = "SELECT * FROM #__audit_loops4 WHERE `parent_id`='$loop_id' AND `id_user`='" . $this->user->id . "' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $childern = $this->db->loadObjectList();
        

        $final_array = [
            'parent_row' => $data,
            'child_rows' => $childern
        ];

        return (object) $final_array;
    }
    
    public function updateTableWithLoops4() {
        $user = JFactory::getUser();
        $db = & JFactory::getDBO();

        $idField = $_POST['id'];
        $valueField = $_POST['value'];

        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];
        $id_user = $idField[2];
        $date = date('Y-m-d');
        
        $final_value=$this->autocompletion($valueField);
        
        $query = "UPDATE #__audit_loops4 SET $field='$final_value' WHERE `id`='$id'";
        $db->setQuery($query);
        if ($db->query()) {
            echo $final_value;
        }
    }
    
    public function editBreakTimeWithLoops4($input) {
        //$this->addLogString($input, 'global_log.txt');
        
        $idField = $input['id'];
        $valueField = $input['value'];
        //$mode=$_POST['mode'];


        $idField = explode('-', $idField);
        $field = $idField[0];
        $id = $idField[1];


        $date = date('Y-m-d');
        
        $final_value=$this->autocompletion($valueField);
        
        $query = "UPDATE #__audit_loops4 SET $field='$final_value' WHERE `id`='$id'";
        $this->db->setQuery($query);
        
        //return $query;
        if ($this->db->query()) {
           // return $query;
            return $final_value;
        }
    }
    
    public function setLoop4Start($date, $parent_id)
    {
        $item = new stdClass();
        $item->id = $parent_id;
        $item->loop_start_date=$date;
      
        $this->db->updateObject('#__loop4_parent', $item, 'id');
    }
    
    public function updateHeaderLoop4Text($value, $field_name, $rule_id, $lang)
    {
        $field_name=$this->db->escape($field_name);
        $value=$this->db->escape($value);
        $lang=$this->db->escape($lang);
        
        $query = "SELECT * FROM #__audit_loop4_texts WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
        $this->db->setQuery($query);
        $data = $this->db->loadObject();
        
        if(empty($data)){
            $item = new stdClass();
            $item->rule_id=$rule_id;
            $item->lang=$lang;
            $item->$field_name=$value;
            
            $this->db->insertObject('#__audit_loop4_texts', $item);
        } else{
            $query = "UPDATE #__audit_loop4_texts SET $field_name='$value' WHERE `rule_id`='$rule_id' AND `lang`='$lang'";
            $this->db->setQuery($query);
            $this->db->query(); 
        }
        
       
        return $value;
    }
    
    public function getToBreakInfoLoop4($rule_id, $rule_type) {
        $user = $this->user;
        $date = date('Y-m-d');
        $rule_id = (int) $rule_id;
        $rule_association = [
            'day_break_time' => 'day_time_to_break',
            'after_hours_break_time' => 'after_hours_time_to_break',
            'night_time_break_time' => 'night_time_time_to_break',
            'overtime_work_break_time' => 'overtime_work_time_to_break',
            'public_holidays_break_time' => 'public_holidays_time_to_break',
            'day_time_end'=>'extra_hours'
        ];

        if (in_array(6, $user->groups)) {
            $id_user = $user->id;
        }

        if (in_array(2, $user->groups)) {
            $id_user = @$user->owner_id;
        }


        $query = "SELECT `$rule_association[$rule_type]`  FROM #__audit_loops4 WHERE `id_user` = '$id_user' AND `id`='$rule_id'";

        $this->db->setQuery($query);
        $data = $this->db->loadResult();
        $output = [
            'name' => $rule_association[$rule_type],
            'value' => $data,
            'id' => $rule_id
        ];

        return json_encode($output);
    }
    
     public function getSelectedLoop4Number($user_id) {
        //here
        $user_with_request = JFactory::getUser($user_id);
        $user_rule_number = $user_with_request->loop4_number;

        if ($user_rule_number == 0) {
            //$user_rule_number=1;
            $mode = 1;
        }

        return json_encode([
            'loop4_number' => $user_rule_number,
            'is_default_value' => $mode
        ]);
    }
    
    public function setLoop4Number($rule_number, $user_id) {

        $this->clearItems($user_id);
        $user_with_request = JFactory::getUser($user_id);

        if ($this->user->owner_id == $user_with_request->owner_id) {
            $query = "UPDATE #__users SET `loop4_number`='$rule_number' WHERE `id`='$user_id'";

            $this->db->setQuery($query);
            return $this->db->query();
        } else {
            return 'error';
        }
    }
    
    public function setLoop4NumberInHome($rule_number, $user_id) 
    {
        $this->clearItems($user_id);
      
        $query = "UPDATE #__users SET `loop4_number`='$rule_number' WHERE `id`='$user_id'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function getPopupHtml($audit_time_wages_info, $lang, $day_number, $date, $cell_name, $user_id, $popup_extra, $tr_class, $daytime_total, $extra_hours, $is_holidays, $ip = null)
    {
        if ($lang === 'is') {
            $lang1 = & JFactory::getLanguage();
            $lang1->setLanguage('is-IS');
            $lang1->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang1->load($extension, $base_dir, $language_tag, $reload);
        }
        
        $html = '<div class="pay_period_info_popup_content">';
            //$html.='<h3>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_CELL').'</h3>';
          
            
          
            switch($cell_name){
                /*case 'start':
                    unset($html);
                    $html = '<div class="pay_period_info_popup_content">';
                    $html .= 'dd';
                 
                break;*/
                case 'daytime':
                      $html .=  '
                <p>
                    <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_MODE').'</strong>'.$this->getModeName($audit_time_wages_info['mode'], $lang).'  
                </p>';
                       if($audit_time_wages_info['mode']!=='default'){
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_DAYTIME_START').'</strong> '.$audit_time_wages_info['result']->day_time_start.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_DAYTIME_END').'</strong> '.$audit_time_wages_info['result']->day_time_end.'
                                    </p>';
                            }
                        } else{
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_DAYTIME_START').'</strong> '.$audit_time_wages_info['result'][0]->day_time.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_DAYTIME_END').'</strong> '.$audit_time_wages_info['result'][1]->day_time.'
                                    </p>';
                            }
                        }
                break;
                case 'afterwork':  $html .=  '
                <p>
                    <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_MODE').'</strong>'.$this->getModeName($audit_time_wages_info['mode'], $lang).'  
                </p>';
                       if($audit_time_wages_info['mode']!=='default'){
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_AFTERHOURS_START').'</strong> '.$audit_time_wages_info['result']->after_hours_start.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_AFTERHOURS_END').'</strong> '.$audit_time_wages_info['result']->after_hours_end.'
                                    </p>';
                            }
                        } else{
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_AFTERHOURS_START').'</strong> '.$audit_time_wages_info['result'][0]->after_hours.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_AFTERHOURS_END').'</strong> '.$audit_time_wages_info['result'][1]->after_hours.'
                                    </p>';
                            }
                        }
                break;
                case 'night':
                      $html .=  '
                <p>
                    <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_MODE').'</strong>'.$this->getModeName($audit_time_wages_info['mode'], $lang).'  
                </p>';
                       if($audit_time_wages_info['mode']!=='default'){
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_NIGHT_TIME_START').'</strong> '.$audit_time_wages_info['result']->night_time_start.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_NIGHT_TIME_END').'</strong> '.$audit_time_wages_info['result']->night_time_end.'
                                    </p>';
                            }
                        } else{
                            if($day_number!=6 && $day_number!=7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_NIGHT_TIME_START').'</strong> '.$audit_time_wages_info['result'][0]->night_time.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_NIGHT_TIME_END').'</strong> '.$audit_time_wages_info['result'][1]->night_time.'
                                    </p>';
                            }
                        }
                break;
                case 'weekends':
                      $html .=  '
                <p>
                    <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_MODE').'</strong>'.$this->getModeName($audit_time_wages_info['mode'], $lang).'  
                </p>';
                       if($audit_time_wages_info['mode']!=='default'){
                            if($day_number==6 || $day_number==7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_WEEKENDS_START').'</strong> '.$audit_time_wages_info['result']->overtime_work_start.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_WEEKENDS_END').'</strong> '.$audit_time_wages_info['result']->overtime_work_end.'
                                    </p>';
                            }
                        } else{
                            if($day_number==6 || $day_number==7 && $is_holidays!='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_WEEKENDS_START').'</strong> '.$audit_time_wages_info['result'][0]->overtime_work.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_WEEKENDS_END').'</strong> '.$audit_time_wages_info['result'][1]->overtime_work.'
                                    </p>';
                            }
                        }
                break;
                case 'holidays':  $html .=  '
                <p>
                    <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_MODE').'</strong>'.$this->getModeName($audit_time_wages_info['mode'], $lang).'  
                </p>';
                       if($audit_time_wages_info['mode']!=='default'){
                            if($is_holidays=='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_HOLIDAYS_START').'</strong> '.$audit_time_wages_info['result']->public_holidays_start.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_HOLIDAYS_END').'</strong> '.$audit_time_wages_info['result']->public_holidays_end.'
                                    </p>';
                            }
                        } else{
                            if($is_holidays=='1'){
                                $html.= '
                                    <p> 
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_HOLIDAYS_START').'</strong> '.$audit_time_wages_info['result'][0]->public_holidays.'
                                    </p>
                                    <p>
                                        <strong>'.JText::_('COM_AUDIT_PAY_PERIOD_POPUP_HOLIDAYS_END').'</strong> '.$audit_time_wages_info['result'][1]->public_holidays.'
                                    </p>';
                            }
                        }
                break;
            }
            
            if ($cell_name !== 'start' && $cell_name !== 'end') {
                $day_name = $this->getDayExtend($day_number, $lang);
                $html .= '
                    <p>
                        <strong>' . JText::_('COM_AUDIT_PAY_PERIOD_POPUP_DAY_NAME') . '</strong> ' . $day_name . '
                    </p>';

                if ($audit_time_wages_info['mode'] === 'loop') {
                    $html .= '
                        <p>
                            <strong>' . JText::_('COM_AUDIT_PAY_PERIOD_POPUP_WEEK') . '</strong> ' . $this->getWeekNumber($user_id, $date) . '
                        </p>';
                }
            }
            if($cell_name === 'start' && !empty($ip)){ 
                unset($html);
                $html = '<div class="pay_period_info_popup_content">';
                    $html .= '
                        <p>
                            <strong>' . JText::_('COM_AUDIT_NEW_PAY_PERIOD_POPUP_IP_START') . '</strong>' . $ip . '
                        </p>';
                $html .= '</div>';
            } if($cell_name === 'end' && !empty($ip)){ 
                unset($html);
                $html = '<div class="pay_period_info_popup_content">';
                    $html .= '
                        <p>
                            <strong>' . JText::_('COM_AUDIT_NEW_PAY_PERIOD_POPUP_IP_STOP') . '</strong>' . $ip . '
                        </p>';
                $html .= '</div>';
            }
            //start new feature 8 hours
            /*if($popup_extra==1 && $tr_class !='weekend_days' && $daytime_total && $extra_hours!=='00:00'){
                $html.= '
                    <p>
                        <strong>'.JText::_('COM_AUDIT_TIME_CARD_EXTRA_POPUP0').'</strong> '.$extra_hours.'
                    </p>';
             } //end code 8 hours*/
            
        $html.='</div>'; 
        
        return $html;
    }
    
    public function setEarnMinutesStatus($status, $minutes_row_id)
    {
        $item = new stdClass();
        $item->id = $minutes_row_id;
        $item->is_enable = $status;

        return $this->db->updateObject('#__subrules_minutes', $item, 'id');
    }
    
    public function setEarnMinutesStatusWeek($status, $minutes_row_id)
    {
        $item = new stdClass();
        $item->id = $minutes_row_id;
        $item->is_enable = $status;

        return $this->db->updateObject('#__subrules_minutes_week', $item, 'id');
    }
    
    public function getDefaultRulesList()
    {
        $standart_rules = $this->getAllDefaultRules();
        $shifts = $this->getAllDefaultShifts();
        $loops = $this->getAllDefaultLoops();
        $monthly_rules = $this->getAllDefaultMonthly();

        $union_enable = $this->config->get('enable_new_rule');
                        
        if($union_enable == '1'){ 
            $union_rules = $this->getAllDefaultUnions(); 
        }
                                    
        $enable_loop_4_weeks_rule = $this->config->get('enable_loop_4_weeks_rule');
                        
        if($enable_loop_4_weeks_rule == '1'){
           $loops4_weeks = $this->getAllDefaultLoops4(); 
        }
        
        return [
            'standart_rules' => $standart_rules,
            'shifts' => $shifts, 
            'loops' => $loops,
            'monthly' => $monthly_rules,
            'unions' => $union_rules,
            'loops4' =>$loops4_weeks
        ];
    }
    
    private function getAllDefaultRules() 
    {
        $query = "SELECT * FROM #__audit_time_wages_with_rules WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    private function getAllDefaultShifts()
    {
        $query = "SELECT * FROM #__shift_parent WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    private function getAllDefaultLoops()
    {
        $query = "SELECT * FROM #__loop_parent WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    private function getAllDefaultMonthly()
    {
        $query = "SELECT * FROM #__audit_spec_rules WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    private function getAllDefaultUnions()
    {
        $query = "SELECT * FROM #__audit_rules0 WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    private function getAllDefaultLoops4()
    {
        $query = "SELECT * FROM #__loop4_parent WHERE `is_default_rule` = '1' ORDER BY `id` ASC";
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();

        return $data;
    }
    
    public function getSubrulesTrue($parent_rule, $type) 
    {
        $data = [];
        
        switch($type){
            case 'new_part':
                $query = "SELECT * FROM #__subrules_new_part WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->id."'";
                $this->db->setQuery($query);
                $data = $this->db->loadObjectList();
            break;
        }
        
        
        return $data;
    }
    
    public function addSubrules($parent_rule, $lang0, $type)
    {
        $lang = $this->lang;
        if($lang0 === 'is'){
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }
        
        switch($type){
            case 'new_part':
                $rule_info = [
                    [
                        'rule_name'=>'',
                        'days'=>'2',
                        'hours'=>'100'
                    ],
                    
                ];
                
                $i=0;
                //for($i=0; $i<1; $i++){
                    $item = new stdClass();
                    $item->rule_name = $rule_info[$i]['rule_name'];
                    $item->days = $rule_info[$i]['days'];
                    $item->hours = $rule_info[$i]['hours'];
            
                    $item->date_create = date('d.m.Y H:i:s');
                    $item->timestamp_create = time();
                    $item->manager_id = $this->user->id;
                    $item->parent_rule_id = (int)$parent_rule;
                    $item->lang = $this->db->escape($lang0);
            
                    $this->db->insertObject('#__subrules_new_part', $item);
            break;
        }

    
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res='0';
            
        switch($type){
            case 'edit_subrules_part':
                $config = JFactory::getConfig();
                $enable_new_part_union = $config->get('enable_new_part_union');
                
               
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0 && $enable_new_part_union == '1'){
                    $res = '1';
                } 
            break;
            case 'edit_shift_union_limit':
                $config = JFactory::getConfig();
                //$enable_new_part_union = $config->get('enable_new_part_union');
                
               
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'cloneRule':
                $config = JFactory::getConfig();
                //$enable_new_part_union = $config->get('enable_new_part_union');
                
               
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setHolidayPercent':
                $config = JFactory::getConfig();
                //$enable_new_part_union = $config->get('enable_new_part_union');
                
               
                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setSeparateWeekendsStatus':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setNewTimeForBreak':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setLimitAsOvertime':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setNewTimeLimit':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setLimitAsOvertimeCheckboxes':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
            case 'setEarnMinutesNew':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user; 
                
                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";     
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();
                
                //if user is in current manager
                if($user_joomla->owner_id == $owner_id && $user->id > 0){
                    $res = '1';
                } 
            break;
        }
      
       
       return $res;
    }
    
    public function updateShiftUnionLimit($user_id, $parent_shift_id, $value)
    {
        $final_value = $this->db->escape($this->autocompletion($value));
        
        $query = "UPDATE #__audit_shifts SET `aw_limit` = '".$final_value."' WHERE `parent_id` = '$parent_shift_id' AND `id_user`='$user_id'";
        $this->db->setQuery($query);
        $this->db->query();  
        
        return $final_value;
    }
    
    public function updateSubrulesFields($value, $field_name, $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $value = $this->db->escape($value);
            
        $permitted_fields=[
            'rule_name',
            'days',
            'hours'
        ];
        
        if(!in_array($field_name, $permitted_fields)){
            throw new Exception(JText::_('COM_AUDIT_RULES_ERROR_PERM_NOT_PERMITTED_ID'));
        }
        
        if($field_name == 'minutes'){
            $value = (int)$value;
        }
        
        $query = "UPDATE #__subrules_new_part SET $field_name = '$value' WHERE `id` = '$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $value;
    }
    
    public function getHolidayPercent(int $parent_rule, $owner_id = null)
    {
        if(empty($owner_id)){
            $query = "SELECT * FROM #__union_rule_holiday_percent WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$this->user->owner_id."'";
        } else{
            $query = "SELECT * FROM #__union_rule_holiday_percent WHERE `parent_rule_id`='$parent_rule' AND `manager_id`='".$owner_id."'";
        }
       
        $this->db->setQuery($query);
        $data = $this->db->loadObjectList();
        return $data;
    }
    
    public function addDefaultHolidayPercent(int $parent_rule, string $lang0) {
        $lang = $this->lang;
        if ($lang0 === 'is') {
            $lang->setLanguage('is-IS');
            $lang->load();
            $extension = 'com_audit';
            $base_dir = JPATH_SITE;
            $language_tag = 'is-IS';
            $reload = true;
            $lang->load($extension, $base_dir, $language_tag, $reload);
        }

     
        $item = new stdClass();
        $item->id = null;
        $item->manager_id = $this->user->owner_id;
        $item->parent_rule_id = $parent_rule; 
        $item->date_create = date('d.m.Y H:i:s');
        $item->timestamp_create = time();
        $item->no_holiday = 1;
        $item->no_holiday_val = 10.17;
        
        $item->{'24_days_chk'} = 0;
        $item->{'24_days_val'} = 10.17;
        $item->{'25_days_chk'} = 0;
        $item->{'25_days_val'} = 10.64;
        $item->{'27_days_chk'} = 0;
        $item->{'27_days_val'} = 11.59;
        $item->{'days_29_chk'} = 0;
        $item->{'days_29_val'} = 12.55;
        $item->{'30_days_chk'} = 0;
        $item->{'30_days_val'} = 13.04;
        
        $this->db->insertObject('#__union_rule_holiday_percent', $item);
   
    }
    
    private function getDbFieldByHtmlId(string $checkbox_id): string
    {
        $arr = [
            'va_off' => 'no_holiday',
            'checkbox_24' => '24_days_chk',
            'checkbox_25' => '25_days_chk',
            'checkbox_27' => '27_days_chk',
            'checkbox_29' => 'days_29_chk',
            'checkbox_30' => '30_days_chk'
        ];
        
        return $arr[$checkbox_id];
    } 
    
    private function getAvailableDbFieldForHolidayPercent(string $except): array
    {
        $arr = [
            //'no_holiday',
            '24_days_chk',
            '25_days_chk',
            '27_days_chk',
            'days_29_chk',
            '30_days_chk'
        ];
        
        unset($arr[$except]);
      
        return $arr;
    }
    
    private function zeroingOldHolidayPercent(string $db_id_by_checkbox_id, int $parent_id)
    {
        $available_fields = $this->getAvailableDbFieldForHolidayPercent($db_id_by_checkbox_id);
        
        $query = "UPDATE #__union_rule_holiday_percent SET ";
        
        foreach($available_fields as $one_field){
            $query .= "`$one_field` = '0', ";
        }
        $query = chop($query, ' ,');
        $query.= " WHERE `parent_rule_id` = '$parent_id' AND `manager_id` = '" . $this->user->owner_id . "'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function setHolidayPercent(int $parent_id, string $checkbox_id, string $value)
    {
        $db_id_by_checkbox_id = $this->getDbFieldByHtmlId($checkbox_id);

        if($value == 'true'){
            $value = 1;
        } else{
            $value = 0;
        }
        if($db_id_by_checkbox_id != 'no_holiday'){
            $this->zeroingOldHolidayPercent($db_id_by_checkbox_id, $parent_id);
        }
        $query = "UPDATE #__union_rule_holiday_percent SET `$db_id_by_checkbox_id` = '$value' WHERE `parent_rule_id` = '$parent_id' AND `manager_id` = '" . $this->user->owner_id . "'";
        $this->db->setQuery($query);
        return $this->db->query(); 
    }
    
    public function setSeparateWeekendsStatus(int $rule_id, string $lang, int $status)
    {
        $query = "UPDATE #__audit_rules0 SET `separate_weekend` = '" . $this->db->escape($status) . "' WHERE `id` = '" . $this->db->escape($rule_id) . "'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    
    public function setNewTimeForBreak(int $rule_id, string $lang, $value, string $type_of_rule)
    {
        //$final_value = $this->autocompletion($value);
        if($type_of_rule === 'union'){
            $table = '#__subrules_minutes';
        } elseif($type_of_rule === '1_week'){
            $table = '#__subrules_minutes_week';
        }
        
        $query = "UPDATE $table SET `new_time_for_break` = '" . $value . "' WHERE `id`='" . $rule_id . "'";
        $this->db->setQuery($query);
        if($this->db->query()){
            return $value;
        }
    }
    
    public function setEarnMinutesCheckboxNew(string $id, array $states, int $rule_id, int $minutes_row_id) {
        $permitted_fields = [
            'earn_min_all_days',
            'earn_min_work_days'
        ];
        
        if (!in_array($id, $permitted_fields)) {
            throw new Exception('Enter correct id!');
        }
        
        $query = "UPDATE #__subrules_minutes SET `checkbox_all_days`='0', `checkbox_work_days`='0' WHERE `id`='" . $rule_id . "'";
        $this->db->setQuery($query);
        $this->db->query();
        
        if($states[0]['state'] == 'false' && $states[1]['state'] == 'false'){
            return $this->setEarnMinutesStatus(0, $minutes_row_id);//disable hidden Collect min. pr. day checkbox
        }

        $item = new stdClass();
        $item->id = $rule_id;
        
        $this->setEarnMinutesStatus(1, $minutes_row_id);//enable hidden Collect min. pr. day checkbox
        if($states[0]['state'] == 'true' && $states[1]['state'] == 'false'){
            $item->checkbox_all_days = '1';
        } elseif($states[0]['state'] == 'false' && $states[1]['state'] == 'true'){
            $item->checkbox_work_days = '1';
        }

        $this->db->updateObject('#__subrules_minutes', $item, 'id');
    }

    public function setLimitAsOvertime(string $status, string $lang, int $rule_id) {
        
        if($status === 'true'){
            $status = 1;
        } else{
            $status = 0;
        }
        
        $query = "UPDATE #__subrules_minutes SET `limit_for_total_hours_state` = '$status' WHERE `parent_rule_id` = '" . $rule_id . "' AND `manager_id` = '" . $this->user->owner_id . "'";
        $this->db->setQuery($query);
        $this->db->query(); 
    }
    
    public function setNewTimeLimit(int $rule_id, string $lang, $value, string $type_of_rule)
    {
        //$final_value = $this->autocompletion($value);
        if($type_of_rule === 'union'){
            $table = '#__subrules_minutes';
        } elseif($type_of_rule === '1_week'){
            $table = '#__subrules_minutes_week';
        }
        
        $query = "UPDATE $table SET `new_limit` = '" . $value . "' WHERE `id`='" . $rule_id . "'";
        $this->db->setQuery($query);
        if($this->db->query()){
            return $value;
        }
    }
    
    public function setLimitAsOvertimeCheckboxes(string $id, array $states, int $rule_id, int $minutes_row_id) {
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/prefill.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
        $permitted_fields = [
            'limit_as_overtime',
            'limit_as_overtime2'
        ];
        
        if (!in_array($id, $permitted_fields)) {
            throw new Exception(JText::_('COM_AUDIT_NEW_UNION_RULES_SET_LIMIT_AS_OVERTIME_CHECKBOXES_ERROR_EMPTY_ID'));
        }
        
        $query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='0', `limit_as_overtime2`='0' WHERE `id`='" . $rule_id . "'";
        $this->db->setQuery($query);
        $this->db->query();
        
        /*if($states[0]['state'] == 'false' && $states[1]['state'] == 'false'){
            return $this->setEarnMinutesStatus(0, $minutes_row_id);//disable hidden Collect min. pr. day checkbox
        }*/

        $item = new stdClass();
        $item->id = $rule_id;
        
        $this->setEarnMinutesStatus(1, $minutes_row_id);//enable hidden Collect min. pr. day checkbox
        if($states[0]['state'] == 'true' && $states[1]['state'] == 'false'){
            $item->limit_as_overtime = '1';
        } elseif($states[0]['state'] == 'false' && $states[1]['state'] == 'true'){
            $item->limit_as_overtime2 = '1';
        }

        $this->db->updateObject('#__subrules_minutes', $item, 'id');
    }
    
    public function setEarnMinutesStatusWeekNew(string $id, array $states, int $rule_id, int $minutes_row_id) {
        $permitted_fields = [
            'earn_min_all_days',
            'earn_min_work_days'
        ];
        
        if (!in_array($id, $permitted_fields)) {
            throw new Exception('Enter correct id!');
        }
        
        $query = "UPDATE #__subrules_minutes_week SET `checkbox_all_days`='0', `checkbox_work_days`='0' WHERE `id`='" . $rule_id . "'";
        $this->db->setQuery($query);
        $this->db->query();
        
        if($states[0]['state'] == 'false' && $states[1]['state'] == 'false'){
            return $this->setEarnMinutesStatusWeek(0, $minutes_row_id);//disable hidden Collect min. pr. day checkbox
        }

        $item = new stdClass();
        $item->id = $rule_id;
        
        $this->setEarnMinutesStatusWeek(1, $minutes_row_id);//enable hidden Collect min. pr. day checkbox
        if($states[0]['state'] == 'true' && $states[1]['state'] == 'false'){
            $item->checkbox_all_days = '1';
        } elseif($states[0]['state'] == 'false' && $states[1]['state'] == 'true'){
            $item->checkbox_work_days = '1';
        }

        $this->db->updateObject('#__subrules_minutes_week', $item, 'id');
    }
    
    public function setEarnMinutesNew($value, string $type_of_rule, string $lang, int $rule_id)
    {
        $field_name = $this->db->escape($field_name);
        $final_value = $this->db->escape($this->autocompletion($value));

        $table = '#__subrules_minutes';
        if($type_of_rule == 'one_week'){
            $table = '#__subrules_minutes_week';
        }

        $query = "UPDATE $table SET `minutes` = '$final_value' WHERE `id` = '$rule_id'";
        $this->db->setQuery($query);
        $this->db->query(); 

        return $final_value;
    }
    
    public function prefillRule(string $lang, int $rule_id, string $type_of_rule, int $value, int $subrules_id)
    {
	
        switch($type_of_rule){
            case 'union':
                switch($value){
                    case 1:
                        $query = "UPDATE #__audit_rules0 SET `rule_name` = '" . JText::_('COM_AUDIT_RULE_NEW_PREFILL-1') . "', `day_time_start` = '08:00', `day_time_end` = '18:00', `after_hours_start` = '18:00', `after_hours_end` = '00:00', `night_time_start` = '00:00', `night_time_end` = '08:00', `extra_hours` = '07:15' WHERE `id`='" . $rule_id . "' AND `id_user` = ".$this->user->owner_id;
                        $this->db->setQuery($query);
                        $this->db->query();
                        
                        $this->setNewTimeLimit($subrules_id, $lang, '157:08', 'union');
                        
                        $this->setEarnMinutesStatus(1, $subrules_id);//enable hidden Collect min. pr. day checkbox
                        $query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='0', `limit_as_overtime2`='1' WHERE `id`='" . $subrules_id . "'";
                        $this->db->setQuery($query);
                        $this->db->query();

                        $this->setHolidayPercent($rule_id, 'va_off', 'false');
                        $this->setHolidayPercent($rule_id, 'checkbox_27', 'true');
                    break;
                    case 2:
                        $query = "UPDATE #__audit_rules0 SET `rule_name` = '" . JText::_('COM_AUDIT_RULE_NEW_PREFILL-2') . "', `day_time_start` = '07:00', `day_time_end` = '17:00', `after_hours_start` = '17:00', `after_hours_end` = '07:00', `night_time_start` = '00:00', `night_time_end` = '00:00', `extra_hours` = '08:00' WHERE `id`='" . $rule_id . "' AND `id_user` = ".$this->user->owner_id;
                        $this->db->setQuery($query);
                        $this->db->query();
                        
                        $this->setNewTimeLimit($subrules_id, $lang, '173:33', 'union');
                        
                        $this->setEarnMinutesStatus(1, $subrules_id);//enable hidden Collect min. pr. day checkbox
                        $query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='1', `limit_as_overtime2`='0' WHERE `id`='" . $subrules_id . "'";
                        $this->db->setQuery($query);
                        $this->db->query();

                        $this->setHolidayPercent($rule_id, 'va_off', 'false');
                        $this->setHolidayPercent($rule_id, 'checkbox_24', 'true');
                    break;
                    case 3:
                        $query = "UPDATE #__audit_rules0 SET `rule_name` = '" . JText::_('COM_AUDIT_RULE_NEW_PREFILL-3') . "', `day_time_start` = '09:00', `day_time_end` = '18:00', `after_hours_start` = '18:00', `after_hours_end` = '00:00', `night_time_start` = '00:00', `night_time_end` = '09:00', `extra_hours` = '07:17' WHERE `id`='" . $rule_id . "' AND `id_user` = ".$this->user->owner_id;
                        $this->db->setQuery($query);
                        $this->db->query();
                         
                        $this->setEarnMinutesStatus(1, $subrules_id);//enable hidden Collect min. pr. day checkbox
                        $query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='0', `limit_as_overtime2`='0' WHERE `id`='" . $subrules_id . "'";
                        $this->db->setQuery($query);
                        $this->db->query();

                        $this->setHolidayPercent($rule_id, 'va_off', 'false');
                        $this->setHolidayPercent($rule_id, 'checkbox_24', 'true');
                    break;
                    case 4:
                        $query = "UPDATE #__audit_rules0 SET `rule_name` = '" . JText::_('COM_AUDIT_RULE_NEW_PREFILL-4') . "', `day_time_start` = '07:00', `day_time_end` = '18:00', `after_hours_start` = '18:00', `after_hours_end` = '07:00', `night_time_start` = '00:00', `night_time_end` = '00:00', `extra_hours` = '07:25', `aw_limit` = '17:33' WHERE `id`='" . $rule_id . "' AND `id_user` = ".$this->user->owner_id;
                        $this->db->setQuery($query);
                        $this->db->query();
                        
                        $this->setNewTimeLimit($subrules_id, $lang, '160:00', 'union');
                        
                        $this->setEarnMinutesStatus(1, $subrules_id);//enable hidden Collect min. pr. day checkbox
                        $query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='0', `limit_as_overtime2`='1' WHERE `id`='" . $subrules_id . "'";
                        $this->db->setQuery($query);
                        $this->db->query();

                        $this->setHolidayPercent($rule_id, 'va_off', 'false');
                        $this->setHolidayPercent($rule_id, 'checkbox_24', 'true');
                        
                        
                        $this->updateHeaderRule0Text('Yfirv.1', 'after_hours_text', $rule_id, 'is');
                        $this->updateHeaderRule0Text('Overt.1', 'after_hours_text', $rule_id, 'en');
                        $this->updateHeaderRule0Text('Yfirv.2', 'night_time_text', $rule_id, 'is');
                        $this->updateHeaderRule0Text('Overt.2', 'night_time_text', $rule_id, 'en');
                    break;
                    case 5:
                        $query = "UPDATE #__audit_rules0 SET `rule_name` = '" . JText::_('COM_AUDIT_RULE_NEW_PREFILL-5') . "', `day_time_start` = '07:00', `day_time_end` = '17:00', `after_hours_start` = '17:00', `after_hours_end` = '23:59', `night_time_start` = '00:00', `night_time_end` = '07:00', `extra_hours` = '08:00' WHERE `id`='" . $rule_id . "' AND `id_user` = ".$this->user->owner_id;
                        $this->db->setQuery($query);
                        $this->db->query();
                        
                        $this->setNewTimeLimit($subrules_id, $lang, '172:00', 'union');
                        
                        $this->setEarnMinutesStatus(1, $subrules_id);//enable hidden Collect min. pr. day checkbox
                        /*$query = "UPDATE #__subrules_minutes SET `limit_as_overtime`='1', `limit_as_overtime2`='0' WHERE `id`='" . $subrules_id . "'";
                        $this->db->setQuery($query);
                        $this->db->query();*/

                        $this->setHolidayPercent($rule_id, 'va_off', 'false');
                        $this->setHolidayPercent($rule_id, 'checkbox_24', 'true');
                        
                        $this->updateHeaderRule0Text('Yfirv.33%', 'after_hours_text', $rule_id, 'is');
                        $this->updateHeaderRule0Text('Overt.33%', 'after_hours_text', $rule_id, 'en');
                        
                        $this->updateHeaderRule0Text('Næturv.45%', 'night_time_text', $rule_id, 'is');
                        $this->updateHeaderRule0Text('Night.45%', 'night_time_text', $rule_id, 'en');
                        
                        $this->updateHeaderRule0Text('Helgarv.45%', 'weekends_text', $rule_id, 'is');
                        $this->updateHeaderRule0Text('Weekends 45%', 'weekends_text', $rule_id, 'en');
                    break;
                } 
            break;
        }
    }
    
    public function addPrefilledRules(string $type, string $lang)
    {
        switch($type){
            case 'union':
                for($i = 0; $i<=3; $i++){
                    $rule_id = $this->addOneRule0();
                    $this->addDefaultHolidaysSubrules($rule_id, $lang);   
                    $this->addDefaultSickChildSubrules($rule_id, $lang);
                    $this->addDefaultSubrules($rule_id, $lang);
                    $this->addDefaultSubrulesMinutes($rule_id, $lang);
                    $this->addDefaultHolidayPercent($rule_id, $lang);
                    
                    $subrules_id = $this->getSubrulesIdAsRuleId($rule_id);
                    $this->prefillRule($lang, $rule_id,  $type, $i + 1, $subrules_id);
                    
                    $item = new stdClass();
                    $item->id = $this->user->owner_id;
                    $item->is_added_prefilled_union_rules = 1;
                    $this->db->updateObject('#__users', $item, 'id');
                }
            break;
        }
        
    }
    
    private function getSubrulesIdAsRuleId(int $rule_id)
    {
        #__subrules_minutes
        $query = "SELECT `id` FROM #__subrules_minutes WHERE `parent_rule_id` = '$rule_id' AND `manager_id` = '".$this->user->owner_id."'";
        $this->db->setQuery($query);
        return $this->db->loadObjectList()[0]->id;
    }
}
