<?php
// No direct access
/*ini_set('error_reporting', E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);*/

defined( '_JEXEC' ) or die;

/**

 *@author 

 */
class AuditModelReport extends JModelLegacy{

    public function __construct() { 
        parent::__construct();
        
        $this->db=&JFactory::getDBO();
        $this->app= JFactory::getApplication();
        $this->doc= JFactory::getDocument();
        $this->user = & JFactory::getUser();
        
        $this->work_day_hours=8;
        
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
      
        require_once $this->server_path . '/components/com_audit/assets/incl/PHPMailer-master/PHPMailerAutoload.php';
    }
    
    public function getReportItems($user_id)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        return json_encode($items);
    }
    
    public function createCsvSingleUser($user_id, $display_months, $display_dates)
    {
        $user_info= JFactory::getUser($user_id);
        $unical_string=uniqid();
        $pathFile = JPATH_BASE . DS . 'tpm_csv_report/'.$user_info->name.'_'.$unical_string.'_report.csv';
        $fp = fopen($pathFile, 'w');
        fwrite($fp,b"\xEF\xBB\xBF");//add special iceland symbols
        
        $monts_array=[];
        $dates_array=[];
        $i=0;
        
        $csv_array=[
            [
                'Staff name: '.$user_info->username0
            ]
            
        ];
               
        foreach($display_months as $month){//foreach string calendar headers(December 2017 etc.)            
            $month=str_replace( chr( 194 ) . chr( 160 ), ' ', $month );
            $new_month=preg_split('/\W/u', $month);
            //$new_month=preg_split('/[\s]+/', $month);            
           // $new_month=preg_split('/\\/u00a/u', $month);
            
            $monts_array[$i]['month']= $new_month[0];
            $month_top_level=date('n', strtotime($monts_array[$i]['month'].' '.$monts_array[$i]['year']));
            
            $monts_array[$i]['year']=trim($new_month[1]);
            $year_top_level=$monts_array[$i]['year'];
            
            $csv_array[]=[
                $monts_array[$i]['month']." ".$monts_array[$i]['year'].":"
            ];
            
            $count_green_days1=0;
            $count_yellow_days1=0;
            $count_red_days1=0;
            $count_blue_days1=0;
                     
            $count_green_days1=$this->getReportItemFromMonth($user_id, $month_top_level, $status=1, $year_top_level);
            $count_yellow_days1=$this->getReportItemFromMonth($user_id, $month_top_level, $status=2, $year_top_level);
            $count_red_days1=$this->getReportItemFromMonth($user_id, $month_top_level, $status=3, $year_top_level);
            $count_blue_days1=$this->getReportItemFromMonth($user_id, $month_top_level, $status=4, $year_top_level);
             
            $csv_array[]=[
                'Green: '.$count_green_days1.'/'.$count_green_days1*$this->work_day_hours." hours"
            ];
            $csv_array[]=[
                'Yellow: '.$count_yellow_days1.'/'.$count_yellow_days1*$this->work_day_hours." hours"
            ];
            $csv_array[]=[
                'Red: '.$count_red_days1.'/'.$count_red_days1*$this->work_day_hours." hours"
            ];
            $csv_array[]=[
                'Blue: '.$count_blue_days1.'/'.$count_blue_days1*$this->work_day_hours." hours"
            ];
            
            $csv_array[]=[' '];
            
             
            $i++;                     
        }
             
        foreach ($csv_array as $fields) {
            fputcsv($fp, $fields, ';');
        }       
        fclose($fp);              
        return $pathFile;
    }
    
    public function createCsvManager($user_id)
    {
        $manager_info= JFactory::getUser($user_id);
        $lang =& JFactory::getLanguage();
        if($lang->getName()=="Íslenska (Ísland)"){
            $l = 'is';
        } else{
            $l = 'en';
        }
                      
        if(in_array(8, $manager_info->groups)) {//from admin
            $csv_array=[];
        }
        if(in_array(6, $manager_info->groups)) {//from manager
            $csv_array=[];
            $i=0;
            
            $final_username='';
            if(!empty($manager_info->username0)){ $final_username=$manager_info->username0; } 
            elseif(!empty($manager_info->username)){ $final_username=$manager_info->username; }
            elseif(!empty($manager_info->name)){ $final_username=$manager_info->name; }
                
       
        
            if($l==='is'){
               $pathFile = JPATH_BASE . DS . 'tpm_csv_report_managers/all_user_manager-' . $final_username . '_is_report.csv'; 
            } else{
               $pathFile = JPATH_BASE . DS . 'tpm_csv_report_managers/all_user_manager-' . $final_username . '_en_report.csv';
            }
            
            $fp = fopen($pathFile, 'w');
            fwrite($fp,b"\xEF\xBB\xBF");//add special iceland symbols
            
            $manager_users_object=$this->getUsersFromManager($manager_info->id);//get manager users
            $space='                                                        ';
            
            foreach($manager_users_object as $manager_user){
                $csv_array[]=[
                    'Staff name: '.$manager_user->username0.$space
                ];
                
                $months_array=[
                    "January"=>"janúar",
                    "February"=>"febrúar",
                    "March"=>"mars",
                    "April"=>"apríl",
                    "May"=>"maí",
                    "June"=>"júní",
                    "July"=>"júlí",
                    "August"=>"ágúst",
                    "September"=>"September",
                    "October"=>"október",
                    "November"=>"nóvember",
                    "December"=>"desember"
                ];
                $months_array_new=[];
                
                foreach($months_array as $month_en=>$month_is){
                    $month=date('n.Y', strtotime($month_en.date('Y', strtotime('now'))));
                    $months_array_new[]=$month;
                    
                    $current_year=date('Y', strtotime($month_en.date('Y', strtotime('now'))));
                    $current_month=date('n', strtotime($month_en.date('Y', strtotime('now'))));
                    
                    if($l==='is'){
                        $month_year_string=$month_is." ".$current_year.":".$space; 
                    } else{
                        $month_year_string=$month_en." ".$current_year.":".$space;
                    }              
                    $csv_array[]=[
                        $month_year_string                        
                    ];
                    
                    $report_dates_green=$this->getReportItemFromMonth($manager_user->id, $current_month, $status=1, $current_year);
                    $report_dates_yellow=$this->getReportItemFromMonth($manager_user->id, $current_month, $status=2, $current_year);
                    $report_dates_red=$this->getReportItemFromMonth($manager_user->id, $current_month, $status=3, $current_year);
                    $report_dates_blue=$this->getReportItemFromMonth($manager_user->id, $current_month, $status=4, $current_year);
                    
                    $csv_array[]=[
                        'Green: '.$report_dates_green.'/'.$report_dates_green*$this->work_day_hours." hours".$space
                    ];
                    $csv_array[]=[
                        'Yellow: '.$report_dates_yellow.'/'.$report_dates_yellow*$this->work_day_hours." hours".$space
                    ];
                    $csv_array[]=[
                        'Red: '.$report_dates_red.'/'.$report_dates_red*$this->work_day_hours." hours".$space
                    ];
                    $csv_array[]=[
                        'Blue: '.$report_dates_blue.'/'.$report_dates_blue*$this->work_day_hours." hours".$space
                    ];
                    
                    $csv_array[]=['---------------'.$space];
                }
                
                
               
                
                $csv_array[]=[' '.$space];
                
                $i++;
            }
            
            foreach ($csv_array as $fields) {
                fputcsv($fp, $fields, ';');
            }       
            fclose($fp);
        }
        
        return $pathFile;
    }
    
    public function getReportItemFromMonth($manager_user_id, $current_month, $status, $year)
    {
        $query='SELECT COUNT(id) as count_items FROM #__user_report_items WHERE `id_user`="'.$manager_user_id.'" AND `month`="'.$current_month.'" AND `status`="'.$status.'" AND `year`="'.$year.'"';
        $this->db->setQuery( $query );
        $shedule_items = $this->db->loadObject(); 
        return $shedule_items->count_items;   
    }
    
    public function checkReportItemStatus($user_id, $date_year, $date_month, $date_day)
    {
        $query='SELECT * FROM #__user_report_items WHERE `id_user`="'.$user_id.'"  AND `year`="'.$date_year.'" AND `month`="'.$date_month.'" AND `day`="'.$date_day.'"';
        $this->db->setQuery($query);
        $user_report = $this->db->loadObject();
        //sleep(1);
        return $user_report->status;
    }
    
    public function sendReport($path_to_csv)
    {
       // $config =& JFactory::getConfig();
        $mailer = JFactory::getMailer();
        
        $sender = array('dd', 'dd');        
        $message = "Report";
        $subject = "Report";
               
        $mailer->setSender($sender);
        $mailer->addRecipient('developer3452@gmail.com');
        $mailer->setSubject($subject);
        $mailer->isHTML(TRUE); 
        $mailer->setBody($message);
        $mailer->AddEmbeddedImage( $path_to_csv );
        /*if($mailer->send()){
            //unlink($pathFile);  
        }
        else{
           // unlink($pathFile);  
        }*/
        return $mailer->send();
    }
    
    public function sendReport1($path_to_csv, $user_id)
    {
        $user_info= & JFactory::getUser($user_id);
        $config =& JFactory::getConfig();
        $from = $config->get('mailfrom'); //from
        $from_name = $config->get('fromname'); //from name
        
        $final_username='';
        if(!empty($user_info->username0)){ $final_username=$user_info->username0; } 
        elseif(!empty($user_info->username)){ $final_username=$user_info->username; }
        elseif(!empty($user_info->name)){ $final_username=$user_info->name; }
                
        $subject = "CSV Report ".$final_username; 
        
        
        $mail = new PHPMailer;  
        $mail->CharSet = "UTF-8";
        $mail->setFrom($from, $from_name);
        $mail->Subject = $subject;
        
        if (in_array(8, $user_info->groups) || in_array(6, $user_info->groups)) { //send to admin or manager email, if user is manager or admin
            $mail->addAddress($user_info->email, $user_info->name);
        } else{//send to user manager email if user has user permission
            $owner_id=$user_info->owner_id;
            $owner_info=& JFactory::getUser($owner_id);
            $owner_email=$owner_info->email;
            $owner_name=$owner_info->name;
            $mail->addAddress($owner_email, $owner_name);
        }
        
        $mail->addAddress('developer3452@gmail.com', 'Developer');
        $msg_body = 'Report'; //тело сообщения
        $mail->isHTML(true);
        $mail->msgHTML($msg_body);
        $mail->addAttachment($path_to_csv);       

        $mail->send();
    
        if (in_array(8, $user_info->groups) || in_array(6, $user_info->groups)) {
            return $user_info->email;
        } else{
            return $owner_email;            
        }               
           
    }
    
    public function addOneReportItem($user_id, $date_start, $new_status, $pay_period_input_val)
    {
        $year=date('Y', strtotime($date_start));
        $month=date('n', strtotime($date_start));
        $day=date('j', strtotime($date_start));
        
        $old_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
        
       
        
        if(!empty($old_item_status)){
            $this->updateReportItem($user_id, $new_status, $year, $month, $day);
          
           // return 'update item status';  
            
        } else{            
            $this->insertReportItem($user_id, $new_status, $year, $month, $day);
            
            //return 'add new report item';
            
        }
        $current_year=date('Y');
        $current_month=date('n');
        $current_day=date('j');
        
        if($current_year===$year && $current_month===$month && $current_day===$day){
            $this->updateUserStatusPageStaff($user_id, $new_status); 
        }
        
        //here
        //if(!empty($pay_period_input_val)){
            $this->updatePayPeriodTotal($pay_period_input_val, $date_start, $user_id, 'one_date');
        //}
       
    }
    
    private function getOldTotalsField($user_id, $date)
    {
        $query='SELECT * FROM #__audit_time WHERE `date`="'.$date.'" AND `id_user`="'.$user_id.'"';
        $this->db->setQuery($query);
        $res=$this->db->loadObjectList();
        return $res;
    }
    
    private function updatePayPeriodTotal($pay_period_input_val, $date_start, $user_id, $mode)
    {
        $current_user=JFactory::getUser($user_id);
        
        switch($mode){
            case 'one_date':
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/calendar_update_pp.html', print_r($pay_period_input_val.PHP_EOL, true), FILE_APPEND | LOCK_EX);
                
                if(!empty($pay_period_input_val)){
                    //7=>07:00, 07=>07:00, 07:=>07:00, 07:0=>07:00
                    $valueField=$this->autocompletion($pay_period_input_val);
                   
                    //convert date from calendar
                    $date_obj=DateTime::createFromFormat('d-m-Y', $date_start);

                    $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
                
                    //foreach($old_valueField as $one_date_item){
                        //$valueField=$one_date_item->new_hours;
                        $cell_existing=$this->checkingDateExistingInPayPeriod($date_obj->format('Y-m-d'), $user_id);
                        file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/calendar_update_pp.html', print_r($cell_existing, true), FILE_APPEND | LOCK_EX);
                    
                        //delete filled cell
                        if($valueField=='00:00' && $cell_existing>0){
                            $query="DELETE FROM `#__audit_time` WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."';";
                            $this->db->setQuery($query);
                            $this->db->query();

                            return false;
                        }
                
                        $item = new stdClass;
                        $item->date_logged = $date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:00';
                        $item->date_exit = $date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:01';
                        $item->new_hours = $valueField;
                
                
                        $sick_state=$this->getSickState($current_user->owner_id);
                        if($sick_state!=1){
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        }

                        if($cell_existing>0){
                            $query = "UPDATE #__audit_time SET "
                                // . "`date_logged`='$item->date_logged', "
                                //. "`date_exit`='$item->date_exit', "
                                . "`new_hours`='$item->new_hours' "
                                //. "`new_daytime`='$item->new_daytime', "
                                // . "`daytime_edit`='$item->daytime_edit', "
                                // . "`daytime_edited_date`='$item->daytime_edited_date' "
                                . "WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."'";       
                            $this->db->setQuery($query);
                            $this->db->query();
                        } elseif($cell_existing==0){
                            $item->id_user=$user_id;
                            $item->date=$date_obj->format('Y-m-d');

                            $this->db->insertObject('#__audit_time', $item);
                        }
                    //}
                } else{//empty value
                    //convert date from calendar
                    $date_obj=DateTime::createFromFormat('d-m-Y', $date_start);
               
                    $old_valueField=$this->getOldTotalsField($user_id, $date_obj->format('Y-m-d'));

                    $model = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
                    $sick_state=$this->getSickState($current_user->owner_id);
                    foreach($old_valueField as $one_date_item){
                        $valueField=$one_date_item->new_hours;
                        $cell_existing=$this->checkingDateExistingInPayPeriod($date_obj->format('Y-m-d'), $user_id);
                     
                        //delete filled cell
                        if($valueField=='00:00' && $cell_existing>0){
                            $query="DELETE FROM `#__audit_time` WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."';";
                            $this->db->setQuery($query);
                            $this->db->query();

                            return false;
                        }
                
                        $item = new stdClass;
                        $item->date_logged = $date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:00';
                        $item->date_exit = $date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:01';
                        $item->new_hours = $valueField;

                        if($sick_state!=1){
                            $item->new_daytime = $valueField;
                            $item->daytime_edit='1';
                            $item->daytime_edited_date=date('Y-m-d H:i:s');
                        }

                        if($cell_existing>0){
                            $query = "UPDATE #__audit_time SET "
                                // . "`date_logged`='$item->date_logged', "
                                //. "`date_exit`='$item->date_exit', "
                                . "`new_hours`='$item->new_hours' "
                                //. "`new_daytime`='$item->new_daytime', "
                                // . "`daytime_edit`='$item->daytime_edit', "
                                // . "`daytime_edited_date`='$item->daytime_edited_date' "
                                . "WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."'";       
                            $this->db->setQuery($query);
                            $this->db->query();
                        } elseif($cell_existing==0){
                            $item->id_user=$user_id;
                            $item->date=$date_obj->format('Y-m-d');

                            $this->db->insertObject('#__audit_time', $item);
                        }
                    }
                }
            break;
            case 'many_dates':
                
            break;
        
        }       
    }
    
    private function getSickState($user_id) {
        $u=&JFactory::getUser($user_id);
        return $u->sick_state;
    }
    
    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        if(empty($valueField)){
            return '00:00';
        }
        return $valueField;
    }
    
    private function checkingDateExistingInPayPeriod($date, $user_id)
    {
        $query='SELECT COUNT(*) FROM #__audit_time WHERE `date`="'.$date.'" AND `id_user`="'.$user_id.'"';
        $this->db->setQuery($query);
        $res=$this->db->loadResult();
        file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/calendar_update_pp.html', print_r($query, true), FILE_APPEND | LOCK_EX); 
        
        return $res;
    }
    
    public function removeReportItems($user_id, $date_start, $date_end)
    {
        $year_start=date('Y', strtotime($date_start));
        $month_start=date('n', strtotime($date_start));
        $day_start=date('j', strtotime($date_start));
               
        $date_end = date('d-m-Y', strtotime(date('Y-m-d', strtotime($date_end)).' +1day'));        
        $from = new DateTime($date_start);
        $to   = new DateTime($date_end);
    
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
   
        
        $arrayOfDates = array_map(
            function($item){
                return $item->format('Y.n.j');
            
            },
            iterator_to_array($period)
        );
        foreach($arrayOfDates as $date){
            $date_explode=explode('.', $date);
            $year=$date_explode[0];
            $month=$date_explode[1];
            $day=$date_explode[2];
            
            
            $query = "DELETE FROM #__user_report_items  WHERE `id_user`='".$user_id."' AND `month`='".$month."' AND `year`='".$year."' AND `day`='".$day."'";  
            $this->db->setQuery($query);
            $this->db->query();
            
            $current_date=date('Y.n.j');
            /*$current_year=date('Y');
            $current_month=date('n');
            $current_day=date('j');*/
            
            if($date==$current_date){
                 $this->updateUserStatusPageStaff($user_id, 1);//set green status from current user   
            }
            
            //convert date from calendar
            $date_obj=DateTime::createFromFormat('Y.n.j', $date);
            $cell_existing=$this->checkingDateExistingInPayPeriod($date_obj->format('Y-m-d'), $user_id);
           
            if($cell_existing>0){
                $query='SELECT * FROM #__audit_time WHERE `date`="'.$date.'" AND `id_user`="'.$user_id.'"';
                $this->db->setQuery($query);
                $items=$this->db->loadObjectList();
                
                foreach($items as $item){
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/upd_total.html', print_r($item, true), FILE_APPEND | LOCK_EX); 
                    $date_logged=$date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:00';
                    $date_exit=$date_obj->format('Y-').$date_obj->format('m-').$date_obj->format('d').' 00:00:01';
                    
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/upd_total.html', print_r($date_logged, true), FILE_APPEND | LOCK_EX); 
                    //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/upd_total.html', print_r($date_exit, true), FILE_APPEND | LOCK_EX); 
                    
                    if($item->date_logged == $date_logged  && $item->date_exit == $date_exit 
                        && $item->new_hours!=''){
                            $query="DELETE FROM `#__audit_time` WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."';";
                            $this->db->setQuery($query);
                            $this->db->query();
                        } else{
                            $query = "UPDATE #__audit_time SET `new_hours`='' WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."'";       
                            $this->db->setQuery($query);
                            $this->db->query();
                        }
                }
                
                
                
                
                    
              
                    
                //file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/upd_total.html', print_r($query, true), FILE_APPEND | LOCK_EX); 
               // return false;
            } /*elseif($cell_existing==0){
                $query="DELETE FROM `#__audit_time` WHERE `id_user`='".$user_id."' AND `date`='".$date_obj->format('Y-m-d')."';";
                $this->db->setQuery($query);
                $this->db->query();
           }  */ 
        }
        
        return $arrayOfDates;
    }
    
    public function updateUserStatusPageStaff($user_id, $new_status)
    {
        $query = "UPDATE #__users SET `status_user`='".$new_status."' WHERE `id`='".$user_id."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function insertReportItem($user_id, $status_user, $year, $month, $day)
    {    
        $query = "INSERT INTO #__user_report_items (id_user, status, year, month, day) VALUES ('".$user_id."', '".$status_user."', '".$year."', '".$month."', '".$day."')";    
        $this->db->setQuery($query);	 
        $this->db->query(); 
    }
    
    public function updateReportItem($user_id, $status_user, $year, $month, $day)
    {
        $query = "UPDATE #__user_report_items SET `status`='".$status_user."' WHERE `id_user`='".$user_id."' AND `month`='".$month."' AND `year`='".$year."' AND `day`='".$day."'";
        $this->db->setQuery($query);
        $this->db->query();
    }
    
    public function addReportItems($user_id, $date_start, $date_end, $new_status, $weekend_status, $pay_period_input_val)
    {
        $year_start=date('Y', strtotime($date_start));
        $month_start=date('n', strtotime($date_start));
        $day_start=date('j', strtotime($date_start));
        
        
        $date_end = date('d-m-Y', strtotime(date('Y-m-d', strtotime($date_end)).' +1day'));
        
        $from = new DateTime($date_start);
        $to   = new DateTime($date_end);
        
       // file_put_contents('/home/curiotime/ultima.curiotime.com/logs/weekends.html', print_r($pay_period_input_val.'<br/>', true), FILE_APPEND | LOCK_EX);       
        
  
       
        $period = new DatePeriod($from, new DateInterval('P1D'), $to);
   
        
        $arrayOfDates = array_map(
            function($item){
                return $item->format('Y.n.j');
            
            },
            iterator_to_array($period)
        );
            $dates_array=[];
            
        //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/weekends.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);       
        
        foreach($arrayOfDates as $date){
            if($weekend_status=='1'){//include weekends
                $date_explode=explode('.', $date);
                $year=$date_explode[0];
                $month=$date_explode[1];
                $day=$date_explode[2];
            
                $dates_array[]['status']=$this->checkReportItemStatus($user_id, $year, $month, $day);
                $dates_array[]['day']=$day;
                $dates_array[]['month']=$month;
                $dates_array[]['year']=$year;
                $dates_array[]['typeof']=gettype( $date);
            
                $old_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
                if(!empty($old_item_status)){
                    $this->updateReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'update item status';           
                } else{            
                    $this->insertReportItem($user_id, $new_status, $year, $month, $day);
                    //return 'add new report item';
                }
                $current_year=date('Y');
                $current_month=date('n');
                $current_day=date('j');
        
                if($current_year===$year && $current_month===$month && $current_day===$day){
                    $this->updateUserStatusPageStaff($user_id, $new_status); 
                }
                
                //here
                //if(!empty($pay_period_input_val)){
                    $date_obj=DateTime::createFromFormat('Y.n.j', $date);
                    $this->updatePayPeriodTotal($pay_period_input_val, $date_obj->format('d-m-Y'), $user_id, 'one_date');
               // }
            } else{//not include weekends             
                $date_explode=explode('.', $date);
                $year=$date_explode[0];
                $month=$date_explode[1];
                $day=$date_explode[2];
                
                //There is conversion date in iteration of the loop from  a string to an object
                $item_date=DateTime::createFromFormat('Y.n.j', $date);
                
                //I check whether have the timestamp  of the date to the weekend
                $res_check=$this->checkWeekendDay($item_date->format('U'));
                
                //file_put_contents('/home/curiotime/ultima.curiotime.com/logs/weekends.html', print_r($res_check.'<br/>', true), FILE_APPEND | LOCK_EX);       
            
                if($res_check==='0'){//if not weekend
                    $dates_array[]['status']=$this->checkReportItemStatus($user_id, $year, $month, $day);
                    $dates_array[]['day']=$day;
                    $dates_array[]['month']=$month;
                    $dates_array[]['year']=$year;
                    $dates_array[]['typeof']=gettype( $date);
            
                    $old_item_status=$this->checkReportItemStatus($user_id, $year, $month, $day);
                    if(!empty($old_item_status)){
                        $this->updateReportItem($user_id, $new_status, $year, $month, $day);         
                    } else{            
                        $this->insertReportItem($user_id, $new_status, $year, $month, $day);    
                    }
                    $current_year=date('Y');
                    $current_month=date('n');
                    $current_day=date('j');
        
                    if($current_year===$year && $current_month===$month && $current_day===$day){
                        $this->updateUserStatusPageStaff($user_id, $new_status); 
                    }
                    //here
                    //if(!empty($pay_period_input_val)){
                        $date_obj=DateTime::createFromFormat('Y.n.j', $date);
                        $this->updatePayPeriodTotal($pay_period_input_val, $date_obj->format('d-m-Y'), $user_id, 'one_date');
                    //}
                }
            }
        }
        return json_encode($dates_array);
    }
    
    private function checkWeekendDay($date)
    {
       
        setlocale(LC_TIME, 'en_GB.utf8');
        $day_name=strftime('%a', $date);
        
        if($day_name=='Sat' || $day_name=='Sun'){
            return '1';
        } else{
            return '0';
        }
        return $day_name;
    }
    
    public function updateStatusText($post, $user_id)
    {
        $idField = $post['id'];       
        $idField = explode('-', $idField);
        $user = & JFactory::getUser($user_id);
        $owner_id=$user->owner_id;
        
        
        $text_status = trim($post['value']);
        $status_number=$idField[1];
        
             
            $query='SELECT * FROM #__users WHERE `owner_id`="'.$owner_id.'" ORDER by id ASC';
            $this->db->setQuery($query);
            $user_from_current_manager = $this->db->loadObjectList(); 
            
            foreach($user_from_current_manager as $one_manager_user){
                //if($one_manager_user->id!=$owner_id){
                    $query="SELECT `user_id` FROM #__user_status_text WHERE `user_id`='".$one_manager_user->id."'";
                    $this->db->setQuery($query);
                    $user_id1 = $this->db->loadObject()->user_id;
            
                    if(empty($user_id1)){//add items in db, if user dont exist
                        $object->number_status=1;
                        $object->status_text='Sick Child';
                        $object->user_id=$one_manager_user->id;         
                        $this->db->insertObject('#__user_status_text', $object);
            
                        $object->number_status=2;
                        $object->status_text='Sick';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text', $object);
            
                        $object->number_status=3;
                        $object->status_text='Away';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text', $object);
                
                        $object->number_status=4;
                        $object->status_text='Days off';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text', $object);
                    }
                
                    $query = "UPDATE #__user_status_text SET `status_text`='".$text_status."' WHERE `user_id`='".$one_manager_user->id."' AND `number_status`='".$status_number."'";
                    $this->db->setQuery($query);
                    $this->db->query(); 
               
            }

        echo $text_status;
    }
    
    public function updateStatusTextIs($post, $user_id)
    {
        $idField = $post['id'];       
        $idField = explode('-', $idField);
        $user = & JFactory::getUser($user_id);
        $owner_id=$user->owner_id;
        
        $text_status = trim($post['value']);
        $status_number=$idField[1];
        
               
            $query='SELECT * FROM #__users WHERE `owner_id`="'.$owner_id.'" ORDER by id ASC';
            $this->db->setQuery($query);
            $user_from_current_manager = $this->db->loadObjectList(); 
            
            foreach($user_from_current_manager as $one_manager_user){
                //if($one_manager_user->id!=$owner_id){
                    $query="SELECT `user_id` FROM #__user_status_text_is WHERE `user_id`='".$one_manager_user->id."'";
                    $this->db->setQuery($query);
                    $user_id1 = $this->db->loadObject()->user_id;
            
                    if(empty($user_id1)){//add items in db, if user dont exist
                        $object->number_status=1;
                        $object->status_text='Veikt barn';
                        $object->user_id=$one_manager_user->id;         
                        $this->db->insertObject('#__user_status_text_is', $object);
            
                        $object->number_status=2;
                        $object->status_text='Veikur';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text_is', $object);
            
                        $object->number_status=3;
                        $object->status_text='Frá vinnu';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text_is', $object);
                
                        $object->number_status=4;
                        $object->status_text='v. barna';
                        $object->user_id=$one_manager_user->id;          
                        $this->db->insertObject('#__user_status_text_is', $object);
                    }
                
                    $query = "UPDATE #__user_status_text_is SET `status_text`='".$text_status."' WHERE `user_id`='".$one_manager_user->id."' AND `number_status`='".$status_number."'";
                    $this->db->setQuery($query);
                    $this->db->query(); 
                
            }
        
        echo $text_status;
    }
    
    public function setDefaultTextFromStatusAllUsers()
    {
        $query='SELECT * FROM #__users ORDER by id ASC';
        $this->db->setQuery( $query );
        $all_users_object = $this->db->loadObjectList(); 
        
        echo '<pre>';
        print_r($all_users_object);
        echo '</pre>';
        
        foreach($all_users_object as $user){
           /* $query = "INSERT INTO #__user_report_items (id_user, status, year, month, day) VALUES ('".$user_id."', '".$status_user."', '".$year."', '".$month."', '".$day."')";    
            $this->db->setQuery($query);	 
            $this->db->query(); */
            
            $object->number_status=1;
            $object->status_text='Sick Child';
            $object->user_id=$user->id;
            
            $this->db->insertObject('#__user_status_text', $object);
            
            $object->number_status=2;
            $object->status_text='Sick';
            $object->user_id=$user->id;
          
            $this->db->insertObject('#__user_status_text', $object);
            
            $object->number_status=3;
            $object->status_text='Away';
            $object->user_id=$user->id;
          
            $this->db->insertObject('#__user_status_text', $object);
                        
            $object->number_status=4;
            $object->status_text='Days off';
            $object->user_id=$user->id;
          
            $this->db->insertObject('#__user_status_text', $object);
        }
        
    }
    
    public function getStatusText($user_id, $number_status)
    {
        $user_id=(int)$user_id;
        $number_status=(int)$number_status;
        
        $query='SELECT * FROM #__user_status_text WHERE `user_id`="'.$user_id.'" AND `number_status`="'.$number_status.'"';
        $this->db->setQuery( $query );
        $object = $this->db->loadObject();
        if(!empty($object->status_text)){
            return $object->status_text;
        } else{
            switch($number_status){
                case '1':
                    $object='Sick Child';
                    break;
                case '2':
                    $object='Sick';
                    break;
                case '3':
                    $object='Away';
                    break;
                case '4':
                    $object='Days off';
                    break;
            }
            return $object;
        }
        
    }
    
    public function getStatusTextNewPsd($user_id, $number_status)
    {
        $user_id=(int)$user_id;
        $number_status=(int)$number_status;
        
        $query='SELECT * FROM #__user_status_text WHERE `user_id`="'.$user_id.'" AND `number_status`="'.$number_status.'"';
        $this->db->setQuery( $query );
        $object = $this->db->loadObject();
        if(!empty($object->status_text)){
            return $object->status_text;
        } else{
            switch($number_status){
                case '1':
                    $object='Sick Child';
                    break;
                case '2':
                    $object='Sick';
                    break;
                case '3':
                    $object='Away';
                    break;
                case '4':
                    $object='Sport';
                    break;
            }
            return $object;
        }
        
    }
    
    public function getStatusTextIs($user_id, $number_status)
    {
        $user_id=(int)$user_id;
        $number_status=(int)$number_status;
        
        $query='SELECT * FROM #__user_status_text_is WHERE `user_id`="'.$user_id.'" AND `number_status`="'.$number_status.'"';
        $this->db->setQuery( $query );
        $object = $this->db->loadObject();
        
        /*echo '<pre>';
        print_r($object);
        echo '</pre>';*/
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/report_page.html', print_r($object, true), FILE_APPEND | LOCK_EX);
        
        if(!empty($object->status_text)){
            return $object->status_text;
        } else{
            switch($number_status){
                case '1':
                    $object='Veikt barn';
                    break;
                case '2':
                    $object='Veikur';
                    break;
                case '3':
                    $object='Frá vinnu';
                    break;
                case '4':
                    $object='v. barna';
                    break;
            }
            return $object;
        }
        
    }
    
    public function getStatusTextIsNewPsd($user_id, $number_status)
    {
        $user_id=(int)$user_id;
        $number_status=(int)$number_status;
        
        $query='SELECT * FROM #__user_status_text_is WHERE `user_id`="'.$user_id.'" AND `number_status`="'.$number_status.'"';
        $this->db->setQuery( $query );
        $object = $this->db->loadObject();
        
        /*echo '<pre>';
        print_r($object);
        echo '</pre>';*/
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/report_page.html', print_r($object, true), FILE_APPEND | LOCK_EX);
        
        if(!empty($object->status_text)){
            return $object->status_text;
        } else{
            switch($number_status){
                case '1':
                    $object='Veikt barn';
                    break;
                case '2':
                    $object='Veikur';
                    break;
                case '3':
                    $object='Frá vinnu';
                    break;
                case '4':
                    $object='Sport';
                    break;
            }
            return $object;
        }
        
    }
    
    private function getUsersFromManager($manager_id)
    {
        $manager_id=(int)$manager_id;
        $query='SELECT * FROM #__users WHERE `owner_id`="'.$manager_id.'" AND `is_hide`="0" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList(); 
        return $items;
    }
    
    public function getYearsArr()
    {
        $years=date('Y');
        $years_arr=[];
        
        /*for($i=0; $i<10; $i++){
            $years_arr[]=$years+$i;
        }*/
        
        for($i=0; $i<10; $i++){
            $years_arr[]=$years-$i;
        }
        
        
        return $years_arr;
        
    }
    
    public function addHolidaysItems($user_id, $date_start, $date_end)
    {
        //$year_start=date('Y', strtotime($date_start));
        //$month_start=date('n', strtotime($date_start));
        //$day_start=date('j', strtotime($date_start));
        
        
        //$date_end = date('d-m-Y', strtotime(date('Y-m-d', strtotime($date_end)).' +1day'));
        
        $from = new DateTime($date_start);
        $to   = new DateTime($date_end);
        
        /*$period = new DatePeriod($from, new DateInterval('P1D'), $to);
   
        
        $arrayOfDates = array_map(
            function($item){
                return $item->format('Y.n.j');
            
            },
            iterator_to_array($period)
        );
        $dates_array=[];
            
        file_put_contents($_SERVER['DOCUMENT_ROOT'].'/logs/calendar.html', print_r($arrayOfDates, true), FILE_APPEND | LOCK_EX);       
        
        foreach($arrayOfDates as $date){
            $date_explode=explode('.', $date);
            $year=$date_explode[0];
            $month=$date_explode[1];
            $day=$date_explode[2];
        }*/
        
        JLoader::register('Spec_holiday2ModelApp_api', JPATH_ROOT . '/components/com_spec_holiday2/models/app_api.php');
        $model = JModelLegacy::getInstance('App_api', 'Spec_holiday2Model'); 
        
        $model->setHolidayFromCalendar($user_id, $from->format('d.m.Y'), $to->format('d.m.Y'));
    }
    
    public function setSpendMinutes($minutes_id, $value, $user_id)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        $current_user=JFactory::getUser($user_id);
        $old_edition=$this->getSpendMinutesEdition($user_id);
        $count_editions=count($old_edition);
        
        $item = new stdClass;
        $item->id = NULL;
        $item->manager_id=$manager->id;
        $item->user_id=$user_id;
        $item->parent_union_rule_id= $current_user->rule_number0;
        $item->value=$this->db->escape($value);
        if(!empty($old_edition)){
           $item->old_value=$old_edition[$count_editions-1]->value; 
        } else{
            $item->old_value=0;
        }
        
        $item->timestamp_edition=time();
        $item->date_edition=date('Y-m-d H:i:s');
        $item->parent_minutes_row=$this->db->escape($minutes_id);
        
        if($this->db->insertObject('#__minutes_edition', $item, 'id')){
            return $value;
        }
    }
    
    public function setSpendMinutesWeek($minutes_id, $value, $user_id)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        $current_user=JFactory::getUser($user_id);
        $old_edition=$this->getSpendMinutesEditionWeek($user_id);
        $count_editions=count($old_edition);
        
        $item = new stdClass;
        $item->id = NULL;
        $item->manager_id=$manager->id;
        $item->user_id=$user_id;
        $item->parent_union_rule_id = $current_user->shift_number;
        $item->value=$this->db->escape($value);
        if(!empty($old_edition)){
           $item->old_value=$old_edition[$count_editions-1]->value; 
        } else{
            $item->old_value=0;
        }
        
        $item->timestamp_edition=time();
        $item->date_edition=date('Y-m-d H:i:s');
        $item->parent_minutes_row=$this->db->escape($minutes_id);
        
        if($this->db->insertObject('#__minutes_edition_week', $item, 'id')){
            return $value;
        }
    }
    
    public function getSpendMinutesEdition($user_id)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        
        $query='SELECT * FROM #__minutes_edition WHERE `user_id`="'.$user_id.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();
        
        return $items;
    }
    
    public function getSpendMinutesEditionWeek($user_id)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        
        $query='SELECT * FROM #__minutes_edition_week WHERE `user_id`="'.$user_id.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();
        
        return $items;
    }
  
    public function getSpendMinutesEditionWithPeriod($user_id, $start_date)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        
        $query='SELECT * FROM #__minutes_edition WHERE `user_id`="'.$user_id.'" AND `timestamp_edition`>="'.$start_date.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();
        
        return $items;
    }
    
    public function getSpendMinutesEditionWithPeriodWeek($user_id, $start_date)
    {
        $manager = JFactory::getUser($this->user->owner_id);
        
        $query='SELECT * FROM #__minutes_edition_week WHERE `user_id`="'.$user_id.'" AND `timestamp_edition`>="'.$start_date.'" ORDER by id ASC';
        $this->db->setQuery( $query );
        $items = $this->db->loadObjectList();
        
        return $items;
    }
    
    public function getFirstCompanyUserId()
    {
        JLoader::register('AuditModelRegistered_Users', JPATH_ROOT . '/components/com_audit/models/registered_users.php');
        $model_reg = JModelLegacy::getInstance('Registered_Users', 'AuditModel');
        $users_list = $model_reg->getRegistredUser();
        $user_list_ids = [];
        
        //remove hide users
        foreach($users_list as $one_user){
            if($one_user->is_hide == 0){
                $user_list_ids[] = $one_user;
            }
        }
        
        return $user_list_ids[1]->id;
    }
    
    public function reloadRigtColumn(string $lang, int $user_id)
    {
        $modelHolidays = JModelLegacy::getInstance('holidays', 'AuditModel');
        JLoader::register('AuditModelHolidays', JPATH_ROOT . '/components/com_audit/models/holidays.php');
        
        $config = &JFactory::getConfig();
        $enable_subrules_part_in_1_week_rule = $config->get('enable_subrules_part_in_1_week_rule');
        $enable_percent_changes_in_calc_and_rule_holiday = $config->get('enable_percent_changes_in_calc_and_rule_holiday');
        $enable_sick_child = $config->get('enable_sick_child');
        $enable_earn_minutes = $config->get('enable_earn_minutes');
        
        $user = JFactory::getUser($user_id);
        $current_user = $user;
        
        if ($user->id != 0) {
            $_REQUEST['load_type'] = 'calendar';
            $holidayTotals = $modelHolidays->getTotals($user_id);
            $holiday_percent_obj = $modelHolidays->loadHolidaysPercent($user_id, '');
            
            /*echo '<pre>$holidayTotals';
            print_r($holidayTotals);
            echo '</pre>'; 
              
            echo '<pre>holiday_percent_obj';
            print_r($holiday_percent_obj); 
            echo '</pre>';*/
              
            if (!empty($holidayTotals) && ($user->rule_number0 != 0 || ($user->shift_number != 0 && $enable_subrules_part_in_1_week_rule == '1' ))) {
                ob_start();?>
                    <div class="span12 d-flex flex-column">    
                        <div class="span5 custom_block_style-0">
                            <div class="bottom_time_panel2 d-flex">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?= JText::_('COM_AUDIT_FOOTER_TEXT_HIRED') ?></span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?= $user->work_start_date ?></span>
                            </div>
                            <div class="bottom_time_panel2 d-flex background_style-0">
                                    <?php if ($enable_percent_changes_in_calc_and_rule_holiday == '1' && $holiday_percent_obj !== false) { ?>
                                        <span class="span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_AVAILABLE'); ?>:</span>

                                        <span class="span6 value-hours pdf-h-value-1"><?php echo $holidayTotals['new_holidays_days_from_first_may'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['new_holidays_hours_from_first_may'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                         <!--<span class="span6 value-hours pdf-h-value-1 d-none" style=""><?php echo $holidayTotals['total_by_law_holidays_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['total_by_law_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>-->
                                         <!--<span class="span6 value-hours pdf-h-value-1"><?php echo round($holidayTotals['total_by_law_holidays_days'] - $holidayTotals['taken_by_law_holidays_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>-->
                                    <?php } else { ?>
                                        <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_AVAILABLE'); ?>:</span>
                                        <span class="span6 value-hours pdf-h-value-1"><?php echo $holidayTotals['total_by_law_holidays_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['total_by_law_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                    <?php } ?>

                            </div>
                            
                            <div class="bottom_time_panel2 d-flex background_style-0">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_TAKEN'); ?>:</span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo $holidayTotals['taken_by_law_holidays_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['taken_by_law_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                            </div>
                            <!--<div class="bottom_time_panel2 d-flex background_style-0">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_TOTAL'); ?>:</span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo round($holidayTotals['total_by_law_holidays_days'] - $holidayTotals['taken_by_law_holidays_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                            </div>-->
                            <div class="bottom_time_panel2 d-flex background_style-0">
                                    <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_TOTAL'); ?>:</span>
                                    <!--<span class="span6 value-hours pdf-h-value-1"  ><?php echo round($holidayTotals['total_by_law_holidays_days'] - $holidayTotals['taken_by_law_holidays_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>-->
                                    <?php if($enable_percent_changes_in_calc_and_rule_holiday == '1' && $holiday_percent_obj !== false){?>
                                        <span class="span6 value-hours pdf-h-value-1"><?=$holidayTotals['new_holidays_days_from_first_may'] -  $holidayTotals['taken_by_law_holidays_days']?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['new_holidays_hours_from_first_may'] - $holidayTotals['taken_by_law_holidays_hours']?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                    <?php } else{?>
                                        <span class="span6 value-hours pdf-h-value-1"  ><?php echo round($holidayTotals['total_by_law_holidays_days'] - $holidayTotals['taken_by_law_holidays_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_holidays_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                    <?php } ?>
                                </div> 
                        </div>
                        <div class="span5">
                            <div class="bottom_time_panel2 d-flex background_style-1" data-type="total_by_law_sick_days">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_AVAILABLE'); ?>:</span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo $holidayTotals['total_by_law_sick_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['total_by_law_sick_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                            </div>
                            <div class="bottom_time_panel2 bottom_time_panel2_with_margin d-flex background_style-1" data-type="taken_by_law_sick_days">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_TAKEN'); ?>:</span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo $holidayTotals['taken_by_law_sick_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['taken_by_law_sick_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                            </div>

                            <div class="bottom_time_panel2 d-flex background_style-1" data-type="total_by_law">
                                <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_TOTAL'); ?>:</span>
                                <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo round($holidayTotals['total_by_law_sick_days'] - $holidayTotals['taken_by_law_sick_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_sick_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                            </div>
                            <?php if($enable_percent_changes_in_calc_and_rule_holiday == '1' && $holiday_percent_obj !== false){?>
                                <!--<div class="bottom_time_panel2 d-flex">
                                    <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOLIDAYS_NEW_MONTHLY_TOTAL'); ?>:</span>
                                    <span class="span6 value-hours pdf-h-value-1"><?php echo $holidayTotals['new_monthly_total_days']?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['new_monthly_total'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                </div>-->
                            <?php } ?>
                        </div>
                    </div>
                    <?php if ($enable_sick_child == '1') { ?>
                        <div class="span12 d-flex flex-column">
                            <div class="span5 sick_child_calc" >
                                <div class="bottom_time_panel2 d-flex background_style-2" data-type="total_by_law_sick_child_days">
                                    <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_CHILD_AVAILABLE'); ?>:</span>
                                    <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo $holidayTotals['total_by_law_sick_child_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['total_by_law_sick_child_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                </div>
                                <div class="bottom_time_panel2 d-flex background_style-2" data-type="taken_by_law_sick_child_days">
                                    <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_CHILD_TAKEN'); ?>:</span>
                                    <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo $holidayTotals['taken_by_law_sick_child_days'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['taken_by_law_sick_child_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                </div>
                                <div class="bottom_time_panel2 d-flex background_style-2" data-type="total_by_law_sick_child">
                                    <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_SICK_CHILD_TOTAL'); ?>:</span>
                                    <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?php echo round($holidayTotals['total_by_law_sick_child_days'] - $holidayTotals['taken_by_law_sick_child_days'], 2) ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_DAYS'); ?> / <?php echo $holidayTotals['sum_sick_child_hours'] ?> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_HOURS'); ?></span>
                                </div>
                            </div>
                        <?php } ?>

                        <?php if ($enable_earn_minutes == '1') { ?>
                            <?php
                            $manager = JFactory::getUser($this->user->owner_id);
                            if($user->shift_number != 0 && $user->rule_number0 == 0){
                                $minutes_object = $modelHolidays->getEarnMinutesRowWeek($current_user->shift_number);
                            } else{
                                $minutes_object = $modelHolidays->getEarnMinutesRow($current_user->rule_number0);
                            }
                           
                            $work_start_timestamp0 = $minutes_object->timestamp_start;
                            $normalize_start_date = $modelHolidays->zeroingStart($work_start_timestamp0);

                            $now = time();
                            $currentDate = date("Y-m-d", $now);


                            if ($now < $normalize_start_date) {
                                // echo 'pp';
                                $is_leep_year = $modelHolidays->isLeap(date('Y'));
                                //echo $is_leep_year;
                                if ($is_leep_year == 1) {
                                    $startDate = $normalize_start_date - 31622400;
                                } elseif ($is_leep_year == 0) {
                                    $startDate = $normalize_start_date - 31536000;
                                }
                                if($user->shift_number != 0 && $user->rule_number0 == 0){
                                    $minutes_edition_object = $this->getSpendMinutesEditionWithPeriodWeek($this->user_id, $startDate);
                                } else{
                                    $minutes_edition_object = $this->getSpendMinutesEditionWithPeriod($this->user_id, $startDate);
                                }
                               
                            } else {
                                if($user->shift_number != 0 && $user->rule_number0 == 0){
                                     $minutes_edition_object = $this->getSpendMinutesEditionWithPeriodWeek($this->user_id, $normalize_start_date);
                                } else{
                                     $minutes_edition_object = $this->getSpendMinutesEditionWithPeriod($this->user_id, $normalize_start_date);
                                }
                                
                            }


                            $count_minutes_edition_object = count($minutes_edition_object);
                            $last_edition = $minutes_edition_object[$count_minutes_edition_object - 1];


                            if (!empty($minutes_object->date_start) && $minutes_object->is_enable == '1') {
                                ?>
                                <div class="span5 sick_child_calc d-flex flex-column" > 
                                    <div class="bottom_time_panel2 d-flex" data-type="total_by_law_sick_child_days">
                                        <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_CALENDAR_TOTAL_EARNED_DATE_START'); ?>:</span>
                                        <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><?= $minutes_object->date_start ?> </span>
                                    </div>
                                    <div class="bottom_time_panel2 d-flex" data-type="total_by_law_sick_child_days">
                                        <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_CALENDAR_TOTAL_EARNED'); ?>:</span>
                                        <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><span class="js_event_minutes_minus_earned"><?php echo $holidayTotals['earned_minutes'] ?></span> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_MINUTES'); ?></span>
                                    </div>
                                    <div class="bottom_time_panel2 pos_relative d-flex" data-type="taken_by_law_sick_child_days">
                                        <span class="d-flex span6 name-hours pdf-h-label-1 js_event_show_editions_popup" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_CALENDAR_TOTAL_SPEND'); ?>:</span>
                                        <span class="span6 value-hours pdf-h-value-1 editable_spend_wrapper justify-content-end" style=" white-space: nowrap">
                                            <?php if($user->shift_number != 0 && $user->rule_number0 == 0){
                                                $editable_class = 'editable_spend_minutes_week';
                                            } else{
                                                $editable_class = 'editable_spend_minutes';
                                            }
                                            ?>
                                            <span class="<?=$editable_class?>" id="editable_spend_minutes-<?= $minutes_object->id ?>-<?= $this->user_id ?>"><?php
                                                if ($last_edition->value != '0' && empty($last_edition->value)) {
                                                    echo 0;
                                                } else {
                                                    $timestamp_last_edition = $last_edition->timestamp_edition;

                                                    $enable_popup = 0;
                                                    if ($timestamp_last_edition > $startDate) {

                                                        echo $last_edition->value;
                                                        $enable_popup = 1;
                                                    } else {
                                                        echo 0;
                                                    }
                                                }
                                                ?></span> <span><?php echo JText::_('COM_AUDIT_FOOTER_TEXT_MINUTES'); ?></span>

                                        </span>
                                        <div class="edition_popup <?php if ($enable_popup == 0) { ?>locked_popup<?php } ?>">
                                            <div class="edition_popup_content">
                                                <h3><?= JText::_('COM_AUDIT_CALENDAR_MINUTES_EDITIONS') ?></h3>
                                                <table>
                                                    <tbody>
                                                        <tr class="tr_header">
                                                            <td></td>
                                                            <td><?= JText::_('COM_AUDIT_CALENDAR_MINUTES_EDITIONS_DATE') ?></td>
                                                            <td><?= JText::_('COM_AUDIT_CALENDAR_MINUTES_EDITIONS_OLD_VAL') ?></td>
                                                            <td><?= JText::_('COM_AUDIT_CALENDAR_MINUTES_EDITIONS_NEW_VAL') ?></td>
                                                        </tr>
                                                        <?php
                                                        $i2 = 1;
                                                        foreach ($minutes_edition_object as $one_edition) {
                                                            ?>
                                                            <?php
                                                            if ($count_minutes_edition_object == $i2) {
                                                                $class = 'tr_last_edition';
                                                            }
                                                            ?>
                                                            <tr class="<?= $class ?>">
                                                                <td><?= $i2 ?>)</td>

                                                                <td><?= $one_edition->date_edition ?></td>
                                                                <td><?= $one_edition->old_value ?></td>
                                                                <td><?= $one_edition->value ?></td>
                                                            </tr>
                                                            <?php
                                                            $i2++;
                                                        }
                                                        ?>
                                                    </tbody>
                                                </table>

                                            </div>
                                        </div>
                                    </div>
                                    <div class="bottom_time_panel2 d-flex" data-type="total_by_law_sick_child">
                                        <span class="d-flex span6 name-hours pdf-h-label-1" style=" text-align: left; "><?php echo JText::_('COM_AUDIT_CALENDAR_TOTAL_LEFT'); ?>:</span>
                                        <span class="span6 value-hours pdf-h-value-1"  style=" white-space: nowrap "><span class="js_event_minutes_minus"><?php
                                                if ($timestamp_last_edition > $startDate) {
                                                    echo $holidayTotals['earned_minutes'] - $last_edition->value;
                                                } else {
                                                    echo $holidayTotals['earned_minutes'];
                                                }
                                                ?></span> <?php echo JText::_('COM_AUDIT_FOOTER_TEXT_MINUTES'); ?></span>
                                    </div>
                                </div>
                                <?php
                            }
                        }
                        ?>
                    </div>

                </div>
                <?php ob_end_flush();
            }
        }
    }
    
    public function checkActionPermission($type, $individual_params)
    {
        $res = '0';

        switch ($type) {
            case 'reloadRigtColumn':
                $config = JFactory::getConfig();

                $user = $individual_params['user_obj'];
                $user_joomla = $this->user;

                $query = "SELECT `owner_id` FROM #__users WHERE `id` = '$user->id'";
                $this->db->setQuery($query);
                $owner_id = $this->db->loadResult();

                //if user is in current manager
                if ($user_joomla->owner_id == $owner_id && $user->id > 0) {
                    $res = '1';
                }
                break;
        }


        return $res;
    }
    
}