<?php
namespace PayPal;

use PayPalHttp\HttpRequest;

class SubscriptionRequest extends HttpRequest    {
    
    private $obj = null;
    public function __construct(&$obj)  {
        parent::__construct("/v1/billing/subscriptions/{id}", "GET");
        $this->obj = $obj;
        $this->path = str_replace("{id}", urlencode($this->obj->plan_id), $this->path);
        $this->headers["Content-Type"] = "application/json";
    }
    
    
    public function getSubscription($client) {        
        try {
            $response = $client->execute(new CreateSubscriptionRequest($this->obj));            
            return $response->result;
        } catch(\Exception $e) {
            throw new \Exception($e->getMessage());
        }
        throw new \Exception("Can't create subscription.");
    }    
}

class CreateSubscriptionRequest extends HttpRequest  {
    private $obj = null;
    
    public function __construct($obj)  {        
        parent::__construct("/v1/billing/subscriptions", "POST");
        $this->obj  =  $obj;
        $this->headers["Content-Type"] = "application/json";
        $request->headers["prefer"] = "return=representation";
        //$request->headers["prefer"] = "return=minimal";
        
        //$startDate = date('c', strtotime("+1 hour"));
        $startDate = date('c', strtotime("+1 min"));
        $user = \JFactory::getUser();
        
        $parsms  =  array(
            'option'    =>  'com_audit',
            'task'      =>  'subscription.success',
            'id'        =>  $this->obj->id
        );
        $successUrl  =  "https://".$_SERVER['HTTP_HOST']."/index.php?".http_build_query($parsms);
        
        $parsms  =  array(
            'option'    =>  'com_audit',
            'task'      =>  'subscription.cancel',
            'id'        =>  $this->obj->id
        );
        $cancelUrl  =  "https://".$_SERVER['HTTP_HOST']."/index.php?".http_build_query($parsms);
        
        
        
        $this->body = [
            'custom_id'     =>  $obj->local_id,
            'plan_id'       =>  $obj->plan_id,
            "start_time"    =>  $startDate,
            "quantity"      =>  1,
            "shipping_amount"   => [
              "currency_code"   => $obj->currency,
              "value"           => "0.00"
            ],
            "subscriber"=> [
                "name"=> [
                  "given_name"=> $user->name
                ],
                "email_address"=> $user->email,                
            ],
            "application_context"=> [
                "brand_name"=> "curiotime.com",
                //"locale"=> "is-IS",
                "locale"=> "en-US",
                "user_action"=> "SUBSCRIBE_NOW",
                "payment_method"=> [
                    "payer_selected"=> "PAYPAL",
                    "payee_preferred"=> "IMMEDIATE_PAYMENT_REQUIRED"
                ],
                "return_url"=> $successUrl,
                "cancel_url"=> $cancelUrl
            ]
        ];    
    }   
}
