<?php
namespace PayPal;

use PayPalHttp\HttpRequest;

class SubscriptionInfoRequest extends HttpRequest    {
    
    private $obj = null;
    public function __construct(&$obj)  {
        parent::__construct("/v1/billing/subscriptions/{id}", "GET");
        $this->obj = $obj;
        $this->path = str_replace("{id}", urlencode($this->obj->subscription_id), $this->path);
        $this->headers["Content-Type"] = "application/json";
    }
    
    
    public function getSubscription($client) {        
        try {
            $response = $client->execute($this);            
            return $response->result;
        } catch(\Exception $e) {
            throw new \Exception($e->getMessage());
        }
        throw new \Exception("Can't find subscription.");
    }    
}
