<?php
namespace PayPal;

use PayPalHttp\HttpRequest;

class ProductRequest extends HttpRequest    {
    
    const PRODUCT_ID    =   "curiotime";
    
    public function __construct()  {
        //parent::__construct("/v1/catalogs/products", "GET");
        parent::__construct("/v1/catalogs/products/{product_id}", "GET");
        $this->path = str_replace("{product_id}", urlencode(self::PRODUCT_ID ), $this->path);
        $this->headers["Content-Type"] = "application/json";
        /*
         * // post only
        $this->body = [
            'page_size'=>20,
            'page'=>40
        ];
         * *
         */
    }
    
    
    public function getProduct($client) {        
        $product  =  null;
        try {
            $response = $client->execute($this);
            $product  =  $response->result;
        } catch(\Exception $e) {
            $product  =  null;
        }
        if(!empty($product))
            return $product;
        try {
            if(empty($product)) {
                $response = $client->execute(new CreateProductRequest());
            }
        } catch(\Exception $e) {
        }
        try {
            $response = $client->execute($this);
            $product  =  $response->result;
        } catch(\Exception $e) {
            $product  =  null;
        }
        if(!empty($product))
            return $product;
        
        throw new Exception("Can't find/create product.");
    }
    
    public function __construct2($orderId)  {
        parent::__construct("/v2/checkout/orders/{order_id}?", "GET");
        $this->path = str_replace("{order_id}", urlencode($orderId), $this->path);
        $this->headers["Content-Type"] = "application/json";
    }

}


class CreateProductRequest extends HttpRequest  {
    public function __construct()  {
        parent::__construct("/v1/catalogs/products", "POST");
        $this->headers["Content-Type"] = "application/json";
        $request->headers["prefer"] = "return=representation";
        //$request->headers["prefer"] = "return=minimal";
        $this->body = [
            'id'            =>  ProductRequest::PRODUCT_ID,
            'name'          =>  "CurioTime",
            'description'   =>  "CurioTime",
            'type'          =>  "SERVICE",
            'category'      =>  "CONSULTING_SERVICES",
            'home_url'      =>  "https://www.curiotime.com/",
            
        ];
        var_dump($this->body);exit;
    }    
}
