<?php
namespace PayPal;

use PayPalHttp\HttpRequest;

class PlanRequest extends HttpRequest    {
    
    const PLAN_ID    =   "curiotime";
    private $obj = null;
    public function __construct(&$obj)  {
        parent::__construct("/v1/billing/plans/{id}", "GET");
        $this->path = str_replace("{id}", urlencode(self::PLAN_ID ), $this->path);
        $this->headers["Content-Type"] = "application/json";
        $this->obj = $obj;
    }
    
    
    public function getPlan($client) {        
        try {
            $response = $client->execute(new CreatePlanRequest($this->obj));
            return $response->result;
        } catch(\Exception $e) {
            throw new \Exception($e->getMessage());
        }
        throw new \Exception("Can't find/create plan.");
    }    
}

class CreatePlanRequest extends HttpRequest  {
    private $obj = null;
    public function __construct(&$obj)  {
        parent::__construct("/v1/billing/plans", "POST");
        $this->headers["Content-Type"] = "application/json";
        $request->headers["prefer"] = "return=representation";
        //$request->headers["prefer"] = "return=minimal";
        $this->body = [
            'product_id'    =>  ProductRequest::PRODUCT_ID,
            'name'          =>  $_SERVER['HTTP_HOST'],
            'description'   =>  $_SERVER['HTTP_HOST']." : ".$obj->company,
            'status'        =>  "ACTIVE",
            "billing_cycles"=> [  
                /*
                [
                    "frequency" => [
                        "interval_unit"   => "MONTH",
                        "interval_count"  => 1
                    ],
                    "tenure_type"   => "TRIAL",
                    "sequence"      => 1,
                    "total_cycles"  => 1,
                    "pricing_scheme"=> [
                        "fixed_price" => [
                            "value"         => $obj->total,
                            "currency_code" => $obj->currency
                        ]
                    ]
                ],
                */                
                [
                    "frequency" => [
                        "interval_unit"=> "MONTH",
                        "interval_count"=> 1
                    ],
                    "tenure_type"=> "REGULAR",
                    "sequence"=> 1,
                    "total_cycles"=> 0,
                    "pricing_scheme"=> [
                        "fixed_price"=> [
                          "value"=> $obj->total,
                          "currency_code"=> $obj->currency
                        ]
                    ]
                ]
            ],
            "payment_preferences"=> [
                "auto_bill_outstanding" => true,
                "setup_fee" => [
                    "value" =>  "0",
                    "currency_code" => $obj->currency
                ],
                "setup_fee_failure_action"  =>  "CONTINUE",
                "payment_failure_threshold" => 3
            ]
        ];
    }    
}
