<?php
// No direct access
defined( '_JEXEC' ) or die;

/**
 * https://github.com/paypal/Checkout-PHP-SDK
 * 
 * https://phppot.com/php/how-to-manage-recurring-payments-using-paypal-subscriptions-in-php/
 * http://paypal.github.io/PayPal-PHP-SDK/sample/#payments
 * https://stackoverflow.com/questions/30958176/paypal-rest-sdk-api-get-token
 */

/*
error_reporting(E_ALL);
ini_set("display_errors", 1);
*/
require_once (JPATH_LIBRARIES."/custom/vendor/autoload.php");
require_once("ProductRequest.php");
require_once("PlanRequest.php");
require_once("SubscriptionRequest.php");
require_once("SubscriptionInfoRequest.php");

use PayPalCheckoutSdk\Core\PayPalHttpClient;
use PayPalCheckoutSdk\Core\ProductionEnvironment;
use PayPalCheckoutSdk\Core\SandboxEnvironment;
use PayPal\ProductRequest;
use PayPal\PlanRequest;
use PayPal\SubscriptionRequest;
use PayPal\SubscriptionInfoRequest;

class PayPalClient {
    
    protected $client           =   null;
    protected $sandbox          =   1;
    protected $environment      =   null;    
    public $environments        =   array   (
        'live'  => array (
            'clientId'=>"",
            'clientSecret'=>''
        ),        
        'sandbox'  => array (
            'clientId'      =>  "AYeS_ApE14YcIVJ4kK4Il5LBVeKEAsiUB1ynXwC-JnT4pJ_t8-mZ8RiU7MWWNrrCPAybrbpJnB0qffee",
            'clientSecret'  =>  "EC-fWtsOERj2SlDsrfmkjhzx85_NtgE6YiYcgdMlZgFOdUcS4Yx1GhH17Ue0q2EdtP6cAsEUnHDR718f"
        ),
    );
    
    
    public function getEnvironment() {
        if($this->environment == null) {
            if($this->sandbox) {
                $this->environment  =    new SandboxEnvironment($this->environments['sandbox']['clientId'],$this->environments['sandbox']['clientSecret']);
            } else {
                $this->environment  =    new ProductionEnvironment($this->environments['live']['clientId'],$this->environments['live']['clientSecret']);
            }
        }
        return $this->environment;
    }
    
    public function __construct() { 
        mt_srand(time());
        $this->db   =   JFactory::getDBO();
        $this->client = new PayPalHttpClient($this->getEnvironment());
    }
    
    public function confirmSubscription(&$obj) {
        $subscriptionInfoRequest =  new SubscriptionInfoRequest($obj);
        $subscription = $subscriptionInfoRequest->getSubscription($this->client);
        if(!empty($subscription)) {
            if($subscription->status == "ACTIVE") {
                $obj->status = 1;
            }
        }        
    }
    
    public function createSubscription(&$obj) {
        $productRequest =  new ProductRequest();
        $product = $productRequest->getProduct($this->client);
        $planRequest =  new PlanRequest($obj);
        $plan   =   $planRequest->getPlan($this->client);
        if(!empty($plan)) {
            $obj->plan_id =  $plan->id;
        }
        $subscriptionRequest    =   new SubscriptionRequest($obj);
        $subscription   =   $subscriptionRequest->getSubscription($this->client);
        if(!empty($subscription)) {
            $obj->subscription_id   =   $subscription->id;
            return $subscription;
        }
        throw new \Exception("Can't create subscription.");
    }
}