<?php
/*ini_set('error_reporting', E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);*/

defined('_JEXEC') or die;
class AuditModelHolidays extends JModelLegacy {

    private $db;
    private $app;
    
    public $hoursPerDay  =   8;
    
    
    public function __construct() {
        parent::__construct();
        $this->db = &JFactory::getDBO();
        $this->app = JFactory::getApplication();
        
        $this->doc = JFactory::getDocument();
        $this->server_path = $_SERVER['DOCUMENT_ROOT'];
        $this->user = & JFactory::getUser();
        $this->lang = & JFactory::getLanguage();
        $this->config = &JFactory::getConfig();
        
        $this->enable_earn_minutes = $this->config->get('enable_earn_minutes');
        $this->enable_subrules_part_in_1_week_rule = $this->config->get('enable_subrules_part_in_1_week_rule');
        $this->enable_percent_changes_in_calc_and_rule_holiday = $this->config->get('enable_percent_changes_in_calc_and_rule_holiday');
        $this->current_url = $this->config->get('current_url');
        $this->enable_break_time_changes = $this->config->get('enable_break_time_changes');
        
        if($this->enable_earn_minutes=='1'){
            $user_id = $this->app->input->getInt('user_id');
            
            if($user_id==0){
                $user_id = $user_id = $this->app->input->getInt('u_id');
            }
            $this->earn_minutes_radio_mode = $this->getEarnMinutesState1($user_id);
            $this->earn_minutes_radio_mode_week = $this->getEarnMinutesState1Week($user_id);
        }
    }
    
    private function getEarnMinutesState()
    {
        $union_rule_id  = $this->user->rule_number0;
        //echo $union_rule_id;
       
        //rewrite this query if you plan a lot of earn minutes row
        $query  =   "SELECT `checkbox_all_days`, `checkbox_work_days` FROM #__subrules_minutes WHERE `parent_rule_id` =  ".$this->db->quote($union_rule_id)." limit 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        
        if($obj->checkbox_all_days=='1'){
            $res='checkbox_all_days';
        } if($obj->checkbox_work_days=='1'){
            $res='checkbox_work_days';
        }
        //echo $res;
        return $res;
    }
    
    public function getEarnMinutesState1($user_id) {
        $user = JFactory::getUser($user_id);
       
        $union_rule_id = $user->rule_number0;

        //rewrite this query if you plan a lot of earn minutes row
        $query = "SELECT `checkbox_all_days`, `checkbox_work_days` FROM #__subrules_minutes WHERE `parent_rule_id` =  " . $this->db->quote($union_rule_id) . " limit 1";
        $this->db->setQuery($query);
        $obj = $this->db->loadObject();

        if ($obj->checkbox_all_days == '1') {
            $res = 'checkbox_all_days';
        } if ($obj->checkbox_work_days == '1') {
            $res = 'checkbox_work_days';
        }
       
        return $res;
    }

    public function getEarnMinutesState1Week($user_id)
    {
        $user = JFactory::getUser($user_id);
        
        $union_rule_id = $user->shift_number;
                
        //rewrite this query if you plan a lot of earn minutes row
        $query = "SELECT `checkbox_all_days`, `checkbox_work_days` FROM #__subrules_minutes_week WHERE `parent_rule_id` =  ".$this->db->quote($union_rule_id)." limit 1";
        $this->db->setQuery($query);
        $obj = $this->db->loadObject();
        
        if($obj->checkbox_all_days=='1'){
            $res = 'checkbox_all_days';
        } if($obj->checkbox_work_days=='1'){
            $res = 'checkbox_work_days';
        }
        //echo $res;
        return $res;
    }
    
    private function getValuesByUserCompanyAge($uid) {
        
        $user   =   JFactory::getUser($uid);
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            return array();
        }
        $d1 = new DateTime(date("Y-m-d",$work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($user->rule_number0);
        $workYears  = abs(intval($diff->y));        
        
        $data  = array();
        $data['holiday_days_per_month']     = 0;
        $data['holiday_hours_per_month']    = 0;
        $data['sick_days_per_month']        = 0; 
        $data['sick_hours_per_month']       = 0;
        $data['sick_child_days_per_month']        = 0;//sick_child
        $data['sick_child_hours_per_month']       = 0;//sick_child
        
        if($this->enable_earn_minutes=='1'){
            $data['earn_min_days_per_month']        = 0;//earn minutes
            $data['earn_min_hours_per_month']       = 0;//earn minutes
        }
        
        if($rule_number0 > 0) {
            $query  =   "SELECT * FROM #__subrules_holidays WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['holiday_days_per_month']     = floatval($obj->days);
                $data['holiday_hours_per_month']    = floatval($obj->hours);
            }
            $query  =   "SELECT * FROM #__subrules_for_earning WHERE year_from <= ".$this->db->quote($workYears)." AND parent_rule_id =  ".$this->db->quote($rule_number0)." order by year_from DESC limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['sick_days_per_month']        = floatval($obj->days);
                $data['sick_hours_per_month']       = floatval($obj->hours);
            }
            //sick child
            $query  =   "SELECT * FROM #__subrules_sick_child WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['sick_child_days_per_month']        = floatval($obj->days);
                $data['sick_child_hours_per_month']       = floatval($obj->hours);
            }
            
            //earn minutes
            if($this->enable_earn_minutes=='1'){
                $query  =   "SELECT * FROM #__subrules_minutes WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
                $this->db->setQuery($query);
                $obj    =   $this->db->loadObject();
                
                if(!empty($obj)) {
                    $data['earn_min_days_per_month']        = floatval($obj->days);
                    $data['earn_min_hours_per_month']       = floatval($obj->hours);
                }
            }
        }
        return $data;
    }
    
    private function getValuesByUserCompanyAgeWeek($uid) {
        
        $user   =   JFactory::getUser($uid);
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            return array();
        }
        $d1 = new DateTime(date("Y-m-d", $work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($user->shift_number);
        $workYears  = abs(intval($diff->y));        
        
        $data  = array();
        $data['holiday_days_per_month']     = 0;
        $data['holiday_hours_per_month']    = 0;
        $data['sick_days_per_month']        = 0; 
        $data['sick_hours_per_month']       = 0;
        $data['sick_child_days_per_month']        = 0;//sick_child
        $data['sick_child_hours_per_month']       = 0;//sick_child
        
        if($this->enable_earn_minutes=='1'){
            $data['earn_min_days_per_month']        = 0;//earn minutes
            $data['earn_min_hours_per_month']       = 0;//earn minutes
        }
        
        if($rule_number0 > 0) {
            $query  =   "SELECT * FROM #__subrules_holidays_week WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['holiday_days_per_month']     = floatval($obj->days);
                $data['holiday_hours_per_month']    = floatval($obj->hours);
            }
            $query  =   "SELECT * FROM #__subrules_for_earning_week WHERE year_from <= ".$this->db->quote($workYears)." AND parent_rule_id =  ".$this->db->quote($rule_number0)." order by year_from DESC limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['sick_days_per_month']        = floatval($obj->days);
                $data['sick_hours_per_month']       = floatval($obj->hours);
            }
            //sick child
            $query  =   "SELECT * FROM #__subrules_sick_child_week WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
            $this->db->setQuery($query);
            $obj    =   $this->db->loadObject();
            if(!empty($obj)) {
                $data['sick_child_days_per_month']        = floatval($obj->days);
                $data['sick_child_hours_per_month']       = floatval($obj->hours);
            }
            
            //earn minutes
            if($this->enable_earn_minutes=='1'){
                $query  =   "SELECT * FROM #__subrules_minutes_week WHERE parent_rule_id =  ".$this->db->quote($rule_number0)." limit 1";
                $this->db->setQuery($query);
                $obj    =   $this->db->loadObject();
                
                if(!empty($obj)) {
                    $data['earn_min_days_per_month']        = floatval($obj->days);
                    $data['earn_min_hours_per_month']       = floatval($obj->hours);
                }
            }
        }
        return $data;
    }
    
    private function getAllDateList($uid,$startDate,$endDate) {
        $arr    =   array();
        $start  =   strtotime($startDate." 00:00:00");
        $end    =   strtotime($endDate." 23:59:59");
        
        for($i  =   $start; $i < $end; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $y      =   date("Y",$i);
            $m      =   date("n",$i);
            
            $w      =   date("w",$i);
            $weekend    =   0;
            if($w == 0 || $w == 6)
                $weekend    =  1;
            
            $arr[$y][$m]['month_days']  =   (int) date("t",$i);            
            $arr[$y][$m]['month_work_days']  = 0;
            $arr[$y][$m]['month_weekend_days']  = 0;
            $arr[$y][$m]['month_work_hours']  = 0;
            $arr[$y][$m]['total_user_hours']  = 0;            
            $arr[$y][$m]['total_by_law_holidays_days']  = 0;
            $arr[$y][$m]['total_by_law_holidays_hours']  = 0; 
            $arr[$y][$m]['total_by_law_sick_child_days']  = 0;//sick child
            $arr[$y][$m]['total_by_law_sick_child_hours']  = 0;//sick child
            if($this->enable_earn_minutes=='1'){
                $arr[$y][$m]['total_by_law_earn_min_days']  = 0;//earn minutes
                $arr[$y][$m]['total_by_law_earn_min_hours']  = 0;//earn minutes
                $arr[$y][$m]['taken_by_law_earn_min_days']  = 0;//earn minutes
                $arr[$y][$m]['taken_by_law_earn_min_hours']  = 0;//earn minutes
            }
            $arr[$y][$m]['total_by_law_sick_days']  = 0;
            $arr[$y][$m]['total_by_law_sick_hours']  = 0;
            
            $arr[$y][$m]['taken_by_law_holidays_days']  = 0;
            $arr[$y][$m]['taken_by_law_holidays_hours']  = 0;            
            $arr[$y][$m]['taken_by_law_sick_days']  = 0;
            $arr[$y][$m]['taken_by_law_sick_hours']  = 0;
            $arr[$y][$m]['taken_by_law_sick_child_days']  = 0;//sick child
            $arr[$y][$m]['taken_by_law_sick_child_hours']  = 0;//sick child
            
            
            
            $arr[$y][$m]['days'][$date] = [
                'date'=>$date,
                'date_str'=>date("d.m.Y",$i),
                'weekend'=>$weekend,
                'total_hours'=>0,
                'holiday'=>0,
                'sick'=>0,
                'sick_child'=>0,
                'holiday_hours'=>0,
                'sick_hours'=>0, 
                'sick_child_hours'=>0,
                'earn_minutes'=>0,
                'earn_minutes_hours'=>0,
                'month_day'=>(int)date("j",$i)
            ];
        }
        /*echo '<pre>';
        print_r($arr);
        echo '</pre>';*/
        
        $totals = $this->calculateTotals($uid,$arr, null);
        if(empty($totals))
            return array();
        
        foreach ($totals as $k=>$v) {
            $totals[$k] = round($v,2);
        }        
        return  $totals;
    }
    
    private function getAllDateListWeek($uid, $startDate, $endDate) {
        $arr    =   array();
        $start  =   strtotime($startDate." 00:00:00");
        $end    =   strtotime($endDate." 23:59:59");
        
        for($i  =   $start; $i < $end; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $y      =   date("Y",$i);
            $m      =   date("n",$i);
            
            $w      =   date("w",$i);
            $weekend    =   0;
            if($w == 0 || $w == 6)
                $weekend    =  1;
            
            $arr[$y][$m]['month_days']  =   (int) date("t",$i);            
            $arr[$y][$m]['month_work_days']  = 0;
            $arr[$y][$m]['month_weekend_days']  = 0;
            $arr[$y][$m]['month_work_hours']  = 0;
            $arr[$y][$m]['total_user_hours']  = 0;            
            $arr[$y][$m]['total_by_law_holidays_days']  = 0;
            $arr[$y][$m]['total_by_law_holidays_hours']  = 0; 
            $arr[$y][$m]['total_by_law_sick_child_days']  = 0;//sick child
            $arr[$y][$m]['total_by_law_sick_child_hours']  = 0;//sick child
            if($this->enable_earn_minutes=='1'){
                $arr[$y][$m]['total_by_law_earn_min_days']  = 0;//earn minutes
                $arr[$y][$m]['total_by_law_earn_min_hours']  = 0;//earn minutes
                $arr[$y][$m]['taken_by_law_earn_min_days']  = 0;//earn minutes
                $arr[$y][$m]['taken_by_law_earn_min_hours']  = 0;//earn minutes
            }
            $arr[$y][$m]['total_by_law_sick_days']  = 0;
            $arr[$y][$m]['total_by_law_sick_hours']  = 0;
            
            $arr[$y][$m]['taken_by_law_holidays_days']  = 0;
            $arr[$y][$m]['taken_by_law_holidays_hours']  = 0;            
            $arr[$y][$m]['taken_by_law_sick_days']  = 0;
            $arr[$y][$m]['taken_by_law_sick_hours']  = 0;
            $arr[$y][$m]['taken_by_law_sick_child_days']  = 0;//sick child
            $arr[$y][$m]['taken_by_law_sick_child_hours']  = 0;//sick child
            
            
            
            $arr[$y][$m]['days'][$date] = [
                'date'=>$date,
                'date_str'=>date("d.m.Y",$i),
                'weekend'=>$weekend,
                'total_hours'=>0,
                'holiday'=>0,
                'sick'=>0,
                'sick_child'=>0,
                'holiday_hours'=>0,
                'sick_hours'=>0, 
                'sick_child_hours'=>0,
                'earn_minutes'=>0,
                'earn_minutes_hours'=>0,
                'month_day'=>(int)date("j",$i)
            ];
        }
        /*echo '<pre>';
        print_r($arr);
        echo '</pre>';*/
        
        $totals = $this->calculateTotalsWeek($uid,$arr, null);
        if(empty($totals))
            return array();
        
        foreach ($totals as $k=>$v) {
            $totals[$k] = round($v,2);
        }        
        return  $totals;
    }
    
    private function getAllDateListWithEarnMinutes($uid, $startDate, $endDate, $earn_minutes_object, $calculated_totals = null) {
        $arr    =   array();
        $start  =   strtotime($startDate." 00:00:00");
        $end    =   strtotime($endDate." 23:59:59");
        
        for($i  =   $start; $i < $end; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $y      =   date("Y",$i);
            $m      =   date("n",$i);
            
            $w      =   date("w",$i);
            $weekend    =   0;
            if($w == 0 || $w == 6)
                $weekend    =  1;
            
           
            
            $arr[$y][$m]['total_by_law_earn_min_days']  = 0;//earn minutes
            $arr[$y][$m]['total_by_law_earn_min_hours']  = 0;//earn minutes
            $arr[$y][$m]['taken_by_law_earn_min_days']  = 0;//earn minutes
            $arr[$y][$m]['taken_by_law_earn_min_hours']  = 0;//earn minutes
          
           
            
            $earn_minutes=0;
            if($weekend==0){
                $earn_minutes=1;
            }
            $arr[$y][$m]['days'][$date] = [
                'date' => $date,
                'date_str' => date("d.m.Y", $i),
                'weekend' => $weekend,
                'total_hours' => 0,
                'holiday' => 0,
                'sick' => 0,
                'sick_child' => 0,
                'holiday_hours' => 0,
                'sick_hours' => 0,
                'sick_child_hours' => 0,
                'earn_minutes' => $earn_minutes,
                'earn_minutes_hours' => 0,
                'month_day' => (int) date("j", $i)
            ];
        }
        /*echo '<pre>';
        print_r($arr);
        echo '</pre>';*/
        
        $totals = $this->calculateTotalsEarnMinutes($uid,$arr, $earn_minutes_object, $calculated_totals);//gg
        if(empty($totals))
            return array();
        
        if($this->enable_break_time_changes != '1'){
            foreach ($totals as $k=>$v) {
                $totals[$k] = round($v,2);
            }   
        }
             
        return  $totals;
    }
    
    private function getAllDateListWithEarnMinutesWeek($uid, $startDate, $endDate, $earn_minutes_object, $calculated_totals = null) {
        $arr = [];
        $start = strtotime($startDate . " 00:00:00");
        $end = strtotime($endDate . " 23:59:59");

        for ($i = $start; $i < $end; $i += 43200) {
            $date = date("Y-m-d", $i);
            $y = date("Y", $i);
            $m = date("n", $i);

            $w = date("w", $i);
            $weekend = 0;
            if ($w == 0 || $w == 6)
                $weekend = 1;



            $arr[$y][$m]['total_by_law_earn_min_days'] = 0; //earn minutes
            $arr[$y][$m]['total_by_law_earn_min_hours'] = 0; //earn minutes
            $arr[$y][$m]['taken_by_law_earn_min_days'] = 0; //earn minutes
            $arr[$y][$m]['taken_by_law_earn_min_hours'] = 0; //earn minutes



            $earn_minutes = 0;
            if ($weekend == 0) {
                $earn_minutes = 1;
            }
            $arr[$y][$m]['days'][$date] = [
                'date' => $date,
                'date_str' => date("d.m.Y", $i),
                'weekend' => $weekend,
                'total_hours' => 0,
                'holiday' => 0,
                'sick' => 0,
                'sick_child' => 0,
                'holiday_hours' => 0,
                'sick_hours' => 0,
                'sick_child_hours' => 0,
                'earn_minutes' => $earn_minutes,
                'earn_minutes_hours' => 0,
                'month_day' => (int) date("j", $i)
            ];
        }


        $totals = $this->calculateTotalsEarnMinutesWeek($uid, $arr, $earn_minutes_object, $calculated_totals);//gg
        if (empty($totals))
            return [];

        if($this->enable_break_time_changes != '1'){
            foreach ($totals as $k=>$v) {
                $totals[$k] = round($v,2);
            }   
        }
        return $totals;
    }

    private function calculateItems($dbItems,$hdaysArr){
        $result  =  array();
        if(empty($dbItems))
            $dbItems =  array();
        foreach ($dbItems as $item) {
            $item   =   (array)$item;
            $date   =   $item['date'];
            if(isset($hdaysArr[$date])) {  
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/sick_child_calc.html', print_r($hdaysArr[$date], true), FILE_APPEND | LOCK_EX);
                
                $t  = $this->calculateItem($item);                
                $t  = floatval($t);
                if(in_array(6, $hdaysArr[$date])) {//6-color code
                    if(!isset($result[$date]['holiday_hours']))
                        $result[$date]['holiday_hours']  = 0;
                    $result[$date]['holiday_hours'] += $t;
                }                
                if(in_array(2, $hdaysArr[$date])) {//2-color code
                    if(!isset($result[$date]['sick_hours']))
                        $result[$date]['sick_hours']  = 0;
                    $result[$date]['sick_hours'] += $t;
                }
                if(in_array(1, $hdaysArr[$date])) {//1-color code
                    if(!isset($result[$date]['sick_child_hours']))
                        $result[$date]['sick_child_hours']  = 0;
                    $result[$date]['sick_child_hours'] += $t;
                }
                if($this->enable_earn_minutes=='1'){
                  if(!isset($result[$date]['earn_minutes_hours']))
                        $result[$date]['earn_minutes_hours']  = 0;
                    $result[$date]['earn_minutes_hours'] += $t;
                }
            }
        }
        return $result;
    }
    
    private function calculateItemsEarnMinutesWithWorkingDaysRadio($dbItems, $hdaysArr)
    {
        $result  =  array();
        if(empty($dbItems))
            $dbItems =  array();
        foreach ($dbItems as $item) {
            $item   =   (array)$item;
            $date   =   $item['date'];
            if(isset($hdaysArr[$date])) {  
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/sick_child_calc.html', print_r($hdaysArr[$date], true), FILE_APPEND | LOCK_EX);
                
                $t  = $this->calculateItemEarnMinutesWorkingDaysRadio($item);                
                //$t  = floatval($t);
                /*if(in_array(6, $hdaysArr[$date])) {//6-color code
                    if(!isset($result[$date]['holiday_hours']))
                        $result[$date]['holiday_hours']  = 0;
                    $result[$date]['holiday_hours'] += $t;
                }                
                if(in_array(2, $hdaysArr[$date])) {//2-color code
                    if(!isset($result[$date]['sick_hours']))
                        $result[$date]['sick_hours']  = 0;
                    $result[$date]['sick_hours'] += $t;
                }
                if(in_array(1, $hdaysArr[$date])) {//1-color code
                    if(!isset($result[$date]['sick_child_hours']))
                        $result[$date]['sick_child_hours']  = 0;
                    $result[$date]['sick_child_hours'] += $t;
                }*/
                
                  if(!isset($result[$date]['earn_minutes_hours']))
                        $result[$date]['earn_minutes_hours']  = 0;
                    $result[$date]['earn_minutes_hours'] += $t;
                
            }
        }
        return $result;
    }
    
    private function calculateItemsEarnMinutes($dbItems){
        $result  =  array();
        if(empty($dbItems))
            $dbItems =  array();
        foreach ($dbItems as $item) {
            $item   =   (array)$item;
            $date   =   $item['date'];
            //if(isset($hdaysArr[$date])) {  
                //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/sick_child_calc.html', print_r($hdaysArr[$date], true), FILE_APPEND | LOCK_EX);
                
                $t  = $item['earned_minutes'];
               // $t  = $this->calculateItemEarnMinutes($item);                
                //$t  = floatval($t);
                
                if($this->enable_earn_minutes=='1'){
                    if(!isset($result[$date]['earn_minutes_hours'])){
                      //echo '!isset';
                        $result[$date]['earn_minutes_hours']  = 0;
                    }
                    $result[$date]['earn_minutes_hours'] += $t;
                }
            //}
        }
        return $result;
    }
    
    private function calculateItem($item) {        
        $new_hours  =  trim($item['new_hours']);
        if(strlen($new_hours) < 1)
            return 0;        
        $total  =   0; 
        $new_hoursArr  =   explode(":", $new_hours);
        if(count($new_hoursArr) > 0) {
            $total  = $new_hoursArr[0];
        }        
        if(count($new_hoursArr) > 1) {
            $total  = $total.".".$new_hoursArr[1];
        }        
        $total  = floatval($total);
        return $total;
    }
    
    private function calculateItemEarnMinutesWorkingDaysRadio($item) {        
        /*$new_hours  =  trim($item['new_hours']);
        if(strlen($new_hours) < 1)
            return 0;        
        $total  =   0; 
        $new_hoursArr  =   explode(":", $new_hours);
        if(count($new_hoursArr) > 0) {
            $total  = $new_hoursArr[0];
        }        
        if(count($new_hoursArr) > 1) {
            $total  = $total.".".$new_hoursArr[1];
        }        
        $total  = floatval($total);
        return $total;*/
        if(!empty($item)){
            return 1;
        } else{
            return 0;
        }
    }
    
    private function calculateItemEarnMinutes($item) {        
        $new_hours  =  trim($item['earned_minutes']);
        if(strlen($new_hours) < 1)
            return 0;        
        $total  =   0;
        $new_hoursArr  =   explode(":", $new_hours);
        if(count($new_hoursArr) > 0) {
            $total  = $new_hoursArr[0];
        }        
        if(count($new_hoursArr) > 1) {
            $total  = $total.".".$new_hoursArr[1];
        }        
        $total  = floatval($total);
        return $total;
    }
    
    private function getPercentValueKey(string $key)
    {
        $arr = [
            //'no_holiday',
            '24_days_chk' => '24_days_val',
            '25_days_chk' => '25_days_val',
            '27_days_chk' => '27_days_val',
            'days_29_chk' => 'days_29_val',
            '30_days_chk' => '30_days_val'
        ];
        
        return $arr[$key];
    }

    public function loadHolidaysPercent(int $user_id, string $mode)
    {
        //file_put_contents( '/home/curiotime/newdev.curiotime.com/logs/loadHolidaysPercent.html', print_r(func_get_args(), true), FILE_APPEND | LOCK_EX);
        
        JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');
        $model = JModelLegacy::getInstance('Rules', 'AuditModel');
        $user_obj = & JFactory::getUser($user_id);
        $res = null;
        
        if($user_obj->id != 0 && ($user_obj->rule_number0 != 0)){
            $parent_rule_id = $user_obj->rule_number0;
            $holiday_percent_obj = $model->getHolidayPercent($parent_rule_id, $user_obj->owner_id);
            if($mode == 'raw'){
                return $holiday_percent_obj;
            }
            /*echo '<pre>';
            print_r($holiday_percent_obj);
            echo '</pre>';*/
            if($holiday_percent_obj[0]->no_holiday == 1){
               // $res = $holiday_percent_obj[0]->no_holiday_val;
                $res = false;
               
                return $res;
            } else{
                unset(
                        $holiday_percent_obj[0]->id, 
                        $holiday_percent_obj[0]->manager_id, 
                        $holiday_percent_obj[0]->parent_rule_id, 
                        $holiday_percent_obj[0]->date_create,
                        $holiday_percent_obj[0]->timestamp_create,
                        $holiday_percent_obj[0]->no_holiday, 
                        $holiday_percent_obj[0]->no_holiday_val      
                );
            
                $key = array_search('1', (array)$holiday_percent_obj[0]);
                //echo '$key:' . $key;
                
                $percent_value_key = $this->getPercentValueKey( $key);
                $res = $holiday_percent_obj[0]->{$percent_value_key};
                
                
            }
        }
        
        return $res;
    }
    
    public function getFromTo($u_id) {
        $from_to = $this->getInputsPayPeriod($u_id);
        
        //file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($from_to.PHP_EOL, true), FILE_APPEND | LOCK_EX); 
         
        $current_date = date('d.m.Y');

        $from_date1 = DateTime::createFromFormat('d.m.Y', $from_to->from_date);
        $from_date2 = $from_date1->format('d');
        $from_date = $from_date2 . date('.m.Y');

        $to_date1 = DateTime::createFromFormat('d.m.Y', $from_to->to_date);
        $to_date2 = $to_date1->format('d');

        if ($from_date2 == '01')
            $to_date = $to_date2 . date('.m.Y');
        else
            $to_date = $to_date2 . date('.m.Y', strtotime('+1month'));

        //echo '<br/>'.$from_date;

        if ($current_date < $from_date) {
            //echo 'попали';
            $from_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');

            $from_date_strtotime = strtotime($from_date_row . '-1months');
            //$from_date_strtotime1=strtotime("$from_date_strtotime -1 month");
            $from_date = date('d.m.Y', $from_date_strtotime);
            $from_date00 = date('Y-m-d', $from_date_strtotime);
            $count_days_in_month = date('t', strtotime($from_date00));

            if ($count_days_in_month == 31) {
                $from_date_strtotime = strtotime($from_date_row . '-1months');
                $from_date = date('d.m.Y', $from_date_strtotime);
            }


            $to_date_row = DateTime::createFromFormat('d.m.Y', $from_date)->format('Y-m-d');
            $to_date_strtotime = strtotime($to_date_row . '+1months -1days');
            $to_date = date('d.m.Y', $to_date_strtotime);
        }
        if (empty($from_date) && empty($to_date)) {
            $from_final = '25' . date('m.Y', strtotime('-1 month'));
            $to_final = '24' . date('m.Y', strtotime('+0 month'));
        } else {
            $from_final=$from_date;
            $to_final=$to_date;
        }
        
        return [
            'from'=>$from_final,
            'to'=>$to_final
        ];
    }
    
    public function getInputsPayPeriod($u_id)
    {
        $user_obj = & JFactory::getUser($u_id);
        
        
        $query = "SELECT * FROM #__pay_period_preserved WHERE `id_user` = '$user_obj->owner_id'";
        $this->db->setQuery($query);
        //get current gps status
        $res = $this->db->loadObject();
        
        
         
        if(empty($res)){
            $from_date='25.'.date('m.Y', strtotime('-1 month'));
            $to_date='24.'.date('m.Y', strtotime('+0 month')); 
            
            $res['id_user']=$u_id;
            $res['from_date']=$from_date;
            $res['to_date']=$to_date;
            $res=(object)$res;
        }
      
        return $res;
    }
    
    private function getPayPeriodWitoutMonthlyLimit(string $token, string $lang, object $user_obj, string $from, string $to, $additional_mode, $note, $groups, $tasks, $json_data, int $is_load_for_new_pay_period) {
       

        ini_set('memory_limit', '-1');
        $curr_user = clone $user_obj;
        JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
        $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');
        $user_id = $user_obj->id;
        $this->sick_child_state = $model_settings->getSickChildStateAndConfig($curr_user->owner_id);
        //echo $this->sick_child_state;

        if ($lang == 'is') {
            $this->lang->setLanguage('is-IS');
            $this->lang->load();
        }

        //if (in_array(6, $curr_user->groups)) {
            //$manager_users_object = $this->getUsersFromManagerCheckHidden($user_id);//get manager users
            $manager_users_object = [$curr_user];
       // } elseif (in_array(10, $curr_user->groups)) {
            //$manager_users_object = $this->getUsersFromManagerCheckHidden($curr_user->owner_id);//get manager users
            //$manager_users_object = [$curr_user];
       // }
        
        $tasks = $json_data['tasks0'];


        $html = [];
        $i = 0;
        $parser_mode = 'simplehtml'; //default or simplehtml

       // include_once($_SERVER['DOCUMENT_ROOT'] . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');

        if (empty($from) && empty($to)) {
            $from_to_obj = $this->getFromTo($user_id);
            $from = $from_to_obj['from'];
            $to = $from_to_obj['to'];
        }
        //file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/fix_percent.html', print_r($manager_users_object, true), FILE_APPEND | LOCK_EX);
        try {
            if ($additional_mode == 'search') {
                if (!empty($groups)) {
                    $groups_array = explode(',', $groups);
                }
                if (!empty($tasks)) {
                    $tasks_array = explode(',', $tasks);
                }
            }
        } catch (Exception $ex) {
            $groups_array = '';
            $tasks_array = '';
        }
        

        foreach($manager_users_object as $manager_user) {
            
            $u  =  JFactory::getUser($manager_user->id);
            if(count($manager_users_object)>1 && in_array(6, $u->groups)) continue;            
            
            if(in_array($manager_user->group_user, $groups_array) || empty($groups_array[0])) {
                
                $html[$i]['user_info']['id'] = $manager_user->id;
                $html[$i]['user_info']['unical_id'] = $manager_user->username;
                $html[$i]['user_info']['username'] = $manager_user->username0;

                switch ($additional_mode) {
                    case 'search':
                      
                        if ($manager_user->owner_id != $manager_user->id) {
                            if (empty($tasks_array)) {
                                $link = $this->current_url . 'index.php?task=getTimeByPeriodCollectSearch&from=' . $from . '&to=' . $to . '&u_id=' . $manager_user->id . '&lang=' . $lang . '&mode=pdf&mode_all_user=1&note=' . urlencode($note) . '&group=' . urlencode($groups) . '&is_load_for_new_pay_period=' . $is_load_for_new_pay_period . '&load_for_holidays_percent=1';
                            } else {
                                $link = $this->current_url . 'index.php?task=getTimeByPeriodCollectWithTasks&from=' . $from . '&to=' . $to . '&u_id=' . $manager_user->id . '&lang=' . $lang . '&mode=pdf&mode_all_user=1&tasks0=' . urlencode(implode(',', $tasks_array)) . '&is_load_for_new_pay_period=' . $is_load_for_new_pay_period . '&load_for_holidays_percent=1';
                            }
                        }
                        break;
                    default:
                        $link = $this->current_url . 'index.php?task=getTimeByPeriodCollect&from=' . $from . '&to=' . $to . '&u_id=' . $manager_user->id . '&lang=' . $lang . '&mode=pdf&mode_all_user=1&is_load_for_new_pay_period=' . $is_load_for_new_pay_period . '&load_for_holidays_percent=1';
                        break;
                }
                $html[$i]['link'] = $link;
                $html[$i]['from'] = $from;
                $html[$i]['to'] = $to;
           
                
                if($parser_mode === 'simplehtml'){
                    //$html1 = str_get_html(file_get_contents($link));
                    $html1 = file_get_contents($link);
                } elseif($parser_mode === 'default'){
                    $html1 = file_get_contents($link);
                
                    $dom = new DOMDocument;	
                    $dom->validateOnParse = true;
                    $dom->loadHTML(mb_convert_encoding($html1, 'HTML-ENTITIES', 'UTF-8'));	
                    $finder = new DomXPath($dom);
                } 
                if($parser_mode === 'simplehtml' && empty($html1) == false){
                    
                  
                       // $html[$i]['pay_period'] = htmlspecialchars($html1);
                        /*$html[$i]['pay_period'] = $layout;
                    }*/
                    $html[$i]['pay_period'] = htmlspecialchars($html1);
                } elseif($parser_mode === 'default'){
                    $classname= "pdf_not_width";
                    $nodes = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]");

                    foreach($nodes as $e){
                        $layout = $e->ownerDocument->saveHTML();
                    }
                    
                    $html[$i]['pay_period'] = htmlspecialchars($layout); 
                }   

                $i++;
            }
        }
        
        //clean memory
        if($parser_mode === 'simplehtml'){
          //  $html1->clear(); 
          //  unset($html1);
        }
        return $html[0];

        //temporary save pay periods
       // $this->savePayPeriod(strip_tags($token), $html);   
    }
    
    private function calcHours($total_h1, $total_m1, $limit = 0, $echo = 1){
      //  file_put_contents('/home/curiotime/app.curiotime.com/logs/collect.html', print_r($total_h1.'-'.$total_m1.'<br/>'.PHP_EOL, true),  FILE_APPEND | LOCK_EX); 
        
        $h = @$total_h1 * 3600;
        $m = @$total_m1 * 60;
        $s = $h + $m;

        $hour = floor($s / 3600);
        $sec = $s - ($hour * 3600);
        $min = ($sec / 60);
        $sec = $sec - ($min * 60);

        if ($min < 10) {
            $min = '0' . $min;
        }

        if($hour >= 8 && $limit != 0){
            if($echo == 1){
                return "08:00";
            } else{
                return "08:00";
            }
        } else{
            if($echo == 1){
                return $hour . ":" . $min;
            } else{
                return $hour . ":" . $min;
            }
        }
    }
    
    private function preparePayPeriodOfHtmlWithTextForHolidayPercent(string $html, object $user_obj, string $lang) 
    {
        ini_set('memory_limit', '-1');
        /*ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);*/
        
        $parser_mode = 'default';
        
        if ($parser_mode === 'simplehtml') {
            include_once($_SERVER['DOCUMENT_ROOT'] . '/components/com_audit/assets/incl/simplehtmldom_1_5/simple_html_dom.php');

            //$time_start = microtime(true);
             $decoded_html = htmlspecialchars_decode($html);
            //$decoded_html = $html;
            //  $time_end = microtime(true);
            //  $execution_time = ($time_end - $time_start) / 60;
            //  $exc_time = '<b>Total Execution Time:</b> '.$execution_time.' Mins';
            //  file_put_contents($_SERVER['DOCUMENT_ROOT'] . '/logs/speed_optimization.html', print_r($exc_time . PHP_EOL, true), FILE_APPEND | LOCK_EX);


            $dom = str_get_html($decoded_html);



            $q1 = $dom->find('table[class="pdf_not_width"]');


            $totalsJson = [];
            if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
                $totalsJson = json_decode($arr[1], true);
            }

            JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
            $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');

            $user = clone $user_obj;
            $sick_child_state = $model_settings->getSickChildStateAndConfig($user->owner_id);
            $sick_state = $model_settings->getSickState($user->owner_id);

            $result = [];
            foreach ($q1 as $table) {
                $dates = $table->find('*[class="api_raw_date"]');
                $totals = $table->find('*[class="api_custom_td_1"]');
                $rows_id = $table->find('*[id="hidden_row_id"]');
                $daytimes = $table->find('*[class="api_daytime"]');
                $daytime_sum = $table->find('*[class="app_api_tr_bottom_td_daytime"]', 0);
                //return 'dd';
                $i = 0;
                foreach ($dates as $date) {
                    $result[$i]['raw_date'] = $date->plaintext;
                    //$result[$i]['date'] = $date->plaintext;


                    $result[$i]['total'] = trim(strip_tags($totals[$i]));
                    $result[$i]['daytime'] = trim(strip_tags($daytimes[$i]));
                    //check cell edited or set color
                    $total_edited = strripos($totals[$i], 'red-line');

                    //check colors
                    $total_color_red = strripos($totals[$i], 'pay_period_td_background_red');
                    $total_color_yellow = strripos($totals[$i], 'pay_period_td_background_yellow');
                    $total_color_green = strripos($totals[$i], 'pay_period_td_background_green');
                    $total_color_blue = strripos($totals[$i], 'pay_period_td_background_blue');
                    $total_color_gray = strripos($totals[$i], 'pay_period_td_background_gray');

                    //set cell edited
                    if ($total_edited == true) {
                        $result[$i]['total_edited'] = 1;
                    }

                    //set colors
                    if ($total_color_red == true) {
                        $result[$i]['total_color'] = 'red';
                    }
                    if ($total_color_yellow == true) {
                        $result[$i]['total_color'] = 'yellow';
                    }
                    if ($total_color_green == true) {
                        $result[$i]['total_color'] = 'green';
                    }
                    if ($total_color_blue == true) {
                        $result[$i]['total_color'] = 'blue';
                    }
                    if ($total_color_gray == true) {
                        $result[$i]['total_color'] = 'gray';
                    }

                    if (!empty($rows_id[$i])) {
                        $result[$i]['row_id'] = trim($rows_id[$i]->getAttribute('value'));
                    } else {
                        $result[$i]['row_id'] = '';
                    }

                    $i++;
                }
            }
            $count = count($result);

            foreach ($dom->find('*[class="total-h"]') as $ee) {
                $result['global_totals']['total'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-daytime"]') as $ee) {
                $result['global_totals']['daytime'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-afterwork"]') as $ee) {
                $result['global_totals']['afterwork'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-night_time"]') as $ee) {
                $result['global_totals']['night_time'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-weekend"]') as $ee) {
                $result['global_totals']['weekend'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-holidays90"]') as $ee) {
                $result['global_totals']['holidays_90'] = trim($ee->plaintext);
            }
            foreach ($dom->find('*[class="t-holidays45"]') as $ee) {
                $result['global_totals']['holidays_45'] = trim($ee->plaintext);
            }
            if ($sick_state == '1') {
                foreach ($dom->find('*[class="t-holidays_sick"]') as $ee) {
                    $result['global_totals']['sick'] = trim($ee->plaintext);
                }
            }
            if ($sick_child_state == '1') {
                foreach ($dom->find('*[class="t-sick_child"]') as $ee) {
                    $result['global_totals']['sick_child'] = trim($ee->plaintext);
                }
            }
            foreach ($dom->find('*[class="t-breaks"]') as $ee) {
                $result['global_totals']['break'] = trim($ee->plaintext);
            }


            if (isset($totalsJson['daytime']))
                $result['global_totals']['daytime'] = $totalsJson['daytime']['total'];
            if (isset($totalsJson['after_hours']))
                $result['global_totals']['afterwork'] = $totalsJson['after_hours']['total'];
            if (isset($totalsJson['night']))
                $result['global_totals']['night_time'] = $totalsJson['night']['total'];
            if (isset($totalsJson['weekends']))
                $result['global_totals']['weekend'] = $totalsJson['weekends']['total'];
            if (isset($totalsJson['holidays_90']))
                $result['global_totals']['holidays_90'] = $totalsJson['holidays_90']['total'];
            if (isset($totalsJson['holidays_45']))
                $result['global_totals']['holidays_45'] = $totalsJson['holidays_45']['total'];
            if ($sick_state == '1') {
                if (isset($totalsJson['sick']))
                    $result['global_totals']['sick'] = $totalsJson['sick']['total'];
            }
            if ($sick_child_state == '1') {
                if (isset($totalsJson['sick_child']))
                    $result['global_totals']['sick_child'] = $totalsJson['sick_child']['total'];
            }
            $result['daytime_sum'] = $daytime_sum->plaintext;
            //$result['raw'] = $totalsJson;

            JLoader::register('AuditModelRules', JPATH_ROOT . '/components/com_audit/models/rules.php');

            $model_rules = JModelLegacy::getInstance('Rules', 'AuditModel');
            $rule_mode = $model_rules->getUserRuleForText($user->id);
            $header_texts_obj = $model_rules->getTexts($rule_mode['mode'], $rule_mode['rule_id'], $lang);

            if ($lang === 'is') {
                $lang1 = & JFactory::getLanguage();
                $lang1->setLanguage('is-IS');
                $lang1->load();
                $extension = 'com_audit';
                $base_dir = JPATH_SITE;
                $language_tag = 'is-IS';
                $reload = true;
                $lang1->load($extension, $base_dir, $language_tag, $reload);
            }

            $result['global_totals']['total_txt'] = JText::_('COM_AUDIT_OVERVIEW_TIME_TOTAL_LOGIN');
            $result['global_totals']['daytime_txt'] = $header_texts_obj->daytime_text;
            $result['global_totals']['afterwork_txt'] = $header_texts_obj->after_hours_text;
            $result['global_totals']['night_time_txt'] = $header_texts_obj->night_time_text;
            $result['global_totals']['weekend_txt'] = $header_texts_obj->weekends_text;
            $result['global_totals']['holidays_90_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 90%';
            $result['global_totals']['holidays_45_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_HOLIDAYS') . ' 45%';
            $result['global_totals']['sick_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK');
            $result['global_totals']['sick_child_txt'] = JText::_('COM_AUDIT_TIME_DK_HEADER_SICK_CHILD');
            $result['global_totals']['break_txt'] = JText::_('COM_AUDIT_PAY_PERIOD_TOTAL_BREAK2');

            $dom->clear();
            unset($dom);
        } elseif ($parser_mode === 'default') {
            $dom = new DOMDocument;	
            $dom->validateOnParse = true;
            $dom->loadHTML(mb_convert_encoding(htmlspecialchars_decode($html), 'HTML-ENTITIES', 'UTF-8'));	
            $finder = new DomXPath($dom);
            
            $classname = "pdf_not_width";
            $nodes = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname ')]");
            
            $totalsJson = [];
            if (preg_match("#<!--json-dk-totals--(.*)--json-dk-totals-->#", $html, $arr)) {
                $totalsJson = json_decode($arr[1], true);
            }

            JLoader::register('AuditModelTime_Wages', JPATH_ROOT . '/components/com_audit/models/time_wages.php');
            $model_settings = JModelLegacy::getInstance('Time_Wages', 'AuditModel');

            $user = clone $user_obj;
            $sick_child_state = $model_settings->getSickChildStateAndConfig($user->owner_id);
            $sick_state = $model_settings->getSickState($user->owner_id);

            $result = [];
           // foreach ($nodes as $table) {
                //$dates = $table->find('*[class="api_raw_date"]');
                /*$classname_dates = "api_raw_date";
                $dates = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname_dates ')]");
            
                //$totals = $table->find('*[class="api_custom_td_1"]');
                $classname_totals = "api_custom_td_1";
                $totals = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname_totals ')]");
                
                //$rows_id = $table->find('*[id="hidden_row_id"]');
                $hidden_row_id = "hidden_row_id";
                $rows_id = $finder->query("//*[@id='$hidden_row_id']")->item(0);
                
                //$daytimes = $table->find('*[class="api_daytime"]');
                $classname_daytimes = "api_daytime";
                $daytimes = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname_daytimes ')]");
                
                //$daytime_sum = $table->find('*[class="app_api_tr_bottom_td_daytime"]', 0);*/
                $classname_daytime_sum = "app_api_tr_bottom_td_daytime";
                $daytime_sum = $finder->query("//*[contains(concat(' ', normalize-space(@class), ' '), ' $classname_daytime_sum ')]")->item(0);
                $result['daytime_sum'] = $daytime_sum->textContent;
                
                /*$i = 0;
                foreach ($dates as $date) {
                    //$result[$i]['raw_date'] = $date->plaintext;
                    /*$dom = new DOMDocument;	
                    $dom->validateOnParse = true;
                    $dom->loadHTML(mb_convert_encoding($html, 'HTML-ENTITIES', 'UTF-8'));	
                    $finder = new DomXPath($dom);
            
                    $xpath = new DOMXPath($dom);
                    $node = $xpath->query('//div/text()')->item(0);
                    $result[$i]['raw_date'] =  $node->textContent; // text*//*
                    $result[$i]['raw_date'] = $date;
                    $i++;
                }*/
           // }
        }

        return $result;
    }
    
    private function loadPayPeriodData(object $user_obj, string $from, string $to, $mode = null) {
        if ($mode === 'may') {
            $token = $user_obj->api_token;
            $lang = 'en';
           
            $additional_mode = '';
            $note = '';
            $groups = '';
            $tasks = '\'\'';
            $json_data = [
                'groups'
            ];
            $is_load_for_new_pay_period = 1;
            
            $current_date = time();//?
            //$current_date = strtotime(date('Y') . '-08-16 00:00:00');//emulate future date > 01.05 for test
            //$first_may_of_current_year = date('d.m.Y H:i:s', strtotime(date('Y') . '-05-01 00:00:00'));
            $first_may_of_current_year = strtotime(date('Y') . '-05-01 00:00:00');
           
            
            if($current_date > $first_may_of_current_year){
                $from1 = '01.05.' . date('Y', strtotime('this year'));
                $to1 = date('d.m.Y', strtotime('last day of this month'));
            } else{
                $from1 = '01.05.' . date('Y', strtotime('last year'));
                $to1 = date('d.m.Y', strtotime('last day of this month'));
            }
            
            
            if(!empty($token)){
                //$time_start = microtime(true);
                $raw_result = $this->getPayPeriodWitoutMonthlyLimit($token, $lang, $user_obj, $from1, $to1, $additional_mode, $note, $groups, $tasks, $json_data, $is_load_for_new_pay_period);
               
                
                
                
                if(empty($raw_result['pay_period'])){
                    throw new Exception('Error from load pay period data from 01.05 to current date for holidays percent: User timesheet is empty');
                }
                $res = $this->preparePayPeriodOfHtmlWithTextForHolidayPercent($raw_result['pay_period'], $user_obj, $lang);
               
                
                return $res;
            }
            
        } else {
            if ($curl = curl_init()) {
                $url = 'https://' . $_SERVER['SERVER_NAME'] . '/index.php?task=getPayPeriod4WithTextsForHolidaysPercent';

                curl_setopt($curl, CURLOPT_URL, $url);
                curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 0);
                curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
                curl_setopt($curl, CURLOPT_POST, true);
                curl_setopt($curl, CURLOPT_POSTFIELDS, 'lang=en&u_id=' . $user_obj->id . '&from=' . $from . '&to=' . $to);
                $out = curl_exec($curl);
                curl_close($curl);
            }
            $data = json_decode(trim($out), true);
            //$data = trim($out);

            if (empty($data)) {
                $data = [];
            }



            $respData['message'] = '';
            $respData['data'] = $data;
            $respData['out'] = $out;
        }

        return $respData;
    }

    private function sumDaytime(array $array_of_pay_period_data)
    {
        $filtered_daytimes_only = array_column($array_of_pay_period_data, 'daytime');
        $total = 0;
        
        foreach($filtered_daytimes_only as $one_item){
            if(!empty($one_item)){
                $arr = explode(':', $one_item);
                $h = $arr[0];
                $m = $arr[1];
                
                $sum_h += $h;
                $sum_m += $m;
                
               
            }
          
        }
        
        
        return $total;
    }
    
    private function normalizeStringToFloat(string $string)
    {
        return str_replace(':', '.', $string);
    }

    private function calculateTotalsAsHolidayPercentScheme(int $user_id, $totals, $earn_min_mode, $holiday_percent_obj, $from, $to, string $load_type) 
    {
                    
        $user_obj = & JFactory::getUser($user_id);
        $res = null;
        $hdaysArr =  [];
        $hdaysStrArr =  [];
        
        if(empty($from) || empty($to)){
            $arr = $this->getFromTo($user_id);
            $from = $arr['from'];
            $to = $arr['to'];
            
        }
        $array_of_pay_period_data = $this->loadPayPeriodData($user_obj, $from, $to, '');//load monthly data from month for extract daytime
        
        if($load_type === 'calendar'){
            $array_of_pay_period_data_from_first_may = $this->loadPayPeriodData($user_obj, $from, $to, 'may');
            
            $daytime_sum_from_first_may = $array_of_pay_period_data_from_first_may['daytime_sum'];
           
        }
       
        
        if(!empty($array_of_pay_period_data['data']['errors'])){
            return false;
        }
      
        $daytime_sum = $array_of_pay_period_data['data']['res']['daytime_sum'];
        $normalize_daytime_sum = $this->normalizeStringToFloat($daytime_sum);
      
        if($load_type === 'calendar'){
            $normalize_daytime_from_first_may_sum = $this->normalizeStringToFloat($daytime_sum_from_first_may);
            
           
        }

        $query  =   "SELECT * FROM #__user_report_items WHERE (status=6 OR status=2 OR status=1) AND `id_user`= ".$this->db->quote($user_id);
        $this->db->setQuery( $query );
        $hdays    =   $this->db->loadObjectList();
        
        foreach ($hdays as $item) {
            $date  =  $item->year."-".sprintf('%02d', $item->month)."-".sprintf('%02d',$item->day);
            $hdaysArr[$date][] = intval($item->status);
            $hdaysStrArr[]  =  "'{$date}'";
        }
      
        
        if(count($hdaysStrArr) > 0) {
            $query  =   "SELECT * FROM #__audit_time WHERE `date` in ( ".join(",",$hdaysStrArr)."  ) AND `id_user`= ".$this->db->quote($user_id);
            $this->db->setQuery( $query );
            $dbItems    =   $this->db->loadObjectList(); 
        } else {
            $dbItems  =  array();
        }
        
       
        $dbDates    =   $this->calculateItems($dbItems,$hdaysArr);
       
        $sickDateAvailsble = array();
        $c  = strtotime(date("Y-m-d 23:59:59"));
        for($i= strtotime("-1 year"); $i < $c; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $sickDateAvailsble[$date] = $date;
        }
        $vars  =  $this->getValuesByUserCompanyAge($user_obj->id);  
        //file_put_contents( '/home/curiotime/newdev.curiotime.com/logs/empl_pdf_calc_holidays_fix.html', print_r($vars, true), FILE_APPEND | LOCK_EX);
        if(empty($vars))
            return array();
        $yearTotals  =  array();
        
        $yearTotals['total_by_law_holidays_days']       =   0;
        $yearTotals['total_by_law_holidays_hours']      =   0;
        $yearTotals['total_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['total_by_law_sick_child_hours']      =   0;//sick child
        if($this->enable_earn_minutes=='1'){
            $yearTotals['total_by_law_earn_min_days']  = 0;//earn minutes
            $yearTotals['total_by_law_earn_min_hours']  = 0;//earn minutes
        }
        $yearTotals['total_by_law_sick_days']           =   0;
        $yearTotals['total_by_law_sick_hours']          =   0;
        
        $yearTotals['taken_by_law_holidays_days']       =   0;
        $yearTotals['taken_by_law_holidays_hours']      =   0;
        $yearTotals['taken_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['taken_by_law_sick_child_hours']      =   0;//sick child
        
        if($this->enable_earn_minutes=='1'){
            $yearTotals['taken_by_law_earn_min_days']       =   0;//earn minutes
            $yearTotals['taken_by_law_earn_min_hours']      =   0;//earn minutes
        }
        $yearTotals['taken_by_law_sick_days']           =   0;
        $yearTotals['taken_by_law_sick_hours']          =   0;
        
        $yearTotals['new_monthly_total'] = $normalize_daytime_sum * ($holiday_percent_obj / 100);
        $yearTotals['new_monthly_total_days'] = $yearTotals['new_monthly_total'] / 8;
                    
        if($load_type === 'calendar'){
            /*if($user_id == 4105){
                    echo '<pre>$normalize_daytime_from_first_may_sum';
                    print_r($normalize_daytime_from_first_may_sum);
                    echo '</pre>';
            }
          
            if(empty($holiday_percent_obj)){
                $holiday_percent_obj  = 0;
            }*/
            $yearTotals['new_holidays_hours_from_first_may'] = $normalize_daytime_from_first_may_sum * ($holiday_percent_obj / 100);
            $yearTotals['new_holidays_days_from_first_may'] = $yearTotals['new_holidays_hours_from_first_may'] / 8;
        }
        
        if ($user_obj->id != 0 && $user_obj->rule_number0 != 0) {
            foreach ($totals as $year => $months) {
                foreach ($months as $m => $month) {

                    $md2 = intval($month['month_days'] / 2);

                    $month_by_law_holidays_days = 0;
                    $month_by_law_holidays_hours = 0;
                    $month_by_law_sick_days = 0;
                    $month_by_law_sick_hours = 0;
                    $month_by_law_sick_child_days = 0; //sick child
                    $month_by_law_sick_child_hours = 0; //sick child

                    if ($this->enable_earn_minutes == '1') {
                        $month_by_law_earn_minutes_days = 0; //earn minutes
                        $month_by_law_earn_minutes_hours = 0; //earn minutes
                    }
                    $month_holidays_days = 0;
                    $month_holidays_hours = 0; 
                    $month_sick_days = 0;
                    $month_sick_hours = 0;
                    $month_sick_child_days = 0; //sick child
                    $month_sick_child_hours = 0; //sick child
                    
                    if ($this->enable_earn_minutes == '1') {
                        $month_earn_minutes_days = 0; //earn minutes
                        $month_earn_minutes_hours = 0; //earn minutes
                    }

                    $totalHours = 0;
                    foreach ($month['days'] as $date => $day) {

                        $hours = 0;
                        if (isset($dbDates[$date]['holiday_hours'])) {
                            $totals[$year][$m]['days'][$date]['holiday_hours'] = $dbDates[$date]['holiday_hours'];
                            $totals[$year][$m]['days'][$date]['holiday'] = 1;
                        }
                        if (isset($dbDates[$date]['sick_hours'])) {
                            $totals[$year][$m]['days'][$date]['sick_hours'] = $dbDates[$date]['sick_hours'];
                            $totals[$year][$m]['days'][$date]['sick'] = 1;
                        }
                        //sick child
                        if (isset($dbDates[$date]['sick_child_hours'])) {
                            $totals[$year][$m]['days'][$date]['sick_child_hours'] = $dbDates[$date]['sick_child_hours'];
                            $totals[$year][$m]['days'][$date]['sick_child'] = 1;
                        }
                        $day = $totals[$year][$m]['days'][$date];


                        if ($day['sick'] && isset($sickDateAvailsble[$date])) {

                            $totals[$year][$m]['taken_by_law_sick_days'] += 1;
                            $totals[$year][$m]['taken_by_law_sick_hours'] += $day['sick_hours'];

                            $yearTotals['taken_by_law_sick_days'] += 1;
                            $yearTotals['taken_by_law_sick_hours'] += $day['sick_hours'];
                        }
                        if ($day['holiday']) {
                            $totals[$year][$m]['taken_by_law_holidays_days'] += 1;
                            $totals[$year][$m]['taken_by_law_holidays_hours'] += $day['holiday_hours'];

                            $yearTotals['taken_by_law_holidays_days'] += 1;
                            $yearTotals['taken_by_law_holidays_hours'] += $day['holiday_hours'];
                        }
                        //sick child
                        if ($day['sick_child']) {
                            //echo '<hr/>';

                            $totals[$year][$m]['taken_by_law_sick_child_days'] += 1;
                            $totals[$year][$m]['taken_by_law_sick_child_hours'] += $day['sick_child_hours'];

                            $yearTotals['taken_by_law_sick_child_days'] += 1;
                            $yearTotals['taken_by_law_sick_child_hours'] += $day['sick_child_hours'];
                        }
                        //earn minutes
                        if ($this->enable_earn_minutes == '1') {
                            if ($day['earn_minutes']) {
                              

                                $totals[$year][$m]['taken_by_law_earn_min_days'] += 1;
                                $totals[$year][$m]['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];

                                $yearTotals['taken_by_law_earn_min_days'] += 1;
                                $yearTotals['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                            }
                        }
                        if (in_array($day['month_day'], array($md2, $month['month_days']))) {
                            //var_dump("Day {$md2} [{$date}]: ".$day['month_day']." days: ".floatval( $vars['holiday_days_per_month']));                        
                            //$month_by_law_holidays_days += (floatval($vars['holiday_days_per_month']) / 2);
                            $month_by_law_holidays_hours += (floatval($vars['holiday_hours_per_month']) / 2);

                            //sick child
                            $month_by_law_sick_child_days += (floatval($vars['sick_child_days_per_month']) / 2);
                            $month_by_law_sick_child_hours += (floatval($vars['sick_child_hours_per_month']) / 2);

                            if ($this->enable_earn_minutes == '1') {
                                //earn minutes
                                $month_by_law_earn_minutes_days += (floatval($vars['earn_min_days_per_month']) / 2);
                                $month_by_law_earn_minutes_hours += (floatval($vars['earn_min_hours_per_month']) / 2);
                            }

                            if (isset($sickDateAvailsble[$date])) {
                                $month_by_law_sick_days += (floatval($vars['sick_days_per_month']) / 2);
                                $month_by_law_sick_hours += (floatval($vars['sick_hours_per_month']) / 2);
                            }
                        }
                    }

                    /* if($this->enable_percent_changes_in_calc_and_rule_holiday == '1'){
                      $month_by_law_holidays_hours *= $holiday_percent;
                      $month_by_law_holidays_days *= $holiday_percent;
                      } */

                    $totals[$year][$m]['total_by_law_holidays_days'] = $month_by_law_holidays_days; //here8
                    $totals[$year][$m]['total_by_law_holidays_hours'] = $month_by_law_holidays_hours; //here7         
                    
                    $totals[$year][$m]['total_by_law_sick_days'] = $month_by_law_sick_days;
                    $totals[$year][$m]['total_by_law_sick_hours'] = $month_by_law_sick_hours;
                    $totals[$year][$m]['total_by_law_sick_child_days'] = $month_by_law_sick_child_days; //sick child
                    $totals[$year][$m]['total_by_law_sick_child_hours'] = $month_by_law_sick_child_hours; //sick child

                    if ($this->enable_earn_minutes == '1') {
                        $totals[$year][$m]['total_by_law_earn_min_days'] = $month_by_law_earn_minutes_days; //earn minutes
                        $totals[$year][$m]['total_by_law_earn_min_hours'] = $month_by_law_earn_minutes_hours; //earn minutes
                        $yearTotals['total_by_law_earn_min_days'] += $month_by_law_earn_minutes_days; //earn minutes
                        $yearTotals['total_by_law_earn_min_hours'] += $month_by_law_earn_minutes_hours; //earn minutes
                    }

                    $yearTotals['total_by_law_holidays_days'] += $month_by_law_holidays_days; //here8
                    $yearTotals['total_by_law_holidays_hours'] += $month_by_law_holidays_hours; //here7
                    $yearTotals['total_by_law_sick_days'] += $month_by_law_sick_days;
                    $yearTotals['total_by_law_sick_hours'] += $month_by_law_sick_hours;
                    $yearTotals['total_by_law_sick_child_days'] += $month_by_law_sick_child_days; //sick child
                    $yearTotals['total_by_law_sick_child_hours'] += $month_by_law_sick_child_hours; //sick child
                    
                    
                }
            }
        }
       
        return $yearTotals;
    }

    private function calculateTotals($uid, &$totals, $earn_min_mode) {
        $args = func_get_args();
        $uid = $args[0];
        $totals = $args[1];
        $earn_min_mode = $args[2];
        
        $hdaysArr =  [];
        $hdaysStrArr =  [];
        
        
        if($this->enable_percent_changes_in_calc_and_rule_holiday == '1'){//here
            $holiday_percent_obj = $this->loadHolidaysPercent($uid, '');
            //var_dump($holiday_percent_obj);
            if($holiday_percent_obj !== false){
               
                $from = $this->app->input->getString('from');
                $to = $this->app->input->getString('to');
                $load_type = $this->app->input->getString('load_type');
                //$from = '01.01.2022';
                //$to = '31.01.2022'; 
               // file_put_contents( '/home/curiotime/newdev.curiotime.com/logs/empl_pdf_calc_holidays_fix.html', print_r('ddd', true), FILE_APPEND | LOCK_EX);
                $yearTotals = $this->calculateTotalsAsHolidayPercentScheme($uid, $totals, $earn_min_mode, $holiday_percent_obj, $from, $to, $load_type);
                
                return $yearTotals;
            } 
           
        }
       //echo 'dd';
        
        $query  =   "SELECT * FROM #__user_report_items WHERE (status=6 OR status=2 OR status=1) AND `id_user`= ".$this->db->quote($uid);
        $this->db->setQuery( $query );
        $hdays    =   $this->db->loadObjectList();
        
        foreach ($hdays as $item) {
            $date  =  $item->year."-".sprintf('%02d', $item->month)."-".sprintf('%02d',$item->day);
            $hdaysArr[$date][] = intval($item->status);
            $hdaysStrArr[]  =  "'{$date}'";
        }
      
        
        if(count($hdaysStrArr) > 0) {
            $query  =   "SELECT * FROM #__audit_time WHERE `date` in ( ".join(",",$hdaysStrArr)."  ) AND `id_user`= ".$this->db->quote($uid);
            $this->db->setQuery( $query );
            $dbItems    =   $this->db->loadObjectList(); 
        } else {
            $dbItems  =  array();
        }
        $dbDates    =   $this->calculateItems($dbItems,$hdaysArr);
        
        $sickDateAvailsble = array();
        $c  = strtotime(date("Y-m-d 23:59:59"));
        for($i= strtotime("-1 year"); $i < $c; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $sickDateAvailsble[$date] = $date;
        }
        $vars  =  $this->getValuesByUserCompanyAge($uid);  
        
        if(empty($vars))
            return array();
        $yearTotals  =  array();
        
        $yearTotals['total_by_law_holidays_days']       =   0;
        $yearTotals['total_by_law_holidays_hours']      =   0;
        $yearTotals['total_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['total_by_law_sick_child_hours']      =   0;//sick child
        if($this->enable_earn_minutes=='1'){
            $yearTotals['total_by_law_earn_min_days']  = 0;//earn minutes
            $yearTotals['total_by_law_earn_min_hours']  = 0;//earn minutes
        }
        $yearTotals['total_by_law_sick_days']           =   0;
        $yearTotals['total_by_law_sick_hours']          =   0;
        
        $yearTotals['taken_by_law_holidays_days']       =   0;
        $yearTotals['taken_by_law_holidays_hours']      =   0;
        $yearTotals['taken_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['taken_by_law_sick_child_hours']      =   0;//sick child
        
        if($this->enable_earn_minutes == '1'){
            $yearTotals['taken_by_law_earn_min_days']       =   0;//earn minutes
            $yearTotals['taken_by_law_earn_min_hours']      =   0;//earn minutes
        }
        $yearTotals['taken_by_law_sick_days']           =   0;
        $yearTotals['taken_by_law_sick_hours']          =   0;
        
        if($holiday_percent_obj === false){
            $yearTotals['new_monthly_total'] = 0;
            $yearTotals['new_monthly_total_days'] = 0;
           
            $yearTotals['new_holidays_hours_from_first_may'] = 0;
            $yearTotals['new_holidays_days_from_first_may'] = 0;
        }

        foreach ($totals as $year=>$months) {
            foreach ($months as $m=>$month) {
                
                $md2 = intval($month['month_days'] / 2);
                
                $month_by_law_holidays_days     = 0;
                $month_by_law_holidays_hours    = 0;
                $month_by_law_sick_days         = 0;
                $month_by_law_sick_hours        = 0;
                $month_by_law_sick_child_days     =0;//sick child
                $month_by_law_sick_child_hours   =0;//sick child
                
                if($this->enable_earn_minutes=='1'){
                    $month_by_law_earn_minutes_days     = 0;//earn minutes
                    $month_by_law_earn_minutes_hours   = 0;//earn minutes
                }
                $month_holidays_days     = 0;
                $month_holidays_hours    = 0;
                $month_sick_days         = 0;
                $month_sick_hours        = 0;
                $month_sick_child_days         = 0;//sick child
                $month_sick_child_hours        = 0;//sick child
                if($this->enable_earn_minutes=='1'){
                    $month_earn_minutes_days         = 0;//earn minutes
                    $month_earn_minutes_hours        = 0;//earn minutes
                }
                
                $totalHours  = 0;
                foreach ($month['days'] as $date=>$day) {      
                    
                    $hours =  0;                    
                    if(isset($dbDates[$date]['holiday_hours'])) {
                        $totals[$year][$m]['days'][$date]['holiday_hours'] = $dbDates[$date]['holiday_hours'];
                        $totals[$year][$m]['days'][$date]['holiday'] = 1;
                    }                        
                    if(isset($dbDates[$date]['sick_hours'])) {
                        $totals[$year][$m]['days'][$date]['sick_hours'] = $dbDates[$date]['sick_hours'];
                        $totals[$year][$m]['days'][$date]['sick'] = 1;
                    }
                    //sick child
                    if(isset($dbDates[$date]['sick_child_hours'])) {
                        $totals[$year][$m]['days'][$date]['sick_child_hours'] = $dbDates[$date]['sick_child_hours'];
                        $totals[$year][$m]['days'][$date]['sick_child'] = 1;
                    }
                    $day = $totals[$year][$m]['days'][$date];
                    
                    
                    if($day['sick'] && isset($sickDateAvailsble[$date])) {
                        
                        $totals[$year][$m]['taken_by_law_sick_days']    += 1;
                        $totals[$year][$m]['taken_by_law_sick_hours']   += $day['sick_hours'];
                        
                        $yearTotals['taken_by_law_sick_days']           +=   1;
                        $yearTotals['taken_by_law_sick_hours']          += $day['sick_hours'];
                        
                    }
                    if($day['holiday']) {
                        $totals[$year][$m]['taken_by_law_holidays_days']    +=  1;
                        $totals[$year][$m]['taken_by_law_holidays_hours']   +=  $day['holiday_hours'];
                        
                        $yearTotals['taken_by_law_holidays_days']           +=  1;
                        $yearTotals['taken_by_law_holidays_hours']          +=  $day['holiday_hours'];
                    }
                    //sick child
                    if($day['sick_child']) {
                        //echo '<hr/>';
                       
                        $totals[$year][$m]['taken_by_law_sick_child_days']    +=  1;
                        $totals[$year][$m]['taken_by_law_sick_child_hours']   +=  $day['sick_child_hours'];
                        
                        $yearTotals['taken_by_law_sick_child_days']           +=  1;
                        $yearTotals['taken_by_law_sick_child_hours']          +=  $day['sick_child_hours'];
                    }
                    //earn minutes
                    if($this->enable_earn_minutes=='1'){
                        if($day['earn_minutes']) {
                            //echo '<hr/>';
                            
                            $totals[$year][$m]['taken_by_law_earn_min_days']    +=  1;
                            $totals[$year][$m]['taken_by_law_earn_min_hours']   +=  $day['earn_minutes_hours'];
                        
                            $yearTotals['taken_by_law_earn_min_days']           +=  1;
                            $yearTotals['taken_by_law_earn_min_hours']          +=  $day['earn_minutes_hours'];
                        }
                    }
                    if (in_array($day['month_day'], array($md2,$month['month_days']))) {                        
                        //var_dump("Day {$md2} [{$date}]: ".$day['month_day']." days: ".floatval( $vars['holiday_days_per_month']));                        
                        $month_by_law_holidays_days     += (floatval( $vars['holiday_days_per_month'])/2);
                        $month_by_law_holidays_hours    += (floatval( $vars['holiday_hours_per_month'])/2);
                        
                        //sick child
                        $month_by_law_sick_child_days     += (floatval( $vars['sick_child_days_per_month'])/2);
                        $month_by_law_sick_child_hours    += (floatval( $vars['sick_child_hours_per_month'])/2);
                        
                        if($this->enable_earn_minutes=='1'){
                            //earn minutes
                            $month_by_law_earn_minutes_days     += (floatval( $vars['earn_min_days_per_month'])/2);
                            $month_by_law_earn_minutes_hours    += (floatval( $vars['earn_min_hours_per_month'])/2);
                        }
                        
                        if(isset($sickDateAvailsble[$date])) {
                            $month_by_law_sick_days         += (floatval( $vars['sick_days_per_month'])/2);
                            $month_by_law_sick_hours        += (floatval( $vars['sick_hours_per_month'])/2);
                        }
                    }                    
                }
                  
                /*if($this->enable_percent_changes_in_calc_and_rule_holiday == '1'){
                    $month_by_law_holidays_hours *= $holiday_percent;
                    $month_by_law_holidays_days *= $holiday_percent;
                }*/
                
                $totals[$year][$m]['total_by_law_holidays_days']  = $month_by_law_holidays_days;//here8
                $totals[$year][$m]['total_by_law_holidays_hours']  = $month_by_law_holidays_hours;//here7         
                $totals[$year][$m]['total_by_law_sick_days']  = $month_by_law_sick_days;
                $totals[$year][$m]['total_by_law_sick_hours']  = $month_by_law_sick_hours;
                $totals[$year][$m]['total_by_law_sick_child_days']  = $month_by_law_sick_child_days;//sick child
                $totals[$year][$m]['total_by_law_sick_child_hours']  = $month_by_law_sick_child_hours;//sick child
                
                if($this->enable_earn_minutes=='1'){
                    $totals[$year][$m]['total_by_law_earn_min_days']  = $month_by_law_earn_minutes_days;//earn minutes
                    $totals[$year][$m]['total_by_law_earn_min_hours']  = $month_by_law_earn_minutes_hours;//earn minutes
                    $yearTotals['total_by_law_earn_min_days']           +=   $month_by_law_earn_minutes_days;//earn minutes
                    $yearTotals['total_by_law_earn_min_hours']          +=   $month_by_law_earn_minutes_hours;//earn minutes
                }
                
                $yearTotals['total_by_law_holidays_days']       +=   $month_by_law_holidays_days;//here8
                $yearTotals['total_by_law_holidays_hours']      +=   $month_by_law_holidays_hours;//here7
                $yearTotals['total_by_law_sick_days']           +=   $month_by_law_sick_days;
                $yearTotals['total_by_law_sick_hours']          +=   $month_by_law_sick_hours;
                $yearTotals['total_by_law_sick_child_days']           +=   $month_by_law_sick_child_days;//sick child
                $yearTotals['total_by_law_sick_child_hours']          +=   $month_by_law_sick_child_hours;//sick child
                
                //unset($totals[$year][$m]['days']);
            }
        }       
        
        
        return $yearTotals;
    }    
    
    private function calculateTotalsWeek($uid, &$totals, $earn_min_mode) {
        $args=func_get_args();
        $uid=$args[0];
        $totals=$args[1];
        $earn_min_mode=$args[2];
        
        $hdaysArr =  array();
        $hdaysStrArr =  array();
        
        
        
        $query  =   "SELECT * FROM #__user_report_items WHERE (status=6 OR status=2 OR status=1) AND `id_user`= ".$this->db->quote($uid);
        $this->db->setQuery( $query );
        $hdays    =   $this->db->loadObjectList();
        
        foreach ($hdays as $item) {
            $date  =  $item->year."-".sprintf('%02d', $item->month)."-".sprintf('%02d',$item->day);
            $hdaysArr[$date][] = intval($item->status);
            $hdaysStrArr[]  =  "'{$date}'";
        }
      
        
        if(count($hdaysStrArr) > 0) {
            $query  =   "SELECT * FROM #__audit_time WHERE `date` in ( ".join(",",$hdaysStrArr)."  ) AND `id_user`= ".$this->db->quote($uid);
            $this->db->setQuery( $query );
            $dbItems    =   $this->db->loadObjectList(); 
        } else {
            $dbItems  =  array();
        }
        $dbDates    =   $this->calculateItems($dbItems,$hdaysArr);
        
        $sickDateAvailsble = array();
        $c  = strtotime(date("Y-m-d 23:59:59"));
        for($i= strtotime("-1 year"); $i < $c; $i += 43200) {
            $date   =   date("Y-m-d",$i);
            $sickDateAvailsble[$date] = $date;
        }
        $vars  =  $this->getValuesByUserCompanyAgeWeek($uid);  
        
        if(empty($vars))
            return array();
        $yearTotals  =  array();
        
        $yearTotals['total_by_law_holidays_days']       =   0;
        $yearTotals['total_by_law_holidays_hours']      =   0;
        $yearTotals['total_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['total_by_law_sick_child_hours']      =   0;//sick child
        if($this->enable_earn_minutes=='1'){
            $yearTotals['total_by_law_earn_min_days']  = 0;//earn minutes
            $yearTotals['total_by_law_earn_min_hours']  = 0;//earn minutes
        }
        $yearTotals['total_by_law_sick_days']           =   0;
        $yearTotals['total_by_law_sick_hours']          =   0;
        
        $yearTotals['taken_by_law_holidays_days']       =   0;
        $yearTotals['taken_by_law_holidays_hours']      =   0;
        $yearTotals['taken_by_law_sick_child_days']       =   0;//sick child
        $yearTotals['taken_by_law_sick_child_hours']      =   0;//sick child
        if($this->enable_earn_minutes=='1'){
            $yearTotals['taken_by_law_earn_min_days']       =   0;//earn minutes
            $yearTotals['taken_by_law_earn_min_hours']      =   0;//earn minutes
        }
        $yearTotals['taken_by_law_sick_days']           =   0;
        $yearTotals['taken_by_law_sick_hours']          =   0;
        
        foreach ($totals as $year=>$months) {
            foreach ($months as $m=>$month) {
                
                $md2 = intval($month['month_days'] / 2);
                
                $month_by_law_holidays_days     = 0;
                $month_by_law_holidays_hours    = 0;
                $month_by_law_sick_days         = 0;
                $month_by_law_sick_hours        = 0;
                $month_by_law_sick_child_days     =0;//sick child
                $month_by_law_sick_child_hours   =0;//sick child
                if($this->enable_earn_minutes=='1'){
                    $month_by_law_earn_minutes_days     =0;//earn minutes
                    $month_by_law_earn_minutes_hours   =0;//earn minutes
                }
                $month_holidays_days     = 0;
                $month_holidays_hours    = 0;
                $month_sick_days         = 0;
                $month_sick_hours        = 0;
                $month_sick_child_days         = 0;//sick child
                $month_sick_child_hours        = 0;//sick child
                if($this->enable_earn_minutes=='1'){
                    $month_earn_minutes_days         = 0;//earn minutes
                    $month_earn_minutes_hours        = 0;//earn minutes
                }
                
                $totalHours  = 0;
                foreach ($month['days'] as $date=>$day) {      
                    
                    $hours =  0;                    
                    if(isset($dbDates[$date]['holiday_hours'])) {
                        $totals[$year][$m]['days'][$date]['holiday_hours'] = $dbDates[$date]['holiday_hours'];
                        $totals[$year][$m]['days'][$date]['holiday'] = 1;
                    }                        
                    if(isset($dbDates[$date]['sick_hours'])) {
                        $totals[$year][$m]['days'][$date]['sick_hours'] = $dbDates[$date]['sick_hours'];
                        $totals[$year][$m]['days'][$date]['sick'] = 1;
                    }
                    //sick child
                    if(isset($dbDates[$date]['sick_child_hours'])) {
                        $totals[$year][$m]['days'][$date]['sick_child_hours'] = $dbDates[$date]['sick_child_hours'];
                        $totals[$year][$m]['days'][$date]['sick_child'] = 1;
                    }
                    $day = $totals[$year][$m]['days'][$date];
                    
                    
                    if($day['sick'] && isset($sickDateAvailsble[$date])) {
                        
                        $totals[$year][$m]['taken_by_law_sick_days']    += 1;
                        $totals[$year][$m]['taken_by_law_sick_hours']   += $day['sick_hours'];
                        
                        $yearTotals['taken_by_law_sick_days']           +=   1;
                        $yearTotals['taken_by_law_sick_hours']          += $day['sick_hours'];
                        
                    }
                    if($day['holiday']) {
                        $totals[$year][$m]['taken_by_law_holidays_days']    +=  1;
                        $totals[$year][$m]['taken_by_law_holidays_hours']   +=  $day['holiday_hours'];
                        
                        $yearTotals['taken_by_law_holidays_days']           +=  1;
                        $yearTotals['taken_by_law_holidays_hours']          +=  $day['holiday_hours'];
                    }
                    //sick child
                    if($day['sick_child']) {
                        //echo '<hr/>';
                       
                        $totals[$year][$m]['taken_by_law_sick_child_days']    +=  1;
                        $totals[$year][$m]['taken_by_law_sick_child_hours']   +=  $day['sick_child_hours'];
                        
                        $yearTotals['taken_by_law_sick_child_days']           +=  1;
                        $yearTotals['taken_by_law_sick_child_hours']          +=  $day['sick_child_hours'];
                    }
                    //earn minutes
                    if($this->enable_earn_minutes=='1'){
                        if($day['earn_minutes']) {
                            //echo '<hr/>';
                            
                            $totals[$year][$m]['taken_by_law_earn_min_days']    +=  1;
                            $totals[$year][$m]['taken_by_law_earn_min_hours']   +=  $day['earn_minutes_hours'];
                        
                            $yearTotals['taken_by_law_earn_min_days']           +=  1;
                            $yearTotals['taken_by_law_earn_min_hours']          +=  $day['earn_minutes_hours'];
                        }
                    }
                    if (in_array($day['month_day'], array($md2,$month['month_days']))) {                        
                        //var_dump("Day {$md2} [{$date}]: ".$day['month_day']." days: ".floatval( $vars['holiday_days_per_month']));                        
                        $month_by_law_holidays_days     += (floatval( $vars['holiday_days_per_month'])/2);
                        $month_by_law_holidays_hours    += (floatval( $vars['holiday_hours_per_month'])/2);
                        
                        //sick child
                        $month_by_law_sick_child_days     += (floatval( $vars['sick_child_days_per_month'])/2);
                        $month_by_law_sick_child_hours    += (floatval( $vars['sick_child_hours_per_month'])/2);
                        
                        if($this->enable_earn_minutes=='1'){
                            //earn minutes
                            $month_by_law_earn_minutes_days     += (floatval( $vars['earn_min_days_per_month'])/2);
                            $month_by_law_earn_minutes_hours    += (floatval( $vars['earn_min_hours_per_month'])/2);
                        }
                        
                        if(isset($sickDateAvailsble[$date])) {
                            $month_by_law_sick_days         += (floatval( $vars['sick_days_per_month'])/2);
                            $month_by_law_sick_hours        += (floatval( $vars['sick_hours_per_month'])/2);
                        }
                    }                    
                }
                
                
                $totals[$year][$m]['total_by_law_holidays_days']  = $month_by_law_holidays_days;
                $totals[$year][$m]['total_by_law_holidays_hours']  = $month_by_law_holidays_hours;            
                $totals[$year][$m]['total_by_law_sick_days']  = $month_by_law_sick_days;
                $totals[$year][$m]['total_by_law_sick_hours']  = $month_by_law_sick_hours;
                $totals[$year][$m]['total_by_law_sick_child_days']  = $month_by_law_sick_child_days;//sick child
                $totals[$year][$m]['total_by_law_sick_child_hours']  = $month_by_law_sick_child_hours;//sick child
                
                if($this->enable_earn_minutes=='1'){
                    $totals[$year][$m]['total_by_law_earn_min_days']  = $month_by_law_earn_minutes_days;//earn minutes
                    $totals[$year][$m]['total_by_law_earn_min_hours']  = $month_by_law_earn_minutes_hours;//earn minutes
                    $yearTotals['total_by_law_earn_min_days']           +=   $month_by_law_earn_minutes_days;//earn minutes
                    $yearTotals['total_by_law_earn_min_hours']          +=   $month_by_law_earn_minutes_hours;//earn minutes
                }
                
                $yearTotals['total_by_law_holidays_days']       +=   $month_by_law_holidays_days;
                $yearTotals['total_by_law_holidays_hours']      +=   $month_by_law_holidays_hours;
                $yearTotals['total_by_law_sick_days']           +=   $month_by_law_sick_days;
                $yearTotals['total_by_law_sick_hours']          +=   $month_by_law_sick_hours;
                $yearTotals['total_by_law_sick_child_days']           +=   $month_by_law_sick_child_days;//sick child
                $yearTotals['total_by_law_sick_child_hours']          +=   $month_by_law_sick_child_hours;//sick child
                
                
            }
        }       
        
        
        return $yearTotals;
    }   
    
    private function superUnique($array, $key)
    {
        $temp_array = [];
        foreach ($array as &$v) {
            if (!isset($temp_array[$v[$key]]))
                $temp_array[$v[$key]] =& $v;
        }
        $array = array_values($temp_array);
        return $array;
    }
    
    private function normalizeTotals(array $calculated_totals): array
    {
        $final = [];
        
        foreach($calculated_totals as $one_row){
            $final[$one_row['date']][] = $one_row;
        }
        
        return $final;
    }
    
    private function autocompletion($valueField)
    {
        switch(strlen($valueField)){
            case 0:
                
                break;
            case 1:
                $valueField='0'.$valueField.':00';
                break;
            case 2:
                $valueField0=str_split($valueField, 1);
                
                if($valueField0[0]=='0'){
                   $valueField='0'.$valueField0[1].':00';
                } else{
                    $valueField=$valueField0[0].$valueField0[1].':00';
                }
                break;
            case 3:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':00';
                break;
            case 4:
                $valueField0=str_split($valueField, 1);
                $valueField=$valueField0[0].$valueField0[1].':'.$valueField0[3].'0';
                break;
        }
        
        return $valueField;
    }
    
    private function convertFloatToStr(float $time)
    {
        //return $time . ':00';
        $h = 0;
        $minutes = $time;
        if($minutes < 60){
            $h++;
            $minutes -= 60;
        }
        
        return $this->calcHours($h, $minutes, 0, 0);
    }
    
    
    private static function convertBreaksToMinutes(string $break){
        $arr = explode(':', $break);
        $res = ($arr[0] * 60) + $arr[1];
        
        return $res; 
    }
    
    private function calculateTotalsEarnMinutes($uid, &$totals, $earn_minutes_object, $calculated_totals = null) {
        
        $hdaysArr =  [];
        $hdaysStrArr =  []; 
        /*echo '<pre>model $earn_minutes_object';
        print_r($earn_minutes_object);
        echo '</pre>';*/
        $break_minutes_converted = self::convertBreaksToMinutes($earn_minutes_object->minutes);
        
        //calc earned minutes if enable first checkbox
        if($this->earn_minutes_radio_mode == 'checkbox_all_days' && $this->enable_break_time_changes != '1'){ 
            $sickDateAvailsble = [];
            
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAge($uid);
            
            if (empty($vars))
                return array();
            $yearTotals = array();


            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
            

            foreach ($totals as $year => $months) {
                foreach ($months as $m => $month) {

                    $md2 = intval($month['month_days'] / 2);

                    
                    $month_by_law_earn_minutes_days = 0; //earn minutes
                    $month_by_law_earn_minutes_hours = 0; //earn minutes
                    $month_earn_minutes_days = 0; //earn minutes
                    $month_earn_minutes_hours = 0; //earn minutes

                    $totalHours = 0;
                    foreach ($month['days'] as $date => $day) {
                        $hours = 0;
                        
                        $day = $totals[$year][$m]['days'][$date];

                        //earn minutes
                        if ($day['earn_minutes']) {
                            $totals[$year][$m]['taken_by_law_earn_min_days'] += 1;
                            $totals[$year][$m]['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                                
                            $yearTotals['taken_by_law_earn_min_days'] += 1;
                            
                            $yearTotals['earned_minutes'] += $break_minutes_converted;
                            $yearTotals['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                        }     
                    }
                }
            }
            $yearTotals['earned_minutes'] -= $earn_minutes_object->minutes;
        } elseif($this->earn_minutes_radio_mode == 'checkbox_all_days' && $this->enable_break_time_changes == '1'){
            if(!empty($calculated_totals)){
                $normalized_totals = $this->normalizeTotals($calculated_totals);//group totals by date
                //$min_working_hours_for_add_break_test = 2.1;//test load
                $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break;//need load from union rule block test
                
                if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes 
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
                }
                
                $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
                $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
                $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];        
                $min_working_hours_for_add_break = (float)($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
                            
                $break_minutes = $break_minutes_converted;//loading from union rule
                $final_breaks = 0;
               
                foreach($normalized_totals as $k => $sessions){
                   
                    $date = $k;
                    $count = count($sessions);
                    
                    $total_sum = 0;//sum total for a date
                    if( $count > 1){
                       
                        $total_sum_for_days = 0;//sum all totals for a date
                        
                        foreach($sessions as $session){//if one date have more them 1 session
                            $total_string = $session['total'];
                            $total_arr = explode(':', $total_string);
                            $total_h = $total_arr[0];
                            $total_m = $total_arr[1];
                            $total_to_float = (float)($total_h . '.' . $total_m);
                            $total_sum_for_days += $total_to_float; 
                        }
                        
                       
                        if($total_sum_for_days >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    } elseif($count == 1){//if one date have 1 session
                        $total_string = $sessions[0]['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float)($total_h . '.' . $total_m);
                        $total_sum = $total_to_float; 
                      
                        if($total_sum >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    }
                }
                
               
            }

            /*echo '<pre>$final_breaks:';
            print_r($final_breaks);
            echo '</pre>';*/

            $vars = $this->getValuesByUserCompanyAge($uid);
            $formatted_final_breaks = $this->convertFloatToStr((float)$final_breaks);
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes
           
            
            return $yearTotals;
            //$yearTotals['earned_minutes'] = '120000';//test
           
        } elseif ($this->earn_minutes_radio_mode == 'checkbox_work_days' && $this->enable_break_time_changes == '1') {//gg
            if(!empty($calculated_totals)){
                $normalized_totals = $this->normalizeTotals($calculated_totals);//group totals by date
                //$min_working_hours_for_add_break_test = 2.1;//test load
                $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break;//need load from union rule block test
                
                if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
                }
                
                $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
                $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
                $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];        
                $min_working_hours_for_add_break = (float)($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
                            
                $break_minutes = $break_minutes_converted;//loading from union rule
                $final_breaks = 0;
               
                foreach($normalized_totals as $k => $sessions){
                   
                    $date = $k;
                    $count = count($sessions);
                    
                    $total_sum = 0;//sum total for a date
                    if( $count > 1){
                       
                        $total_sum_for_days = 0;//sum all totals for a date
                        
                        foreach($sessions as $session){//if one date have more them 1 session
                            $total_string = $session['total'];
                            $total_arr = explode(':', $total_string);
                            $total_h = $total_arr[0];
                            $total_m = $total_arr[1];
                            $total_to_float = (float)($total_h . '.' . $total_m);
                            $total_sum_for_days += $total_to_float; 
                        }
                        
                       
                        if($total_sum_for_days >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    } elseif($count == 1){//if one date have 1 session
                        $total_string = $sessions[0]['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float)($total_h . '.' . $total_m);
                        $total_sum = $total_to_float; 
                      
                        if($total_sum >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    }
                }
                
               
            }

            /*echo '<pre>$final_breaks:';
            print_r($final_breaks);
            echo '</pre>';*/

            $vars = $this->getValuesByUserCompanyAge($uid);
            $formatted_final_breaks = $this->convertFloatToStr((float)$final_breaks);
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes
           
            
            return $yearTotals;
            //$yearTotals['earned_minutes'] = '120000';//test
           
        } elseif ($this->earn_minutes_radio_mode == 'checkbox_work_days' && $this->enable_break_time_changes != '1') {
          
            
            $date_start_timestamp   =   $earn_minutes_object->timestamp_start;
            $date_start             =   date('Y-m-d', $date_start_timestamp);
            

            $current_time   =   time();
            $date_end       =   date('Y-m-d', $current_time);
            
            $query  =   "SELECT * FROM #__user_report_items WHERE `id_user`= " . $this->db->quote($uid);
            $this->db->setQuery( $query );
            $hdays    =   $this->db->loadObjectList();
              
            //prepare calendar items
            foreach ($hdays as $item) {
                $date = $item->year . "-" . sprintf('%02d', $item->month) . "-" . sprintf('%02d', $item->day);
                $hdaysArr[$date][] = intval($item->status);
                $hdaysStrArr[] = "'{$date}'";
            }

            $calendar_items = [];
            
            //filter calendar items on start-end date
            $calendar_items_length = count($hdaysStrArr);
            for ($i = 0; $i < $calendar_items_length; $i++) {
                $one_date_obj = DateTime::createFromFormat("'Y-m-d'", $hdaysStrArr[$i]);
                $one_date_timestamp = $one_date_obj->format('U');

                if ($one_date_timestamp >= $date_start_timestamp && $one_date_timestamp < $current_time) {
                    $calendar_items[] = $one_date_obj->format('Y-m-d');
                }
            }
            asort($calendar_items);
            
            /*echo '<pre>Calendar dates filtered:';
            print_r($calendar_items);
            echo '</pre>';*/
            
            
            //get all dates with edited exclude calendar dates
            if (!empty($hdaysStrArr)) {
                $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '" . $date_start . "' AND '" . $date_end . "' AND `date` NOT in ( " . join(",", $hdaysStrArr) . "  )  AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            } else {
                $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '" . $date_start . "' AND '" . $date_end . "' AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            }
            //echo $query;
            $this->db->setQuery($query);
            $dbItems1 = $this->db->loadAssocList();
            
            //remove one date rows in pay period
            $dbItems=$this->superUnique($dbItems1, 'date');
            
            /*echo '<pre>Pay period filtered:';
            print_r($dbItems);
            echo '</pre>';*/
            

            $sickDateAvailsble = [];
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAge($uid);
           
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
           
            
            $i2 = 0;
            foreach($dbItems as $pay_period_item){
                $yearTotals['earned_minutes'] += $break_minutes_converted;
                
                $i2++;
            }
            
            $i3 = 0;
            foreach($calendar_items as $one_calendar_item){
                $yearTotals['earned_minutes'] += $break_minutes_converted;
              
                $i3++;
            }
            
        }
        return $yearTotals;
    }
    
    private function calculateTotalsEarnMinutesWeek($uid, &$totals, $earn_minutes_object, $calculated_totals = null) {
        //old calculation. <=15.04.2022
        /*$hdaysArr =  [];
        $hdaysStrArr =  []; 
     
        //calc earned minutes if enable first checkbox
        if($this->earn_minutes_radio_mode_week == 'checkbox_all_days'){ 
            $sickDateAvailsble = [];
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAgeWeek($uid);
            
            if (empty($vars))
                return [];
            $yearTotals = [];


            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
            

            foreach ($totals as $year => $months) {
                foreach ($months as $m => $month) {

                    $md2 = intval($month['month_days'] / 2);

                    
                    $month_by_law_earn_minutes_days = 0; //earn minutes
                    $month_by_law_earn_minutes_hours = 0; //earn minutes
                    $month_earn_minutes_days = 0; //earn minutes
                    $month_earn_minutes_hours = 0; //earn minutes

                    $totalHours = 0;
                    foreach ($month['days'] as $date => $day) {
                        $hours = 0;
                        
                        $day = $totals[$year][$m]['days'][$date];

                        //earn minutes
                        if ($day['earn_minutes']) {
                            $totals[$year][$m]['taken_by_law_earn_min_days'] += 1;
                            $totals[$year][$m]['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                                
                            $yearTotals['taken_by_law_earn_min_days'] += 1;
                            
                            $yearTotals['earned_minutes'] += 1*$earn_minutes_object->minutes;
                            $yearTotals['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                        }     
                    }
                }
            }
            $yearTotals['earned_minutes'] -= $earn_minutes_object->minutes;
        } elseif ($this->earn_minutes_radio_mode_week == 'checkbox_work_days' && $this->enable_break_time_changes == '1') {//gg
            if(!empty($calculated_totals)){
               
                $normalized_totals = $this->normalizeTotals($calculated_totals);//group totals by date
                //$min_working_hours_for_add_break_test = 2.1;//test load
                $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break;//need load from union rule block test
                
                if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
                }
                
                $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
                $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
                $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];        
                $min_working_hours_for_add_break = (float)($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
                            
                $break_minutes = $earn_minutes_object->minutes;//loading from union rule
                $final_breaks = 0;
                /*echo '<pre>$normalized_totals';
                print_r($normalized_totals);
                echo '</pre>';*//*
                foreach($normalized_totals as $k => $sessions){
                   
                    $date = $k;
                    $count = count($sessions);
                    
                    $total_sum = 0;//sum total for a date
                    if( $count > 1){
                       
                        $total_sum_for_days = 0;//sum all totals for a date
                        
                        foreach($sessions as $session){//if one date have more them 1 session
                            $total_string = $session['total'];
                            $total_arr = explode(':', $total_string);
                            $total_h = $total_arr[0];
                            $total_m = $total_arr[1];
                            $total_to_float = (float)($total_h . '.' . $total_m);
                            $total_sum_for_days += $total_to_float; 
                        }
                        
                       
                        if($total_sum_for_days >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    } elseif($count == 1){//if one date have 1 session
                        $total_string = $sessions[0]['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float)($total_h . '.' . $total_m);
                        $total_sum = $total_to_float; 
                      
                        if($total_sum >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    }
                }
                
               
            }

            /*echo '<pre>$final_breaks:';
            print_r($final_breaks);
            echo '</pre>';*//*

            $vars = $this->getValuesByUserCompanyAge($uid);
            $formatted_final_breaks = $this->convertFloatToStr((float)$final_breaks);
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes
            /*echo '<pre>$formatted_final_breaks';
            print_r($formatted_final_breaks);
            echo '</pre>';*//*
            
            return $yearTotals;
            //$yearTotals['earned_minutes'] = '120000';//test
           
        } elseif ($this->earn_minutes_radio_mode_week == 'checkbox_work_days' && $this->enable_break_time_changes != '1') {
            $date_start_timestamp   =   $earn_minutes_object->timestamp_start;
            
            $date_start             =   date('Y-m-d', $date_start_timestamp);
            
           
           
            $current_time   =   time();
            $date_end       =   date('Y-m-d', $current_time);
            
            $query  =   "SELECT * FROM #__user_report_items WHERE `id_user`= ".$this->db->quote($uid);
            $this->db->setQuery( $query );
            $hdays    =   $this->db->loadObjectList();
              
            //prepare calendar items
            foreach ($hdays as $item) {
                $date = $item->year . "-" . sprintf('%02d', $item->month) . "-" . sprintf('%02d', $item->day);
                $hdaysArr[$date][] = intval($item->status);
                $hdaysStrArr[] = "'{$date}'";
            }

            $calendar_items=[];
            
            //filter calendar items on start-end date
            $calendar_items_length=count($hdaysStrArr);
            for($i=0; $i<$calendar_items_length; $i++){
                $one_date_obj= DateTime::createFromFormat("'Y-m-d'", $hdaysStrArr[$i]);
                $one_date_timestamp=$one_date_obj->format('U');
               
                if($one_date_timestamp>=$date_start_timestamp && $one_date_timestamp<$current_time){
                    $calendar_items[]=$one_date_obj->format('Y-m-d');
                }
            }
            asort($calendar_items);
            
            
            
            
            //get all dates with edited exclude calendar dates
            if(!empty($hdaysStrArr)){
                 $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '".$date_start."' AND '".$date_end."' AND `date` NOT in ( ".join(",",$hdaysStrArr)."  )  AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            } else{
                 $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '".$date_start."' AND '".$date_end."' AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            }
           
            $this->db->setQuery($query);
            $dbItems1 = $this->db->loadAssocList();
            
            //remove one date rows in pay period
            $dbItems=$this->superUnique($dbItems1, 'date');
            
            /*echo '<pre>Pay period filtered:';
            print_r($dbItems);
            echo '</pre>';*//*
            

            $sickDateAvailsble = array();
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAgeWeek($uid);
           
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
           
            //here5
            $i2=0;
            foreach($dbItems as $pay_period_item){
                $yearTotals['earned_minutes'] += 1*$earn_minutes_object->minutes;
                
                $i2++;
            }
            
            $i3=0;
            foreach($calendar_items as $one_calendar_item){
                $yearTotals['earned_minutes'] += 1*$earn_minutes_object->minutes;
              
                $i3++;
            }
 
        }
        return $yearTotals;**/
        $hdaysArr =  [];
        $hdaysStrArr =  []; 
        $break_minutes_converted = self::convertBreaksToMinutes($earn_minutes_object->minutes);
        
        //calc earned minutes if enable first checkbox
        if($this->earn_minutes_radio_mode_week == 'checkbox_all_days' && $this->enable_break_time_changes != '1'){ 
            //echo 'dd';
            $sickDateAvailsble = [];
            
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAge($uid);
            
            if (empty($vars))
                return array();
            $yearTotals = array();


            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
            

            foreach ($totals as $year => $months) {
                foreach ($months as $m => $month) {

                    $md2 = intval($month['month_days'] / 2);

                    
                    $month_by_law_earn_minutes_days = 0; //earn minutes
                    $month_by_law_earn_minutes_hours = 0; //earn minutes
                    $month_earn_minutes_days = 0; //earn minutes
                    $month_earn_minutes_hours = 0; //earn minutes

                    $totalHours = 0;
                    foreach ($month['days'] as $date => $day) {
                        $hours = 0;
                        
                        $day = $totals[$year][$m]['days'][$date];

                        //earn minutes
                        if ($day['earn_minutes']) {
                            $totals[$year][$m]['taken_by_law_earn_min_days'] += 1;
                            $totals[$year][$m]['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                                
                            $yearTotals['taken_by_law_earn_min_days'] += 1;
                            
                            $yearTotals['earned_minutes'] += $break_minutes_converted;
                            $yearTotals['taken_by_law_earn_min_hours'] += $day['earn_minutes_hours'];
                        }     
                    }
                }
            }
            $yearTotals['earned_minutes'] -= $earn_minutes_object->minutes;
        } elseif($this->earn_minutes_radio_mode_week == 'checkbox_all_days' && $this->enable_break_time_changes == '1'){
            if(!empty($calculated_totals)){
                $normalized_totals = $this->normalizeTotals($calculated_totals);//group totals by date
                //$min_working_hours_for_add_break_test = 2.1;//test load
                $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break;//need load from union rule block test
                
                if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes 
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
                }
                
                $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
                $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
                $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];        
                $min_working_hours_for_add_break = (float)($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
                            
                $break_minutes = $break_minutes_converted;//loading from union rule
                $final_breaks = 0;
               
                foreach($normalized_totals as $k => $sessions){
                   
                    $date = $k;
                    $count = count($sessions);
                    
                    $total_sum = 0;//sum total for a date
                    if( $count > 1){
                       
                        $total_sum_for_days = 0;//sum all totals for a date
                        
                        foreach($sessions as $session){//if one date have more them 1 session
                            $total_string = $session['total'];
                            $total_arr = explode(':', $total_string);
                            $total_h = $total_arr[0];
                            $total_m = $total_arr[1];
                            $total_to_float = (float)($total_h . '.' . $total_m);
                            $total_sum_for_days += $total_to_float; 
                        }
                        
                       
                        if($total_sum_for_days >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    } elseif($count == 1){//if one date have 1 session
                        $total_string = $sessions[0]['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float)($total_h . '.' . $total_m);
                        $total_sum = $total_to_float; 
                      
                        if($total_sum >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    }
                }
                
               
            }

           

            $vars = $this->getValuesByUserCompanyAge($uid);
            $formatted_final_breaks = $this->convertFloatToStr((float)$final_breaks);
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes
           
            
            return $yearTotals;
            //$yearTotals['earned_minutes'] = '120000';//test
           
        } elseif ($this->earn_minutes_radio_mode_week == 'checkbox_work_days' && $this->enable_break_time_changes == '1') {//gg
            if(!empty($calculated_totals)){
                $normalized_totals = $this->normalizeTotals($calculated_totals);//group totals by date
                //$min_working_hours_for_add_break_test = 2.1;//test load
                $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break;//need load from union rule block test
                
                if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
                }
                
                $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
                $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
                $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];        
                $min_working_hours_for_add_break = (float)($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
                            
                $break_minutes = $break_minutes_converted;//loading from union rule
                $final_breaks = 0;
               
                foreach($normalized_totals as $k => $sessions){
                   
                    $date = $k;
                    $count = count($sessions);
                    
                    $total_sum = 0;//sum total for a date
                    if( $count > 1){
                       
                        $total_sum_for_days = 0;//sum all totals for a date
                        
                        foreach($sessions as $session){//if one date have more them 1 session
                            $total_string = $session['total'];
                            $total_arr = explode(':', $total_string);
                            $total_h = $total_arr[0];
                            $total_m = $total_arr[1];
                            $total_to_float = (float)($total_h . '.' . $total_m);
                            $total_sum_for_days += $total_to_float; 
                        }
                        
                       
                        if($total_sum_for_days >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    } elseif($count == 1){//if one date have 1 session
                        $total_string = $sessions[0]['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float)($total_h . '.' . $total_m);
                        $total_sum = $total_to_float; 
                      
                        if($total_sum >= $min_working_hours_for_add_break){
                            $final_breaks += $break_minutes;
                        } 
                    }
                }
                
               
            }

            /*echo '<pre>$final_breaks:';
            print_r($final_breaks);
            echo '</pre>';*/

            $vars = $this->getValuesByUserCompanyAge($uid);
            $formatted_final_breaks = $this->convertFloatToStr((float)$final_breaks);
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes
           
            
            return $yearTotals;
            //$yearTotals['earned_minutes'] = '120000';//test
           
        } elseif ($this->earn_minutes_radio_mode_week == 'checkbox_work_days' && $this->enable_break_time_changes != '1') {
          
            
            $date_start_timestamp   =   $earn_minutes_object->timestamp_start;
            $date_start             =   date('Y-m-d', $date_start_timestamp);
            

            $current_time   =   time();
            $date_end       =   date('Y-m-d', $current_time);
            
            $query  =   "SELECT * FROM #__user_report_items WHERE `id_user`= " . $this->db->quote($uid);
            $this->db->setQuery( $query );
            $hdays    =   $this->db->loadObjectList();
              
            //prepare calendar items
            foreach ($hdays as $item) {
                $date = $item->year . "-" . sprintf('%02d', $item->month) . "-" . sprintf('%02d', $item->day);
                $hdaysArr[$date][] = intval($item->status);
                $hdaysStrArr[] = "'{$date}'";
            }

            $calendar_items = [];
            
            //filter calendar items on start-end date
            $calendar_items_length = count($hdaysStrArr);
            for ($i = 0; $i < $calendar_items_length; $i++) {
                $one_date_obj = DateTime::createFromFormat("'Y-m-d'", $hdaysStrArr[$i]);
                $one_date_timestamp = $one_date_obj->format('U');

                if ($one_date_timestamp >= $date_start_timestamp && $one_date_timestamp < $current_time) {
                    $calendar_items[] = $one_date_obj->format('Y-m-d');
                }
            }
            asort($calendar_items);
            
            /*echo '<pre>Calendar dates filtered:';
            print_r($calendar_items);
            echo '</pre>';*/
            
            
            //get all dates with edited exclude calendar dates
            if (!empty($hdaysStrArr)) {
                $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '" . $date_start . "' AND '" . $date_end . "' AND `date` NOT in ( " . join(",", $hdaysStrArr) . "  )  AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            } else {
                $query = "SELECT * FROM #__audit_time WHERE `date` BETWEEN '" . $date_start . "' AND '" . $date_end . "' AND `date_logged`!='0000-00-00 00:00:00' AND `id_user`= " . $this->db->quote($uid);
            }
            //echo $query;
            $this->db->setQuery($query);
            $dbItems1 = $this->db->loadAssocList();
            
            //remove one date rows in pay period
            $dbItems = $this->superUnique($dbItems1, 'date');
            
            /*echo '<pre>Pay period filtered:';
            print_r($dbItems);
            echo '</pre>';*/
            

            $sickDateAvailsble = [];
            $c = strtotime(date("Y-m-d 23:59:59"));
            for ($i = strtotime("-1 year"); $i < $c; $i += 43200) {
                $date = date("Y-m-d", $i);
                $sickDateAvailsble[$date] = $date;
            }
            $vars = $this->getValuesByUserCompanyAge($uid);
           
            
            if (empty($vars))
                return [];
            
            $yearTotals = [];

            $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
            $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
            $yearTotals['earned_minutes'] = 0; //earn minutes
           
            
            $i2 = 0;
            foreach($dbItems as $pay_period_item){
                $yearTotals['earned_minutes'] += $break_minutes_converted;
                
                $i2++;
            }
            
            $i3 = 0;
            foreach($calendar_items as $one_calendar_item){
                $yearTotals['earned_minutes'] += $break_minutes_converted;
              
                $i3++;
            }
            
        }
        return $yearTotals;
    }
    
   
    public function getUserWorkAgeTotals($uid) {
        $user   =   JFactory::getUser($uid);
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d",$work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($user->rule_number0);
        
        if($rule_number0 < 1)
            return array();
        
        $workYears  = abs(intval($diff->y));
        $y  = $workYears;
        $startDate  =  date("Y-m-d",$work_start_timestamp);        
        $currentDate  =  date("Y-m-d");

        $dateArr    =   $this->getAllDateList($uid, $startDate, $currentDate);
      
        return          $dateArr;
    }
    
     public function getUserWorkAgeTotalsWeek($uid) {
        $user   =   JFactory::getUser($uid);
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d",$work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($user->shift_number);
        
        if($rule_number0 < 1)
            return array();
        
        $workYears  = abs(intval($diff->y));
        $y  = $workYears;
        $startDate  =  date("Y-m-d",$work_start_timestamp);        
        $currentDate  =  date("Y-m-d");

        $dateArr    =   $this->getAllDateListWeek($uid, $startDate, $currentDate);
      
        return          $dateArr;
    }
    
    public function getEarnMinutesRow($parent_union_rule_id)
    {
        //rewrite this query if you plan a lot of earn minutes row
        $query  =   "SELECT * FROM #__subrules_minutes WHERE `parent_rule_id` =  ".$this->db->quote($parent_union_rule_id)." limit 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        
        return $obj;
    }
    
    public function getEarnMinutesRowWeek($parent_union_rule_id)
    {
        //rewrite this query if you plan a lot of earn minutes row
        $query  =   "SELECT * FROM #__subrules_minutes_week WHERE `parent_rule_id` =  ".$this->db->quote($parent_union_rule_id)." limit 1";
        $this->db->setQuery($query);
        $obj    =   $this->db->loadObject();
        
        return $obj;
    }
    
    public function zeroingStart($work_start_timestamp)
    {
        $date=date('Y-m-d', $work_start_timestamp);
        $date_arr=explode('-', $date);
        $date_str=strtotime(date('Y').'-'.$date_arr[1].'-'.$date_arr[2]);
        
        return $date_str;
    }
    
    public function isLeap($year)
    {
        return date("L", mktime(0,0,0, 7,7, $year));
    }

    
    private function getUserWorkAgeTotalsWithEarnMinutes($uid, $calculated_totals = null)
    {
        $user = JFactory::getUser($uid);
        $union_rule_id = (int)$user->rule_number0;             
        $earn_minutes_object=$this->getEarnMinutesRow($union_rule_id);

        $work_start_timestamp  =  $earn_minutes_object->timestamp_start;
        
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d", $work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($union_rule_id);
       
        
        if($rule_number0 < 1 )
            return array();
        
        $workYears  = abs(intval($diff->y));
        $y  = $workYears;
        $normalize_start_date=$this->zeroingStart($work_start_timestamp);
        //echo '$normalize_start_date='.date('Y-m-d', $normalize_start_date);
        
        $startDate  =  date("Y-m-d", $normalize_start_date); 
        //echo 'start='.$startDate;
        $now=time();
        $currentDate  =  date("Y-m-d", $now);
        //$currentDate=strtorime('2020-01-28');
        //$now=strtotime('2020-01-28');
        
        if($now<$normalize_start_date){
            //echo 'pp';
            $is_leep_year=$this->isLeap(date('Y'));
            //echo $is_leep_year;
            if($is_leep_year==1){
                $startDate=date("Y-m-d", $normalize_start_date-31622400);
            } elseif($is_leep_year==0){
                $startDate=date("Y-m-d", $normalize_start_date-31536000);
            }
            //echo ' < mode; '.$startDate.'<br/>';
        }
        //calc earn minutes
        $dateArrOnlyEarnMinutes    =   $this->getAllDateListWithEarnMinutes($uid, $startDate, $currentDate, $earn_minutes_object, $calculated_totals);
        /*echo '<pre>earn minutes calc';
        print_r($dateArrOnlyEarnMinutes);
        echo '</pre>';*/
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d", $work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        $rule_number0  = intval($user->rule_number0);
       
        
        if($rule_number0 < 1 )
            return [];
        
        $workYears  = abs(intval($diff->y));
        $y  = $workYears;
        $startDate  =  date("Y-m-d",$work_start_timestamp);        
        $currentDate  =  date("Y-m-d");
        
        //standart calc
        $dateArr    =   $this->getAllDateList($uid, $startDate, $currentDate);
        $dateArr['earned_minutes'] = $dateArrOnlyEarnMinutes['earned_minutes'];
        /*echo '<pre>standart calc';
        print_r($dateArr);
        echo '</pre>';*/
        return    $dateArr;
    }
    
    private function getUserWorkAgeTotalsWithEarnMinutesWeek($uid, $calculated_totals = null)
    {
        //gg2
        $user = JFactory::getUser($uid);
        $union_rule_id = (int)$user->rule_number0;
        
      
        $shift_id = (int)$user->shift_number;
        $earn_minutes_object = $this->getEarnMinutesRowWeek($shift_id);
        
        

        $work_start_timestamp  =  $earn_minutes_object->timestamp_start;
        
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d", $work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
       
       
        
        if($shift_id < 1){
             return [];
        }
           
        
        $workYears = abs(intval($diff->y));
        $y  = $workYears;
        $normalize_start_date=$this->zeroingStart($work_start_timestamp);
      
        
        $startDate = date("Y-m-d", $normalize_start_date); 
      
        $now = time();
        $currentDate  =  date("Y-m-d", $now);
        
        
        if($now < $normalize_start_date){
           
            $is_leep_year = $this->isLeap(date('Y'));
            
            if($is_leep_year == 1){
                $startDate = date("Y-m-d", $normalize_start_date-31622400);
            } elseif($is_leep_year == 0){
                $startDate = date("Y-m-d", $normalize_start_date-31536000);
            }
      
        }
        //calc earn minutes
        $dateArrOnlyEarnMinutes    =   $this->getAllDateListWithEarnMinutesWeek($uid, $startDate, $currentDate, $earn_minutes_object, $calculated_totals);//gg
       
        ////////////////////////////////////////////////////////////////////////////////////////////////////
        $work_start_timestamp  =  intval($user->work_start_timestamp);
        if($work_start_timestamp < 10000) {
            $work_start_timestamp  = strtotime("-1 month");
            return array();
        }
        $d1 = new DateTime(date("Y-m-d", $work_start_timestamp));
        $d2 = new DateTime(date("Y-m-d"));
        $diff = $d2->diff($d1);
        //$rule_number0  = intval($user->rule_number0);
        $shift_id = (int)$user->shift_number;
        
        if( $shift_id < 1){
            return [];
        }
        
        $workYears  = abs(intval($diff->y));
        $y  = $workYears;
        $startDate  =  date("Y-m-d",$work_start_timestamp);        
        $currentDate  =  date("Y-m-d");
        
        //standart calc
        $dateArr = $this->getAllDateListWeek($uid, $startDate, $currentDate);
        $dateArr['earned_minutes'] = $dateArrOnlyEarnMinutes['earned_minutes'];
        //$dateArr['earned_minutes'] = 'dd';
        
        /*echo '<pre>dateArr:';
        print_r($dateArr);
        echo '</pre>';*/
        
        return $dateArr;
    }
    
    public function toSec($str) {
        $str = $str . "";

        /* echo '<pre>$str';
          print_r($str);
          echo '</pre>'; */

        $total = "0.0";
        //$t = preg_split('[\.,\:;]', $str);   //old
        $t = explode('.', $str);   //old
        if (count($t) === 1) {
            /* echo 'dd';
              echo '<pre>$t';
              print_r($t);
              echo '</pre>'; */

            $sum = array('h' => 0, 'm' => 0);

            /* echo '<pre>$sum';
              print_r($sum);
              echo '</pre>'; */

            $h = intval($t[0]);
            $m = 0;

            $sum['h'] = $sum['h'] + $h;
            $sum['m'] = $sum['m'] + $m;

            $hour = $sum['h'];
            $min = $sum['m'];
            
            $total = $min * 60;
            $total += $hour * 60 * 60;
        }

        if (count($t) === 2) {
            /* echo '<pre>$t';
              print_r($t);
              echo '</pre>'; */

            $sum = array('h' => 0, 'm' => 0);

            /* echo '<pre>$sum';
              print_r($sum);
              echo '</pre>'; */

            $h = intval($t[0]);
            $m = intval($t[1]);

            $sum['h'] = $sum['h'] + $h;
            $sum['m'] = $sum['m'] + $m;

            $hour = $sum['h'];
            $min = $sum['m'];
            $total = $min * 60;
            $total += $hour * 60 * 60;
        }
        
        return $total;
    }

    public function toHour($sec) {
        //echo 'toHour $sec' . $sec . PHP_EOL;
        
        $sec  =  abs(intval($sec));
        $total  = intval($sec);
        $hours = floor($total / 3600);
        $minutes = floor(($total / 60) % 60);
        $seconds = $total % 60;
        if($minutes < 10)
            $minutes =  "0".$minutes;
        if($seconds < 10)
            $seconds =  "0".$seconds;
        $total =    "{$hours}.{$minutes}";
        return $total;
    }
    
    public function sumTotals($totals) {        
        
        $sec    =   $this->toSec($totals['total_by_law_holidays_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['total_by_law_holidays_hours']  =   $hour;
        
        $sec    =   $this->toSec($totals['taken_by_law_holidays_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['taken_by_law_holidays_hours']  =   $hour;
        
        ////////////////////////////////////////////////////////////////////////sick child
        $sec    =   $this->toSec($totals['total_by_law_sick_child_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['total_by_law_sick_child_hours']  =   $hour;
        
        $sec    =   $this->toSec($totals['taken_by_law_sick_child_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['taken_by_law_sick_child_hours']  =   $hour;
        ////////////////////////////////////////////////////////////////////////end sick child
        
        if($this->enable_earn_minutes=='1'){
            ////////////////////////////////////////////////////////////////////////earn minutes
            $sec    =   $this->toSec($totals['total_by_law_earn_min_hours']);
            $hour   =   $this->toHour($sec);        
            if($sec < 0) {
                $hour  =  "-".$hour;
            }
            $totals['total_by_law_earn_min_hours']  =   $hour;
        
            $sec    =   $this->toSec($totals['taken_by_law_earn_min_hours']);
            $hour   =   $this->toHour($sec);        
            if($sec < 0) {
                $hour  =  "-".$hour;
            }
            $totals['taken_by_law_earn_min_hours']  =   $hour;
            ////////////////////////////////////////////////////////////////////////end earn minutes
        }
        
        $sec    =   $this->toSec($totals['total_by_law_sick_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['total_by_law_sick_hours']      =   $hour;
        
        
        
        $sec    =   $this->toSec($totals['taken_by_law_sick_hours']);
        /*echo '<pre>$sec';
        print_r($sec);
        echo '</pre>';*/
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['taken_by_law_sick_hours']      =   $hour;
        
        
        
        
        
        
        //
        $sec    =   $this->toSec($totals['total_by_law_holidays_hours']) - $this->toSec($totals['taken_by_law_holidays_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['sum_holidays_hours']           =   $hour;
        
        $sec    =   $this->toSec($totals['total_by_law_sick_hours']) - $this->toSec($totals['taken_by_law_sick_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['sum_sick_hours']               =   $hour;
        /////////////////////////////////////////////////////////////////sick child
        $sec    =   $this->toSec($totals['total_by_law_sick_child_hours']) - $this->toSec($totals['taken_by_law_sick_child_hours']);
        $hour   =   $this->toHour($sec);        
        if($sec < 0) {
            $hour  =  "-".$hour;
        }
        $totals['sum_sick_child_hours']           =   $hour;
        ////////////////////////////////////////////////////////////////sick child
        
        if($this->enable_earn_minutes=='1'){
            /////////////////////////////////////////////////////////////////earn minutes
            $sec    =   $this->toSec($totals['total_by_law_earn_min_hours']) - $this->toSec($totals['taken_by_law_earn_min_hours']);
            $hour   =   $this->toHour($sec);        
            if($sec < 0) {
                $hour  =  "-".$hour;
            }
            $totals['sum_earn_min_hours']           =   $hour;
            ////////////////////////////////////////////////////////////////end earn minutes
        }
        /*echo '<pre>$totals';
        print_r($totals);
        echo '</pre>';*/
        return $totals;
    }
    
   
    public function getTotals($uid, $calculated_totals = null) {

        $config = JFactory::getConfig();
        $user = JFactory::getUser($uid);
        
        //for shifts(1 week) rules
        if($this->enable_subrules_part_in_1_week_rule == '1' && $user->rule_number0 == 0 && $user->shift_number > 0 ){
           
            $enable_new_rule = intval($config->get('enable_new_rule'));
            
            if (!$enable_new_rule){
                return [];
            }

            $totals = [];
            if ($this->enable_earn_minutes == '1') {
               
                $totals = $this->getUserWorkAgeTotalsWithEarnMinutesWeek($uid, $calculated_totals);//gg1
                
            } else {
                $totals = $this->getUserWorkAgeTotalsWeek($uid);
            }

            return $this->sumTotals($totals);
        } else{//for union rules
            $enable_new_rule = intval($config->get('enable_new_rule'));
            if (!$enable_new_rule)
                return [];

            $totals = [];
      

            if ($this->enable_earn_minutes == '1') {
                $totals = $this->getUserWorkAgeTotalsWithEarnMinutes($uid, $calculated_totals);//gg
            } else {
                $totals = $this->getUserWorkAgeTotals($uid);
            }

            return $this->sumTotals($totals);
        }
    }

    public static function convertToTime($str) {
        $str    =   $str."";
        $total  =   "0.0";        
        $t = explode('[\.,\:;]', $str);      
        $sum =  array('h'=>0,'m'=>0);
        $h  =   intval($t[0]);
        $m  =   intval($t[1]);
        $sum['h']   =   $sum['h'] + $h;
        $sum['m']   =   $sum['m'] + $m;
        
        $hour  =  $sum['h'];
        $min  =  $sum['m'];
        $total  =  $h + $m;
        
        $total  = $min * 60;
        $total  += $hour * 60 * 60;
        
        
        $hours = floor($total / 3600);
        $minutes = floor(($total / 60) % 60);
        $seconds = $total % 60;
        
        if($minutes < 10)
            $minutes =  "0".$minutes;
        if($seconds < 10)
            $seconds =  "0".$seconds;
        $total =    "{$hours}.{$minutes}";
        return $total;
    }
    
    public static function convertToTime1($str) {
        $str    =   $str."";
        $total  =   "0.0";        
        $t = explode('[\.,\:;]', $str);      
        $sum =  array('h'=>0,'m'=>0);
        $h  =   intval($t[0]);
        $m  =   intval($t[1]);
        $sum['h']   =   $sum['h'] + $h;
        $sum['m']   =   $sum['m'] + $m;
        
        $hour  =  $sum['h'];
        $min  =  $sum['m'];
        $total  =  $h + $m;
        
        $total  = $min * 60;
        $total  += $hour * 60 * 60;
        
        
        $hours = $total / 3600;
        $minutes = ($total / 60) % 60;
        $seconds = $total % 60;
        
        if($minutes < 10)
            $minutes =  "0".$minutes;
        if($seconds < 10)
            $seconds =  "0".$seconds;
        $total =    "{$hours}.{$minutes}";
        return $total;
    }
    
    public function rawCalculateNewBreaks(int $uid, $calculated_totals = null) {
        if (!empty($calculated_totals)) {
            $user = JFactory::getUser($uid);
            $union_rule_id = (int) $user->rule_number0;
            $one_week_rule_id = (int) $user->shift_number;
            
            if($union_rule_id > 0){
                $earn_minutes_object = $this->getEarnMinutesRow($union_rule_id);
            } elseif($one_week_rule_id > 0){
                $earn_minutes_object = $this->getEarnMinutesRowWeek($one_week_rule_id);
            }

            $normalized_totals = $this->normalizeTotals($calculated_totals); //group totals by date
            //$min_working_hours_for_add_break_test = 2.1;//test load
            $min_working_hours_for_add_break_raw = $earn_minutes_object->new_time_for_break; //need load from union rule block test

            if(empty($min_working_hours_for_add_break_raw)){
                    $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
                    $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
                    //$yearTotals['earned_minutes'] = '0:00'; //earn minutes
                    $min_working_hours_for_add_break_raw = '00:00';
                    //return $yearTotals;
            }

            $min_working_hours_for_add_break_arr = explode(':', $min_working_hours_for_add_break_raw);
            $working_hours_for_add_break_h = $min_working_hours_for_add_break_arr[0];
            $working_hours_for_add_break_m = $min_working_hours_for_add_break_arr[1];
            $min_working_hours_for_add_break = (float) ($working_hours_for_add_break_h . '.' . $working_hours_for_add_break_m);
            
            //$break_minutes = $earn_minutes_object->minutes; //loading from union rule
            $break_minutes_converted = self::convertBreaksToMinutes($earn_minutes_object->minutes);
            $final_breaks = 0;

            foreach ($normalized_totals as $k => $sessions) {

                $date = $k;
                $count = count($sessions);

                $total_sum = 0; //sum total for a date
                if ($count > 1) {

                    $total_sum_for_days = 0; //sum all totals for a date

                    foreach ($sessions as $session) {//if one date have more them 1 session
                        $total_string = $session['total'];
                        $total_arr = explode(':', $total_string);
                        $total_h = $total_arr[0];
                        $total_m = $total_arr[1];
                        $total_to_float = (float) ($total_h . '.' . $total_m);
                        $total_sum_for_days += $total_to_float;
                    }


                    if ($total_sum_for_days >= $min_working_hours_for_add_break) {
                        $final_breaks += $break_minutes_converted;
                    }
                } elseif ($count == 1) {//if one date have 1 session
                    $total_string = $sessions[0]['total'];
                    $total_arr = explode(':', $total_string);
                    $total_h = $total_arr[0];
                    $total_m = $total_arr[1];
                    $total_to_float = (float) ($total_h . '.' . $total_m);
                    $total_sum = $total_to_float;

                    if ($total_sum >= $min_working_hours_for_add_break) {
                        $final_breaks += $break_minutes_converted;
                    }
                }
            }
        }

        /* echo '<pre>$final_breaks:';
          print_r($final_breaks);
          echo '</pre>'; */

        $vars = $this->getValuesByUserCompanyAge($uid);
        $formatted_final_breaks = $this->convertFloatToStr((float) $final_breaks);

        if (empty($vars))
            return [];

        $yearTotals = [];

        $yearTotals['total_by_law_earn_min_days'] = 0; //earn minutes
        $yearTotals['total_by_law_earn_min_hours'] = 0; //earn minutes
        $yearTotals['taken_by_law_earn_min_days'] = 0; //earn minutes
        $yearTotals['taken_by_law_earn_min_hours'] = 0; //earn minutes
        $yearTotals['earned_minutes'] = $formatted_final_breaks; //earn minutes


        return $yearTotals;
    }
}
